      SUBROUTINE MAKEATTENTABLE1(kindradar)
C     GENERATE TABLE FOR TWO-WAY INTERVENING ATTENUATION FOR .25 DBZ 
C     INCREMENTS FOR USE BY INTERVENATTEN SUBROUTINE
C     KINDRADAR - FLAG FOR LOWER FUSELAGE(1) OR  TAIL(2)RADAR
C     ATTENTABLE - ATTENUATION TABLE FOR DBZ LEVELS 0 TO 64 IN QUARTER DBZ
C     ATTENCALIB1LF - ATTENUATION CALIBRATION COEFF-1 FOR LOWER FUSELAGE RADAR
C     ATTENCALIB2LF - ATTENUATION CALIBRATION COEFF-2 FOR LOWER FUSELAGE RADAR
C     ATTENCALIB1TA - ATTENUATION CALIBRATION COEFF-1 FOR TAIL RADAR
C     ATTENCALIB2LF - ATTENUATION CALIBRATION COEFF-2 FOR TAIL RADAR
C     ATTENCALIB1 - ATTENUATION CALIBRATION COEFF-1 FOR RADAR USED
C     ATTENCALIB2 - ATTENUATION CALIBRATION COEFF-2 FOR RADAR USED
C     CALIBLOG - TEMPORARY VARIABLE:  ATTENCALIB2 / (NATURAL LOG OF 10.0) / 10.0
C     DBZ - TEMPORARY VARIABLE:  HOLDS QUARTER DBZ VALUES

      PARAMETER       (attencalib1lf = 0.000019, attencalib2lf = 0.85,
     +                attencalib1ta = 0.0000533, attencalib2ta = 0.889)
      COMMON /INTATT/ attentable(256)


C     GET PROPER CALIBRATION CONSTANTS FOR TYPE OF RADAR(LOWER FUSELAGE VS TAIL)
      IF (kindradar.EQ.1) THEN
        attencalib1 = attencalib1lf
        attencalib2 = attencalib2lf
      ELSE
        attencalib1 = attencalib1ta
        attencalib2 = attencalib2ta
      ENDIF

C     0.23025851 = (LN 10.0) / 10.0
      caliblog = attencalib2 * 0.23025851 

      DO index = 1, 256
        dbz = FLOAT(index) * 0.25
        attentable(index) = attencalib1 * EXP(caliblog * dbz) * 2.0 
      ENDDO 

      RETURN  
      END 
