      subroutine fltlvl_map_sub(clat, clon, width, height, npts,
     +	time, wd, ws, rlat, rlon, ip_ctr, ip_max_1,
     +	ip_max_2,
     +	ip_in, ip_out, wc_ctr_lat, wc_ctr_lon,
     +	ps_file) 
C plot flight-level data on lambert confromal maps
C most map routines are in lamcon_subs.f
C track subs in biglib
C plotting uses my version of hrd calcomp-plotter subs
	integer npts
	real time(npts), wd(npts), ws(npts), rlat(npts), rlon(npts)
	character*(*) ps_file
      parameter(deg2rad=0.0174533)
      character ans*1 ,lbl*2
      integer plotter 
      integer hemis ! +1 for Northern Hemisphere, -1 for Southern 
      real w(4) ! w is clipping window in inches
      logical lamcon, las_comp, done, arc_visible, vis, ps_out
      character*80 buoyfile
      character*64 ram_file,infil,geofil,trackfile,label*40 
	character*64 center_file ! holds storm positions
	character*80 buoys_file ! holds buoy locations
	character*64 track_file ! storm track (*.trk)
C 
	logical all_sites, installed_only, plot_winds
	integer instl(100), flag(100)
	character*4 stnid(100), typ*3, place*36
	character*5 buoy
	character data_id*4, sonde_id*9
	character*1 marker
C
	character cstr*36
	integer*2 istr(18)
C
	logical storm_rel, constant_advection
C
	integer thin_pen, medium_pen, thick_pen
	integer black, red,orange,yellow,green,blue,darkturq,violet,white
	data black, red,orange,yellow,green,blue,darkturq,violet,white/0,
     +		-1,-2,-3,-4,-5,-6,-7,-8/
C  plot on other dev does not have to be compatible with laser print:
	las_comp = .false. 
	thick_pen = 4
	thin_pen  = 1
	medium_pen = 2
C
	bad_wind = 999.0
C
	storm_rel = .false.
	constant_advection = .false.
C
	rmw_lat_1 = rlat(ip_max_1)
	rmw_lon_1 = rlon(ip_max_1)
	rmw_lat_2 = rlat(ip_max_2)
	rmw_lon_2 = rlon(ip_max_2)
	rad_lat_in = rlat(ip_in)
	rad_lon_in = rlon(ip_in)
	rad_lat_out = rlat(ip_out)
	rad_lon_out = rlon(ip_out)
C
C get plotter
	if( ps_file(1:4) .ne. 'none' ) then
		ps_out = .true.
		plotter = 1
		ipst_file = 25
	else
		plotter = 1
		ipst_file = -1
	end if
C
C	WRITE(6,*)' enter grid inc (-1 for none) '
C	READ(5,*)grid_inc
C	grid_inc = -1 ! no grid marks
	grid_inc = 1
      lamcon=.true. 
C now initialize plotter
	csiz = 0.15
	 wid = 0.5 * csiz
	tsiz = csiz * 0.5
	xl = 7.0 * csiz
	yb = 7.0 * csiz
	wid_in_max = 6.0
	ht_in_max = 6.0
	ires = 400
	iwid= (wid_in_max + 2.0 * xl ) * 10 
	iht = (ht_in_max + 2.0 * yb) * 10 
C ibkgd_type = 1, white bkgd, black fgd
C ibkgd_type = 2, black bkgd, white fgd
	ibkgd_type = 2
 	call initl(plotter,ires,iwid,iht,ibkgd_type,im,im) 
	if( ipst_file .gt. 0) then	! postscript output also
		ipst_fnt_size = 10
		if( wid_in_max .gt. 8.5) then
			ipage_orien = 1 ! flip to landscape
		else
			ipage_orien = 0 ! portrait
		end if
		call init_ps_plot(ires,iwid,iht,ipst_file,
     +			ipst_fnt_size, ipage_orien, ps_file)
	endif 
C
	asp_plot = wid_in_max / ht_in_max
	deglat = 111.13209-0.56605*cosd(2.*clat)
	deglon = 111.41513*cosd(clat)-0.09455*cosd(3.*clat)
Cout	WRITE(6,*)' enter width and height in km'
Cout	READ(5,*)width, height
	aspect = width / height
	if( aspect .ge. 1.0 ) then ! wider than high
		if( asp_plot .ge. aspect) then
			radkm = height * 0.5
			radinch = 0.5 * ht_in_max
		else
			radkm = height * 0.5
			radinch = 0.5 * ht_in_max / asp_plot
		end if
	else ! higher than wide
		if( asp_plot .le. aspect) then
			radkm = height * 0.5
			radinch = 0.5 * ht_in_max
		else
			radkm = height * 0.5
			radinch = 0.5 * ht_in_max / asp_plot
		end if
	end if
Cout	WRITE(6,*)' clat, clon: ',clat,clon
Cout	WRITE(6,*)' radkm, radinch ',radkm, radinch
C
      call plot(0.,0.,-3) 
C Window:
	w(1) = xl
	w(2) = yb
	w(3) = xl + wid_in_max
	w(4) = yb + ht_in_max
	csiz = 0.1
	if(ps_out)then
		call ps_comment(ipst_file,' Labels and scale begin')
	end if
	call newpn(white)
C distance scale and labels out side bounding box
C draw these first, so it is easy to reset clip path in 
C PS code without losing these.
	x = w(1) + 4.0 * csiz
	y = w(2) - 4.0 * csiz
	nticks = width * 0.25 * 0.1 ! # of 10 km ticks
	call dis_scale(w, radinch, radkm, x, y, nticks, csiz) 
C write out info for legs
	x = w(1) + 0.5 * ( w(3) -w(1) )
	y = w(2) - 2.5 * csiz
	call ctme1(time(ip_in),ih,im,is)
	write(cstr,"('Inbound start:',3i2.2)")ih,im,is
	read(cstr(1:20),'(10a2)')(istr(ii), ii = 1, 10)
	call symbl(x, y, csiz, istr, 0.0, 20)
	y = y - 1.5 * csiz
	call ctme1(time(ip_ctr),ih,im,is)
	write(cstr,"('Center: ',3i2.2,1x,f5.2,1x,f7.2)")ih,im,is,
     +		rlat(ip_ctr), rlon(ip_ctr)
	read(cstr(1:28),'(14a2)')(istr(ii), ii = 1, 14)
	call symbl(x, y, csiz, istr, 0.0, 28)
	y = y - 1.5 * csiz
	call ctme1(time(ip_out),ih,im,is)
	write(cstr,"('Outbound end: ',3i2.2)")ih,im,is
	read(cstr(1:20),'(10a2)')(istr(ii), ii = 1, 10)
	call symbl(x, y, csiz, istr, 0.0, 20)
C
	write(cstr(1:30),"('Center Lat: ',f5.2,' Lon: ',f7.2)")clat,
     +		clon
	read(cstr(1:30),'(15a2)')(istr(ii), ii = 1, 15)
	x = w(1)
	y = w(4) + 3.0 * csiz
	call symbl(x, y, csiz, istr, 0.0, 30)
	if(ps_out)then
		call ps_comment(ipst_file,' Labels and dcale end')
	end if

C bounding box:
C In ps code these can be edited to have a more complicated clip
C window, to make room for captions, etc.
	call newpn(medium_pen)
	call plot(w(1), w(2), 3)
	call plot(w(3), w(2), 2)
	call plot(w(3), w(4), 2)
	call plot(w(1), w(4), 2)
	call plot(w(1), w(2), 2)
C plot the map
	call newpn(thin_pen)
	WRITE(6,*)' drawing map '
Cout	WRITE(6,424)
424	format(1x,'Pick geography: ',/,
     +		5x,'1 - Continental outline and major rivers only',/,
     +		5x,'2 - State outlines only',/,
     +		5x,'3 - You specify the geography file',/,
     +		5x,'0 - no geography')
Cout	READ(5,*)igeo_type
	igeo_type = 1
	if( igeo_type .eq. 0 ) then
		geofil = 'none'
	else if( igeo_type .eq. 1 ) then
		geofil = '/users/HRD/geog/namer.dat'
	else if( igeo_type .eq. 2 ) then
		geofil = '/users/HRD/geog/usofa.dat'
	else if( igeo_type .eq. 3 ) then
		WRITE(6,*)' Enter geography file name:'
		READ(5,'(a)')geofil
	end if
      label = 'none' ! so we don't get the caption
	if(ps_out)then
		call ps_comment(ipst_file,' Map begin')
	end if
      call lamcon_map_sub(xl, yb, clat,clon,radkm,radinch,lamcon, 
     + geofil,cone,hemis,xscale,yscale,xcen,ycen,w,label, csiz) 
	if( igeo_type .eq. 3 ) then
	    ans = 'y'
	    do while( ans .eq. 'y')
		WRITE(6,*)' Another geography file?'
		READ(5,'(a)')ans
		if( (ans.eq.'y') .or. (ans.eq.'Y') ) then
		  WRITE(6,*)' enter geography file name:'
		  READ(5,'(a)')geofil
		  call lamcon_map_sub(xl, yb, clat,clon,radkm,
     +			radinch,lamcon, geofil,cone,hemis,
     + 			xscale,yscale,xcen,ycen,w,label, csiz) 

		end if
	    end do
	end if
	if(ps_out)then
		call ps_comment(ipst_file,' Map end')
	end if
C get lat lon of box corners:
	u1 = (w(1) - xl - xcen) / xscale
	v1 = (w(2) - yb - ycen) / yscale
	u2 = (w(3) - xl - xcen) / xscale
	v2 = (w(4) - yb - ycen) / yscale
        write(6,*)'u1,v1,u2,v2 = ',u1,v1,u2,v2
	call inv_lam_proj(u1, v1, ylat_ll, xlon_ll, cone, clon, hemis)
	write(6,*)' Lat, lon lower left corner: ',ylat_ll, xlon_ll
	call inv_lam_proj(u2, v1, ylat_lr, xlon_lr, cone, clon, hemis)
Cout	write(6,*)' Lat, lon lower right corner: ',ylat_lr, xlon_lr
	call inv_lam_proj(u2, v2, ylat_ur, xlon_ur, cone, clon, hemis)
Cout	write(6,*)' Lat, lon upper right corner: ',ylat_ur, xlon_ur
	call inv_lam_proj(u1, v2, ylat_ul, xlon_ul, cone, clon, hemis)
Cout	write(6,*)' Lat, lon upper left corner: ',ylat_ul, xlon_ul
	xlatmn = min(ylat_ll, ylat_lr, ylat_ur, ylat_ul)
	xlatmx = max(ylat_ll, ylat_lr, ylat_ur, ylat_ul)
	xlonmn = min(xlon_ll, xlon_lr, xlon_ur, xlon_ul)
	xlonmx = max(xlon_ll, xlon_lr, xlon_ur, xlon_ul)
C plot grid
	call newpn(thin_pen)
	WRITE(6,*)' doing grid'
	if(ps_out)then
		call ps_comment(ipst_file,' Grid begin')
	end if
	call short_grid_lines(xl, yb, grid_inc,
     +		xlatmn-0.5,xlatmx+0.5,xlonmn-0.5,xlonmx+0.5,
     +		xcen,ycen,xscale,yscale,cone,clon,hemis,w,
     +		medium_pen, thin_pen, csiz)
	if(ps_out)then
		call ps_comment(ipst_file,' Grid end')
	end if
	call plot_point(xl, yb, clat,clon,wid,cone,clon,hemis, 
     +        xscale,yscale,xcen,ycen,w)
C buoy locations:
        open(98,file='buoys_file')
        read(98,'(a80)')buoys_file
        close(98)
c	buoys_file = '/users/jfgmiami/buoys.dat'
Cout	WRITE(6,*)' Want buoy/C-MAN locations plotted ?'
Cout	READ(5,'(a1)')ans
	ans = 'y'
	if( (ans .eq. 'y') .or. (ans .eq. 'Y') ) then
	  if(ps_out)then
		call ps_comment(ipst_file,'Buoys begin')
	  end if
C changed to lighter color
	  call newpn(orange)
	  open(12, file = buoys_file,
     +		form = 'formatted', status = 'old')
	  read(12,*)
	  read(12,*)
	  do i = 1, 100
		read(12, 987, end = 989, err = 989)buoy, slat,slon
987		format(a5,1x,f5.2,1x,f7.2)
		call lbl_buoy(buoy, csiz,xl, yb, 
     +		  slat, slon, wid, cone, clon, hemis, 
     +		  xscale, yscale, xcen, ycen, w)
	  end do
989	  close(12)
	  if(ps_out)then
		call ps_comment(ipst_file,' Buoys end')
	  end if
	end if
C 
C Plot flight track
	  wid = 0.25 * csiz ! for 10 minute marks
	  if(ps_out)then
		call ps_comment(ipst_file,'Flight track start')
	  end if
C changed color to white
	  call newpn(white)
Cout	  WRITE(6,*)' Enter label interval in minutes: '
Cout	  READ(5,*)min_int
	min_int = 10
		storm_rel = .false.
		constant_advection = .false.
C plot flight track:
	shaft = 0.75
	call lam_proj(rlat(1),rlon(1),u,v,cone,clon,hemis)
	xp = xl + u * xscale + xcen 
	yp = yb + v * yscale + ycen 
	  do i = 2, npts
	  	call lam_proj(rlat(i),rlon(i),u,v,cone,clon,hemis)
		x = xl + u * xscale + xcen 
		y = yb + v * yscale + ycen 
		call wclip(xp,yp,x,y,w,vis,ic_code)
		if( vis ) then
			call plot(xp, yp, 3)
			call plot(x, y, 2)
		end if
		xp = x
		yp = y
C added time labels every 10 minutes:
		call ctme1(time(i), ihr, imin, isec)
		nrem = imin - (imin/min_int)*min_int
		if( (isec .eq. 0) .and. (nrem .eq. 0) .and. vis) then
			call plot(x+shaft, y + shaft, 2)
			write(data_id,'(i2.2,i2.2)')ihr, imin
			read(data_id,'(2a2)')istr(1), istr(2)
			call symbl(x+shaft,y+shaft,csiz,istr,0.0,4)
Cout			call plot(x,y,3)
C and plot a symbol at that mark:
			call plot(x-wid,y,3)
			call plot(x,y+wid,2)
			call plot(x+wid,y,2)
			call plot(x,y-wid,2)
			call plot(x-wid,y,2)
	  	end if
	  end do
	  if(ps_out)then
		call ps_comment(ipst_file,'Flight track end')
	  end if
		if(ps_out)then
		  call ps_comment(ipst_file,'Wind barbs start')
		end if
Cout		WRITE(6,*)' enter interval in seconds: '
Cout		READ(5,*)dt
		idt = 60
		shaft = 0.5
Cout			shaft = .75 ! for Paul Harasti
		do i = 1, npts, idt
		  call lam_proj(rlat(i),rlon(i),u,v,cone,clon,hemis)
			x = xl + u * xscale + xcen 
			y = yb + v * yscale + ycen 
		  call wdir2uv(wd(i), ws(i), ucomp,vcomp,-999.9,ier)
C added to test if shaft lies completely in window or not
			ang = atan2(ucomp, vcomp)
			xp = x + shaft* cos(ang)
			yp = y + shaft * sin(ang)
	  		call wclip(xp,yp,x,y,w,vis,ic_code)
	  		if(ic_code .eq. 0 )then ! fits inside
			  call plot_barb_uv(x, y, ucomp, vcomp, shaft)
		     	  call plot(x, y, 3)
			end if
		end do
		if(ps_out)then
		  call ps_comment(ipst_file,'Wind barbs end')
		end if
 
C Finally, plot individual points
	  if(ps_out)then
		call ps_comment(ipst_file,'Individual points start')
	  end if
C changed to color white
	  call newpn(white)
	  call newpn(thick_line)
	  buoy = 'RMW 1'
		call lbl_buoy(buoy, csiz,xl, yb, 
     +		  rmw_lat_1, rmw_lon_1, wid, cone, clon, hemis, 
     +		  xscale, yscale, xcen, ycen, w)
	  buoy = 'RMW 2'
		call lbl_buoy(buoy, csiz,xl, yb, 
     +		  rmw_lat_2, rmw_lon_2, wid, cone, clon, hemis, 
     +		  xscale, yscale, xcen, ycen, w)
C draw lines for radial legs
C changed to lighter color
	call newpn(yellow)
	call newpn(thick_line)
	call lam_proj(rad_lat_in, rad_lon_in,u,v,cone,clon,hemis)
	xp = xl + u * xscale + xcen 
	yp = yb + v * yscale + ycen
	call lam_proj(clat, clon,u,v,cone,clon,hemis)
	x = xl + u * xscale + xcen 
	y = yb + v * yscale + ycen
	call wclip(xp,yp,x,y,w,vis,ic_code)
	if(vis )then !
		  call plot(xp, yp, 3)
	     	  call plot(x, y, 2)
	end if
	call lam_proj(rad_lat_out, rad_lon_out,u,v,cone,clon,hemis)
	xp = xl + u * xscale + xcen 
	yp = yb + v * yscale + ycen
	call lam_proj(clat, clon,u,v,cone,clon,hemis)
	x = xl + u * xscale + xcen 
	y = yb + v * yscale + ycen
	call wclip(xp,yp,x,y,w,vis,ic_code)
	if(vis )then ! fits inside
		  call plot(xp, yp, 3)
	     	  call plot(x, y, 2)
	end if
C Plot WC center
	if(wc_ctr_lat .gt. -90.0)then
		if(ps_out)then
		  call ps_comment(ipst_file,'Willoughby-Chelmow Center')
		end if
		call newpn(white)
		call lam_proj(wc_ctr_lat, wc_ctr_lon, u, v, 
     +			cone, clon,hemis)
		xp = xl + u * xscale + xcen 
		yp = yb + v * yscale + ycen
		  call plot(xp-csiz, yp, 3)
	     	  call plot(xp+csiz, yp, 2)
		  call plot(xp, yp-csiz, 3)
	     	  call plot(xp, yp+csiz, 2)
		  call plot(xp-csiz, yp-csiz, 3)
	     	  call plot(xp+csiz, yp+csiz, 2)
		  call plot(xp-csiz, yp+csiz, 3)
	     	  call plot(xp+csiz, yp-csiz, 2)
	end if
C close plot, free plotter
      call plot(0.,0.,998) ! close out plot 
	write(6,*)' pausing. hit return to quit.'
	read(5,*)
	return
	end
C 
C ****************************
      subroutine plot_point(xl, yb, ylat,xlon,wid,cone,cenlon,hemis, 
     +        xscale,yscale,xcen,ycen,w)
      logical solid, vis
	integer hemis ! +1 for northern hemis
      real cone,cenlon,xscale,yscale,xcen,ycen,w(4)
C 
      call lam_proj(ylat,xlon,u,v,cone,cenlon,hemis)
      x = xl + u * xscale + xcen 
      y = yb + v * yscale + ycen 
	if(inside(x,y,w).eq.0)then
		call plot(x-wid,y+wid,3) 
		call plot(x-wid,y-wid,2) 
                call plot(x+wid,y-wid,2) 
                call plot(x+wid,y+wid,2) 
                call plot(x-wid,y+wid,2) 
 	end if
      return
      end 
C -----------------------------
      subroutine lbl_point(stnid, csiz, xl, yb, ylat,xlon,wid,
     +		cone,cenlon,hemis, xscale,yscale,xcen,ycen,w)
      logical solid, vis
	integer hemis ! +1 for northern hemis
      real cone,cenlon,xscale,yscale,xcen,ycen,w(4)
	character*4 stnid
	integer*2 istr(2)
C 
      call lam_proj(ylat,xlon,u,v,cone,cenlon,hemis)
      x = xl + u * xscale + xcen 
      y = yb + v * yscale + ycen 
	xch = x - 2 * csiz
	ych = y + 1.5 * wid
	del = 0.25 * csiz
	if(inside(x,y,w).eq.0)then
Cout		call blank_box(xch-del, ych - del, 
Cout     +			xch + 4.0 * csiz + del, ych + csiz + del)
		read(stnid,'(2a2)')istr(1), istr(2)
		call symbl(xch, ych, csiz, istr, 0.0, 4)
		call plot(x, y+wid,3) 
                call plot(x+wid,y,2) 
		call plot(x,y-wid,2) 
                call plot(x-wid,y,2) 
		call plot(x, y+wid,2)
 	end if
      return
      end 
C --------------------------------------            
      subroutine cirk(radius, xl, yb, ylat,xlon,wid,cone,cenlon,
     +		hemis, xscale,yscale,xcen,ycen,w, vis)
      logical down, vis
C vis returned true if some part of circle drawn in window,
C false if circle completely outside.
	integer hemis ! +1 for northern hemis
      real cone,cenlon,xscale,yscale,xcen,ycen,w(4)
C 
      call lam_proj(ylat,xlon,u,v,cone,cenlon,hemis)
      x = xl + u * xscale + xcen 
      y = yb + v * yscale + ycen 
      call plot10_circle(x, y, radius, w, vis)
      return
      end 
C --------------
C --i'm so lazy.....---------------------------
      subroutine lbl_buoy(stnid, csiz, xl, yb, ylat,xlon,wid,
     +		cone,cenlon,hemis, xscale,yscale,xcen,ycen,w)
      logical solid, vis
	integer hemis ! +1 for northern hemis
      real cone,cenlon,xscale,yscale,xcen,ycen,w(4)
	character*5 stnid
	integer*2 istr(6)
C 
      call lam_proj(ylat,xlon,u,v,cone,cenlon,hemis)
      x = xl + u * xscale + xcen 
      y = yb + v * yscale + ycen 
	xch = x - 2 * csiz
	ych = y + 1.5 * wid
	del = 0.25 * csiz
	if(inside(x,y,w).eq.0)then
Cout		call blank_box(xch-del, ych - del, 
Cout     +			xch + 5.0 * csiz + del, ych + csiz + del)
		read(stnid,'(2a2,a1)')istr(1), istr(2), istr(3)
		call symbl(xch, ych, csiz, istr, 0.0, 5)
		call plot(x, y+wid,3) 
		call plot(x+wid,y,2) 
                call plot(x,y-wid,2) 
                call plot(x-wid,y,2) 
		call plot(x, y+wid,2) 
 	end if
      return
      end 

C --------------
      subroutine short_grid_it(xleft, ybottom, grid_inc,
     +		xlatmn,xlatmx,xlonmn,xlonmx,
     +        xcen,ycen,xscale,yscale,cone, 
     +        cenlon,hemis,w, ipen1, ipen2) 
      real w(4) ! clipping window 
      logical cool,visible
      integer hemis 
C  THIS subroutine plots lat and lon grid 
C  use lambert conformal conical proj.
C version that just makes + at whole degree intersections, instead of
C lotsa a little segments..
      if(grid_inc.le.0.0)then 
              return
      end if
      slatmn=anint(xlatmn-grid_inc) 
      slatmx=anint(xlatmx+grid_inc) 
      slonmn=anint(xlonmn-grid_inc) 
      slonmx=anint(xlonmx+grid_inc) 
	if( grid_inc .gt. 2.0 )then ! adjust starts so on 5 deg inc
		n = int( slatmx ) / 5
		slatmx = (n+1) * 5.0
		n = int( slonmx ) / 5
		slonmx = (n+1) * 5.0
	else if( grid_inc .gt. 1.0 )then ! adjust to start on even deg
		n = int( slatmx ) / 2
		slatmx = (n+1) * 2.0
		n = int( slonmx ) / 2
		slonmx = (n+1) * 2.0
	end if
C crosses at whole degrees
C	call newpn(ipen1)
	if (grid_inc .lt. 1.0) then
		nln_lon =anint(slonmx-slonmn)+1
		nln_lat = anint(slatmx-slatmn)+1
		deg_inc = 1.0
	else
		nln_lon = (slonmx-slonmn) / grid_inc + 1
		nln_lat = (slatmx-slatmn)/ grid_inc + 1
		deg_inc = 1.0
	end if
      start_lat = slatmx + deg_inc
      do i=1,nln_lat
       start_lat = start_lat - deg_inc
	start_lon = slonmx + deg_inc
	do j =1,nln_lon
       	   start_lon = start_lon - deg_inc
           call lam_proj(start_lat,start_lon - 0.1,
     +		u,v,cone,cenlon,hemis) 
           xb = xleft + u*xscale+xcen
           yb = ybottom + v*yscale+ycen
           call lam_proj(start_lat,start_lon + 0.1,
     +		u,v,cone,cenlon,hemis)
           xe = xleft + u*xscale+xcen
           ye = ybottom + v*yscale+ycen
           call wclip(xb,yb,xe,ye,w,visible,ic_code) 
           if(visible)then 
                call plot(xb,yb,3)
                call plot(xe,ye,2)
           endif 
           call lam_proj(start_lat - 0.1,start_lon,
     +		u,v,cone,cenlon,hemis) 
           xb = xleft + u*xscale+xcen
           yb = ybottom + v*yscale+ycen
           call lam_proj(start_lat + 0.1,start_lon,
     +		u,v,cone,cenlon,hemis)
           xe = xleft + u*xscale+xcen
           ye = ybottom + v*yscale+ycen
           call wclip(xb,yb,xe,ye,w,visible,ic_code) 
           if(visible)then 
                call plot(xb,yb,3)
                call plot(xe,ye,2)
           endif 
	end do
      end do
C crosses at incrments less than 1 degree:
C	call newpn(ipen2)
	tick = 0.025 ! degrees
	if (grid_inc .lt. 1.0) then ! <<<<<<<<<<<<<<<<<<<<<<<
		nln_lon = (slonmx-slonmn) / grid_inc + 1
		nln_lat = (slatmx-slatmn)/ grid_inc + 1
      start_lat = slatmx+grid_inc
      do i=1,nln_lat
       start_lat = start_lat -grid_inc
	start_lon = slonmx + grid_inc
	do j =1,nln_lon
       	   start_lon = start_lon -grid_inc
C           call lam_proj(start_lat,start_lon,
C    +		u,v,cone,cenlon,hemis) 
C          xb = xleft + u*xscale+xcen
C          yb = ybottom + v*yscale+ycen
C		xe = xb
C		ye = yb
C          call wclip(xb,yb,xe,ye,w,visible,ic_code) 
C          if(visible)then 
C               call plot(xb,yb,3)
C               call plot(xb,yb,2)
C          endif 
           call lam_proj(start_lat,start_lon - tick,
     +		u,v,cone,cenlon,hemis) 
           xb = xleft + u*xscale+xcen
           yb = ybottom + v*yscale+ycen
           call lam_proj(start_lat,start_lon + tick,
     +		u,v,cone,cenlon,hemis)
           xe = xleft + u*xscale+xcen
           ye = ybottom + v*yscale+ycen
           call wclip(xb,yb,xe,ye,w,visible,ic_code) 
           if(visible)then 
                call plot(xb,yb,3)
                call plot(xe,ye,2)
           endif 
           call lam_proj(start_lat - tick,start_lon,
     +		u,v,cone,cenlon,hemis) 
           xb = xleft + u*xscale+xcen
           yb = ybottom + v*yscale+ycen
           call lam_proj(start_lat + tick,start_lon,
     +		u,v,cone,cenlon,hemis)
           xe = xleft + u*xscale+xcen
           ye = ybottom + v*yscale+ycen
           call wclip(xb,yb,xe,ye,w,visible,ic_code) 
           if(visible)then 
                call plot(xb,yb,3)
                call plot(xe,ye,2)
           endif 
	end do
      end do
	end if ! <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	return
	end
C 
