	Subroutine WritePSMain(panel,id,nid)
C Modified on 17 June 1997, to use non-uniform contours...
C "        again 8 June 2005, changing F7.3 to f8.3, to allow ,= -100 km
	Implicit none

	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'
	
	Integer j,k,l,count,indx,temp_flag,cont_num,num_iter,label_num
	Integer initialize_flag,nid,id(nid),panel ! midval in /ContInt/
	Real cont_beg,cont_inc,count_arr(42)
	Character*1 scale_flag,font_flag,call_scale

	Data temp_flag,indx,label_num/0,1,0/

C WRITE OUT THE DATA
*************************
	IF (orient.EQ.'L'.AND.panel.EQ.1) THEN
	 Call WriteBorder
	 Call WriteOrient
	ENDIF
	label_num=0
	Call WriteBorder
	Call BoxPosTrans(panel)
C INITIALIZE ARRAY THAT CONTAINS THE DATA TO -999 (BAD VALUES) IN CASE THE
C USER ENTERS COORDINATES OUTSIDE OF THE CEDRIC COORDINATES
        initialize_flag=0
*        Call InitializeData(initialize_flag,id,nid)

C DRAW THE CONTOUR LINES
	IF (plot_type.GE.2) THEN
	 Call WriteGsave(indx)
	 Call WriteClip
	 Call OriginTrans
	 Call AddOffSet

C FIGURE OUT HOW MANY TIMES TO ITERATE THRU THE CONTOUR ROUTINE
	 IF (plot_type.EQ.2.OR.plot_type.EQ.3) THEN
	  num_iter=1
	  cont=cont1
	 ELSEIF (plot_type.EQ.4.OR.plot_type.EQ.5) THEN
	  num_iter=2
	 ENDIF

C CONTOUR PARAMETERS
	 DO 10 j=1,num_iter
	  IF (j.EQ.1.AND.num_iter.NE.1) THEN
	   fill_flag='Y' 
	   cont=cont1
	  ELSEIF (j.EQ.2.AND.num_iter.NE.1) THEN
	   fill_flag='N' 
	   cont=cont2
	  ENDIF
	  IF (fill_flag.EQ.'Y'.OR.fill_flag.EQ.'y') THEN
	   cont_beg=fill_beg
	   cont_inc=fill_inc
	   cont_num=ifix(fill_num)
	   scale_flag='Y'
	  ELSEIF (fill_flag.EQ.'N'.OR.fill_flag.EQ.'n') THEN
	   cont_beg=nofill_beg
	   cont_inc=nofill_inc
	   cont_num=ifix(nofill_num)
	  ENDIF
	  IF (fill_flag.EQ.'N'.OR.fill_flag.EQ.'n') THEN
	   Write (95,*) '8/Helvetica font'
	  ENDIF

	if( non_uniform .eq. 0) then
          zct=cont_beg
	  DO k=1,cont_num
*	     count=((num_colors/2)+1)+ifix((k-midval)*color_inc) 
	     count=k+1
	     Call Contour(count)
C need to subtract cont_offset because Contour adds cont_offset to zct,
C because AddOffset has added cont_offset to data...all because Contour
C does not contour to negative values properly.
	     zct=zct+cont_inc-cont_offset 
	  end do
C
C Note that in the non-uniform contour case I do no have to worry about
C cont_offset, because I reset zct each time.
	else
	  DO  k=1,cont_num
	   IF (fill_flag.EQ.'Y'.OR.fill_flag.EQ.'y') THEN
	     zct = fill_non_lev(k)
	   else
	     zct = nofill_non_lev(k)
	   end if
	   count=k+1
	   Call Contour(count)
	  end do
	end if

          initialize_flag=1
*          Call InitializeData(initialize_flag,id,nid)
	  Call OriginUnTrans
	  Call WriteGrestore(indx)

	  indx=indx+1
	  IF (plot_type.EQ.4.AND.j.EQ.1) THEN
             Call WriteGsave(indx)
	     Call OriginTrans
          ENDIF 
	  IF (plot_type.EQ.5.AND.j.EQ.1) THEN
	   Call WriteGsave(indx)
	   Call WriteClip
	   Call OriginTrans
	   Call Vector 
	   Call OriginUnTrans
	   Call WriteGrestore(indx)
	   indx=indx+1
	   Call WriteGsave(indx)
	   Call WriteClip
	   Call OriginTrans
	  ENDIF
10	 CONTINUE
	ENDIF

C Draw the vectors
	IF (plot_type.EQ.1.OR.plot_type.EQ.3) THEN
	 Call WriteGsave(indx)
	 Call WriteClip
	 Call OriginTrans
	 Call Vector 
	 Call OriginUnTrans
	 Call WriteGrestore(indx)
	 indx=indx+1
	ENDIF

C Draw the flight track
	IF ((fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z')
     $   .AND.scan_mode.EQ.'AIR') THEN
	  IF (catalog_name(1:4).NE.'none') THEN
	    Call WriteGsave(indx)
	    Call WriteClip
	    Call OriginTrans
	    Write (95,*)'drawplane'
	    Call OriginUnTrans
	    Call WriteGrestore(indx)
	    indx=indx+1
	  ENDIF
	ENDIF

C Draw the box
	Call DrawBox
C Label the numbers on the box
	font_flag='N'
	Call WriteFont(font_flag)
	Call WriteNum
	IF (title_flag(1:2).EQ.'ON') THEN
C Panel info
	font_flag='L'
	Call WriteFont(font_flag)
	Call WriteDist 
	Call WriteDate 
	Call WriteTime 
	Call WritePanelTitle
	Call WriteAxisLabel
	Call DrawScaleVector
C Bottom Label
	IF (panel.EQ.1) THEN
	 Call WriteFieldLabel(label_num)
	 Call WriteLatLong(label_num)
	 Call WriteHorOrigin(label_num)
	 Call WritePoints(label_num)
	 Call WriteScan(label_num)
	ENDIF
        IF (panel.EQ.num_plot) THEN
         font_flag='T'
         Call WriteFont(font_flag)
         Call WriteTitle
        ENDIF
	Call BoxPosUnTrans(panel)
C Draw the scale if needed 
	IF (scale_pos.EQ.'VER'.AND.panel.EQ.num_plot
     $   .AND.scale_flag.EQ.'Y') THEN
	 call_scale='Y'
	ELSEIF (scale_pos.EQ.'HOR'.AND.panel.EQ.1
     $   .AND.scale_flag.EQ.'Y') THEN
	 call_scale='Y'
	ELSEIF (template.EQ.1.AND.num_plot.GT.1) THEN
	 call_scale='Y'
	ENDIF
	 
	IF (call_scale.EQ.'Y') THEN
	 Call ScaleTrans
	 Call DrawScale
	 font_flag='L'
	 Call WriteFont(font_flag)
	 Call WriteScaleNum(count_arr)
	 Call WriteScaleTitle
	 Call ScaleUnTrans
	 call_scale='N'
	ENDIF

	ENDIF

C End of plot
	IF (template.EQ.1.OR.panel.EQ.num_plot) THEN
	 Call WriteShowPage
	ENDIF

	Return
	End
**************************************************
	Subroutine AddOffSet

	Implicit none

	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer i,j,k,num_iter ! cont declared in common block /Field/

	IF (plot_type.EQ.4.OR.plot_type.EQ.5) THEN
	 num_iter=2
	ELSE
	 num_iter=1
	ENDIF

	DO k=1,num_iter
	 IF (k.EQ.1) cont=cont1
	 IF (k.EQ.2) cont=cont2
	 IF (fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') THEN
*          Do 10 i=1,horiz_num
*           Do 11 j=1,vert_num
          Do 10 i=1,ii
           Do 11 j=1,jj
            fld_data(i,j,cont)=fld_data(i,j,cont)
     $      +cont_offset
11         Continue
10        Continue
         ELSEIF (fix_axis.EQ.'Y'.OR.fix_axis.EQ.'y') THEN
*          Do 12 i=1,horiz_num
*           Do 13 j=1,vert_num
          Do 12 i=1,ii
           Do 13 j=1,jj
            fld_data(i,j,cont)=fld_data(i,j,cont)
     $      +cont_offset
13         Continue
12        Continue
         ELSEIF (fix_axis.EQ.'X'.OR.fix_axis.EQ.'x') THEN
*          Do 14 i=1,horiz_num
*           Do 15 j=1,vert_num
          Do 14 i=1,ii
           Do 15 j=1,jj
            fld_data(i,j,cont)=fld_data(i,j,cont)
     $      +cont_offset
15         Continue
14        Continue
         ENDIF
	ENDDO

        Return
        End

**************************************************
	Subroutine CalcDist(dist)

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Real dist

C  This subroutine calculates the distance given the level
	
	dist=((level-1)*fix_inc)+fix_beg

	Return
	End
**************************************************
	Subroutine WriteGsave(gflag)

	Implicit none
	Integer gflag

C gflag keeps is used to link the gsave to the grestore
 
	Write (95,10)gflag
10	Format ('gsave %',I2)

	Return
	End
**************************************************
	Subroutine WriteGrestore(gflag)

	Implicit none
	Integer gflag

C gflag keeps is used to link the gsave to the grestore
 
	Write (95,10)gflag
10	Format ('grestore %',I2)

	Return
	End
**************************************************
	Subroutine WriteClip

	Implicit none

	Write (95,10)
10	Format('ClipIt')

	Return
	End
**************************************************
	Subroutine BoxPosTrans(num)

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer num

	IF (template.EQ.1) THEN
	 Write (95,10)strx(1),stry(1)
10	 Format (A,1X,A,' translate')
	ELSE
	 Write (95,11)strx(num),stry(num)
11	 Format (A,1X,A,' translate')
	ENDIF

	IF (fill_flag.EQ.'N'.OR.fill_flag.EQ.'n') THEN
	 Write (95,*)'8/Helvetica font'
	ENDIF

	Return
	End
**************************************************
	Subroutine OriginTrans

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'


	Write (95,10)
10	Format ('shift_horiz shift_vert translate')

	Return
	End
**************************************************
	Subroutine BoxPosUnTrans(num)

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer num

	IF (template.EQ.1) THEN
	 Write (95,10)strx(1),stry(1)
10	 Format (A,'neg ',A,' neg translate')
	ELSE
	 Write (95,11)strx(num),stry(num)
11	 Format (A,' neg ',A,' neg translate')
	ENDIF

	Return
	End
**************************************************
	Subroutine OriginUnTrans

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Write (95,10)
10	Format ('shift_horiz neg shift_vert neg translate')

*	Write (95,10)shift_horiz,shift_vert
*10	Format (F7.2,' neg ',F7.2,' neg translate')

	Return
	End
**************************************************
	Subroutine WriteShowPage

	Implicit none

	Write(95,*)'showpage'

	Return
	End
**************************************************
	Subroutine WriteBorder

	Implicit none

	Write (95,*)'%***********************************************'
	Write (95,*)'%***********************************************'

	Return
	End
**************************************************
	Subroutine DrawBox

	Implicit none

	Write (95,*) '% DRAW BOX'
	Write(95,*)'gs .5 setlinewidth box gr'
	Write(95,*)'phgrid pvgrid shgrid svgrid'

	Return
	End
**************************************************
	Subroutine WriteFont(font_flag)

	Implicit none
	Include 'common1.h'

	Character*1 font_flag

	IF (font_flag.EQ.'N') THEN
	 Write (95,10)font_num
10	 Format (I2,'/Helvetica font')
	ELSEIF (font_flag.EQ.'L') THEN
	 Write (95,11)font_label
11	 Format (I2,'/Helvetica font')
	ELSEIF (font_flag.EQ.'T') THEN
	 Write (95,12)font_title
12	 Format (I2,'/Helvetica font')
	ENDIF

	Return
	End
**************************************************
	Subroutine WriteNum

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer i,j
	Real temp_horiz_num,temp_vert_num

C Label the grid
	i=0
	j=0
	temp_horiz_num=horiz_beg+tick_hbeg1 
	temp_vert_num=vert_beg+tick_vbeg1
	Write (95,*)'%HORIZONTAL NUMBERS'
        write(6,*)'temp_horiz_num,horiz_beg,tick_hbeg1 = ',
     1   temp_horiz_num,horiz_beg,tick_hbeg1
c        pause
10	IF (temp_horiz_num.LE.horiz_end) THEN	 
	 Write (95,20)i,tick_hbeg1,hkm,ifix(temp_horiz_num)
20	 Format('pri_grid1 ',I2,' mul ',F6.2,1X,A,
     $ ' add sp_horiz_text neg 0 (',I3,') 2 3 text_pos')
	 Write (95,*)'text1'
	 i=i+1
	 temp_horiz_num=temp_horiz_num+pri_grid1
	 go to 10
	ENDIF
	Write (95,*)'%VERTICAL NUMBERS'
11	IF (temp_vert_num.LE.vert_end) THEN	 
	 Write (95,21)j,tick_vbeg1,vkm,ifix(temp_vert_num)
21	 Format('sp_vert_text neg pri_grid2 ',I2,' mul ',F6.2,1X,A,
     $ ' add 0 (',I3,') 4 2 text_pos')
	 Write (95,*)'text1'
	 j=j+1
	 temp_vert_num=temp_vert_num+pri_grid2
	 go to 11
	ENDIF
		
	Return
	End
**************************************************
	Subroutine WriteAxisLabel

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'
	
	Character*5 temp_hlb,temp_vlb

C Print the horizontal & vertical grid labels
	IF (fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') THEN
	 temp_hlb='X(KM)'
	 temp_vlb='Y(KM)'
	ELSEIF (fix_axis.EQ.'Y'.OR.fix_axis.EQ.'y') THEN
	 temp_hlb='X(KM)'
	 temp_vlb='Z(KM)'
	ELSEIF (fix_axis.EQ.'X'.OR.fix_axis.EQ.'x') THEN
	 temp_hlb='Y(KM)'
	 temp_vlb='Z(KM)'
	ENDIF
		
	Write (95,*)'% GRID LABELS'
	Write (95,10)temp_hlb
10	Format ('box_w 2 div sp_horiz_text 2 mul num_ht add neg  0',
     $ '(',A,') 2 2 text_pos') 
	Write (95,*)'text1'
	Write (95,11)temp_vlb
11	Format ('sp_vert_text 2 mul num_ht add neg box_h 2 div 90',
     $ '(',A,') 2 1 text_pos')
	Write (95,*)'text1'

	Return
	End
**************************************************
	Subroutine DrawScaleVector

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Real head,halfhead,halfthick
	
	IF (plot_type.EQ.1.OR.plot_type.EQ.3.OR.plot_type.EQ.5) THEN
	 Write (95,*)'%DRAW SCALE VECTOR'
C Changed so all arrow heads same size: Peter Dodge 12 August 1997
Cout         head = arrow_h*vec_length
Cout         halfhead = arrow_hh*vec_length
         head = arrow_h
         halfhead = arrow_hh
C Changed so all arrows same thickness: Peter Dodge 28 April 1997
Cout         halfthick = arrow_ht*vec_length
         halfthick = arrow_ht
C Write the vector
         Write (95,10)vec_length,hkm,vec_length,hkm,
     $   halfthick,hkm,halfhead,hkm,head,hkm
10	 Format('sp_horiz_text 2 mul num_ht add neg  box_w ',F6.1,1X,A,
     $   ' sub 0 ',F6.1,1X,A,1X,F6.2,1X,A,F6.2,1X,A,F6.2,1X,A,' a f')
	 Write (95,11)vec_length,hkm,int(vec_speed)
11	 Format('box_w ',F6.1,1X,A,
     +		' sub 5 sub sp_horiz_text 2 mul num_ht ',
     $   'add neg 0 (',I3,' m/s) 4 2 text_pos')
	 Write (95,*)'text1'
	ENDIF

	Return
	End
**************************************************
	Subroutine WriteDate

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'
	
	Character*1 sp

C Print date
	Write (95,*)'%PRINT PLOT INFO'
	sp='/'
C Modifed to write 04/09/04 instead of 4/9/4
	Write (95,20)year_beg,sp,month_beg,sp,day_beg
20	Format('0 box_h sp_horiz_text add 0 (',I2.2,A,I2.2,A,I2.2,
     $') 1 1 text_pos')
	Write (95,*)'text1'

	Return
	End
**************************************************
	Subroutine WriteTime

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'
	
	Character*1 sp

C Print time
	sp=':'
	Write (95,21)hour_beg,sp,min_beg,sp,sec_beg,
     $  hour_end,sp,min_end,sp,sec_end
21 	Format ('box_w 3 div  box_h sp_horiz_text add 0 (',
     $  I2,A,I2,A,I2,'-',I2,A,I2,A,I2,') 2 1 text_pos')
	Write (95,*)'text1'

	Return
	End
**************************************************
	Subroutine WritePanelTitle

	Implicit none

	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'
	
	Integer i1

	i1=index(panel_title,'  ')-1

	Write (95,10)panel_title(1:i1)
10	Format ('box_w 3 div 2 mul box_h sp_horiz_text add 0 (',
     $  A,') 2 1 text_pos')
	Write (95,*)'text1'
C For hurricane plots
*	Write (95,10)panel_title(1:i1)
*10	Format ('box_w 3 div 0 mul box_h sp_horiz_text add 0 (',
*     $  A,') 1 1 text_pos')
*	Write (95,*)'text1'
	
	Return
	End
**************************************************
	Subroutine WriteDist

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'
	
	Real dist
	Character*1 sp

C Print level
	Call CalcDist(dist)	
	sp='='
	Write (95,22)fix_axis,sp,dist
22	Format ('box_w box_h sp_horiz_text add 0 (',A,A,F6.2,
     $  ')4 1 text_pos')
C For hurricane plots
*	Write (95,22)'INT',sp,nint(nofill_inc)
*22	Format ('box_w box_h sp_horiz_text add 0 (',A,A,I2,')
*     $  4 1 text_pos')
	Write (95,*)'text1'

	Return
	End
**************************************************
	Subroutine DrawScale

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	IF (scale_pos.EQ.'VER') THEN
	 Write (95,10)
10	 Format('DrawScale')
	ELSEIF (scale_pos.EQ.'HOR') THEN
	 Write (95,11)
11	 Format('gsave 270 rotate DrawScale grestore')
	
	ENDIF

	Return
	End
**************************************************
	Subroutine WriteScaleNum(count_arr)
C Mod 17 June 1997 for non-uniform intervals
	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer i,int_value
	Real real_value,count_arr(42)
	Character*4 value_flag

C Check to see if values are integers
	if( non_uniform .eq. 0) then
	  IF ((mod(fill_beg,10.0).EQ.0.AND.mod(fill_inc,10.0).EQ.0)
     $    .OR.(mod(fill_beg,1.0).EQ.0.AND.mod(fill_inc,1.0).EQ.0)) THEN
	 	value_flag='INT'
	  ELSE
	 	value_flag='REAL'
	  ENDIF
	else
	IF ((mod(fill_non_lev(1),10.0).EQ.0.AND.
     +		mod(fill_non_lev(fill_nonunif),10.0).EQ.0)
     $  	.OR.(mod(fill_non_lev(1),1.0).EQ.0.AND.
     +		mod(fill_non_lev(fill_nonunif),1.0).EQ.0)) THEN
	 value_flag='INT'
	ELSE
	 value_flag='REAL'
	ENDIF
	end if
C Write out the numbers
	if( non_uniform .eq. 0) then ! <><><><><><><><><><><><><><><><><>
	IF (scale_pos.EQ.'VER') THEN
	 IF (value_flag(1:3).EQ.'INT') THEN
	  DO i=2,num_box
	   int_value=nint(((i-1)*fill_inc)+fill_beg)
	   Write (95,10)i-1,int_value
10	   Format ('scale_w sp_vert_text add scale_box_h ',I2,' mul 0 (',
     $     I3,') 1 2 text_pos')
	   Write (95,*)'text1'
	  ENDDO
	 ELSEIF (value_flag.EQ.'REAL') THEN
	  DO i=2,num_box
	   real_value=((i-1)*fill_inc)+fill_beg
	   Write (95,11)i-1,real_value
11	   Format ('scale_w sp_vert_text add scale_box_h ',I2,' mul 0 (',
     $     F5.1,') 1 2 text_pos')
	   Write (95,*)'text1'
	  ENDDO
	 ENDIF
	ELSEIF (scale_pos.EQ.'HOR') THEN
	 IF (value_flag(1:3).EQ.'INT') THEN
	  DO i=2,num_box
	   int_value=nint(((i-1)*fill_inc)+fill_beg)
	   Write (95,20)i-1,int_value
20	   Format ('scale_box_h ',I2,' mul sp_horiz_text 0 (',
     $     I3,') 2 1 text_pos')
	   Write (95,*)'text1'
	  ENDDO
	 ELSEIF (value_flag.EQ.'REAL') THEN
	  DO i=2,num_box
	   real_value=((i-1)*fill_inc)+fill_beg
	   Write (95,21)i-1,real_value
21	   Format ('scale_box_h ',I2,' mul sp_horiz_text 0 (',
     $     F5.1,') 2 1 text_pos')
	   Write (95,*)'text1'
	  ENDDO
	 ENDIF
	ENDIF
	else ! <><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
	IF (scale_pos.EQ.'VER') THEN
	 IF (value_flag(1:3).EQ.'INT') THEN
	  DO i=2,num_box
	   int_value = fill_non_lev(i)
Cout	   int_value=nint(((i-1)*fill_inc)+fill_beg)
	   Write (95,10)i-1,int_value
	   Write (95,*)'text1'
	  ENDDO
	 ELSEIF (value_flag.EQ.'REAL') THEN
	  DO i=2,num_box
	   real_value= fill_non_lev(i)
C	   real_value=((i-1)*fill_inc)+fill_beg
	   Write (95,11)i-1,real_value
	   Write (95,*)'text1'
	  ENDDO
	 ENDIF
	ELSEIF (scale_pos.EQ.'HOR') THEN
	 IF (value_flag(1:3).EQ.'INT') THEN
	  DO i=2,num_box
	   int_value = fill_non_lev(i)
Cout	   int_value=nint(((i-1)*fill_inc)+fill_beg)
	   Write (95,20)i-1,int_value
	   Write (95,*)'text1'
	  ENDDO
	 ELSEIF (value_flag.EQ.'REAL') THEN
	  DO i=2,num_box
	   real_value= fill_non_lev(i)
Cout	   real_value=((i-1)*fill_inc)+fill_beg
	   Write (95,21)i-1,real_value
	   Write (95,*)'text1'
	  ENDDO
	 ENDIF
	ENDIF
	end if ! <><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>
	Return
	End
**************************************************
	Subroutine WriteScaleTitle

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer i1
	i1=index(scale_title,'  ')-1
C mod 28 may 96, to avoid writing bad postscript if scale title too big...
	if( i1 .ge. 1 ) then ! >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

	IF (scale_pos.EQ.'VER') THEN
	 Write (95,10)scale_title(1:i1)
10	 Format('scale_w 2 div scale_h sp_horiz_text add 0 (',A,
     $   ')  2 1 text_pos') 
	 Write (95,*)'text1'
	ELSEIF (scale_pos.EQ.'HOR') THEN
	 Write (95,11)scale_title(1:i1)
11	 Format ('sp_vert_text neg scale_w 2 div neg 0 (',A,
     $   ') 4 2 text_pos')
	 Write (95,*)'text1'
	ENDIF
C
	else   ! <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
		write(6,*)' scale title too long!!'
	end if ! <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	Return
	End
**************************************************
	Subroutine ScaleTrans 

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Write (95,*)'%DRAW THE SCALE'
	Write (95,10)
10	Format ('scale_posx scale_posy translate')

	Return
	End
**************************************************
	Subroutine ScaleUnTrans 

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Write (95,10)
10	Format ('scale_posx neg scale_posy neg translate')

	Return
	End
**************************************************
	Subroutine Vector 
C modified 28 April 1997 by Peter Dodge, so if vector has zero length, and thus
C indeterminate direction, it is not written out.
	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer i,j,x, igood
	Integer pthinc,ptvinc,hindex_beg,hindex_end,vindex_beg,vindex_end
	Real tailh,tailv,tiph,tipv,head,halfhead,halfthick

	Call CalcPtSkip(pthinc,ptvinc)
	Call CalcIndex(hindex_beg,hindex_end,vindex_beg,vindex_end)
	IF (fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') THEN
	 DO 10 i=hindex_beg,hindex_end,pthinc
	  DO 11,j=vindex_beg,vindex_end,ptvinc
           IF (ptskip.EQ.-1.AND.mod(j+1,2).EQ.0) THEN
            x = i+1
           ELSE
            x = i
           ENDIF
*           IF ((fld_data(i,j,vec1).GT.-100.).AND.
*     $        (fld_data(i,j,vec2).GT.-100.)) THEN
*	    Call CalcTail(i,j,tailh,tailv)
*	    Call CalcTip(i,j,tiph,tipv, igood)
           IF ((fld_data(x,j,vec1).GT.-100.).AND.
     $        (fld_data(x,j,vec2).GT.-100.)) THEN
	    Call CalcTail(x,j,tailh,tailv)
	    Call CalcTip(x,j,tiph,tipv, igood)
	    if( igood .eq. 1) then
		Call CalcVector(tiph,tipv,head,halfhead,halfthick)
		Call WriteVector(tailh,tailv,tiph,tipv,head,
     +			halfhead,halfthick)
	    end if
	   ENDIF
11	  CONTINUE
10	 CONTINUE
	ELSEIF (fix_axis.EQ.'Y'.OR.fix_axis.EQ.'y') THEN
	 DO 20 i=hindex_beg,hindex_end,pthinc
	  DO 21,j=vindex_beg,vindex_end,ptvinc
           IF (ptskip.EQ.-1.AND.mod(j+1,2).EQ.0) THEN
            x = i+1
           ELSE
            x = i
           ENDIF
           IF ((fld_data(x,j,vec1).GT.-100.).AND.
     $        (fld_data(x,j,vec2).GT.-100.)) THEN
	    Call CalcTail(x,j,tailh,tailv)
	    Call CalcTip(x,j,tiph,tipv, igood)
	    if( igood .eq. 1) then
	    	Call CalcVector(tiph,tipv,head,halfhead,halfthick)
	    	Call WriteVector(tailh,tailv,tiph,tipv,head,
     +			halfhead,halfthick)
	    end if
	   ENDIF
21	  CONTINUE
20	 CONTINUE
	ELSEIF (fix_axis.EQ.'X'.OR.fix_axis.EQ.'x') THEN
	 DO 30 i=hindex_beg,hindex_end,pthinc
	  DO 31,j=vindex_beg,vindex_end,ptvinc
           IF (ptskip.EQ.-1.AND.mod(j+1,2).EQ.0) THEN
            x = i+1
           ELSE
            x = i
           ENDIF
           IF ((fld_data(x,j,vec1).GT.-100.).AND.
     $        (fld_data(x,j,vec2).GT.-100.)) THEN
	    Call CalcTail(x,j,tailh,tailv)
	    Call CalcTip(x,j,tiph,tipv, igood)
	    if( igood .eq. 1) then
	    	Call CalcVector(tiph,tipv,head,halfhead,halfthick)
	    	Call WriteVector(tailh,tailv,tiph,tipv,head,
     +			halfhead,halfthick)
	    end if
	   ENDIF
31	  CONTINUE
30	 CONTINUE
	ENDIF

	Return
	End
**************************************************
	Subroutine CalcPtSkip (pthinc,ptvinc) 

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer pthinc,ptvinc

C Calculate the points to skip
        If (ptskip.EQ.-1) then
         pthinc = 2
         ptvinc = 1
        else
         pthinc = ptskip
*         ptvinc = 1
         ptvinc = ptskip
        endif

	Return
	End
**************************************************
	Subroutine CalcIndex(hindex_beg,hindex_end,vindex_beg,vindex_end)

        Implicit none
        Include 'common1.h'
        Include 'common2.h'
        Include 'common3.h'

	Integer hindex_beg,hindex_end,vindex_beg,vindex_end

C Calculate the beginning & ending index of array 
	IF (horiz_beg.LE.save_hbeg) THEN
	 hindex_beg=1	
	ELSE
	 hindex_beg=nint(((horiz_beg-save_hbeg)/horiz_inc)+1)	
	ENDIF
	IF (vert_beg.LE.save_vbeg) THEN
	 vindex_beg=1	
	ELSE
	 vindex_beg=nint(((vert_beg-save_vbeg)/vert_inc)+1)	
	ENDIF

	hindex_end=nint(((horiz_end-save_hbeg)/horiz_inc)+1)	
	vindex_end=nint(((vert_end-save_vbeg)/vert_inc)+1)	

	Return
	End  
**************************************************
	Subroutine CalcTail(i,j,tailh,tailv)

        Implicit none
        Include 'common1.h'
        Include 'common2.h'
        Include 'common3.h'

	Integer i,j
	Real tailh,tailv

C Calculate the tail of the vector
	tailh=save_hbeg+((i-1)*horiz_inc)
	tailv=save_vbeg+((j-1)*vert_inc)

	Return
	End
**************************************************
	Subroutine CalcTip(i,j,tiph,tipv, igood)

        Implicit none
        Include 'common1.h'
        Include 'common2.h'
        Include 'common3.h'

	Integer i,j, igood
	Real tiph,tipv

C Calculate the tip of the vector
	tiph=fld_data(i,j,vec1)*vec_scale
	tipv=fld_data(i,j,vec2)*vec_scale
C Arrow will bomb if itph = tipv = 0, ( 0 0 atan not defined in PostScript)
C so added code to check, 
C and arg to return 28 April 1997 Peter Dodge
	if( tiph*tipv .eq. 0.0) then
	    if( tiph .ne. 0.0 .or. tipv .ne. 0.0) then
		igood = 1
	    else
		igood = 0
	    end if
	else
		igood = 1
	end if
	Return
	End
**************************************************
	Subroutine CalcVector(tiph,tipv,head,halfhead,halfthick)

        Implicit none
        Include 'common1.h'
        Include 'common2.h'
        Include 'common3.h'

	Real tiph,tipv,head,halfhead,halfthick,sum,length

C Calculate the arrow parameters
	IF (tiph.EQ.0.AND.tipv.EQ.0) THEN
         tiph = 1
         tipv = 0
         sum = 0
        ELSE
         sum = tiph**2 + tipv**2
        ENDIF
        length = sqrt(sum)
C Changed so all arrow heads same size: Peter Dodge 12 August 1997
Cout         head = arrow_h*length
Cout         halfhead = arrow_hh*length
         head = arrow_h
         halfhead = arrow_hh
C All arrows have constant thickness 28 april 1997 Peter Dodge
	halfthick = arrow_ht
Cout        halfthick = arrow_ht*length

	Return
	End
**************************************************
	Subroutine WriteVector(tailh,tailv,tiph,tipv,head,
     +		halfhead,halfthick)

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Real tailh,tailv,tiph,tipv,head,halfhead,halfthick

C Write the vector
	Write (95,10)tailv,vkm,tailh,hkm,tipv,vkm,tiph,hkm,
     $  halfthick,hkm,halfhead,hkm,head,hkm
*	Write (95,10)tailv,vkm,tailh,hkm,tipv,hkm,tiph,hkm,
*     $  halfthick,hkm,halfhead,hkm,head,hkm
 
C Modifed 6 June 2005, to allow coordinates <= -100.0 km 
10	Format (F8.3,1X,A,1X,F8.3,1X,A,1X,F8.3,1X,A,1X,F8.3,1X,A,1X,
     $  F6.2,1X,A,1X,F6.2,1X,A,1X,F6.2,1X,A,' a f')

	Return
	End
**************************************************
	Subroutine WriteOrient

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Write (95,*)'21.59 cm 0 translate 0 0 m 90 rotate'

	Return
	End
**************************************************
	Subroutine WriteFieldLabel(label_num)

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer i1,i2,i3,i4,label_num,temp,k,str_index(4)

	label_num=label_num+1

	IF (scale_pos.EQ.'HOR'.AND.plot_type.EQ.1) temp=1 
	IF (scale_pos.EQ.'HOR'.AND.plot_type.GT.1) temp=2 

	Write (95,*)'%DRAW BOTTOM LABEL'

C count the characters in the fields
        Do k=1,4
         str_index(k)=index(str(k),' ')-1
        ENDDO

C Calculate the actual size of the field name so you don't end up with a
C bunch of spaces when the name is written out
*	DO i=1,4
*	j=1
*100	 IF (str(i)(j:j).NE.' ') THEN
*	  str_index(i)=j
*	  j=j+1
*	  go to 100
*	 ENDIF
*	ENDDO 	

C Write out the field labels
	i1=str_index(1) 
	i2=str_index(2) 
	i3=str_index(3) 
	i4=str_index(4) 
	IF (scale_pos.EQ.'VER') THEN
	 IF (plot_type.EQ.1) THEN
	  Write (95,10)label_num+2,label_num,
     $    str(1)(1:i1),str(2)(1:i2)
10	  Format('0 sp_horiz_text ',I1,' mul num_ht add label_ht ',
     $    I1,' mul add neg 0 (VECTOR:  ',A,5x,A,') 1 3 text_pos')
	  Write (95,*)'text1'
	 ELSEIF (plot_type.EQ.2) THEN
	  Write (95,20)label_num+2,label_num,
     $    str(3)(1:i3)
20	  Format('0 sp_horiz_text ',I1,' mul num_ht add label_ht ',
     $    I1,' mul add neg 0 (CONTOUR:  ',A,') 1 3 text_pos')
	  Write (95,*)'text1'
	 ELSEIF (plot_type.EQ.3) THEN
	  Write (95,30)label_num+2,label_num,
     $    str(1)(1:i1),str(2)(1:i2),str(3)(1:i3)
30	  Format('0 sp_horiz_text ',I1,' mul num_ht add label_ht ',
     $    I1,' mul add neg 0 (VECTOR:  ',A,5x,A,5X,'CONTOUR:  ',
     $    A,') 1 3 text_pos')
	  Write (95,*)'text1'
	 ELSEIF (plot_type.EQ.4) THEN
	  Write (95,40)label_num+2,label_num,
     $    str(3)(1:i3),str(4)(1:i4)
40	  Format('0 sp_horiz_text ',I1,' mul num_ht add label_ht ',
     $    I1,' mul add neg 0 (CONTOUR:  ',A,5x,A,') 1 3 text_pos')
	  Write (95,*)'text1'
	 ELSEIF (plot_type.EQ.5) THEN
	  Write (95,50)label_num+2,label_num,
     $    str(1)(1:i1),str(2)(1:i2),str(3)(1:i3),str(4)(1:i4)
50	  Format('0 sp_horiz_text ',I1,' mul num_ht add label_ht ',
     $    I1, ' mul add neg 0 (VECTOR:  ',A,5x,A,5X,'CONTOUR: ',
     $    A,5x,A,') 1 3 text_pos')
	  Write (95,*)'text1'
	 ENDIF
	ELSEIF (scale_pos.EQ.'HOR') THEN
	 IF (plot_type.EQ.1) THEN
	  Write (95,11)label_num+2,label_num,temp,
     $    str(1)(1:i1),str(2)(1:i2)
11	  Format('0 sp_horiz_text ',I1,
     +		' mul num_ht ',I1,' mul add label_ht ',
     $    I1,' mul add scale_w add sp_scale add neg 0 ',
     $    '(VECTOR:  ',A,5x,A,') 1 3 text_pos')
	  Write (95,*)'text1'
	 ELSEIF (plot_type.EQ.2) THEN
	  Write (95,21)label_num+3,label_num,temp,
     $    str(3)(1:i3)
21	  Format('0 sp_horiz_text ',I1,' mul num_ht ',
     +		I1,' mul add label_ht ',
     $    I1,' mul add scale_w add sp_scale add neg 0 ',
     $    '(CONTOUR:  ',A,') 1 3 text_pos')
	  Write (95,*)'text1'
	 ELSEIF (plot_type.EQ.3) THEN
	  Write (95,31)label_num+3,label_num,temp,
     $    str(1)(1:i1),str(2)(1:i2),str(3)(1:i3)
31	  Format('0 sp_horiz_text ',I1,' mul num_ht ',I1,
     +		' mul add label_ht ',
     $    I1,' mul add scale_w add sp_scale add neg 0 ',
     $    '(VECTOR:  ',A,5x,A,5X,'CONTOUR:  ', A,') 1 3 text_pos')
	  Write (95,*)'text1'
	 ELSEIF (plot_type.EQ.4) THEN
	  Write (95,41)label_num+3,label_num,temp,
     $    str(3)(1:i3),str(4)(1:i4)
41	  Format('0 sp_horiz_text ',I1,' mul num_ht ',
     +		I1,' mul add label_ht ',
     $    I1,' mul add scale_w add sp_scale add neg 0 ',
     $    '(CONTOUR:  ',A,5x,A,') 1 3 text_pos')
	  Write (95,*)'text1'
	 ELSEIF (plot_type.EQ.5) THEN
	  Write (95,51)label_num+3,label_num,temp,
     $    str(1)(1:i1),str(2)(1:i2),str(3)(1:i3),str(4)(1:i4)
51	  Format('0 sp_horiz_text ',I1,' mul num_ht ',
     +		I1,' mul add label_ht ',
     $    I1, ' mul add scale_w add sp_scale add neg 0 ',
     $    '(VECTOR:  ',A,5x,A,5X,'CONTOUR: ',A,5x,A,') 1 3 text_pos')
	  Write (95,*)'text1'
	 ENDIF
	ENDIF

	Return
	End
**************************************************
	Subroutine WriteLatLong(label_num)

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer label_num,temp
	Character*3 t1,t2,t3

	t1='DEG'
	t2='MIN'
	t3='SEC'
	label_num=label_num+1

	IF (scale_pos.EQ.'HOR'.AND.plot_type.EQ.1) temp=1 
	IF (scale_pos.EQ.'HOR'.AND.plot_type.GT.1) temp=2 

	IF (scale_pos.EQ.'VER') THEN
	 Write(95,10)label_num+2,label_num,
     $   lat_deg,t1,lat_min,t2,lat_sec,t3,
     $   long_deg,t1,long_min,t2,long_sec,t3
10	 Format('0 sp_horiz_text ',I1,' mul num_ht add label_ht ',
     $   I1,' mul add neg 0 (LATITUDE:  ',I4,1X,A,2X,I3,1X,A,2X,I3,1X,A,
     $   2X,'LONGITUDE:  ',I4,1X,A,2X,I3,1X,A,2X,I3,1X,A,
     $   ') 1 3 text_pos')
	 Write (95,*)'text1'
	ELSEIF (scale_pos.EQ.'HOR') THEN
	 IF (plot_type.EQ.1) THEN
	  Write(95,11)label_num+2,label_num,temp,
     $    lat_deg,t1,lat_min,t2,lat_sec,t3,
     $    long_deg,t1,long_min,t2,long_sec,t3
	 ELSE
	  Write(95,11)label_num+3,label_num,temp,
     $    lat_deg,t1,lat_min,t2,lat_sec,t3,
     $    long_deg,t1,long_min,t2,long_sec,t3
	 ENDIF
11	 Format('0 sp_horiz_text ',I1,' mul num_ht ',
     +		I1,' mul add label_ht ',
     $   I1,' mul add scale_w add sp_scale add neg 0 (LATITUDE:  '
     $   ,I4,1X,A,2X,I3,1X,A,2X,I3,1X,A,2X,'LONGITUDE:  '
     $   ,I4,1X,A,2X,I3,1X,A,2X,I3,1X,A,') 1 3 text_pos')
	 Write (95,*)'text1'
	ENDIF

	Return
	End
**************************************************
	Subroutine WriteHorOrigin(label_num)

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer label_num,temp

	label_num=label_num+1

	IF (scale_pos.EQ.'HOR'.AND.plot_type.EQ.1) temp=1 
	IF (scale_pos.EQ.'HOR'.AND.plot_type.GT.1) temp=2 

	IF (scale_pos.EQ.'VER') THEN
	 Write(95,10)label_num+2,label_num,xhoriz_orig,yhoriz_orig
10	 Format('0 sp_horiz_text ',I1,' mul num_ht add label_ht ',
     $   I1,' mul add neg 0 (ORIGIN: (',F5.2,',',F5.2,')) 1 3 text_pos')
	 Write (95,*)'text1'
	ELSEIF (scale_pos.EQ.'HOR') THEN
	 IF (plot_type.EQ.1) THEN
	  Write(95,11)label_num+2,label_num,temp,xhoriz_orig,
     +		yhoriz_orig
	 ELSE
	  Write(95,11)label_num+3,label_num,temp,xhoriz_orig,
     +		yhoriz_orig
	 ENDIF
11	 Format('0 sp_horiz_text ',I1,' mul num_ht ',
     +		I1,' mul add label_ht ',
     $   I1,' mul add scale_w add sp_scale add neg 0 (ORIGIN: ('
     $   ,F5.2,',',F5.2,')) 1 3 text_pos')
	 Write (95,*)'text1'
	ENDIF

	Return
	End
**************************************************
	Subroutine WritePoints(label_num)

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer label_num,temp

	IF (scale_pos.EQ.'HOR'.AND.plot_type.EQ.1) temp=1 
	IF (scale_pos.EQ.'HOR'.AND.plot_type.GT.1) temp=2 

	IF (scale_pos.EQ.'VER') THEN
	 IF (plot_type.EQ.1.OR.plot_type.EQ.3.OR.plot_type.EQ.5) THEN
	  label_num=label_num+1
	  IF (ptskip.EQ.1) THEN
	   Write(95,10)label_num+2,label_num
10	   Format('0 sp_horiz_text ',I1,' mul num_ht add label_ht ',
     $     I1,' mul add neg 0 (EVERY POINT PLOTTED) 1 3 text_pos')
	   Write (95,*)'text1'
	  ELSE
	   Write(95,11)label_num+2,label_num,ptskip
11	   Format('0 sp_horiz_text ',I1,' mul num_ht add label_ht ',
     $     I1,' mul add neg 0 (EVERY ',I2,' POINTS PLOTTED) 
     $     1 3 text_pos')
	   Write (95,*)'text1'
	  ENDIF
	 ENDIF
	ELSEIF (scale_pos.EQ.'HOR') THEN
	 IF (plot_type.EQ.1.OR.plot_type.EQ.3.OR.plot_type.EQ.5) THEN
	  label_num=label_num+1
	  IF (ptskip.EQ.1) THEN
	   IF (plot_type.EQ.1) THEN
	    write(95,20)label_num+2,label_num,temp
	   ELSE
	    write(95,20)label_num+3,label_num,temp
	   ENDIF
20	   Format('0 sp_horiz_text ',I1,' mul num_ht ',
     +		I2,' mul add label_ht ',
     $     I1,' mul add scale_w add sp_scale add neg 0 ',
     $     '(EVERY POINT PLOTTED) 1 3 text_pos')
	   Write (95,*)'text1'
	  ELSE
	   IF (plot_type.EQ.1) THEN
	    write(95,21)label_num+2,label_num,temp,ptskip
	   ELSE
	    write(95,21)label_num+3,label_num,temp,ptskip
	   ENDIF
21	   Format('0 sp_horiz_text ',I1,' mul num_ht ',
     +		I2,' mul add label_ht ',
     $     I1,' mul add scale_w add sp_scale add neg 0 ',
     $     '(EVERY ',I2,' POINTS PLOTTED) 1 3 text_pos')
	   Write (95,*)'text1'
	  ENDIF
	 ENDIF
	ENDIF

	Return
	End
**************************************************
	Subroutine WriteScan(label_num)

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer label_num,temp

	IF (scale_pos.EQ.'HOR'.AND.plot_type.EQ.1) temp=1 
	IF (scale_pos.EQ.'HOR'.AND.plot_type.GT.1) temp=2 

	IF (scale_pos.EQ.'VER') THEN
	 IF ((fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') .AND 
     +		.scan_mode.EQ.'AIR') THEN
	  label_num=label_num+1
	  IF (plane_inc.EQ.1) THEN
	   Write(95,10)label_num+2,label_num
10	   Format('0 sp_horiz_text ',I1,' mul num_ht add label_ht ',
     $     I1,' mul add neg 0 (PLOT AIRCRAFT EVERY SCAN) 1 3 text_pos')
	   Write (95,*)'text1'
	  ELSE
	   Write(95,11)label_num+2,label_num,plane_inc
11	   Format('0 sp_horiz_text ',I1,' mul num_ht add label_ht ',
     $     I1,' mul add neg 0 (PLOT AIRCRAFT EVERY ',I2,' SCANS)', 
     $     ' 1 3 text_pos')
	   Write (95,*)'text1'
	  ENDIF
	 ENDIF
	ELSEIF (scale_pos.EQ.'HOR') THEN
	 IF ((fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') .AND. 
     +		scan_mode.EQ.'AIR') THEN
	  label_num=label_num+1
	  IF (plane_inc.EQ.1) THEN
	   IF (plot_type.EQ.1) THEN
	    write(95,20)label_num+2,label_num,1
	   ELSE
	    write(95,20)label_num+3,label_num,2
	   ENDIF
20	   Format('0 sp_horiz_text ',I1,' mul num_ht ',
     +		I1,' mul add label_ht ',
     $     I1,' mul scale_w add sp_scale add add neg 0 ',
     $     '(PLOT AIRCRAFT EVERY SCAN) 1 3 text_pos')
	   Write (95,*)'text1'
	  ELSE
	   IF (plot_type.EQ.1) THEN
	    write(95,21)label_num+2,label_num,temp,plane_inc
	   ELSE
	    write(95,21)label_num+3,label_num,temp,plane_inc
	   ENDIF
21	   Format('0 sp_horiz_text ',I1,' mul num_ht ',
     +		I1,' mul add label_ht ',
     $     I1,' mul add scale_w add sp_scale add  neg 0 ',
     $     '(PLOT AIRCRAFT EVERY ',I2,' SCANS)', 
     $     ' 1 3 text_pos')
	   Write (95,*)'text1'
	  ENDIF
	 ENDIF
	ENDIF

	Return
	End
**************************************************
	Subroutine WriteTitle

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer i1

	i1=index(title,'  ')-1

	IF (template.LE.5.OR.template.EQ.11) THEN
	 Write (95,10)title(1:i1)
	ELSEIF (template.GT.5.AND.template.LE.10) THEN
	 Write (95,60)title(1:i1)
	ELSEIF (template.EQ.12.OR.template.EQ.13) THEN
	 Write (95,60)title(1:i1)
	ENDIF

	Write (95,*)'text1'

10	Format('box_w 2 div box_h sp_horiz_text 2.5 mul add label_ht add 
     $  0 (', A,') 2 1 text_pos')
60 	Format ('sp_col 2 div neg box_h sp_horiz_text 2.5 mul add 
     $  label_ht add   0 (',A,') 2 1 text_pos')

	Return
	End
**************************************************
        Subroutine InitializeData(initialize_flag,id,nid)

        Implicit none

        Integer nid,id(nid)
        Integer initialize_flag,i,j,k,l
        Integer horiz_index1,vert_index1,fix_index1
        Integer horiz_index2,vert_index2,fix_index2
        Character init_array

        Include 'common1.h'
        Include 'common2.h'
        Include 'common3.h'

        init_array='N'
        horiz_index1=ifix(horiz_num)
        vert_index1=ifix(vert_num)
        fix_index1=ifix(fix_num)

        IF (initialize_flag.EQ.0.AND.(fix_axis.EQ.'Z'.OR.
     $      fix_axis.EQ.'z')) THEN
         IF (horiz_num.GT.id(162).OR.vert_num.GT.id(167)) THEN
          init_array='Y'
          horiz_index2=id(162)
          vert_index2=id(167)
	  fix_index2=id(172)
         ENDIF
        ELSEIF (initialize_flag.EQ.0.AND.(fix_axis.EQ.'Y'.OR.
     $      fix_axis.EQ.'y')) THEN
         IF (horiz_num.GT.id(162).OR.vert_num.GT.id(172)) THEN
          init_array='Y'
          horiz_index2=id(162)
          vert_index2=id(172)
	  fix_index2=id(167)
         ENDIF
        ELSEIF (initialize_flag.EQ.0.AND.(fix_axis.EQ.'X'.OR.
     $      fix_axis.EQ.'x')) THEN
         IF (horiz_num.GT.id(167).OR.vert_num.GT.id(172)) THEN
          init_array='Y'
          horiz_index2=id(167)
          vert_index2=id(172)
	  fix_index2=id(162)
         ENDIF
        ELSEIF (initialize_flag.EQ.1) THEN
         zmx=0.
         zmn=0.
         kx1=0.
         kx2=0.
         ky1=0.
         ky2=0.
         istx=0.
         isty=0.
        ENDIF
C Now initialize the array!
        IF (init_array.EQ.'Y'.AND.horiz_index2.LT.horiz_index1) THEN
         DO i=horiz_index2,horiz_index1
          DO j=1,vert_index1
            DO l=1,4
             fld_data(i,j,l)=-999.
            ENDDO
          ENDDO
         ENDDO
	ENDIF
        IF (init_array.EQ.'Y'.AND.vert_index2.LT.vert_index1) THEN
         DO i=1,horiz_index1
          DO j=vert_index2,vert_index1
            DO l=1,4
             fld_data(i,j,l)=-999.
            ENDDO
          ENDDO
         ENDDO
        ENDIF

        Return
        End
**************************************************

