      SUBROUTINE UNFLDNEW(V0,VN,M,IRS,NB,RAY,URAY,NBINS)! Unfold Doppler Ray
C 
C   subroutine to unfold doppler radial velocities
C   Described by D.W. Bargen and R.C. Brown (1980), preprints 
C   19th Radar Meteorology Conference, 278-283. 
C   Implemention of their B-algorithm of automatic unfolding
C   INPUT:
C        V0 - initial estimate of the velocity bias 
C             = wind speed * COS (AZM - wind direction) 
C        VN - nyquist velocity
C        M  - number of gates for averaging interval
C             = 10 - 20 for high shear regimes (convection) 
C             = 50 for low shear regimes (stratiform precip.) 
C        IRS- starting gate # for the unfolding <1 for whole ray> 
C        NB - number of gates to be processed starting at IRS 
C             <256 max for pre 1988 tapes, <512 max 1988 and after
C        RAY- original folded radial velocity estimates 
C   OUTPUT: 
C        URAY - unfolded radial velocity estimates
C   DUMMY ARRAY:
C        DRAY - holds the good (no noise) unfolded values for averaging
C 
      REAL RAY(NBINS),URAY(NBINS),DRAY(512) 
C 
C     CALCULATE INITIAL NUMBER OF FOLDS
C 
      n = (v0 + sign(1.,v0)*vn) / (2*vn)
C 
C     INITIALIZE VALUES FOR AVERAGING INTERVAL
C 
      VNP = VN * M
      NBP = NB + IRS    
      IF(NBP.GT.NBINS) NBP=NBINS
      V0P = V0*M
      V0PSTART = V0*M
      ISTART=0
C 
C     START PROCESSING THE RAY 
C 
      IRC=0 
      IRCNEW=0
      IRCSAVE=0
      IF(IRS.GE.1)THEN
       DO I=1,IRS
        URAY(I)=-888.8
       ENDDO
      ENDIF
C 
      NBAD=0
      DO 10 I=IRS+1,NBP 
C 
C      CHECK FOR NOISE FLAG (-888.88). 
C 
       IF(RAY(I).lt.-800.) then
C
C        SET URAY TO FLAG AND SKIP UNFOLDING
C 
         URAY(I)=-888.88 
         NBAD=NBAD+1
C 
       ELSE
C 
         IF(NBAD.GE.M)THEN
          IF(ISTART.EQ.1.OR.I.GT.20)THEN
           IF(URAY(I).GT.-800.)THEN
            V0P=URAY(I)*M
            V0=URAY(I)
            n = (v0 + sign(1.,v0)*vn) / (2*vn)
            IRCNEW=0
           ELSE
            IRCNEW=IRCSAVE
           ENDIF
          ELSE
           V0P=V0PSTART
           IRCNEW=IRC
          ENDIF
         ENDIF  
C               
         IRC=IRC+1 
         IRCNEW=IRCNEW+1
         IRCSAVE=IRCNEW
         ISTART=1
         NBAD=0
C 
         OLDURAY=URAY(I)
C 
C        CHECK IF M GOOD VALUES HAVE BEEN AVERAGED
C 
         IF(IRCNEW.GT.M+1) GO TO 15 
C 
C        IF LESS THAN M VALUES FOUND
C 
         IF(IRCNEW.gt.1) V0P=V0P+DRAY(IRC-1)-V0
         GO TO 16
C 
C        IF MORE THAN M VALUES FOUND
C 
15       V0P=V0P+DRAY(IRC-1)-DRAY(IRC-M-1) 
C 
C        DO THE UNFOLDING TESTS (N IS THE NUMBER OF FOLDS) 
C 
16       DO JL=1,3
          VP=M*(RAY(I) + 2.*N*VN) 
          IF(VP.GT.V0P+VNP) N=N-1 
          IF(VP.LT.V0P-VNP) N=N+1 
          URAY(I)=RAY(I)+2.*N*VN
         ENDDO
C
C        STORE GOOD VALUE IN DRAY
C 
         DRAY(IRC)=URAY(I) 
C 
       ENDIF
C 
10    CONTINUE
C 
      RETURN
      END 
