      subroutine make_tiff(data_form, array, idim, jdim, 
     +		ixl, iyb, ixr, iyt, nbit_pl,
     +		red, green, blue, ioutlu, ierror, outfil)
C Take an array of bytes and write a 1, 4 or 8 bit plane TIFF file.
C 1 bit not working, 4 bit TIFF not supported by many readers,
C 8 bit best to write out. 
C Compression similar to IFF (PackBits), except TIFF does not allow 
C compression of each bit plane..(in any way that i can figure out )
C TIFF files made with this program will conform to Baseline TIFF
C Revision 6.0. Arrays are encoded as "Palette-color  images".
C Input:
C Data_form = 	1 means array is packed with bytes
C	 	2 means array has one byte per i*2 word
C		3 means array is packed in nibbles in SIGMET format
C		4 means array is one nibble per word
C		5 means array is packed binary (CAN'T DO YET)
C red, green and blue hold colors in TIFF format. To read and
C convert Sigmet colors make these calls before calling this sub:
C	call tvrcmap(sigcols,16)
C	call sigcols2tiffcols(sigcols,15,red,green,blue)
C and then set red(i), i = 16, 255 to something or 0, etc.
C
	integer data_form, idim, jdim,
     +		ixl, iyb, ixr, iyt, nbit_pl, ioutlu, ierror
	integer*2 array(0:idim, 0:jdim)
	integer*2 red(0:255), green(0:255), blue(0:255)
C
	parameter(maxarr = 80000)
	integer pixels(0:647)
	integer*2 ijunk, ipos ! for mvbits
	parameter(maxcompar = 647)
	integer compar(0:maxcompar)
	character*(*) outfil
	integer*2 outarr(maxarr)
	integer ptr
	integer*2 tag(15), val_typ(15)
	integer*4  val_cnt(15), val_off(15),
     +		image_width, image_length, num_strips,
     +		rows_per_strip, num_colors, num_ch_desc
	character*20 time_string, NUL*1, desc_string, string*4
	integer*4 strip_ptr, byte_count_ptr, strip_start
	integer*2 iii, ihp_crap
C
	ierror = 0 
c Debug stuff:
c	write(6,*)' Here are arguments passed to make_tiff:'
c	write(6,*)' data_form: ', data_form, 'idim, jdim: ',idim, jdim
c	write(6,*)' ixl, iyb: ',ixl, iyb,' ixr, iyt: ', ixr, iyt
c	write(6,*)' nbit_pl: ',nbit_pl,' ioutlu: ',ioutlu
c	write(6,*)' output file name: ', outfil
	if( data_form .lt. 1 .or. data_form .gt. 4 )then
	  write(6,*)' Data format #',data_form,' unsupported.'
	  ierror = -1
	  return
	end if
	if( nbit_pl .eq. 1)then
	  write(6,*)' sorry, 1 bit plane not working yet.'
	  ierror = -10
	  return
	end if
	rows_per_strip = 10
C Later make this an arg of sub, so folks can add own title
c	NUL = Z'00'  ! string must be terminated by NUL
        NUL=CHAR(0)
	num_ch_desc = 10
	desc_string(1:10) = 'HRD Image'//NUL
C
C dimensions of array to save 
	image_width = ixr - ixl + 1
	image_length = iyt - iyb + 1
	num_colors = 2 ** nbit_pl
C Get # of pixels:
	npix = ixr - ixl  ! for dim of pixels (0:npix)
C Calculate how many i*2 words to unpack per row of pixels
	if ( data_form .eq. 1 ) then
	    nunpk = (npix + 1) / 2 ! 2 bytes per i*2 word 
	    if( (nunpk * 2) .lt. (npix + 1) ) then 
		nunpk = nunpk + 1
	    end if
	else if( data_form .eq. 3 ) then
	    nunpk = (npix + 1) / 4 ! 4 nibbles per i*2 word 
	    if( (nunpk * 4) .lt. (npix + 1) ) then 
		nunpk = nunpk + 1
	    end if
	end if
C ---------------------------
C write out TIFF header:
	string(1:2) = 'MM'
C MM - byte order MSB then LSB (HP, Motorola, etc.)
	read(string(1:2),'(a)')outarr(1)
	outarr(2) = 42
C 42 - TIFF magic number ... helps identify as TIFF file...and is the
C 		ANSWER
C	ifd_offset = 8 
	call long_to_outarr(outarr, maxarr, 3, 8)
C	num of ifd entries = 14
	outarr(5) = 14
C At present write 00 00 00 00 in 15 th IFD. Strictly speaking
C IFD is followed by 4 byte pointer to next IFD, or 4 bytes
C of zeros if only one IFD, as is case here. To facilitate adding
C entries, i will always write out 12 bytes of zero's...a waste of
C 8 bytes that can be fixed later...but must be careful about setting
C pointers corrctly, if those 8 are removed.
C now stuff for IFD
	call init_ifd(tag, val_typ, val_cnt, val_off,
     +		image_width, image_length, 
     +		rows_per_strip, num_colors, num_ch_desc,
     +		num_strips, nbit_pl)
C Now write out IFD to scratch array:
	ptr = 6  ! bytes 11 and 12
	do i = 1, 15
		outarr(ptr) = tag(i)
		outarr(ptr+1) = val_typ(i)
		call long_to_outarr(outarr,maxarr,ptr+2,val_cnt(i))
		call long_to_outarr(outarr,maxarr,ptr+4,val_off(i))
		ptr = ptr + 6
	end do
C Ptr now points to space after IFD, which I will use to store XRes,
C YRes, date string, descriptive string, colormap, and the strip
C offsets and byte counts.
C X and Y res, i set arbitrarily to 72 pixels per inch:
	call long_to_outarr(outarr, maxarr, ptr, 72)
	call long_to_outarr(outarr, maxarr, ptr+2, 1)
	call long_to_outarr(outarr, maxarr, ptr+4, 72)
	call long_to_outarr(outarr, maxarr, ptr+6, 1)
C Date string:
	ptr = ptr + 8
	write(time_string,100)1999,12,12,00,00,00,NUL
100	format(i4,':',i2,':',i2,1x,i2,':',i2.2,':',i2.2,a1)
	read(time_string,'(10a2)')(outarr(i),i=ptr, ptr+9)
C Descriptive string:
	ptr = ptr + 10
	read(desc_string(1:10),'(5a2)')(outarr(i), i= ptr, ptr+4)
C Color map
C debug:
c	write(6,*)' r, g, b: (in TIFF range )'
c	do i = 0, 15
c		write(6, 555)i,red(i),red(i), green(i),green(i), 
cd    +			blue(i), blue(i)
cd555		format(1x,i2,3(2x,i6,1x,'(',z4,')'))
c	end do
	ptr = ptr + num_ch_desc*0.5
	if( nbit_pl .eq. 4 )then
	   do i = 0, 15
		outarr(ptr+i) = red(i)
	   end do
	   ptr = ptr + 16
	   do i = 0, 15
		outarr(ptr+i) = green(i)
	   end do
	   ptr = ptr + 16
	   do i = 0, 15
		outarr(ptr+i) = blue(i)
	   end do
	   ptr = ptr + 16
	else if ( nbit_pl .eq. 8 ) then ! 
	   do i = 0, 255
		outarr(ptr+i) = red(i)
	   end do
	   ptr = ptr + 256
	   do i = 0, 255
		outarr(ptr+i) = green(i)
	   end do
	   ptr = ptr + 256
	   do i = 0, 255
		outarr(ptr+i) = blue(i)
	   end do
	   ptr = ptr + 256
	end if
C DEBUG
c	do i = 1, ptr + 16
c	  write(6,112)i,outarr(i), outarr(i)
cd112	  format(1x,i4,2x,Z4,2x,i6)
c	end do
C -----------------------------------------------------------
C Now initialize pointers for strip offsets and byte counts
	strip_ptr = ptr !  pointer to where strip offsets are stored
	byte_count_ptr = strip_ptr + num_strips * 2 ! points to byte counts
C Save for debug:
	ifrst_strip = strip_ptr
	ifrst_bytc = byte_count_ptr
C pointer to first byte of data in image strip
	strip_start = ( byte_count_ptr + num_strips * 2 -1) * 2
C so word 111 starts with byte 220, etc.
	ibyt_num = strip_start - 1 ! points to next byte to write - 1
c	write(6,*)' Initial strip_ptr, byte_count_ptr, strip_start:'
c	write(6,*) strip_ptr, byte_count_ptr, strip_start
C ---------------------------------------------------------------
C Read array from top down, compress in strips:
C Need to add some logic to allow for a last strip with less than
C rows_per_strip in the row.
	do is = iyt, iyb + rows_per_strip -1, -rows_per_strip
	  call long_to_outarr(outarr, maxarr, strip_ptr, strip_start)
	  strip_ptr = strip_ptr + 2
	  nbytes_in_strip = 0
	  do js = 0, rows_per_strip-1, 1
		j = is - js
		if( data_form .eq. 2 .or. data_form .eq. 4)then
		   do i = 0, npix
			pixels(i) = array(ixl + i, j)
		   end do
C Temporarily commneted out, so I can link without Joe's subs:
C		else if( data_form .eq. 1) then ! unpack to one byte per word
C		   call unpk8( array(ixl, j), pixels(0), nunpk)
C		else if( data_form .eq. 3 ) then ! unpack to one nibble per word
C		  call tvunp4(array(ixl, j), pixels(0), nunpk)
	        end if
		if( nbit_pl .eq. 4 ) then ! >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
C repack, two nibbles per word, to pass to run-length encoder:
		   do ii = 0, npix, 2
			iwd = ii / 2
			pixels(iwd) = ior(ishft(pixels(ii),4),
     +				pixels(ii+1) )
		   end do
		   call pack_row(pixels(0), npix/2, compar, 
     +			maxcompar, ncomp)
		else if (nbit_pl .eq. 8 ) then ! simpler packing <><><><>><>>
		   call pack_row(pixels(0), npix, compar, 
     +			maxcompar, ncomp)
		end if		! <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
		ncompressed = ncomp + 1 ! compar indexed from 0 to ncomp
Cout		ncompressed = (npix+1)/2
C I pack the bytes this way because the compressed rows do not
C neccessarily start or end on word boundaries:
		do i = 0, ncompressed-1
			ibyt_num = ibyt_num + 1
			ptr = ibyt_num /2 + 1! which word to write in
C so bytes 0,1 goes to outarr(1), etc.
Cout	write(6,*)'ptr: ',ptr
			ipos = 8 - mod(ibyt_num,2)*8 ! pick high or low byte
			ijunk = compar(i) ! mvbits won't mix i*2 and i*4
Cout			ijunk = pixels(i) ! mvbits won't mix i*2 and i*4
Cout			call mvbits(ijunk,0i,8i,outarr(ptr),ipos)
C				0i, 8i mean these are i*2 constants
C mvbits commented out and replaced for folks who compile with Sun Fortran:
			if(ipos .eq. 0) then ! pack lower byte
			  do iii = 0, 7 ! clear lower byte in outarr
			        outarr(ptr) = ibclr(outarr(ptr),iii)
				ihp_crap = iii +8
				ijunk = ibclr(ijunk, ihp_crap)
			  end do
			else if(ipos .eq. 8) then ! pack upper byte
			  do iii = 8,15
				outarr(ptr) = ibclr(outarr(ptr),iii)
			  end do
			  ihp_crap = 8
			  ijunk = ishft(ijunk,ihp_crap)
			end if
			outarr(ptr) = ior(outarr(ptr), ijunk)
		  end do		  
		  nbytes_in_strip = nbytes_in_strip + ncompressed
	   end do
c	   write(6,*)' nbytes_in_strip ',nbytes_in_strip
C now we have to write strip offset and byte counts out:
	   call long_to_outarr(outarr, maxarr,byte_count_ptr,
     +		nbytes_in_strip)
	   byte_count_ptr = byte_count_ptr + 2
	   strip_start = strip_start +  nbytes_in_strip ! ibyt_num - 1 ! -1 cause 1 added in loop
c	   write(6,*)' strip_start: ',strip_start
C is this right? what if not on word bndry?
	end do
	nrem_rows = num_strips * rows_per_strip - image_length
	if( nrem_rows .gt. 0) then
	end if
C Debug
c	WRITE(6,*)' Number of strips: ', num_strips
c	WRITE(6,*)' pausing'
c	READ(5,*)
cd500	format(1x,'Strip # ',1x,'Strip ptr',1x,'Byte Count')
cd510	format(1x,4x,i4,1x,1x,i8,1x,2x,i8)
c	write(6,500)
c	do i = 1, num_strips
c	  ip1 = ifrst_strip + (i-1)*2
c	  it1 = outarr(ip1)
c	  it2 = outarr(ip1 + 1)
c	  iw1 = ior( ishft(it1, 16), it2)
c	  ip2 = ifrst_bytc + (i-1)*2
c	  iw2 = ior( ishft(outarr(ip2), 16), outarr(ip2+1) )
c	  write(6,510)i, iw1, iw2
c	end do
C Finally, write outarr to output file.
	ioerror = 0
	nwds = ( strip_start ) / 2
C I assumed that strip_start (= # byte sin tiff) would always be even, but
C that is not so, so I have to add this test to make sure last byte is 
C written out! p dodge 31 March 1999
	if( iand(strip_start,1) .eq. 1) then
		nwds = nwds + 1
	end if
c	write(6,*)' Total # words : ',nwds
	open(unit=ioutlu,file=outfil,err=900,iostat=ioerr,
     +        	 access = 'direct', recl = 256,
     +		 form='formatted', status = 'new')
	go to 910
900	write(6,*)' Error ',ioerr,' opening output file. '
	ioerror = ioerr
	return
910	write(6,*)' file opened. '
	nlines = nwds/128
	nrem = nwds - nlines * 128
	nrec = 0
	do j = 1, nlines
		ibeg = (j-1) * 128 + 1
		iend = j * 128
		nrec = nrec + 1
		write(ioutlu, 111, rec = nrec)
     +			(outarr(i), i = ibeg, iend)
	end do
	if(nrem .gt. 0)then
	   nrec = nrec + 1
	   write(ioutlu, 111, rec = nrec)
     +		(outarr(i), i = iend+1, iend + nrem)
	end if
111	format(128(a2))
	close( ioutlu )
	return
	end 
C ------------------
	subroutine init_ifd(tag, val_typ, val_cnt, val_off,
     +		image_width, image_length, 
     +		rows_per_strip, num_colors, num_ch_desc,
     +		num_strips, num_bitpl)
C
	integer*2 tag(15), val_typ(15)
	integer*4  val_cnt(15), val_off(15),
     +		image_width, image_length, num_strips,
     +		rows_per_strip, num_colors, num_ch_desc, num_bitpl
	integer*4 desc_string_ptr, first_offset_ptr,
     +		first_byt_cnt_ptr, xres_ptr, first_red_ptr,
     +		date_ptr
C Note I use I*4 often because that is default on HP-835
C i*2 values in val_off must be shifted up 16 bits
C Initialize Image File Directory. 
C Note that this in F77 is equivalent to the spec in tiff doc, which is
C num_strips = Floor[ (image_length + rows_per_strip -1 ) / rows_per_strip ]
	num_strips = (image_length + rows_per_strip -1 ) / 
     +		rows_per_strip
C Figure out where I will put stuff:
C 8 byte header + 2 byte IFD count + IFD count * 12 bytes
	istart_ptr = 8 + 2 + 15*12 
C Pointers to data structures for various fields:
	xres_ptr = istart_ptr
	date_ptr = xres_ptr + 16
	desc_string_ptr = date_ptr + 20
	first_red_ptr = desc_string_ptr + num_ch_desc
	first_offset_ptr = first_red_ptr + num_colors * 3 * 2
	first_byt_cnt_ptr = first_offset_ptr + 4 * num_strips
C
	do i = 1, 15
		val_typ(i) = 4
		val_cnt(i) = 1
	end do
C IFD required fields ( page 23 of TIFF 6.0 Specification )
C	2 bytes with # of fields, followed by 12 byte field entries
C in numerical order:
C	ImageWidth	256
	tag(1) = 256
	val_off(1) = image_width	
C	ImageLength	257
	tag(2) = 257
	val_off(2) = image_length
C	BitsPerSample	258
	tag(3) = 258
	val_typ(3) = 3		! i*2 word
	val_off(3) = num_bitpl
	val_off(3)  = ishftc(val_off(3), 16, 32) ! make i*2 ok
C	Compression	259
	tag(4) = 259
	val_typ(4) = 3		! i*2 word
	val_off(4) = 32773  ! PackBits compression
Cout	val_off(4) = 1
	val_off(4)  = ishftc(val_off(4), 16, 32)
C	PhotometricInterpretation	262
	tag(5) = 262
	val_typ(5) = 3		! i*2 word
	val_off(5) = 3	! Palette-color iamge (needs color LUT)
	val_off(5)  = ishftc(val_off(5), 16, 32)
C ImageDescription 270
	tag(6) = 270
	val_typ(6) = 2	! ASCII string
	val_cnt(6) = num_ch_desc ! # of characters in string 
C Note: string must be terminated by NUL
	val_off(6) = desc_string_ptr
C	StripOffsets	273
	tag(7) = 273
	val_cnt(7) = num_strips
	val_off(7) = first_offset_ptr
C	RowsPerStrip	278
	tag(8) = 278
	val_off(8) = rows_per_strip
C	StripByteCounts 279
	tag(9) = 279
	val_cnt(9) = num_strips
	val_off(9) = first_byt_cnt_ptr
C	XResolution	282
	tag(10) = 282
	val_typ(10) = 5	! Rational number (two i*4's, num and denom)
	val_off(10) = xres_ptr
C	YResolution	283
	tag(11) = 283
	val_typ(11) = 5	! Rational number (two i*4's, num and denom)
	val_off(11) = xres_ptr + 8
C	ResolutionUnit	296
	tag(12) = 296
	val_typ(12) = 3
	val_off(12) = 2	! means inches
	val_off(12)  = ishftc(val_off(12), 16, 32)
C	DateTime	306
	tag(13) = 306
	val_typ(13) = 2
	val_cnt(13) = 20
	val_off(13) = date_ptr
C	ColorMap	320
	tag(14) = 320
	val_typ(14) = 3
	val_cnt(14) = 3 * num_colors  ! 48 or 768
	val_off(14) = first_red_ptr
C	Next IFD offset, which is zero because I only put
C one image per file and do not mess around with fancy sub files or
C masks. See TIFF 6.0 document if you want to change!
	tag(15) = 0
	val_typ(15) = 0
	val_cnt(15) = 0
	val_off(15) = 0
	return
	end
C --------------
	subroutine sigcols2tiffcols(sigcols,ncols,red,green,blue)
C Convert 5 bit Sigmet color table to 16 bit TIFF color table
C In TIFF (0,0,0) = black, (65535, 65535, 65535) = white.
      integer*4 ncols,sigcols(0:ncols)
	integer*2 red(0:ncols), green(0:ncols),
     +		blue(0:ncols) 
      do i = 0, ncols
	if( sigcols(i) .eq. 32767 ) then ! special case to preserve white
	  red(i) = -1
	  blue(i) = -1
	  green(i) = -1
	else
	  ratio = iand(sigcols(i),31) / 31.0
	  icol = ratio * 32767
          red(i) = ishft(icol, 1)
	  ratio = iand(ishft(sigcols(i),-5),31) / 31.0
	  icol = ratio * 32767
	  green(i) = ishft(icol, 1)
	  ratio = iand(ishft(sigcols(i),-10),31) / 31.0
	  icol = ratio * 32767
	  blue(i) = ishft(icol, 1)
	end if
      end do
      return
      end 
C ----------------------
	subroutine long_to_outarr(outarr, maxarr, ptr, value)
	integer*2 outarr(maxarr), sh_temp(2)
	integer*4 ptr, value, temp
	equivalence (sh_temp, temp)
C all this to write one i*4 word in two i*2 words
C probably could do with mvbits...
	temp = value
	outarr(ptr) = sh_temp(1)
	outarr(ptr+1) = sh_temp(2)
	return
	end
C -- Packing subroutines: -----
	subroutine pack_row(bits, nbytes, compar, maxcomp, ncomp)
C Fortran 77 version of packer.c from CBM IFF disk (Fred Fish # 184)
	integer nbytes, ncomp, maxcomp
	integer bits(0:nbytes), compar(0:maxcomp), buf(0:256)
	integer current, lastc, mode, dump, run, row_size, outptr,
     +		rstart
	parameter( dump = 0, run = 1, min_run = 3, max_run = 128,
     +		max_dat = 128)
C
	rstart = 0
	row_size = nbytes + 1
	mode = dump
	outptr = 0
	current = bits(0)
	lastc = current
	buf(0) = lastc
	nbuf = 1
	inptr = 1
	row_size = row_size - 1
Cout	do while( row_size .gt. 0)
	do while( inptr .le. nbytes )
		current = bits( inptr )
		inptr = inptr + 1
		buf(nbuf) = current
		nbuf = nbuf + 1
		row_size = row_size - 1
C DUMP:
		if( mode .eq. dump ) then
		  if( nbuf.gt. max_dat ) then
			call PutDump(buf,nbuf-1,compar,maxcomp,outptr)
			buf(0) = current
			nbuf = 1
			rstart = 0
		  else if(current .eq. lastc) then
		    if( nbuf - rstart .ge. min_run) then
			if( rstart .gt. 0) then
				call PutDump(buf,rstart,compar,
     +					maxcomp,outptr)
			end if
			mode = run
		    else if(rstart .eq.  0) then
			mode = run
		    end if
		  else
		    rstart = nbuf - 1
		  end if
C RUN:
		else if(mode .eq. run)then
		  if( ( current .ne. lastc) .or. 
     +			(nbuf - rstart .gt. max_run) ) then
			call PutRun(nbuf-1-rstart,lastc,
     +				compar,maxcomp,outptr)
			buf(0) = current
			nbuf = 1
			rstart = 0
			mode = dump
		  end if
		end if
		lastc = current
	end do
C now dump the last stuff
	if( mode .eq. dump) then
		call PutDump(buf,nbuf,compar, maxcomp, outptr)
	else
		call PutRun(nbuf-rstart,lastc,compar,maxcomp, outptr)
	end if
	ncomp = outptr - 1 ! because outptr always pointed to next byte
	return
	end
C -------------------------------------------------------
	subroutine PutRun( nr, ival, dest, maxout, outptr)
	integer nr, ival, dest(0:maxout), outptr
C
	dest(outptr) = - (nr -1)
	dest(outptr+1) = ival
	outptr = outptr + 2
	return
	end
C -------------------------------------------------------
	subroutine PutDump(buf, nd, dest,maxout, outptr)
	integer buf(0:128), nd, dest(0:maxout), outptr
C
	dest(outptr) = nd - 1
	do i = 0, nd-1
		outptr = outptr + 1
		dest(outptr) = buf(i)
	end do
	outptr = outptr + 1
	return
	end
