      SUBROUTINE SWEEPIN(SWEEP,SWEEPZ,MAX_RAYS,MAX_GATES,NUM_RAYS,RDTAI,
     + AZ_EL,ICALLSWEEPIN,NUMREC,VRRAD,UNFVEL,TMP1,TMP2,JINDEX,
     + JIINDEX,NYQ,ILATERSWEEP,SWEEPSAVE,U,V,W,IMX,JMX,KMX,SX,SY,SZ,
     + OLAT,OLON,XZ,YZ,ZZ,IUSEWIND,EAZM,EEV,TMSWEEP,RRLAT,RRLON,RRA,
     + SMOTIONU0,SMOTIONV0,CENTIME0,PELEV,MAXI,ANGTEST,AZMSLOPE,
     + RADALTDIFF,NSWEEPSUMS,SWEEPTESTS,SWEEPTESTS2,
     + SWEEPZTEST,SWEEPZTEST2,ZLOW,ZHIGH,HB2,DPB2)
C 
C     Doppler/Reflectivity processing program. 
C     This program reads the radar tapes and writes rays of Doppler data on
C     disc.  The file contains time in seconds, radar altitude in meters, 
C     latitude and longitude in degrees, earth relative azimuths in degrees,
C     earth relative elevation in degrees and 256 doppler velocities at 300
C     meter intervals.  The data is written to disc and then transfer via 
C     ftp to NCEP.
C 
C     To use: ncepwrite_file ncepwrite_file.job
C     ncepwrite_file.job - data file containing input information. 
C 
C  Subroutines use: 
C     READTAPE - Reads merged tapes and returns 1 record.
C 
C  Logical units: 
C     unit(1) - user's terminal 
C     unit(LUNR) - tape drive LU #
C     unit(LP) - line printer LU #. (6/7 dot-matrix printer)
C  Variables in Common Block and Main Program:
C     NIX - Flag for end-of-file/end-of-tape.(NIX=-100).
C     NGATE1 - Gate number to start mapping the data, for negative range del.
C     IFLT/INM - Flight date/ project name.
C     STIME/ETIME - Starting/Ending times of disc file in seconds.
C     WD/WS - Wind direction(deg) and Wind Speed (m/s).
C     IVT - flag to calculate  and subtract the terminal velocity (y/n).
C     RAMFL - flag to open and read the ram data with the GPS information.
C     XR,YR,ZR - east-west,north-south,and vertical distances of radar gate
C      from the radar
C 
      COMMON /AREA1/ INM,IFLT,STIME,ETIME,WD,WS,NIX,NGATE1,LP,LUNR,
     +               IVT,RAMFL
      COMMON /TAPEHEADER/ nbytesheader,ntape,nversion,ihheader,imheader,
     +                    isheader,ine,ndrive,naircraft,flightid,stmname
     +                    ,nsamplelf,nsampleta,refslopelf,refslopeta,
     +                    refnoisethreslf,refnoisethresta,sqilf,sqita,
     +                    widththreslf,widththresta,caliblf,calibta,
     +                    modedatalf,modedatata,noisetmlf,noisetmta,
     +                    rpmlf,rpmta,gtlnlf,ivrangelf,ivrangeta,
     +                    gtlnta(3),rdellf,rdelta,rdelcorlf,rdelcorta,
     +                    nbinlf,nbinta,nbins,rmaxlf,rmaxta,
     +                    radiita(512),radiilf(512),prf_flaglf,
     +                    prf_flagta,prf_highlf,prf_highta,xniqlf,
     +                    xniqta,iheader(1024)
      COMMON /RAYHEADER / nbytesdata,nlfsweep,ntasweep,numrecord,
     +                    irecflag,idradar,nbytesray,icode,idsp,mdata,
     +                    iyear,month,iday,iraycode,radtime,ih,im,is,
     +                    is100,radlat,radlon,radalt,gse,gsn,radgs,
     +                    radvgs,ucom,vcom,radwd,radws,radvws,ircu,
     +                    elev,radazm,pitch,roll,drift,heading,
     +                    dbzbuffer(512),velbuffer(512),widthbuffer(512)
      COMMON /PARAMS/ trakazm,trakelev,driftnew,
     +                rot,track,htbb,dbb,thresh,swthresh,dbzrs,ibst(2),
     +                inob(2),ileg,xniq,irsw,maxnbins,v0,
     +                pcor,dcor,rcor,azmcor,elcor,dbzcor,dbzslope,
     +                iunfoldflag,iattenflag,
     +                badstabflag,surfelimflag,echoflag,atmflag
      common /tsearch/ kountrec,firstsweep(2),keylf(1024,2),
     +                 keyta(4096,2),
     +                 numsweep(2),itimex(2),lastpoint(2),
     +                 iheadertime,ioldsweep(2),kwords,nwords,krays,
     +                 ibuf(2048)
      LOGICAL badstabflag, surfelimflag, echoflag, atmflag
      REAL TIMEONE,RLATONE,RLONONE,RAONE,AZMONE,EVONE
      REAL BINONE(512),REFONE(512)
      REAL RDVWS(800),RDUCOM(800),RDVCOM(800),RDGS(800)
      REAL SWEEPVT(512,800)
      INTEGER FASTON
      INTEGER IAZM(800)
      INTEGER*2 IHEADER
      INTEGER OLDTIME,IITEST(5),JJTEST(5),IKEEP(512,800)
      INTEGER PRF_FLAGLF, PRF_FLAGTA
      REAL UNFVEL(MAX_GATES,MAX_RAYS)
      REAL TMP1(MAX_GATES,MAX_RAYS),TMP2(MAX_GATES,MAX_RAYS)
      INTEGER JINDEX(MAX_GATES,MAX_RAYS),JIINDEX(MAX_GATES,MAX_RAYS)
      REAL SWEEP(MAX_GATES,MAX_RAYS),RDTAI(512),AZ_EL(2,MAX_RAYS)
      REAL PAZM(MAX_RAYS)
      REAL PELEV(MAX_RAYS),RDTAIIN(512)
      REAL SWEEPSAVE(MAX_GATES,MAX_RAYS)
      REAL PCORS(2),DCORS(2),RCORS(2)
      REAL AZMCORS(2),RDELCORTAS(2),ELCORS(2)
      REAL RAY(512),URAY(512),V0SAVE(800)
      REAL VRRAD(512,800),NYQ(512,800)
      REAL VROUT(512,800)
      INTEGER*2 ISWEEP(512,800)
      REAL XRSWEEP(512,800),YRSWEEP(512,800),ZRSWEEP(512,800)
      REAL XRMIN(512,800),YRMIN(512,800),ZRMIN(512,800)
      REAL XRMAX(512,800),YRMAX(512,800),ZRMAX(512,800)
      REAL AZMIN(512,800),AZMAX(512,800)
      REAL SWEEPZ(512,800),ZDIFF(512,800)
      REAL ZMIN(512,800),ZMAX(512,800)
      REAL XR(512),YR(512),ZR(512)
      REAL U(IMX,JMX,KMX),V(IMX,JMX,KMX),W(IMX,JMX,KMX)
      REAL EAZM(800),EEV(800),RRLAT(800),RRLON(800),RRA(800)
      REAL TMSWEEP(800),SWEEPTESTS(20),SWEEPZTEST(20)
      REAL SWEEPTESTS2(20),SWEEPZTEST2(20)
      REAL SWEEPSUM(20),SWEEPZSUM(20)
      REAL SWEEPSUM2(20),SWEEPZSUM2(20)
      INTEGER NSWEEPSUMS(20)
      INTEGER ISEG(512,800),ISEGB(512,800),ISEGE(512,800)
      CHARACTER*7 IFLTCHK,IFLTCHK2
      CHARACTER*1 CAIRCRAFT(3)
      CHARACTER CDUMMY*80
      CHARACTER FLIGHTID*8,STMNAME*16,DUMMYREAD*1
      CHARACTER IFLT*8, INM*12
      CHARACTER *1 TAPE, RAMFL, IVT, IATTEN
      CHARACTER *80 NAMERAM, IFILE, NAMEO
      CHARACTER*80 RADARFILE
      DIMENSION BIN(512),REF(512),BIN1(512),REF1(512)
      SAVE ISWEEPCHECK,BINONE,REFONE,TIMEONE,RLATONE,RLONONE
      SAVE RAONE,AZMONE,EVONE,RCAZM,AZELONE,AZELTWO,PELEVONE
      SAVE ICONSERVE,ITAPEOPEN,RDTAIIN,RADTEST,RADTEST2
      SAVE V0ONE,PAZMONE,IFRANCE
      SAVE PCORS,DCORS,RCORS,RDELCORTAS,AZMCORS,ELCORS
      SAVE TIME,TIMES,WFLAG,SWEEPSUM,SWEEPZSUM,SWEEPSUM2,SWEEPZSUM2
      SAVE IHS,IMS,ISS,IHE,IME,ISE
      SAVE IFASTCHECK,RDVWS,RDVWSONE,RDUCOMONE,RDVCOMONE,RDGSONE
      SAVE IFLIGHTCHECK,IADD86400
      DATA AT1/5.33E-5/, AT2/0.889/
      CAIRCRAFT(1)='H'
      CAIRCRAFT(2)='I'
      CAIRCRAFT(3)='?'
      IMAXBINS=512
      JMAXRAYS=800
      SXBIG=SX
      NB1=10
c      DO K=1,KMX
c       DO J=1,JMX
c        WRITE(6,*)'J,K,U = ',J,K,(U(I,J,K),I=1,IMX)
c       ENDDO
c      ENDDO
      IF(SY.GT.SXBIG)SXBIG=SY
      SUMXI=0.
      SUMYI=0.
      SUMXYI=0.
      SUMXI2=0.
      SUMZI=0.
      SUMELEV=0.
      NUMRADALT=0.
      NSUMSLOPE=0.
      XIMIN=0.
      XIMAX=0.
      IF(ICALLSWEEPIN.EQ.0)THEN
       DO I=1,20
        SWEEPSUM(I)=0.
        SWEEPZSUM(I)=0.
        SWEEPSUM2(I)=0.
        SWEEPZSUM2(I)=0.
        NSWEEPSUMS(I)=0
       ENDDO
       IFASTCHECK=0
       IFILECHECK=0
       RADTEST=-1.
       RADTEST2=-1.
       IFRANCE=0
       IFLIGHTCHECK=0
      ELSE
       IFILECHECK=1
       IFLIGHTCHECK=1
       DO I=1,20
        IF(NSWEEPSUMS(I).GT.0)THEN
         SWEEPTESTS(I)=SWEEPSUM(I)/NSWEEPSUMS(I)
         SWEEPZTEST(I)=SWEEPZSUM(I)/NSWEEPSUMS(I)
         SWEEPTESTS2(I)=SWEEPSUM2(I)/NSWEEPSUMS(I)
     1                  -SWEEPTESTS(I)*SWEEPTESTS(I)
         SWEEPZTEST2(I)=SWEEPZSUM2(I)/NSWEEPSUMS(I)
     1                  -SWEEPZTEST(I)*SWEEPZTEST(I)
         IF(SWEEPTESTS2(I).GT.0.)THEN
          SWEEPTESTS2(I)=SQRT(SWEEPTESTS2(I))
         ELSE
          SWEEPTESTS2(I)=0.00
         ENDIF
         IF(SWEEPZTEST2(I).GT.0.)THEN
          SWEEPZTEST2(I)=SQRT(SWEEPZTEST2(I))
         ELSE
          SWEEPZTEST2(I)=0.00
         ENDIF
        ELSE
         SWEEPTESTS(I)=-888.8
         SWEEPTESTS2(I)=-888.8
         SWEEPZTEST(I)=-32.
         SWEEPZTEST2(I)=-32.
        ENDIF
       ENDDO
c ****Today 18 Jan 2007
       WRITE(6,*)'NSWEEPSUMS = '
       WRITE(6,8110)(NSWEEPSUMS(I),I=1,20)
8110   FORMAT(8I10)
       WRITE(6,*)'RADIITA = '
       WRITE(6,6527)(RADIITA(I),I=1,20)
       WRITE(6,*)'SWEEPTESTS = '
       WRITE(6,6527)(SWEEPTESTS(I),I=1,20)
       WRITE(6,*)'SWEEPZTEST = '
       WRITE(6,6527)(SWEEPZTEST(I),I=1,20)
       WRITE(6,*)'SWEEPTESTS2 = '
       WRITE(6,6527)(SWEEPTESTS2(I),I=1,20)
       WRITE(6,*)'SWEEPZTEST2 = '
       WRITE(6,6527)(SWEEPZTEST2(I),I=1,20)
6527   FORMAT(8F10.3)
c ****Today 18 Jan 2007
      ENDIF
      IF(IUSEWIND.EQ.1)THEN
       SMOTIONU=SMOTIONU0
       SMOTIONV=SMOTIONV0
       CENTIME=CENTIME0
      ELSE
       SMOTIONU=0.
       SMOTIONV=0.
       CENTIME=CENTIME0
      ENDIF
      DO I=1,800
       RDVWS(I)=-999.9
      ENDDO
      deg2rad = acos(-1.0) / 180.0
      rad2deg = 1.0 / deg2rad
      half_beam_ta = 0.8 ! degrees, vertical
      half_beam_lf = 2.05 ! degrees, vertical
      beam_wid = 2.0 * half_beam_ta
      WFLAG=-1.0E+10
C 
C DOPPLER processing program
c      write(6,*)'icallsweepin = ',icallsweepin
      ISWEEPSET=2
      SWEEPOLD=0.
      NUM_RAYS=0
      DO I=1,MAX_GATES
       DO J=1,MAX_RAYS
        SWEEP(I,J)=-888.8
        SWEEPZ(I,J)=-32.0
       ENDDO
      ENDDO
c      write(6,*)'imx,jmx,kmx = ',imx,jmx,kmx
c      write(6,*)'sx,sy,sz = ',sx,sy,sz
c      write(6,*)'xz,yz,zz = ',xz,yz,zz
      IF(ICALLSWEEPIN.EQ.1)THEN
       NUM_RAYS=1
       RLAT=RLATONE
       RLON=RLONONE
       EAZM(1)=AZMONE
       EEV(1)=EVONE
       RRLAT(1)=RLAT
       RRLON(1)=RLON
       RRA(1)=RAONE
       RDGS(1)=RDGSONE
       RDVWS(1)=RDVWSONE
       RDUCOM(1)=RDUCOMONE
       RDVCOM(1)=RDVCOMONE
       TMSWEEP(1)=TIMEONE
       RA=RAONE
       RDUCOMONE=UCOM
       RDVCOMONE=VCOM
       RDGSONE=RADGS
       RDVWSONE=RADVWS
       AZM=AZMONE
       EV=EVONE
       V0SAVE(1)=V0ONE
       IF(IBST(1).GE.1)THEN
        DO I=1,IBST(1)
         SWEEP(I,1)=-888.8
         SWEEPZ(I,1)=-32.
        ENDDO
       ENDIF
       DO I=IBST(1)+1,NB1
        SWEEP(I,1)=BINONE(I)
        SWEEPZ(I,1)=REFONE(I)
       ENDDO
       IF(NB1.LT.512)THEN
        DO I=NBINS+1,512
         SWEEP(I,1)=-888.8
         SWEEPZ(I,1)=-32.
        ENDDO
       ENDIF
c       DO I=1,512-IBST(1)
c        SWEEP(I,1)=BINONE(I+IBST(1))
c        SWEEPZ(I,1)=REFONE(I+IBST(1))
c       ENDDO
       OOLAT=RLAT
       OOLON=RLON
       TIMES=TIME
       IF(IUSEWIND.NE.1)CENTIME=TIMES
       ISCANDIM=512
       IBINS=512
       AZ_EL(1,1)=AZELONE
       AZ_EL(2,1)=AZELTWO
       PELEV(1)=PELEVONE
       PAZM(1)=PAZMONE
c       write(6,*)'calling vrlocate'
c       write(6,*)'olat,olon = ',olat,olon
c       write(6,*)'rlat,rlon = ',rlat,rlon
c       write(6,*)'ra,ev,azm = ',ra,ev,azm
       IF(IUSEWIND.EQ.1)THEN
        ISCANNBINS=10
        CALL VRLOCATER(TIMES,OLAT,OLON,
     +  RLAT,RLON,RA,EV,AZM,RDTAIIN,XR,YR,ZR,
     +  ISCANNBINS,SMOTIONU,SMOTIONV,CENTIME,BIN,REF)
c        WRITE(6,*)'OLAT,OLON = ',OLAT,OLON
c        WRITE(6,*)'RLAT,RLON = ',RLAT,RLON
c        WRITE(6,*)'SMOTIONU,SMOTIONV,CENTIME = ',
c     +   SMOTIONU,SMOTIONV,CENTIME
c        WRITE(6,*)'RAY 1 SPOT,TIMES,RA,AZM,EV,XR,YR,ZR AT 20 = ',
c     +   TIMES,RA,AZM,EV,XR(20),YR(20),ZR(20)
        RADIANEV=EV*3.14159/180.
        RADIANAZM=AZM*3.14159/180.
        DIRCOSX=COS(RADIANEV)*COS(RADIANAZM)
        DIRCOSY=COS(RADIANEV)*SIN(RADIANAZM)
        DIRCOSZ=SIN(RADIANEV)
        XMIN=-XZ
        YMIN=-YZ
        XMAX=-XZ+IMX*SX
        YMAX=-YZ+JMX*SY
        ZZMAX=ZZ+(KMX-1)*SZ
C       WRITE(6,*)'SX,SY,SZ,XZ,YZ,ZZ = ',SX,SY,SZ,XZ,YZ,ZZ
C       WRITE(6,*)'XMIN,YMIN,ZZMIN = ',XMIN,YMIN,ZZMIN
C       WRITE(6,*)'XMAX,YMZX,ZZMAX = ',XMAX,YMAX,ZZMAX
        DO IR=1,10
         IF(BIN(IR).GT.-800.)THEN
          IINT=INT((XR(IR)+XZ+.5*SX)/SX)
          JINT=INT((YR(IR)+YZ+.5*SY)/SY)
          KINT=1+INT((ZR(IR)-ZZ)/SZ)
          VRRAD(IR,1)=0.
          VRSUM=0.
          DO I=IINT,IINT+1
           DO J=JINT,JINT+1
            DO K=KINT,KINT+1
             IF(I.GE.1.AND.I.LE.IMX)THEN
              IF(J.GE.1.AND.J.LE.JMX)THEN
               IF(K.GE.1.AND.K.LE.KMX)THEN
                IF(U(I,J,K).GT.WFLAG)THEN
                 XG=(I-1)*SX-XZ+.5*SX
                 YG=(J-1)*SY-YZ+.5*SY
                 ZG=(K-1)*SZ+ZZ
                 XI=XR(IR)-XG
                 YI=YR(IR)-YG
                 ZI=ZR(IR)-ZG
                 RADR=SQRT(XR(IR)*XR(IR)+YR(IR)*YR(IR))
                 RADG=SQRT(XG*XG+YG*YG)
                 VRAD=(U(I,J,K)*XG+V(I,J,K)*YG)/RADG
                 VTAN=(V(I,J,K)*XG-U(I,J,K)*YG)/RADG
                 URAD=(VRAD*XR(IR)-VTAN*YR(IR))/RADR
                 VRAD=(VRAD*YR(IR)+VTAN*XR(IR))/RADR
                 DISTPOINT=SQRT(XI*XI+YI*YI+ZI*ZI)
                 IF(DISTPOINT.GT.0.)THEN
                  RINT=1./DISTPOINT
                 ELSE
                  RINT=1000000.
                 ENDIF
                 VRRAD(IR,1)=VRRAD(IR,1)+
     1              RINT*(URAD*DIRCOSX+VRAD*DIRCOSY+
     1              W(I,J,K)*DIRCOSZ)
                 VRSUM=VRSUM+RINT
                ENDIF
               ENDIF
              ENDIF
             ENDIF
            ENDDO
           ENDDO
          ENDDO
          IF(VRSUM.GT.0.)THEN
           VRRAD(IR,1)=VRRAD(IR,1)/VRSUM
          ELSE
           VRRAD(IR,1)=-888.8
          ENDIF
         ELSE
          VRRAD(IR,1)=-888.8
         ENDIF
        ENDDO
        ISCANNBINS=NB1
        CALL VRLOCATER(TIMES,OOLAT,OOLON,
     +  RLAT,RLON,RA,EV,AZM,RDTAIIN,XR,YR,ZR,
     +  ISCANNBINS,SMOTIONU,SMOTIONV,CENTIME,BIN,REF)
        DO I=1,512
         XRSWEEP(I,1)=XR(I)
         YRSWEEP(I,1)=YR(I)
         ZRSWEEP(I,1)=ZR(I)
        ENDDO
       ENDIF
      ENDIF
      IF(ICALLSWEEPIN.EQ.0)THEN
       ISWEEPSET=0
       OPEN(1,FILE='/dev/null')
       IF(IUSEWIND.NE.1)THEN
c        WRITE(6,*)'be conservative on first pass y(1)/n(0)'
c        READ(5,*)ICONSERVE
        ICONSERVE=1
       ELSE
        ICONSERVE=0
       ENDIF
c       WRITE(6,*)'Enter job file name'
c       READ(5,'(A80)')IFILE
       IFILE='jobfile_radar'
       OPEN(84,FILE=IFILE,IOSTAT=IERR,ERR=998,STATUS='OLD')
C The Following Parameters are read from input file  - ncepwrite_file.job
C Read Flight ID and Storm Name
      READ(84,'(A8)')IFLT
      READ(84,'(A12)')INM
      DO JIJ=1,7
       READ(84,'(A1)')DUMMYREAD
      ENDDO
C      READ(84,'(A8,1X,A12)',IOSTAT=IERR,ERR=999) IFLT,INM
C Read Line Printer LU#, Tape LU# & flag for printing parameters
       LP=6
       READ(84,*)LUNRT
C       READ(84,'(I2,1X,I2)',IOSTAT=IERR,ERR=999) LP,LUNRT
C1       READ(84,*)ITAPEOPEN
C       IF(LUNRT.GT.6)THEN
C        WRITE(6,*)'YOU ARE USING TAPE DRIVE ',LUNRT
C        WRITE(6,*)'IF CORRECT ENTER 1, OTHERWISE 0'
C        READ(5,*)ILUNRT
C        IF(ILUNRT.NE.1)THEN
C         WRITE(6,*)'REENTER TAPE DRIVE UNIT NUMBER'
C         WRITE(6,*)'IF YOU MEANT TO USE A FILE ENTER 0'
C         READ(5,*)LUNRT
C        ENDIF
C       ELSE
C        WRITE(6,*)'YOU WILL BE READING FROM A RADAR FILE'
C       ENDIF
C       READ(84,'(A80)')RADARFILE
       RADARFILE='DUMMY'
       IF(LUNRT.GT.6)THEN
        ITAPEOPEN=1
       ELSE
        ITAPEOPEN=0
       ENDIF
c       IF(ITAPEOPEN.EQ.1)THEN
c        CALL TAPEOPEN(LUNRT,0,LUNR)
c        CALL TAPECONTROL(LUNR,2,1) !back up 1 file
c       ELSE
c        OPEN(80,FILE=RADARFILE,FORM='UNFORMATTED',RECL=2,
c     1       ACCESS='DIRECT')
c       ENDIF
       WRITE(LP,'(1X,"NCEP program to write doppler on disc: ",A)')
     +      IFILE
       WRITE(LP,'(2X,"Date:",1X,A8,2X,"Name: ",A12,/,
     +        2X,"Line-Printer:",1X,I2,2X,"Tape-LU#:",I2)')
     + IFLT,INM,LP,LUNRT
C Read Ram File Flag{Y/N} and the Ram File Name 
C       READ(84,'(A1,1X,A80)',IOSTAT=IERR,ERR=999) RAMFL,NAMERAM 
C       IF(RAMFL.EQ.'y')RAMFL='Y'
C       IF(RAMFL.EQ.'n')RAMFL='N'
       RAMFL='N'
C      CALL CASEFOLD(RAMFL)
C Open the Ram File 
       IF (RAMFL .EQ. 'Y') THEN
          CALL OPENRAMFILE(NAMERAM,LP,STIMERAM,ETIMERAM,DATARATE,IERR)
          IF (IERR .NE. 0) GO TO 1050
          WRITE(LP,'(2X,"RAMFL= ",A1,1X,A80)') RAMFL,NAMERAM
       ENDIF 
C Read Unfolding Flag{Y/N},first guess wind and speed
C       READ(84,*,IOSTAT=IERR,ERR=999) IUNFOLDFLAG,WD,WS
C       INFOLDFLAG=1
       WD=0.
       WS=1.
       iunfoldflag=0
       WRITE(LP,'(2X,"IUNFOLDFLAG= ",I1," WD= ",F6.1," WS= ",F6.1)')
     +      IUNFOLDFLAG,WD,WS
C Read the starting bin and the number of bins for averaging
       READ(84,*,IOSTAT=IERR,ERR=999) IBST(1),INOB(1) 
       WRITE(LP,'(2X,"IBST= ",I4," INOB= ",I4)') IBST(1),INOB(1)
C Enter AZM, Elevation & rdel corrs.
       READ (84,*,IOSTAT=IERR,ERR=999) AZMCORS(1),ELCORS(1),
     +                                  RDELCORTA
       WRITE(LP,'(2X,"TA AZMCOR=",F6.2,2X,"ELCOR= ",F6.2,
     +      2X,"RDELCORTA= ",F6.2)') AZMCORS(1),ELCORS(1),
     +                               RDELCORTA
C Enter Pitch, drift and roll corrections:
       READ (84,*,IOSTAT=IERR,ERR=999) PCORS(1),DCORS(1),RCORS(1)
       WRITE(LP,'(2X,"TA PCOR= ",F5.1,2X,"DCOR= ",F5.1,
     +      2X,"RCOR= ",F5.1)') PCORS(1),DCORS(1),RCORS(1)
C Enter AZM, Elevation & rdel corrs.
       READ (84,*,IOSTAT=IERR,ERR=999) AZMCORS(2),ELCORS(2),
     +                                  RDELCORTA
       WRITE(LP,'(2X,"TF AZMCOR=",F6.2,2X,"ELCOR= ",F6.2,
     +      2X,"RDELCORTA= ",F6.2)') AZMCORS(2),ELCORS(2),
     +                               RDELCORTA
C Enter Pitch, drift and roll corrections:
       READ (84,*,IOSTAT=IERR,ERR=999) PCORS(2),DCORS(2),RCORS(2)
       WRITE(LP,'(2X,"TF PCOR= ",F5.1,2X,"DCOR= ",F5.1,
     +      2X,"RCOR= ",F5.1)') PCORS(2),DCORS(2),RCORS(2)
       RDELCORTAS(1)=RDELCORTA
       RDELCORTAS(2)=RDELCORTA
       DO IAZMCOR=1,2
        AZMCORS(IAZMCOR)=0.
        ELCORS(IAZMCOR)=0.
        PCORS(IAZMCOR)=0.
        DCORS(IAZMCOR)=0.
        RCORS(IAZMCOR)=0.
       ENDDO
       WRITE(6,*)'THREE'
C Read threshold value
       READ (84,*,IOSTAT=IERR,ERR=999) THRESH,DBZRS,DBZCOR,DBZSLOPE
       WRITE(LP,'(2X,"NOISE VALUE= ",F5.1,2X,"DBZRS= ",F5.1,
     +          "DBZSLOPE= ",F5.1,2X,"DBZCOR= ",F5.1)')
     +       THRESH,DBZRS,DBZSLOPE,DBZCOR
C Read spectral width threshold value
       READ (84,*,IOSTAT=IERR,ERR=999) swthresh
       IF (SWTHRESH.LE.0.0 .OR. SWTHRESH.GT.13.0) SWTHRESH=99.0
       WRITE(LP,'(2X,"SPECTRAL WIDTH THRESHOLD= ",F5.1)') swthresh
C Read Flag for adding the Terminal Velocity Corr. Value, the height &
C depth of the bright band, P. Willis or Joss VT.
       IVT='N'
       HTBB=5.5
       DBB=2.
       IRSW=0
C       READ (84,*,IOSTAT=IERR,ERR=999) IVT,HTBB,DBB,IRSW
       IF(IVT.EQ.'n')IVT='N'
       IF(IVT.EQ.'y')IVT='Y'
C      CALL CASEFOLD(IVT)
       WRITE(LP,'(2X,''VT= '',A1," HTBB= ",F6.2," DBB= ",F6.2, 
     +           " IRSW= ",I1)') 
     +      IVT,HTBB,DBB,IRSW
      IF (IVT .EQ. 'N') HTBB= -99.0
C Read flag to add the intervening attenuation
      IATTEN='N'
C       READ (84,*,IOSTAT=IERR,ERR=999) IATTEN
       IF(IATTEN.EQ.'y')IATTEN='Y'
       IF(IATTEN.EQ.'n')IATTEN='N'
C      CALL CASEFOLD(IATTEN) 
       IF (IATTEN .EQ. 'Y') THEN 
C compute attenuation table if flag is on 
          CALL MAKEATTENTABLE1(2)
          WRITE(LP,'(1X,"Intervening attenuation: A=",E10.2, 
     +   "*Z**",F4.2)') AT1,AT2
          IATTENFLAG = 1
       ELSE
          IATTENFLAG = 0
       ENDIF   
C Read Start Time and End Time
       READ(84,'(3I2,1X,3I2)',IOSTAT=IERR,ERR=999)
     +     IHS,IMS,ISS,IHE,IME,ISE
       WRITE(LP,'(2X,"Start Time:",3I2.2,2X,"End Time:",3I2.2)')
     +IHS,IMS,ISS,IHE,IME,ISE
C Read a second tape:
       TAPE='N'
C       READ(84,'(A1)',IOSTAT=IERR,ERR=999) TAPE
       IF(TAPE.EQ.'y')TAPE='Y'
       IF(TAPE.EQ.'n')TAPE='N'
C      CALL CASEFOLD(TAPE)
C 
C Read Disk File Name 
C       READ(84,'(A)',IOSTAT=IERR,ERR=999) NAMEO
      READ(84,*)DUMMY
      READ(84,*)DUMMY1,DUMMY2
      READ(84,*)DUMMY1,DUMMY2
      READ(84,'(A80)')CDUMMY
      READ(84,*)DUMMY1,DUMMY2
      READ(84,'(A80)')RADARFILE
      IF(LUNRT.GT.6)THEN
       ITAPEOPEN=1
      ELSE
       ITAPEOPEN=0
C       WRITE(6,*)'Enter name of radar file'
C       READ(84,'(A80)')RADARFILE
      ENDIF
      READ(84,*)IFRANCE
      WRITE(6,*)'IFRANCE = ',IFRANCE
      IF(ITAPEOPEN.EQ.1)THEN
       CALL TAPEOPEN(LUNRT,0,LUNR)
       CALL TAPECONTROL(LUNR,2,1) !back up 1 file
      ELSE
       LUNR=80
       CALL OPENRADARFILE(RADARFILE,LUNR,1,IERROPEN)
c        OPEN(80,FILE=RADARFILE,FORM='UNFORMATTED',RECL=2,
c     1       ACCESS='DIRECT')
      ENDIF
      CLOSE(84)
      NAMEO='DUMMY'
      ENDIF
c      WRITE(LP,'(2X,"NCEP Output File Name:",A)') NAMEO
c      WRITE(LP,*)trakazm,trakelev,driftnew,
c     +         rot,track,htbb,dbb,thresh,swthresh,dbzrs,ibst(1),ibst(2),
c     +         inob(1),inob(2),ileg,xniq,irsw,maxnbins,v0,
c     +         pcor,dcor,rcor,azmcor,elcor,dbzcor,dbzslope,
c     +         iunfoldflag,iattenflag,
c     +         badstabflag,surfelimflag,echoflag,atmflag
C Open Disk File
      OPEN(86,FILE='editfile',IOSTAT=IERR,ERR=1000,STATUS='UNKNOWN',
     +     FORM='unformatted') 
      OPEN(85,FILE='editfile.txt')
c      OPEN(83,FILE='passeditfile',IOSTAT=IERR,ERR=1000,
c     +     STATUS='UNKNOWN',FORM='unformatted') 
c      OPEN(82,FILE='passeditfile.txt')
C 
      STIME=FLOAT(IHS)*3600.0 + FLOAT(IMS)*60.0 + FLOAT(ISS)
      ETIME=FLOAT(IHE)*3600.0 + FLOAT(IME)*60.0 + FLOAT(ISE)
C
C Search for the start time:
c971   write(6,*)'itapeopen,icallsweepin = ',itapeopen,icallsweepin
971   IF(ICALLSWEEPIN.EQ.0)THEN
       ROLDTIME=200000.
97100  WRITE(6,*)'CALLING READTAPE'
       kwords=0
       nwords=-1
       CALL READTAPE(TIME,RLAT,RLON,RA,AZM,EV,BIN,REF,BIN1,REF1,RCAZM,
     +  ITAPEOPEN,RADARFILE,NUMREC,PCORS,DCORS,RCORS,AZMCORS,
     +  RDELCORTAS,ELCORS)
       IF(IFLIGHTCHECK.EQ.0)THEN
        IFLIGHTCHECK=1
        IF(NAIRCRAFT.EQ.42)THEN
         INAIR=1
        ELSEIF(NAIRCRAFT.EQ.43)THEN
         INAIR=2
        ELSE
         WRITE(6,*)'NAIRCRAFT = ',NAIRCRAFT
         WRITE(6,*)'NAIRCRAFT DOES NOET EQUAL 42 OR 43'
c         STOP
         INAIR=3
        ENDIF
        write(6,6104)iyear,month,iday,caircraft(inair)
        write(IFLTCHK,6104)iyear,month,iday,caircraft(inair)
6104    FORMAT(3I2.2,A)
        read(IFLT,'(A7)')IFLTCHK2
        WRITE(6,'(A7)')IFLTCHK
        write(6,'(A7)')IFLTCHK2
        CALL FINDIDAYS(IDAYSCHK,NAIRCHK,IFLTCHK)
        CALL FINDIDAYS(IDAYSCHK2,NAIRCHK2,IFLTCHK2)
        WRITE(6,*)'IDAYS FROM JOBFILE = ',IFLTCHK2
        WRITE(6,*)'IDAYS FROM TAPE = ',IFLTCHK
        IDAYSDIFF=IDAYSCHK-IDAYSCHK2
        IF(IDAYSDIFF.EQ.1)THEN
         IADD86400=1
        ELSE
         IADD86400=0
        ENDIF
        IF(IFLTCHK2.NE.IFLTCHK)THEN
         write(6,*)'flight id on jobfile inconsistent with tape'
c         write(6,*)'do you want to continue?'
c         OPEN(1,FILE='/dev/tty')
c         READ(5,'(A1)')IYES
c         CLOSE(1)
c         IF(IYES.EQ.'N'.OR.IYES.EQ.'n')THEN
c          WRITE(6,*)'rerun jobfilemaker and continue'
c          STOP
c         ENDIF
        ENDIF
c        PAUSE
       ENDIF
       IF(IADD86400.EQ.1)TIME=TIME+86400.
       IF(IRCU.EQ.6.OR.IFRANCE.EQ.1)THEN
        FASTON=1
       ELSEIF(IRCU.EQ.2)THEN
        FASTON=0
       ELSE
        write(6,*)'faston not determine correctly'
        FASTON=1
       ENDIF
       WRITE(6,*)'TIME,RLAT,RLON = ',TIME,RLAT,RLON
       WRITE(6,*)'TIME,OLDTIME = ',TIME,ROLDTIME
       IF(TIME.EQ.ROLDTIME)GO TO 97100
       TIMEMSTIME=TIME-STIME
       WRITE(6,*)'TIME,STIME,TIMEMSTIME = ',TIME,STIME,TIMEMSTIME
       IF(TIMEMSTIME.LT.-72000..AND.ITAPEOPEN.EQ.1)THEN
c        write(6,*)'should not get here 3'
c        stop
        WRITE(6,*)'BACKSPACING'
        CALL TAPECONTROL(LUNR,2,1)
        CALL TAPECONTROL(LUNR,2,1)
        ROLDTIME=TIME
        GO TO 97100
       ENDIF
       write(6,*)'calling tapesearch'
c97101  
97101  IF(IADD86400.EQ.1)THEN
        STIMESEARCH=STIME-86400
       ELSE
        STIMESEARCH=STIME
       ENDIF
       IF(LUNR.NE.80)THEN
        CALL TAPESEARCH(LUNR,2,2,STIMESEARCH,IERR)
       ELSE
        WRITE(6,*)'CALLING DISCSEARCH'
        CALL DISCSEARCH(LUNR,2,2,STIMESEARCH,IERR)
        NTIMER=0
        write(6,*)'called discsearch'
        timetest=itimex(2)
        write(6,*)'timetest,etime = ',timetest,etime
        if(timetest.gt.etime)then
         itimex(2)=1
         time=itimex(2)
         write(6,*)'new time,itimex = ',time,itimex(2)
         ierr=20
         go to 97101
        endif
       ENDIF
       IF (IERR.LT.0) GO TO 970
      CALL READTAPE(TIME,RLAT,RLON,RA,AZM,EV,BIN,REF,BIN1,REF1,RCAZM,
     +ITAPEOPEN,RADARFILE,NUMREC,PCORS,DCORS,RCORS,AZMCORS,
     +RDELCORTAS,ELCORS)
      IF(IADD86400.EQ.1)TIME=TIME+86400.
c       WRITE(6,*)'IRCU = ',IRCU
       IF(IRCU.EQ.6.OR.IFRANCE.EQ.1)THEN
        FASTON=1
       ELSEIF(IRCU.EQ.2)THEN
        FASTON=0
       ELSE
        write(6,*)'faston not determine correctly'
        FASTON=1
       ENDIF
       IF((TIME-STIME).LT.-60000.)THEN
        CALL TAPECONTROL(LUNR,2,1) !back up 1 file
        CALL TAPECONTROL(LUNR,2,1) !back up 1 file
        GO TO 97101
c        write(6,*)'should not get here 4'
c        stop
       ELSEIF((TIME-STIME).LT.1.)THEN
        WRITE(6,*)'SETTING IFILECHECK TO 1'
        IFILECHECK=1
       ELSE
        WRITE(6,*)'TIME IS ',TIME
       ENDIF
      ENDIF
      OLDTIME=0
      ITIMECHECK=0
C      WRITE(6,*)'START XNIQ AND XNIQTA = ',XNIQ,XNIQTA
c7040  write(6,*)'calling readtape'
7040  CALL READTAPE(TIME,RLAT,RLON,RA,AZM,EV,BIN,REF,BIN1,REF1,RCAZM,
     +ITAPEOPEN,RADARFILE,NUMREC,PCORS,DCORS,RCORS,AZMCORS,
     +RDELCORTAS,ELCORS)
      TRACKLATLON=180./3.14159*ATAN2(GSE,GSN)
      IF(TRACKLATLON.LT.0.)TRACKLATLON=TRACKLATLON+360.
      TRACKDIFF=TRACK-TRACKLATLON
      IF(TRACKDIFF.GT.180.)TRACKDIFF=TRACKDIFF-360.
      IF(TRACKDIFF.LT.-180.)TRACKDIFF=TRACKDIFF+360.
      IF(TRACKDIFF.GT.2.)THEN
c      IF(ABS(TRACKDIFF).GT.2..OR.ABS(PITCH).LT..1.OR.
c     +   ABS(HEADING).LT..1)THEN
C     +   ABS(ROLL).LT..1.OR.ABS(HEADING).LT..1)THEN
       DO I=1,512
        BIN(I)=-888.8
        BIN1(I)=-888.8
        REF(I)=-32.
        REF1(I)=-32.
       ENDDO
      ENDIF
      IF(IADD86400.EQ.1)TIME=TIME+86400.
       IF(ABS(ELEV).LT..001)THEN
        DO I=1,512
         REF(I)=-32.
         BIN(I)=-888.88
        ENDDO
       ENDIF
       DO I=1,512
        IF(REF(I).GT.60.)THEN
         REF(I)=-32.
         BIN(I)=-888.88
        ENDIF
       ENDDO
       IF(IRCU.EQ.6.OR.IFRANCE.EQ.1)THEN
        FASTON=1
       ELSEIF(IRCU.EQ.2)THEN
        FASTON=0
        IF(IFASTCHECK.EQ.0)THEN
         WRITE(6,*)'ANTENNA NOT IN FAST'
         WRITE(6,*)'DO YOU WANT TO CONTINUE? IF SO TYPE go'
c         PAUSE
         FASTON=1
         IFASTCHECK=1
        ENDIF
       ELSE
        write(6,*)'faston not determined correctly'
        FASTON=1
       ENDIF
c      write(6,*)'back from readtape'
c      WRITE(6,*)'TIME,NTASWEEP,ISWEEPSET,ISWEEPCHECK = ',
c     + TIME,NTASWEEP,ISWEEPSET,ISWEEPCHECK
c      write(6,*)'time,stime = ',time,stime
      IF(TIME.GT.ETIME)THEN
c       write(6,*)'time,etime = ',time,etime
       IF(TIME-ETIME.GT.1000..AND.NTIMER.LT.100)THEN
        TIME=1
        ITIMEX(2)=1
        NTIMER=NTIMER+1
        GO TO 7040
       ELSE
        NTIMER=0
       ENDIF
      ENDIF
      IF(TIME.GT.STIME.AND.IFILECHECK.EQ.0.AND.ITAPEOPEN.EQ.1)THEN
       WRITE(6,*)'BACKING UP TWO FILES LOOKING FOR STARTIME'
c       write(6,*)'I should not get here 5'
c       stop
       CALL TAPECONTROL(LUNR,2,1) !back up 1 file
       CALL TAPECONTROL(LUNR,2,1) !back up 1 file
       IFILECHECK=1
       GO TO 971
      ELSE
       IFILECHECK=1
      ENDIF
      OOLAT=RLAT
      OOLON=RLON
      TIMES=TIME
      IF(IUSEWIND.NE.1)CENTIME=TIME
      ISCANDIM=512
      IBINS=512
      IF((RADIITA(3)-RADIITA(2)).GT..145)THEN
       I150=1
      ELSE
       I150=0
      ENDIF
      IF(RADTEST.GT.0..AND.RADIITA(50).NE.RADTEST)THEN
       INEWRAD=1
       RADTEST=RADIITA(50)
      ELSE
       INEWRAD=0
      ENDIF     
      IF(TIME.LT.STIME)THEN
c       write(6,*)'calling int'
       ITIME=INT(TIME)
c       write(6,*)'returned from int'
       IF(ITIME.GT.ITIMECHECK)THEN
        WRITE(6,*)'TIME,STIME = ',TIME,STIME
        ITIMECHECK=ITIME
       ENDIF
c       write(6,*)'going to 7040 time,stime = ',time,stime
       GO TO 7040
      ENDIF
      TANAZM=TAN(TRAKAZM*3.14159/180.)
      COSAZM=COS(TRAKAZM*3.14159/180.)
      COSEV=COS(TRAKELEV*3.14159/180.)
      RALTITUDE=RA*.001
      IF(COSAZM.GT.0.)THEN
       VLENGTH=20.-RALTITUDE
       IEV=1
       XLENGTH=VLENGTH*TANAZM*COSEV
      ELSEIF(COSAZM.LT.0.)THEN
       VLENGTH=RALTITUDE
       IEV=-1
       XLENGTH=-VLENGTH*TANAZM*COSEV
      ELSE
       IEV=0
       XLENGTH=1000.
      ENDIF
      IF(NUM_RAYS.GT.1)THEN
       XDIFF=XLENGTH-XLENGTHOLD
c       write(6,*)'vlength,xlength,tanazm,cosazm,cosev = ',
c     + VLENGTH,XLENGTH,TANAZM,COSAZM,COSEV
       IF(ABS(XDIFF).LT.SXBIG)THEN
        IAZM(NUM_RAYS)=0
       ELSE
        XLENGTHOLD=XLENGTH
        IAZM(NUM_RAYS)=1
       ENDIF
      ELSE
       XLENGTHOLD=XLENGTH
      ENDIF       
c      if(trakazm.gt.85.and.trakazm.lt.86)then
c       write(6,*)'bin = ',bin
c      endif
c      write(6,*)'calling vrlocater'
c      IF(IUSEWIND.NE.1)THEN
c       I=1
c       RA1000=(RA/1000.)-.2
c       DO I=1,30
c        IF(BIN(I).GT.-98..AND.REF(I).GT.20.)GO TO 29654
c        IF(RADIITA(I).GT.2.)THEN
cc         WRITE(6,*)'GOING TO 7040 I,RADIITA,RA = ',I,RADIITA(i),RA1000
c         GO TO 7040
c        ENDIF
c       ENDDO
cc       WRITE(6,*)'GOING TO 7040'
c       GO TO 7040
c      ENDIF
29654 ISCANNBINS=10
      CALL VRLOCATER(TIMES,OLAT,OLON,
     + RLAT,RLON,RA,EV,AZM,RDTAIIN,XR,YR,ZR,
     + ISCANNBINS,SMOTIONU,SMOTIONV,CENTIME,BIN,REF)
c      write(6,*)'returned from vrlocater'
       IF(NUM_RAYS.GT.0.AND.IUSEWIND.EQ.1)THEN
c        write(6,*)'olat,olon,rlat,rlon = ',olat,olon,rlat,rlon
c        write(6,*)'smotionu,smotionv,centime',smotionu,smotionv,centime
c        WRITE(6,*)'TRAKAZM = ',TRAKAZM
c        WRITE(6,*)'NUM_RAYS SPOT,TIMES,EV,XR,YR,ZR AT 1 = ',
c     +   TIMES,EV,XR(1),YR(1),ZR(1)
        RADIANEV=EV*3.14159/180.
        RADIANAZM=AZM*3.14159/180.
        DIRCOSX=COS(RADIANEV)*COS(RADIANAZM)
        DIRCOSY=COS(RADIANEV)*SIN(RADIANAZM)
        DIRCOSZ=SIN(RADIANEV)
        XMIN=-XZ
        YMIN=-YZ
        XMAX=-XZ+IMX*SX
        YMAX=-YZ+JMX*SY
        ZZMAX=ZZ+(KMX-1)*SZ
c        WRITE(6,*)'IMX,JMX,KMX = ',IMX,JMX,KMX
c        WRITE(6,*)'SX,SY,SZ,XZ,YZ,ZZ = ',SX,SY,SZ,XZ,YZ,ZZ
c       WRITE(6,*)'XMIN,YMIN,ZZMIN = ',XMIN,YMIN,ZZMIN
c       WRITE(6,*)'XMAX,YMZX,ZZMAX = ',XMAX,YMAX,ZZMAX
        DO IR=1,10
         IF(BIN(IR).GT.-800.)THEN
          IINT=INT((XR(IR)+XZ+.5*SX)/SX)
          JINT=INT((YR(IR)+YZ+.5*SY)/SY)
          KINT=1+INT((ZR(IR)-ZZ)/SZ)
          VRRAD(IR,NUM_RAYS)=0.
          VRSUM=0.
          DO I=IINT,IINT+1
           DO J=JINT,JINT+1
            DO K=KINT,KINT+1
             IF(I.GE.1.AND.I.LE.IMX)THEN
              IF(J.GE.1.AND.J.LE.JMX)THEN
               IF(K.GE.1.AND.K.LE.KMX)THEN
                IF(U(I,J,K).GT.WFLAG)THEN
c                 if(num_rays.gt.0)then
c                 write(6,*)'wflag,i,j,k,u,v,w = ',wflag,i,j,k,u(i,j,k),       
c     1            v(i,j,k),w(i,j,k)
c                 endif
                 XG=(I-1)*SX-XZ+.5*SX
                 YG=(J-1)*SY-YZ+.5*SY
                 ZG=(K-1)*SZ+ZZ
                 XI=XR(IR)-XG
                 YI=YR(IR)-YG
                 ZI=ZR(IR)-ZG
                 RADR=SQRT(XR(IR)*XR(IR)+YR(IR)*YR(IR))
                 RADG=SQRT(XG*XG+YG*YG)
                 VRAD=(U(I,J,K)*XG+V(I,J,K)*YG)/RADG
                 VTAN=(V(I,J,K)*XG-U(I,J,K)*YG)/RADG
                 URAD=(VRAD*XR(IR)-VTAN*YR(IR))/RADR
                 VRAD=(VRAD*YR(IR)+VTAN*XR(IR))/RADR
                 DISTPOINT=SQRT(XI*XI+YI*YI+ZI*ZI)
                 IF(DISTPOINT.GT.0.)THEN
                  RINT=1./DISTPOINT
                 ELSE
                  RINT=1000000.
                 ENDIF
                 VRRAD(IR,NUM_RAYS)=VRRAD(IR,NUM_RAYS)+
     1              RINT*(URAD*DIRCOSX+VRAD*DIRCOSY+
     1              W(I,J,K)*DIRCOSZ)
                 VRSUM=VRSUM+RINT
                ENDIF
               ENDIF
              ENDIF
             ENDIF
            ENDDO
           ENDDO
          ENDDO
          IF(VRSUM.GT.0.)THEN
           VRRAD(IR,NUM_RAYS)=VRRAD(IR,NUM_RAYS)/VRSUM
          ELSE
           VRRAD(IR,NUM_RAYS)=-888.8
          ENDIF
         ELSE
          VRRAD(IR,NUM_RAYS)=-888.8
         ENDIF
        ENDDO
       ENDIF
C       write(6,*)'num_rays = ',num_rays
C       write(6,*)'bin'
C       write(6,*)(bin(ir),ir=1,512)
C       write(6,*)'vrrad'
C       write(6,*)(vrrad(ir,num_rays),ir=1,512)
CC       IF(XR(80).GE.XMIN.AND.XR(80).LE.XMAX)THEN
C        IF(YR(80).GE.YMIN.AND.YR(80).LE.YMAX)THEN
C         IF(ZR(80).GE.ZMIN.AND.YR(80).LE.ZMAX)THEN
C          ILOC=1+(XR(80)+XZ)/SX
C          JLOC=1+(YR(80)+YZ)/SY
C          KLOC=1+(ZR(80)-ZZ)/SZ
C          WRITE(6,*)'ILOC,JLOC,KLOC = ',ILOC,JLOC,KLOC
C         ENDIF
C        ENDIF
C       ENDIF
      IF(NUM_RAYS.GT.0)THEN
c       WRITE(6,*)'NUM_RAYS,XR = ',NUM_RAYS,XR
c       WRITE(6,*)'NUM_RAYS,YR = ',NUM_RAYS,YR
c       WRITE(6,*)'NUM_RAYS,ZR = ',NUM_RAYS,ZR       
      ISCANNBINS=NB1
      CALL VRLOCATER(TIMES,OOLAT,OOLON,
     + RLAT,RLON,RA,EV,AZM,RDTAIIN,XR,YR,ZR,
     + ISCANNBINS,SMOTIONU,SMOTIONV,CENTIME,BIN,REF)
       DO I=1,512
        XRSWEEP(I,NUM_RAYS)=XR(I)
        YRSWEEP(I,NUM_RAYS)=YR(I)
        ZRSWEEP(I,NUM_RAYS)=ZR(I)
       ENDDO
      ENDIF
      SWEEPTEST=1.
      IF(ABS(ELEV).GT.0.)THEN
       SWEEPTEST=ELEV*SWEEPOLD
       SWEEPOLD=ELEV
      ENDIF
      IF(IFRANCE.NE.1.AND.ISWEEPCHECK.NE.NTASWEEP)SWEEPTEST=-1.
      IF(IFRANCE.NE.1.AND.ISWEEPCHECK.EQ.NTASWEEP)SWEEPTEST=1.
      IF(ISWEEPSET.EQ.0)THEN
       ISWEEPCHECK=NTASWEEP
       ISWEEPSET=1
c       WRITE(6,*)'ISWEEP 0 NTASWEEP = ',NTASWEEP
C       WRITE(6,*)'INITIAL READ XNIQ,XNIQTA = ',XNIQ,XNIQTA
       GO TO 7040
C      ELSEIF(ISWEEPSET.EQ.1.AND.NTASWEEP.EQ.ISWEEPCHECK)THEN
      ELSEIF(ISWEEPSET.EQ.1.AND.SWEEPTEST.GE.0.)THEN
c       WRITE(6,*)'ISWEEP 1 NTASWEEP = ',NTASWEEP
       GO TO 7040
C      ELSEIF(ISWEEPSET.EQ.1.AND.NTASWEEP.NE.ISWEEPCHECK)THEN
      ELSEIF(ISWEEPSET.EQ.1.AND.SWEEPTEST.LT.0.)THEN
c       WRITE(6,*)'ISWEEP 1-1 NTASWEEP = ',NTASWEEP
c       RDDIFF=RDTAIIN(IBST(1)+1)-RDTAIIN(1)
       IF(IBST(1).GE.1)THEN
        DO I=1,IBST(1)
         RDTAIIN(I)=1000.
        ENDDO
       ENDIF
       DO I=IBST(1)+1,NBINS
        RDTAIIN(I)=RADIITA(I)
       ENDDO
       IF(NBINS.LT.512)THEN
        DO I=NBINS+1,512
         RDTAIIN(I)=1000.
        ENDDO
       ENDIF
c       DO I=1,512-IBST(1)
c        RDTAIIN(I)=RADIITA(I+IBST(1))-RDDIFF
c       ENDDO
c       DO I=512-IBST(1)+1,512
c        RDTAIIN(I)=RDTAIIN(I-1)+.3
c       ENDDO
c       WRITE(6,*)'RDTAIIN = ',RDTAIIN
       ISWEEPSET=2
       ISWEEPCHECK=NTASWEEP
C      ELSEIF((ISWEEPSET.EQ.2.AND.NTASWEEP.NE.ISWEEPCHECK).
C     1        OR.NUM_RAYS.EQ.800)THEN
      ELSEIF((ISWEEPSET.EQ.2.AND.SWEEPTEST.LT.0.).
     1       OR.NUM_RAYS.EQ.800)THEN
c       WRITE(6,*)'ENDING,NTASWEEP,ISWEEPCHECK = ',
c     1                   NTASWEEP,ISWEEPCHECK
c       write(6,*)'backspacing 2 records'
c       CALL TAPECONTROL(LUNR,4,10)
       ISWEEPCHECK=NTASWEEP
c       WRITE(6,*)'ISWEEPCHECK SET TO ',ISWEEPCHECK
       CALL CTME1(TIME,IIHH,IIMM,IISS)
       WRITE(6,*)'SWEEP END TIME IS '
       WRITE(6,'(3I2)')IIHH,IIMM,IISS
       TIMEONE=TIME
       RLATONE=RLAT
       RLONONE=RLON
       RAONE=RA
       AZMONE=AZM
       EVONE=EV
       V0ONE=V0
       RDUCOMONE=UCOM
       RDVCOMONE=VCOM
       RDGSONE=RADGS
       RDVWSONE=RADVWS
       AZELONE=TRAKAZM
       AZELTWO=TRAKELEV
       PELEVONE=ELEV
       PAZMONE=RADAZM
       IF(IBST(1).GE.1)THEN
        DO I=1,IBST(1)-1
         BINONE(I)=-888.8
         REFONE(I)=-32.
        ENDDO
       ENDIF
       DO I=IBST(1)+1,512
        BINONE(I)=BIN(I)
        REFONE(I)=REF(I)
       ENDDO
c       DO I=1,512-IBST(1)
c        BINONE(I)=BIN(I+IBST(1))
c        BINONE(I)=REF(I+IBST(1))
c        REFONE(I)=REF(I+IBST(1))
c       ENDDO
c       DO I=512-IBST(1)+1,512
c        BINONE(I)=-888.8
c        REFONE(I)=-32.
c       ENDDO
       IF(TRAKAZM.GT.91..AND.TRAKAZM.LT.269.)THEN
c       WRITE(6,*)'J,RDTAIIN(1,60) = ',J,(RDTAIIN(LLL),LLL=1,60)
        IF(ELEV.GE.0)THEN
         ELCORF=ELCORS(2)
         AZMCORF=AZMCORS(2)
        ELSE
         ELCORF=ELCORS(1)
         AZMCORF=AZMCORS(1)
        ENDIF
        CALL FIND_GROUND(RDTAIIN,DEG2RAD,BEAM_WID,RS_TH,RS_M,
     + DBZ_MAX,IBEG,NG2,ELCORF,AZMCORF,RA_NEW)
c       WRITE(6,*)'RS_TH,RS_M,DBZ_MAX,IBEG,NG2 = ',RS_TH,RS_M,DBZ_MAX,
c     +  IBEG,NG2
        IBEGNEW=IBEG
        REFL=-32.
        IF(IBEG.GT.1)THEN
c         WRITE(6,*)'RA_NEW,IBEG = ',RA_NEW,IBEG
         DO L=1,20
          IBEGL=IBEG-L+1
          IF((IBEGL-1).GE.5)THEN
c          WRITE(6,*)'IBEGL,L,REF(IBEGL),REF(IBEGL-1) = ',
c     +               IBEGL,L,REF(IBEGL),REF(IBEGL-1)
           IF(DBZBUFFER(IBEGL).GT.-31.95)REFL=DBZBUFFER(IBEGL)
           IF(REFL.GT.-31.95.AND.DBZBUFFER(IBEGL-1).GT.-31.95)THEN
            IF(REFL-DBZBUFFER(IBEGL-1).GT.5.)THEN
             IBEGNEW=IBEGL
            ENDIF
           ENDIF
          ENDIF
         ENDDO
         IBEG=IBEGNEW
         DO I=IBEG,512
          BIN(I)=-999.9
          REF(I)=-999.9
         ENDDO
c        DO I=1,IBEG
c         IF(REF(I).GT.40.)THEN
c          WRITE(6,*)'TRAKAZM,IBEG = ',TRAKAZM,IBEG
c          WRITE(6,6927)(REF(I),DBZBUFFER(I),I=1,IBEG)
c6927      FORMAT(10F8.2)
c          GO TO 2222
c         ENDIF
c        ENDDO
        ELSEIF(IBEG.EQ.-1)THEN
         DO I=1,512
          BIN(I)=-999.9
          REF(I)=-999.9
         ENDDO 
        ENDIF
       ENDIF
       GO TO 2000
      ENDIF
      NUM_RAYS=NUM_RAYS+1
      RRLAT(NUM_RAYS)=RLAT
      RRLON(NUM_RAYS)=RLON
      RRA(NUM_RAYS)=RA
      EAZM(NUM_RAYS)=AZM
      EEV(NUM_RAYS)=EV
      RDGS(NUM_RAYS)=RADGS
      RDVWS(NUM_RAYS)=RADVWS
      RDUCOM(NUM_RAYS)=UCOM
      RDVCOM(NUM_RAYS)=VCOM
      TMSWEEP(NUM_RAYS)=TIME
c      write(6,*)'num_rays = ',num_rays
      IF(TRAKAZM.GT.91..AND.TRAKAZM.LT.269.)THEN
c       WRITE(6,*)'J,RDTAIIN(1,60) = ',J,(RDTAIIN(LLL),LLL=1,60)
       IF(ELEV.GE.0)THEN
        ELCORF=ELCORS(2)
        AZMCORF=AZMCORS(2)
       ELSE
        ELCORF=ELCORS(1)
        AZMCORF=AZMCORS(1)
       ENDIF
       CALL FIND_GROUND(RDTAIIN,DEG2RAD,BEAM_WID,RS_TH,RS_M,
     + DBZ_MAX,IBEG,NG2,ELCORF,AZMCORF,RA_NEW)
c       WRITE(6,*)'RS_TH,RS_M,DBZ_MAX,IBEG,NG2 = ',RS_TH,RS_M,DBZ_MAX,
c     +  IBEG,NG2
       IBEGNEW=IBEG
       REFL=-32.
       IF(IBEG.GT.1)THEN
        RTRAKAZM=3.14159/180.*TRAKAZM
        RTRAKELEV=3.14159/180.*TRAKELEV
        X_NEW=RS_M*SIN(RTRAKAZM)*COS(RTRAKELEV)
c        WRITE(6,*)'RA_NEW,X_NEW,IBEG = ',RA_NEW,X_NEW,IBEG
        IF(ABS(RA_NEW).GT.10.)THEN
         SUMXI=SUMXI+X_NEW
         SUMYI=SUMYI+RA_NEW
         RADALTDIFFERENCE=(RA_NEW+RADALT)/COS(RTRAKELEV)
c         WRITE(6,*)'RADALT,RA_NEW,TRAKAZM,RADIFF = ',
c     1    RADALT,RA_NEW,TRAKAZM,RADALTDIFFERENCE
         IF(ABS(RADALT+RA_NEW).LT.1000..AND.
     1    COS(RADAZM*3.14159/180.).LT.-.9)THEN
          SUMELEV=SUMELEV+ELEV
          SUMZI=SUMZI+RADALT
          NUMRADALT=NUMRADALT+1
c          WRITE(6,*)'SUMZI,NUMRADALT = ',SUMZI,NUMRADALT
         ENDIF
         SUMXYI=SUMXYI+X_NEW*RA_NEW
         SUMXI2=SUMXI2+X_NEW*X_NEW
         NSUMSLOPE=NSUMSLOPE+1
         IF(X_NEW.LT.XIMIN)XIMIN=X_NEW
         IF(X_NEW.GT.XIMAX)XIMAX=X_NEW
        ENDIF
        DO L=1,20
         IBEGL=IBEG-L+1
         IF((IBEGL-1).GE.5)THEN
c          WRITE(6,*)'IBEGL,L,REF(IBEGL),REF(IBEGL-1) = ',
c     +               IBEGL,L,REF(IBEGL),REF(IBEGL-1)
          IF(DBZBUFFER(IBEGL).GT.-31.95)REFL=DBZBUFFER(IBEGL)
          IF(REFL.GT.-31.95.AND.DBZBUFFER(IBEGL-1).GT.-31.95)THEN
           IF(REFL-DBZBUFFER(IBEGL-1).GT.5.)THEN
            IBEGNEW=IBEGL
           ENDIF
          ENDIF
         ENDIF
        ENDDO
        IBEG=IBEGNEW
        DO I=IBEG,512
         BIN(I)=-999.9
         REF(I)=-999.9
        ENDDO
c        DO I=1,IBEG
c         IF(REF(I).GT.40.)THEN
c          WRITE(6,*)'TRAKAZM,IBEG = ',TRAKAZM,IBEG
c          WRITE(6,6927)(REF(I),DBZBUFFER(I),I=1,IBEG)
c6927      FORMAT(10F8.2)
c          GO TO 2222
c         ENDIF
c        ENDDO
       ELSEIF(IBEG.EQ.-1)THEN
        DO I=1,512
         BIN(I)=-999.9
         REF(I)=-999.9
        ENDDO 
       ENDIF
      ENDIF
c      WRITE(6,*)'TIME,TRAKAZM,REF = ',TIME,TRAKAZM,(REF(I),I=1,512)      
c      IF (TIME.GT.ETIME .OR. NIX.EQ.-100)GO TO 2000
2222  IF (NIX.EQ.-100)GO TO 2000
      IF (TAPE .EQ. 'Y') THEN 
c          call radartaperewind(lunr)
          write(6,*)'should not get here'
          stop
          WRITE(6,'("Change Radar Tape; RETURN to continue")')
7060      PAUSE
          WRITE(6,'("1-continue, 2-pause:",nn)')
          READ(5,*,err=7060) irewind
          if (irewind .ne. 1) go to 7060
          TAPE='N'
          GO TO 7040
      ENDIF 
C 
C Write Radar Information To Disk  
      ITIME=TIME
C      WRITE(83,IOSTAT=IERR,ERR=1040) TIME,RLAT,RLON,RA,RADAZM,ELEV,
C     +                 (BIN(I),I=1,512)
c      WRITE(6,*)'TIME,RLAT,RLON,RA,AZM,EV = ',
c     +   TIME,RLAT,RLON,RA,AZM,EV
c      WRITE(6,*)'PRF_FLAGTA,PRF_HIGHTA = ',PRF_FLAGTA,PRF_HIGHTA
c      WRITE(6,*)'XNIQ,XNIQTA = ',XNIQ,XNIQTA
c      WRITE(6,*)'NTASWEEP = ',NTASWEEP
c      write(6,*)'num_rays = ',num_rays
      AZ_EL(1,NUM_RAYS)=TRAKAZM
      AZ_EL(2,NUM_RAYS)=TRAKELEV
      PELEV(NUM_RAYS)=ELEV
      PAZM(NUM_RAYS)=RADAZM
c      WRITE(6,*)'NUM_RAYS,AZIMUTH,ELEVATION,V0 = ',
c     1           NUM_RAYS,AZ_EL(1,NUM_RAYS),AZ_EL(2,NUM_RAYS),V0
c      WRITE(6,*)'GSE,GSN,UCOM,VCOM = ',GSE,GSN,UCOM,VCOM
c      WRITE(6,*)'RADLAT,RADLON,EV,AZM = ',RADLAT,RADLON,EV,AZM
      V0SAVE(NUM_RAYS)=V0
      DO I=1,20
       IF(REF(I).GT.-32..AND.BIN(I).GT.-888.)THEN
        SWEEPSUM(I)=SWEEPSUM(I)+BIN(I)
        SWEEPZSUM(I)=SWEEPZSUM(I)+REF(I)
        SWEEPSUM2(I)=SWEEPSUM2(I)+BIN(I)*BIN(I)
        SWEEPZSUM2(I)=SWEEPZSUM2(I)+REF(I)*REF(I)
        NSWEEPSUMS(I)=NSWEEPSUMS(I)+1
       ENDIF
      ENDDO
      IF(IBST(1).GE.1)THEN
       DO I=1,IBST(1)
        BIN(I)=-888.8
        REF(I)=-32.
       ENDDO
      ENDIF
      DO I=1,NB1
       SWEEP(I,NUM_RAYS)=BIN(I)
c       SWEEP(I,NUM_RAYS)=BIN(I+IBST(1))
       SWEEPZ(I,NUM_RAYS)=REF(I)
c       IF(BIN1(I).NE.BIN(I))THEN
c        WRITE(6,'(I5,3F10.4)')I,VELBUFFER(I),BIN1(I),BIN(I)
c       ENDIF
      ENDDO
      IF(NB1.LT.512)THEN
       DO I=NB1+1,512
        SWEEP(I,NUM_RAYS)=-888.8
        SWEEPZ(I,NUM_RAYS)=-32.
       ENDDO
      ENDIF
c      if(az_el(1,num_rays).gt.85..and.az_el(1,num_rays).lt.86.)then
c       write(6,*)'sweep = ',(sweep(i,num_rays),i=1,512)
c      endif
c      WRITE(6,*)'I,BIN,SWEEP = ',I,(SWEEP(I,NUM_RAYS),I=1,512)
C      IF(RADAZM.GT.270..AND.RADAZM.LT.277.)THEN
C       WRITE(6,*)'RADAZM,rdelta,ngate1,v0 = ',RADAZM,rdelta,ngate1,v0
C       WRITE(6,'(9F8.2)')(BIN(I),REF(I),WIDTHBUFFER(I),I=1,512)
C      ENDIF
C      WRITE(6,5674)(I,VELBUFFER(I),BIN1(I),BIN(I),I=1,512)
C      WRITE(6,5674)(I,DBZBUFFER(I),REF1(I),REF(I),I=1,512)
c      WRITE(6,5675)(I,WIDTHBUFFER(I),I=1,512)
C5674  FORMAT(3(I4,3F10.4))
5675  FORMAT(4(I3,F10.4))
      IF (MOD(ITIME,60).EQ.0 .AND. itime.NE.OLDTIME) THEN
         CALL CTME1(TIME,IH,IM,IS)
         WRITE(6,'(" Writing: ",3i2.2,1x,2(f8.3,1x),3(f12.4,1x))')
     +        IH,IM,IS,RLAT,RLON,RA,AZM,EV
      ENDIF
      OLDTIME=ITIME
      GO TO 7040
C 
C <<<<<<Error Conditions<<<<<<
970   WRITE(LP,'(1X," Error searching for start time:",i6)') IERR
      GO TO 2000
998   WRITE(LP,'(1X,"Error Opening Input File: ",A,1X,"IERR= ",I6)')
     +      IFILE,IERR
      GO TO 2000
999   WRITE(LP,'(1X,"Bad Input Data",I4)') IERR 
      GO TO 2000
1000  WRITE(LP,1030)IERR,NAMEO
1030  FORMAT(1X,'Error on Creating Output File= ',I5,1X,A) 
      GO TO 2000
1040  WRITE(LP,1045)IERR,NAMEO
1045  FORMAT(1X,'Error on Write= ',I5,1X,A)
      GO TO 2000
1050  WRITE(LP,'("Error on opening Ram File: ",I5,1X,A80)') IERR,NAMERAM 
2000  NUM_RAYS=NUM_RAYS-1
      if(num_rays.ge.1)then
       radvwmax=0.
       sumvw=0.
       do j=1,num_rays
        radvwtest=abs(rdvws(j))
        sumvw=sumvw+rdvws(j)
c        write(6,*)'j,rdvws,radvwtest,radvwmax = ',j,rdvws(j),
c     1   radvwtest,radvwmax
        if(radvwtest.gt.radvwmax)radvwmax=radvwtest
       enddo
       radvwmean=sumvw/num_rays
c       write(6,*)'radvwmax,radvwmean = ',radvwmax,radvwmean
       radvwmean=abs(radvwmean)
       if(radvwmax.gt.30..or.radvwmean.gt.15.)then
        do j=1,num_rays
         do i=1,nb1
          sweep(i,j)=-888.8
         enddo
        enddo
       endif
      endif
      write(6,*)'num_rays = ',num_rays
c      pause
C      DO J=1,NUM_RAYS
C       WRITE(6,*)'BEFORE,J,EEV,SWEEP(1,10),SWEEPZ(1,10) = ',
C     + J,EEV(J),(SWEEP(I,J),I=1,10),(SWEEPZ(I,J),I=1,10)
C      ENDDO
      RATEST=RA/1000.
      JSTART=0
      DO J=1,NUM_RAYS
       IF(AZ_EL(1,J).GT.90..AND.AZ_EL(1,J).LT.271.)THEN
        JSTART=J
        GO TO 18187
       ENDIF
      ENDDO
      GO TO 19187
18187 JEND=0
      DO J=JSTART+1,NUM_RAYS
       IF(AZ_EL(1,J).GT.270.)THEN
        JEND=J-1
        GO TO 18181
       ENDIF
      ENDDO
C18181 WRITE(6,*)'JSTART,JEND SET TO ',JSTART,JEND
18181 CONTINUE
      IRINSIDE=0
      DO I=1,128
       RALTDIFF=RDTAIIN(I)-RATEST
       IF(RALTDIFF.GT.-1..AND.IRINSIDE.EQ.0)THEN
        IRINSIDE=I
       ENDIF
c       write(6,*)'raltdiff,i,irinside = ',raltdiff,i,irinside
       IF(RALTDIFF.GT.1.)THEN
        IROUTSIDE=I-1
        GO TO 18182
       ENDIF
      ENDDO
18182 CONTINUE
C      WRITE(6,*)'IRINSIDE,IROUTSIDE = ',IRINSIDE,IROUTSIDE
      DO I=IRINSIDE,IROUTSIDE
       DO J=1,NUM_RAYS
        IF(SWEEPZ(I,J).LT.0..OR.ZRSWEEP(I,J).LE.0.5)THEN
         SWEEP(I,J)=-999.9
         SWEEPZ(I,J)=-32.
        ENDIF
       ENDDO
      ENDDO
      DO I=1,NB1
       IF(RDTAIIN(I).GT.RATEST)THEN
        IGTEST=0
        J=NUM_RAYS+1
        JJ=JSTART
        DO WHILE(JJ.LE.NUM_RAYS.AND.AZ_EL(1,JJ).LT.180.)
         IF(SWEEPZ(I,JJ).GT.-32.)THEN
          J=JJ+1
C         ELSE
C          GO TO 6498
         ENDIF
         JJ=JJ+1
        ENDDO
6498    IF(J.LE.NUM_RAYS.AND.AZ_EL(1,J).LT.180.)THEN
         ICHECK=1
C         write(6,*)'icheck,j,azel = ',icheck,j,az_el(1,j)
         CALL GROUNDCHECK(SWEEP,SWEEPZ,NUM_RAYS,I,J,ICHECK,ZRSWEEP,
     +    RDTAIIN)
        ENDIF
        J=0
        JJ=JEND
c        write(6,*)'i,j,jend = ',i,j,jend
        JAZTEST=1
        DO WHILE(JJ.GE.1.AND.JAZTEST.EQ.1)
         IF(AZ_EL(1,JJ).GT.180.)THEN
C         write(6,*)'i,j,sweep(i,j) = ',i,j,sweep(i,j)
          IF(SWEEPZ(I,JJ).GT.-32.)THEN
           J=JJ-1
C         ELSE
C          GO TO 6499
          ENDIF
          JJ=JJ-1
          JAZTEST=1
         ELSE
          JAZTEST=0
         ENDIF
        ENDDO
c        WRITE(6,*)'J,JEND = ',J,JEND
6499    IF(J.GE.1)THEN
         IF(AZ_EL(1,J).GT.180.)THEN
          ICHECK=2
C         write(6,*)'icheck,j,azel = ',icheck,j,az_el(1,j)
          CALL GROUNDCHECK(SWEEP,SWEEPZ,NUM_RAYS,I,J,ICHECK,ZRSWEEP,
     +    RDTAIIN)
         ENDIF
        ENDIF
       ENDIF
      ENDDO
C      DO J=1,NUM_RAYS
C       WRITE(6,*)'AFTER,J,EEV,SWEEP(1,10),SWEEPZ(1,10) = ',
C     + J,EEV(J),(SWEEP(I,J),I=1,10),(SWEEPZ(I,J),I=1,10)
C      ENDDO
C      WRITE(6,'(" NCEPWRITE_FILE....ending.")')
C      DO J=1,NUM_RAYS
C       DO I=1,512
C        ZDIFF(I,J)=-888.8
C       ENDDO
C      ENDDO
C      DO J=1,NUM_RAYS
C       J1=J-1
C       J2=J+1
C       IF(J.EQ.1)THEN
C        J1=NUM_RAYS
C       ELSEIF(J.EQ.NUM_RAYS)THEN
C        J2=1
C       ENDIF
C       AZ1=AZ_EL(1,J1)
C       AZ2=AZ_EL(1,J2)
C       AZDIFF=AZ2-AZ1
C       IF(AZDIFF.LT..0)AZDIFF=AZDIFF+360.
C       DO I=IBST(1),512
C        IF(SWEEPZ(I,J2).GT.-31.99.AND.SWEEPZ(I,J1).GT.-31.99.AND.
C     +    AZDIFF.LT.5..AND.AZDIFF.GE..5)THEN
C         ZDIFF(I,J)=(SWEEPZ(I,J2)-SWEEPZ(I,J1))/AZDIFF
CC         WRITE(6,*)'I,J,SWEEPZ1,SWEEPZ2,AZ1,AZ2,AZDIFF,ZDIFF = ',
CC     +   I,J,SWEEPZ(I,J1),SWEEPZ(I,J2),AZ1,AZ2,AZDIFF,ZDIFF(I,J)
C        ENDIF
C       ENDDO
C      ENDDO
C      DO I=1,512
C       DO J=1,NUM_RAYS
C        XRMAX(I,J)=XRSWEEP(I,J)
C        YRMAX(I,J)=YRSWEEP(I,J)
C        ZRMAX(I,J)=ZRSWEEP(I,J)
C        XRMIN(I,J)=XRSWEEP(I,J)
C        YRMIN(I,J)=YRSWEEP(I,J)
C        ZRMIN(I,J)=ZRSWEEP(I,J)
C        AZMIN(I,J)=AZ_EL(1,J)
C        AZMAX(I,J)=AZ_EL(1,J)
C        IF(ZDIFF(I,J).GT.-888.8)THEN
C         ZMIN(I,J)=ZDIFF(I,J)
C         ZMAX(I,J)=ABS(ZDIFF(I,J))
C        ELSE
C         ZMIN(I,J)=888.8
C         ZMAX(I,J)=-888.8
C        ENDIF
C       ENDDO
C      ENDDO
C      DO I=1,512
C       DO J=1,11
C        DO L=J+1,NUM_RAYS
C         IF(ZMAX(I,L).GT.ZMAX(I,J))THEN
C          ABC=ZMAX(I,J)
C          ZMAX(I,J)=ZMAX(I,L)
C          ZMAX(I,L)=ABC
C          ABC=XRMAX(I,J)
C          XRMAX(I,J)=XRMAX(I,L)
C          XRMAX(I,L)=ABC
C          ABC=YRMAX(I,J)
C          YRMAX(I,J)=YRMAX(I,L)
C          YRMAX(I,L)=ABC
C          ABC=ZRMAX(I,J)
C          ZRMAX(I,J)=ZRMAX(I,L)
C          ZRMAX(I,L)=ABC
C          ABC=AZMAX(I,J)
C          AZMAX(I,J)=AZMAX(I,L)
C          AZMAX(I,L)=ABC
C          ABC=ZMIN(I,J)
C          ZMIN(I,J)=ZMIN(I,L)
C          ZMIN(I,L)=ABC
C         ENDIF
Cc         IF(ZMIN(I,L).LT.ZMIN(I,J))THEN
Cc          ABC=ZMIN(I,J)
Cc          ZMIN(I,J)=ZMIN(I,L)
Cc          ZMIN(I,L)=ABC
Cc          ABC=XRMIN(I,J)
Cc          XRMIN(I,J)=XRMIN(I,L)
Cc          XRMIN(I,L)=ABC
Cc          ABC=YRMIN(I,J)
Cc          YRMIN(I,J)=YRMIN(I,L)
Cc          YRMIN(I,L)=ABC
Cc          ABC=ZRMIN(I,J)
Cc          ZRMIN(I,J)=ZRMIN(I,L)
Cc          ZRMIN(I,L)=ABC
Cc          ABC=AZMIN(I,J)
Cc          AZMIN(I,J)=AZMIN(I,L)
Cc          AZMIN(I,L)=ABC
Cc         ENDIF
C        ENDDO
C       ENDDO
C      ENDDO
Cc      DO I=IBST(1),512
Cc       DO J=1,10
Cc        IF(ZMAX(I,J).GT.-888.)THEN
Cc         WRITE(6,412)I,J,ZMIN(I,J),AZMAX(I,J),XRMAX(I,J),YRMAX(I,J),
Cc     +               ZRMAX(I,J)
Cc        ENDIF
Cc       ENDDO
Cc      ENDDO
C412   FORMAT(' MAX ',2I4,5F8.2)
CC      DO I=IBST(1),512
CC       DO J=1,10
CC        IF(ZMIN(I,J).LT.888.)THEN
CC         WRITE(6,413)I,J,ZMIN(I,J),AZMIN(I,J),XRMIN(I,J),YRMIN(I,J),
CC     +               ZRMIN(I,J)
CC        ENDIF
CC       ENDDO
CC      ENDDO
CC413   FORMAT(' MIN ',2I4,5F8.2)
c      DO J=1,NUM_RAYS
c       DO I=1,512
c        SWEEP(I,J)=SWEEPZ(I,J)
c       ENDDO
c      ENDDO
19187 DO ICHECKSWEEP=1,3
       NB1=10
       DO I=1,NB1
        DO J=1,NUM_RAYS
         IKEEP(I,J)=1
         IF(SWEEP(I,J).GT.-800.)THEN
          DO I1=1,5
           II=I+I1-3
           IF(II.GT.0.AND.II.LE.NB1)THEN
            IF(SWEEP(II,J).GT.-800)THEN
             IITEST(I1)=1
            ELSE
             IITEST(I1)=0
            ENDIF
           ELSE
            IITEST(I1)=0
           ENDIF
          ENDDO
          DO J1=1,5
           JJ=J+J1-3
           IF(JJ.GT.0.AND.JJ.LE.NUM_RAYS)THEN
            IF(SWEEP(I,JJ).GT.-800)THEN
             JJTEST(J1)=1
            ELSE
             JJTEST(J1)=0
            ENDIF
           ELSE
            JJTEST(J1)=0
           ENDIF
          ENDDO
          IKEEPER=0
          IF(IITEST(2).EQ.1.AND.IITEST(4).EQ.1)THEN
           IKEEPER=1
          ELSEIF(IITEST(1).EQ.1.AND.IITEST(2).EQ.1)THEN
           IKEEPER=1
          ELSEIF(IITEST(4).EQ.1.AND.IITEST(5).EQ.1)THEN
           IKEEPER=1
          ENDIF
          JKEEPER=0
          IF(JJTEST(2).EQ.1.AND.JJTEST(4).EQ.1)THEN
           JKEEPER=1
          ELSEIF(JJTEST(1).EQ.1.AND.JJTEST(2).EQ.1)THEN
           JKEEPER=1
          ELSEIF(JJTEST(4).EQ.1.AND.JJTEST(5).EQ.1)THEN
           JKEEPER=1
          ENDIF
          IF(IKEEPER.EQ.0.OR.JKEEPER.EQ.0)THEN
           IKEEP(I,J)=0
          ENDIF
         ENDIF
        ENDDO
       ENDDO
       DO I=1,NB1
        DO J=1,NUM_RAYS
         IF(IKEEP(I,J).EQ.0)SWEEP(I,J)=-999.9
        ENDDO
       ENDDO
      ENDDO
      IF(ICONSERVE.EQ.1)THEN
       DO J=1,NUM_RAYS
        RADSAVER=0.
        I=1
        DO WHILE(I.LT.NB1)
         IF(SWEEP(I,J).GT.-98..OR.RDTAIIN(I).LT.2.)THEN
          RADSAVER=RDTAIIN(I)
          I=I+1
         ELSEIF(RDTAIIN(I)-RADSAVER.GT.1.)THEN
          DO L=I,NB1
           SWEEP(L,J)=-888.8
          ENDDO
          GO TO 6305
         ELSE
          I=I+1
         ENDIF
        ENDDO
6305   ENDDO
      ENDIF
      XNIQTA1=XNIQTA
      CALL DEFRECKLE(IMAXBINS,JMAXRAYS,
     1 NUM_RAYS,PAZM,SWEEP,VROUT,XNIQTA1)
      DO J=1,NUM_RAYS
       DO I=2,511
c        if(j.eq.261)
c     1   WRITE(6,*)'I,J,SWEEPS = ',I,J,(SWEEP(II,J),II=I-1,I+1)
        IF(SWEEP(I,J).GT.-800..AND.SWEEP(I-1,J).LT.-799..AND.
     1     SWEEP(I+1,J).LT.-799.)THEN
c         WRITE(6,*)'REMOVING I,J = ',I,J
         SWEEP(I,J)=-888.88
c         WRITE(6,*)'I,J,SWEEPS = ',I,J,(SWEEP(II,J),II=I-1,I+1)
        ENDIF
       ENDDO
      ENDDO
      DO J=1,NUM_RAYS
       V00=V0SAVE(J)
       M=INOB(1)
       IRS=IBST(1)
       NB=NB1
       VN=XNIQTA
c       write(6,*)'beginnin bargen-brown loop'
       DO I=1,NB1
        RAY(I)=SWEEP(I,J)
        IF(IUSEWIND.NE.1)THEN
         VRRAD(I,J)=-888.8
        ELSEIF(IUSEWIND.EQ.1)THEN
c         if(vrrad(i,j).gt.-800..and.ray(i).gt.-800.)then
c         write(6,*)'iusewind,vrrad,ray = ',iusewind,vrrad(i,j),ray(i)
c         endif
         IF(VRRAD(I,J).LT.-800.)THEN
          RAY(I)=-888.88
         ENDIF
        ENDIF
        URAY(I)=VRRAD(I,J)
       ENDDO
c       write(6,*)'AZM = ',az_el(1,j)
c       write(6,*)'calling unfolder'
c       CALL UNFLD1(V00,VN,M,IRS,NB,RAY,URAY,NB)
       NB1=10
       NB2=10
c       WRITE(6,*)'CALLING UNFLDNEW'
       CALL UNFLDNEW(V00,VN,M,IRS,NB1,RAY,URAY,NB2)
c       WRITE(6,*)'RETURNED FROM UNFLDNEW,NB1,NB2,J,NUM_RAYS = ',
c     1            NB1,NB2,J,NUM_RAYS
c       pause
c       write(6,*)'j,ray,uray = ',j,(ray(i),uray(i),i=1,30)
c       iraytest=0
       do i=1,8
        if(ray(i).ne.uray(i).and.ray(i).gt.-800.)iraytest=1
       enddo
c       if(iraytest.eq.1)then
c        write(6,*)'j,pazm = ',j,pazm(j)
c        write(6,*)'v00,vn = ',v00,vn
c        write(6,*)'ray  ',(ray(i),i=1,8)
c        write(6,*)'uray ',(uray(i),i=1,8)
c       endif
       DO I=1,NB1
        SWEEP(I,J)=URAY(I)
       ENDDO
c       write(6,*)'finished calling unfolder'
      ENDDO
c      write(6,*)'ending bargen-brown loop'
c      pause
c      DO J=1,NUM_RAYS
c       DO I=1,512
c        SWEEP(I,J)=SWEEPZ(I,J)
c       ENDDO
c      ENDDO
      XXNIQTA=XNIQTA*.7
      XXNIQ=XNIQTA
c      write(6,*)'setting nyq to ',xxniq
      DO I=1,MAX_GATES
       DO J=1,NUM_RAYS
        NYQ(I,J)=XXNIQ
       ENDDO
      ENDDO
c      write(6,*)'finished setting nyq'
c      write(6,*)'calling aziunfld'
c      do j=1,num_rays
c       write(6,*)'j = ',j
c      enddo
c      DO J=1,NUM_RAYS
c       WRITE(6,*)'J,PAZM(J),V0 = ',J,PAZM(J),V0SAVE(J)
c       WRITE(6,*)'SWEEP BEFORE = ',(SWEEP(I,J),I=1,8)
c       WRITE(6,*)'VRRAD BEFORE = ',(VRRAD(I,J),I=1,8)
c      ENDDO
      NB=NB1
c      WRITE(6,*)'CALLING AZIUNFLD,MAX_GATES,NB = ',MAX_GATES,NB
      CALL AZIUNFLD(SWEEP,ISEG,ISEGE,MAX_GATES,NB,MAX_RAYS,XXNIQTA,
     1 RDTAIIN,AZ_EL,XXNIQ,NUM_RAYS,VRRAD,IUSEWIND,PAZM)
c      WRITE(6,*)'RETURNED FROM AZIUNFLD,MAX_GATES,NB = ',MAX_GATES,NB
c      pause
c       DO J=1,NUM_RAYS
c        WRITE(6,*)'J,SWEEP = ',J,(SWEEP(I,J),I=1,512)
c       ENDDO
c      DO J=1,NUM_RAYS
c       WRITE(6,*)'J,PAZM(J),V0 = ',J,PAZM(J),V0SAVE(J)
c       WRITE(6,*)'SWEEP AFTER = ',(SWEEP(I,J),I=1,8)
c       WRITE(6,*)'VRRAD AFTER = ',(VRRAD(I,J),I=1,8)
c      ENDDO
      FLAGVAL=-888.8
      IVADFLAG=10
      NSWEEPSUM=0
      YVRSUM=0
      XVRSUM=0
      VVRSUM=0
      ANGSUM=0
      DO J=1,MAX_RAYS
       DO I=1,MAX_GATES
        IF(ABS(PELEV(J)).GT..0001.AND.
     1   SWEEP(I,J).GT.-400..AND.SWEEPZ(I,J).GT.-32.)THEN
         H=ZRSWEEP(I,J)
         ZDBZ=SWEEPZ(I,J)
         IRSW=0.
         VTSUB1=VTERM_NEW(ZDBZ,H,HB2,DPB2,IRSW,ZLOW,ZHIGH)
         VTSUB=VTSUB1*SIN(EEV(J)*3.14159/180.)
         SWEEPVT(I,J)=SWEEP(I,J)-VTSUB
c         WRITE(6,*)'I,J,EVV,H,VTSUB,VTSUB1,SWEEP,SWEEPVT,SWEEPZ = ',
c     1     I,J,EEV(J),
c     1     H,VTSUB,VTSUB1,SWEEP(I,J),SWEEPVT(I,J),SWEEPZ(I,J)
        ELSE
         SWEEP(I,J)=-888.88
         SWEEPZ(I,J)=-32.
         SWEEPVT(I,J)=-888.88
        ENDIF
       ENDDO
      ENDDO
      DO J=1,NUM_RAYS
       EV1=EEV(J)
       AZM1=EAZM(J)
       UCOM1=RDUCOM(J)
       VCOM1=RDVCOM(J)
       WCOM1=RDVWS(J)-6.
       RADGS1=RDGS(J)
       RADIANEV=EV1*3.14159/180.
       RADIANAZM=AZM1*3.14159/180.
       DIRCOSX=COS(RADIANEV)*COS(RADIANAZM)
       DIRCOSY=COS(RADIANEV)*SIN(RADIANAZM)
       DIRCOSZ=SIN(RADIANEV)
       IF(SWEEPVT(9,J).GT.-800.)THEN
        NSWEEPSUM=NSWEEPSUM+1
        YVRSUM=COS(3.14159/180.*PAZM(J))+YVRSUM
        XVRSUM=SIN(3.14159/180.*PAZM(J))+XVRSUM
        VRSUMADD=SWEEPVT(9,J)-UCOM1*DIRCOSX-VCOM1*DIRCOSY-
     1         WCOM1*DIRCOSZ
        VVRSUM=VVRSUM+VRSUMADD
        ANGSUM=ANGSUM+VRSUMADD/RADGS1
       ENDIF
      ENDDO
      WRITE(6,*)'FINAL NSWEEPSUM IS ',NSWEEPSUM
      IF(NSWEEPSUM.GT.0)THEN
       YTEST=ABS(YVRSUM/NSWEEPSUM)
       XTEST=ABS(XVRSUM/NSWEEPSUM)
       WRITE(6,*)'NSWEEPSUM,XTEST,YTEST = ',NSWEEPSUM,XTEST,YTEST
       IF(YTEST.LT..1.AND.XTEST.LT..1)THEN
        VRTEST=VVRSUM/NSWEEPSUM
        ANGTEST=ANGSUM/NSWEEPSUM
        ANGTEST=ASIN(ANGTEST)*180./3.14159
c        WRITE(6,*)'NSWEEPSUM,YVRSUM,XVRSUM,VVRSUM = ',
c     1            NSWEEPSUM,YVRSUM,XVRSUM,VVRSUM,ANGSUM
c        WRITE(6,*)'NSWEEPSUM,YTEST,XTEST,VRTEST = ',
c     1            NSWEEPSUM,YTEST,XTEST,VRTEST,ANGTEST
C        PAUSE
       ELSE
        ANGTEST=-999.9
       ENDIF
      ELSE
       ANGTEST=-999.9
      ENDIF
c      DO J=1,NUM_RAYS
c       DO I=1,MAX_GATES
c        VRRAD(I,J)=SWEEP(I,J)
c       ENDDO
c      ENDDO
C      DO J=1,NUM_RAYS
C       DO I=1,MAX_GATES
c        IF(ILATERSWEEP.EQ.0.OR.SWEEP(I,J).LT.-200.)THEN
C         VRRAD(I,J)=SWEEP(I,J)
c        ELSE
c         VRRAD(I,J)=SWEEPSAVE(I,J)
c        ENDIF
C       ENDDO
C      ENDDO
      IMINRNG=1
      NRANG=NBINS
c      DO J=1,NUM_RAYS
c       WRITE(6,*)'J,AZ = ',J,AZ_EL(1,J),AZ_EL(2,J)
c       WRITE(6,*)'SWEEP = ',(SWEEP(I,J),I=1,512)
c       WRITE(6,*)'VRRAD = ',(VRRAD(I,J),I=1,512)
c      ENDDO
c      write(6,*)'returning from aziunfld'
c      write(6,*)'num_rays,iminrng,nrang,flagval,ivadflag,vnyq = ',
c     1           num_rays,iminrng,nrang,flagval,ivadflag,XNIQTA
      DO J=1,NUM_RAYS
       DO I=1,NB1
        SWEEPSAVE(I,J)=SWEEP(I,J)
       ENDDO
      ENDDO
c      CALL DEALIAS_EILTS(MAX_GATES,MAX_RAYS,SWEEP,NUM_RAYS,IMINRNG,
c     1 NRANG,VRRAD,NYQ,FLAGVAL,IVADFLAG,UNFVEL,TMP1,TMP2,JINDEX,
c     1 JIINDEX)
c      CALL UNFNQC(MAX_GATES,MAX_RAYS,NRANG,NUM_RAYS,SWEEP,XXNIQ,
c     1 UNFVEL,TMP1,TMP2,IVADFLAG,VRRAD,JINDEX)
c      write(6,*)'returning from aziunfld'
c      write(6,*)'num_rays,iminrng,nrang,flagval,ivadflag = ',
c     1           num_rays,iminrng,nrang,flagval,ivadflag
c      DO J=1,NUM_RAYS
cc       write(6,*)j,(unfvel(i,j),i=1,512)
c       DO I=1,MAX_GATES
cc        SWEEP(I,J)=VRRAD(I,J)
c        IF(SWEEPSAVE(I,J).GT.-800)THEN
c         SWEEP(I,J)=UNFVEL(I,J)
c         SWEEPSAVE(I,J)=UNFVEL(I,J)
c        ELSE
c         SWEEP(I,J)=-888.8
c         SWEEPSAVE(I,J)=-888.8
c        ENDIF
c       ENDDO
c      ENDDO
      ILATERSWEEP=1
      PELEVMAX=0.
      DO J=1,NUM_RAYS
       PELEVTEST=ABS(PELEV(J))
       IF(PELEVTEST.GT.PELEVMAX)PELEVMAX=PELEVTEST
      ENDDO
c      WRITE(6,*)'PELEVMAX = ',PELEVMAX
      IF(PELEVMAX.LT.15..AND.FASTON.NE.0)THEN
       DO J=1,10
        WRITE(6,*)'PELEVMAX = ',PELEVMAX
       ENDDO
      ENDIF
      MAXI=NB1
      MAXIOLD=MAXI
      IF(NSUMSLOPE.GE.2.AND.XIMIN.LE.-4000..AND.XIMAX.GE.4000.)THEN
c       WRITE(6,*)'NSUMSLOPE,SUMXI,SUMXI2,SUMYI,SUMXYI = ',
c     1            NSUMSLOPE,SUMXI,SUMXI2,SUMYI,SUMXYI
       DENOMINATOR=NSUMSLOPE*SUMXI2-SUMXI*SUMXI
       RNUMERATOR=NSUMSLOPE*SUMXYI-SUMXI*SUMYI
       AZMTAN=RNUMERATOR/DENOMINATOR
       AZMSLOPE=ATAN(AZMTAN)*180./3.14159
       RNUMERATOR=SUMXI2*SUMYI-SUMXI*SUMXYI
       AZMB=RNUMERATOR/DENOMINATOR
      ELSE
       AZMSLOPE=-999.9
       AZMB=-999.9
      ENDIF
      IF(NUMRADALT.LT.1)THEN
       RADALTMEAN=-999.9
       ELEVMEAN=-999.9
      ELSE
       RADALTMEAN=SUMZI/NUMRADALT
       ELEVMEAN=SUMELEV/NUMRADALT
      ENDIF
c      WRITE(6,*)'SUMZI,NUMRADALT,RADALTMEAN = ',
c     1 SUMZI,NUMRADALT,RADALTMEAN
c      WRITE(6,*)'XIMIN,XIMAX = ',XIMIN,XIMAX
      IF(RADALTMEAN.LT.-999..OR.ELEVMEAN.LT.-999.)THEN
       RADALTDIFF=-999.9
      ELSE
       RADALTDIFF=AZMB+RADALTMEAN
       RADALTDIFF=RADALTDIFF/COS(3.14159/180.*ELEVMEAN)
      ENDIF
      IF(ABS(RADALTDIFF).GT.500.)RADALTDIFF=-999.9
      WRITE(6,*)'SLOPE,INTERCEPT = ',AZMSLOPE,AZMB,RADALTDIFF
      RETURN
      END 
c      SUBROUTINE AZIUNFLD(SWEEP,ISEG,ISEGE,MAX_GATES,MAX_RAYS,
c     1 XXNIQTA,RDTAI,AZ_EL,XXNIQ,NUM_RAYS,VRRAD,IUSEWIND)
c      REAL SWEEP(MAX_GATES,MAX_RAYS)
c      INTEGER ISEG(MAX_GATES,MAX_RAYS),ISEGE(MAX_GATES,MAX_RAYS)
c      REAL RDTAI(MAX_GATES),AZ_EL(2,MAX_RAYS)
c      REAL VRRAD(MAX_GATES,MAX_RAYS)
c      REAL SWEEPKEEP(512,800)
c      XXNIQ2=XXNIQ*2.
cc      OPEN(77,FILE='lister')
cc      IF(IUSEWIND.NE.1)THEN
c      write(6,*)'iusewind = ',iusewind
c      write(6,*)'setting sweepkeep'
c       DO J=1,NUM_RAYS
c        DO I=1,MAX_GATES
c         SWEEPKEEP(I,J)=SWEEP(I,J)
c        ENDDO
c       ENDDO
cc      ENDIF
c      DO J=1,NUM_RAYS
c       IFIRST=0
c       DO I=1,MAX_GATES
c        ISEG(I,J)=0
c       ENDDO
c       DO I=1,512
c        IF(SWEEP(I,J).GT.-800..AND.IFIRST.EQ.0)THEN
cC---VERY FIRST GOOD GATE IN RAY
c         BEFORE=SWEEP(I,J)
c         IFIRST=1
c         ISEG(I,J)=-1
c         ILAST=I
c        ELSEIF(SWEEP(I,J).GT.-800.)THEN
c         IF(ABS(SWEEP(I,J)-BEFORE).GE.XXNIQTA.OR.
c     1      RDTAI(I)-RDTAI(ILAST).GT..9)THEN
cC---DIFFERENCE BETWEEN GATE AND PREVIOUS GOOD GATE MORE THEN .7*VNYQ
cc         WRITE(6,*)'SWEEP,BEFORE,XNIQTA7 = ',
cc     1               SWEEP(I,J),BEFORE,XXNIQTA
cc          WRITE(6,*)'RDTAII,RDTAILAST = ',RDTAI(I),RDTAI(ILAST)
cC
cC---ISEG AT THE LAST GOOD GATE BEFORE THIS LARGE SHIFT IS SET TO 1
c          ISEG(ILAST,J)=1
c          ISEG(I,J)=-1
cC---ISEG AT THIS BREAKPOINT IS SET TO -1
cc          WRITE(6,*)'ILAST,I,AZ_EL = ',ILAST,I,AZ_EL(1,J)
c         ENDIF
cC
cC---GOOD VALUES SET ILAST AND BEFORE TO THESE VALUES
c         ILAST=I
c         BEFORE=SWEEP(I,J)
c        ENDIF
c       ENDDO
cC---VERY LAST GOOD VALUE GETS AN ISEG VALUE OF 1
c       IF(IFIRST.EQ.1)ISEG(ILAST,J)=1
c       IISEGE=-1
c       DO I=MAX_GATES,1,-1
c        IF(ISEG(I,J).EQ.1)THEN
c         IISEGE=I
c         ISEGE(I,J)=IISEGE
c        ELSEIF(ISEG(I,J).EQ.-1)THEN
c         ISEGE(I,J)=IISEGE
c         IISEGE=-1
c        ELSE
c         ISEGE(I,J)=IISEGE
c        ENDIF
c       ENDDO
cc       WRITE(77,'(F10.2,2I5,F10.2)')
cc     1        (SWEEP(I,J),ISEGE(I,J),I,AZ_EL(1,J),I=1,512)       
c      ENDDO
cc      CLOSE(77)
c      IUSETEST=0
c      DO J=2,NUM_RAYS
c       JMAX=J-1
cc       WRITE(6,*)'J,AZ_EL = ',J,AZ_EL(1,J)
c       IF(AZ_EL(1,J).GT.180..AND.AZ_EL(1,J).LT.320.)GO TO 777
c       I=1
c       DO WHILE(I.LE.511)
c        IF(SWEEP(I,J).GT.-800.AND.SWEEP(I,J-1).GT.-800.)THEN
c         NSUM=0
c         SUM=0
c         N=ISEGE(I,J)
c         DO L=I,N
c          IF(SWEEP(L,J).GT.-800.AND.SWEEP(L,J-1).GT.-800.)THEN
c           SUM=SUM+SWEEP(L,J)-SWEEP(L,J-1)
c           NSUM=NSUM+1
c          ENDIF
c         ENDDO
cc         write(6,*)'j,i,n,sum,nsum = ',j,i,n,sum,nsum
c         IF(NSUM.GE.1)THEN
c          DIFMEAN=SUM/NSUM
c          IF(DIFMEAN.GT.XXNIQ)THEN
c           CHANGE=NINT(DIFMEAN/XXNIQ2)*XXNIQ2
cc           write(6,*)'j,nsum,difmean,change,xxniq,xxniq2 = ',
cc     1      j,nsum,difmean,change,xxniq,xxniq2
c           DO L=I,N
c            IF(SWEEP(L,J).GT.-800.)SWEEP(L,J)=SWEEP(L,J)-CHANGE
c           ENDDO
c          ELSEIF(DIFMEAN.LT.-XXNIQ)THEN
c           CHANGE=NINT(DIFMEAN/XXNIQ2)*XXNIQ2
cc           write(6,*)'j,nsum,difmean,change,xxniq,xxniq2 = ',
cc     1      j,nsum,difmean,change,xxniq,xxniq2
c           DO L=I,N
c            IF(SWEEP(L,J).GT.-800.)SWEEP(L,J)=SWEEP(L,J)-CHANGE
c           ENDDO
c          ENDIF
c         ENDIF
c         I=N+1
c        ELSE
c         I=I+1
c        ENDIF
c       ENDDO        
c      ENDDO
c777   NSUM=0
c      SUM=0.
c      DO J=1,JMAX
c       DO I=1,512
c        IF(SWEEP(I,J).GT.-800.AND.VRRAD(I,J).GT.-800.)THEN
c         DIFF=SWEEP(I,J)-VRRAD(I,J)
c         NSUM=NSUM+1
c         SUM=SUM+DIFF
c        ENDIF
c       ENDDO
c      ENDDO
c      IF(NSUM.GT.0)THEN
c       IUSETEST=1
c       DIFF=SUM/FLOAT(NSUM)
c       write(6,*)'difference on right side is ',DIFF
c       IF(ABS(DIFF).GT.XXNIQ)THEN
c        IF(DIFF.GT.0.)THEN
c         VCHANGE=-XXNIQ2
c        ELSE
c         VCHANGE=XXNIQ2
c        ENDIF
c        DO J=1,JMAX
c         DO I=1,512
c          IF(SWEEP(I,J).GT.-800.)THEN
c           SWEEP(I,J)=SWEEP(I,J)+VCHANGE
c          ENDIF
c         ENDDO
c        ENDDO
c       ENDIF
c      ELSE
c       IUSETEST=0
c      ENDIF
c      IF(IUSEWIND.NE.1.OR.IUSETEST.NE.1)THEN
c       NSUM=0
c       SUM=0
c       DO J=1,JMAX
c        DO I=1,512
c         IF(SWEEP(I,J).GT.-800.AND.SWEEPKEEP(I,J).GT.-800.)THEN
c          SUM=SUM+SWEEP(I,J)-SWEEPKEEP(I,J)
c          NSUM=NSUM+1
c         ENDIF
c        ENDDO
c       ENDDO
cc       write(6,*)'iusewind,sum,nsum = ',iusewind,sum,nsum
c       IF(NSUM.GT.0)THEN
c        DIFFMEAN=SUM/NSUM
c        CHANGE=0.
c        IF(DIFFMEAN.GT.XXNIQ)THEN
c         CHANGE=-XXNIQ2
c        ELSEIF(DIFFMEAN.LT.-XXNIQ)THEN
c         CHANGE=XXNIQ2
c        ENDIF
c        write(6,*)'right change = ',change
c        IF(CHANGE.NE.0.)THEN
c         write(6,*)'changing'
c         DO J=1,JMAX
c          DO I=1,512
c           IF(SWEEP(I,J).GT.-800.)THEN
c            SWEEP(I,J)=SWEEP(I,J)+CHANGE
c           ENDIF
c          ENDDO
c         ENDDO
c        ENDIF
c       ENDIF
c      ENDIF
c      IUSETEST=0
c      DO J=NUM_RAYS-1,1,-1
c       JMIN=J+1
cc       WRITE(6,*)'J,AZ_EL = ',J,AZ_EL(1,J)
c       IF(AZ_EL(1,J).LT.180..AND.AZ_EL(1,J).GT.40.)GO TO 778
c       I=1
c       DO WHILE(I.LE.511)
c        IF(SWEEP(I,J).GT.-800.AND.SWEEP(I,J+1).GT.-800.)THEN
c         NSUM=0
c         SUM=0
c         N=ISEGE(I,J)
c         DO L=I,N
c          IF(SWEEP(L,J).GT.-800.AND.SWEEP(L,J+1).GT.-800.)THEN
c           SUM=SUM+SWEEP(L,J)-SWEEP(L,J+1)
c           NSUM=NSUM+1
c          ENDIF
c         ENDDO
c         IF(NSUM.GE.1)THEN
c          IUSETEST=1
c          DIFMEAN=SUM/NSUM
c          IF(DIFMEAN.GT.XXNIQ)THEN
c           CHANGE=NINT(DIFMEAN/XXNIQ2)*XXNIQ2
cc           write(6,*)'j,nsum,difmean,change,xxniq,xxniq2 = ',
cc     1      j,nsum,difmean,change,xxniq,xxniq2
c           DO L=I,N
c            IF(SWEEP(L,J).GT.-800.)SWEEP(L,J)=SWEEP(L,J)-CHANGE
c           ENDDO
c          ELSEIF(DIFMEAN.LT.-XXNIQ)THEN
c           CHANGE=NINT(DIFMEAN/XXNIQ2)*XXNIQ2
cc           write(6,*)'j,nsum,difmean,change,xxniq,xxniq2 = ',
cc     1      j,nsum,difmean,change,xxniq,xxniq2
c           DO L=I,N
c            IF(SWEEP(L,J).GT.-800.)SWEEP(L,J)=SWEEP(L,J)-CHANGE
c           ENDDO
c          ENDIF
c         ENDIF
c         I=N+1
c        ELSE
c         I=I+1
c        ENDIF
c       ENDDO        
c      ENDDO
c778   NSUM=0
c      SUM=0.
c      DO J=JMIN,NUM_RAYS
c       DO I=1,512
c        IF(SWEEP(I,J).GT.-800.AND.
c     1      VRRAD(I,J).GT.-800.)THEN
c         DIFF=SWEEP(I,J)-VRRAD(I,J)
c         NSUM=NSUM+1
c         SUM=SUM+DIFF
c        ENDIF
c       ENDDO
c      ENDDO
c      IF(NSUM.GT.0)THEN
c       IUSETEST=1
c       DIFF=SUM/FLOAT(NSUM)
c       write(6,*)'difference on left side is ',DIFF
c       IF(ABS(DIFF).GT.XXNIQ)THEN
c        IF(DIFF.GT.0.)THEN
c         VCHANGE=-XXNIQ2
c        ELSE
c         VCHANGE=XXNIQ2
c        ENDIF
c        DO J=JMIN,NUM_RAYS
c         DO I=1,512
c          IF(SWEEP(I,J).GT.-800.)THEN
c           SWEEP(I,J)=SWEEP(I,J)+VCHANGE
c          ENDIF
c         ENDDO
c        ENDDO
c       ENDIF
c      ELSE
c       IUSETEST=0
c      ENDIF
c      IF(IUSEWIND.NE.1.OR.IUSETEST.NE.1)THEN
c       NSUM=0
c       SUM=0
c       DO J=JMIN,NUM_RAYS
c        DO I=1,512
c         IF(SWEEP(I,J).GT.-800.AND.SWEEPKEEP(I,J).GT.-800.)THEN
c          SUM=SUM+SWEEP(I,J)-SWEEPKEEP(I,J)
c          NSUM=NSUM+1
c         ENDIF
c        ENDDO
c       ENDDO
c       WRITE(6,*)'LEFT SIDE SUM,NSUM = ',SUM,NSUM
c       IF(NSUM.GT.0)THEN
c        DIFFMEAN=SUM/NSUM
c        CHANGE=0.
c        IF(DIFFMEAN.GT.XXNIQ)THEN
c         CHANGE=-XXNIQ2
c        ELSEIF(DIFFMEAN.LT.-XXNIQ)THEN
c         CHANGE=XXNIQ2
c        ENDIF
c        write(6,*)'left change = ',change
c        IF(CHANGE.NE.0.)THEN
c         write(6,*)'changing'
c         DO J=JMIN,NUM_RAYS
c          DO I=1,512
c           IF(SWEEP(I,J).GT.-800.)THEN
c            SWEEP(I,J)=SWEEP(I,J)+CHANGE
c           ENDIF
c          ENDDO
c         ENDDO
c        ENDIF
c       ENDIF
c      ENDIF
c      RETURN
c      END
      SUBROUTINE GROUNDCHECK(SWEEP,SWEEPZ,NUM_RAYS,I,JSTART,ICHECK,
     + ZRSWEEP,RD)
      REAL SWEEP(512,800),SWEEPZ(512,800),ZRSWEEP(512,800)
      REAL RD(512)
      IF(ICHECK.LT.1.OR.ICHECK.GT.2)THEN
       WRITE(6,*)'PROBLEM WITH ICHECK IN GROUNDCHECK'
       STOP
      ENDIF
      IF(SWEEPZ(I,JSTART).GT.-32.)THEN
       WRITE(6,*)'SWEEP(I,JSTART) GT -999.'
       WRITE(6,*)'ICHECK,I,JSTART,SWEEP,SWEEPZ = ',
     +  ICHECK,I,JSTART,SWEEP(I,JSTART),SWEEPZ(I,JSTART)
       STOP
      ENDIF
      IDBZTEST=0
      IF(ICHECK.EQ.1)THEN
       IF(JSTART.LT.5)THEN
        DO J=JSTART,1,-1
         SWEEPZ(I,J)=-32.
         SWEEP(I,J)=-888.8
        ENDDO
        RETURN
       ELSE
        IF(SWEEPZ(I,JSTART-1).GT.40..OR.
     +     SWEEPZ(I,JSTART-4).GT.40.)IDBZTEST=1
c        IF(IDBZTEST.GT.0)WRITE(6,*)'BEFORE RIGHT,JSTART,SWEEPZ = ',
c     +    JSTART,(SWEEPZ(I,J),J=JSTART-9,JSTART)
       ENDIF
       DO J=JSTART-1,JSTART-3,-1
        IF(SWEEPZ(I,J).GT.-32..AND.SWEEPZ(I,J-1).GT.-32.AND.
     +      SWEEPZ(I,J)-SWEEPZ(I,J-1).GT.5.)THEN
c        IF(SWEEPZ(I,J)-SWEEPZ(I,J-1).GT.10.)THEN
         DO JJ=J,JSTART
          SWEEPZ(I,JJ)=-32.
          SWEEP(I,JJ)=-888.8
         ENDDO
        ENDIF
       ENDDO
c       IF(IDBZTEST.GT.0)WRITE(6,*)'AFTER RIGHT,JSTART,SWEEPZ = ',
c     +   JSTART,(SWEEPZ(I,J),J=JSTART-9,JSTART)
c       IF(IDBZTEST.GT.0)WRITE(6,*)'ZR AFTER RIGHT,JSTART,SWEEPZ = ',
c     +   JSTART,(ZRSWEEP(I,J),J=JSTART-9,JSTART)
c       IF(IDBZTEST.GT.0)WRITE(6,*)'RADIUS = ',RD(I)
c       IF(SWEEPZ(I,JSTART-9).GT.20.)THEN
c        WRITE(6,*)'SWEEPZ(I,JSTART-9) = ',SWEEPZ(I,JSTART-9)
c        WRITE(6,*)'ZRSWEEP(I,JSTART-9) = ',ZRSWEEP(I,JSTART-9)
c       WRITE(6,*)'RADIUS = ',RD(I)
c        PAUSE
c       ENDIF
      ELSE
       IF(NUM_RAYS-JSTART.LT.4)THEN
        DO J=JSTART,NUM_RAYS
         SWEEPZ(I,J)=-32.
         SWEEP(I,J)=-888.8
        ENDDO
        RETURN
       ELSE
        IF(SWEEPZ(I,JSTART+1).GT.40..OR.
     +     SWEEPZ(I,JSTART+4).GT.40.)IDBZTEST=1
c        IF(IDBZTEST.GT.0)WRITE(6,*)'BEFORE LEFT,JSTART,SWEEPZ = ',
c     +   JSTART,(SWEEPZ(I,J),J=JSTART,JSTART+9)
       ENDIF
       DO J=JSTART+1,JSTART+3
c        IF(SWEEPZ(I,J)-SWEEPZ(I,J+1).GT.10.)THEN
        IF(SWEEPZ(I,J).GT.-32..AND.SWEEPZ(I,J+1).GT.-32.AND.
     +      SWEEPZ(I,J)-SWEEPZ(I,J+1).GT.5.)THEN
         DO JJ=J,JSTART,-1
          SWEEPZ(I,JJ)=-32.
          SWEEP(I,JJ)=-888.8
         ENDDO
        ENDIF
       ENDDO
c       IF(IDBZTEST.GT.0)WRITE(6,*)'AFTERLEFT,JSTART,SWEEPZ = ',
c     +            JSTART,(SWEEPZ(I,J),J=JSTART,JSTART+9)
c       IF(IDBZTEST.GT.0)WRITE(6,*)'ZR AFTERLEFT,JSTART,SWEEPZ = ',
c     +            JSTART,(ZRSWEEP(I,J),J=JSTART,JSTART+9)
c       IF(IDBZTEST.GT.0)WRITE(6,*)'RADIUS = ',RD(I)
c       IF(SWEEPZ(I,JSTART+4).GT.20.)THEN
c        WRITE(6,*)'SWEEPZ(I,JSTART+9) = ',SWEEPZ(I,JSTART+9)
c        WRITE(6,*)'ZRSWEEP(I,JSTART+9) = ',ZRSWEEP(I,JSTART+9)
c        WRITE(6,*)'RADIUS = ',RD(I)
c        PAUSE
c       ENDIF
      ENDIF
      RETURN
      END
C ********************
      SUBROUTINE SVGROUNDCHECK(SWEEP,SWEEPZ,NUM_RAYS,I,JSTART,ICHECK)
      REAL SWEEP(512,800),SWEEPZ(512,800)
      IF(ICHECK.LT.1.OR.ICHECK.GT.2)THEN
       WRITE(6,*)'PROBLEM WITH ICHECK IN GROUNDCHECK'
       STOP
      ENDIF
      IF(SWEEPZ(I,JSTART).GT.-32.)THEN
       WRITE(6,*)'SWEEP(I,JSTART) GT -999.'
       WRITE(6,*)'ICHECK,I,JSTART,SWEEP,SWEEPZ = ',
     +  ICHECK,I,JSTART,SWEEP(I,JSTART),SWEEPZ(I,JSTART)
       STOP
      ENDIF
      IF(ICHECK.EQ.1)THEN
       IF(JSTART.LT.5)RETURN
       J=JSTART-4
c       WRITE(6,*)'RIGHT,I,JSTART,VEL = ',I,JSTART,
c     +             (SWEEP(I,L),L=J,JSTART)
c       WRITE(6,*)'RIGHT,I,JSTART,DBZ = ',I,JSTART,
c     +             (SWEEPZ(I,L),L=J,JSTART)
      SWTEST1=SWEEPZ(I,JSTART-1)-SWEEPZ(I,JSTART-3)
      SWTEST2=SWEEPZ(I,JSTART-2)-SWEEPZ(I,JSTART-3)
      IF(SWTEST1.GT.5..OR.SWTEST2.GT.5.)THEN
C       IF((SWEEPZ(I,JSTART-1).GT.-32..OR.SWEEPZ(I,JSTART-2).GT.-32.).
C     +  AND.SWEEPZ(I,JSTART-3).LE.-32.)THEN
        SWEEPZ(I,JSTART-1)=-32.
        SWEEPZ(I,JSTART-2)=-32.
        SWEEPZ(I,JSTART-3)=-32.
        SWEEP(I,JSTART-1)=-888.8
        SWEEP(I,JSTART-2)=-888.8
        SWEEP(I,JSTART-3)=-888.8
       ENDIF
c       WRITE(6,*)'RIGHT,I,JSTART,VEL = ',I,JSTART,
c     +             (SWEEP(I,L),L=J,JSTART)
c       WRITE(6,*)'RIGHT,I,JSTART,DBZ = ',I,JSTART,
c     +             (SWEEPZ(I,L),L=J,JSTART)
      ELSE
       IF(NUM_RAYS-JSTART.LT.4)RETURN
       JEND=JSTART+4
c       WRITE(6,*) 'LEFT,I,JSTART,VEL = ',I,JSTART,
c     +             (SWEEP(I,L),L=JSTART,JEND)
c       WRITE(6,*) 'LEFT,I,JSTART,DBZ = ',I,JSTART,
c     +             (SWEEPZ(I,L),L=JSTART,JEND)
       SWTEST1=SWEEPZ(I,JSTART+1)-SWEEPZ(I,JSTART+3)
       SWTEST2=SWEEPZ(I,JSTART+2)-SWEEPZ(I,JSTART+3)
       IF(SWTEST1.GT.5..OR.SWTEST2.GT.5.)THEN
C       IF((SWEEPZ(I,JSTART+1).GT.-32..OR.SWEEPZ(I,JSTART+2).GT.-32.).
C     +  AND.SWEEPZ(I,JSTART+3).LE.-32.)THEN
        SWEEPZ(I,JSTART+1)=-32.
        SWEEPZ(I,JSTART+2)=-32.
        SWEEPZ(I,JSTART+3)=-32.
        SWEEP(I,JSTART+1)=-888.8
        SWEEP(I,JSTART+2)=-888.8
        SWEEP(I,JSTART+3)=-888.8
       ENDIF
c       WRITE(6,*) 'LEFT,I,JSTART,VEL = ',I,JSTART,
c     +             (SWEEP(I,L),L=JSTART,JEND)
c       WRITE(6,*) 'LEFT,I,JSTART,DBZ = ',I,JSTART,
c     +             (SWEEPZ(I,L),L=JSTART,JEND)
      ENDIF
      RETURN
      END
C ********************
      SUBROUTINE READTAPE(TIME,RLAT,RLON,RA,AZM,EV,BIN,REF,BIN1,REF1,
     +                    RCAZM,ITAPEOPEN,RADARFILE,NUMREC,
     +                    PCORS,DCORS,RCORS,AZMCORS,
     +                    RDELCORTAS,ELCORS)
      COMMON /AREA1/ INM,IFLT,STIME,ETIME,WD,WS,NIX,NGATE1,LP,LUNR,
     +               IVT,RAMFL
      COMMON /TAPEHEADER/ nbytesheader,ntape,nversion,ihheader,imheader,
     +                    isheader,ine,ndrive,naircraft,flightid,stmname
     +                    ,nsamplelf,nsampleta,refslopelf,refslopeta,
     +                    refnoisethreslf,refnoisethresta,sqilf,sqita,
     +                    widththreslf,widththresta,caliblf,calibta,
     +                    modedatalf,modedatata,noisetmlf,noisetmta,
     +                    rpmlf,rpmta,gtlnlf,ivrangelf,ivrangeta,
     +                    gtlnta(3),rdellf,rdelta,rdelcorlf,rdelcorta,
     +                    nbinlf,nbinta,nbins,rmaxlf,rmaxta,
     +                    radiita(512),radiilf(512),prf_flaglf,
     +                    prf_flagta,prf_highlf,prf_highta,xniqlf,
     +                    xniqta,iheader(1024)
      COMMON /RAYHEADER / nbytesdata,nlfsweep,ntasweep,numrecord,
     +                    irecflag,idradar,nbytesray,icode,idsp,mdata,
     +                    iyear,month,iday,iraycode,radtime,ih,im,is,
     +                    is100,radlat,radlon,radalt,gse,gsn,radgs,
     +                    radvgs,ucom,vcom,radwd,radws,radvws,ircu,
     +                    elev,radazm,pitch,roll,drift,heading,
     +                    dbzbuffer(512),velbuffer(512),widthbuffer(512)
      COMMON /PARAMS/ trakazm,trakelev,driftnew,
     +                rot,track,htbb,dbb,thresh,swthresh,dbzrs,ibst(2),
     +                inob(2),ileg,xniq,irsw,maxnbins,v0,
     +                pcor,dcor,rcor,azmcor,elcor,dbzcor,dbzslope,
     +                iunfoldflag,iattenflag,
     +                badstabflag,surfelimflag,echoflag,atmflag
      LOGICAL badstabflag, surfelimflag, echoflag, atmflag
      INTEGER*2 IHEADER
      INTEGER RTYPE
      INTEGER PRF_FLAGLF, PRF_FLAGTA
      REAL PCORS(2),DCORS(2),RCORS(2),AZMCORS(2)
      REAL RDELCORTAS(2),ELCORS(2)
      CHARACTER FLIGHTID*8,STMNAME*16 
      CHARACTER IFLT*8, INM*12
      CHARACTER *1 RAMFL, IVT
      CHARACTER*80 RADARFILE
      DIMENSION BIN(512),REF(512),BIN1(512),REF1(512)
      DATA RTYPE/6/
C Subroutine to read doppler and Reflectivity data from the new 1988
C format radar tapes.  Reads refl/doppler when rtype=6 and dop/ref/sw when
C rtype=7.  It returns one ray per call.
C NIX = -100 determines an end-of-file
C Read data from tape:
      IHEADERFLAG=1
      DO I=1,512
       BIN(I)=-888.8
       REF(I)=-32.
       BIN1(I)=-888.8
       REF1(I)=-32.
      ENDDO
      IF (SWTHRESH.GT.0.0 .AND. SWTHRESH.LE.13.0) RTYPE=7
c50    write(6,*)'calling radartaperead1'
c      write(6,*)'itapeopen,numrec = ',itapeopen,numrec
c      write(6,'(A80)')radarfile
50    IF(ITAPEOPEN.EQ.0)THEN
       CALL RADARDISCREAD1(LUNR,2,IHEADERFLAG,RTYPE,IERR)
C       CALL RADARFILEREAD(LUNR,2,0,RTYPE,IERR,ITAPEOPEN,RADARFILE,
C     + NUMREC)
      ELSE
       CALL RADARTAPEREAD(LUNR,2,0,RTYPE,IERR)
c       write(6,*)'should not get here 2'
c       stop
       IF(IERR.NE.0)THEN
        write(6,*)'returned from radartaperead ierr = ',ierr
       ENDIF
      ENDIF
      IF(NBINS.LT.512)THEN
       DO I=NBINS+1,512
        RADIITA(I)=0.
       ENDDO
      ENDIF
      IF (IERR .LT. 0) THEN
         NIX= -100
         RETURN
      ENDIF
      IF(ELEV.LT.0.)THEN
       PCOR=PCORS(1)
       DCOR=DCORS(1)
       RCOR=RCORS(1)
       AZMCOR=AZMCORS(1)
       ELCOR=ELCORS(1)
      ELSE
       PCOR=PCORS(2)
       DCOR=DCORS(2)
       RCOR=RCORS(2)
       AZMCOR=AZMCORS(2)
       ELCOR=ELCORS(2)
      ENDIF
C    clear nix variable
      NIX= 0
C    time in seconds  
      TIME=RADTIME
C    raw azimuth
      TRAKAZM=RADAZM
c    roll corrected azimuth but in heading rather than track
      RCAZM=RADAZM+RCOR+ROLL
C    raw elevation
      TRAKELEV=ELEV
C    raw drift
      DRIFTNEW=DRIFT
C    nyquist velocity
      XNIQ=XNIQTA
      track = AMOD(heading + driftnew + 360.0, 360.0)
C ANGLECOR corrects the aircraft pitch,drift,roll,azimuth,elevation and
C adds the roll to the azimuth.
c      write(6,*)'roll,rcor,radazm,rcazm = ',roll,rcor,radazm,rcazm
c      WRITE(6,*)'BEFORE TRAKAZM,TRAKELEV = ',TRAKAZM,TRAKELEV
      CALL ANGLECOR(PITCH,DRIFTNEW,ROLL,TRAKAZM,TRAKELEV,2,PCOR,
     +              DCOR,RCOR,AZMCOR,ELCOR)
c      WRITE(6,*)'AFTER TRAKAZM,TRAKELEV = ',TRAKAZM,TRAKELEV
c      write(6,*)'after roll,trakazm = ',roll,trakazm
C Convert aircraft angles to earth relative shperical coordinates
      CALL CONVERTANGLES(TRACK,TRAKAZM,TRAKELEV,HORAZM,HORELEV)
C    azimuth earth relative
      AZM=HORAZM
C    elevation earth relative
      EV=HORELEV
C get information from the ram files.
      IF (RAMFL .EQ. 'Y')
     *   CALL READRAMFILE(TIME,TIMERAM,RADLAT,RADLON,RADALT,
     *                    RADWD,RADWS,UCOM,VCOM,RADVWS,RADVGS,IOS)
C get information from the radar tape or the standard tape
      GS=RADGS                       !ground speed
      VGS=RADVGS                     !vertical ground speed
      VWS=RADVWS                     !vertical wind speed
      RLAT=RADLAT                    !latitude(deg)
      RLON=RADLON                    !longitude(deg)
      RA=RADALT                      !radar altitude(meters) 
      WD=RADWD                       !wind direction
      WS=RADWS                       !wind speed
C RAYCOR corrects the velocities one ray at a time.  It returns the airplane
C track, the first guess wind, the stabilized, vt corrected and unfolded
c velocities as well as the dbz values from the tail radar.
      IUNFOLDFLAG=0
      CALL RAYCOR1(BIN1,REF1)
      IUNFOLDFLAG=0
      CALL RAYCOR1(BIN,REF)
      IUNFOLDFLAG=0
      RETURN
      END 
C ********************
      BLOCK DATA
      COMMON /AREA1/ INM,IFLT,STIME,ETIME,WD,WS,NIX,NGATE1,LP,LUNR,
     +               IVT,RAMFL
      COMMON /PARAMS/ trakazm,trakelev,driftnew,
     +                rot,track,htbb,dbb,thresh,swthresh,dbzrs,ibst(2),
     +                inob(2),ileg,xniq,irsw,maxnbins,v0,
     +                pcor,dcor,rcor,azmcor,elcor,dbzcor,dbzslope,
     +                iunfoldflag,iattenflag,
     +                badstabflag,surfelimflag,echoflag,atmflag
      LOGICAL badstabflag, surfelimflag, echoflag, atmflag
      CHARACTER IFLT*8, INM*12
      CHARACTER *1 RAMFL, IVT
      DATA NIX/0/, NGATE1/5/, IVT/'N'/, RAMFL/'N'/ 
      DATA rot/0.0/, htbb/-99./, dbb/2.0/, thresh/-99.0/, swthresh/99./,
     1     dbzrs/-99./, ibst/2*0/, inob/2*0/, ileg/1/, xniq/12.8/,
     2     irsw/0/, maxnbins/512/, 
     3     pcor,dcor,rcor,azmcor,elcor,dbzcor/6*0.0/, dbzslope/1.0/,
     4     iunfoldflag/0/, iattenflag/0/,
     5     badstabflag/.true./, surfelimflag/.false./,
     6     echoflag/.false./, atmflag/.true./
      END 
      SUBROUTINE VRLOCATER(TIMES,OLAT,OLON,
     + RLAT,RLON,ALT,ELEV,AZIM,RANGE,XR,YR,ZR,
     + ISCANDIM,SMOTIONU,SMOTIONV,CENTIME,BIN,REF)
      REAL RANGE(ISCANDIM),XR(ISCANDIM),YR(ISCANDIM),ZR(ISCANDIM)
      REAL SUM(1024),WSUM(1024),WEIGHT(200),VR(1024)
      REAL BIN(ISCANDIM),REF(ISCANDIM)
c      WRITE(6,*)'OLAT,OLON,RLAT,RLON,ALT,ELEV,AZIM = ',
c     + OLAT,OLON,RLAT,RLON,ALT,ELEV,AZIM
c      WRITE(6,*)'RANGE = ',RANGE
      RALT=ALT/1000.
      PI=ASIN(1.0)*2.
      DTR=PI/180.
      REARTH=6366.
C      SMOTIONU=0.
C      SMOTIONV=0.
      TDIFF=TIMES-CENTIME
c      write(6,*)'olat,rlat,times,centime,tdiff,smotionu,smotionv = ',
c     + olat,rlat,times,centime,tdiff,smotionu,smotionv
C      TDIFF=0.
C      JBINS=IBINS*3
c      DO I=1,ISCANDIM
c       SUM(I)=0
c       WSUM(I)=0
c       ISTART=I-JBINS
c       IEND=I+JBINS
c       IF(ISTART.LT.1)ISTART=1
c       IF(IEND.GT.ISCANDIM)IEND=ISCANDIM
c       DO J=ISTART,IEND
c        IF(VR(J).GT.-900.)THEN
c         IDIFF=J-I
c         IDIFF=IABS(IDIFF)
c         WSUM(I)=WSUM(I)+WEIGHT(IDIFF)
c         SUM(I)=SUM(I)+WEIGHT(IDIFF)*VR(J)
c        ENDIF
c       ENDDO
c      ENDDO
c      DO I=1,ISCANDIM
c       IF(WSUM(I).LE.0..AND.VR(I).LE.-900.)THEN
c        VR(I)=-999.9
c       ELSE
c        VR(I)=SUM(I)/WSUM(I)
c       ENDIF
c      ENDDO
      XSHIFT=TDIFF*SMOTIONU/1000.
      YSHIFT=TDIFF*SMOTIONV/1000.     
c      write(6,*)'xshift,yshift = ',xshift,yshift
      RAZIM=AZIM*DTR
      RELEV=ELEV*DTR
      DO I=1,ISCANDIM
       IF(BIN(I).GT.-800..OR.REF(I).GT.-31.9)THEN
c xradar=horizontal distance from aircraft
c yradar=vertical distance from center of earth
       XRADAR=RANGE(I)*COS(RELEV)
       YRADAR=REARTH+RALT+RANGE(I)*SIN(RELEV)
c radnew=distance of datum from center of earth
       RADNEW=SQRT(XRADAR*XRADAR+YRADAR*YRADAR)
c delangle=angle between vertical at aircraft and vertical at datum
       DELANGLE=ATAN(XRADAR/YRADAR)
c distance along great circle from radar to datum
       DISTANCE=.5*(RADNEW+REARTH+RALT)*DELANGLE
c height=altitude of datum
       HEIGHT=RADNEW-REARTH
c distance2=xradar
       DISTANCE2=RANGE(I)*COS(RELEV)
c height2=altitude of datum not accounting for earth's curvature
       HEIGHT2=RALT+RANGE(I)*SIN(RELEV)
c delx=distance (aircraft/datum) along great circle due to east west
       DELY=DISTANCE*SIN(RAZIM)
c dely=distance(aircraft/datum)along great circle due to north-south
       DELX=DISTANCE*COS(RAZIM)
c dx=east west distance from origin to aircraft
       XLAT=.5*(RLAT+OLAT)*DTR
       DX=(RLON-OLON)*DTR*REARTH*COS(XLAT)
c dy=north south distance from origin to aircraft
       DY=(RLAT-OLAT)*DTR*REARTH
c xshift=east-west distance from lower left corner to origin
c yshift=north-south distance from lower left corner to origin
c XR=distance of datum from lower left corner
c YR=distance of datum from lower left corner
       XR(I)=DELX+DX-XSHIFT
c yshift=distance from lower left corner to origin
       YR(I)=DELY+DY-YSHIFT
       ZR(I)=HEIGHT
c       WRITE(6,*)'I,RANGE,DISTANCE,HEIGHT,DELX,DELY,DX,DY,XSHIFT,'
c     +  'YSHIFT = ',
c     +  I,RANGE(I),DISTANCE,HEIGHT,DELX,DELY,DX,DY,XSHIFT,YSHIFT
      ELSE
       XR(I)=-888.8
       YR(I)=-888.8
       ZR(I)=-888.8
       ENDIF
      ENDDO
c      WRITE(6,*)'XR = ',XR
c      WRITE(6,*)'YR = ',YR
c      WRITE(6,*)'ZR = ',ZR
      CONTINUE
      RETURN
      END
	subroutine find_ground(rdtai,deg2rad, beam_wid, 
     +		rs_th, rs_m, dBz_max, ibeg, Ng2, 
     +          elcorf, azmcorf, ra_new)
C Find the surface, as in Testud's memo.
      COMMON /TAPEHEADER/ nbytesheader,ntape,nversion,ihheader,imheader,
     +                    isheader,ine,ndrive,naircraft,flightid,stmname
     +                    ,nsamplelf,nsampleta,refslopelf,refslopeta,
     +                    refnoisethreslf,refnoisethresta,sqilf,sqita,
     +                    widththreslf,widththresta,caliblf,calibta,
     +                    modedatalf,modedatata,noisetmlf,noisetmta,
     +                    rpmlf,rpmta,gtlnlf,ivrangelf,ivrangeta,
     +                    gtlnta(3),rdellf,rdelta,rdelcorlf,rdelcorta,
     +                    nbinlf,nbinta,nbins,rmaxlf,rmaxta,
     +                    radiita(512),radiilf(512),prf_flaglf,
     +                    prf_flagta,prf_highlf,prf_highta,xniqlf,
     +                    xniqta,iheader(1024)
C
      COMMON /RAYHEADER / nbytesdata,nlfsweep,ntasweep,numrecord,
     +                    irecflag,idradar,nbytesray,icode,idsp,mdata,
     +                    iyear,month,iday,iraycode,time,ih,im,
     +                    is,is100,rlat,rlon,ra,gse,gsn,gs,vgs,
     +                    ucom,vcom,wd,ws,vws,ircu,
     +                    elev,azm,pitch,roll,drift,heading,
     +                    dbzbuffer(512),velbuffer(512),widthbuffer(512)
	CHARACTER FLIGHTID*8,STMNAME*16
	integer*2 iheader
	real lambda
        real rdtai(512)
C
	theta = (elev +elcorf) * deg2rad ! tilt relative to plane 
c                                          perp to radar axis
	beta = pitch * deg2rad
C In Testud's form, 0 is down, -90 port, 90 starboard:
	phi = (180 - (azm +azmcorf + roll) ) * deg2rad 
	epsilon = beam_wid * deg2rad
C Now get elevation of beam rel to horizontal plane through radar
	sn_lambda = sin(theta) * sin(beta) - 
     *			cos(theta) * cos(beta) * cos(phi)
	lambda = asin(sn_lambda)
C Find theoretical range of surface. - sign because lambda neg
	rs_th = -ra / sn_lambda ! ra in m, radiita in km
C Find # of gates intersecting surface at theoretical range
C This would be formula if dR was constant:
C	Ng = rs_th * epsilon / (dR * tan(lambda) )
C But we may have varying beamwidths, so
Cout	slant_depth = -rs_th * epsilon / tan(lambda) ! slight approximation
Cout	rs_th_in = ( rs_th - slant_depth * 0.5 ) * 0.001
Cout	rs_th_out = ( rs_th + slant_depth * 0.5 ) * 0.001
C mod dec 8 92:
	rs_th_in = -ra / sin(lambda - epsilon * 0.75) * 0.001
	rs_th_out = -ra / sin(lambda + epsilon * 0.75) * 0.001
	rs_km = rs_th * 0.001
c        write(6,*)'rs_th_in,rs_km,rs_th_out = ',
c     +             rs_th_in,rs_km,rs_th_out
	in = -1
        iout = -1
	do i = 1, 512
	    if( radiita(i) .gt. 0.0 )then
		if(radiita(i) .lt. rs_th_in) in = i
		if(radiita(i) .le. rs_th_out) iout = i
		if(radiita(i) .le. rs_km) Nr = i
	    end if
	end do
	if(in .eq. -1.or.iout.eq.-1)then
		WRITE(6,*)' find_ground failure!'
		WRITE(6,*)' ra:',ra
		WRITE(6,*)'azm, phi: ', azm, phi
		WRITE(6,*)'pitch, drift, roll: ',pitch, drift, roll
		WRITE(6,*)'el, sin(lambda), lambda:',elev, 
     +			sn_lambda, lambda
		WRITE(6,*)'rs_th_in, rs_th_out, rs_km:'
		WRITE(6,*)rs_th_in, rs_th_out, rs_km
		WRITE(6,*)' find_gs in, iout, Nr: ',in, iout, Nr
c		pause ' pausing for this mystery '
		ibeg = -1
                ra_new=-1.
		return
	end if
	Ng = iout - in
c	Ng = iout - in + 1
        Ng2 = Ng
c	Ng2 =  0.5 * Ng
c	if (Ng2 .eq. 0) Ng2 = 1
c        write(6,*)'in,iout,ng,ng2,nr = ',in,iout,ng,ng2,nr
C changed radius of check to 30 bins = 2.25 km, because of huge
C range delays in Andrew 8 dec 92
C Then search the gates within +- 30 of gate at theoretical
C range to find the swath Ng/2 wide with greatest Total Ze.
C Return bounding bins.
	dBz_max = -1.0
	ibeg = -1
        if(ng2.gt.30)then
         n30=ng2
        else
         n30=30
        endif
	ist = max(1, Nr - n30)
	ien = min(512-Ng2, Nr + n30 -Ng2)
c	WRITE(6,*)'find_gd ist, ien: ',ist, ien
	do i = ist, ien
	   dBzsum = 0.0
	   do j = i, i + Ng2
		dBzsum = dBzsum + dbzbuffer(j)
c                dbzsum = dbzbuffer(i+Ng2)-dbzbuffer(i)
	   end do
	   if( dBzsum .gt. dBz_max)then
		dBz_max = dBzsum
		ibeg = i
	   end if
	end do
	iradius = ibeg + Ng2 * 0.5
	if( iradius .le.0) iradius = 1
        if( iradius .gt.512) iradius = 512
	rs_m = radiita( iradius ) * 1000.0
        if(sn_lambda.gt.-.25)then
         ra_new=-1.
        elseif(sin(phi).gt.0.)then
         ra_new=sn_lambda*rs_m
        else
         ra_new=sn_lambda*rs_m
        endif
	return
	end
