	subroutine show_iz(ixl, iyb, iz, max_x, max_y,imax,jmax,
     +        zmin,zmax, data_type, too_noisy, ambiguous,
     +		im_struct, display_label)
C convert dBZ or Doppler to 0-15, show on X window
	integer*2 iz(max_x, max_y)
	integer data_type
	integer im_struct(100)
C
	character*32 display_label
	parameter( iras_max = 900, jras_max = 350)
	integer*4 raster(iras_max, jras_max)
C
	do j = 1, jras_max
		do i = 1, iras_max
			raster(i, j) = 0
		end do
	end do
C
	if( data_type .eq. 1) then ! dBZ
	  zscale = 12.0 / (zmax - zmin) ! for colors 2-14
	  do j = 1, jmax
	   do i = 1, imax
	    ival = iz(i, j)
	    if( ival .eq. -9999)then ! missing, set to 0
		icol = 0
	    else
		val = ival * 0.1
		if(val .lt. zmin)then
			icol = 1
		else if(val .gt. zmax)then
			icol = 15
		else
			icol = 2 + (val-zmin) * zscale
		end if
	    end if
	    raster(ixl + i, iyb + j)  = icol
	   end do
	  end do
	else if( data_type .eq. 2) then
		zscale = 12.0 / (zmax - zmin) ! for colors 2-14
		do j = 1, jmax
		    do i = 1, imax
		    	ival = iz(i, j)
			val = ival * 0.1
C in main too_noisy = -200.0, bad-val = -999.9, so this takes care of both:
			if(val .le. too_noisy)then
				icol = 0
C ambiguous = -100.0
			else if(val .le. ambiguous)then
				icol = 1
			else if(val .lt. zmin)then
				icol = 0
			else if(val .gt. zmax)then
				icol = 15
			else
				icol = 2 + (val-zmin) * zscale
			end if
                        IAX=IXL+I
                        IAY=IYB+J
c                        WRITE(6,*)'IAX,IAY = ',IAX,IAY
       	if(iax.gt.0.and.iay.gt.0.and.iax.le.iras_max.and.
     +     iay.le.jras_max)raster(ixl + i, iyb + j)  = icol
c                        write(6,*)'ixl +i, iyb +j = ',ixl +i,iyb +j
c       	                raster(ixl + i, iyb + j)  = icol
		    end do
	  end do
	end if
        call rasx_display_image(iras_max, raster, im_struct,
     +		display_label)
C and outline area:
	call x_tvline(ixl, iyb, ixl + imax, iyb, 15,im_struct)
	call x_tvline(ixl+imax, iyb, ixl + imax, iyb+jmax, 15,im_struct)
	call x_tvline(ixl, iyb+jmax, ixl + imax, iyb+jmax, 15,im_struct)
	call x_tvline(ixl, iyb, ixl, iyb + jmax, 15,im_struct)
	return
	end
C --------------------------------------
      subroutine cap_solo(ixl, iyt, imax, jmax, rad_name, radar_id,
     +	project, avg_el, time, mon, day, yr, sx, sy, icol,
     +	data_type, im_struct)
C Text captions 
      parameter(ispac = 20)
	integer*4 im_struct(47)
      integer mon,day,yr
	integer data_type
      character string*21,rad_name*8, project*20,radar_id*4
      character*3 chmon(12)
      save chmon
      data chmon/'Jan','Feb','Mar','Apr','May','Jun','Jul', 
     +        'Aug','Sep','Oct','Nov','Dec'/
      ifont = 1 
       call x_tvtype(ixl,iyt-6*ispac,project,20,ifont,icol,im_struct) 
c date: 
	if( ( mon.ge. 1) .and. ( mon .le. 12 ) )then
	        string(1:3)=chmon(mon)
        	write(string(4:7),'(". ",i2)')day 
		if(yr.lt.1900) yr = yr + 1900
	        write(string(8:13),'(", ",i4)')yr 
	        call x_tvtype(ixl,iyt-ispac,string,13,ifont,
     +			icol,im_struct) 
		call ctme(time,ih,im,is)
		string(1:12)='nn:nn:nn UTC'
		write(string(1:8),'(i2,":",i2.2,":",i2.2)')ih,im,is
	        call x_tvtype(ixl,iyt-2*ispac,string,12,ifont,
     +			icol,im_struct) 
	end if
C domain:
	iwide=imax*sx 
	itall=jmax*sy 
	write(string(1:3),'(i3)')iwide 
	write(string(7:9),'(i3)')itall
	string(4:6)=' x ' 
	string(10:12)=' km' 
	call x_tvtype(ixl,iyt-4*ispac,string,12,ifont,icol,im_struct)
C elevations:
	string(1:11) = 'El nn.n deg'
	write(string(4:7),'(f4.1)')avg_el
        call x_tvtype(ixl,iyt-3*ispac, string, 11, ifont,
     +		icol,im_struct)
c Site ID
	call x_tvtype(ixl,iyt-5*ispac,rad_name,8,ifont,icol,im_struct) 
c where it is:
C	call x_tvtype(ixl,iyt-5*ispac,radnam,10,ifont,icol,im_struct) 
C
	return
	end
C -----
	subroutine color_bar(itype, ixl, iyb, zmin, zmax, nyq_vel,
     +		im_struct)
	character string*21, chdb*8
	real zmin, zmax, nyq_vel
	integer*4 im_struct(47)
C
	ixbl = ixl
	iybb = iyb
	iht = 20
	ixbr = ixl + iht
	icol = 16
	if( itype .eq. 1 ) then 
C Dbz:
	iybb = iyb - 2*iht
        scaling = ( zmax - zmin )/12.0
         do i = 2, 14 
          call x_tvfrec(ixbl+1, (iybb+i*iht)+1, ixbr-1,
     +		(iybb+(i+1)*iht), i, im_struct)
	  idbz1=((i-2)*scaling)+zmin ! low dbz 
	  idbz2=((i-1)*scaling)+zmin ! high dbz 
	  idbzm = idbz1 + (idbz2-idbz1)*0.5
	  write(chdb(1:2),'(i2)')idbzm
	  if((i .eq.2).or.(i.eq.14)) then
		write(chdb(3:6),'(a4)')' dBZ'
		call x_tvtype(ixbr+1,(iybb+i*iht)+2,chdb,6,1,
     +			icol, im_struct)
	  else
		call x_tvtype(ixbr+1,(iybb+i*iht)+2,chdb,2,1,
     +			icol, im_struct)
	  end if
         end do
C
	else if( itype .ge. 2) then
C Doppler
	iybb = iyb - iht
        scaling = ( zmax - zmin )/12.0
	 i = 1
	 call x_tvfrec(ixbl+1, (iybb+i*iht)+1, ixbr-1,
     +		(iybb+(i+1)*iht), i, im_struct)
	 string = 'Range Ambiguous'
	 call x_tvtype(ixbr+1, (iybb+i*iht)+2, string, 15, 1,
     +		icol, im_struct)
	 do i = 2, 14 
	  call x_tvfrec(ixbl+1, (iybb+i*iht)+1, ixbr-1,
     +		(iybb+(i+1)*iht), i, im_struct)
	  idbz1=((i-2)*scaling)+zmin ! low vel 
	  idbz2=((i-1)*scaling)+zmin ! high vel 
	  idbzm = idbz1 + (idbz2-idbz1)*0.5
	  write(chdb(1:3),'(i3)')idbzm
	  if( (i .eq.2).or.(i.eq.14) ) then
	    write(chdb(4:7),'(a4)')' m/s'
	    call x_tvtype(ixbr+1, (iybb+i*iht)+2, chdb, 7, 1,
     +		icol, im_struct)
	  else
	  call x_tvtype(ixbr+1, (iybb+i*iht)+2, chdb, 3, 1,
     +		icol, im_struct)
	  end if
	 end do
	 string = 'Nyquist vel nn.nn m/s'
	 write(string(13:17),'(f5.2)')nyq_vel
         call x_tvtype(ixbl-50,iybb-20,string,21,1,icol,
     +		im_struct) 
C
	end if
	return
	end 
