      SUBROUTINE SWEEPIN(SWEEP,SWEEPZ,MAX_RAYS,MAX_GATES,NUM_RAYS,RDTAI,
     + AZ_EL,ICALLSWEEPIN,NUMREC,VRRAD,UNFVEL,TMP1,TMP2,JINDEX,
     + JIINDEX,NYQ,ILATERSWEEP,SWEEPSAVE,U,V,W,IMX,JMX,KMX,SX,SY,SZ,
     + OLAT,OLON,XZ,YZ,ZZ,IUSEWIND,EAZM,EEV,TMSWEEP,RRLAT,RRLON,RRA,
     + SMOTIONU0,SMOTIONV0,CENTIME0,PELEV,NTASWEEPER,
     + RDWS,RDWD,RDVWS,NBINSPARM,OLATOUT,OLONOUT)
C
C     QUALITY CONTROL SUBROUTINE CALLED BY SUBROUTINE ABCD (ABCD_SCAN_RT4.F)
C       
C ... FUNCTION:   
C       
C     THIS SUBROUTINE READS THE RADAR TAPES OR FORTRAN-BINARY COPIES OF THEM
C     AND WRITES (REDUCED-RESOLUTION) RAYS OF DOPPLER DATA WHICH ARE THEN SENT 
C     BACK TO SUBROUTINE ABCD TO BE INTERPOLATED.
C
C     THE QUALITY CONTROL PROCEEDS AS FOLLOWS:
C
C     1) CORRECT AZI AND ELEV ANGLES FOR AIRCRAFT PITCH, DRIFT AND ROLL (READTAPE-->ANGLECOR)
C     2) ADD SYSTEMATIC AZI AND ELEV ANGLE CORRECTIONS FROM JOBFILE (READTAPE-->ANGLECOR)
C     3) FLAG NEGATIVE RANGE VALUES, SPECTRAL WIDTH THRESHOLD, REMOVE AIRCRAFT MOTION (READTAPE-->RAYCOR1)
C     4) FLAG DBZ,VR GATES...SOMETHING INVOLVING TRACKDIFF>2 AND |ELEV|<0.001 (SWEEPIN)
C     5) FLAG VR VALUES FOR WHICH ROLL>10, FLAG DBZ,VR FOR DBZ>60 (SWEEPIN) 
C     6) IF N42 AND (WIND SPEED FROM RADAR TAPE)*TANDIF>1200, FLAG VR VALUES (SWEEPIN)
C     7) FLAG SURFACE IN DBZ,VR (SWEEPIN)
C     8) FLAG SWEEP VR IF |W_FL|_MAX>30 M/S OR |AVG(W_FL)|>15 M/S (SWEEPIN)
C     9) SOMETHING INVOLVING RADIFFTEST, SELECT BINS, AND DBZ,VR FLAGS (SWEEPIN)
C    10) SOMETHING INVOLVING LEFT/RIGHT DOWNWARD POINTING RAYS, FLAG DBZ,VR (GROUNDCHECK...AZIMUTHAL GRADIENT)
C    11) FLAG VR VALUES NOT ADEQUATELY SURROUNDED BY GOOD DATA -- DESPECKLE? (SWEEPIN)
C    12) FLAG VR BEYOND 1KM GAPS (SWEEPIN)
C    13) DEFRECKLE VR (DEFRECKLE)
C    14) BARGEN AND BROWN UNFOLDING (UNFLDNEW)
C    15) "AZIMUTHAL CONTINUITY" UNFOLDING (AZIUNFLD)
C
C     NOTE: -999.9 --> 
C           -888.8 --> TYPICAL VR FLAG
C            -32.0 -->
C
C     CURRENT QUESTIONS:
C
C     WHERE ARE RANGE DELAY CORRECTIONS MADE --> (RADARDISCREAD1)
C     AND WHERE IS SIDELOBE REMOVAL PERFORMED (IRINSIDE ETC)
C        FALL SPEED REMOVED IN SYNTHESIS 
C
C ... SWEEPIN SUBPROGRAM REFERENCES:      
C       
C          OPENRAMFILE & MAKEATTENTABLE1 (PRESENTLY NOT USED)
C          TAPEOPEN, TAPECONTROL, TAPESEARCH (PRESENTLY NOT USED) 
C          DISCSEARCH, OPENRADARFILE, READTAPE, FINDIDAYS
C          VRLOCATER, CTME1, FIND_GROUND, GROUNDCHECK
C          DEFRECKLE, UNFLDNEW, AZIUNFLD
C 
C ... ADDITIONAL INFO ON SELECT SUBPROGRAMS:
C
C          READTAPE - READS MERGED TAPES AND RETURNS ONE RECORD
C          UNFLDNEW - VERSION OF UNFLD WRITTEN SINCE LAST CHANGES IN BIGLIB
C          AZIUNFLD - VERSION OF UNFOLDING THAT DEMANDS AZIMUTHAL CONTINUITY
C
C ... IMPORTANT FLAGS: <()> INDICATES DEFAULT
C   
C          ICALLSWEEPIN   SWITCH FROM (0) TO (1) UPON CALLING SWEEPIN ONCE
C          IUSEWIND       USE A GUESS WIND FIELD <(0)> NO (1) YES 
C          IATTEN         ADD INTERVENING ATTENUATION <(0)> NO (1) YES
C          ITAPEOPEN      READ FROM <(0)> BINARY FILE OR (1) DATA TAPE
C          IFLIGHTCHECK   SWITCH FROM (0) TO (1) DURING FIRST SWEEPIN CALL
C          IFILECHECK     HAS NO PURPOSE IF ITAPEOPEN IS ZERO
C          ISWEEPSET      NEED TO SORT THROUGH THIS ONE...
C          ITIMECHECK     SERVES NO REAL PURPOSE IN CODE
C          IFRANCE        ANTENNA (0) NOAA (1) FRENCH
C          INEWRAD        ??
C
C     NOTES REGARDING LOGICAL UNITS:
C
C     UNIT(1)     USER'S TERMINAL
C     UNIT(LUNR)  TAPE DRIVE LU #
C     UNIT(LP)    LINE PRINTER LU #. (6/7 DOT MATRIX PRINTER)--THIS IS LEGACY
C                   SINCE C IS NOW THE DEFAULT OUTPUT TO THE TERMINAL
C 
C     IF LUNRT IS LESS THAN 6 THEN LUNR IS SET TO 80.  THIS IS A SIGNAL TO
C     READTAPE TO READ FROM A FORTRAN BINARY FILE INSTEAD OF A DATA TAPE
C      
C     VERSION:  <TBD>
C       
C     CODE WRITTEN BY:  JOHN GAMACHE   
C                       HRD/AOML/NOAA          
C                       MIAMI, FL 33149      
C       
C     FOR ADDITIONAL DETAILS ON THE ALGORITHM SEE <TBD>
C       
C     BASED ON THEORY BY:  <TBD>
C       
C     REFERENCE THE BOOK:  <TBD>
C       
C     **************************************************  
C     *               IMPORTANT NOTE                   *  
C     *                                                *  
C     *                    <TBD>                       *  
C     *                                                *  
C     **************************************************         
C
C     SPECIFICATIONS FOR ARGUMENTS
C 
      COMMON /AREA1/ INM,IFLT,STIME,ETIME,WD,WS,NIX,NGATE1,LP,LUNR,
     +               IVT,RAMFL
      COMMON /TAPEHEADER/ nbytesheader,ntape,nversion,ihheader,imheader,
     +                    isheader,ine,ndrive,naircraft,flightid,stmname
     +                    ,nsamplelf,nsampleta,refslopelf,refslopeta,
     +                    refnoisethreslf,refnoisethresta,sqilf,sqita,
     +                    widththreslf,widththresta,caliblf,calibta,
     +                    modedatalf,modedatata,noisetmlf,noisetmta,
     +                    rpmlf,rpmta,gtlnlf,ivrangelf,ivrangeta,
     +                    gtlnta(3),rdellf,rdelta,rdelcorlf,rdelcorta,
     +                    nbinlf,nbinta,nbins,rmaxlf,rmaxta,
     +                    radiita(512),radiilf(512),prf_flaglf,
     +                    prf_flagta,prf_highlf,prf_highta,xniqlf,
     +                    xniqta,iheader(1024)
      COMMON /RAYHEADER / nbytesdata,nlfsweep,ntasweep,numrecord,
     +                    irecflag,idradar,nbytesray,icode,idsp,mdata,
     +                    iyear,month,iday,iraycode,radtime,ih,im,is,
     +                    is100,radlat,radlon,radalt,gse,gsn,radgs,
     +                    radvgs,ucom,vcom,radwd,radws,radvws,ircu,
     +                    elev,radazm,pitch,roll,drift,heading,
     +                    dbzbuffer(512),velbuffer(512),widthbuffer(512)
      COMMON /PARAMS/ trakazm,trakelev,driftnew,
     +                rot,track,htbb,dbb,thresh,swthresh,dbzrs,ibst(2),
     +                inob(2),ileg,xniq,irsw,maxnbins,v0,
     +                pcor,dcor,rcor,azmcor,elcor,dbzcor,dbzslope,
     +                iunfoldflag,iattenflag,
     +                badstabflag,surfelimflag,echoflag,atmflag
      common /tsearch/ kountrec,firstsweep(2),keylf(1024,2),
     +                 keyta(4096,2),
     +                 numsweep(2),itimex(2),lastpoint(2),
     +                 iheadertime,ioldsweep(2),kwords,nwords,krays,
     +                 ibuf(2048)
      LOGICAL badstabflag, surfelimflag, echoflag, atmflag
      REAL TIMEONE,RLATONE,RLONONE,RAONE,AZMONE,EVONE
      REAL BINONE(512),REFONE(512),RDWD(800),RDWS(800)
      INTEGER*2 IHEADER
      INTEGER OLDTIME,IITEST(5),JJTEST(5),IKEEP(512,800)
      INTEGER PRF_FLAGLF, PRF_FLAGTA
      CHARACTER*1 CAIRCRAFT(3)
      CHARACTER*7 IFLTCHK,IFLTCHK2
      REAL UNFVEL(512,800)
      REAL TMP1(512,800),TMP2(512,800)
      INTEGER JINDEX(512,800),JIINDEX(512,800)
      REAL RDVWS(800)
      REAL SWEEP(512,800),RDTAI(512),AZ_EL(2,800)
      REAL PELEV(800),RDTAIIN(512)
      REAL VROUT(512,800)
      REAL PAZM(800)
      REAL SWEEPSAVE(512,800)
      REAL PCORS(2),DCORS(2),RCORS(2)
      REAL AZMCORS(2),RDELCORTAS(2),ELCORS(2)
      REAL RAY(512),URAY(512),V0SAVE(800)
      REAL VRRAD(512,800),NYQ(512,800)
      REAL SWIDTH(512,800),SWONE(800)
      REAL XRSWEEP(512,800),YRSWEEP(512,800),ZRSWEEP(512,800)
      REAL XRMIN(512,800),YRMIN(512,800),ZRMIN(512,800)
      REAL XRMAX(512,800),YRMAX(512,800),ZRMAX(512,800)
      REAL AZMIN(512,800),AZMAX(512,800)
      REAL SWEEPZ(512,800),ZDIFF(512,800)
      REAL ZMIN(512,800),ZMAX(512,800)
      REAL XR(512),YR(512),ZR(512)
      REAL U(IMX,JMX,KMX),V(IMX,JMX,KMX),W(IMX,JMX,KMX)
      REAL EAZM(800),EEV(800),RRLAT(800),RRLON(800),RRA(800)
      REAL TRACKSTORE(800),HEADSTORE(800)
      REAL TMSWEEP(800)
      INTEGER ISEG(512,800),ISEGB(512,800),ISEGE(512,800)
      CHARACTER CDUMMY*80
      CHARACTER FLIGHTID*8,STMNAME*16,DUMMYREAD*1
      CHARACTER IFLT*8, INM*12
      CHARACTER *1 TAPE, RAMFL, IVT, IATTEN, IYES
      CHARACTER *80 NAMERAM, IFILE, NAMEO
      CHARACTER*80 RADARFILE
      DIMENSION BIN(512),REF(512),BIN1(512),REF1(512)
C 
      SAVE
C
C     Variables in Common Block and Main Program:
C     NIX - Flag for end-of-file/end-of-tape.(NIX=-100).
C     NGATE1 - Gate number to start mapping the data, for negative range del.
C     IFLT/INM - Flight date/ project name.
C     STIME/ETIME - Starting/Ending times of disc file in seconds.
C     WD/WS - Wind direction(deg) and Wind Speed (m/s).
C     IVT - flag to calculate  and subtract the terminal velocity (y/n).
C     RAMFL - flag to open and read the ram data with the GPS information.
C     XR,YR,ZR - east-west,north-south,and vertical distances of radar gate
C      from the radar
C
C ... DESCRIPTION OF ARGUMENTS
C
C     SWEEP(GATE,RAY)     - DOPPLER RADIAL VELOCITY FOR GIVEN GATE AND RADIAL (M/S)
C     SWEEPZ(GATE,RAY)    - REFLECTIVITY FOR GIVEN GATE AND RADIAL (DBZ)
C     MAX_GATES           - MAX NO. OF GATES STORED FOR EACH RADIAL
C     MAX_RAYS            - MAX NO. OF RADIALS EXPECTED IN A FULL SWEEP
C     NUM_RAYS            - RADIAL COUNTER
C     RDTAI(GATE)         - ??
C     AZ_EL(1/2,RAY)      - 1/2 RAW AZIMUTH/ELEVATION ANGLE FOR GIVEN RADIAL (AIRCRAFT RELATIVE, DEG)
C     NUMREC              - NUMBER OF RECORDS (APPEARS TO BE 1)
C     VRRAD(GATE,RAY)     - ??     
C     UNFVEL(GATE,RAY)    - NOT USED
C     TMP1(GATE,RAY)      - NOT USED
C     TMP2(GATE,RAY)      - NOT USED
C     JINDEX(GATE,RAY)    - NOT USED
C     JIINDEX(GATE,RAY)   - NOT USED    
C     NYQ(GATE,RAY)       - ASSIGNED A VALUE IN SWEEPIN, BUT NOT USED
C     SWEEPSAVE(GATE,RAY) - ASSIGNED A VALUE IN SWEEPIN, BUT NOT USED
C     U,V,W               - GUESS WIND FIELD (TYPICALLY ZERO)
C     IMX,JMX,KMX         - GUESS WIND RADIAL,AZI,VERTICAL ARRAY DIMENSION
C     SX,SY,SZ            - GUESS WIND RADIAL,AZI,VERTICAL GRID SPACING (KM,DEG,KM)
C     OLAT,OLON           - GUESS WIND LAT,LON OF GRID ORIGIN
C     XZ,YZ,ZZ            - GUESS WIND MIN RADIUS,AZI,HEIGHT (KM,DEG,KM)
C     EAZM(RAY)           - AZIMUTH ANGLE FOR GIVEN RADIAL (EARTH RELATIVE, DEG)
C     EEV(RAY)            - ELEVATION ANGLE FOR GIVEN RADIAL (EARTH RELATIVE, DEG)
C     TMSWEEP(RAY)        - TIME OF EACH RADIAL (S)
C     RRLAT,RRLON(RAY)    - RADAR LAT,LON FOR GIVEN RADIAL
C     RRA(RAY)            - RADAR ALTITUDE FOR GIVEN RADIAL
C     SMOTIONU0,SMOTIONV0 - STORM MOTION (M/S)
C     CENTIME0            - ANALYSIS TIME (S)
C     PELEV(RAY)          - ELEVATION ANGLE (AIRCRAFT RELATIVE, DEG)
C     NTASWEEPER          - ??
C     RDWS(RAY)           - FLIGHT-LEVEL WIND SPEED FOR GIVEN RADIAL (M/S)
C     RDWD(RAY)           - FLIGHT-LEVEL WIND DIRECTION FOR GIVEN RADIAL (DEG)
C     RDVWS(RAY)          - FLIGHT-LEVEL VERTICAL WIND SPEED FOR GIVEN RADIAL (M/S)
C     NBINSPARAM          - ??
C     OLATOUT,OLONOUT     - LAT,LON OF GRID ORIGIN (STORM CENTER)
C
C     SPECIFICATIONS FOR LOCAL VARIABLES
C

C
C ... DESCRIPTION OF VARIABLES PASSED BETWEEN SUBROUTINES
C  
C **** VRLOCATER
C 
CCTIMES,OLAT,OLON,RLAT,RLON,RA,EV,AZM,RDTAIIN,XR,YR,ZR,ISCANDIM,SMOTIONU,SMOTIONV,CENTIME
C
C **** OPENRAMFILE
C 
CCNAMERAM,LP,STIMERAM,ETIMERAM,DATARATE,IERR
C
C **** TAPEOPEN
C 
CCLUNRT,LUNR
C
C **** OPENRADARFILE
C 
CCRADARFILE,IERROPEN
C
C **** READTAPE
C 
CCTIME,BIN,REF,RCAZM,NUMREC,PCORS,DCORS,RCORS,AZMCORS,RDELCORTAS,ELCORS
C
C **** FINDIDAYS
C 
CCIDAYSCHK,NAIRCHK,IFLTCHK
C
C **** TAPESEARCH
C 
CCSTIMESEARCH
C
C **** FIND_GROUND
C 
CCRDTAIIN,DEG2RAD,BEAM_WID,RS_TH,RS_M,DBZ_MAX,IBEG,NG2,IBST1
C 
C **** CTME1
C 
CCIIHH,IIMM,IISS
C
C **** GROUNDCHECK
C 
CCSWEEP,SWEEPZ,NUM_RAYS,I,J,ICHECK
C
C **** DEFRECKLE
C 
CCIMAXBINS,JMAXRAYS,PAZM,VROUT,XNIQTA1
C
C **** UNFLDNEW
C 
CCV00,VN,M,IRS,NB,RAY,URAY,NB
C
C **** AZIUNFLD
C 
CCISEG,ISEGE,MAX_GATES,MAX_RAYS,XXNIQTA,AZ_EL,XXNIQ,VRRAD
C 
      DATA AT1/5.33E-5/, AT2/0.889/
C 
      CAIRCRAFT(1)='H'
      CAIRCRAFT(2)='I'
      CAIRCRAFT(3)='?'
C
C     MAXIMUM GATE BINS
C 
      IMAXBINS=512
C
C     MAXIMUM NUMBER OF RAYS
C 
      JMAXRAYS=800
C 
      IF(IUSEWIND.EQ.1)THEN
       WRITE(6,*)'IUSEWIND = ',IUSEWIND
      ELSE
       WRITE(6,*)'IUSEWIND = ',IUSEWIND
      ENDIF
C
C     SINCE IUSEWIND IS BY DEFAULT ZERO, STORM MOTION IS ZERO
C 
      IF(IUSEWIND.EQ.1)THEN
       SMOTIONU=SMOTIONU0
       SMOTIONV=SMOTIONV0
       CENTIME=CENTIME0
      ELSE
       SMOTIONU=0.
       SMOTIONV=0.
       CENTIME=CENTIME0
      ENDIF
C 
C     INITIALIZE HORIZ WIND SPEED AND DIRECTION, AND VERTICAL WIND SPEED,
C     FOR EACH RAY TO FLAGGED VALUE
C 
      DO I=1,800
       RDWS(I)=-999.9
       RDWD(I)=-999.9
       RDVWS(I)=-999.9
      ENDDO
C  
C     ICALLSWEEPIN IS ONLY ZERO THE FIRST TIME SWEEPIN IS CALLED
C     IF ITAPEOPEN EQUALS ZERO, THEN IFILECHECK IS NOT USED IN CODE
C 
      IF(ICALLSWEEPIN.EQ.0)THEN
       IFILECHECK=0
       RADTEST=-1.
       IFRANCE=0
       IFLIGHTCHECK=0
      ELSE
       IFILECHECK=1
       IFLIGHTCHECK=1
      ENDIF
C 
      deg2rad = acos(-1.0) / 180.0
      rad2deg = 1.0 / deg2rad
C 
C     HARDWIRE HALF VERTICAL BEAM WIDTH FOR TAIL AND LF RADARS
C     NOTE: LF BEAM WIDTH IS NOT PRESENTLY USED
C 
      half_beam_ta = 0.8 ! degrees, vertical
      half_beam_lf = 2.05 ! degrees, vertical
      beam_wid = 2.0 * half_beam_ta
C 
      WFLAG=-1.0E+10
C 
C     ISWEEPSET INITIALIZED TO TWO AND RAY COUNTER INITIALIZED TO ZERO
C 
      ISWEEPSET=2
      SWEEPOLD=0.
      NUM_RAYS=0
C 
C     INITIALIZE RADIAL VELOCITY AND DBZ FOR EACH GATE OF EACH RAY OF 
C     PRESENT SWEEP TO FLAGGED VALUES
C 
      DO I=1,512
       DO J=1,800
        SWEEP(I,J)=-888.8
        SWEEPZ(I,J)=-32.0
       ENDDO
      ENDDO
C 
C     THE BELOW CODE IS NOT EXECUTED FIRST TIME SWEEPIN IS CALLED
C     SINCE ICALLSWEEPIN IS ZERO. IN SUBSEQUENT CALLS ICALLSWEEPIN
C     IS ONE. BUT DOES THIS CODE EVER SERVE A PURPOSE?
CCC1 
      IF(ICALLSWEEPIN.EQ.1)THEN
CCC1 
C
C      THESE VALUES ARE BASED UPON UNDEFINED VALUES?
C 
       NUM_RAYS=1
       RLAT=RLATONE
       RLON=RLONONE
       EAZM(1)=AZMONE
       EEV(1)=EVONE
       TRACKSTORE(1)=TRACK
       HEADSTORE(1)=HEADING
       RRLAT(1)=RLAT
       RRLON(1)=RLON
       RRA(1)=RAONE
       RDVWS(1)=RDVWSONE
       TMSWEEP(1)=TIMEONE
       RA=RAONE
       AZM=AZMONE
       EV=EVONE
       V0SAVE(1)=V0ONE
C
C      IBST(1) IS GENERALLY AROUND 4. IN THIS CASE THE FIRST 4 GATE
C      BINS OF THE FIRST RAY ARE ASSIGNED FLAGGED VALUES
C 
       IF(IBST(1).GE.1)THEN
        DO I=1,IBST(1)
         SWEEP(I,1)=-888.8
         SWEEPZ(I,1)=-32.
        ENDDO
       ENDIF
C
C      THE VELOCITY, DBZ, AND SPECTRAL WIDTH OF REMAINING GATE BINS OF 
C      FIRST RAY ARE BASED UPON UNDEFINED VALUES?
C 
       DO I=IBST(1)+1,NBINS
        SWEEP(I,1)=BINONE(I)
        SWEEPZ(I,1)=REFONE(I)
        SWIDTH(I,1)=SWONE(I)
       ENDDO
C
C      IF THE NUMBER OF GATE BINS IS LESS THAN THE MAX NUMBER, ASSIGN
C      FLAGGED VALUES TO THE REMAINING BINS
C 
       IF(NBINS.LT.512)THEN
        DO I=NBINS+1,512
         SWEEP(I,1)=-888.8
         SWEEPZ(I,1)=-32.
        ENDDO
       ENDIF
C 
C      THE BELOW ARE BASED UPON UNDEFINED VALUES?
C 
       OOLAT=RLAT
       OOLON=RLON
       TIMES=TIME
C 
       IF(IUSEWIND.NE.1)CENTIME=TIMES
C 
       ISCANDIM=512
       IBINS=512
       AZ_EL(1,1)=AZELONE
       AZ_EL(2,1)=AZELTWO
       PELEV(1)=PELEVONE
       PAZM(1)=PAZMONE
C
C      IUSEWIND IS BY DEFAULT ZERO SO BELOW CODE IS NOT USED AT PRESENT
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC1 
       IF(IUSEWIND.EQ.1)THEN
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC1 
        CALL VRLOCATER(TIMES,OLAT,OLON,
     +  RLAT,RLON,RA,EV,AZM,RDTAIIN,XR,YR,ZR,
     +  ISCANDIM,SMOTIONU,SMOTIONV,CENTIME)
        RADIANEV=EV*3.14159/180.
        RADIANAZM=AZM*3.14159/180.
        DIRCOSX=COS(RADIANEV)*COS(RADIANAZM)
        DIRCOSY=COS(RADIANEV)*SIN(RADIANAZM)
        DIRCOSZ=SIN(RADIANEV)
        XMIN=-XZ
        YMIN=-YZ
        XMAX=-XZ+IMX*SX
        YMAX=-YZ+JMX*SY
        ZZMAX=ZZ+(KMX-1)*SZ
C 
C       BEGIN LOOP OVER BIN NUMBER
C 
        DO IR=1,512
         IF(BIN(IR).GT.-800.)THEN
          IINT=INT((XR(IR)+XZ+.5*SX)/SX)
          JINT=INT((YR(IR)+YZ+.5*SY)/SY)
          KINT=1+INT((ZR(IR)-ZZ)/SZ)
          VRRAD(IR,1)=0.
          VRSUM=0.
C 
          DO I=IINT,IINT+1
           DO J=JINT,JINT+1
            DO K=KINT,KINT+1
C 
             IF(I.GE.1.AND.I.LE.IMX)THEN
              IF(J.GE.1.AND.J.LE.JMX)THEN
               IF(K.GE.1.AND.K.LE.KMX)THEN
                IF(U(I,J,K).GT.WFLAG)THEN
                 XG=(I-1)*SX-XZ+.5*SX
                 YG=(J-1)*SY-YZ+.5*SY
                 ZG=(K-1)*SZ+ZZ
                 XI=XR(IR)-XG
                 YI=YR(IR)-YG
                 ZI=ZR(IR)-ZG
                 RADR=SQRT(XR(IR)*XR(IR)+YR(IR)*YR(IR))
                 RADG=SQRT(XG*XG+YG*YG)
                 VRAD=(U(I,J,K)*XG+V(I,J,K)*YG)/RADG
                 VTAN=(V(I,J,K)*XG-U(I,J,K)*YG)/RADG
                 URAD=(VRAD*XR(IR)-VTAN*YR(IR))/RADR
                 VRAD=(VRAD*YR(IR)+VTAN*XR(IR))/RADR
                 DISTPOINT=SQRT(XI*XI+YI*YI+ZI*ZI)
                 IF(DISTPOINT.GT.0.)THEN
                  RINT=1./DISTPOINT
                 ELSE
                  RINT=1000000.
                 ENDIF
                 VRRAD(IR,1)=VRRAD(IR,1)+
     1              RINT*(URAD*DIRCOSX+VRAD*DIRCOSY+
     1              W(I,J,K)*DIRCOSZ)
                 VRSUM=VRSUM+RINT
                ENDIF
               ENDIF
              ENDIF
             ENDIF
C 
            ENDDO
           ENDDO
          ENDDO
C 
          IF(VRSUM.GT.0.)THEN
           VRRAD(IR,1)=VRRAD(IR,1)/VRSUM
          ELSE
           VRRAD(IR,1)=-888.8
          ENDIF
C 
         ELSE
C 
          VRRAD(IR,1)=-888.8
         ENDIF
        ENDDO
C 
C       END LOOP OVER BIN NUMBER
C 
        ISCANONE=1
        RDTAONE=.0001
        BINNONE=0.
        REFFONE=0.
        CALL VRLOCATER(TIMES,OLATOUT,OLONOUT,
     +  RLAT,RLON,RA,EV,AZM,RDTAONE,XR,YR,ZR,
     +  ISCANONE,SMOTIONU,SMOTIONV,CENTIME)
        HEADSTORM=ATAN2(XR(1),YR(1))
        HEADSTORM=HEADSTORM*180./3.14159
        IF(NAIRCRAFT.NE.42)GO TO 76582  
        IF(HEADSTORM.LT.0.)HEADSTORM=HEADSTORM+360.
        TANDIR=HEADSTORM+90.
        IF(HEADSTORM.GE.360.)HEADSTORM=HEADSTORM-360.
        IF(TANDIR.GE.360.)TANDIR=TANDIR-360.
        IFLAGGING=0
        TANDIF=ABS(TANDIR-RADWD)
        IF(TANDIF.GT.180.)TANDIF=360.-TANDIF
        WSTANTEST=RADWS*TANDIFF
        IF(WSTANTEST.GT.1200.)THEN
         IFLAGGING=1
        ENDIF
C TURNED OFF THIS FLAG--OCTOBER 6, 2010
        IFLAGGING=0
C       INE PROBLEMS... (WHAT IF SYSTEM HAS NO WELL-DEFINED CENTER)
        IF(IFLAGGING.EQ.1)THEN
         WRITE(6,*)'FLAGGING RAY'
         write(6,*)'headstorm,tandir = ',headstorm,tandir
         write(6,*)'ucom,vcom = ',ucom,vcom
         write(6,*)'radws,radwd = ',
     +             radws,radwd
         WRITE(6,*)'TANDIF = ',TANDIF
         DO I=1,512
          BIN(I)=-888.8
         ENDDO
        ENDIF
76582   CALL VRLOCATER(TIMES,OOLAT,OOLON,
     +  RLAT,RLON,RA,EV,AZM,RDTAIIN,XR,YR,ZR,
     +  ISCANDIM,SMOTIONU,SMOTIONV,CENTIME)
        DO I=1,512
         XRSWEEP(I,1)=XR(I)
         YRSWEEP(I,1)=YR(I)
         ZRSWEEP(I,1)=ZR(I)
        ENDDO
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC1 
       ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC1
C      END IF IUSEWIND EQUALS ONE
CCC1 
      ENDIF
CCC1
C     END IF ICALLSWEEPIN EQUALS ONE
C 
C     THE BELOW CODE IS ONLY EXECUTED THE FIRST TIME SWEEPIN IS CALLED.
C     READ IN ALL NECESSARY PARAMETERS....
CCC0 
      IF(ICALLSWEEPIN.EQ.0)THEN
CCC0 
C
C      ISWEEPSET INITIALIZED TO ZERO IF THIS IS THE FIRST SWEEP
C 
       ISWEEPSET=0
C 
       IF(IUSEWIND.NE.1)THEN
C
C       BE 'CONSERVATIVE' ON FIRST PASS
C 
        ICONSERVE=1
C 
       ENDIF
C 
       IFILE='jobfile_radar'
C 
       OPEN(98,FILE=IFILE,IOSTAT=IERR,ERR=998,STATUS='OLD')
C
C      READ PARAMETERS FROM JOBFILE_RADAR: FLIGHT NAME, STORM NAME,
C      HORIZONTAL & VERTICAL GRID SPACING, HORIZONTAL & VERTICAL
C      GRID ORIGIN OFFSET, HORIZONTAL & VERTICAL GRIDPOINTS
C 
       READ(98,'(A8)')IFLT
       READ(98,'(A12)')INM
       DO JIJ=1,4
        READ(98,'(A1)')DUMMYREAD
       ENDDO
       READ(98,*)SXSX,SYSY,SZSZ
       READ(98,*)XZXZ,YZYZ,ZZZZ
       READ(98,*)IMXIMX,JMXJMX,KMXKMX
C
C      SPECIFY LINE PRINTER LU# AND READ IN TAPE LU# 
C 
       LP=6
       READ(98,*)LUNRT
C 
       WRITE(LP,'(1X,"NCEP program to write doppler on disc: ",A)')
     +      IFILE
       WRITE(LP,'(2X,"Date:",1X,A8,2X,"Name: ",A12,/,
     +        2X,"Line-Printer:",1X,I2,2X,"Tape-LU#:",I2)')
     +        IFLT,INM,LP,LUNRT
C 
C      DO NOT READ IN A RAMFILE
C 
       RAMFL='N'
C 
       IF (RAMFL .EQ. 'Y') THEN
          CALL OPENRAMFILE(NAMERAM,LP,STIMERAM,ETIMERAM,DATARATE,IERR)
          IF (IERR .NE. 0) GO TO 1050
          WRITE(LP,'(2X,"RAMFL= ",A1,1X,A80)') RAMFL,NAMERAM
       ENDIF 
C 
C      SPECIFY FIRST GUESS WIND DIRECTION AND SPEED, AND READ IN 
C      UNFOLDING FLAG
C 
       WD=0.
       WS=1.
C      
C      ZERO HERE DOES NOT MEAN UNFOLDING IS NOT PERFORMED. THE UNFOLDING IS
C      SIMPLY DONE OUTSIDE OF READTAPE.
C 
       iunfoldflag=0
C 
       WRITE(LP,'(2X,"IUNFOLDFLAG= ",I1," WD= ",F6.1," WS= ",F6.1)')
     +      IUNFOLDFLAG,WD,WS
C
C      READ IN STARTING BIN AND NUMBER OF BINS FOR AVERAGING FROM JOBFILE_RADAR
C 
       READ(98,*,IOSTAT=IERR,ERR=999) IBST(1),INOB(1) 
       WRITE(LP,'(2X,"IBST= ",I4," INOB= ",I4)') IBST(1),INOB(1)
C
C      READ FORE AZIMUTH, ELELVATION AND RANGE DELAY CORRECTIONS FROM JOBFILE_RADAR
C 
       READ (98,*,IOSTAT=IERR,ERR=999) AZMCORS(1),ELCORS(1),
     +                                  RDELCORTA
       WRITE(LP,'(2X,"TA AZMCOR=",F6.2,2X,"ELCOR= ",F6.2,
     +      2X,"RDELCORTA= ",F6.2)') AZMCORS(1),ELCORS(1),
     +                               RDELCORTA
C 
C      READ FORE PITCH, DRIFT, AND ROLL CORRECTIONS FROM JOBFILE_RADAR
C 
       READ (98,*,IOSTAT=IERR,ERR=999) PCORS(1),DCORS(1),RCORS(1)
       WRITE(LP,'(2X,"TA PCOR= ",F5.1,2X,"DCOR= ",F5.1,
     +      2X,"RCOR= ",F5.1)') PCORS(1),DCORS(1),RCORS(1)
C
C      READ AFT AZIMUTH, ELELVATION AND RANGE DELAY CORRECTIONS FROM JOBFILE_RADAR
C      NOTE: DOES NOT APPEAR THAT RDELCORTAS IS EVER USED
C 
       READ (98,*,IOSTAT=IERR,ERR=999) AZMCORS(2),ELCORS(2),
     +                                  RDELCORTA
       RDELCORTAS(1)=RDELCORTA
       RDELCORTAS(2)=RDELCORTA
       WRITE(LP,'(2X,"TF AZMCOR=",F6.2,2X,"ELCOR= ",F6.2,
     +      2X,"RDELCORTA= ",F6.2)') AZMCORS(2),ELCORS(2),
     +                               RDELCORTA
C
C      READ AFT PITCH, DRIFT, AND ROLL CORRECTIONS FROM JOBFILE_RADAR
C 
       READ (98,*,IOSTAT=IERR,ERR=999) PCORS(2),DCORS(2),RCORS(2)
       WRITE(LP,'(2X,"TF PCOR= ",F5.1,2X,"DCOR= ",F5.1,
     +      2X,"RCOR= ",F5.1)') PCORS(2),DCORS(2),RCORS(2)
C 
C      READ THRESHOLD VALUES FROM JOBFILE_RADAR
C 
       READ (98,*,IOSTAT=IERR,ERR=999) THRESH,DBZRS,DBZCOR,DBZSLOPE
       WRITE(LP,'(2X,"NOISE VALUE= ",F5.1,2X,"DBZRS= ",F5.1,
     +          "DBZSLOPE= ",F5.1,2X,"DBZCOR= ",F5.1)')
     +       THRESH,DBZRS,DBZSLOPE,DBZCOR
C 
C      READ SPECTRAL WIDTH THRESHOLD VALUE FROM JOBFILE_RADAR
C 
       READ (98,*,IOSTAT=IERR,ERR=999) swthresh
       IF (SWTHRESH.LE.0.0 .OR. SWTHRESH.GT.13.0) SWTHRESH=99.0
       WRITE(LP,'(2X,"SPECTRAL WIDTH THRESHOLD= ",F5.1)') swthresh
C 
C      READ FLAG FOR ADDING THE TERMINAL VELOCITY CORRECTION VALUE,
C      THE HEIGHT AND DEPTH OF THE BRIGHT BAND, P. WILLIS OR JOSS VT
C      NOTE: BRIGHT BAND HEIGHT & DEPTH ARE HARDWIRED HERE
C 
       IVT='N'
       HTBB=5.5
       DBB=2.
       IRSW=0
       IF(IVT.EQ.'n')IVT='N'
       IF(IVT.EQ.'y')IVT='Y'
       WRITE(LP,'(2X,''VT= '',A1," HTBB= ",F6.2," DBB= ",F6.2, 
     +           " IRSW= ",I1)') 
     +      IVT,HTBB,DBB,IRSW
       IF (IVT .EQ. 'N') HTBB= -99.0
C 
C      DO NOT ADD INTERVENING ATTENUATION
C 
       IATTEN='N'
       IF(IATTEN.EQ.'y')IATTEN='Y'
       IF(IATTEN.EQ.'n')IATTEN='N'
C 
       IF (IATTEN .EQ. 'Y') THEN 
C 
C       COMPUTE ATTENUATION TABLE IF FLAG IS ON
C     
        CALL MAKEATTENTABLE1(2)
        WRITE(LP,'(1X,"Intervening attenuation: A=",E10.2, 
     +        "*Z**",F4.2)') AT1,AT2
        IATTENFLAG = 1
       ELSE
        IATTENFLAG = 0
       ENDIF 
C   
C      READ START AND END TIMES FROM JOBFILE_RADAR
C 
       READ(98,'(3I2,1X,3I2)',IOSTAT=IERR,ERR=999)
     +      IHS,IMS,ISS,IHE,IME,ISE
       WRITE(LP,'(2X,"Start Time:",3I2.2,2X,"End Time:",3I2.2)')
     +       IHS,IMS,ISS,IHE,IME,ISE
C     
C      DO NOT READ A SECOND TAPE
       TAPE='N'
       IF(TAPE.EQ.'y')TAPE='Y'
       IF(TAPE.EQ.'n')TAPE='N'
C 
C      READ FORTRAN BINARY FILE NAME FROM JOBFILE_RADAR
C 
       READ(98,*)DUMMY
       READ(98,*)DUMMY1,DUMMY2
       READ(98,*)DUMMY1,DUMMY2
       READ(98,'(A80)')CDUMMY
       READ(98,*)DUMMY1,DUMMY2
       RADARFILE='DUMMY'
       IF(LUNRT.GT.6)THEN
        ITAPEOPEN=1
        READ(98,'(A80)')RADARFILE
       ELSE
        ITAPEOPEN=0
        WRITE(6,*)'Enter name of radar file'
        READ(98,'(A80)')RADARFILE
       ENDIF
C
C      READ ANTENNA FLAG 
C 
       READ(98,*)IFRANCE
C 
C      DEFAULT IS TO CALL OPENRADARFILE (OPEN FILE CONTAINING RADAR DATA)    
C 
       IF(ITAPEOPEN.EQ.1)THEN
        WRITE(6,*)'CALLING TAPEOPEN'
        CALL TAPEOPEN(LUNRT,0,LUNR)
        WRITE(6,*)'RETURNED FROM TAPEOPEN'
        WRITE(6,*)'LUNRT,LUNR = ',LUNRT,LUNR
        CALL TAPECONTROL(LUNR,2,1) !back up 1 file
       ELSE
        LUNR=80
        CALL OPENRADARFILE(RADARFILE,LUNR,1,IERROPEN)
       ENDIF
       CLOSE(98)
       NAMEO='DUMMY'
CCC0 
      ENDIF
CCC0 
C     END IF ICALLSWEEPIN EQUALS ZERO
C 
      WRITE(LP,'(2X,"NCEP Output File Name:",A)') NAMEO
      WRITE(LP,*)trakazm,trakelev,driftnew,
     +         rot,track,htbb,dbb,thresh,swthresh,dbzrs,ibst(1),ibst(2),
     +         inob(1),inob(2),ileg,xniq,irsw,maxnbins,v0,
     +         pcor,dcor,rcor,azmcor,elcor,dbzcor,dbzslope,
     +         iunfoldflag,iattenflag,
     +         badstabflag,surfelimflag,echoflag,atmflag
C 
C     EXPRESS START & END TIMES IN SECONDS (STIME,ETIME)
C 
      STIME=FLOAT(IHS)*3600.0 + FLOAT(IMS)*60.0 + FLOAT(ISS)
      ETIME=FLOAT(IHE)*3600.0 + FLOAT(IME)*60.0 + FLOAT(ISE)
C
C     SEARCH FOR THE START TIME
C 
971   write(6,*)'itapeopen,icallsweepin = ',itapeopen,icallsweepin
C 
C     THE BELOW CODE IS ONLY EXECUTED THE FIRST TIME SWEEPIN IS CALLED
CCC0 
      IF(ICALLSWEEPIN.EQ.0)THEN
CCC0 
       write(6,*)'calling tapesearch'
       ROLDTIME=200000.
97100  WRITE(6,*)'CALLING READTAPE'
       kwords=0
       nwords=-1
       TIME=STIME  ! WHY IS TIME DEFINED HERE?  ISN'T IT OVERWRITTEN IN READTAPE?
C
C      WHAT EXACTLY IS ACCOMPLISHED BY THIS FIRST CALL TO READTAPE?
C 
       CALL READTAPE(TIME,RLAT,RLON,RA,AZM,EV,BIN,REF,RCAZM,
     +  ITAPEOPEN,RADARFILE,NUMREC,PCORS,DCORS,RCORS,AZMCORS,
     +  RDELCORTAS,ELCORS)
C
C      IFLIGHTCHECK WILL BE ZERO THE FIRST TIME SWEEPIN IS CALLED
CC 
       IF(IFLIGHTCHECK.EQ.0)THEN
CC 
C       PROMPTLY SET TO ONE
C 
        IFLIGHTCHECK=1
C 
        IF(NAIRCRAFT.EQ.42)THEN
         INAIR=1
        ELSEIF(NAIRCRAFT.EQ.43)THEN
         INAIR=2
        ELSE
         WRITE(6,*)'NAIRCRAFT = ',NAIRCRAFT
         WRITE(6,*)'NAIRCRAFT DOES NOT EQUAL 42 OR 43'
         INAIR=3
        ENDIF
C 
C       WRITE FLIGHT ID
C 
        write(6,6104)iyear,month,iday,caircraft(inair)
        write(IFLTCHK,6104)iyear,month,iday,caircraft(inair)
6104    FORMAT(3I2.2,A)
        read(IFLT,'(A7)')IFLTCHK2
        WRITE(6,'(A7)')IFLTCHK
        write(6,'(A7)')IFLTCHK2
        CALL FINDIDAYS(IDAYSCHK,NAIRCHK,IFLTCHK)
        CALL FINDIDAYS(IDAYSCHK2,NAIRCHK2,IFLTCHK2)
        WRITE(6,*)'IDAYS FROM JOBFILE = ',IFLTCHK2
        WRITE(6,*)'IDAYS FROM TAPE = ',IFLTCHK
C
C       ADD A DAY IN SECONDS TO TIME IF IDAYSCHK > IDAYSCHK2
C       NOTE: IDAYSCHK2 IS FROM THE JOBFILE
C 
        IDAYSDIFF=IDAYSCHK-IDAYSCHK2
        IF(IDAYSDIFF.EQ.1)THEN
         IADD86400=1
        ELSE
         IADD86400=0
        ENDIF
        IF(IFLTCHK2.NE.IFLTCHK)THEN
         write(6,*)'flight id on jobfile inconsistent with tape'
        ENDIF
CC 
       ENDIF
CC
C      END IF IFLIGHTCHECK EQUALS ZERO
C
C      ADD A DAY IN SECONDS FOR CONSISTENCY WITH RADAR TAPE
C 
       IF(IADD86400.EQ.1)TIME=TIME+86400.
C 
       NTASWEEPER=NTASWEEP
       WRITE(6,*)'TIME,RLAT,RLON,RA = ',TIME,RLAT,RLON,RA
       WRITE(6,*)'TIME,OLDTIME = ',TIME,ROLDTIME
C 
C      WHY WOULD TIME EQUAL ROLDTIME=200000?
C 
       IF(TIME.EQ.ROLDTIME)GO TO 97100  ! DIRECT BACK TO READTAPE
C 
C      BELOW DOES NOT MATTER SINCE ITAPEOPEN EQUALS ZERO
C
       TIMEMSTIME=TIME-STIME
       WRITE(6,*)'TIME,STIME,TIMEMSTIME = ',TIME,STIME,TIMEMSTIME
       IF(TIMEMSTIME.LT.-72000..AND.ITAPEOPEN.EQ.1)THEN
        WRITE(6,*)'BACKSPACING'
        CALL TAPECONTROL(LUNR,2,1)
        CALL TAPECONTROL(LUNR,2,1)
        ROLDTIME=TIME
        GO TO 97100  
       ENDIF
C
C      WHY?
C 
97101  IF(IADD86400.EQ.1)THEN
        STIMESEARCH=STIME-86400.
       ELSE
        STIMESEARCH=STIME
       ENDIF
C
C      POSITION DISC AT SPECIFIED TIME, STIMESEARCH
C      NOTE: NTIMER IS SET TO ZERO THE FIRST TIME SWEEPIN IS CALLED
C 
       IF(LUNR.NE.80)THEN
        CALL TAPESEARCH(LUNR,2,2,STIMESEARCH,IERR)
       ELSE
94826   CALL DISCSEARCH(LUNR,2,2,STIMESEARCH,IERR)
        NTIMER=0
        write(6,*)'called discsearch'
        timetest=itimex(2)
        write(6,*)'timetest,etime = ',timetest,etime
        if(timetest.gt.etime)then
         itimex(2)=1
         time=itimex(2)
         write(6,*)'new time,itimex = ',time,itimex(2)
         ierr=20
         go to 94826  ! DIRECT BACK TO DISCSEARCH
        endif
       ENDIF
C 
       WRITE(6,*)'IERR = ',IERR
C
C      IF PROBLEM FINDING START TIME...
C 
       IF (IERR.LT.0) GO TO 970
C 
C      ...OTHERWISE READ FROM BINARY FILE (WHAT IS ACCOMPLISHED HERE?)
C 
       CALL READTAPE(TIME,RLAT,RLON,RA,AZM,EV,BIN,REF,RCAZM,
     +        ITAPEOPEN,RADARFILE,NUMREC,PCORS,DCORS,RCORS,AZMCORS,
     +        RDELCORTAS,ELCORS)
C 
       NTASWEEPER=NTASWEEP
C 
C      WHY ADD A DAY IN SECONDS AFTER CALL TO READTAPE?
C 
       IF(IADD86400.EQ.1)TIME=TIME+86400
C 
C      BELOW DOES NOT MATTER SINCE ITAPEOPEN EQUALS ZERO
C 
       IF((TIME-STIME).LT.-60000..AND.ITAPEOPEN.EQ.1)THEN
        CALL TAPECONTROL(LUNR,2,1) !back up 1 file
        CALL TAPECONTROL(LUNR,2,1) !back up 1 file
        GO TO 97101
       ELSEIF((TIME-STIME).LT.1.)THEN
        WRITE(6,*)'SETTING IFILECHECK TO 1'
        IFILECHECK=1
       ELSE
        WRITE(6,*)'TIME IS ',TIME
       ENDIF
C
C      END IF ICALLSWEEPIN EQUALS ZERO 
CCC0 
      ENDIF
CCC0 
      OLDTIME=0
      ITIMECHECK=0
C 
C     RETURN HERE BECAUSE...
C 
C     READ FROM BINARY FILE (WHAT IS CURRENT TIME, AND HOW IS IT USED?)
C 
7040  CALL READTAPE(TIME,RLAT,RLON,RA,AZM,EV,BIN,REF,RCAZM,
     +       ITAPEOPEN,RADARFILE,NUMREC,PCORS,DCORS,RCORS,AZMCORS,
     +       RDELCORTAS,ELCORS)
C 
C     IF COMPUTED TRACK DIFFERS FROM INE TRACK BY MORE THAN 2 DEG, FLAG RAY DATA
C 
      TRACKLATLON=180./3.14159*ATAN2(GSE,GSN)
      IF(TRACKLATLON.LT.0.)TRACKLATLON=TRACKLATLON+360.
      TRACKDIFF=TRACK-TRACKLATLON
      IF(TRACKDIFF.GT.180.)TRACKDIFF=TRACKDIFF-360.
      IF(TRACKDIFF.LT.-180.)TRACKDIFF=TRACKDIFF+360.
C
C     IF ?? GREATER THAN TWO, THEN ASSIGN BIN AND REF ARRAYS 
C     FLAGGED VALUES FOR ALL GATES. NOTE: BIN1 AND REF1 ARE
C     NOT USED IN THE CODE.
C 
      IF(TRACKDIFF.GT.2.)THEN
       WRITE(6,*)'TRACK,TRACKLATLON,PITCH,ROLL,HEADING = ',
     +  TRACK,TRACKLATLON,PITCH,ROLL,HEADING
       DO I=1,512
        BIN(I)=-888.8
        BIN1(I)=-888.8
        REF(I)=-32.
        REF1(I)=-32.
       ENDDO
      ENDIF
C 
C     WHY ADD A DAY IN SECONDS AFTER CALL TO READTAPE?
C 
      IF(IADD86400.EQ.1)TIME=TIME+86400
C 
C     IF MAGNITUDE OF ELEVATION ANGLE IS VERY SMALL, THEN ASSIGN 
C     BIN AND REF ARRAYS FLAGGED VALUES FOR ALL GATES (FRENCH ANTENNA
C     SWITCHING...DATA ARE NOT GOOD)
C 
      IF(ABS(ELEV).LT..001)THEN
        DO I=1,512
         BIN(I)=-888.88
         REF(I)=-32.
        ENDDO
      ENDIF
C
C     IF MAGNITUDE OF ROLL IS VERY LARGE, THEN ASSIGN 
C     BIN AND REF ARRAYS FLAGGED VALUES FOR ALL GATES
C 
      IF(ABS(ROLL).GT.10.)THEN
        DO I=1,512
         BIN(I)=-888.88
        ENDDO
      ENDIF
C
C     IF GATE CONTAINS DBZ>60, THEN ASSIGN BIN AND REF FLAGGED VALUES 
C 
      DO I=1,512
        IF(REF(I).GT.60.)THEN
         REF(I)=-32.
         BIN(I)=-888.88
        ENDIF
      ENDDO
C 
      NTASWEEPER=NTASWEEP
C 
C     IF RANGE OF THE ITH BIN IS LESS THAN RANGE OF THE (I-1)TH BIN,
C     ASSIGN A VALUE OF 1000 TO RANGE FOR ALL BINS BEYOND THE (I-1)TH.
C     THEN EXIT OUT OF DO LOOP.
C 
      DO I=2,512
       IF(RADIITA(I).LT.RADIITA(I-1))THEN
        DO L=I,512
         RADIITA(L)=1000.
        ENDDO
        GO TO 5699  ! EXIT OUT OF DO LOOP
       ENDIF
      ENDDO
5699  CONTINUE
C 
C     HAS THE END TIME BEEN EXCEEDED?
C 
      IF(TIME.GT.ETIME)THEN
C 
       write(6,*)'time,etime,ntimer = ',time,etime,ntimer
C
C      IF SO, AND THE DIFFERENCE IS MORE THAN 1000 S, AND THE NUMBER
C      OF TIMES THE PROGRAM HAS RETURNED TO READTAPE IS LESS THAN 100,
C      RETURN TO READTAPE. OTHERWISE, RESET NTIMER TO ZERO AND MOVE ON.
C 
       IF(TIME-ETIME.GT.1000..AND.NTIMER.LT.100)THEN
        TIME=1
        ITIMEX(2)=1
        NTIMER=NTIMER+1
        GO TO 7040  ! DIRECT BACK TO READTAPE
       ELSE
        NTIMER=0
       ENDIF
C 
      ENDIF
C 
C     TO GET TO THIS POINT, EITHER 1) BEFORE END TIME OR 2) AFTER END TIME, 
C     AND THE DIFFERENCE BETWEEN TIME AND END TIME IS LESS THAN 1000 AND
C     NTIME HAS REACHED 100
C 
C     BELOW DOES NOT MATTER SINCE ITAPEOPEN EQUALS ZERO  
C 
      IF(TIME.GT.STIME.AND.IFILECHECK.EQ.0.AND.ITAPEOPEN.EQ.1)THEN
       WRITE(6,*)'BACKING UP TWO FILES LOOKING FOR STARTIME'
       CALL TAPECONTROL(LUNR,2,1) !back up 1 file
       CALL TAPECONTROL(LUNR,2,1) !back up 1 file
       IFILECHECK=1
       GO TO 971
      ELSE
       IFILECHECK=1
      ENDIF
C 
      OOLAT=RLAT
      OOLON=RLON
      TIMES=TIME
      IF(IUSEWIND.NE.1)CENTIME=TIME
      ISCANDIM=512
      IBINS=512
C 
C     IF THE RANGE DIFFERENCE BETWEEN 2ND AND 3RD BINS EXCEEDS
C     145 M, THEN SET I150 TO ONE. OTHERWISE SET IT TO ZERO
C 
      IF((RADIITA(3)-RADIITA(2)).GT..145)THEN
       I150=1
      ELSE
       I150=0
      ENDIF
C
C     WHAT IS PURPOSE HERE?
C 
      IF(RADTEST.GT.0..AND.RADIITA(50).NE.RADTEST)THEN
       INEWRAD=1
       RADTEST=RADIITA(50)
      ELSE
       INEWRAD=0
      ENDIF  
C
C      IF TIME IS LESS THAN START TIME, THEN RETURN TO READTAPE
C    
      IF(TIME.LT.STIME)THEN
       ITIME=INT(TIME)
       IF(ITIME.GT.ITIMECHECK)THEN
        WRITE(6,*)'TIME,STIME = ',TIME,STIME
        ITIMECHECK=ITIME
       ENDIF
       GO TO 7040  ! DIRECT BACK TO READTAPE
      ENDIF
C 
C     WILL ONLY GET HERE IF TIME IS AFTER START TIME
C 
C     FOR IUSEWIND EQUALS ZERO, THIS IS THE FIRST TIME VRLOCATER
C     IS CALLED. LOCATES DATUM WITHIN CARTESIAN ANALYSIS GRID.
C     NOTE: RDTAIIN IS NOT INITIALIZED, IS IT?  PURSPOSE?
C 
29654 CALL VRLOCATER(TIMES,OLAT,OLON,
     + RLAT,RLON,RA,EV,AZM,RDTAIIN,XR,YR,ZR,
     + ISCANDIM,SMOTIONU,SMOTIONV,CENTIME)
C  
C     IUSEWIND IS BY DEFAULT ZERO SO BELOW CODE IS NOT USED AT PRESENT  
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC1 
      IF(NUM_RAYS.GT.0.AND.IUSEWIND.EQ.1)THEN
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC1 
        RADIANEV=EV*3.14159/180.
        RADIANAZM=AZM*3.14159/180.
        DIRCOSX=COS(RADIANEV)*COS(RADIANAZM)
        DIRCOSY=COS(RADIANEV)*SIN(RADIANAZM)
        DIRCOSZ=SIN(RADIANEV)
        XMIN=-XZ
        YMIN=-YZ
        XMAX=-XZ+IMX*SX
        YMAX=-YZ+JMX*SY
        ZZMAX=ZZ+(KMX-1)*SZ
C 
C       BEGIN LOOP OVER GATE BINS
C 
        DO IR=1,512
         IF(BIN(IR).GT.-800.)THEN
          IINT=INT((XR(IR)+XZ+.5*SX)/SX)
          JINT=INT((YR(IR)+YZ+.5*SY)/SY)
          KINT=1+INT((ZR(IR)-ZZ)/SZ)
          VRRAD(IR,NUM_RAYS)=0.
          VRSUM=0.
C 
          DO I=IINT,IINT+1
           DO J=JINT,JINT+1
            DO K=KINT,KINT+1
C 
             IF(I.GE.1.AND.I.LE.IMX)THEN
              IF(J.GE.1.AND.J.LE.JMX)THEN
               IF(K.GE.1.AND.K.LE.KMX)THEN
                IF(U(I,J,K).GT.WFLAG)THEN
C 
                 XG=(I-1)*SX-XZ+.5*SX
                 YG=(J-1)*SY-YZ+.5*SY
                 ZG=(K-1)*SZ+ZZ
                 XI=XR(IR)-XG
                 YI=YR(IR)-YG
                 ZI=ZR(IR)-ZG
                 RADR=SQRT(XR(IR)*XR(IR)+YR(IR)*YR(IR))
                 RADG=SQRT(XG*XG+YG*YG)
                 VRAD=(U(I,J,K)*XG+V(I,J,K)*YG)/RADG
                 VTAN=(V(I,J,K)*XG-U(I,J,K)*YG)/RADG
                 URAD=(VRAD*XR(IR)-VTAN*YR(IR))/RADR
                 VRAD=(VRAD*YR(IR)+VTAN*XR(IR))/RADR
                 DISTPOINT=SQRT(XI*XI+YI*YI+ZI*ZI)
                 IF(DISTPOINT.GT.0.)THEN
                  RINT=1./DISTPOINT
                 ELSE
                  RINT=1000000.
                 ENDIF
                 VRRAD(IR,NUM_RAYS)=VRRAD(IR,NUM_RAYS)+
     1              RINT*(URAD*DIRCOSX+VRAD*DIRCOSY+
     1              W(I,J,K)*DIRCOSZ)
                 VRSUM=VRSUM+RINT
                ENDIF
               ENDIF
              ENDIF
             ENDIF
C 
            ENDDO
           ENDDO
          ENDDO
C 
          IF(VRSUM.GT.0.)THEN
           VRRAD(IR,NUM_RAYS)=VRRAD(IR,NUM_RAYS)/VRSUM
          ELSE
           VRRAD(IR,NUM_RAYS)=-888.8
          ENDIF
C 
         ELSE
C 
          VRRAD(IR,NUM_RAYS)=-888.8
         ENDIF
        ENDDO
C
C       END LOOP OVER GATE BINS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC1  
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC1 
C     END IF IUSEWIND EQUALS ONE
C 
      ISCANONE=1
      RDTAONE=.0001
      BINNONE=0.
      REFFONE=0.
C 
C     IN THIS SECOND CALL TO VRLOCATER, THE NUMBER OF GATES IS SET TO
C     ONE AND THE RANGE IS INFINITESIMALLY SMALL. PURSPOSE?
C 
      CALL VRLOCATER(TIMES,OLATOUT,OLONOUT,
     + RLAT,RLON,RA,EV,AZM,RDTAONE,XR,YR,ZR,
     + ISCANONE,SMOTIONU,SMOTIONV,CENTIME)
C  
C     IF AIRCRAFT IS NOT N42, SKIP BELOW CODE. WHY?
C 
      IF(NAIRCRAFT.NE.42)GO TO 76583 
C 
      HEADSTORM=ATAN2(XR(1),YR(1))
      HEADSTORM=HEADSTORM*180./3.14159
      IF(HEADSTORM.LT.0.)HEADSTORM=HEADSTORM+360.
      TANDIR=HEADSTORM+90.
      IF(HEADSTORM.GE.360.)HEADSTORM=HEADSTORM-360.
      IF(TANDIR.GE.360.)TANDIR=TANDIR-360.
      IFLAGGING=0
      TANDIF=ABS(TANDIR-RADWD)
      IF(TANDIF.GT.180.)TANDIF=360.-TANDIF
      WSTANTEST=RADWS*TANDIF
      IF(WSTANTEST.GT.1200.)THEN
       IFLAGGING=1
      ENDIF
C TURNED OFF THIS FLAG--OCTOBER 6, 2010
       IFLAGGING=0
C 
      IF(IFLAGGING.EQ.1)THEN
        WRITE(6,*)'FLAGGING RAY'
        write(6,*)'headstorm,tandir = ',headstorm,tandir
        write(6,*)'ucom,vcom = ',ucom,vcom
        write(6,*)'radws,radwd = ',
     +             radws,radwd
        WRITE(6,*)'TANDIF = ',TANDIF
        DO I=1,512
         BIN(I)=-888.8
        ENDDO
      ENDIF
C 
C     JUMP HERE IF NOT N42...
C     NUM_RAYS WILL BE ZERO FIRST TIME SWEEPIN IS CALLED AND THIS POINT 
C     IN THE CODE IS REACHED FOR THE FIRST TIME
C 
76583 IF(NUM_RAYS.GT.0)THEN
       CALL VRLOCATER(TIMES,OOLAT,OOLON,
     + RLAT,RLON,RA,EV,AZM,RDTAIIN,XR,YR,ZR,
     + ISCANDIM,SMOTIONU,SMOTIONV,CENTIME)
       DO I=1,512
        XRSWEEP(I,NUM_RAYS)=XR(I)
        YRSWEEP(I,NUM_RAYS)=YR(I)
        ZRSWEEP(I,NUM_RAYS)=ZR(I)
       ENDDO
      ENDIF
C 
      SWEEPTEST=1.
C 
C     IF ELEVATION ANGLE IS > ZERO, ASSIGN TO SWEEPTEST THE ELEVATION
C     ANGLE TIMES THE OLD ELEVATION ANGLE. THE PRESENT ELEVATION ANGLE
C     IS THEN STORED IN SWEEPOLD
C 
      IF(ABS(ELEV).GT.0.)THEN
       SWEEPTEST=ELEV*SWEEPOLD
       SWEEPOLD=ELEV
      ENDIF
C 
      IF(IFRANCE.NE.1.AND.ISWEEPCHECK.NE.NTASWEEP)SWEEPTEST=-1.
      IF(IFRANCE.NE.1.AND.ISWEEPCHECK.EQ.NTASWEEP)SWEEPTEST=1.
C 
CCC   ISWEEPSET EQUALS ZERO MEANS START TIME HAS NOT BEEN REACHED
      IF(ISWEEPSET.EQ.0)THEN
CCC 
       ISWEEPCHECK=NTASWEEP
C
C      ISWEEPSET IS ADVANCED TO ONE BEFORE NEXT CALL TO READTAPE
C 
       ISWEEPSET=1
       GO TO 7040  ! DIRECT BACK TO READTAPE
C
CCC   ISWEEPSET EQUALS ONE MEANS START TIME HAS BEEN REACHED BUT 
CCC   STILL WAITING FOR THE BEGINNING OF THE NEXT SWEEP TO START PROCESSING
      ELSEIF(ISWEEPSET.EQ.1.AND.SWEEPTEST.GE.0.)THEN
CCC 
       WRITE(6,*)'ISWEEP 1 NTASWEEP = ',NTASWEEP
       GO TO 7040  ! DIRECT BACK TO READTAPE
CCC 
      ELSEIF(ISWEEPSET.EQ.1.AND.SWEEPTEST.LT.0.)THEN
CCC 
C
C      IT APPEARS THAT THIS IS THE ONLY PLACE RDTAAIN IS INITIALIZED.
C      SO IT IS ONLY DEFINED AFTER ISWEEPSET IS ADVANCED TO ONE?
C 
       write(6,*)'ibst(1) = ',ibst(1)
C
C      RDDIFF NOT USED IN CODE
C 
       RDDIFF=RDTAIIN(IBST(1)+1)-RDTAIIN(1)
C 
C      IBST(1) IS GENERALLY AROUND 4. IN THIS CASE THE FIRST 4 GATE
C      BINS OF THE RANGE VARIABLE, RDRAIIN, ARE SET TO 1000. THE 
C      REST OF THE GATE BINS ARE FILLED WITH RANGE INFO FROM RADIITA.
C      IF NBINS < 512, THE RANGE OF THE LAST BIN IS SET TO 1000.
C 
       IF(IBST(1).GE.1)THEN
        DO I=1,IBST(1)
         RDTAIIN(I)=1000.
        ENDDO
       ENDIF
       DO I=IBST(1)+1,NBINS
        RDTAIIN(I)=RADIITA(I)
       ENDDO
       IF(NBINS.LT.512)THEN
        RDTAIIN(I)=1000.
       ENDIF
C
C      SETTING ISWEEPSET TO 2 MEANS WE HAVE REACHED THE START TIME
C      (UPON EXITING IF/THEN, RAY NUMBER IS ADVANCED)
C 
       ISWEEPSET=2
       ISWEEPCHECK=NTASWEEP
C
CCC   THE FOLLOWING BEING TRUE MEANS WE HAVE STARTED THE PROCESSING AND 
CCC   HAVE JUST REACHED A NEW SWEEP
      ELSEIF((ISWEEPSET.EQ.2.AND.SWEEPTEST.LT.0.).
     1       OR.NUM_RAYS.EQ.800)THEN
CCC 
       IF(NUM_RAYS.EQ.800)THEN
        WRITE(6,*)'SPECIAL END TO SWEEP'
       ENDIF
C 
       ISWEEPCHECK=NTASWEEP
C 
       CALL CTME1(TIME,IIHH,IIMM,IISS)
       WRITE(6,*)'SWEEP END TIME IS '
       WRITE(6,'(3I2)')IIHH,IIMM,IISS
C 
       TIMEONE=TIME
       RLATONE=RLAT
       RLONONE=RLON
       RAONE=RA
       RDVWSONE=RADVWS
       AZMONE=AZM
       EVONE=EV
       V0ONE=V0
       AZELONE=TRAKAZM
       AZELTWO=TRAKELEV
       PELEVONE=ELEV
       PAZMONE=RADAZM
C 
C      BINONE, REFONE, AND SWONE SERVE NO PURPOSE?
C 
       IF(IBST(1).GE.1)THEN
        DO I=1,IBST(1)
         BINONE(I)=-888.8
         REFONE(I)=-32.
        ENDDO
       ENDIF
       DO I=IBST(1)+1,512
        BINONE(I)=BIN(I)
        REFONE(I)=REF(I)
        SWONE(I)=WIDTHBUFFER(I)
       ENDDO
C
C      FIND THE SURFACE IF THE RAW AZIMUTH IS BETWEEN 91 AND 269 DEG
C      THIS CORRESPONDS TO A BEAM POINTING DOWNWARD.
CC 
       IF(TRAKAZM.GT.91..AND.TRAKAZM.LT.269.)THEN
CC 
        IBST1=IBST(1)
C
C       INPUT RANGE INFO, STARTING BIN, ETC. AND RETURN "SURFACE BIN", IBEG
C 
        CALL FIND_GROUND(RDTAIIN,DEG2RAD,BEAM_WID,RS_TH,RS_M,
     +         DBZ_MAX,IBEG,NG2,IBST1)
        IBEGNEW=IBEG
        REFL=-32.
C 
C       IF THE "SURFACE BIN" IS GREATER THAN THE FIRST BIN...
C 
        IF(IBEG.GT.1)THEN
C 
C        LOOP 20 BINS INWARD FROM THE "SURFACE BIN"
C 
         DO L=1,20
          IBEGL=IBEG-L+1
C 
C         IF THE BIN IS GREATER THAN OR EQUAL TO THE 5TH BIN:
C         IF REF(BINNO) > -31.95 ASSIGN REFL=REF(BINNO), OTHERWISE
C         REFL=-32. IF REFL AND REF(BINNO-1) ARE BOTH > -31.95, THEN
C         IF THE GRADIENT IS POSITIVE WITH A CHANGE OF 5 DBZ, BINNO
C         BECOMES THE NEW SURFACE BIN.         
C 
          IF((IBEGL-1).GE.5)THEN
           IF(DBZBUFFER(IBEGL).GT.-31.95)REFL=DBZBUFFER(IBEGL)
           IF(REFL.GT.-31.95.AND.DBZBUFFER(IBEGL-1).GT.-31.95)THEN
            IF(REFL-DBZBUFFER(IBEGL-1).GT.5.)THEN
             IBEGNEW=IBEGL
            ENDIF
           ENDIF
          ENDIF
C 
         ENDDO
         IBEG=IBEGNEW
C
C        FROM THE SURFACE TO OUTERMOST BIN, FLAG REFLECTIVITY AND VELOCITY
C 
         DO I=IBEG,512
          BINONE(I)=-999.9
          REFONE(I)=-999.9
         ENDDO
C 
C       FLAG THE ENTIRE RAY IF FIND_GROUND FAILED  TO FIND SURFACE
C 
        ELSEIF(IBEG.EQ.-1)THEN
C 
         DO I=1,512
          BINONE(I)=-999.9
          REFONE(I)=-999.9
         ENDDO 
C 
        ENDIF
CC 
       ENDIF
CC      
C      END IF TRAKAZM
C 
C      ALL RAYS READ IN AND DIRECTING TO FINAL PROCESSING?  
C   
       GO TO 2000
CCC 
      ENDIF
CCC 
C     END IF ISWEEPSET EQUALS TWO
C 
C     INCREMENT THE RAY COUNTER, NUM_RAYS
C 
      NUM_RAYS=NUM_RAYS+1
C 
      RRLAT(NUM_RAYS)=RLAT
      RRLON(NUM_RAYS)=RLON
      RRA(NUM_RAYS)=RA
      EAZM(NUM_RAYS)=AZM
      EEV(NUM_RAYS)=EV
      TRACKSTORE(NUM_RAYS)=TRACK
      HEADSTORE(NUM_RAYS)=HEADING
      TMSWEEP(NUM_RAYS)=TIME
      RDWD(NUM_RAYS)=RADWD
      RDWS(NUM_RAYS)=RADWS
      RDVWS(NUM_RAYS)=RADVWS
C
C     FIND THE SURFACE IF THE RAW AZIMUTH IS BETWEEN 91 AND 269 DEG
C     THIS CORRESPONDS TO A BEAM POINTING DOWNWARD.
CCC 
      IF(TRAKAZM.GT.91..AND.TRAKAZM.LT.269.)THEN
CCC 
       IBST1=IBST(1)
C
C      INPUT RANGE INFO, STARTING BIN, ETC. AND RETURN "SURFACE BIN", IBEG
C 
       CALL FIND_GROUND(RDTAIIN,DEG2RAD,BEAM_WID,RS_TH,RS_M,
     + DBZ_MAX,IBEG,NG2,IBST1)
       IBEGNEW=IBEG
       REFL=-32.
C 
C      IF THE "SURFACE BIN" IS GREATER THAN THE FIRST BIN...
CC 
       IF(IBEG.GT.1)THEN
CC 
C       LOOP 20 BINS INWARD FROM THE "SURFACE BIN"
C 
        DO L=1,20
         IBEGL=IBEG-L+1
C 
C        IF THE BIN IS GREATER THAN OR EQUAL TO THE 5TH BIN:
C        IF REF(BINNO) > -31.95 ASSIGN REFL=REF(BINNO), OTHERWISE
C        REFL=-32. IF REFL AND REF(BINNO-1) ARE BOTH > -31.95, THEN
C        IF THE GRADIENT IS POSITIVE WITH A CHANGE OF 5 DBZ, BINNO
C        BECOMES THE NEW SURFACE BIN.         
C 
         IF((IBEGL-1).GE.5)THEN
          IF(DBZBUFFER(IBEGL).GT.-31.95)REFL=DBZBUFFER(IBEGL)
          IF(REFL.GT.-31.95.AND.DBZBUFFER(IBEGL-1).GT.-31.95)THEN
           IF(REFL-DBZBUFFER(IBEGL-1).GT.5.)THEN
            IBEGNEW=IBEGL
           ENDIF
          ENDIF
         ENDIF
        ENDDO
        IBEG=IBEGNEW
C
C       FROM THE SURFACE TO OUTERMOST BIN, FLAG REFLECTIVITY AND VELOCITY
C 
        DO I=IBEG,512
         BIN(I)=-999.9
         REF(I)=-999.9
        ENDDO
C 
6927    FORMAT(10F8.2)
CC
C      FLAG THE ENTIRE RAY IF...??
C 
       ELSEIF(IBEG.EQ.-1)THEN
C 
        DO I=1,512
         BIN(I)=-999.9
         REF(I)=-999.9
        ENDDO 
CC
       ENDIF
CCC 
      ENDIF
CCC 
C     END IF TRAKAZM
C 
2222  IF (NIX.EQ.-100)GO TO 2000
      IF (TAPE .EQ. 'Y') THEN 
          WRITE(6,'("Change Radar Tape; RETURN to continue")')
7060      PAUSE
          WRITE(6,'("1-continue, 2-pause:",nn)')
          READ(5,*,err=7060) irewind
          if (irewind .ne. 1) go to 7060
          TAPE='N'
          GO TO 7040
      ENDIF 
C 
C     WRITE RADAR INFORMATION TO DISK
C 
      ITIME=TIME
      AZ_EL(1,NUM_RAYS)=TRAKAZM
      AZ_EL(2,NUM_RAYS)=TRAKELEV
      PELEV(NUM_RAYS)=ELEV
      PAZM(NUM_RAYS)=RADAZM
      V0SAVE(NUM_RAYS)=V0
      IF(IBST(1).GE.1)THEN
       DO I=1,IBST(1)
        BIN(I)=-888.8
        REF(I)=-32.
        WIDTHBUFFER(I)=-888.8      
       ENDDO
      ENDIF
      DO I=1,NBINS
       SWEEP(I,NUM_RAYS)=BIN(I)
       SWEEPZ(I,NUM_RAYS)=REF(I)
       SWIDTH(I,NUM_RAYS)=WIDTHBUFFER(I)
      ENDDO
      IF(NBINS.LT.512)THEN
       DO I=NBINS+1,512
        SWEEP(I,NUM_RAYS)=-888.8
        SWEEPZ(I,NUM_RAYS)=-32.
       ENDDO
      ENDIF
5675  FORMAT(4(I3,F10.4))
      IF (MOD(ITIME,60).EQ.0 .AND. itime.NE.OLDTIME) THEN
         CALL CTME1(TIME,IH,IM,IS)
         WRITE(6,'(" Writing: ",3i2.2,1x,3(f9.3,1x),2(f12.4,1x))')
     +        IH,IM,IS,RLAT,RLON,RA,AZM,EV
      ENDIF
      OLDTIME=ITIME
C 
      GO TO 7040  ! DIRECT BACK TO READTAPE TO READ IN NEXT RAY
C 
C     ERROR CONDITIONS
C 
970   WRITE(LP,'(1X," Error searching for start time:",i6)') IERR
      GO TO 2000
998   WRITE(LP,'(1X,"Error Opening Input File: ",A,1X,"IERR= ",I6)')
     +      IFILE,IERR
      GO TO 2000
999   WRITE(LP,'(1X,"Bad Input Data",I4)') IERR 
      GO TO 2000
1000  WRITE(LP,1030)IERR,NAMEO
1030  FORMAT(1X,'Error on Creating Output File= ',I5,1X,A) 
      GO TO 2000
1040  WRITE(LP,1045)IERR,NAMEO
1045  FORMAT(1X,'Error on Write= ',I5,1X,A)
      GO TO 2000
1050  WRITE(LP,'("Error on opening Ram File: ",I5,1X,A80)') IERR,NAMERAM 
C 
C     DOES GETTING TO 2000 MEAN WE'VE READ IN AND STORED ALL THE RAYS?
C 
2000  NUM_RAYS=NUM_RAYS-1
C 
      write(6,*)'num_rays = ',num_rays
C 
      if(num_rays.ge.1)then
C 
       radvwmax=0.
       sumvw=0.
C
C      GET MAXIMUM MAGNITUDE OF FLIGHT-LEVEL VERTICAL WIND SPEED FOR SWEEP,
C      AS WELL WELL AS MAGNITUDE OF MEAN VALUE OF VERTICAL WIND SPEED. IF
C      MAX MAG > 30 M/S OR MAG OF MEAN > 15 M/S, FLAG SWEEP.
C 
       do j=1,num_rays
        radvwtest=abs(rdvws(j))
        sumvw=sumvw+rdvws(j)
        if(radvwtest.gt.radvwmax)radvwmax=radvwtest
       enddo
       radvwmean=sumvw/num_rays
       write(6,*)'radvwmax,radvwmean = ',radvwmax,radvwmean
       radvwmean=abs(radvwmean)
       if(radvwmax.gt.30..or.radvwmean.gt.15.)then
        do j=1,num_rays
         do i=1,nbins
          sweep(i,j)=-888.8
         enddo
        enddo
       endif
C 
      endif
C 
C     HOLD THE RAY INDEX FOR THE FIRST RAY HAVING AIRCRAFT-RELATIVE RAW
C     AZIMUTH ANGLE BETWEEN 90 AND 271 DEG, JSTART
C 
      RATEST=RA/1000.
C 
      JSTART=0
      DO J=1,NUM_RAYS
       IF(AZ_EL(1,J).GT.90..AND.AZ_EL(1,J).LT.271.)THEN
        WRITE(6,*)'J,AZ_EL = ',AZ_EL(1,J)
        JSTART=J
        GO TO 18187
       ENDIF
      ENDDO
      GO TO 19187
C
C     HOLD THE RAY INDEX FOR THE FIRST RAY BEYOND JSTART HAVING AIRCRAFT-RELATIVE RAW
C     AZIMUTH ANGLE GREATER THAN 270 DEG, JEND
C 
18187 JEND=0
      DO J=JSTART+1,NUM_RAYS
       IF(AZ_EL(1,J).GT.270.)THEN
        JEND=J-1
        GO TO 18181
       ENDIF
      ENDDO
18181 CONTINUE
C
C     RADIFFTEST IS THE RADAR ALTITUDE DIVIDED BY 1.5. RALTDIFF IS
C     THE RANGE OF GIVEN BIN MINUS THE RADAR ALTITUDE. IF THIS DIFFERENCE
C     IS > -RADIFFTEST...? FROM GATES IRINSIDE TO IROUTSIDE FLAG THE BINS HAVING REFLECTIVITY
C     LESS THAN ZERO OR VERTICAL HEIGHT LESS THAN OR EQUAL TO 0.5 KM.
C     SIDELOBE REMOVAL VIA RING...
C 
      IRINSIDE=0
      IROUTSIDE=513
      RADIFFTEST=RATEST/1.5
      DO I=1,NBINS
       RALTDIFF=RDTAIIN(I)-RATEST
       IF(RALTDIFF.GT.-RADIFFTEST.AND.IRINSIDE.EQ.0)THEN
        IRINSIDE=I
       ENDIF
       IF(RALTDIFF.GT.RADIFFTEST)THEN
        IROUTSIDE=I-1
        GO TO 18182
       ENDIF
      ENDDO
18182 CONTINUE
      IF(IRINSIDE.GE.1.AND.IROUTSIDE.LE.NBINS)THEN
       DO I=IRINSIDE,IROUTSIDE
        DO J=1,NUM_RAYS
         IF(SWEEPZ(I,J).LT.0..OR.ZRSWEEP(I,J).LE.0.5)THEN
          SWEEP(I,J)=-999.9
          SWEEPZ(I,J)=-32.
         ENDIF
        ENDDO
       ENDDO
      ENDIF
C
C     IF THE RANGE OF A GIVEN GATE BIN IS GREATER THAN THE
C     THE RADAR ALTITUDE, PERFORM THE FOLLOWING: 
CCC 
      DO I=1,NBINS
CCC 
       IF(RDTAIIN(I).GT.RATEST)THEN
CC
C       INITIALLY, JJ IS RAY INDEX FOR THE FIRST RAY HAVING AIRCRAFT-
C       RELATIVE RAW AZIMUTH ANGLE BETWEEN 90 AND 271 DEG, JSTART.
C       NOTE IGTEST IS NOT USED
C 
        IGTEST=0
        J=NUM_RAYS+1
        JJ=JSTART
C 
C       FOR GIVEN GATE BIN, AS LONG AS DBZ(JJ) IS NOT FLAGGED, INCREMENT
C       J FROM JJ. THEN INCREMENT JJ. IF DBZ(JJ) IS FLAGGED, JUST 
C       INCREMENT JJ. SO IF DBZ FOR ALL RAYS IS FLAGGED, J = NUM_RAYS+1. 
C       OTHERWISE, J-1 SEEMS TO BE THE RAY INDEX WITHIN DOWNWARD-RIGHT QUADRANT
C       LAST HAVING REFLECTIVITY?
C 
        DO WHILE(JJ.LE.NUM_RAYS.AND.AZ_EL(1,JJ).LT.180.)
         IF(SWEEPZ(I,JJ).GT.-32.)THEN
          J=JJ+1
         ENDIF
         JJ=JJ+1
        ENDDO
C 
C       IF DBZ FOR ALL RAYS IS FLAGGED, SKIP. OTHERWISE USE THE RAY
C       POINTING MOST VERTICALLY DOWNWARD TO DO GROUND CHECK?
C 
6498    IF(J.LE.NUM_RAYS.AND.AZ_EL(1,J).LT.180.)THEN
         ICHECK=1
         CALL GROUNDCHECK(SWEEP,SWEEPZ,NUM_RAYS,I,J,ICHECK)
        ENDIF
C 
        J=0
        JJ=JEND
        JAZTEST=1
C 
C       BELOW SEEMS TO COVER THE DOWNWARD-LEFT QUADRANT, FOLLOWING 
C       PROCEDURE DESCRIBED ABOVE
C 
        DO WHILE(JJ.GE.1.AND.JAZTEST.EQ.1)
         IF(AZ_EL(1,JJ).GT.180.)THEN
          IF(SWEEPZ(I,JJ).GT.-32.)THEN
           J=JJ-1
          ENDIF
          JJ=JJ-1
          JAZTEST=1
         ELSE
          JAZTEST=0
         ENDIF
        ENDDO
C 
6499    IF(J.GE.1)THEN
         IF(AZ_EL(1,J).GT.180.)THEN
          ICHECK=2
          CALL GROUNDCHECK(SWEEP,SWEEPZ,NUM_RAYS,I,J,ICHECK)
         ENDIF
        ENDIF
CC 
       ENDIF
CCC 
      ENDDO
CCC 
19187 DO ICHECKSWEEP=1,3
C
C      LOOP OVER ENTIRE SWEEP. QC BY FLAGGING (GATE,RAY) POINT NOT 
C      IMMEDIATELY SURROUNDED BY GOOD VELOCITY, OR AT LEAST HAS TWO
C      CONSECUTIVE ADJACENT GATES AND RAYS OF GOOD VELOCITY
C 
       DO I=1,NBINS
        DO J=1,NUM_RAYS
C 
C        ASSUME ALL RAYS AND GATES OF SWEEP ARE TO BE KEPT
C 
         IKEEP(I,J)=1
CC
         IF(SWEEP(I,J).GT.-800.)THEN  ! IF NOT ALREADY FLAGGED
CC
C
C         FOR GIVEN GATE BIN, LOOP FROM TWO BINS INSIDE TO TWO 
C         BINS OUTSIDE. IF LOOPED BIN, I1, NOT A VALID BIN OR IF 
C         FLAGGED, IITEST(I1)=0.  
C 
          DO I1=1,5
           II=I+I1-3
           IF(II.GT.0.AND.II.LE.512)THEN
            IF(SWEEP(II,J).GT.-800)THEN
             IITEST(I1)=1
            ELSE
             IITEST(I1)=0
            ENDIF
           ELSE
            IITEST(I1)=0
           ENDIF
          ENDDO
C 
C         FOR A GIVEN RAY, LOOP FROM TWO RAYS CW TO TWO RAYS
C         CCW. IF LOOPED RAY, J1, NOT A VALID RAY OR IF 
C         FLAGGED, JJTEST(J1)=0.
C 
          DO J1=1,5
           JJ=J+J1-3
           IF(JJ.GT.0.AND.JJ.LE.NUM_RAYS)THEN
            IF(SWEEP(I,JJ).GT.-800)THEN
             JJTEST(J1)=1
            ELSE
             JJTEST(J1)=0
            ENDIF
           ELSE
            JJTEST(J1)=0
           ENDIF
          ENDDO
C 
C         AS LONG AS GATES ADJACENT TO BIN, TWO INWARD OF BIN, OR
C         TWO OUTWARD OF BIN ARE NONFLAGGED, IKEEPER=1
C 
          IKEEPER=0
          IF(IITEST(2).EQ.1.AND.IITEST(4).EQ.1)THEN  ! ADJACENT TO BIN
           IKEEPER=1
          ELSEIF(IITEST(1).EQ.1.AND.IITEST(2).EQ.1)THEN  ! INWARD OF BIN
           IKEEPER=1
          ELSEIF(IITEST(4).EQ.1.AND.IITEST(5).EQ.1)THEN  ! OUTWARD OF BIN
           IKEEPER=1
          ENDIF
C 
C         AS LONG AS RAYS ADJACENT TO RAY, TWO CW OF RAY, OR
C         TWO CCW OF RAY ARE NONFLAGGED, JKEEPER=1
C 
          JKEEPER=0
          IF(JJTEST(2).EQ.1.AND.JJTEST(4).EQ.1)THEN
           JKEEPER=1
          ELSEIF(JJTEST(1).EQ.1.AND.JJTEST(2).EQ.1)THEN
           JKEEPER=1
          ELSEIF(JJTEST(4).EQ.1.AND.JJTEST(5).EQ.1)THEN
           JKEEPER=1
          ENDIF
C 
C         (GATE,RAY) IS NOT TO BE KEPT IF ABOVE CONDITIONS NOT MET
C 
          IF(IKEEPER.EQ.0.OR.JKEEPER.EQ.0)THEN
           IKEEP(I,J)=0
          ENDIF
CC
         ENDIF
CC 
        ENDDO 
       ENDDO 
C 
C      END LOOP OVER ENTIRE SWEEP
C 
C      FLAG (GATE,RAY) FAILING ABOVE QC
C 
       DO I=1,512
        DO J=1,NUM_RAYS
         IF(IKEEP(I,J).EQ.0)SWEEP(I,J)=-999.9
        ENDDO
       ENDDO 
C 
C     DO THE ABOVE AGAIN WITH NEWLY FLAGGED VELOCITY DATA
C 
      ENDDO
C     
C     QUESTION: WHY -999.9 IN SOME PLACES AND -888.8 IN OTHERS?
C     TO BE CONSERVATIVE: IF RANGE GAP EXCEEDS 1KM, JUST FLAG ALL
C     VELOCITY BEYOND GAP (TO FACILITATE INITIAL DEALIASING)
C 
      IF(ICONSERVE.EQ.1)THEN
       DO J=1,NUM_RAYS
        RADSAVER=0.
        I=1
        DO WHILE(I.LT.NBINS)
C
C        IF VELOCITY IS NONFLAGGED OR RANGE IS < 2KM OR
C        RANGE HAS BEEN SET TO 1000 (ABOVE), ASSIGN TO
C        RADSAVER THE RANGE VALUE. THEN INCREMENT BIN NUMBER.
C 
         IF(SWEEP(I,J).GT.-98..OR.RDTAIIN(I).LT.2..OR.
     +    RDTAIIN(I).GT.999.9)THEN
          RADSAVER=RDTAIIN(I)
          I=I+1
C
C        IF THE DIFFERENCE BETWEEN THE RANGE AND RADSAVER
C        IS > 1KM, LOOP THROUGH ALL BINS BEGINNING WITH
C        I AND FLAG THE VELOCITY. THEN MOVE ON TO NEXT RAY.
C 
         ELSEIF(RDTAIIN(I)-RADSAVER.GT.1.)THEN
          DO L=I,NBINS
           SWEEP(L,J)=-888.8
          ENDDO
          GO TO 6305
C
C        OTHERWISE DO NOTHING AND INCREMENT I
C 
         ELSE
          I=I+1
         ENDIF
C 
        ENDDO
6305   ENDDO
      ENDIF
C 
C     DEFRECKLE DATA: FLAG VELOCITY DATA IF AVERAGE DIFFERENCE BETWEEN
C     TEST POINT AND SURROUNDING SECTOR DATA (+/- 3 GATES AND RAYS) IS
C     TOO LARGE. 
C 
      XNIQTA1=XNIQTA
      CALL DEFRECKLE(IMAXBINS,JMAXRAYS,
     1 NUM_RAYS,PAZM,SWEEP,VROUT,XNIQTA1)
C 
C     PASS EACH RAY INTO UNFLDNEW TO BE DEALIASED VIA BARGEN
C     AND BROWN ALGORITHM
CC 
      DO J=1,NUM_RAYS
CC 
       V00=V0SAVE(J)
       M=INOB(1)
       IRS=1
       NB=NBINS
       VN=XNIQTA  ! NYQUIST VELOCITY
C 
       DO I=1,NBINS
C 
        RAY(I)=SWEEP(I,J)
C 
        IF(ABS(HEADSTORE(J)).LT..1)RAY(I)=-888.8
        DIFFHDTRK=HEADSTORE(J)-TRACKSTORE(J)
C 
        IF(ABS(DIFFHDTRK).LT..1)RAY(I)=-888.8
C 
C       SINCE IUSEWIND EQUALS ONE, THE FOLLOWING JUST SETS
C       VRRAD TO FLAGGED VALUES
C 
        IF(IUSEWIND.NE.1)THEN
         VRRAD(I,J)=-888.8
        ELSEIF(IUSEWIND.EQ.1)THEN
         IF(VRRAD(I,J).LT.-800.)THEN
          RAY(I)=-888.8
         ENDIF
        ENDIF
        URAY(I)=VRRAD(I,J)
       ENDDO
C 
       CALL UNFLDNEW(V00,VN,M,IRS,NB,RAY,URAY,NB)
C 
C      OVERWRITE SWEEP WITH UNFOLDED VELOCITY DATA
C 
       DO I=1,NBINS
        SWEEP(I,J)=URAY(I)
       ENDDO
CC 
      ENDDO
CC 
C     STORE 7/10 NYQUIST VELOCITY IN XXNIQTA    
C 
      XXNIQTA=XNIQTA*.7
      XXNIQ=XNIQTA
C
C     CREATE (GATE,RAY) ARRAY CONTAINING CONSTANT NYQUIST VELOCITY (NOT USED?)
C 
      DO I=1,NBINS
       DO J=1,NUM_RAYS
        NYQ(I,J)=XXNIQ
       ENDDO
      ENDDO
C 
      write(6,*)'calling aziunfld'
C 
C     HOLD BARGEN AND BROWN DEALISED VELOCITY IN SWEEPSAVE
C 
      DO J=1,NUM_RAYS
       DO I=1,512
        SWEEPSAVE(I,J)=SWEEP(I,J)
       ENDDO
      ENDDO
C 
C     "AZIMUTHAL CONTINUITY" DEALIASING
C 
      NB=NBINS
      CALL AZIUNFLD(SWEEP,ISEG,ISEGE,MAX_GATES,NB,MAX_RAYS,XXNIQTA,
     1       RDTAIIN,AZ_EL,XXNIQ,NUM_RAYS,VRRAD,IUSEWIND,PAZM)
C 
      write(6,*)'returned from aziunfld'
C 
C     SWEEP NOW CONTAINS 'FULLY' DEALIASED VELOCITY 
C 
      FLAGVAL=-888.8
      IVADFLAG=10
      IMINRNG=1
      NRANG=NBINS
      NSWEEPSUM=0
      YVRSUM=0
      XVRSUM=0
      VVRSUM=0
C 
      DO J=1,NUM_RAYS
       IF(SWEEP(5,J).GT.-800.)THEN
        NSWEEPSUM=NSWEEPSUM+1
        YVRSUM=COS(PAZM(J))+YVRSUM
        XVRSUM=SIN(PAZM(J))+XVRSUM
        VVRSUM=VVRSUM+SWEEP(5,J)
       ENDIF
      ENDDO
C 
      IF(NSWEEPSUM.GT.0)THEN
       YTEST=YVRSUM/NSWEEPSUM
       XTEST=XVRSUM/NSWEEPSUM
       VRTEST=VVRSUM/NSWEEPSUM
       WRITE(6,*)'NSWEEPSUM,YVRSUM,XVRSUM,VVRSUM = ',
     1            NSWEEPSUM,YVRSUM,XVRSUM,VVRSUM
       WRITE(6,*)'NSWEEPSUM,YTEST,XTEST,VRTEST = ',
     1            NSWEEPSUM,YTEST,XTEST,VRTEST
      ENDIF
C 
C     HOLD 'FULLY' DEALIASED VELOCITY IN SWEEPSAVE
C 
      DO J=1,NUM_RAYS
       DO I=1,NBINS
        SWEEPSAVE(I,J)=SWEEP(I,J)
       ENDDO
      ENDDO
C 
      ILATERSWEEP=1
C
C     IF RANGE GAP BETWEEN SECOND AND THIRD GATES EXCEEDS 145 M,
C     THEN I150 EQUALS ONE. NOT SURE OF PURPOSE HERE? (DEALING
C     WITH VARIABLE RESOLUTION DATA WITH RANGE...)
C 
      IF(I150.EQ.1)THEN
       ITEST1=64
       ITEST2=-1
       ITEST3=-1
       ITEST4=-1
       MULT1=8
       MULT2=-1
       MULT3=-1
       MULT4=-1
       KSTART1=1
       KSTART2=-1000
       KSTART3=-1000
      ELSE
       MULT1=16
       MULT2=8
       MULT3=4
       KSTART1=1
       KSTART2=257
       KSTART3=385
       ITEST1=16
       ITEST2=17
       ITEST3=32
       ITEST4=33
      ENDIF
C
C     LOOP OVER ALL RAYS, AND 8 BIN INTERVALS, FOR EXAMPLE
C     1...8, 9...16, ETC. THROUGH 512
CCC 
      DO J=1,NUM_RAYS 
       DO I=1,64
CCC 
C
C       DOCUMENT FOR CASE: I150 EQUALS ONE
C       FIRST CONDITION ALWAYS TRUE SO K = 1 + 8*(I-1)
C       AND M = 8*I... FOR FIRST BIN, K=1 AND M=8
C 
        IF(I.LE.ITEST1)THEN
         K=KSTART1+(I-1)*MULT1
         M=I*MULT1
        ELSEIF(I.GE.ITEST2.AND.I.LE.ITEST3)THEN
         K=KSTART2+(I-ITEST2)*MULT2
         M=K+MULT2-1
        ELSEIF(I.GE.ITEST4)THEN
         K=KSTART3+(I-ITEST4)*MULT3
         M=K+MULT3-1
        ENDIF
C 
        SUM=0.
        SUMD=0.
        SUMND=0.
        SUMN=0.
        RADSUM=0.
        RADSUMN=0.
C 
C       FOR 8 BIN INTERVAL: IF THIS IS THE FIRST SWEEP AND FIRST RAY,
C       THEN IF THE RANGE IS LESS THAN 200 M, SUM RANGE VALUES. ALSO
C       SUM NONFLAGGED VELOCITY AND REFLECTIVITY VALUES WITHIN INTERVAL.
CC 
        DO L=K,M
CC 
         IF((ICALLSWEEPIN.EQ.0..OR.INEWRAD.EQ.1).AND.J.EQ.1)THEN
          IF(RDTAIIN(L).LT.200..AND.L.LE.NBINS)THEN
           RADSUMN=RADSUMN+1
           RADSUM=RADSUM+RDTAIIN(L)
          ENDIF
         ENDIF
C 
         IF(SWEEP(L,J).GT.-888.8.AND.L.LE.NBINS)THEN
          SUM=SUM+SWEEP(L,J)
          SUMN=SUMN+1.
         ENDIF
         IF(SWEEPZ(L,J).GT.-20..AND.L.LE.NBINS)THEN
          SUMD=SUMD+SWEEPZ(L,J)
          SUMND=SUMND+1.
         ENDIF
CC 
        ENDDO
CC 
C       ASSIGN THE INTERVAL-AVERAGE VALUE OF VELOCITY TO SWEEP(I)
C       NOTE: 8*150M=1.2KM, SO THIS AVERAGING REDUCES THE RESOLUTION
C       (512 BINS --> 64 BINS) BUT ULTIMATELY SPEEDS UP INTERPOLATION.  
C 
        IF(SUMN.GT.0.)THEN
         SWEEP(I,J)=SUM/SUMN
        ELSE
         SWEEP(I,J)=-888.8
        ENDIF
C 
        IF((ICALLSWEEPIN.EQ.0..OR.INEWRAD.EQ.1).AND.J.EQ.1)THEN
         IF(RADSUMN.GT.0.)THEN
          RDTAI(I)=RADSUM/RADSUMN
         ELSE
          RDTAI(I)=1000.
         ENDIF
         WRITE(6,*)'I,RADSUM,RADSUMN,RDTAI = ',
     +              I,RADSUM,RADSUMN,RDTAI(I)      
        ENDIF
C 
C       ASSIGN THE INTERVAL-AVERAGE VALUE OF REFLECTIVITY TO SWEEPZ(I)
C 
        IF(SUMND.GT.0.)THEN
         SWEEPZ(I,J)=SUMD/SUMND
        ELSE
         SWEEPZ(I,J)=-32.
        ENDIF
CCC 
       ENDDO 
      ENDDO
CCC 
      NBINSPARM=64
C 
      DO I=64,10,-1
       IF(RDTAI(I).LE.0..OR.RDTAI(I).GE.1000.)THEN
        NBINSPARM=I
       ENDIF
      ENDDO
C 
76383 IF(NBINSPARM.GT.1)NBINSPARM=NBINSPARM-2
      WRITE(6,*)'NBINSPARM = ',NBINSPARM
C 
      RETURN
      END 
C
C  *********************************************************************
C 
      SUBROUTINE GROUNDCHECK(SWEEP,SWEEPZ,NUM_RAYS,I,JSTART,ICHECK)
C 
C     SUBROUTINE CALLED BY SWEEPIN (NEWSWEEPREAD_AUTO_FIRST_DISC_DEFRECKLE.F)
C       
C ... FUNCTION:   
C       
C     THIS SUBROUTINE...
C
C ... GROUNDCHECK SUBPROGRAM REFERENCES: NONE
C     
C     VERSION:  <TBD>
C       
C     CODE WRITTEN BY:  JOHN GAMACHE   
C                       HRD/AOML/NOAA          
C                       MIAMI, FL 33149      
C       
C     FOR ADDITIONAL DETAILS ON THE ALGORITHM SEE <TBD>
C       
C     BASED ON THEORY BY:  <TBD>
C       
C     REFERENCE THE BOOK:  <TBD>
C       
C     **************************************************  
C     *               IMPORTANT NOTE                   *  
C     *                                                *  
C     *                    <TBD>                       *  
C     *                                                *  
C     **************************************************         
C
C     SPECIFICATIONS FOR ARGUMENTS
C    
      REAL SWEEP(512,800),SWEEPZ(512,800)
C 
      IF(ICHECK.LT.1.OR.ICHECK.GT.2)THEN
       WRITE(6,*)'PROBLEM WITH ICHECK IN GROUNDCHECK'
       STOP
      ENDIF
C 
C     BY DEFINITION THIS RAY JSTART SHOULD HAVE FLAGGED DBZ
C 
      IF(SWEEPZ(I,JSTART).GT.-32.)THEN
       WRITE(6,*)'SWEEPZ(I,JSTART) GT -32.'
       WRITE(6,*)'I,JSTART,SWEEP,SWEEPZ = ',
     +  I,JSTART,SWEEP(I,JSTART),SWEEPZ(I,JSTART)
       STOP
      ENDIF
C 
C     DOWNWARD-RIGHT QUADRANT
C     NOTE: J IS NOT USED
C 
      IF(ICHECK.EQ.1)THEN
       IF(JSTART.LT.5)RETURN
       J=JSTART-4
       SWTEST1=SWEEPZ(I,JSTART-1)-SWEEPZ(I,JSTART-3)
       SWTEST2=SWEEPZ(I,JSTART-2)-SWEEPZ(I,JSTART-3)
C
C      IF DBZ GRADIENT BETWEEN LAST RAY HAVING REFLECTIVITY
C      AND TWO BEFORE (CCW) OR BETWEEN ONE BEFORE LAST RAY
C      HAVING REFLECTIVITY AND ONE BEFORE THAT (CCW) EXCEEDS
C      10 DBZ, THEN FLAG WIND AND REFLECTIVITY IN LAST RAY 
C      HAVING REFLECTIVITY AND ONE BEFORE (CCW).
C 
       IF(SWTEST1.GT.10..OR.SWTEST2.GT.10.)THEN
        SWEEPZ(I,JSTART-1)=-32.
        SWEEPZ(I,JSTART-2)=-32.
        SWEEP(I,JSTART-1)=-888.8
        SWEEP(I,JSTART-2)=-888.8
       ENDIF
C
C     DOWNWARD-LEFT QUADRANT
C     NOTE: JEND IS NOT USED
C 
      ELSE
       IF(NUM_RAYS-JSTART.LT.4)RETURN
       JEND=JSTART+4
       SWTEST1=SWEEPZ(I,JSTART+1)-SWEEPZ(I,JSTART+3)
       SWTEST2=SWEEPZ(I,JSTART+2)-SWEEPZ(I,JSTART+3)
C
C      SEE ABOVE FOR FLAGGING PROCEDURE
C 
       IF(SWTEST1.GT.10..OR.SWTEST2.GT.10.)THEN
        SWEEPZ(I,JSTART+1)=-32.
        SWEEPZ(I,JSTART+2)=-32.
        SWEEP(I,JSTART+1)=-888.8
        SWEEP(I,JSTART+2)=-888.8
       ENDIF
      ENDIF
C 
      RETURN
      END
C
C  *********************************************************************
C  
      SUBROUTINE READTAPE(TIME,RLAT,RLON,RA,AZM,EV,BIN,REF,
     +                    RCAZM,ITAPEOPEN,RADARFILE,NUMREC,
     +                    PCORS,DCORS,RCORS,AZMCORS,
     +                    RDELCORTAS,ELCORS)
C 
C     SUBROUTINE TO READ DOPPLER AND REFLECTIVITY DATA FROM THE NEW 1988 
C     FORMAT RADAR TAPES. READS REFLECTIVITY/DOPPLER WHEN RTYPE=6 AND 
C     DOPPLER/REFLECTIVITY/SPECTRAL WIDTH WHEN RTYPE=7. IT RETURNS ONE 
C     RAY PER CALL. NIX=-100 DETERMINES AND END-OF-FILE. 
C 
      COMMON /AREA1/ INM,IFLT,STIME,ETIME,WD,WS,NIX,NGATE1,LP,LUNR,
     +               IVT,RAMFL
      COMMON /TAPEHEADER/ nbytesheader,ntape,nversion,ihheader,imheader,
     +                    isheader,ine,ndrive,naircraft,flightid,stmname
     +                    ,nsamplelf,nsampleta,refslopelf,refslopeta,
     +                    refnoisethreslf,refnoisethresta,sqilf,sqita,
     +                    widththreslf,widththresta,caliblf,calibta,
     +                    modedatalf,modedatata,noisetmlf,noisetmta,
     +                    rpmlf,rpmta,gtlnlf,ivrangelf,ivrangeta,
     +                    gtlnta(3),rdellf,rdelta,rdelcorlf,rdelcorta,
     +                    nbinlf,nbinta,nbins,rmaxlf,rmaxta,
     +                    radiita(512),radiilf(512),prf_flaglf,
     +                    prf_flagta,prf_highlf,prf_highta,xniqlf,
     +                    xniqta,iheader(1024)
      COMMON /RAYHEADER / nbytesdata,nlfsweep,ntasweep,numrecord,
     +                    irecflag,idradar,nbytesray,icode,idsp,mdata,
     +                    iyear,month,iday,iraycode,radtime,ih,im,is,
     +                    is100,radlat,radlon,radalt,gse,gsn,radgs,
     +                    radvgs,ucom,vcom,radwd,radws,radvws,ircu,
     +                    elev,radazm,pitch,roll,drift,heading,
     +                    dbzbuffer(512),velbuffer(512),widthbuffer(512)
      COMMON /PARAMS/ trakazm,trakelev,driftnew,
     +                rot,track,htbb,dbb,thresh,swthresh,dbzrs,ibst(2),
     +                inob(2),ileg,xniq,irsw,maxnbins,v0,
     +                pcor,dcor,rcor,azmcor,elcor,dbzcor,dbzslope,
     +                iunfoldflag,iattenflag,
     +                badstabflag,surfelimflag,echoflag,atmflag
      LOGICAL badstabflag, surfelimflag, echoflag, atmflag
      INTEGER*2 IHEADER
      INTEGER RTYPE
      INTEGER PRF_FLAGLF, PRF_FLAGTA
      REAL PCORS(2),DCORS(2),RCORS(2),AZMCORS(2)
      REAL RDELCORTAS(2),ELCORS(2)
      CHARACTER FLIGHTID*8,STMNAME*16 
      CHARACTER IFLT*8, INM*12
      CHARACTER *1 RAMFL, IVT
      CHARACTER*80 RADARFILE
      DIMENSION BIN(512),REF(512)
      DATA RTYPE/6/
C 
      DO I=1,512
       BIN(I)=-888.8
       REF(I)=-32.
      ENDDO
      IF (SWTHRESH.GT.0.0 .AND. SWTHRESH.LE.13.0) RTYPE=7
50    IF(ITAPEOPEN.EQ.0)THEN
       CALL RADARDISCREAD1(LUNR,2,0,RTYPE,IERR)
      ELSE
       CALL RADARTAPEREAD(LUNR,2,0,RTYPE,IERR)
      ENDIF
      IF (IERR .LT. 0) THEN
         NIX= -100
         RETURN
      ENDIF
      IF(ELEV.LT.0.)THEN
       PCOR=PCORS(1)
       DCOR=DCORS(1)
       RCOR=RCORS(1)
       AZMCOR=AZMCORS(1)
       ELCOR=ELCORS(1)
      ELSE
       PCOR=PCORS(2)
       DCOR=DCORS(2)
       RCOR=RCORS(2)
       AZMCOR=AZMCORS(2)
       ELCOR=ELCORS(2)
      ENDIF
C 
C     CLEAR NIX VARIABLE
C 
      NIX= 0
C
C     TIME IN SECONDS
C 
      TIME=RADTIME
C 
C     RAW AZIMUTH
C 
      TRAKAZM=RADAZM
C 
c     ROLL CORRECTED AZIMUTH BUT IN HEADING RATHER THAN TRACK
C 
      RCAZM=RADAZM+RCOR+ROLL
C
C     RAW ELEVATION
C 
      TRAKELEV=ELEV
C
C     RAW DRIFT
C 
      DRIFTNEW=DRIFT
C
C     NYQUIST VELOCITY
C 
      XNIQ=XNIQTA
      track = AMOD(heading + driftnew + 360.0, 360.0)
C 
C     ANGLECOR CORRECTS THE AIRCRAFT PITCH, DRIFT, ROLL, AZIMUTH, ELEVATION
C     AND ADDS THE ROLL TO THE AZIMUTH
C 
      CALL ANGLECOR(PITCH,DRIFTNEW,ROLL,TRAKAZM,TRAKELEV,2,PCOR,
     +              DCOR,RCOR,AZMCOR,ELCOR)
C
C     CONVERT AIRCRAFT ANGLES TO EARTH-RELATIVE SPHERICAL COORDINATES
C 
      CALL CONVERTANGLES(TRACK,TRAKAZM,TRAKELEV,HORAZM,HORELEV)
C 
C     AZIMUTH (EARTH RELATIVE)
C 
      AZM=HORAZM
C 
C     ELEVATION ANGLE (EARTH RELATIVE)
C 
      EV=HORELEV
C 
C     GET INFORMATION FROM THE RAM FILES 
C 
      IF (RAMFL .EQ. 'Y')
     *   CALL READRAMFILE(TIME,TIMERAM,RADLAT,RADLON,RADALT,
     *                    RADWD,RADWS,UCOM,VCOM,RADVWS,RADVGS,IOS)
C 
C     GET INFORMATION FROM THE RADAR TAPE OR STANDARD TAPE
C 
      GS=RADGS                       !ground speed
      VGS=RADVGS                     !vertical ground speed
      VWS=RADVWS                     !vertical wind speed
      RLAT=RADLAT                    !latitude(deg)
      RLON=RADLON                    !longitude(deg)
      RA=RADALT                      !radar altitude(meters) 
      WD=RADWD                       !wind direction
      WS=RADWS                       !wind speed
C 
C     RAYCOR CORRECTS THE VELOCITIES ONE RAY AT A TIME. IT RETURNS THE
C     AIRCRAFT TRACK, FIRST GUESS WIND, THE STABILIZED, VT-CORRECTED
C     AND UNFOLDED VELOCITIES AS WELL AS THE DBZ VALUES FROM THE TAIL RADAR.
C 
      CALL RAYCOR1(BIN,REF)
C 
      RETURN
      END 
C
C  *********************************************************************
C 
      BLOCK DATA
C 
      COMMON /AREA1/ INM,IFLT,STIME,ETIME,WD,WS,NIX,NGATE1,LP,LUNR,
     +               IVT,RAMFL
      COMMON /PARAMS/ trakazm,trakelev,driftnew,
     +                rot,track,htbb,dbb,thresh,swthresh,dbzrs,ibst(2),
     +                inob(2),ileg,xniq,irsw,maxnbins,v0,
     +                pcor,dcor,rcor,azmcor,elcor,dbzcor,dbzslope,
     +                iunfoldflag,iattenflag,
     +                badstabflag,surfelimflag,echoflag,atmflag
      LOGICAL badstabflag, surfelimflag, echoflag, atmflag
      CHARACTER IFLT*8, INM*12
      CHARACTER *1 RAMFL, IVT
      DATA NIX/0/, NGATE1/5/, IVT/'N'/, RAMFL/'N'/ 
      DATA rot/0.0/, htbb/-99./, dbb/2.0/, thresh/-99.0/, swthresh/99./,
     1     dbzrs/-99./, ibst/2*0/, inob/2*0/, ileg/1/, xniq/12.8/,
     2     irsw/0/, maxnbins/512/, 
     3     pcor,dcor,rcor,azmcor,elcor,dbzcor/6*0.0/, dbzslope/1.0/,
     4     iunfoldflag/0/, iattenflag/0/,
     5     badstabflag/.true./, surfelimflag/.false./,
     6     echoflag/.false./, atmflag/.false./
C 
      END 
C
C  *********************************************************************
C 
      SUBROUTINE VRLOCATER(TIMES,OLAT,OLON,
     + RLAT,RLON,ALT,ELEV,AZIM,RANGE,XR,YR,ZR,
     + ISCANDIM,SMOTIONU,SMOTIONV,CENTIME)
C 
      REAL RANGE(ISCANDIM),XR(ISCANDIM),YR(ISCANDIM),ZR(ISCANDIM)
      REAL SUM(1024),WSUM(1024),WEIGHT(200),VR(1024)
C 
      RALT=ALT/1000.
      PI=ASIN(1.0)*2.
      DTR=PI/180.
      REARTH=6366.
      TDIFF=TIMES-CENTIME
C
C     X(Y)SHIFT=EAST-WEST (NORTH-SOUTH) DISTANCE FROM LOWER-LEFT CORNER TO ORIGIN
C 
      XSHIFT=TDIFF*SMOTIONU/1000.
      YSHIFT=TDIFF*SMOTIONV/1000.     
      RAZIM=AZIM*DTR
      RELEV=ELEV*DTR
C 
      DO I=1,ISCANDIM
C
C      XRADAR=HORIZONTAL DISTANCE FROM AIRCRAFT
C      YRADAR=VERTICAL DISTANCE FROM CENTER OF EARTH
C 
       XRADAR=RANGE(I)*COS(RELEV)
       YRADAR=REARTH+RALT+RANGE(I)*SIN(RELEV)
C
C      RADARNEW=DISTANCE OF DATUM FROM CENTER OF EARTH
C 
       RADNEW=SQRT(XRADAR*XRADAR+YRADAR*YRADAR)
C
C      DELANGLE=ANGLE BETWEEN VERTICAL AT AIRCRAFT AND VERTICAL AT DATUM
C 
       DELANGLE=ATAN(XRADAR/YRADAR)
C
C      DISTANCE ALONG GREAT CIRCLE FROM RADAR TO DATUM
C 
       DISTANCE=.5*(RADNEW+REARTH+RALT)*DELANGLE
C
C      HEIGHT=ALTITUDE OF DATUM
C 
       HEIGHT=RADNEW-REARTH
C
C      DISTANCE2=XRADAR
C 
       DISTANCE2=RANGE(I)*COS(RELEV)
C
C      HEIGHT2=ALTITUDE OF DATUM NOT ACCOUNTING FOR EARTH'S CURVATURE
C 
       HEIGHT2=RALT+RANGE(I)*SIN(RELEV)
C
C      DELX(Y)=DISTANCE (AIRCRAFT/DATUM) ALONG GREAT CIRCLE DUE TO EAST WEST (NORTH SOUTH)
C 
       DELX=DISTANCE*COS(RAZIM)
       DELY=DISTANCE*SIN(RAZIM)
C
C      DX=EAST-WEST DISTANCE FROM ORIGIN TO AIRCRAFT
C 
       XLAT=.5*(RLAT+OLAT)*DTR
       DX=(RLON-OLON)*DTR*REARTH*COS(XLAT)
C
C      DY=NORTH-SOUTH DISTANCE FROM ORIGIN TO AIRCRAFT
C 
       DY=(RLAT-OLAT)*DTR*REARTH
C
C      (X,Y,Z)R=DISTANCE OF DATUM FROM LOWER LEFT CORNER
C 
       XR(I)=DELX+DX-XSHIFT
       YR(I)=DELY+DY-YSHIFT
       ZR(I)=HEIGHT
C 
      ENDDO
      CONTINUE
C 
      RETURN
      END
C
C  *********************************************************************
C 
      SUBROUTINE find_ground(rdtai,deg2rad,beam_wid,rs_th,rs_m, 
     + dBz_max,ibeg,Ng2,ibst)
C
C     SUBROUTINE CALLED BY SWEEPIN (NEWSWEEPREAD_AUTO_FIRST_DISC_DEFRECKLE.F)
C       
C ... FUNCTION:   
C       
C     THIS SUBROUTINE FINDS THE SURFACE FROM A GIVEN RAY, AS IN TESTUD'S
C     MEMO.
C
C ... FIND_GROUND SUBPROGRAM REFERENCES: NONE
C     
C     VERSION:  <TBD>
C       
C     CODE WRITTEN BY:  JOHN GAMACHE   
C                       HRD/AOML/NOAA          
C                       MIAMI, FL 33149      
C       
C     FOR ADDITIONAL DETAILS ON THE ALGORITHM SEE <TBD>
C       
C     BASED ON THEORY BY:  <TBD>
C       
C     REFERENCE THE BOOK:  <TBD>
C       
C     **************************************************  
C     *               IMPORTANT NOTE                   *  
C     *                                                *  
C     *                    <TBD>                       *  
C     *                                                *  
C     **************************************************         
C
C     SPECIFICATIONS FOR ARGUMENTS
C    
      COMMON /TAPEHEADER/ nbytesheader,ntape,nversion,ihheader,imheader,
     +                    isheader,ine,ndrive,naircraft,flightid,stmname
     +                    ,nsamplelf,nsampleta,refslopelf,refslopeta,
     +                    refnoisethreslf,refnoisethresta,sqilf,sqita,
     +                    widththreslf,widththresta,caliblf,calibta,
     +                    modedatalf,modedatata,noisetmlf,noisetmta,
     +                    rpmlf,rpmta,gtlnlf,ivrangelf,ivrangeta,
     +                    gtlnta(3),rdellf,rdelta,rdelcorlf,rdelcorta,
     +                    nbinlf,nbinta,nbins,rmaxlf,rmaxta,
     +                    radiita(512),radiilf(512),prf_flaglf,
     +                    prf_flagta,prf_highlf,prf_highta,xniqlf,
     +                    xniqta,iheader(1024)
C 
      COMMON /RAYHEADER / nbytesdata,nlfsweep,ntasweep,numrecord,
     +                    irecflag,idradar,nbytesray,icode,idsp,mdata,
     +                    iyear,month,iday,iraycode,time,ih,im,
     +                    is,is100,rlat,rlon,ra,gse,gsn,gs,vgs,
     +                    ucom,vcom,wd,ws,vws,ircu,
     +                    elev,azm,pitch,roll,drift,heading,
     +                    dbzbuffer(512),velbuffer(512),widthbuffer(512)
      CHARACTER FLIGHTID*8,STMNAME*16
      integer*2 iheader
      real lambda
      real rdtai(512)
C
C ... DESCRIPTION OF ARGUMENTS
C

C
C     SPECIFICATIONS FOR LOCAL VARIABLES
C

C 
C     THETA IS TILT RELATIVE TO THE PLANE PERP. TO RADAR AXIS
C 
      theta = elev * deg2rad 
      beta = pitch * deg2rad
C 
C     IN TESTUD'S FORM, 0 IS DOWN, -90 PORT, 90 STARBORARD
C 
      phi = (180 - (azm + roll) ) * deg2rad 
      epsilon = beam_wid * deg2rad
C 
C     NOW GET ELEVATION OF BEAM RELATIVE TO HORIZ PLANE THROUGH RADAR 
C 
      sn_lambda = sin(theta) * sin(beta) - 
     *		  cos(theta) * cos(beta) * cos(phi)
      lambda = asin(sn_lambda)
C 
C     FIND THEORETICAL RANGE OF SURFACE (- SIGN BECAUSE LAMBDA NEGATIVE)
C 
      rs_th = -ra / sn_lambda ! RA IN M, RADITTA IN KM
C 
C     FIND # OF GATES INTERSECTING SURFACE AT THEORETICAL RANGE
C     THIS WOULD BE THE FORMULA IF DR WAS CONSTANT:
C	Ng = rs_th * epsilon / (dR * tan(lambda))
C     BUT WE MAY HAVE VARYING BEAMWIDTHS. SO (MOD DEC 8 92):
C 
      rs_th_in = -ra / sin(lambda - epsilon * 0.75) * 0.001
      rs_th_out = -ra / sin(lambda + epsilon * 0.75) * 0.001
      rs_km = rs_th * 0.001
      in = -1
      iout = -1
      do i = 1, 512
	 if( radiita(i) .gt. 0.0 )then
	   if(radiita(i) .lt. rs_th_in) in = i
	   if(radiita(i) .le. rs_th_out) iout = i
	   if(radiita(i) .le. rs_km) Nr = i
	 end if
      end do
      if(in .eq. -1.or.iout.eq.-1)then
	write(6,*)' find_ground failure!'
	write(6,*)' ra:',ra
	write(6,*)'azm, phi: ', azm, phi
	write(6,*)'pitch, drift, roll: ',pitch, drift, roll
	write(6,*)'el, sin(lambda), lambda:',elev, 
     +		sn_lambda, lambda
	write(6,*)'rs_th_in, rs_th_out, rs_km:'
	write(6,*)rs_th_in, rs_th_out, rs_km
	write(6,*)' find_gs in, iout, Nr: ',in, iout, Nr
	ibeg = -1
	return
      end if
      Ng = iout - in + 1
      Ng2 = Ng
      if (Ng2 .eq. 0) Ng2 = 1
C
C     CHANGED RADIUS OF CHECK TO 30 BINS = 2.25 KM, BECAUSE OF
C     HUGE RANGE DELAYS IN ANDREW 8 DEC 92. THEN SEARCH THE GATES
C     WITHIN +- 30 OF GATE AT THEORETICAL RANGE TO FIND THE SWATH
C     NG/2 WIDE WITH GREATEST TOTAL ZE. RETURN BOUNDING BINS.
C 
      dBz_max = -1.0
      ibeg = -1
      if(ng2.gt.30)then
        n30=ng2
      else
        n30=30
      endif
      ist = max(1, Nr - n30)
      ien = min(512-Ng2, Nr + n30 -Ng2)
      do i = ist, ien
	 dBzsum = 0.0
	 do j = i, i + Ng2
            if(j.gt.ibst.and.dbzbuffer(j).gt.-32.)then
 		dBzsum = dBzsum + dbzbuffer(j)
            endif
	 end do
	 if( dBzsum .gt. dBz_max)then
             dBz_max = dBzsum
	   ibeg = i
	 end if
      end do
      iradius = ibeg + Ng2 * 0.5
      if( iradius .le.0) iradius = 1
      if( iradius .gt.512) iradius = 512
      rs_m = radiita( iradius ) * 1000.0
C 
      return
      end


