      SUBROUTINE DIFFOBLONG3D(IB,JB,KB,XDIFFMAX,YDIFFMAX,ZDIFFMAX,
     + SX,SY,SZ,SXB,SYB,SZB,XZ,YZ,ZZ,
     + XZB,YZB,ZZB,IMAX,JMAX,KMAX,
     + IMN,IMX,JMN,JMX,KMN,KMX,ROT,ROTB)
      X=(FLOAT(IB)-.5)*SXB-XZB
      Y=(FLOAT(JB)-.5)*SYB-YZB
c      write(6,*)'ib,jb,kb,x,y,rotb = ',ib,jb,kb,x,y,rotb
      CALL ROTATE(X,Y,XEARTH,YEARTH,ROTB)
      X=XEARTH
      Y=YEARTH
      Z=(KB-1)*SZB+ZZB
      XMINREL=X-XDIFFMAX
      YMINREL=Y-YDIFFMAX
      ZMINREL=Z-ZDIFFMAX
      XMAXREL=X+XDIFFMAX
      YMAXREL=Y+YDIFFMAX
      ZMAXREL=Z+ZDIFFMAX
c      write(6,*)'xminrel,yminrel = ',xminrel,yminrel
      CALL ROTATE(XMINREL,YMINREL,X1,Y1,-ROT)
c      write(6,*)'xmaxrel,yminrel = ',xmaxrel,yminrel
      CALL ROTATE(XMAXREL,YMINREL,X2,Y2,-ROT)
c      write(6,*)'xminre1,ymaxrel = ',xminrel,ymaxrel
      CALL ROTATE(XMINREL,YMAXREL,X3,Y3,-ROT)
c      write(6,*)'xmaxre1,ymaxrel = ',xminrel,ymaxrel
      CALL ROTATE(XMAXREL,YMAXREL,X4,Y4,-ROT)
      XMAXREL=X1
      XMINREL=X1
      IF(X2.GT.XMAXREL)XMAXREL=X2
      IF(X3.GT.XMAXREL)XMAXREL=X3
      IF(X4.GT.XMAXREL)XMAXREL=X4
      IF(X2.LT.XMINREL)XMINREL=X2
      IF(X3.LT.XMINREL)XMINREL=X3      
      IF(X4.LT.XMINREL)XMINREL=X4
      YMAXREL=Y1
      YMINREL=Y1
      IF(Y2.GT.YMAXREL)YMAXREL=Y2
      IF(Y3.GT.YMAXREL)YMAXREL=Y3
      IF(Y4.GT.YMAXREL)YMAXREL=Y4
      IF(Y2.LT.YMINREL)YMINREL=Y2
      IF(Y3.LT.YMINREL)YMINREL=Y3      
      IF(Y4.LT.YMINREL)YMINREL=Y4
      IMN=INT((XMINREL+XZ)/SX+.5)
      JMN=INT((YMINREL+YZ)/SY+.5)
      KMN=1+INT((ZMINREL-ZZ)/SZ)
      IF(IMN.LT.1)IMN=1
      IF(JMN.LT.1)JMN=1
      IF(KMN.LT.1)KMN=1
      IF(IMX.LT.1)IMX=0
      IF(JMX.LT.1)JMX=0
      IF(KMX.LT.1)KMX=0
      IMX=INT((XMAXREL+XZ)/SX+.5)
      JMX=INT((YMAXREL+YZ)/SY+.5)
      KMX=1+INT((ZMAXREL-ZZ)/SZ)
      IF(IMX.GT.IMAX)IMX=IMAX
      IF(JMX.GT.JMAX)JMX=JMAX
      IF(KMX.GT.KMAX)KMX=KMAX
      IF(IMN.GT.IMAX)IMN=IMAX+1
      IF(JMN.GT.JMAX)JMN=JMAX+1
      IF(KMN.GT.KMAX)KMN=KMAX+1
      RETURN
      END
      SUBROUTINE DIFFOBLONG(XIN,YIN,Z,XDIFFMAX,YDIFFMAX,ZDIFFMAX,
     + SXB,SYB,SZB,
     + XZB,YZB,ZZB,IMAXB,JMAXB,KMAXB,
     + IMN,IMX,JMN,JMX,KMN,KMX,ROTB)
      CALL ROTATE(XIN,YIN,XB,YB,-ROTB)
      X=XB
      Y=YB
      XMINREL=X-XDIFFMAX
      YMINREL=Y-YDIFFMAX
      ZMINREL=Z-ZDIFFMAX
      XMAXREL=X+XDIFFMAX
      YMAXREL=Y+YDIFFMAX
      ZMAXREL=Z+ZDIFFMAX
      IMN=INT((XMINREL+XZB)/SXB+.5)
      JMN=INT((YMINREL+YZB)/SYB+.5)
      KMN=1+INT((ZMINREL-ZZB)/SZB)
      IF(IMN.LT.1)IMN=1
      IF(JMN.LT.1)JMN=1
      IF(KMN.LT.1)KMN=1
      IF(IMX.LT.1)IMX=0
      IF(JMX.LT.1)JMX=0
      IF(KMX.LT.1)KMX=0
      IMX=INT((XMAXREL+XZB)/SXB+.5)
      JMX=INT((YMAXREL+YZB)/SYB+.5)
      KMX=1+INT((ZMAXREL-ZZB)/SZB)
      IF(IMX.GT.IMAXB)IMX=IMAXB
      IF(JMX.GT.JMAXB)JMX=JMAXB
      IF(KMX.GT.KMAXB)KMX=KMAXB
      IF(IMN.GT.IMAXB)IMN=IMAXB+1
      IF(JMN.GT.JMAXB)JMN=JMAXB+1
      IF(KMN.GT.KMAXB)KMN=KMAXB+1
      RETURN
      END
      SUBROUTINE ROTATE(X,Y,XROT,YROT,ROT)
      ROTD=3.14159/180.*ROT
      XROT=X*COS(ROTD)+Y*SIN(ROTD)
      YROT=-X*SIN(ROTD)+Y*COS(ROTD)
      RETURN
      END
      SUBROUTINE DIFFDIST3D(I,J,K,IB,JB,KB,INEAR,JNEAR,KNEAR,
     + SX,SY,SZ,SXB,SYB,SZB,XZ,YZ,ZZ,
     + XZB,YZB,ZZB,DISTX,DISTY,DISTZ,ROT,ROTB)
      ROTD=3.14159/180.*ROT
      ROTBD=3.14159/180.*ROTB
      XB=(FLOAT(IB)-.5)*SXB-XZB
      YB=(FLOAT(JB)-.5)*SYB-YZB
      ZB=(KB-1)*SZB+ZZB
      XROT=COS(ROTBD)*XB+SIN(ROTBD)*YB
      YROT=-SIN(ROTBD)*XB+COS(ROTBD)*YB
      XB=XROT
      YB=YROT
      XBROT=COS(ROTD)*XB-SIN(ROTD)*YB
      YBROT=SIN(ROTD)*XB+COS(ROTD)*YB
      X=(FLOAT(I)-.5)*SX-XZ
      Y=(FLOAT(J)-.5)*SY-YZ
      XROT=COS(ROTD)*X+SIN(ROTD)*Y
      YROT=-SIN(ROTD)*X+COS(ROTD)*Y
      X=XROT
      Y=YROT
      Z=(K-1)*SZ+ZZ
      INEAR=1+INT((XBROT+XZ)/SX)
      JNEAR=1+INT((YBROT+YZ)/SY)
      KNEAR=1+INT((Z-ZZ)/SZ)
      DISTX=X-XB
      DISTY=Y-YB
      DISTZ=Z-ZB
      RETURN
      END
      SUBROUTINE DIFFDIST(X,Y,Z,IB,JB,KB,INEAR,JNEAR,KNEAR,
     + SXB,SYB,SZB,
     + XZB,YZB,ZZB,DISTX,DISTY,DISTZ,ROTB)
      ROTBD=-3.14159/180.*ROTB
      A=COS(ROTBD)
      B=SIN(ROTBD)
C      WRITE(100,*)'ROTB,ROTBD,COS,SIN = ',ROTB,ROTBD,A,B
      XBROT=A*X+B*Y
      YBROT=-B*X+A*Y
C      XBROT=COS(ROTBD)*X+SIN(ROTBD)*Y
C      YBROT=-SIN(ROTBD)*X+COS(ROTBD)*Y
C      WRITE(100,*)'X,Y,XBROT,YBROT = ',X,Y,XBROT,YBROT
      ZBROT=(KB-1)*SZB+ZZB
      XB=(FLOAT(IB)-.5)*SXB-XZB
      YB=(FLOAT(JB)-.5)*SYB-YZB
      ZB=(FLOAT(KB)-1)*SZB+ZZB
      INEAR=1+INT((XBROT+XZB)/SXB)
      JNEAR=1+INT((YBROT+YZB)/SYB)
      KNEAR=1+INT((Z-ZZB)/SZB)
      DISTX=XB-XBROT
      DISTY=YB-YBROT
      DISTZ=Z-ZBROT
C      WRITE(100,*)'IB,JB,KB,XB,YB,ZB = ',IB,JB,KB,XB,YB,ZB
C      WRITE(100,*)'XBROT,YBROT,ZBROT = ',XBROT,YBROT,ZBROT
      RETURN
      END
      SUBROUTINE ZEROW(DIV,W,IMAXB,JMAXB,KMAXB)
      REAL DIV(IMAXB,JMAXB,KMAXB),W(IMAXB,JMAXB,KMAXB)
      FLAG=-1.0E+10
      DO K=1,KMAXB
       DO J=1,JMAXB
        DO I=1,KMAXB
         W(I,J,K)=FLAG
         DIV(I,J,K)=FLAG
        ENDDO
       ENDDO
      ENDDO
      RETURN
      END
      SUBROUTINE DIVER(U,V,DIV,IMAX,JMAX,KMAX,SX,SY)
      REAL U(IMAX,JMAX,KMAX),V(IMAX,JMAX,KMAX),DIV(IMAX,JMAX,KMAX)
      FLAG=-1.0E+10
      DO 1 K=1,KMAX                                                             
c        WRITE(6,'("- computing divergence for plane #",i3)') K  
        DO 2 J=1,JMAX                                                           
          DO 3 I=1,IMAX                                                         
            DIV(I,J,K)=FLAG
            SCALX=SX*2000.0      !TWICE THE RES IN M                            
            SCALY=SY*2000.0      !TWICE THE RES IN M                            
            IF(I.EQ.1) THEN                                                     
              U1=U(I,J,K)
              SCALX=SCALX*.5                                                    
            ELSE                                                                
              U1=U(I-1,J,K)
            ENDIF                                                               
            IF(I.EQ.IMAX) THEN                                                  
              U2=U(I,J,K)
              SCALX=SCALX*.5                                                    
            ELSE                                                                
              U2=U(I+1,J,K)
            ENDIF                                                               
            IF(J.EQ.1) THEN                                                     
              V1=V(I,J,K)
              SCALY=SCALY*.5                                                    
            ELSE                                                                
              V1=V(I,J-1,K)
            ENDIF                                                               
            IF(J.EQ.JMAX) THEN                                                  
              V2=V(I,J,K)
              SCALY=SCALY*.5                                                    
            ELSE                                                                
              V2=V(I,J+1,K)
            ENDIF                                                               
            IF(U1.GT.FLAG.AND.U2.GT.FLAG.AND.                                 
     1       V1.GT.FLAG.AND.V2.GT.FLAG)THEN                                   
             DIV(I,J,K)=(U2-U1)/SCALX + (V2-V1)/SCALY
             IF (ABS(DIV(I,J,K)).GT.0.32767) 
     1         DIV(I,J,K)=SIGN(0.32767,DIV(I,J,K))  
            ELSE                                                                
             DIV(I,J,K)=FLAG
            ENDIF                                                               
C            IF(IDATA(5,I,J,K).GE.32767)
C     1       write(6,*)'I,J,K,V1,V2,U1,U2',I,J,K,V1,V2,U1,U2
3           CONTINUE                                                            
2         CONTINUE                                                              
1       CONTINUE                                                                
      RETURN                                                                    
      END                                                                       
      FUNCTION VTERM_NEW(Z,H,hb,dpb,IRSW,ZLOW,ZHIGH) 
C Terminal velocity from dBZ and height 
C This function computes mean terminal velocity from the reflectivity 
C according to Paul Willis' 2-parameter gamma distribution and
C a snow relationship developed by Atlas et al. (1973)
C Reflectivity, in terms of dBZ, must be passed to this routine.
C HEIGHT MUST BE IN KM
c irsw - 0 Joss and Waldvogel; >0 Willis Gamma
C hb is the height of the bright band, and dpb is the depth of the bright 
C   band both in km 
C 
      ZZ=10.0**(Z*0.1)
      hlow= hb - dpb * .5 
      hhi= hlow + dpb 
C density correction term (rhoo/rho)*0.45 [rho(Z)=rhoo exp-(z/H), where 
C  H is the scale height = 9.58125 from Gray's inner 2 deg composite] 
C 0.45 density correction from Beard (1985, JOAT pp 468-471)
      DCOR=EXP(0.45*H*.10437052)
C The snow relationship (Atlas et al., 1973) --- VT=0.817*Z**0.063  (m/s) 
      VTS=-DCOR * (0.817*ZZ**0.063) 
      if(irsw.gt.0) then
C The rain relationship --- from Willis analytical-gamma distribution 
         TERM1=7.331/ZZ**0.010022 
         TERM2=0.14034*ZZ**0.095238 
         VTR=-DCOR * (5.5011E+09/(TERM1+TERM2)**10.5) 
      else
C The rain relationship (Joss and Waldvogel,1971) --- VT=2.6*Z**.107 (m/s)
         VTR=-DCOR * (2.6*ZZ**.107) 
      endif 
C test if height is in the transition region between SNOW and RAIN
C  defined as hlow in km < H < hhi in km
C  if in the transition region do a linear weight of VTR and VTS
      IF(Z.GT.ZLOW.AND.Z.LE.ZHIGH)THEN
       WEIGHTR=(Z-ZLOW)/(ZHIGH-ZLOW)
       WEIGHTS=1.-WEIGHTR
       VTS=(VTR*WEIGHTR+VTS*WEIGHTS)/(WEIGHTR+WEIGHTS)
      ELSEIF(Z.GT.ZHIGH)THEN
       VTS=VTR
      ENDIF
      VTERM_NEW=VTR*(hhi-H)/dpb + VTS*(H-hlow)/dpb  
      IF(H.LT.hlow) VTERM_NEW=VTR 
      IF(H.GT.hhi) VTERM_NEW=VTS
      RETURN
      END 
      FUNCTION VTERM(Z,H,hb,dpb,IRSW) 
C Terminal velocity from dBZ and height 
C This function computes mean terminal velocity from the reflectivity 
C according to Paul Willis' 2-parameter gamma distribution and
C a snow relationship developed by Atlas et al. (1973)
C Reflectivity, in terms of dBZ, must be passed to this routine.
C HEIGHT MUST BE IN KM
c irsw - 0 Joss and Waldvogel; >0 Willis Gamma
C hb is the height of the bright band, and dpb is the depth of the bright 
C   band both in km 
C 
      ZZ=10.0**(Z*0.1)
      hlow= hb - dpb * .5 
      hhi= hlow + dpb 
C density correction term (rhoo/rho)*0.45 [rho(Z)=rhoo exp-(z/H), where 
C  H is the scale height = 9.58125 from Gray's inner 2 deg composite] 
C 0.45 density correction from Beard (1985, JOAT pp 468-471)
      DCOR=EXP(0.45*H*.10437052)
C The snow relationship (Atlas et al., 1973) --- VT=0.817*Z**0.063  (m/s) 
      VTS=-DCOR * (0.817*ZZ**0.063) 
      if(irsw.gt.0) then
C The rain relationship --- from Willis analytical-gamma distribution 
         TERM1=7.331/ZZ**0.010022 
         TERM2=0.14034*ZZ**0.095238 
         VTR=-DCOR * (5.5011E+09/(TERM1+TERM2)**10.5) 
      else
C The rain relationship (Joss and Waldvogel,1971) --- VT=2.6*Z**.107 (m/s)
         VTR=-DCOR * (2.6*ZZ**.107) 
      endif 
C test if height is in the transition region between SNOW and RAIN
C  defined as hlow in km < H < hhi in km
C  if in the transition region do a linear weight of VTR and VTS
      VTERM=VTR*(hhi-H)/dpb + VTS*(H-hlow)/dpb  
      IF(H.LT.hlow) VTERM=VTR 
      IF(H.GT.hhi) VTERM=VTS
      RETURN
      END 
      SUBROUTINE DVDOT(XMAG,X,N1,Y,N2,IPOS)
      DOUBLE PRECISION XMAG,X(IPOS),Y(IPOS)
      XMAG=0.
      NN1=N1-1
      NN2=N2-1
      DO I=1,IPOS
       XMAG=XMAG+X(NN1+I)*Y(NN2+I)
      ENDDO
      RETURN
      END       
C      SUBROUTINE DVSUB(B,I1,C,I2,R,I3,IPOS)
C      DOUBLE PRECISION B(IPOS),C(IPOS),R(IPOS)
C      DO I=1,IPOS
C       R(I)=B(I)-C(I)
C      ENDDO
C      RETURN
C      END
      SUBROUTINE DVMOV(R,I1,P,I2,IPOS)
      DOUBLE PRECISION R(IPOS),P(IPOS)
      DO I=1,IPOS
       P(I)=R(I)
      ENDDO
      RETURN
      END
      SUBROUTINE DVPIV(AI,P,I1,X,I2,Y,I3,IPOS)
      DOUBLE PRECISION AI,P(IPOS),X(IPOS),Y(IPOS)
      DO I=1,IPOS
       Y(I)=X(I)+AI*P(I)
      ENDDO
      RETURN
      END
      FUNCTION RMASSQ(DBZ,HGT,HLOW,HIGH,ZLOW,ZHIGH,RHO)
      AA=259. 
      BB=1.37 
      CC=1./BB
      ZZ=10.**(DBZ/10.)
      ZMI=(ZZ/AA)**CC
      ZMW=1.33E-3*(ZZ**.6905) 
      DML=HIGH-HLOW
c      write(6,*)'rho,dbz,hgt,hlow,high,zlow,zhigh,zz,zmi,zmw = ',
c     1           rho,dbz,hgh,hlow,high,zlow,zhigh,zz,zmi,zmw
      IF(DBZ.GT.ZLOW.AND.DBZ.LE.ZHIGH)THEN
c       write(6,*)'statement 1'
       WEIGHTR=(DBZ-ZLOW)/(ZHIGH-ZLOW)
       WEIGHTS=1.-WEIGHTR
       ZMI=(ZMW*WEIGHTR+ZMI*WEIGHTS)/(WEIGHTR+WEIGHTS)
      ELSEIF(DBZ.GT.ZHIGH)THEN
c       write(6,*)'statement 2'
       ZMI=ZMW
      ENDIF
      IF(HGT.GT.HLOW.AND.HGT.LT.HIGH)THEN
c       write(6,*)'statement 3, dml = ',dml
       ZM=(ZMW*(HIGH-HGT)+ZMI*(HGT-HLOW))/DML 
      ELSEIF(HGT.LE.HLOW)THEN
       ZM=ZMW 
      ELSEIF(HGT.GE.HIGH)THEN
       ZM=ZMI 
      ENDIF
c      write(6,*)'rho = ',rho
      RMASSQ=ZM/RHO
      RETURN
      END 

