      PROGRAM LEASTWIND
C
C     MAIN PROGRAM OF WIND_INTERPOLATE_RT_AUTO_FIRST_DEFRECKLE
C       
C ... FUNCTION:   
C       
C          THIS PROGRAM COMPUTES SUMMATIONS OF PRODUCTS NEEDED FOR THE
C          FIRST LEAST SQUARES WIND SOLUTION. THE GOVERNING EQUATIONS 
C          ARE FORMULATED IN R-THETA-Z COORDINATES RELATIVE TO THE STORM
C          CENTER, AND REPRESENT THE AZIMUTHAL STRUCTURE IN TERMS OF 
C          FOURIER WAVENUMBER 0 AND 1 COMPONENTS.  AIRCRAFT MOTION 
C          REMOVAL, BARGEN-BROWN DEALIASING, DEFRECKLING, AND SURFACE
C          REMOVAL ARE PERFORMED AS PART OF THE QC PROCESS. 
C       
C ... LEASTWIND SUBPROGRAM REFERENCES:      
C       
C          NON-SYSTEM     OPENRAMFILE, ABCD, WRITEABCD
C
C          SYSTEM         GETARG
C 
C ... IMPORTANT FLAGS: <()> INDICATES DEFAULT
C          
C          IGRAPHICS      USE GRAPHICS (0) NO (1) YES
C          COMYES         USE COMMAND FILE (N) NO <(Y)> YES
C          IACROSS        AZI-COVERAGE (0) SECTOR <(1)> FULL
C          IGUESS         USE A GUESS WIND FIELD <(0)> NO (1) YES
C          IREVERSE       REVERSE SIGN OF DOPPLER VR <(0)> NO (1) YES
C          IREADABCD      READ IN SUMFILE <(0)> NO (1) YES
C          IWRITEABCD     WRITE OUT SUMFILE (0) NO <(1)> YES
C          IVSPEED        USE CONST. AZI ADV. <(0)> NO (1) YES
C          IRAMSFILES     USE RAMSFILE <(0)> NO (1) YES
C      
C     VERSION:  <TBD>
C       
C     CODE WRITTEN BY:  JOHN GAMACHE   
C                       HRD/AOML/NOAA          
C                       MIAMI, FL 33149      
C       
C     FOR ADDITIONAL DETAILS ON THE ALGORITHM SEE TBD
C       
C     BASED ON THEORY BY:  <TBD>
C       
C     REFERENCE THE BOOK:  <TBD>
C       
C     **************************************************  
C     *               IMPORTANT NOTE                   *  
C     *                                                *  
C     *                    <TBD>                       *  
C     *                                                *  
C     **************************************************  
C       
C     SPECIFICATIONS FOR LOCAL VARIABLES
C       
C **** HEADER RECORD OF AN HRD-TYPE DOPPLER WIND FILE 
C 
      INTEGER IB,JB,KB,IE,JE,KE,IH,IM,IS
      INTEGER IMAX,JMAX,KMAX
      REAL STIME,ETIME,OLAT,OLON,SX,SY,SZ,XZ,YZ,ZZ,ROT
      REAL SMOTIONU,SMOTIONV
      CHARACTER FLTNAME*8,EXPERIMENT*32
      CHARACTER FILNAM(40)*80
C 
C **** REMAINING 
C 
      INTEGER N,IJK
      INTEGER KMIN2,KMAX2
      INTEGER LUIN,LUOUT,LUSCAN,LUW,NFILE,NF,NFF
      INTEGER IGRAPHICS,IACROSS,IGUESS,IREVERSE,IREADABCD
      INTEGER IWRITEABCD,IVSPEED,IRAMSFILES,IERR
      PARAMETER(N1=200000,N2=800000,N3=600000,N8=1600000)
      REAL TSTART,TEND,SLOPE1,CENTIME
      REAL TSTARTARRAY(40),TENDARRAY(40)
      REAL XSHIFT(80),YSHIFT(80),DBZFACT(80)
      REAL RRMAX,RTMAX,RZMAX,ERMAX,ETMAX,EZMAX
      REAL XACC,YACC,ZACC,PIMAX
      REAL SINTOL,CTR,RFLAG,DATARATE
      REAL DBZTEST,RRRR,VSPEED0,VFACTOR
      REAL SUM1(N1),SUM2(N1),SUM3(N1)
      REAL SUM4(N1),SUM5(N1),SUM6(N1)
      REAL SUM7(N1),SUM8(N1),SUM9(N1)
      REAL SUM10(N1),SUM11(N1),SUM12(N1),SUM13(N1)
      REAL DISTXYZ(N8)
      REAL SUMWTSAVE(N1),SUMDBZ(N1)
      REAL UGUESS(N1),VGUESS(N1),WGUESS(N1)
      REAL VELS(N3)
      CHARACTER TATF(80)*2
      CHARACTER COMYES*1,GRAPHICSYES*1
      CHARACTER OSUMFILENAME(80)*80,RAMSFILES(80)*80
C
C ... DESCRIPTION OF VARIABLES PASSED TO SUBROUTINES
C       
C     RAMSFILES            - RAMSFILE NAME
C     LUOUT                - LOGICAL UNIT NUMBER TO DISPLAY MESSAGES
C     STIME,ETIME          - START,END TIME (S)
C     DATARATE             - FILE DATA RATE
C     IERR                 - ERROR CONDITION FLAG
C     RRMAX,RTMAX,RZMAX    - RADIAL,AZI,VERTICAL SCALE OF INFLUENCE (KM,DEG,KM)
C     ERMAX,ETMAX,EZMAX    - RADIAL,AZI,VERTICAL E-FOLDING DISTANCE (KM,DEG,KM)
C     XACC,YACC,ZACC       - MAX ALLOWED RADIAL,AZI,VERTICAL DIST. BETWEEN AVG. OBS POS. AND GRID POINT
C     NF                   - FILE NO.
C     SUM1-13              - SUMS OF PRODUCTS ACCUMULATED DURING INTERP. PROCESS
C     KMIN2,KMAX2          - TYPICALLY MIN AND MAX VERTICAL LEVEL NO.
C     SINTOL               - SIN OF MAX ALLOWED DOPPLER RADIAL ANGLE FROM HORIZ.
C     SX,SY,SZ             - RADIAL,AZI,VERTICAL GRID SPACING (KM,DEG,KM)
C     XZ,YZ,ZZ             - MIN RADIUS,AZI,HEIGHT (KM,DEG,KM)
C     ROT                  - COORD. ROTATION (ALWAYS ZERO IN CYL COORDS)
C     IMAX,JMAX,KMAX       - RADIAL,AZI,VERTICAL ARRAY DIMENSION
C     SUMDBZ               - WEIGHTED AVG. REFLECTIVITY AT GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN
C     SUMWTSAVE            - ACCUMULATED WEIGHT AT GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN
C     VELS                 - WEIGHTED AVG. R,THETA,Z DIST. BETWEEN DATUM AND GRIDPOINT
C     OLAT,OLON            - LAT,LON OF GRID ORIGIN (STORM CENTER)
C     SLOPE1               - REFLECTIVITY SLOPE CORRECTION FACTOR SET TO ONE
C     CENTIME              - ANALYSIS TIME (S)
C     TSTART,TEND          - SEE STIME,ETIME
C     SMOTIONU,SMOTIONV    - STORM MOTION (M/S)
C     FLTNAME              - FLIGHT NAME
C     DBZTEST              - MIN DBZ TO INCLUDE
C     RRRR                 - MIN RANGE TO INCLUDE 
C     UGUESS,VGUESS,WGUESS - GUESS RADIAL, TANGENTIAL, AND VERTICAL WIND (ZERO, M/S)
C     DISTXYZ              - DISTANCE OF THE CLOSEST OBS THAT WAS INTERP. TO GRID POINT (I,J,K)
C     PIMAX                - MAX AZI ANGLE FOR OBS TO BE INCLUDED IN WT AVG
C     VSPEED0              - CONST. ADV. SPEED USED IN COMPOSITING (M/S)
C     VFACTOR              - FACTOR MULT. WIND SPEED TO USE IN COMPOSITING (M/S)
C     TATF                 - IDENTIFY SCAN TYPE 
C     LUW                  - LOGICAL UNIT NUMBER FOR OUTPUT SUMFILE
C     NFF                  - FORE OR AFT FILE NO.
C    
      LUOUT=6
      LUSCAN=97      
      CTR=3.14159/180.
      RFLAG=-1.0E+10
C 
      OPEN(1,FILE='/dev/null')
C 
C ... INITIALIZE DBZ VECTOR TO FLAGGED VALUE
C 
      DO N=1,N1
       SUMDBZ(N)=RFLAG
      ENDDO
C 
C ... CHECK FOR GRAPHICS OPTION AND SET FLAG
C 
      CALL GETARG(1,GRAPHICSYES)
      IF(GRAPHICSYES.EQ.'G'.OR.GRAPHICSYES.EQ.'g')THEN
       IGRAPHICS=1
      ELSE
       IGRAPHICS=0
      ENDIF
C
C ... READ IN PARAMETERS AND FLAGS
C
C **** COMMAND FILE FLAG AND FILE NAME
C 
      COMYES='Y'
      IF(COMYES.EQ.'Y'.OR.COMYES.EQ.'y')THEN
       LUIN=16
       FILNAM(1)='jobfile_radar_rt'
       OPEN(16,FILE=FILNAM(1),STATUS='OLD')
      ELSE
       LUIN=1
      ENDIF
C
C **** FLIGHT NAME
C 
      READ(LUIN,'(A8)')FLTNAME
      WRITE(6,1501)FLTNAME
1501  FORMAT('FLIGHT ID IS ',A8)
C
C **** EXPERIMENT NAME (32 CHARACTERS OR LESS)
C 
      READ(LUIN,'(A32)')EXPERIMENT
      WRITE(6,1502)EXPERIMENT
1502  FORMAT('EXPERIMENT NAME IS ',A32)
C
C **** NUMBER OF DOP3D FILES
C 
      NFILE=2
      WRITE(6,1503)NFILE
1503  FORMAT('NUMBER OF UF FILES TO BE INTERPOLATED IN THIS RUN '/
     + 'BE ',I3)
      IF(NFILE.GT.40)THEN
       WRITE(6,*)'Too many files'
       STOP
      ENDIF
C
C **** SUMMATION FILE NAMES
C 
      OSUMFILENAME(1)='SUMFILE_aft_rt_auto_first'
      OSUMFILENAME(2)='SUMFILE_fore_rt_auto_first'
C
C **** BEGIN AND END TIMES
C 
      READ(LUIN,'(3I2,X,3I2)')IB,JB,KB,IE,JE,KE
      WRITE(6,1506)NF,IB,JB,KB
1506  FORMAT('BEGINNING TIME FOR FILE NO. ',I3,' WILL BE ',3I2)
      WRITE(6,1507)NF,IE,JE,KE
1507  FORMAT('ENDING TIME FOR FILE NO. ',I3,' WILL BE ',3I2)
      TSTART=IB*3600.+JB*60+KB
      STIME=TSTART
      ETIME=IE*3600.+JE*60.+KE
      IF(ETIME.LT.STIME)THEN
       TEND=ETIME+86400.
      ELSE
       TEND=ETIME
      ENDIF
      WRITE(6,*)'STIME,ETIME,TSTART,TEND = ',
     +            STIME,ETIME,TSTART,TEND 
C
C     SUMMARY LOOP 
C            
      DO NF=1,2
       TATF(NF)='TA'
       TATF(NF)='TF'
       TSTARTARRAY(NF)=TSTART
       TENDARRAY(NF)=TEND
       DBZFACT(NF)=1.
       XSHIFT(NF)=0.
       YSHIFT(NF)=0.
       WRITE(6,1508)NF,OSUMFILENAME(NF)
1508   FORMAT('OUTPUT INTERPOLATION SUMFILE FOR INPUT FILE NO. ',I3/
     + 'WILL BE ',A80)
       WRITE(6,11508)TATF(NF)
11508  FORMAT('SCAN TYPE WILL BE ',A2)
      ENDDO
C
C **** E-W AND N-S STORM MOTION
C 
      READ(LUIN,*)SMOTIONU,SMOTIONV
      WRITE(6,1509)SMOTIONU,SMOTIONV
1509  FORMAT('ADVECTION FOR VELOCITY FOR INTERPOLATION COMPOSITE '/
     + 'WILL BE ',2F8.3,' M/S')
C
C **** COMPOSITE TIME
C 
      READ(LUIN,'(3I2)')IH,IM,IS
      WRITE(6,1510)IH,IM,IS
1510  FORMAT('TIME OF ZERO ADVECTION IN COMPOSITE WILL BE ',3I2)
      CENTIME=IH*3600+IM*60+IS
      IF(CENTIME.LT.STIME.AND.ETIME.GT.86400)CENTIME=CENTIME+86400.
C
C **** LATITUDE AND LONGITUDE OF ORIGIN
C 
      READ(LUIN,*)OLAT,OLON
      WRITE(6,1511)IH,IM,IS,OLAT,OLON
1511  FORMAT('LATITUDE AND LONGITUDE OF ORIGIN AT TIME ',3I2/
     + 'WILL BE ',2F8.3)
C
C **** RADIAL, AZIMUTHAL, AND VERTICAL RESOLUTIONS
C 
      READ(LUIN,*)SX,SY,SZ
      WRITE(6,1512)SX,SY,SZ
1512  FORMAT('RADIAL-, AZIMUTHAL-, AND VERTICAL-DIRECTION GRID '/
     + 'RESOLUTIONS ARE ',F6.2,' KM, ',F6.2,' DEGREES, AND '/
     + F6.2,' KM, RESPECTIVELY')
C
C **** MINIMUM RADIUS FROM STORM CENTER, MINIMUM AZIMUTH CCW FROM
C **** EAST, AND LOWEST HEIGHT
C 
      READ(LUIN,*)XZ,YZ,ZZ
C 
C     ROTATION IS SET TO ZERO SINCE CYLINDRICAL COORDINATES
C 
      ROT=0.
      WRITE(6,1513)XZ
1513  FORMAT('MINIMUM RADIUS FROM STORM CENTER WILL BE ',F8.3)
      WRITE(6,1514)YZ
1514  FORMAT('MINIMUM AZIMUTH COUNTERCLOCKWISE FROM EAST WILL BE ',
     + F8.3,' DEGREES')
      WRITE(6,1515)ZZ
1515  FORMAT('HEIGHT OF LEVEL 1 WILL BE ',F8.3,' KM')
C
C **** RADIAL, AZIMUTHAL, AND VERTICAL DIMENSIONS
C 
      READ(LUIN,*)IMAX,JMAX,KMAX
      WRITE(6,1516)IMAX,JMAX,KMAX
1516  FORMAT('RADIAL, AZIMUTHAL, AND VERTICAL DIMENSIONS OF ARRAYS '/
     + 'WILL BE ',3I4)
      DO IJK=1,10
       READ(LUIN,*)DUMMYIJK
      ENDDO
      READ(LUIN,*)HB2,DPB2
      READ(LUIN,*)ZLOW,ZHIGH
C
C **** RADIAL, AZIMUTHAL, AND VERTICAL RADII (KM) OF INFLUENCE
C 
      RRMAX=2.*SX
      RTMAX=3.*SY
      RZMAX=2.*SZ
      WRITE(6,1517)RRMAX,RTMAX,RZMAX
1517  FORMAT('RADIAL, AZIMUTHAL, AND VERTICAL RADII (KM) OF '/
     + 'INFLUENCE OF DOPPLER DATA WILL BE ',3F8.2)
C
C **** RADIAL, AZIMUTHAL, AND VERTICAL E-FOLDING DISTANCE
C 
      ERMAX=SX
      ETMAX=SY
      EZMAX=SZ
      WRITE(6,1518)ERMAX,ETMAX,EZMAX
1518  FORMAT('RADIAL, AZIMUTHAL, AND VERTICAL E-FOLDING DISTANCE '/
     + 'FOR GAUSSIAN INTERPOLATION WILL BE ',3F8.2,' KM')
C
C **** MAXIMUM ALLOWABLE RADIAL, AZIMUTHAL, AND VERTICAL DISPLACEMENT 
C **** OF WEIGHTED AVERAGE POSITION OF OBSERVATIONS FROM NOMINAL GRID 
C **** POSITION
C 
      XACC=99.
      YACC=99.
      ZACC=99.
C
C **** MAXIMUM AZIMUTHAL DISTANCE (IN DEGREES) THAT AN OBSERVATION 
C **** CAN BE FROM A GRID POINT AND BE INCLUDED IN THE WEIGHTED AVERAGE
C 
      PIMAX=45.
      WRITE(6,1520)PIMAX
1520  FORMAT('MAXIMUM AZIMUTHAL DISTANCE (IN DEGREES) '/
     + ' THAT AN OBSERVATION CAN BE FROM A GRID POINT AND BE '/
     + ' INCLUDED IN THE WEIGHTED AVERAGE WILL BE ',F8.2)
C
C **** AZIMUTHAL COVERAGE FLAG
C 
      IACROSS=1
      IF(IACROSS.EQ.1)THEN
C
C     AZIMUTHS START BEFORE AZI=0 AND EXTEND BEYOND AZI=0, OR FULL 360
C 
       WRITE(6,*)'J=1 AND J=JMAX WILL BE CONSIDERED ADJACENT'
      ELSE
C
C     WEDGE STARTS AT AZI>0 AND ENDS AT AZI<360 
C 
       WRITE(6,*)'J=1 AND J=JMAX WILL NOT BE CONSIDERED ADJACENT ',
     + '(SECTOR ONLY)'
      ENDIF
C
C **** ALLOWS A DIFFERENT NUMBER OF LEVELS BETWEEN SYNTHESIS AND 
C **** ORIGINAL INTERPLOATION (LEGACY)
C 
      KMIN2=1
      KMAX2=KMAX
      WRITE(6,1521)KMIN2,KMAX2
1521  FORMAT('MINIMUM AND MAXIMUM LEVELS OF INTERPOLATION FILE ',
     + 'TO BE FILLED ARE ',2I4)
C
C **** SET MAXIMUM ANGLE OF DOPPLER RADIAL RELATIVE TO HORIZONTAL 
C **** (EARTH-RELATIVE ELEVATION ANGLE) TO BE ACCEPTABLE FOR 
C **** INTERPOLATION (THEN TAKE SIN)
C 
      SINTOL=90.
      WRITE(6,1522)SINTOL
1522  FORMAT('MAXIMUM ANGLE OF DOPPLER RADIAL RELATIVE TO '/
     + 'HORIZONTAL (EARTH-RELATIVE ELEVATION ANGLE) TO BE '/
     + 'ACCEPTABLE FOR INTERPOLATION WILL BE ',F8.2,' DEGREES')
      IF(SINTOL.GE.90.)THEN
       SINTOL=1.
      ELSE
       SINTOL=SINTOL*CTR
       SINTOL=SIN(SINTOL)
      ENDIF
C
C **** MINIMUM DBZ AND RANGE TO INCLUDE
C 
      DBZTEST=-2000.
      RRRR=10.
C
C **** AZIMUTHAL ADVECTION FLAG AND SPEED FOR COMPOSITE
C 
      IGUESS=0
C 
      IVSPEED=0
      IF(IVSPEED.EQ.1)THEN
       WRITE(6,*)'Enter advection speed'
       READ(1,*)VSPEED0
       VFACTOR=1.
      ELSE
       IF(IGUESS.EQ.5)THEN
        WRITE(6,*)'Enter factor to multiply wind speed by for advection'
        READ(1,*)VFACTOR
       ELSE
        VFACTOR=0.
       ENDIF
       IVSPEED=0
      ENDIF
C
C **** RAMSFILE FLAG AND FILE NAME
C 
      IRAMSFILES=0
      IF(IRAMSFILES.EQ.1)THEN
       DO NF=1,NFILE
        READ(LUIN,'(A80)')RAMSFILES(NF)
        WRITE(6,1530)NF,RAMSFILES(NF)
1530    FORMAT('RAMS FILE FOR UF FILE NO. ',I3,' WILL BE: '/A80)
       ENDDO
      ENDIF
C
C ... INITIALIZE LEGACY VARIABLE
C 
      DO IJK=1,N1
       UGUESS(IJK)=0.
       VGUESS(IJK)=0.
       WGUESS(IJK)=0.
      ENDDO
C
C     ONLY ONE INPUT FILE WHEN WORKING WITH REAL TIME DATA STREAM 
C 
      NF=1
      write(6,*)'at the beginning of nfile do loop nf = ',nf
C
C ... ABCD READS SCAN FILE NO. NF, SUMS EFFECTS FROM PRESENT WIND FILE, 
C     AND COMPUTES WINDS IF LAST FILE IN ITERATION 
C 
      WRITE(6,*)'CALLING ABCD'
C 
      IF(IRAMSFILES.EQ.1)THEN
       CALL OPENRAMFILE(RAMSFILES(NF),LUOUT,STIME,ETIME,DATARATE,IERR)
      ENDIF
C 
      TSTART=TSTARTARRAY(NF)
      TEND=TENDARRAY(NF)
      SLOPE1=DBZFACT(NF)
C 
      IREVERSE=0
      IREADABCD=0
C 
      CALL ABCD
     1   (RRMAX,RTMAX,RZMAX,ERMAX,ETMAX,EZMAX,XACC,YACC,ZACC,NF,
     2   SUM1,SUM2,SUM3,SUM4,SUM5,SUM6,SUM7,SUM8,SUM9,
     2   SUM10,SUM11,SUM12,SUM13,
     3   KMIN2,KMAX2,
     4   SINTOL,SX,SY,SZ,XZ,YZ,ZZ,ROT,IMAX,JMAX,KMAX,SUMDBZ,
     6   SUMWTSAVE,VELS(1),VELS(1+N1),VELS(1+2*N1),
     6   IGUESS,
     7   IREADABCD,OLAT,OLON,
     9   SLOPE1,CENTIME,TSTART,TEND,
     1   SMOTIONU,SMOTIONV,FLTNAME,DBZTEST,RRRR,
     1   UGUESS,VGUESS,WGUESS,IREVERSE,IRAMSFILES,
     1   DISTXYZ,PIMAX,IACROSS,IVSPEED,VSPEED0,VFACTOR,TATF,IGRAPHICS,
     1   ZLOW,ZHIGH,HB2,DPB2)
C
C ... CLOSE FILE OPENED IN SUBROUTINE ABCD
C 
      CLOSE(98)
C 
      IWRITEABCD=1 
C 
      IF(IWRITEABCD.EQ.1)THEN
C
C      LUW IS THE LOGICAL UNIT NUMBER FOR OUTPUT SUMFILE. FILE IS OPENED
C      IN MAIN PROGRAM BUT CLOSED IN A SUBROUTINE
C 
       LUW=95
       NFF=1
       OPEN(LUW,FILE=OSUMFILENAME(NFF),FORM='UNFORMATTED')
C
C .... WRITEABCD WRITES OUT THE SUMMATIONS OF PRODUCTS THAT ARE NEEDED FOR
C      THE LEAST SQUARES WIND SOLUTION IN THE SYNTHESIS PROGRAMS
C 
       CALL WRITEABCD(LUW,IMAX,JMAX,KMAX,SUM1,SUM2,SUM3,
     +   SUM4,SUM5,SUM6,SUM7,SUM8,SUM9,SUM10,SUM11,SUM12,SUM13,SUMDBZ,
     +   VELS(1),VELS(N1+1),VELS(2*N1+1),NFF)
       write(6,*)'ended writeabcd for file ',nf
C
C      APPARENTLY FILE LUW IS CLOSED IN WRITEABCD
C 
       NFF=2
       OPEN(LUW,FILE=OSUMFILENAME(NFF),FORM='UNFORMATTED')
       CALL WRITEABCD(LUW,IMAX,JMAX,KMAX,SUM1,SUM2,SUM3,
     +   SUM4,SUM5,SUM6,SUM7,SUM8,SUM9,SUM10,SUM11,SUM12,SUM13,SUMDBZ,
     +   VELS(1),VELS(N1+1),VELS(2*N1+1),NFF)
       write(6,*)'ended writeabcd for file ',nf
      ENDIF
      STOP
      END
