      SUBROUTINE ABCD
     1   (RRMAX,RTMAX,RZMAX,ERMAX,ETMAX,EZMAX,XACC,YACC,ZACC,NF,
     2   SUM1,SUM2,SUM3,SUM4,SUM5,SUM6,SUM7,SUM8,SUM9,
     2   SUM10,SUM11,SUM12,SUM13,
     3   KMIN2,KMAX2,
     4   SINTOL,SRB,STHETAB,SZB,RZB,THETAZB,ZZB,ROTB,
     5   IMAXB,JMAXB,KMAXB,SUMDBZ,
     6   SUMWTSAVE,XWSAVE,YWSAVE,ZWSAVE,IGUESS,
     7   IREADABCD,OLAT,OLON,
     9   SLOPE1,CENTIME,TSTART,TEND,
     1   SMOTIONU,SMOTIONV,FLIGHTID,DBZTEST,RRRR,
     1   UGUESS,VGUESS,WGUESS,IREVERSE,IRAMSFILES,
     1   DISTXYZ,PIMAX,IJTEST,IVSPEED,VSPEED0,VFACTOR,TATF,IGRAPHICS,
     1   ZLOW,ZHIGH,HB2,DPB2)
C
C     MAIN SUBROUTINE OF PROGRAM LEASTWIND (DNEWBIGR_ABCDONLY_AUTO_FIRST.F)
C       
C ... FUNCTION:   
C       
C     THIS SUBROUTINE CALLS THE DATA-READING AND QUALITY-CONTROL ROUTINE (SWEEPIN).
C     IT THEN INTERPOLATES THE REQUIRED PRODUCTS OF RADIAL VELOCITY WITH DIRECTION COSINE 
C     AS WELL AS THE PRODUCTS OF SEPARATE DIRECTION COSINES, AND FINALLY SUMS OF RADAR 
C     REFLECTIVITY. ALL BUT THE RADAR REFLECTIVITY SUMS ARE USED IN THE SYNTHESIS METHOD 
C     THAT USES A VARIATIONAL LEAST-SQUARES SOLUTION OF THE WIND FIELD.
C
C     FIRST CONSIDER THE TWO FUNCTIONALS (F_1=FORE,F_2=AFT) CORRESPONDING TO THE 
C     DOPPLER OBSERVATIONS, REPRESENTING THE DIFFERENCE BETWEEN THE ANALYSIS AND 
C     OBSERVATIONS. PROJECTING THE DOPPLER RADIAL VELOCITY ONTO STORM-RELATIVE RADIAL, 
C     TANGENTIAL, AND VERTICAL DIRECTIONS:
C    
C     F_1 = S_M1(S_IJK(DELTA_IJKM1*(VR_M1-ALPHAI_IJKM1*U_IJK-BETAI_IJKM1*V_IJK-GAMMA_M1*(W_IJK-VT_IJK))^2))
C
C     WHERE S_M1 IS SUM OVER ALL FORE DOPPLER OBS FOR GRID POINT (I,J,K) WITHIN SCALE OF INFLUENCE
C           S_IJK IS SUM OVER ALL GRIDPOINTS
C           VR_M1 IS FORE DOPPLER RADIAL VELOCITY OBS M1
C           VT_IJK IS FALL SPEED AT GRIDPOINT IJK
C           U_IJK IS RADIAL VELOCITY AT GRIDPOINT IJK
C           V_IJK IS TANGENTIAL VELOCITY AT GRIDPOINT IJK
C           W_IJK IS VERTICAL VELOCITY AT GRIDPOINT IJK
C
C           DELTA_IJKM1 IS WEIGHT OF FORE DOPPLER OBS M1 AT GRIDPOINT IJK (VARIABLE P)
C                      
C           ALPHA_M1 = SIN(TAU_M1)
C           BETA_M1  = COS(PHI_M1)*COS(TAU_M1)
C           GAMMA_M1 = SIN(PHI_M1)*COS(TAU_M1)
C
C           ALPHAI_IJKM1 = COS(PHI_IJK)*SIN(TAU_M1) + SIN(PHI_IJK)*COS(PHI_M1)*COS(TAU_M1)
C           BETAI_IJKM1  = -SIN(PHI_IJK)*SIN(TAU_M1) + COS(PHI_IJK)*COS(PHI_M1)*COS(TAU_M1)
C
C           WHERE PHI_M1 AND TAU_M1 ARE EARTH-RELATIVE FORE DOPPLER AZIMUTH AND ELEVATION ANGLES, RESPECTIVELY
C                 PHI_IJK IS THE AZIMUTHAL ANGLE OF GRIDPOINT ABOUT THE GRID ORIGIN (X-AXIS IS ZERO)
C
C     THE GRADIENT WRT (U,V,W) IS USED IN THE VARIATIONAL LEAST-SQUARES SOLUTION:
C         
C     DF_1/DU --> 2.0*S_M1(S_IJK(DELTA_IJKM1*(VR_M1-ALPHAI_IJKM1*U_IJK-BETAI_IJKM1*V_IJK-
C                                GAMMA_M1*(W_IJK-VT_IJK))*(-ALPHAI_IJKM1)))
C
C     DF_1/DV --> 2.0*S_M1(S_IJK(DELTA_IJKM1*(VR_M1-ALPHAI_IJKM1*U_IJK-BETAI_IJKM1*V_IJK-
C                                GAMMA_M1*(W_IJK-VT_IJK))*(-BETAI_IJKM1)))
C
C     DF_1/DW --> 2.0*S_M1(S_IJK(DELTA_IJKM1*(VR_M1-ALPHAI_IJKM1*U_IJK-BETAI_IJKM1*V_IJK-
C                                GAMMA_M1*(W_IJK-VT_IJK))*(-GAMMA_M1)))  
C    
C     THE FOLLOWING 9 SUMMATIONS OVER ALL M1 ARE THEN NEEDED:
C
C     (4) DELTA_IJKM1*ALPHAI_IJKM1*VR_M1  
C     (5) DELTA_IJKM1*ALPHAI_IJKM1*ALPHAI_IJKM1
C     (1) DELTA_IJKM1*ALPHAI_IJKM1*BETAI_IJKM1
C     (6) DELTA_IJKM1*ALPHAI_IJKM1*GAMMA_M1
C     (2) DELTA_IJKM1*BETAI_IJKM1*VR_M1
C     (3) DELTA_IJKM1*BETAI_IJKM1*BETAI_IJKM1
C     (7) DELTA_IJKM1*BETAI_IJKM1*GAMMA_M1
C     (9) DELTA_IJKM1*GAMMA_M1*VR_M1  
C     (8) DELTA_IJKM1*GAMMA_M1*GAMMA_M1
C
C ... ABCD SUBPROGRAM REFERENCES:      
C       
C          NON-GRAPHICS     READWIND (IF USING GUESS WIND FIELD)
C                           SWEEPIN, READRAMFILE (PRESENTLY NOT USED), VRLOCATE
C
C          GRAPHICS         RASX_OPEN_WINDOW, SOLO_CONVT, SHOW_IZ
C 
C ... IMPORTANT FLAGS: <()> INDICATES DEFAULT
C          
C          IGRAPHICS      USE GRAPHICS (0) NO (1) YES
C          IJTEST         AZI-COVERAGE (0) SECTOR <(1)> FULL (AKA IACROSS)
C          IGUESS         USE A GUESS WIND FIELD <(0)> NO (1) YES (AKA IUSEWIND)
C          IREVERSE       REVERSE SIGN OF DOPPLER VR <(0)> NO (1) YES
C          IREADABCD      READ IN SUMFILE <(0)> NO (1) YES
C          IVSPEED        USE CONST. AZI ADV. <(0)> NO (1) YES
C          IRAMSFILES     USE RAMSFILE <(0)> NO (1) YES
C          ICLSWP         SWITCH FROM (0) TO (1) UPON CALLING SWEEPIN ONCE
C          IBEGIN         SWITCH FROM (0) TO (1) WHEN ANGLE PROJ SUM BEGINS
C          ILATERSWEEP    ASSIGNED (1) WITHIN SWEEPIN
C      
C     VERSION:  <TBD>
C       
C     CODE WRITTEN BY:  JOHN GAMACHE   
C                       HRD/AOML/NOAA          
C                       MIAMI, FL 33149      
C       
C     FOR ADDITIONAL DETAILS ON THE ALGORITHM SEE <TBD>
C       
C     BASED ON THEORY BY:  <TBD>
C       
C     REFERENCE THE BOOK:  <TBD>
C       
C     **************************************************  
C     *               IMPORTANT NOTE                   *  
C     *                                                *  
C     *                    <TBD>                       *  
C     *                                                *  
C     **************************************************         
C
C     SPECIFICATIONS FOR ARGUMENTS
C 
      INTEGER NF
      INTEGER IMAXB,JMAXB,KMAXB,KMIN2,KMAX2
      INTEGER IGRAPHICS,IJTEST,IGUESS,IREVERSE,IREADABCD
      INTEGER IVSPEED,IRAMSFILES
      REAL RRMAX,RTMAX,RZMAX,ERMAX,ETMAX,EZMAX
      REAL SRB,STHETAB,SZB,RZB,THETAZB,ZZB,ROTB
      REAL XACC,YACC,ZACC,PIMAX
      REAL SINTOL
      REAL SMOTIONU,SMOTIONV,OLAT,OLON
      REAL TSTART,TEND,SLOPE1,CENTIME     
      REAL DBZTEST,RRRR,VSPEED0,VFACTOR
      REAL SUM1(IMAXB,JMAXB,KMAXB,2),SUM2(IMAXB,JMAXB,KMAXB,2)
      REAL SUM3(IMAXB,JMAXB,KMAXB,2),SUM4(IMAXB,JMAXB,KMAXB,2)
      REAL SUM5(IMAXB,JMAXB,KMAXB,2),SUM6(IMAXB,JMAXB,KMAXB,2)
      REAL SUM7(IMAXB,JMAXB,KMAXB,2),SUM8(IMAXB,JMAXB,KMAXB,2)
      REAL SUM9(IMAXB,JMAXB,KMAXB,2),SUM10(IMAXB,JMAXB,KMAXB,2)
      REAL SUM11(IMAXB,JMAXB,KMAXB,2),SUM12(IMAXB,JMAXB,KMAXB,2)
      REAL SUM13(IMAXB,JMAXB,KMAXB,2)
      REAL UGUESS(IMAXB,JMAXB,KMAXB),VGUESS(IMAXB,JMAXB,KMAXB)
      REAL WGUESS(IMAXB,JMAXB,KMAXB)
      REAL SUMWTSAVE(IMAXB,JMAXB,KMAXB,2)
      REAL XWSAVE(IMAXB,JMAXB,KMAXB,2),YWSAVE(IMAXB,JMAXB,KMAXB,2)
      REAL ZWSAVE(IMAXB,JMAXB,KMAXB,2)
      REAL SUMDBZ(IMAXB,JMAXB,KMAXB,2)
      REAL DISTXYZ(IMAXB,JMAXB,KMAXB,2,2,2,2)
      CHARACTER*2 TATF(80)
      CHARACTER FLIGHTID*8
C
C ... DESCRIPTION OF ARGUMENTS
C
C     RRMAX,RTMAX,RZMAX    - RADIAL,AZI,VERTICAL SCALE OF INFLUENCE (KM,DEG,KM)
C     ERMAX,ETMAX,EZMAX    - RADIAL,AZI,VERTICAL E-FOLDING DISTANCE (KM,DEG,KM)
C     XACC,YACC,ZACC       - MAX ALLOWED RADIAL,AZI,VERTICAL DIST. BETWEEN AVG. OBS POS. AND GRIDPOINT
C     NF                   - FILE NO.
C     SUM1-13              - SUMS OF PRODUCTS ACCUMULATED DURING INTERP. PROCESS
C     KMIN2,KMAX2          - TYPICALLY MIN AND MAX VERTICAL LEVEL NO.
C     SINTOL               - SIN OF MAX ALLOWED DOPPLER RADIAL ANGLE FROM HORIZ.
C     SRB,STHETAB,SZB      - RADIAL,AZI,VERTICAL GRID SPACING (KM,DEG,KM)
C     RZB,THETAZB,ZZB      - MIN RADIUS,AZI,HEIGHT (KM,DEG,KM)
C     ROTB                 - COORD. ROTATION (ALWAYS ZERO IN CYL COORDS)
C     IMAXB,JMAXB,KMAXB    - RADIAL,AZI,VERTICAL ARRAY DIMENSION
C     SUMDBZ               - WEIGHTED AVG. REFLECTIVITY AT GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN
C     SUMWTSAVE            - ACCUMULATED WEIGHT AT GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN
C     XWSAVE,YWSAVE,ZWSAVE - WEIGHTED AVG. R,THETA,Z DIST. BETWEEN DATUM AND GRIDPOINT
C     OLAT,OLON            - LAT,LON OF GRID ORIGIN (STORM CENTER)
C     SLOPE1               - REFLECTIVITY SLOPE CORRECTION FACTOR SET TO ONE
C     CENTIME              - ANALYSIS TIME (S)
C     TSTART,TEND          - SEE STIME,ETIME
C     SMOTIONU,SMOTIONV    - STORM MOTION (M/S)
C     FLIGHTID             - FLIGHT NAME
C     DBZTEST              - MIN DBZ TO INCLUDE
C     RRRR                 - MIN RANGE TO INCLUDE
C     UGUESS,VGUESS,WGUESS - GUESS RADIAL, TANGENTIAL, AND VERTICAL WIND (ZERO, M/S)
C     DISTXYZ              - DISTANCE OF THE CLOSEST OBS THAT WAS INTERP. TO GRIDPOINT (I,J,K)
C     PIMAX                - MAX AZI ANGLE FOR OBS TO BE INCLUDED IN WT AVG
C     VSPEED0              - CONST. ADV. SPEED USED IN COMPOSITING (M/S)
C     VFACTOR              - FACTOR MULT. WIND SPEED TO USE IN COMPOSITING (M/S)
C     TATF                 - IDENTIFY SCAN TYPE 
C
C     SPECIFICATIONS FOR LOCAL VARIABLES
C
C **** GRAPHICS
C 
      PARAMETER(MAX_X=750,MAX_Y=250)
      INTEGER IMAXSWEEP,JMAXSWEEP,NMOSM,DATA_TYPE,IXL,IYB
      INTEGER RAW_WINDOW(100),RAWZ_WINDOW(100)
      INTEGER*2 DBZ_INT(MAX_X,MAX_Y)      
      INTEGER ILOG_LU,LABLEN,IERSM,ITFLG
      REAL RMX,XDIS,YDIS,SWEEPSX,SWEEPSY
      REAL RDEL,RDEL_Z,BAD_VAL,DOPMIN,DOPMAX
      REAL TOO_NOISY,AMBIGUOUS,BAD_VALZ,DBZMIN,DBZMAX
      REAL RLATDUM,RLONDUM,SLATDUM,SLONDUM
      CHARACTER DISPLAY_LABEL*32,WINDOW_LABEL*28
      CHARACTER DISPLAY_LABELZ*32,WINDOW_LABELZ*18
C
C **** REMAINING
C 
      INTEGER I,J,K,L,II,JJ,KK,LL,A,LMN,MNO,KNO,L2,IL
      INTEGER IJKMAX,ISCANMAX,IUSEWIND,IMXG,JMXG,KMXG,ILATERSWEEP
      INTEGER JJJSTART,JJTEST,IA,JA,KA,KABOT
      INTEGER IMIDDLE,JMIDDLE,KMIDDLE,IMID,JMID,KMID
      INTEGER IDELTA,JDELTA,KDELTA,IXMIN,IXMAX,IYMIN,IYMAX,IZMIN,IZMAX
      INTEGER MAX_GATES,MAX_RAYS,MDIM,MDIM2,ISCANDIM,IBINS,JBINS,NR
      INTEGER IBEGIN,NRECORD,ICLSWP,NELAZOLD,NUM_RAYS,NTASWEEP,NBINS
      INTEGER JINDEX(512,800),JIINDEX(512,800)
      INTEGER WINDOWERROR,NVRADD,IOKAY
      INTEGER IHOURS,IMINS,ISECS,ITHHMMSS,IOS,IERR
      INTEGER ITIMES,ITIMEHH,IREMAIN,ITIMEMM,ITIMESS
      REAL FLAG,PI,PI2
      REAL ELMIN,ELMAX,DTR,HEIGHT,RHO
      REAL SXG,SYG,SZG,OLATG,OLONG,XZG,YZG,ZZG
      REAL SXB2,SYB2,SZB2,RHIGH,RLOW
      REAL RRWEIGHT,RTWEIGHT,RZWEIGHT,TIMER
      REAL SUMU,SUMV,SUMW,ELEVTEST,AZEL,ELAZ,AZIM,AZIMM
      REAL GAMMA,ALPHA,BETA,DBZCHK,ZRCHECK,VRVR
      REAL TIMES,TIMEOLD,SECLEFT,TIME_RAM
      REAL UU,VV,WW,REEV,REAZM,CREAZM,SREAZM,CREEV,SREEV
      REAL VRTEST,RALT,ELEV,RLAT,RLON,RLATR,RLONR
      REAL DM1,DM2,DM3,DM4,DM5,DM6,DM7
      REAL RLATDIFF,RLONDIFF,TIMEDIFF
      REAL XSHFT,YSHFT
      REAL HKMID,VSPEED,RSPEED,WSPEED,UM,VM,WM
      REAL DELTHETA,DELRAD,DELH
      REAL ALPHAI,BETAI,RHOVRVR,HKK,ZAN,RZ,RAN,RX,RTFACT
      REAL TAN,TDIFF,RYDIST,RY,RR,ABC,WEIGHT,P,DBZZ,ZE,DIST
      REAL GTLENGTH(512)
      REAL UG(400000),VG(400000),WG(400000)
      REAL SUMVR(90,2,3),SUMNVR(90,2,3),VRTOT(2,3),VRTOTN(2,3)
      REAL VRTOTSUM(2,3),VRTOTSUMN(2,3),VRINTERIM(2,3)
      REAL SUMVRSHOW(90,2,3)
      REAL UMEAN(100,360),VMEAN(100,360),WMEAN(100,360)
      REAL VR(1024),RANGE(1024),DBZ(1024),XR(1024),YR(1024),ZR(1024)
      REAL RDWD(800),RDWS(800),RDVWS(800)
      REAL RAD(1024),THETA(1024)
      REAL RHOK(100)
      REAL VRSWP(512,800),REFSWP(512,800),VRRAD(512,800)
      REAL RDTAI(512),AZ_EL(2,800),EAZM(800),EEV(800)
      REAL VNYQ(512,800),PELEV(800)
      REAL TMP1(512,800),TMP2(512,800),UNFVEL(512,800)
      REAL SWEEPSAVE(512,800)
      REAL TMSWEEP(800),RRLAT(800),RRLON(800),RRA(800)
      REAL SUMMER(100,400,50,2)
      CHARACTER*2 TAF
C
C ... DESCRIPTION OF VARIABLES PASSED BETWEEN SUBROUTINES
C 
C **** SWEEPIN
C
C     VRSWP(GATE,RAY)     - DOPPLER RADIAL VELOCITY FOR GIVEN GATE AND RADIAL (M/S)
C     REFSWP(GATE,RAY)    - REFLECTIVITY FOR GIVEN GATE AND RADIAL (DBZ)
C     MAX_GATES           - MAX NO. OF GATES STORED FOR EACH RADIAL
C     MAX_RAYS            - MAX NO. OF RADIALS EXPECTED IN A FULL SWEEP
C     NUM_RAYS            - RADIAL COUNTER
C     RDTAI(GATE)         - ??
C     AZ_EL(1/2,RAY)      - 1/2 RAW AZIMUTH/ELEVATION ANGLE FOR GIVEN RADIAL (AIRCRAFT RELATIVE, DEG)
C     NRECORD             - NUMBER OF RECORDS (APPEARS TO BE 1)
C     VRRAD(GATE,RAY)     - ??     
C     UNFVEL(GATE,RAY)    - NOT USED
C     TMP1(GATE,RAY)      - NOT USED
C     TMP2(GATE,RAY)      - NOT USED
C     JINDEX(GATE,RAY)    - NOT USED
C     JIINDEX(GATE,RAY)   - NOT USED    
C     VNYQ(GATE,RAY)      - ASSIGNED A VALUE IN SWEEPIN, BUT NOT USED
C     SWEEPSAVE(GATE,RAY) - ASSIGNED A VALUE IN SWEEPIN, BUT NOT USED
C     UG,VG,WG            - GUESS WIND FIELD (TYPICALLY ZERO)
C     IMXG,JMXG,KMXG      - GUESS WIND RADIAL,AZI,VERTICAL ARRAY DIMENSION
C     SXG,SYG,SZG         - GUESS WIND RADIAL,AZI,VERTICAL GRID SPACING (KM,DEG,KM)
C     OLATG,OLONG         - GUESS WIND LAT,LON OF GRID ORIGIN
C     XZG,YZG,ZZG         - GUESS WIND MIN RADIUS,AZI,HEIGHT (KM,DEG,KM)
C     EAZM(RAY)           - AZIMUTH ANGLE FOR GIVEN RADIAL (EARTH RELATIVE, DEG)
C     EEV(RAY)            - ELEVATION ANGLE FOR GIVEN RADIAL (EARTH RELATIVE, DEG)
C     TMSWEEP(RAY)        - TIME OF EACH RADIAL (S)
C     RRLAT,RRLON(RAY)    - RADAR LAT,LON FOR GIVEN RADIAL
C     RRA(RAY)            - RADAR ALTITUDE FOR GIVEN RADIAL
C     PELEV(RAY)          - ELEVATION ANGLE (AIRCRAFT RELATIVE, DEG)
C     NTASWEEP            - ??
C     RDWS(RAY)           - FLIGHT-LEVEL WIND SPEED FOR GIVEN RADIAL (M/S)
C     RDWD(RAY)           - FLIGHT-LEVEL WIND DIRECTION FOR GIVEN RADIAL (DEG)
C     RDVWS(RAY)          - FLIGHT-LEVEL VERTICAL WIND SPEED FOR GIVEN RADIAL (M/S)
C     NBINS               - ??
C
C **** READRAMFILE
C
C     TIMES               - TIME OF GIVEN RADIAL (S) 
C     TIME_RAM            - ??
C     RLAT,RLON           - RADAR LAT,LON FOR GIVEN RADIAL
C     DM1-7               - ??
C     IOS                 - ??
C
C **** VRLOCATE
C
C     RALT                - RADAR ALTITUDE FOR GIVEN RADIAL
C     ELEV                - ELEVATION ANGLE FOR GIVEN RADIAL (EARTH RELATIVE, DEG)
C     AZIM                - AZIMUTH ANGLE FOR GIVEN RADIAL (EARTH RELATIVE, DEG)
C     RANGE               - GATE RANGE FOR GIVEN RADIAL
C     XR,YR,ZR            - (X,Y,Z) DISTANCE OF DATUM FROM GRID ORIGIN (KM)
C     ISCANDIM            - RANGE GATE DIMENSION OF ARRAYS 
C     XSHFT,YSHFT         - ZERO BY DEFAULT IN R-THETA INTERPOLATION
C     RAD                 - DISTANCE OF DATUM FROM GRID ORIGIN (KM)
C     THETA               - ANGLE DATUM MAKES WITH POSITIVE X AXIS
C     ISCANMAX            - MAX NUMBER OF GATES INCLUDED
C 
      FLAG=-1.0E+10
C 
C ... OPEN GRAPHICS WINDOWS
C 
      IF(IGRAPHICS.EQ.1)THEN
       WINDOW_LABEL='cleaned up radial velocities'
       WINDOW_LABELZ='reflectivity (dBZ)'
       ILOG_LU=6
       LABLEN=28
       CALL RASX_OPEN_WINDOW(RAW_WINDOW,WINDOWERROR,
     +  WINDOW_LABEL,LABLEN)
       LABLEN=18
       CALL RASX_OPEN_WINDOW(RAWZ_WINDOW,WINDOWERROR,
     +  WINDOW_LABELZ,LABLEN)
      ENDIF
C
C     SINCE THIS ROUTINE IS USED TO DO THE INITIAL INTERPOLATION BEFORE
C     THERE IS A GUESS WIND FIELD, CALL TO READWIND IS TYPICALLY SKIPPED
C 
      WRITE(6,*)'IGUESS = ',IGUESS
      IUSEWIND=IGUESS
      IF(IUSEWIND.EQ.1)THEN
       IJKMAX=400000
       CALL READWIND(UG,VG,WG,IMXG,JMXG,KMXG,SXG,SYG,SZG,
     + OLATG,OLONG,XZG,YZG,ZZG,IJKMAX,ZLOW,ZHIGH,HB2,DPB2)
      ENDIF
C 
      ISCANMAX=128
C 
      MAX_GATES=512
      MAX_RAYS=800
C
C     MDIM IS TOTAL NO. OF GRID POINTS IN OUTPUT FIELDS
C 
      MDIM=IMAXB*JMAXB*KMAXB
      WRITE(6,*)'MDIM = IMAXB*JMAXB*KMAXB = ',MDIM
C
C     DETERMINE PI TO FULL REAL-VARIABLE RESOLUTION
C 
      PI=2.*ASIN(1.)
      PI2=2.*PI
      NELAZOLD=0
      ELMIN=-180.
      ELMAX=180.
      DTR=PI/180.
      ISCANDIM=256
      IBINS=7
      SXB2=.5*SXB*SXB
      SYB2=.5*SYB*SYB
      SZB2=.5*SZB*SZB
      JBINS=3*IBINS+1
      RHIGH=200.
      RLOW=.1
C  
C     (II,JJ,KK,I,J,K,LL,L) LOOPS (RADIAL SIDE,AZI SIDE,VERTICAL SIDE,RADIUS,AZI,HEIGHT,GATE,FORE/AFT) 
C
C ... INITIALIZE ARRAYS HOLDING ?? AND DENSITY PROFILE.
C     DISTXYZ IS THE DISTANCE OF THE CLOSEST OBS THAT WAS INTERPOLATED
C     TO GRID POINT (I,J,K). IF EQUAL TO 1000, THEN GRID POINT WAS NOT
C     SURROUNDED BY DATA WHICH COULD BE INTERPOLATED. ALL GRID POINTS
C     ARE INITIALIZED TO HAVE DISTXYZ EQUAL TO 1000.
C 
      DO L=1,2
       DO LL=1,3
        VRTOTSUM(L,LL)=0.
        VRTOTSUMN(L,LL)=0.
       ENDDO
       DO K=1,KMAXB
        HEIGHT=ZZB+(K-1)*SZB
        RHO=EXP(-HEIGHT*.10437052)
        RHOK(K)=RHO
        DO J=1,JMAXB
         DO I=1,IMAXB
          DO KK=1,2
           DO JJ=1,2
            DO II=1,2
             DISTXYZ(I,J,K,L,II,JJ,KK)=1000.
            ENDDO
           ENDDO
          ENDDO
         ENDDO
        ENDDO
       ENDDO
      ENDDO
C 
C     RANGE IS VECTOR (1,2,...,256)
C     VR IS VECTOR -(1,2,...,256)
C     DBZ IS VECTOR 2*(1,2,...,256)
C 
      DO I=1,256
       A=I
       RANGE(I)=A
       VR(I)=-A
       DBZ(I)=A*2.
      ENDDO
C 
      write(6,*)'entered abcd'
      MDIM2=IMAXB*JMAXB
      WRITE(6,*)'IMAXB,JMAXB,KMAXB,SXB,SYB,SZB,ROTB'
      WRITE(6,*)IMAXB,JMAXB,KMAXB,SXB,SYB,SZB,ROTB
      WRITE(6,*)'Entered ABCD'
C
C     RADIAL, AZI, AND VERTICAL WEIGHTS ARE EFOLDING SCALES SQUARED
C  
      RRWEIGHT=ERMAX*ERMAX
      RTWEIGHT=ETMAX*ETMAX
      RZWEIGHT=EZMAX*EZMAX
      WRITE(6,*)'EHMAX,EZMAX,RXMAX,RYMAX,RZMAX'
      WRITE(6,*)EHMAX,EZMAX,RXMAX,RYMAX,RZMAX    
      WRITE(6,*)'XACC = ',XACC
      WRITE(6,*)'YACC = ',YACC
      WRITE(6,*)'ZACC = ',ZACC
C 
      TIMER=0.
C
C ... DETERMINE R-Z MEAN VALUES OF GUESS TANGENTIAL (V), RADIAL (U) AND 
C     VERTICAL (W) WIND. MEAN VALUES CAN BE USED TO ADVECT OBS TO COMMON
C     COMPOSITE TIME. 
C 
      DO K=1,KMAXB
       DO I=1,IMAXB
        SUMV=0.
        SUMU=0.
        SUMW=0.
        DO J=1,JMAXB
         SUMV=SUMV+VGUESS(I,J,K)
         SUMU=SUMU+UGUESS(I,J,K)
         SUMW=SUMW+WGUESS(I,J,K)
        ENDDO
        VMEAN(I,K)=SUMV/JMAXB
        UMEAN(I,K)=SUMU/JMAXB
        WMEAN(I,K)=SUMW/JMAXB
       ENDDO
      ENDDO
C 
C     (II,JJ,KK,L) LOOPS (RADIUS,AZI,HEIGHT,FORE/AFT) 
C 
C ... ZERO ALL ANGLE-PROJECTION SUMMATIONS. THIS IS DONE BEFORE LOOPING OVER ALL SWEEPS.
C 
      DO L=1,2
       IF(IREADABCD.NE.1)THEN
        DO KK=KMIN2,KMAX2
         DO JJ=1,JMAXB
          DO II=1,IMAXB
           SUMDBZ(II,JJ,KK,L)=0
           SUMWTSAVE(II,JJ,KK,L)=0
           SUM1(II,JJ,KK,L)=0
           SUM2(II,JJ,KK,L)=0
           SUM3(II,JJ,KK,L)=0
           SUM4(II,JJ,KK,L)=0
           SUM5(II,JJ,KK,L)=0
           SUM6(II,JJ,KK,L)=0
           SUM7(II,JJ,KK,L)=0
           SUM8(II,JJ,KK,L)=0
           SUM9(II,JJ,KK,L)=0
           SUM10(II,JJ,KK,L)=0
           SUM11(II,JJ,KK,L)=0
           SUM12(II,JJ,KK,L)=0
           SUM13(II,JJ,KK,L)=0
           XWSAVE(II,JJ,KK,L)=0
           YWSAVE(II,JJ,KK,L)=0
           ZWSAVE(II,JJ,KK,L)=0
           SUMMER(II,JJ,KK,L)=0
          ENDDO
         ENDDO
        ENDDO
       ENDIF
      ENDDO
C 
      IBEGIN=0
      TIMES=0.
      NRECORD=1
      ICLSWP=0
C 
      IF(IREADABCD.EQ.1)GO TO 72735
C 
C     ****AFTER EACH SWEEP THE PROGRAM RETURNS HERE UNTIL MAX TIME IS REACHED****
C 
92923 TAF=TATF(1)
C
C     VR IS 1024 ELEMENT VECTOR (FLAG,FLAG,...,FLAG)
C     DBZ IS 1024 ELEMENT VECTOR (FLAG,FLAG,...,FLAG)
C 
      DO I=1,1024
       VR(I)=FLAG
       DBZ(I)=FLAG
      ENDDO
C
C ... SWEEPIN READS DATA FROM A TO_FB FILE, CLEANS IT UP, REMOVES THE SURFACE,
C     REMOVES SPECKLES, AND AUTOMATICALLY (BARGEN BROWN) DE-ALIASES THE DATA 
C     IN BOTH SINGLE-RADIAL AND AZIMUTHAL MODES
C 
      CALL SWEEPIN(VRSWP,REFSWP,MAX_RAYS,MAX_GATES,NUM_RAYS,RDTAI,
     + AZ_EL,ICLSWP,NRECORD,VRRAD,UNFVEL,TMP1,TMP2,JINDEX,
     + JIINDEX,VNYQ,ILATERSWEEP,SWEEPSAVE,UG,VG,WG,
     + IMXG,JMXG,KMXG,SXG,SYG,SZG,OLATG,OLONG,XZG,YZG,ZZG,
     + IUSEWIND,EAZM,EEV,TMSWEEP,RRLAT,RRLON,RRA,
     + SMOTIONU,SMOTIONV,CENTIME,PELEV,NTASWEEP,
     + RDWS,RDWD,RDVWS,NBINS,OLAT,OLON)
C 
      ICLSWP=1
      NR=1
C
C ... SET FIRST 128 ELEMENTS OF RANGE TO ??. GTLENGTH CONTAINS SAME INFO.
C 
      DO I=1,128
       RANGE(I)=RDTAI(I)
       GTLENGTH(I)=RDTAI(I)
      ENDDO
C
C ... LOOPING THROUGH ALL GATES, SET RANGE TO MAX VAL PLUS 0.01 IF IT 
C     EXCEEDS MAX VAL.
C    
      DO I=1,512
       IF(RANGE(I).GT.RHIGH)RANGE(I)=RHIGH+.01
      ENDDO
C
C ... BEGIN GRAPHICS
C 
      IF(IGRAPHICS.EQ.1)THEN
C 
       RMX=gtlength(nbins)
       XDIS=75.
       YDIS=10.
       SWEEPSX=.20
       SWEEPSY=.20
       IMAXSWEEP=MAX_X
       JMAXSWEEP=MAX_Y
       RDEL=0.
       RDEL_Z=0.
       NMOSM=0
       BAD_VAL=-888.8
       DOPMIN=-80.
       DOPMAX=80.
       TOO_NOISY=-200.
       AMBIGUOUS=-100.
       BAD_VALZ=-31.5
       DBZMIN=-20.
       DBZMAX=55.
       IXL=20
       IYB=20
C
C      FIRST FOR DATA_TYPE=2
C 
       DATA_TYPE=2
C 
       write(6,*)'calling solo_convt'
       CALL SOLO_CONVT(DATA_TYPE,ELMIN,ELMAX,
     +  DBZ_INT,MAX_X,MAX_Y,ILOG_LU,
     +  AZ_EL,VRSWP,MAX_GATES,ISCANMAX,NUM_RAYS,IERSM,
     +  IMAXSWEEP,JMAXSWEEP,SWEEPSX,SWEEPSY,XDIS,YDIS,RLATDUM,
     +  RLONDUM,SLATDUM,SLONDUM,RMX,RDEL_Z,TIMES,NMOSM,ITFLG,
     +  GTLENGTH,BAD_VAL)
       write(6,*)'returned from solo_convt'
       write(6,*)'calling show_iz'
       CALL SHOW_IZ(IXL,IYB,DBZ_INT,MAX_X,MAX_Y,IMAXSWEEP,JMAXSWEEP,
     +  DOPMIN,DOPMAX,DATA_TYPE,TOO_NOISY,AMBIGUOUS,
     +  RAW_WINDOW,DISPLAY_LABEL)
       write(6,*)'returned from show_iz'
C      
C      THEN FOR DATA_TYPE=1
C 
       DATA_TYPE=1
C 
       write(6,*)'calling solo_convt'
       CALL SOLO_CONVT(DATA_TYPE,ELMIN,ELMAX,
     +  DBZ_INT,MAX_X,MAX_Y,ILOG_LU,
     +  AZ_EL,REFSWP,MAX_GATES,ISCANMAX,NUM_RAYS,IERSM,
     +  IMAXSWEEP,JMAXSWEEP,SWEEPSX,SWEEPSY,XDIS,YDIS,RLATDUM,
     +  RLONDUM,SLATDUM,SLONDUM,RMX,RDEL_Z,TIMES,NMOSM,ITFLG,
     +  GTLENGTH,BAD_VALZ)
       write(6,*)'returned from solo_convt'
       write(6,*)'calling show_iz'
       CALL SHOW_IZ(IXL,IYB,DBZ_INT,MAX_X,MAX_Y,IMAXSWEEP,JMAXSWEEP,
     +  DBZMIN,DBZMAX,DATA_TYPE,TOO_NOISY,AMBIGUOUS,
     +  RAWZ_WINDOW,DISPLAY_LABELZ)
       write(6,*)'returned from show_iz'
C 
      ENDIF
C
C ... END GRAPHICS
C 
C     PELEV IS SET IN SWEEPIN AND STORES ELEVATION ANGLE FOR EACH RADIAL. 
C     IF THE SECOND ELEMENT IS >= ZERO, SCAN IS AFT (NELAZ=2). IF 
C     ELEMENT IS < ZERO, SCAN IS FORE (NELAZ=1). KEEPING TRACK OF WHETHER
C     RADIAL IS FORE OR AFT HELPS TO DEAL WITH THE ERRORS IN SEPARATING 
C     SWEEPS WHEN THE FRENCH ANTENNA IS USED.
C 
      IF(PELEV(2).GE.0.)THEN
       NELAZ=2
      ELSE
       NELAZ=1
      ENDIF
C     
C     NELAZOLD IS INITIALLY SET TO ZERO, SO CONDITION IS ALWAYS TRUE
C 
C ... ZERO ARRAYS CONTAINING ACCUMULATED DIFFERENCES BETWEEN DOPPLER VELOCITY AND VRTEST,
C     AND COUNTER OF GOOD GATES. 
C 
C     (KNO,MNO,LMN) LOOPS (GATE,FORE/AFT,AZI ANGLE INDEX)
C 
      IF(NELAZ.NE.NELAZOLD)THEN
       DO LMN=1,90
        DO MNO=1,2
         DO KNO=1,3
          SUMVR(LMN,MNO,KNO)=0.
          SUMNVR(LMN,MNO,KNO)=0.
         ENDDO
        ENDDO
       ENDDO
       NELAZOLD=NELAZ
      ENDIF
C 
C     EXECUTE THE CODE BELOW AS LONG AS RAY NUMBER (INITIALLY 1) IS <= MAX RAYS
C     RECALL NR IS THE RAY NO., WHICH IS ADVANCED BELOW 
C 
92924 DO WHILE(NR.LE.NUM_RAYS)
C 
       ELEVTEST=PELEV(NR)
C
C ... ADD 2 DEG TO AZI ANGLE FOR THIS RADIAL AND STORE IN AZEL. STORE ELEVATION ANGLE FOR 
C     THIS RADIAL IN ELAZ.  KEEP AZEL BETWEEN 0 AND 360.
C 
       AZEL=AZ_EL(1,NR)+2.
       ELAZ=PELEV(NR)
       NELAZ=1
       IF(ELAZ.GE.0.)NELAZ=2
       IF(AZEL.LT.0.)AZEL=AZEL+360.
       IF(AZEL.GT.360.)AZEL=AZEL-360.
C
C      AZIMUTHAL ANGLE INDEX ( (ANGLE+2 DEG)/4 + 1 )
C 
       NVRADD=1+INT(AZEL/4.)
C
C ...  BACK OUT CARTESIAN VELOCITY FROM FLIGHT-LEVEL WIND SPEED AND DIRECTION
C 
       VV=-RDWS(NR)*COS(RDWD(NR)*3.14159/180.)
       UU=-RDWS(NR)*SIN(RDWD(NR)*3.14159/180.)
       WW=RDVWS(NR)
C
C ...  CONVERT EARTH RELATIVE ELEVATION AND AZIMUTH ANGLE TO RADIANS
C 
       REEV=3.14159/180.*EEV(NR)
       REAZM=3.14159/180.*EAZM(NR)
C
C ...  COMPUTE COS/SIN OF EARTH RELATIVE AZIMUTH AND ELEVATION ANGLES
C 
       CREAZM=COS(REAZM)
       SREAZM=SIN(REAZM)
       CREEV=COS(REEV)
       SREEV=SIN(REEV)
C
C      (KNO) LOOPS (GATE)
C 
C ...  VRSWP(GATE,RAY) IS THE QC'D DOPPLER RADIAL VELOCITY.
C      KNO=1,3 DENOTES FIRST 3 GATES NEAR AIRCRAFT. VRTEST REPRESENTS
C      THE PROJECTION OF THE FLIGHT-LEVEL WIND ONTO THE DOPPLER RADIAL:
C      VRTEST = U*COS(AZI)*COS(ELEV) + V*SIN(AZI)*COS(ELEV) + W*SIN(ELEV)
C      SUMVR ACCUMULATES THE DIFFERENCES BETWEEN THE DOPPLER VELOCITY AND
C      VRTEST, WHILE SUMNVR SERVES AS A COUNTER OF GOOD GATES. THESE 
C      VARIABLES ARE USED ONLY AS A CHECK, AND ARE NOT PART OF THE 
C      SOLUTION METHOD.
C 
       DO KNO=1,3
        IF(VRSWP(KNO,NR).GT.-800.)THEN
        VRTEST=UU*CREAZM*CREEV
     +  +VV*SREAZM*CREEV+WW*SREEV
        VRCHECK=VRSWP(KNO,NR)-VRTEST
        SUMVR(NVRADD,NELAZ,KNO)=SUMVR(NVRADD,NELAZ,KNO)+VRCHECK
        SUMNVR(NVRADD,NELAZ,KNO)=SUMNVR(NVRADD,NELAZ,KNO)+1
        ENDIF
       ENDDO
C 
C      TAF WILL BE 'TA' OR 'TF'. RECALL ELEVTEST IS THE AIRCRAFT-RELATIVE 
C      ELEVATION ANGLE FOR THIS RAY. IF <= 0 THEN FORE AND L2=NF=1.  
C      IF > 0 THEN AFT AND L2=NF=2.
C 
       TAF=TATF(1)
       IF(ELEVTEST.LE.0.OR.'TAF'.EQ.'TN')THEN
        L2=1
        NF=1
       ELSE
        L2=2
        NF=2
       ENDIF
C      
C      TIMES STORES THE RAY TIME AND AZIM STORES THE EARTH-RELATIVE AZIMUTH ANGLE
C 
       TIMES=TMSWEEP(NR)
       AZIM=EAZM(NR)
C
C ...  SWEEPIN USES MATH ANGLES BUT VRLOCATE WAS BASED UPON USING THE UF FILE 
C      READER WHICH REPORTS BACK IN NAVIGATIONAL COORDINATES. DO A REFLECTION
C      AND CHECK.
C 
       AZIM=90-AZIM
       IF(AZIM.LT.0.)AZIM=AZIM+360.  
       IF(AZIM.GT.360.)AZIM=AZIM-360.
C 
       RALT=RRA(NR)   
       ELEV=EEV(NR)
       RLAT=RRLAT(NR)
       RLON=RRLON(NR)
       RLATR=RLAT
       RLONR=RLON
C 
       IHOURS=TIMES/3600.
       SECLEFT=TIMES-IHOURS*3600.
       IMINS=SECLEFT/60.
       ISECS=TIMES-IHOURS*3600.-IMINS*60.
       ITHHMMSS=IHOURS*10000+IMINS*100+ISECS
C
C ...  FOR GIVEN RADIAL STORE THE FIRST 128 GATES OF THE QC'D DOPPLER RADIAL 
C      VELOCITY IN VR AND REFLECTIVITY IN DBZ.
C 
       DO I=1,128
        VR(I)=VRSWP(I,NR)
        DBZ(I)=REFSWP(I,NR)
       ENDDO
C 
C **** RAMSFILES ARE NOT USED AT PRESENT, SO THIS CODE IS SKIPPED
C 
       IF(IRAMSFILES.EQ.1)THEN
        CALL READRAMFILE(TIMES,TIME_RAM,RLAT,RLON,DM1,DM2,DM3,
     *                      DM4,DM5,DM6,DM7,IOS)
        IF(IERR.EQ.0.AND.IOS.EQ.0)THEN
         RLATDIFF=RLAT-RLATR
         RLONDIFF=RLON-RLONR
        WRITE(6,*)'RLAT,RLATR,RLATDIFF,RLON,RLONR,RLONDIFF = ',
     +              RLAT,RLATR,RLATDIFF,RLON,RLONR,RLONDIFF
        ELSEIF(IOS.NE.0)THEN
         RLAT=RLATR+RLATDIFF
         RLON=RLONR+RLONDIFF
        WRITE(6,*)'IOS,RLAT,RLATR,RLATDIFF,RLON,RLONR,RLONDIFF = ',
     +              IOS,RLAT,RLATR,RLATDIFF,RLON,RLONR,RLONDIFF
        ELSE
         IHOURS=TIMES/3600.
         SECLEFT=TIMES-IHOURS*3600.
         IMINS=SECLEFT/60.
         ISECS=TIMES-IHOURS*3600.-IMINS*60.
         IHHMMSS=IHOURS*10000+IMINS*100+ISECS
         WRITE(6,*)'TIME,IOS,IERR = ',IHHMMSS,IOS,IERR
         IF(IERR.EQ.-2.OR.IERR.EQ.-3)THEN
          WRITE(6,*)'Are you giving rams coordinates to the '
          WRITE(6,*)'NEXRAD radar i.e. moving the radar?'
         ENDIF
         IF(IERR.LE.-4)GO TO 92923
        ENDIF
       ENDIF
C
C **** END SKIPPED CODE
C 
C      IF A NEW DAY IS REACHED, THEN ADD 86400 SEC TO THE TIME
C 
       IF(IBEGIN.EQ.1.AND.TIMES.LT.TSTART)TIMES=TIMES+86400.
C
C      EXIT PROCESSING OF RADIALS ONCE END TIME IS REACHED OR UPON ERROR
C 
       IF(TIMES.GT.TEND.OR.IERR.EQ.-1)GO TO 92929
C
C      INITIALLY TIMEOLD EQUALS ZERO, SO THIS CODE IS EXECUTED FIRST TIME.
C      APPEARS TO EXECUTE EVERY TIME.
C      
       IF(TIMES.GT.TIMEOLD)THEN
        ITIMES=NINT(TIMES)
        ITIMEHH=ITIMES/3600
        IREMAIN=ITIMES-3600*ITIMEHH
        ITIMEMM=IREMAIN/60
        ITIMESS=IREMAIN-ITIMEMM*60
       ENDIF
C 
       TIMEOLD=TIMES
C 
C ...  BEGIN ANGLE SUMMING CODE
C 
       IF(IREADABCD.NE.1.AND.TIMES.GE.TSTART.AND.TIMES.LE.TEND)THEN
C 
C       RDEL APPEARS TO BE ZERO...ALWAYS. RESULT: JJJSTART=2
C 
        IF(RDEL.GT.0.)THEN
         JJJSTART=1
        ELSE
         JJJSTART=2-(RDEL/.15)
        ENDIF
        IF(RDEL.LT.0)THEN
         DO JJJ=JJJSTART,ISCANDIM
          RANGE(JJJ)=RANGE(JJJ)+RDEL
          IF(IREVERSE.EQ.1)THEN
           VR(JJJ)=-VR(JJJ)
          ENDIF
         ENDDO
        ENDIF
C 
        IHOURS=TIMES/3600.
        SECLEFT=TIMES-IHOURS*3600.
        IMINS=SECLEFT/60.
        ISECS=TIMES-IHOURS*3600.-IMINS*60.
        ITHHMMSS=IHOURS*10000+IMINS*100+ISECS
C 
        IBEGIN=1
C
C       X/Y SHIFTING IS ZERO BY DEFAULT IN R-THETA INTERPOLATION
C 
        XSHFT=0.
        YSHFT=0.
C
C ...   VRLOCATE DETERMINES DATUM LOCATION WITHIN INTERPOLATION GRID
C       RETURNS XR,YR,ZR,RAD,THETA
C 
        CALL VRLOCATE(OLAT,OLON,TIMES,
     +   RLAT,RLON,RALT,ELEV,AZIM,RANGE,XR,YR,ZR,
     +   SMOTIONU,SMOTIONV,ISCANDIM,CENTIME,XSHFT,YSHFT,RAD,THETA,
     +   ISCANMAX)
C 
C       AZIMM IS JUST EARTH-RELATIVE AZIMUTH ANGLE (SINCE ROTB IS ZERO)
C 
        AZIMM=AZIM-ROTB
C 
C ...   COMPUTE DIRECTION COSINES WHICH ARE FUNCTIONS OF EARTH-RELATIVE 
C       RAY ORIENTATION ALONE: ALPHA_M, BETA_M, GAMMA_M
C 
        GAMMA=SIN(ELEV*DTR)
        ALPHA=SIN(AZIMM*DTR)*COS(ELEV*DTR)
        BETA=COS(AZIMM*DTR)*COS(ELEV*DTR)
C
C       (I) LOOPS (GATES)
C
C ...   SEE DOCUMENTATION AT BEGINNING OF SUBROUTINE FOR MATHEMATICAL EXPRESSIONS
C       BEING FORMULATED IN CODE BELOW. NUMBERS POINT TO RESPECTIVE EXPRESSIONS.
C 
        DO I=JJJSTART,NBINS
C 
C        CHECK VARIABLES NOT UTILIZED IN PRESENT CODE
C 
         DBZCHK=DBZTEST+20.*ALOG10(RANGE(I)/RRRR)
         ZRCHECK=RANGE(I)/57.*.95*COS(ELEV*DTR)
C 
         RHO=EXP(-ZR(I)*.10437052)
C 
C        VRVR STORES DOPPLER RADIAL VELOCITY FOR GATE I: VR_M
C 
         VRVR=VR(I)
C 
C        IF DOPPLER RADIAL VELOCITY EXISTS OR REFLECTIVITY IS ABOVE -30 DBZ
C        AND THE GATE IS WITHIN THE SPECIFIED RANGE, EXECUTE THE FOLLOWING:
C 
         IF((VR(I).GT.-800..OR.DBZ(I).GT.-30.).AND.
     +     RANGE(I).GT.RLOW.AND.RANGE(I).LT.RHIGH)THEN
C
C         IF EARTH-RELATIVE ELEVATION ANGLE IS <= 90 (DEFAULT), EXECUTE THE FOLLOWING:
C 
          IF(GAMMA.LE.SINTOL)THEN
C
C ...      DETERMINE ACTUAL DISTANCE BETWEEN DATUM AND POINT BEING EVALUATED IN OUTPUT FILE
C 
           IMIDDLE=NINT((RAD(I)-RZB)/SRB+1.)
           JMIDDLE=NINT((THETA(I)-THETAZB)/STHETAB+1.)
           KMIDDLE=NINT((ZR(I)-ZZB)/SZB+1.)
C 
           TIMEDIFF=TIMES-CENTIME
C 
C          IF > MAX RADIAL INDEX, IMID EQUALS MAX RADIAL INDEX. IF <= ZERO, IMID EQUALS
C          ONE. OTHERWISE IMID EQUALS IMIDDLE. ETC.          
C          
           IF(IMIDDLE.GT.IMAXB)THEN
            IMID=IMAXB
           ELSEIF(IMIDDLE.LE.0)THEN
            IMID=1
           ELSE
            IMID=IMIDDLE
           ENDIF
           IF(KMIDDLE.GT.KMAX2)THEN
            KMID=KMAX2
           ELSEIF(KMIDDLE.LE.0)THEN
            KMID=1
           ELSE
            KMID=KMIDDLE
           ENDIF
           IF(JMIDDLE.GT.JMAXB)THEN
            JMID=JMAXB
           ELSEIF(JMIDDLE.LE.0)THEN
            JMID=1
           ELSE
            JMID=JMIDDLE
           ENDIF
C 
           HKMID=ZZB+(KMID-1)*SZB
           RHO=EXP(-HKMID*.10437052)
C 
C          END RESULT HERE WILL BE VSPEED EQUALS ZERO
C 
           IF(VGUESS(IMID,JMID,KMID).GT.FLAG)THEN
            VSPEED=VGUESS(IMID,JMID,KMID)/RHO
           ELSE
            VSPEED=FLAG
            DO IL=IMID-1,1,-1
             IF(VGUESS(IL,JMID,KMID).GT.FLAG)THEN
              VSPEED=VGUESS(IL,JMID,KMID)/RHO
              GO TO 9984
             ENDIF
            ENDDO
9984         IF(VSPEED.EQ.FLAG)THEN
             VSPEED=60.
            ENDIF
           ENDIF
C 
           RSPEED=0.
           WSPEED=0.
           UM=0.
           VM=0.
           WM=0.
C
C          VSPEED HARDWIRED ANYWAY
C 
           VSPEED=0.
C 
C          DELTHETA,DELRAD,DELH WILL ALL BE ZERO HERE
C 
           DELTHETA=-TIMEDIFF*VSPEED/RAD(I)/1000.*180./3.14159*VFACTOR
           DELRAD=-TIMEDIFF*RSPEED/1000.
           DELH=-TIMEDIFF*WSPEED/1000.
C
C          DEFINITIONS OF RAD, THETA AND ZR ARE UNCHANGED
C 
           THETA(I)=THETA(I)+DELTHETA
           RAD(I)=RAD(I)+DELRAD
           ZR(I)=ZR(I)+DELH
C 
           IF(THETA(I).GT.360.)THETA(I)=THETA(I)-360.
           IF(THETA(I).LT.0.)THETA(I)=THETA(I)+360.
C           
           IMIDDLE=NINT((RAD(I)-RZB)/SRB+1.)
           JMIDDLE=NINT((THETA(I)-THETAZB)/STHETAB+1.)
           KMIDDLE=NINT((ZR(I)-ZZB)/SZB+1.)
C 
C          SCALES OF INFLUENCE CONVERTED TO NUMBER OF INDICES
C 
           IDELTA=INT(RRMAX/SRB)+1
           JDELTA=INT(RTMAX/STHETAB)+1
           KDELTA=INT(RZMAX/SZB)+1
C 
           IXMIN=IMIDDLE-IDELTA
           IXMAX=IMIDDLE+IDELTA
           IYMIN=JMIDDLE-JDELTA
           IYMAX=JMIDDLE+JDELTA
           IZMIN=KMIDDLE-KDELTA
           IZMAX=KMIDDLE+KDELTA
C 
C          DEALING WITH POSSIBILITY THAT IXMIN ETC. ARE NOT VALID GRIDPOINTS
C          
           IF(IXMIN.LT.1)THEN
            IXMIN=1
           ELSEIF(IXMIN.GT.IMAXB)THEN
            IXMIN=999
           ENDIF
           IF(IXMAX.GT.IMAXB)THEN
            IXMAX=IMAXB
           ELSEIF(IXMAX.LT.1)THEN
            IXMAX=999
           ENDIF
           IF(IZMIN.LT.KMIN2)THEN
            IZMIN=KMIN2
           ELSEIF(IZMIN.GT.KMAX2)THEN
            IZMIN=999
           ENDIF
           IF(IZMAX.LT.KMIN2)THEN
            IZMAX=999
           ELSEIF(IZMAX.GT.KMAX2)THEN
            IZMAX=KMAX2
           ENDIF
C 
C          THIS BELOW WILL NEVER BE EXECUTED AS LONG AS RSPEED IS ZERO
C 
           IF(RAD(I).LT.-100.)THEN
            WRITE(6,*)'i,rzb,srb,imiddle,idelta,ixmin,ixmax = ',
     +               i,rzb,srb,imiddle,idelta,ixmin,ixmax
            WRITE(6,*)'i,thetazb,sthetab,jmiddle,jdelta,iymin,iymax = ',      
     +               i,thetazb,sthetab,jmiddle,jdelta,iymin,iymax
            WRITE(6,*)'i,zzb,szb,kmiddle,kdelta,izmin,izmax = ',
     +               i,zzb,szb,kmiddle,kdelta,izmin,izmax
           ENDIF
C 
C ...      PERFORM THE FOLLOWING COMPUTATIONS AS LONG AS DOMAIN OF INFLUENCE
C          AROUND GRIDPOINT FALLS WITHIN ANALYSIS DOMAIN.
C 
           IF(IXMIN.LT.999.AND.IXMAX.LT.999.AND.IYMIN.LT.999.AND.
     +       IYMAX.LT.999.AND.IZMIN.LT.999.AND.IZMAX.LT.999)THEN
C 
C ...       NOTE XR/RAD IS COS(PHI) AND YR/RAD IS SIN(PHI)         
C 
            ALPHAI=(ALPHA*XR(I)+BETA*YR(I))/RAD(I)
            BETAI=(-ALPHA*YR(I)+BETA*XR(I))/RAD(I)
C
C           (KK) LOOPS (VERTICAL GRIDPOINT CENTERED ON DOMAIN OF INFLUENCE)
C 
            DO KK=IZMIN,IZMAX
C 
C ...        RHOVRVR IS RHO_K*VR_M
C 
             RHOVRVR=VRVR*RHOK(KK)
             HKK=ZZB+(KK-1)*SZB
             RHO=EXP(-HKK*.10437052)
C
C            ZAN IS HEIGHT OF GRIDPOINT ABOVE GROUND
C            RZ IS VERTICAL DISTANCE BETWEEN DATUM AND GRIDPOINT
C            
             ZAN=(KK-1)*SZB+ZZB
             RZ=ZR(I)-ZAN
C
C            (II) LOOPS (RADIAL GRIDPOINT CENTERED ON DOMAIN OF INFLUENCE)
C 
             DO II=IXMIN,IXMAX
C 
C             RAN IS RADIAL DISTANCE OF GRIDPOINT FROM GRID ORIGIN (STORM CENTER)
C             RX IS THE RADIAL DISTANCE BETWEEN DATUM AND GRIDPOINT.  
C 
              RAN=(II-1)*SRB+RZB
              RX=RAD(I)-RAN
C 
              RTFACT=1.
C
C             (JJ) LOOPS (AZIMUTHAL GRIDPOINT CENTERED ON DOMAIN OF INFLUENCE)
C 
              DO JJTEST=IYMIN,IYMAX  
C 
C              TAN IS AZIMUTHAL ANGLE OF GRIDPOINT FROM + X DIRECTION
C              TDIFF IS AZIMUTHAL ANGLE BETWEEN DATUM AND GRIDPOINT
C 
               TAN=(JJTEST-1)*STHETAB+THETAZB
               TDIFF=THETA(I)-TAN
               IF(TDIFF.GT.180.)TDIFF=TDIFF-360.
               IF(TDIFF.LT.-180.)TDIFF=TDIFF+360.
C
C              RYDIST IS AZIMUTHAL ARC DISTANCE (AT DATUM RADIUS) BETWEEN DATUM AND GRIDPOINT   
C              RY IS AZIMUTHAL ANGLE BETWEEN DATUM AND GRIDPOINT 
C          
               RYDIST=TDIFF*3.14159/180.*RAD(I)
               RY=TDIFF
C 
               IF(JJTEST.LT.1)THEN
                IF(IJTEST.EQ.1)THEN
                 JJ=JJTEST+JMAXB
                ELSEIF(ABS(RY).LT.RTMAX)THEN
                 JJ=JJTEST+NINT(360./STHETAB)
                ELSE
                 JJ=-1
                ENDIF
               ELSEIF(JJTEST.GT.JMAXB)THEN
                IF(IJTEST.EQ.1)THEN
                 JJ=JJTEST-JMAXB
                ELSEIF(ABS(RY).LT.RTMAX)THEN
                 JJ=JJTEST-NINT(360./STHETAB)
                ELSE
                 JJ=-1
                ENDIF
               ELSE
                JJ=JJTEST
               ENDIF
C 
               IF(JJ.LT.1.OR.JJ.GT.JMAXB)GO TO 6298
C
C              IF COMPONENT DISTANCE BETWEEN DATUM AND GRIDPOINT EXCEEDS SCALE OF 
C              INFLUENCE, GOTO NEXT GRIDPOINT                         
C 
               IF(ABS(RX).GT.RRMAX.OR.ABS(RY).GT.RTMAX.OR.
     +           ABS(RZ).GT.RZMAX)GO TO 6298
C 
C              RX <= 0 DATUM RADIALLY AT OR INSIDE GRIDPOINT --> IA=1
C              RX > 0  DATUM RADIALLY OUTSIDE GRIDPOINT      --> IA=2
C              RY <= 0 DATUM CLOCKWISE FROM GRIDPOINT        --> JA=1
C              RY > 0  DATUM COUNTERCLOCKWISE FROM GRIDPOINT --> JA=2
C              RZ <= 0 DATUM AT OR LOWER THAN GRIDPOINT      --> KA=1
C              RZ > 0  DATUM HIGHER THAN GRIDPOINT           --> KA=2
C 
               IF(RX.LE.0)IA=1
               IF(RX.GT.0)IA=2
               IF(RY.LE.0)JA=1
               IF(RY.GT.0)JA=2
               IF(RZ.LE.0)KA=1
               IF(RZ.GT.0)KA=2
C 
C              RR IS DISTANCE IN CYLINDRICAL COORDINATES BETWEEN DATUM AND GRIDPOINT
C 
               RR=SQRT(RX*RX+RTFACT*RYDIST*RYDIST+RZ*RZ)
C
C ...          IF DISTANCE RR BETWEEN GIVEN DATUM AND GRIDPOINT (II,JJ,KK) IS LESS THAN
C              CURRENT MINIMUM DISTANCE, AND THE DOPPLER RADIAL VELOCITY IS NON-FLAGGED,
C              ASSIGN DISTXYZ FOR GRIDPOINT (II,JJ,KK) THE VALUE RR. THIS IS DONE 
C              SEPARATELY FOR FORE AND AFT SWEEPS (L2=1,2). THIS IS ALSO DONE SEPARATELY
C              FOR THE 8 DIFFERENT SECTORS (IA,JA,KA=1,2) ABOUT THE GRIDPOINT.
C 
               IF(RR.LT.DISTXYZ(II,JJ,KK,L2,IA,JA,KA))THEN
                IF(VR(I).GT.-800.)THEN
                 DISTXYZ(II,JJ,KK,L2,IA,JA,KA)=RR
                ENDIF
               ENDIF
C 
C ...          P=WEIGHT=e^(-((R_D-R_GP)^2/EFOLD_R^2+(T_D-T_GP)^2/EFOLD_THETA^2+(Z_D-Z_GP)^2/EFOLD_Z^2))
C 
               ABC=RX*RX/RRWEIGHT+RY*RY/RTWEIGHT+RZ*RZ/RZWEIGHT
               WEIGHT=EXP(-ABC)
               P=WEIGHT
C
C              SLOPE1 IS HARDWIRED TO 1, SO DBZZ STORES DBZ DATUM 
C 
               IF(DBZ(I).GT.-100)THEN
                DBZZ=DBZ(I)*SLOPE1
                ELSE
                DBZZ=-200.
               ENDIF
C
C ...          ZE IS DBZ CONVERTED TO POWER. SUMDBZ IS THE ACCUMULATED WEIGHTED POWER AT 
C              GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN. SUMMER IS THE ACCUMULATED WEIGHT
C              AT GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN. ACCUMULATION OCCURS ONLY IF
C              THE REFELCTIVITY IS NOT FLAGGED.
C 
               IF(DBZ(I).GT.-100.)THEN
                ZE=10.**(DBZZ/10.)
                SUMDBZ(II,JJ,KK,L2)=
     +          SUMDBZ(II,JJ,KK,L2)+P*ZE
                SUMMER(II,JJ,KK,L2)=
     +          SUMMER(II,JJ,KK,L2)+P
               ENDIF
C
C ...          PERFORM WEIGHTED SUMS OF DIRECTION COSINE/VR TERMS AS LONG AS DOPPLER RADIAL 
C              VELOCITY IS NON-FLAGGED. THE FIRST 9 ARE USED IN THE COST-FUNCTION GRADIENT...
C 
               IF(VR(I).GT.-800.)THEN
C
C               (1)
                SUM1(II,JJ,KK,L2)=
     +          SUM1(II,JJ,KK,L2)+P*ALPHAI*BETAI
C
C               RHO*(2) 
                SUM2(II,JJ,KK,L2)=
     +          SUM2(II,JJ,KK,L2)+P*BETAI*RHOVRVR
C
C               (3) 
                SUM3(II,JJ,KK,L2)=
     +          SUM3(II,JJ,KK,L2)+P*BETAI*BETAI
C
C               RHO*(4) 
                SUM4(II,JJ,KK,L2)=
     +          SUM4(II,JJ,KK,L2)+P*ALPHAI*RHOVRVR
C
C               (5) 
                SUM5(II,JJ,KK,L2)=
     +          SUM5(II,JJ,KK,L2)+P*ALPHAI*ALPHAI
C
C               (6) 
                SUM6(II,JJ,KK,L2)=
     +          SUM6(II,JJ,KK,L2)+P*ALPHAI*GAMMA
C
C               (7) 
                SUM7(II,JJ,KK,L2)=
     +          SUM7(II,JJ,KK,L2)+P*BETAI*GAMMA
C
C               (8) 
                SUM8(II,JJ,KK,L2)=
     +          SUM8(II,JJ,KK,L2)+P*GAMMA*GAMMA
C
C               RHO*(9) 
                SUM9(II,JJ,KK,L2)=
     +          SUM9(II,JJ,KK,L2)+P*GAMMA*RHOVRVR
C
C ...           THE REMAINING SUMMATIONS ARE USED IN THE DEFINITION OF THE COST FUNCTION...
C
C               (10) 
                SUM10(II,JJ,KK,L2)=
     +          SUM10(II,JJ,KK,L2)+P*ALPHAI
C
C               (11) 
                SUM11(II,JJ,KK,L2)=
     +          SUM11(II,JJ,KK,L2)+P*BETAI
C
C               (12) 
                SUM12(II,JJ,KK,L2)=
     +          SUM12(II,JJ,KK,L2)+P*GAMMA
C
C               RHO*(13) 
                SUM13(II,JJ,KK,L2)=
     +          SUM13(II,JJ,KK,L2)+P*RHOVRVR
C 
C ...           SUMWTSAVE IS THE ACCUMULATED WEIGHT AT GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN. 
C               ACCUMULATION OCCURS ONLY IF THE DOPPLER RADIAL VELOCITY IS NON-FLAGGED. THIS 
C               VARIABLE IS DISTINGUISHED FROM SUMMER, WHICH IS BASED UPON REFLECTIVITY.
C 
                SUMWTSAVE(II,JJ,KK,L2)=SUMWTSAVE(II,JJ,KK,L2)+P
C
C ...           X/Y/ZSAVE ARE ACCUMULATED WEIGHTED R, THETA AND Z DISTANCES.
C 
                XWSAVE(II,JJ,KK,L2)=XWSAVE(II,JJ,KK,L2)+P*RX
                YWSAVE(II,JJ,KK,L2)=YWSAVE(II,JJ,KK,L2)+P*RY
                ZWSAVE(II,JJ,KK,L2)=ZWSAVE(II,JJ,KK,L2)+P*RZ
C 
               ENDIF
C
C              END DOPPLER RADIAL VELOCITY CONDITION 
C 
6298          ENDDO
             ENDDO
            ENDDO
C
C           END LOOPS OVER RADIUS, AZIMUTH, AND HEIGHT (II,JJ,KK)
C 
           ENDIF
C
C          END DOMAIN OF INFLUENCE CONDITION
C 
          ENDIF
C
C         END ELEVATION ANGLE CONDITION
C 
         ENDIF
C
C        END VR/DBZ/RANGE CONDITION
C  
        ENDDO
C       
C       END LOOP OVER GATES (I)
C 
       ENDIF
C
C      END CONTRIBUTION TO SUMMATIONS FROM GIVEN RAY
C
C ...  INCREMENT RAY NUMBER
C 
27272  NR=NR+1
C 
      ENDDO
C
C     DONE EXECUTING ABOVE CODE FOR EACH RAY (NR) FOR A GIVEN SWEEP 
C
C ... BEGIN SUMMATIONS THAT ARE DESIGNED TO DIAGNOSE ERRORS IN ANTENNA TILT (ELEVATION ANGLE)
C 
C
C    (I,J,KNO) LOOPS (AZI ANGLE INDEX,FORE/AFT,GATE)
C 
      DO J=1,2
C 
       DO KNO=1,3
        VRTOT(J,KNO)=0.
        VRTOTN(J,KNO)=0.
       ENDDO
C 
       DO I=1,45
        DO KNO=1,3
C
C        FOR GIVEN FORE/AFT SWEEP AND GATE, IF VELOCITY AT AZIMUTH NVRADD(1:45)
C        AND NVRADD(46:90) HAVE NON-FLAGGED VALUES, ASSIGN SUMVRSHOW THE
C        AVERAGE VALUE OF SUMVR. VRTOT FOR GIVEN FORE/AFT SWEEP AND GATE IS
C        THE SUM OF SUMVRSHOW FOR NVRADD(1:45) AND NVRADD(46:90). VRTOTN FOR
C        A GIVEN FORE/AFT SWEEP AND GATE IS TWICE THE NUMBER OF TIMES THE 
C        ABOVE CONDITION IS SATISFIED WHEN LOOPING THROUGH NVRADD.
C 
         IF(SUMNVR(I,J,KNO).GT.0..AND.SUMNVR(I+45,J,KNO).GT.0.)THEN
         SUMVRSHOW(I,J,KNO)=SUMVR(I,J,KNO)/SUMNVR(I,J,KNO)
         SUMVRSHOW(I+45,J,KNO)=SUMVR(I+45,J,KNO)/SUMNVR(I+45,J,KNO)
         VRTOT(J,KNO)=
     +    VRTOT(J,KNO)+SUMVRSHOW(I,J,KNO)+SUMVRSHOW(I+45,J,KNO)
          VRTOTN(J,KNO)=VRTOTN(J,KNO)+2.
         ELSE
          SUMVRSHOW(I,J,KNO)=0.
          SUMVRSHOW(I+45,J,KNO)=0.
         ENDIF
        ENDDO
       ENDDO
C 
      ENDDO
C
C     (J,KNO) LOOPS (FORE/AFT,GATE)
C 
      DO J=1,2
       DO KNO=1,3
C 
        VRINTERIM(J,KNO)=0.
C
C       AS LONG AS THERE IS ONE GOOD PAIR OF RAYS FOR THIS SWEEP AND GATE, VRTOT IS
C       REDEFINED TO BE THE AVERAGE VALUE. VRTOTSUM THEN ACCUMULATES VRTOT AS ALL
C       SWEEPS ARE READ IN. VRTOTSUMN COUNTS THE NUMBER OF ACCUMULATIONS.      
C 
        IF(VRTOTN(J,KNO).GT.0.)THEN
         VRTOT(J,KNO)=VRTOT(J,KNO)/VRTOTN(J,KNO)
         VRTOTSUM(J,KNO)=VRTOT(J,KNO)+VRTOTSUM(J,KNO)
         VRTOTSUMN(J,KNO)=VRTOTSUMN(J,KNO)+1.
        ELSE
         VRTOT(J,KNO)=0.
        ENDIF
C
C       VRINTERIM IS DEFINED AS THE AVERAGE VALUE OF VRTOT
C 
        IF(VRTOTSUMN(J,KNO).GT.0.)THEN
         VRINTERIM(J,KNO)=VRTOTSUM(J,KNO)/VRTOTSUMN(J,KNO)
        ENDIF
C 
       ENDDO
      ENDDO
C 
C     RETURN TO SWEEPIN TO INCORPORATE NEXT RADAR SWEEP
C 
      GO TO 92923
C 
C     PROGRAM HAS NOW READ IN, QC'D AND INCORPORATED ALL SWEEPS
C 
92929 WRITE(6,*)'JUST FINISHED VR SUMMATION'
C
C ... DETERMINE IF GRID POINT IS SURROUNDED BY DATA
C 
C     (II,JJ,KK,L,IA,JA,KA) LOOPS (RADIUS,AZI,HEIGHT,FORE/AFT,RADIAL SIDE,AZI SIDE,VERTICAL SIDE)
C 
      DO L=1,2
       DO KK=1,KMAXB
        DO JJ=1,JMAXB
         DO II=1,IMAXB
C
C         IF VERTICAL LEVEL IS <=4 THEN KA LOOPS FROM 2, 2. THIS MEANS THAT KA LOOP ONLY 
C         CONSIDERS DATUM HIGHER THAN GRID POINT IN THE BELOW.
C 
          IF(KK.LE.4)THEN
           KABOT=2
          ELSE
           KABOT=1
          ENDIF
C 
          DO KA=KABOT,2
           DO JA=1,2
            DO IA=1,2
C 
             DIST=DISTXYZ(II,JJ,KK,L,IA,JA,KA)
C
C            SETTING THIS TEST SO HIGH MEANS THE TEST OF A GRID POINT BEING SURROUNDED
C            IS TURNED OFF
C 
             IF(DIST.GE.99999999.)THEN
C 
              SUM1(II,JJ,KK,L)=0
              SUM2(II,JJ,KK,L)=0
              SUM3(II,JJ,KK,L)=0
              SUM4(II,JJ,KK,L)=0
              SUM5(II,JJ,KK,L)=0
              SUM6(II,JJ,KK,L)=0
              SUM7(II,JJ,KK,L)=0
              SUM8(II,JJ,KK,L)=0
              SUM9(II,JJ,KK,L)=0
              SUM10(II,JJ,KK,L)=0
              SUM11(II,JJ,KK,L)=0
              SUM12(II,JJ,KK,L)=0
              SUM13(II,JJ,KK,L)=0
              XWSAVE(II,JJ,KK,L)=1000.*SUMWTSAVE(II,JJ,KK,L)
              YWSAVE(II,JJ,KK,L)=1000.*SUMWTSAVE(II,JJ,KK,L)
              ZWSAVE(II,JJ,KK,L)=1000.*SUMWTSAVE(II,JJ,KK,L)
              SUMWTSAVE(II,JJ,KK,L)=0.
C
C             IF CONDITION IS MET MOVE ON TO NEXT (I,J,K,L) POINT
C 
              GO TO 10097
C 
             ENDIF
C 
            ENDDO
           ENDDO
          ENDDO
C
C         END IA,JA,KA LOOP
C 
10097    ENDDO
        ENDDO
       ENDDO
      ENDDO
C
C     END I,J,K,L LOOP 
C 
      IOKAY=1
C 
72735 IF(IOKAY.EQ.1)THEN
C
C      AT THE END OF EACH COMPLETE ITERATION
C
C      L = 1 AND 2 REPRESENT FORE AND AFT SUMMATIONS, RESPECTIVELY
C 
       DO L=1,2
C
C       (II,JJ,KK) LOOPS (RADIUS,AZI,HEIGHT)
C 
        DO KK=KMIN2,KMAX2
         DO JJ=1,JMAXB
          DO II=1,IMAXB
C
C          IF REFLECTIVITY AND DOPPLER VELOCITY EXIST AT (II,JJ,KK) FOR THE FORE
C          OR AFT SCAN, THE WEIGHTED SUM THERE FOR THE FORE OR AFT SCAN IS NORMALIZED 
C          BY THE ACCUMULATED WEIGHT.
C 
           IF(SUMWTSAVE(II,JJ,KK,L).GT.0.AND.
     +       SUMMER(II,JJ,KK,L).GT.0.)THEN
            SUM1(II,JJ,KK,L)=SUM1(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM2(II,JJ,KK,L)=SUM2(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM3(II,JJ,KK,L)=SUM3(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM4(II,JJ,KK,L)=SUM4(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM5(II,JJ,KK,L)=SUM5(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM6(II,JJ,KK,L)=SUM6(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM7(II,JJ,KK,L)=SUM7(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM8(II,JJ,KK,L)=SUM8(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM9(II,JJ,KK,L)=SUM9(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM10(II,JJ,KK,L)=SUM10(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM11(II,JJ,KK,L)=SUM11(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM12(II,JJ,KK,L)=SUM12(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM13(II,JJ,KK,L)=SUM13(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            XWSAVE(II,JJ,KK,L)=XWSAVE(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            YWSAVE(II,JJ,KK,L)=YWSAVE(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            ZWSAVE(II,JJ,KK,L)=ZWSAVE(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            ZE=SUMDBZ(II,JJ,KK,L)/SUMMER(II,JJ,KK,L)
C
C           CONVERT AVERAGE POWER TO DBZ
C 
            SUMDBZ(II,JJ,KK,L)=10.*ALOG10(ZE)
C
C           IF NO DOPPLER VELOCITY AT (II,JJ,KK), BUT REFLECTIVITY EXISTS,
C           COMPUTE AVERAGE REFLECTIVITY. ALL OTHER SUMMATIONS ARE ZERO AT
C           THAT GRID POINT.
C 
           ELSEIF(SUMMER(II,JJ,KK,L).GT.0.)THEN
            ZE=SUMDBZ(II,JJ,KK,L)/SUMMER(II,JJ,KK,L)
            SUMDBZ(II,JJ,KK,L)=10.*ALOG10(ZE)
            SUM1(II,JJ,KK,L)=0
            SUM2(II,JJ,KK,L)=0
            SUM3(II,JJ,KK,L)=0
            SUM4(II,JJ,KK,L)=0
            SUM5(II,JJ,KK,L)=0
            SUM6(II,JJ,KK,L)=0
            SUM7(II,JJ,KK,L)=0
            SUM8(II,JJ,KK,L)=0
            SUM9(II,JJ,KK,L)=0
            SUM10(II,JJ,KK,L)=0
            SUM11(II,JJ,KK,L)=0
            SUM12(II,JJ,KK,L)=0
            SUM13(II,JJ,KK,L)=0
C
C           IF NOTHING EXISTS AT (II,JJ,KK) THEN SUMMATIONS ARE ZERO AND THE 
C           REFLECTIVITY IS FLAGGED.
C 
           ELSE
            SUM1(II,JJ,KK,L)=0
            SUM2(II,JJ,KK,L)=0
            SUM3(II,JJ,KK,L)=0
            SUM4(II,JJ,KK,L)=0
            SUM5(II,JJ,KK,L)=0
            SUM6(II,JJ,KK,L)=0
            SUM7(II,JJ,KK,L)=0
            SUM8(II,JJ,KK,L)=0
            SUM9(II,JJ,KK,L)=0
            SUM10(II,JJ,KK,L)=0
            SUM11(II,JJ,KK,L)=0
            SUM12(II,JJ,KK,L)=0
            SUM13(II,JJ,KK,L)=0
            SUMDBZ(II,JJ,KK,L)=FLAG
           ENDIF
C 
          ENDDO
         ENDDO
        ENDDO     
C 
        WRITE(6,*)'SUM1,SUM2,SUM3,SUMDBZ,SUMWTSAVE = ',
     +  SUM1(1,1,1,L),SUM2(1,1,1,L),SUM3(1,1,1,L),
     +  SUMDBZ(1,1,1,L),SUMWTSAVE(1,1,1,L)
C 
       ENDDO
C 
      ENDIF
C 
      RETURN
      END
C
C  *********************************************************************
C 
      SUBROUTINE VRLOCATE(OLAT,OLON,TIMES,RLAT,RLON,ALT,ELEV,AZIM,
     + RANGE,XR,YR,ZR,SMOTIONU,SMOTIONV,ISCANDIM,CENTIME,XSHFT,YSHFT,
     + RAD,THETA,ISCANMAX)
C
C     SUBROUTINE CALLED BY ABCD
C       
C ... FUNCTION:   
C       
C     THIS SUBROUTINE LOCATES AN OBSERVATION PROPERLY WITHIN THE 
C     INTERPOLATION COORDINATE GRID.
C       
C ... VRLOCATE SUBPROGRAM REFERENCES:      
C       
C          NONE     
C 
C ... IMPORTANT FLAGS: <()> INDICATES DEFAULT
C          
C          NONE
C      
C     VERSION:  <TBD>
C       
C     CODE WRITTEN BY:  JOHN GAMACHE   
C                       HRD/AOML/NOAA          
C                       MIAMI, FL 33149      
C       
C     FOR ADDITIONAL DETAILS ON THE ALGORITHM SEE TBD
C       
C     BASED ON THEORY BY:  <TBD>
C       
C     REFERENCE THE BOOK:  <TBD>
C       
C     **************************************************  
C     *               IMPORTANT NOTE                   *  
C     *                                                *  
C     *                    <TBD>                       *  
C     *                                                *  
C     **************************************************         
C
C     SPECIFICATIONS FOR ARGUMENTS
C 
      INTEGER ISCANDIM,ISCANMAX
      REAL OLAT,OLON,TIMES,RLAT,RLON,ALT,ELEV,AZIM
      REAL SMOTIONU,SMOTIONV,CENTIME,XSHFT,YSHFT
      REAL RANGE(ISCANDIM),XR(ISCANDIM),YR(ISCANDIM),ZR(ISCANDIM)
      REAL RAD(ISCANDIM),THETA(ISCANDIM)
C
C ... DESCRIPTION OF ARGUMENTS
C
C     OLAT,OLON           - LAT,LON OF GRID ORIGIN (STORM CENTER)
C     TIMES               - TIME OF GIVEN RADIAL (S)
C     RLAT,RLON,ALT       - RADAR LAT,LON,ALTITUDE FOR GIVEN RADIAL
C     ELEV                - ELEVATION ANGLE FOR GIVEN RADIAL (EARTH RELATIVE, DEG)
C     AZIM                - AZIMUTH ANGLE FOR GIVEN RADIAL (EARTH RELATIVE, DEG)
C     RANGE               - GATE RANGE FOR GIVEN RADIAL
C     XR,YR,ZR            - (X,Y,Z) DISTANCE OF DATUM FROM GRID ORIGIN (KM)
C     SMOTIONU,SMOTIONV   - STORM MOTION (M/S)
C     ISCANDIM            - RANGE GATE DIMENSION OF ARRAYS 
C     CENTIME             - ANALYSIS TIME (S)
C     XSHFT,YSHFT         - ZERO BY DEFAULT IN R-THETA INTERPOLATION
C     RAD                 - DISTANCE OF DATUM FROM GRID ORIGIN (KM)
C     THETA               - ANGLE DATUM MAKES WITH POSITIVE X AXIS
C     ISCANMAX            - MAX NUMBER OF RANGE GATES INCLUDED
C
C     SPECIFICATIONS FOR LOCAL VARIABLES 
C 
      INTEGER I
      REAL RALT,PI,DTR,REARTH,TDIFF,XSHIFT,YSHIFT,RAZIM,RELEV
      REAL XRADAR,YRADAR,RADNEW,DELANGLE,DISTANCE,HEIGHT
      REAL DELX,DELY,XLAT,DX,DY
C 
      PI=ASIN(1.0)*2.
      DTR=PI/180.
      REARTH=6366.
C 
C     RADAR ALTITUDE IN KM
C 
      RALT=ALT/1000.
C 
C ... COMPUTE X AND Y DISPLACEMENT (KM) BASED ON STORM MOTION 
C     AND DEPARTURE FROM ANALYSIS TIME. FOR EXAMPLE, STORM IS MOVING
C     DUE EAST AND THE OBS IS MADE 10 MIN AFTER CENTIME...XSHIFT>0
C 
      TDIFF=TIMES-CENTIME
      XSHIFT=TDIFF*SMOTIONU/1000.
      YSHIFT=TDIFF*SMOTIONV/1000.     
C 
C     AZIMUTH AND ELEVATION ANGLES IN RADIANS
C 
      RAZIM=AZIM*DTR
      RELEV=ELEV*DTR
C 
C     (I) LOOPS (GATES)
C 
      DO I=1,ISCANMAX
C
C      XRADAR/YRADAR IS HORIZONTAL/VERTICAL DISTANCE FROM AIRCRAFT.
C      YRADAR INCLUDES DISTANCE FROM CENTER OF EARTH TO AIRCRAFT.
C      RELEV=90 WOULD HAVE NO HORIZ. PROJECTION.
C 
       XRADAR=RANGE(I)*COS(RELEV)
       YRADAR=REARTH+RALT+RANGE(I)*SIN(RELEV)
C
C      RADNEW IS DISTANCE OF DATUM FROM CENTER OF EARTH
C 
       RADNEW=SQRT(XRADAR*XRADAR+YRADAR*YRADAR)
C
C      DELANGLE IS ANGLE BETWEEN VERTICAL AT AIRCRAFT AND VERTICAL AT DATUM
C 
       DELANGLE=ATAN(XRADAR/YRADAR)
C
C      DISTANCE IS GREAT CIRCLE DISTANCE FROM RADAR TO DATUM
C 
       DISTANCE=.5*(RADNEW+(REARTH+RALT))*DELANGLE
C
C      HEIGHT IS ALTITUDE OF DATUM
C 
       HEIGHT=RADNEW-REARTH
C
C      DELX/DELY IS EAST-WEST/NORTH-SOUTH COMPONENT OF AIRCRAFT-DATUM GREAT CIRCLE DISTANCE 
C 
       DELX=DISTANCE*SIN(RAZIM)
       DELY=DISTANCE*COS(RAZIM)
C
C      DX/DY IS EAST-WEST/NORTH-SOUTH DISTANCE FROM GRID ORIGIN TO AIRCRAFT
C 
       XLAT=.5*(RLAT+OLAT)*DTR
       DX=(RLON-OLON)*DTR*REARTH*COS(XLAT)
       DY=(RLAT-OLAT)*DTR*REARTH
C
C      XR/YR IS COMPONENT DISTANCE OF DATUM FROM GRID ORIGIN:
C      X/YSHFT + (DELX/Y + DX/Y) --> GRID ORIGIN TO DATUM DISTANCE
C      SUBTRACTING X/YSHIFT ADVECTS DATUM TO CENTIME USING STORM MOTION.
C 
       XR(I)=DELX+DX-XSHIFT+XSHFT
       YR(I)=DELY+DY-YSHIFT+YSHFT
       ZR(I)=HEIGHT
C 
C      RAD IS DISTANCE OF DATUM FROM GRID ORIGIN
C      THETA IS ANGLE DATUM MAKES WITH POSITIVE X AXIS
C 
       RAD(I)=SQRT(XR(I)*XR(I)+YR(I)*YR(I))
       THETA(I)=ATAN2(YR(I),XR(I))*180./3.14159
       IF(THETA(I).GT.360.)THETA(I)=THETA(I)-360.
       IF(THETA(I).LT.0.)THETA(I)=THETA(I)+360.
C 
      ENDDO
C 
      CONTINUE
      END
