	Subroutine WritePSVar(panel)

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer panel

C Open the output file
	Open (unit=95,file=output_name,status='unknown')

C This subroutine writes out the variables utilized in the PostScript file
        Write (95,10) '%!PS'
10	Format (A)
        Write (95,*) 
     +	 '%80 45 {180 mul cos exch 180 mul cos add 2 div} setscreen'
        Write (95,*)'%********************'
	Write (95,*)'% DEFINE VARIABLES'
        Write (95,*)'%********************'
C Shorten PostScript commands
	Call ShortCom
C Write cm def
	Call WriteCm
C Write xkm,ykm,zkm
	Call WriteKm
C Write sp_horiz_text,sp_vert_text,sp_scale
	Call WriteSpText
C Write num_ht, title_ht, label_ht, num_w 
	Call WriteTextHt
C Write scale_w,scale_h
*	IF (plot_type.NE.1) THEN
	 Call WriteScaleDim
*	ENDIF
C Write l_marg, r_marg, t_marg, b_marg
	Call WriteMarg
C Write page_w,page_h
	Call WritePageDim
C Write box_w,box_h
	Call WriteBoxDim
C Write sp_row, sp_col
        Call WriteSubRowCol
C Write xpos1,ypos1..xposn,yposn
	Call WritePos(panel)
C Write previous box height & width to use for next plot
	Call WritePosPrev(panel)
C Write pri_grid1,pri_grid2,sec_grid1,sec_grid2
	Call WriteGridVar
C Write shift_horiz,shift_verg
	Call WriteShift

	Return
	End
**************************************************
C Subroutines to write PostScript variables
**************************************************
	Subroutine ShortCom 

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Write (95,*)'% SHORTEN COMMANDS'
	Write (95,10)
10	Format ('/l {lineto} def')
	Write (95,11)
11	Format ('/m {moveto} def')
	Write (95,12)
12	Format ('/gs {gsave} def')
	Write (95,13)
13	Format ('/gr {grestore} def')
	Write (95,14)
14	Format ('/c {closepath} def')
	Write (95,15)
15	Format ('/f {fill} def')
	Write (95,16)
16	Format ('/a {arrow} def')
	
	Return
	End
**************************************************
	Subroutine WriteKm

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

C Write km definition
	Write (95,*)'% DEFINE KM'
	IF (fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') THEN
	 Write (95,10)xkm,ykm
10	 Format ('/xkm {',F8.4,' cm mul} def',5X,
     +		'/ykm {',F8.4,' cm mul} def')
	ELSEIF (fix_axis.EQ.'Y'.OR.fix_axis.EQ.'y') THEN
	 Write (95,11)xkm,zkm
11	 Format ('/xkm {',F8.4,' cm mul} def',5X,
     +		'/zkm {',F8.4,' cm mul} def')
	ELSEIF (fix_axis.EQ.'X'.OR.fix_axis.EQ.'x') THEN
	 Write (95,12)ykm,zkm
12	 Format ('/ykm {',F8.4,' cm mul} def',5X,
     +		'/zkm {',F8.4,' cm mul} def')
	ENDIF

	Return
	End
**************************************************
	Subroutine WriteCm

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

C Write cm definition
	Write (95,*)'% DEFINE CM'
	Write(95,10)
10	Format('/cm {28.346457 mul} def')

	Return
	End
**************************************************
	Subroutine WriteSpText

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

C space between text
	Write (95,*)'% SPACE BETWEEN TEXT & GRID'
	Write (95,10)sp_horiz_text,sp_vert_text
10	Format (F6.2,' cm /sp_horiz_text exch def',5X,
     $   F6.2,' cm /sp_vert_text exch def')
	Write (95,*)'% SPACE BETWEEN TEXT & SCALE'
	IF (plot_type.EQ.1) THEN
	 Write (95,11)
11	 Format ('0/sp_scale exch def')
	ELSE
	 Write (95,12)sp_scale
12	 Format (F6.2,' cm/sp_scale exch def')
	ENDIF

	Return
	End
**************************************************
	Subroutine WriteTextHt

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

C space for title,label, and numbers
	Write (95,*)'% HEIGHT OF TEXT (BASED ON FONT SIZE)'
	Write (95,10)title_ht,label_ht
10	Format(F6.2,' cm/title_ht exch def',5X,
     $  F6.2,' cm/label_ht exch def')
	Write (95,11) num_ht,num_w
11	Format (F6.2,' cm/num_ht exch def',5X,
     +		F6.2,' cm/num_w exch def')

	Return
	End
**************************************************
	Subroutine WriteScaleDim

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	IF (plot_type.EQ.1) THEN
	 Write (95,*)'% WIDTH & HEIGHT OF SCALE PARTITION'
	 Write (95,10)
10	 Format ('0/scale_w exch def',5X,'0/scale_h exch def')
	ELSEIF (plot_type.GT.1) THEN
	 Write (95,*)'% WIDTH & HEIGHT OF SCALE PARTITION'
	 Write (95,20) scale_w,scale_h
20	 Format (F6.2,' cm/scale_w exch def',5X,
     +		F6.2,' cm/scale_h exch def')
	 Write (95,21) num_box 
21	 Format(I2,' /num_box exch def')
	 Write (95,22)
22	 Format ('scale_h num_box div /scale_box_h exch def')
	ENDIF

	Return
	End
**************************************************
	Subroutine WriteMarg

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

C Margins
	Write (95,*)'% MARGINS'
	Write (95,10)l_marg,r_marg
10	Format(F6.2,' cm/l_marg exch def',5X,
     +		F6.2,' cm/r_marg exch def')
	Write (95,11)t_marg,b_marg
11	Format(F6.2,' cm/t_marg exch def',5X,
     +		F6.2,' cm/b_marg exch def')

	Return
	End
**************************************************
	Subroutine WritePageDim

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

C Write dimensions of page
	Write (95,*)'% PAGE DIMENSIONS'
	Write (95,10)page_w,page_h
10	Format(F6.2,' cm/page_w exch def',5X,F6.2,' cm/page_h exch def')
	
	Return
	End
**************************************************
	Subroutine WriteBoxDim

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

C Write dimensions of box 
	Write (95,*)'% BOX DIMENSIONS'
	Write (95,10)box_w,box_h
10	Format(F6.2,' cm/box_w exch def',5X,
     +		F6.2,' cm/box_h exch def')
	
	Return
	End
**************************************************
	Subroutine WritePosPrev(panel)

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer panel

C Only adjust one column
	IF (panel.EQ.1) THEN
	 Write (95,*)'%STORE BOX_H & BOX_W'
	 Write (95,*)'box_h/prev_boxh exch def'
	 Write (95,*)'box_w/prev_boxw exch def'
	ENDIF
	
	Return
	End
**************************************************
	Subroutine WritePos(panel)

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer panel

C sprow & spcol are temp values
*	Write (95,10)sp_row,sp_col
*10	Format(F6.2,' cm/sprow exch def',5X,F6.2,' cm/spcol exch def')
	Write (95,10)sp_row
10	Format('/sprow {',F6.2,
     +		' cm sp_horiz_text add label_ht add} def')
	Write (95,11)sp_col
11	Format('/spcol {',F6.2,
     +		' cm sp_vert_text 2 mul add label_ht add} def')

C If the first panel, then use box dimensions, else use previous box dim 
**************************************************
**************************************************
	IF (panel.EQ.1) THEN
C Write position variables
	Write (95,*)'% POSITION VARIABLES (panel eq 1)'
COUT debug 	write(6,*)'Debug. Template = ',template
COUT debug	pause
	IF (template.GE.1.AND.template.LE.13) THEN
	 Write (95,20)xpos1,ypos1
20	 Format(F6.2,' cm/xpos1 exch def',5X,F6.2,' cm/ypos1 exch def')
	ENDIF
	IF (template.GE.2.AND.template.LE.5) THEN
	 Write (95,*) 'xpos1/xpos2 exch def'
	 Write (95,*) 'ypos1 box_h add sp_horiz_text add '
     	 write(95,*)' label_ht add sprow add/ypos2 exch def'
 	ENDIF
	IF (template.GE.3.AND.template.LE.5) THEN
	 Write (95,*) 'xpos1/xpos3 exch def'
	 Write (95,*) 'ypos2 box_h add sp_horiz_text add '
     	 write(95,*) 'label_ht add sprow add/ypos3 exch def'
	ENDIF
	IF (template.GE.4.AND.template.LE.5) THEN
	 Write (95,*) 'xpos1/xpos4 exch def'
	 Write (95,*) 'ypos3 box_h add sp_horiz_text add ' 
     	 write(95,*)  ' label_ht add sprow add/ypos4 exch def'
	ENDIF
	IF (template.EQ.5) THEN
	 Write (95,*) 'xpos1/xpos5 exch def'
	 Write (95,*) 'ypos4 box_h add sp_horiz_text add '
     	 write (95, *)' label_ht add sprow add/ypos5 exch def'
	ENDIF
*************************
	IF ((template.GE.6.AND.template.LE.10).OR.template.GE.12) THEN
	 Write (95,*)'xpos1 box_w add spcol add label_ht add'
     	 write(95,*)' sp_vert_text 2 mul add/xpos2 exch def'
	 Write (95,*)'ypos1/ypos2 exch def'
	ENDIF
	IF ((template.GE.7.AND.template.LE.10).OR.template.EQ.13) THEN
	 Write (95,*)'xpos1/xpos3 exch def'
	 Write (95,*) 'ypos1 box_h add sp_horiz_text add '
	 write (95,*) ' label_ht add sprow add/ypos3 exch def'
	 Write (95,*)'xpos2/xpos4 exch def'
	 Write (95,*)'ypos3/ypos4 exch def'
	ENDIF
	IF (template.GE.8.AND.template.LE.10) THEN
	 Write (95,*)'xpos1/xpos5 exch def'
	 Write (95,*) 'ypos3 box_h add sp_horiz_text add '
	 write (95, *) ' label_ht add sprow add/ypos5 exch def'
	 Write (95,*)'xpos2/xpos6 exch def'
	 Write (95,*)'ypos5/ypos6 exch def'
	ENDIF
	IF (template.GE.9.AND.template.LE.10) THEN
	 Write (95,*)'xpos1/xpos7 exch def'
	 Write (95,*) 'ypos5 box_h add sp_horiz_text add '
	 write(95,*) ' label_ht add sprow add/ypos7 exch def'
	 Write (95,*)'xpos2/xpos8 exch def'
	 Write (95,*)'ypos7/ypos8 exch def'
	ENDIF
	IF (template.EQ.10) THEN
	 Write (95,*)'xpos1/xpos9 exch def'
	 Write (95,*) 'ypos7 box_h add sp_horiz_text add '
	 write (95,*) ' label_ht add sprow add/ypos9 exch def'
	 Write (95,*)'xpos2/xpos10 exch def'
	 Write (95,*)'ypos9/ypos10 exch def'
	ENDIF
*************************
	IF (plot_type.NE.1) THEN
C Write the horizontal & vertical position of the scale
C Calculate the horizontal position of the scale
	 Write (95,*)'%SCALE POSITION VARIABLES'
	 IF (scale_pos.EQ.'VER') THEN
C Horizontal position of the scale
	  IF ((template.GE.1.AND.template.LE.5).OR.template.EQ.11) THEN
	   Write (95,*)
     +		'xpos1 box_w add sp_scale add/scale_posx exch def'
	  ELSEIF ((template.GE.6.AND.template.LE.10).OR
     $     .template.EQ.12.OR.template.EQ.13) THEN
	   Write (95,*)
     +		'xpos2 box_w add sp_scale add/scale_posx exch def'
	  ENDIF
C Vertical position of the scale
	  IF (template.EQ.1.OR.template.EQ.6.OR
     $    .template.EQ.11.OR.template.EQ.12) THEN
	   Write (95,*)'ypos1 box_h 2 div add scale_h 2 div sub'
     	   write(95,*)' /scale_posy exch def'
	  ELSEIF (template.EQ.2.OR.template.EQ.7.OR.template.EQ.13) THEN
	   Write (95,*)'ypos1 box_h add sp_row 2 div add scale_h '
           write(95,*)'2 div sub/scale_posy exch def'
	  ELSEIF (template.EQ.3) THEN
	   Write (95,*)'ypos2 box_h 2 div add scale_h '
           write(95,*)' 2 div sub/scale_posy exch def'
	  ELSEIF (template.EQ.4) THEN
	   Write (95,*)'ypos2 box_h add sp_row 2 div add scale_h '
           write(95,*)' 2 div sub/scale_posy exch def'
	  ELSEIF (template.EQ.5) THEN
	   Write (95,*)'ypos3 box_h 2 div add scale_h '
     	   write(95,*)' 2 div sub/scale_posy exch def'
	  ELSEIF (template.EQ.8) THEN
	   Write (95,*)'ypos3 box_h 2 div add scale_h '
	   write(95,*)' 2 div sub/scale_posy exch def'
	  ELSEIF (template.EQ.9) THEN
	   Write (95,*)'ypos3 box_h add sp_row 2 div add scale_h '
           write(95,*)' 2 div sub/scale_posy exch def'
	  ELSEIF (template.EQ.10) THEN
	   Write (95,*)'ypos5 box_h 2 div add scale_h '
           write(95,*)'2 div sub/scale_posy exch def'
	  ENDIF
	 ELSEIF (scale_pos.EQ.'HOR') THEN
C Horizontal position of the scale
	  IF ((template.GE.1.AND.template.LE.5).OR.template.EQ.11) THEN
	   Write (95,*)'xpos1 box_w 2 div add scale_h 2 div sub '
           write(95,*)' /scale_posx exch def'
	  ELSEIF ((template.GE.6.AND.template.LE.10).OR
     $    .template.EQ.12.OR.template.EQ.13) THEN
	   Write (95,*)
     +		'xpos1 box_w add sp_col 2 div add scale_h 2 div sub'
     	   write(95,*)' /scale_posx exch def'
	  ENDIF
C Vertical position of the scale
	  Write (95,*)'ypos1 sp_horiz_text 2 mul sub sp_scale sub '
     	write(95,*)
     +		'num_ht 2 mul sub label_ht sub /scale_posy exch def'
	 ENDIF
	ENDIF
	ENDIF
**************************************************
**************************************************
	IF (panel.NE.1) THEN
C Write position variables
	Write (95,*)'% POSITION VARIABLES (Panel ne 1)'
	IF (template.GE.1.AND.template.LE.13) THEN
	 Write (95,30)xpos1,ypos1
30	 Format(F6.2,' cm/xpos1 exch def',5X,F6.2,' cm/ypos1 exch def')
	ENDIF
	IF (template.GE.2.AND.template.LE.5) THEN
	 Write (95,*) 'xpos1/xpos2 exch def'
	 Write (95,*) 'ypos1 prev_boxh add sp_horiz_text add'
     	 write(95,*)'  label_ht add sprow add/ypos2 exch def'
 	ENDIF
	IF (template.GE.3.AND.template.LE.5) THEN
	 Write (95,*) 'xpos1/xpos3 exch def'
	 Write (95,*) 'ypos2 prev_boxh add sp_horiz_text add '
     	 write(95,*)' label_ht add sprow add/ypos3 exch def'
	ENDIF
	IF (template.GE.4.AND.template.LE.5) THEN
	 Write (95,*) 'xpos1/xpos4 exch def'
	 Write (95,*) 'ypos3 prev_boxh add sp_horiz_text add '
     	 write(95,*)' label_ht add sprow add/ypos4 exch def'
	ENDIF
	IF (template.EQ.5) THEN
	 Write (95,*) 'xpos1/xpos5 exch def'
                                                                       
	 Write (95,*) 'ypos4 prev_boxh add sp_horiz_text add '
         write(95,*)' label_ht add sprow add/ypos5 exch def'
	ENDIF
*************************
	IF ((template.GE.6.AND.template.LE.10).OR.template.GE.12) THEN
	 Write (95,*)'xpos1 prev_boxw add spcol add label_ht add '
         write(95,*)' sp_vert_text 2 mul add/xpos2 exch def'
	 Write (95,*)'ypos1/ypos2 exch def'
	ENDIF
	IF ((template.GE.7.AND.template.LE.10).OR.template.EQ.13) THEN
	 Write (95,*)'xpos1/xpos3 exch def'
	 Write (95,*) 'ypos1 prev_boxh add sp_horiz_text add'
         write(95,*)'  label_ht add  sprow add/ypos3 exch def'
	 Write (95,*)'xpos2/xpos4 exch def'
	 Write (95,*)'ypos3/ypos4 exch def'
	ENDIF
	IF (template.GE.8.AND.template.LE.10) THEN
	 Write (95,*)'xpos1/xpos5 exch def'
	 Write (95,*) 'ypos3 prev_boxh add sp_horiz_text add '
     	 write(95,*)'  label_ht add sprow add/ypos5 exch def'
	 Write (95,*)'xpos2/xpos6 exch def'
	 Write (95,*)'ypos5/ypos6 exch def'
	ENDIF
	IF (template.GE.9.AND.template.LE.10) THEN
	 Write (95,*)'xpos1/xpos7 exch def'
	 Write (95,*) 'ypos5 prev_boxh add sp_horiz_text add'
         write(95,*)'  label_ht add  sprow add/ypos7 exch def'
	 Write (95,*)'xpos2/xpos8 exch def'
	 Write (95,*)'ypos7/ypos8 exch def'
	ENDIF
	IF (template.EQ.10) THEN
	 Write (95,*)'xpos1/xpos9 exch def'
	 Write (95,*) 'ypos7 prev_boxh add sp_horiz_text add ' 
         write(95,*)' label_ht add sprow add/ypos9 exch def'
	 Write (95,*)'xpos2/xpos10 exch def'
	 Write (95,*)'ypos9/ypos10 exch def'
	ENDIF
*************************
	IF (plot_type.NE.1) THEN
C Write the horizontal & vertical position of the scale
C Calculate the horizontal position of the scale
	 Write (95,*)'%SCALE POSITION VARIABLES'
	 IF (scale_pos.EQ.'VER') THEN
C Horizontal position of the scale
	  IF ((template.GE.1.AND.template.LE.5).OR.template.EQ.11) THEN
	   Write (95,*)
     +		'xpos1 prev_boxw add sp_scale add/scale_posx exch def'
	  ELSEIF ((template.GE.6.AND.template.LE.10).OR
     $     .template.EQ.12.OR.template.EQ.13) THEN
	   Write (95,*)
     +		'xpos2 prev_boxw add sp_scale add/scale_posx exch def'
	  ENDIF
C Vertical position of the scale
	  IF (template.EQ.1.OR.template.EQ.6.OR
     $    .template.EQ.11.OR.template.EQ.12) THEN
	   Write (95,*)'ypos1 prev_boxh 2 div add scale_h '
          write(95,*)' 2 div sub /scale_posy exch def'
	  ELSEIF (template.EQ.2.OR.template.EQ.7.OR.template.EQ.13) THEN
	   Write (95,*)'ypos1 prev_boxh add sp_row 2 div '
	   write(95,*)' add scale_h 2 div sub/scale_posy exch def'
	  ELSEIF (template.EQ.3) THEN
	   Write (95,*)'ypos2 prev_boxh 2 div add scale_h '
           write(95,*) ' 2 div sub/scale_posy exch def'
	  ELSEIF (template.EQ.4) THEN
	   Write (95,*)'ypos2 prev_boxh add sp_row 2 div '
	   write(95,*) ' add scale_h 2 div sub/scale_posy exch def'
	  ELSEIF (template.EQ.5) THEN
	   Write (95,*)'ypos3 prev_boxh 2 div add scale_h '
           write(95,*)' 2 div sub/scale_posy exch def'
	  ELSEIF (template.EQ.8) THEN
	   Write (95,*)'ypos3 prev_boxh 2 div add scale_h '
           write(95,*)' 2 div sub/scale_posy exch def'
	  ELSEIF (template.EQ.9) THEN
	   Write (95,*)'ypos3 prev_boxh add sp_row 2 div'
	   write(95,*)' add scale_h 2 div sub/scale_posy exch def'
	  ELSEIF (template.EQ.10) THEN
	   Write (95,*)'ypos5 prev_boxh 2 div add scale_h'
     	   write (95,*)' 2 div sub/scale_posy exch def'
	  ENDIF
	 ELSEIF (scale_pos.EQ.'HOR') THEN
C Horizontal position of the scale
	  IF ((template.GE.1.AND.template.LE.5).OR.template.EQ.11) THEN
	   Write (95,*)'xpos1 prev_boxw 2 div add scale_h 2 div sub ',
     $     '/scale_posx exch def'
	  ELSEIF ((template.GE.6.AND.template.LE.10).OR
     $    .template.EQ.12.OR.template.EQ.13) THEN
	   Write (95,*)'xpos1 prev_boxw add sp_col 2 div add scale_h ',
     $ '2 div sub/scale_posx exch def'
	  ENDIF
C Vertical position of the scale
	  Write (95,*)'ypos1 sp_horiz_text 2 mul sub sp_scale sub ',
     $   'num_ht 2 mul sub label_ht sub /scale_posy exch def'
	 ENDIF
	ENDIF
	ENDIF
**************************************************
**************************************************

	Return
	End
**************************************************
	Subroutine WriteGridVar

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Write (95,*)'% GRID TICK MARKS: GRID1=HORIZONTAL GRID2=VERTICAL'
	IF (fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') THEN
	 Write (95,10)pri_grid1,pri_grid2
10	 Format(I2,' xkm/pri_grid1 exch def',5X,
     +		I2,' ykm/pri_grid2 exch def')
	 Write (95,11)sec_grid1,sec_grid2
11	 Format(I2,' xkm/sec_grid1 exch def',5X,
     +		I2,' ykm/sec_grid2 exch def')
	ELSEIF (fix_axis.EQ.'Y'.OR.fix_axis.EQ.'y') THEN
	 Write (95,12)pri_grid1,pri_grid2
12	 Format(I2,' xkm/pri_grid1 exch def',5X,
     +		I2,' zkm/pri_grid2 exch def')
	 Write (95,13)sec_grid1,sec_grid2
13	 Format(I2,' xkm/sec_grid1 exch def',5X,
     +		I2,' zkm/sec_grid2 exch def')
	ELSEIF (fix_axis.EQ.'X'.OR.fix_axis.EQ.'x') THEN
	 Write (95,14)pri_grid1,pri_grid2
14	 Format(I2,' ykm/pri_grid1 exch def',5X,
     +		I2,' zkm/pri_grid2 exch def')
	 Write (95,15)sec_grid1,sec_grid2
15	 Format(I2,' ykm/sec_grid1 exch def',5X,
     +		I2,' zkm/sec_grid2 exch def')
	ENDIF

	Return
	End
**************************************************
	Subroutine WriteShift

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'
	
        Character*3 temp_hkm,temp_vkm

        IF (fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') THEN
         temp_hkm='xkm'
         temp_vkm='ykm'
        ELSEIF (fix_axis.EQ.'Y'.OR.fix_axis.EQ.'y') THEN
         temp_hkm='xkm'
         temp_vkm='zkm'
        ELSEIF (fix_axis.EQ.'X'.OR.fix_axis.EQ.'x') THEN
         temp_hkm='ykm'
         temp_vkm='zkm'
        ENDIF

	Write (95,10)shift_horiz,temp_hkm,shift_vert,temp_vkm
10	Format(F6.2,1X,A,'/shift_horiz exch def',5X,
     $ F6.2,1X,A,'/shift_vert exch def')

	Return
	End
**************************************************
        Subroutine WriteSubRowCol

        Implicit none
        Include 'common1.h'
        Include 'common2.h'
        Include 'common3.h'

        Write (95,*)'% DEFINE SPACE BETWEEN COLUMNS & ROWS'
        Write (95,10)
10      Format('/sp_row {sp_horiz_text 3 mul num_ht add label_ht ',
     $'2 mul add sprow add} def')
        Write (95,11)
11      Format ('/sp_col {sp_horiz_text 3 mul num_w add label_ht ',
     $'2 mul add spcol add } def')

        Return
        End

