	subroutine wedgint(y0,rad,xc,yc,phi1,phi2,x1,x2,nints)
C This subroutine finds the the intersection of the line y=y0 
C and the wedge with formed by two rays with center
C (xc, yc), length rad, and angles 
C from phi1 to phi2, where the angles are math (increasing
C counterclockwise) and in radians. We assume the wedge is
C 90 degrees or less, so any line intersects at most twice. 
C the x intersections are returned as x1,x2. Nints is the 
C # of intersections. If nints =1, then x1 is the only intersection.
C Note: x in {x',x"} iff (x-x')*(x-x")<0, regardless of ordering of x',x" 
C that fact used to figure where things are.
      dimension x(2)
C 
      nints=0 
C 
      arg = rad*rad - (yc-y0)**2
      if(arg.lt.0)then ! out of bounds
              nints=0 
              return
      endif 
C first ray:
      sinang=sin(phi1)
      cosp1=cos(phi1) 
      yedge1=yc + rad*sinang ! end of ray 
      xedge1= xc + rad*cosp1
      if( ((y0-yc)*(y0-yedge1)) .lt. 0.0 )then ! intersects ray, usual case 
              nints=1 
              x(1)=(y0-yc)*cosp1/sinang + xc
      else if(sinang.eq.0)then ! parallel. Do ray and scanline coincide?
        if(yc .eq. y0)then
              if(cosp1.lt.0)then ! leftward pointing
                x1 = xc - rad 
                x2 = xc
              else
                x1 = xc
                x2 = xc + xrad
              endif 
              nints=2 
              return
        endif 
      else if(y0 .eq. yc)then ! scanline only intersects vertex 
              nints=1 
              x(1)=xc
      else if(y0 .eq. yedge1)then ! scanline only intersects tip of ray 
		nints = 1
		x(1)=xedge1 
      endif 
C second ray: (code the same except now worry about # of intersections) 
      sinang = sin(phi2)
      cosp2 = cos(phi2) 
      yedge2 = yc + rad * sinang
      xedge2 = xc + rad * cosp2 
      if( ((y0-yc) * (y0-yedge2)) .lt. 0.0)then ! does intersect ray
              nints = nints + 1 
              x(nints) = (y0-yc) * cosp2/sinang + xc
      else if(sinang.eq.0)then ! parallel. Do they coincide?
        if(yc .eq. y0)then
              if(cosp2.lt.0)then ! points to left 
                x1 = xc - rad 
                x2 = xc
              else
                x1 = xc
                x2 = xc + xrad
              endif 
              nints=2 
              return
        endif 
      else if( y0 .eq. yedge2 )then 
              nints = nints + 1 
              x(nints) = xedge2 
      endif 
C for thin wedges the usual case will be two intersections with 
C the two rays. However there will be times when the scanline intersects
C the arc in one or two places. 
      if(nints.lt.2)then
        root=sqrt(arg)
        if((cosp1*cosp2).gt.0)then ! falls entirely to left or right of y axis
          if( ((y0-yedge1)*(y0-yedge2)) .lt. 0.0)then 
              nints=nints+1 
              x(nints)=xc+sign(root,cosp1)
          endif 
        else ! straddles 90 or 270... may have two ints 
              if( ((y0-yedge1)*(y0-yedge2)) .gt. 0.0)then ! two ints
                if((y0-yc)*sinang.gt.0)then   ! since above or below ray tips 
                  nints=2 
                  x1=xc+root
                  x2=xc-root
                  return
                endif 
              else ! well which intersection with circle is it? 
                  xarc=xc+root
                  nints=nints+1 
                  if(((xarc-xedge1)*(xarc-xedge2)).lt.0.0)then
                           x(nints)=xarc
                  else
                           x(nints)=xc-root 
                  endif 
              endif 
        endif 
      endif 
C correct ordering of x1 and x2 so x1 is left of x2:
      if(nints.eq.2)then
              x1=x(1) 
              x2=x(2) 
              if(x1.gt.x2)then
                           t=x1 
                           x1=x2
                           x2=t 
              endif 
      else
              x1=x(1) 
              x2=x1 ! for drawing one point lines 
      endif 
      return
      end 

 



