      subroutine wclip(xb, yb, xe, ye, w, vis, ic_code)
C Two-dimensional clipping in real numbers. 
C Line {(xb,yb),(xe,ye)} is clipped to the window 
C with lower left corner(w(1),w(2)) and upper right 
C corner (w(3),w(4)). Note that the orientation of
C the line does not change since beg and end are
C never swapped.
      dimension w(4)
      logical vis 
      ic1=inside(xb,yb,w) 
      ic2=inside(xe,ye,w) 
      if(iand(ic1,ic2).ne.0) then !segment outside window 
              vis=.false. 
		ic_code = -1
              return
      else if((ic1+ic2).eq.0) then ! segment completely inside 
              vis=.true.
		ic_code = 0
              return
      endif 
	ic_code = 1 ! means we had to trim something
C following code from PICG by Newman and Sproull :
      vis=.true.
      delx=xe-xb
      dely=ye-yb
      do k=1,4 !should take at most 4 clips 
              ic=ic1
              if(ic.eq.0)ic=ic2 
              if((ic1+ic2).eq.0)then !done
                           return 
              else if(iand(ic1,ic2).ne.0)then 
                           vis=.false. !remainig seg is outside 
              endif 
              if(iand(ic,1).eq.1)then !crosses left
                           x=w(1) 
                           y=(dely/delx)*(w(1)-xb)+yb 
              else if(iand(ic,2).eq.2)then !crosses right
                           x=w(3) 
                           y=(dely/delx)*(w(3)-xb)+yb 
              else if(iand(ic,4).eq.4)then ! crosses bottom 
                           y=w(2) 
                           x=(delx/dely)*(w(2)-yb)+xb 
              else  ! crosses the top 
                           y=w(4) 
                           x=(delx/dely)*(w(4)-yb)+xb 
              endif 
              if(ic.eq.ic1)then 
                           xb=x 
                           yb=y 
                           ic1=inside(x,y,w)
              else
                           xe=x 
                           ye=y 
                           ic2=inside(x,y,w)
              endif 
      end do
      return
      end 
C*************************
      function inside(pointx,pointy,w)
C Returns a location code for point, relative to window.
C Lower left corner of window is (w(1),w(2)), upper right 
C is (w(3),w(4)). 
C     1001/9  1000/8  1010/10    above the window 
C     0001/1  0000/0  0010/2     left,window,right
C     0101/5  0100/4  0110/6     below the window 
      dimension w(4)
      inside=0
      if(pointx.lt.w(1))then
              inside=inside+1 
      else if(pointx.gt.w(3))then 
              inside=inside+2 
      endif 
      if(pointy.lt.w(2))then
              inside=inside+4 
      else if(pointy.gt.w(4))then 
              inside=inside+8 
      endif 
      return
      end 

