      SUBROUTINE VARUNFLD(SWEEP,MAX_GATES,NBINS,MAX_RAYS,
     1 RDTAI,AZ_EL,NUM_RAYS,VRRAD,PAZM,XXNIQ)
C SWEEP--Radial velocities with projection of aircraft motion removed
C MAX_GATES--Dimensioning parameter for storage of VR in radial direction
C NBINS--Actual number of radial bins available for each VR
C MAX_RAYS--Dimensioning parameter for max number of radials in a sweep
C RDTAI--Radius in km of radial velocity from aircraft
C AZ_EL--Azimuth and elevation relative to the track of the aircraft
C NUM_RAYS--Actual number of rays in the sweep
C VRRAD--Projection of background (guess) wind field on to radials
C IUSEWIND
C PAZM
      PARAMETER(NZ=10000000,NN=409600,NW=2500000)
      REAL SWEEP(MAX_GATES,MAX_RAYS),RDTAI(MAX_GATES)
      REAL AZ_EL(2,MAX_RAYS),VRRAD(MAX_GATES,MAX_RAYS)
      REAL PAZM(MAX_RAYS)
      INTEGER INDEX1(NN),INDEX2(NN),INDEX4(NN),INDEX5(NN)
      INTEGER IA(NN),JA(NZ),IWORK(NZ)
      DOUBLE PRECISION M(NZ),RHS(NN),WORK(NW)
      COMMON /VARUN/M,IWORK,JA,WORK
c      WRITE(6,*)'RDTAI = ',RDTAI
      WRITE(6,*)'CALLING SPARSEVAR'
      CALL SPARSEVAR(SWEEP,MAX_GATES,NBINS,MAX_RAYS,
     1 RDTAI,AZ_EL,NUM_RAYS,VRRAD,PAZM,M,RHS,INDEX1,INDEX2,INDEX4,IPOS,
     1 IA,JA,IWORK,INDEX5)
      WRITE(6,*)'CALLING SOLVESPARSE'
      CALL SOLVESPARSE(SWEEP,VRRAD,MAX_GATES,MAX_RAYS,IPOS,M,RHS,
     1 INDEX1,INDEX2,INDEX4,IA,JA,IWORK,INDEX5,XXNIQ,AZ_EL,WORK)
c      WRITE(6,*)SWEEP
      RETURN
      END
      SUBROUTINE SPARSEVAR(SWEEP,MAX_GATES,NBINS,MAX_RAYS,
     1 RDTAI,AZ_EL,NUM_RAYS,VRRAD,PAZM,M,RHS,INDEX1,INDEX2,INDEX4,IPOS,
     1 IA,JA,IWORK,INDEX5)
      PARAMETER(NZ=10000000,NW=2500000)
      REAL SWEEP(MAX_GATES,MAX_RAYS)
      REAL RDTAI(MAX_GATES),AZ_EL(2,MAX_RAYS)
      REAL VRRAD(MAX_GATES,MAX_RAYS),PAZM(MAX_RAYS)
      REAL DVRADR(MAX_GATES,MAX_RAYS),DVRADAZM(MAX_GATES,MAX_RAYS)
      INTEGER INDEX1(409600),INDEX2(409600),INDEX4(MAX_GATES,MAX_RAYS)
      INTEGER INDEX5(MAX_GATES,MAX_RAYS)
      INTEGER INDEXNN(15)
      DOUBLE PRECISION RHS(409600),M(NZ)
      INTEGER IA(409600),JA(NZ),IWORK(NZ)       
      REAL DR(MAX_GATES),THETA(MAX_RAYS),DTHETA(MAX_RAYS)
      DOUBLE PRECISION VALUES(15)
      NN=409600
      NNNN=409600
      DO I=1,409600
       RHS(I)=0.
      ENDDO
      DO J=1,MAX_RAYS
       DO I=1,MAX_GATES
        INDEX4(I,J)=0
        INDEX5(I,J)=0
       ENDDO
      ENDDO
      DO I=1,409600
       INDEX1(I)=0
       INDEX2(I)=0
      ENDDO
      DO I=1,NBINS-1
       DR(I)=(RDTAI(I+1)-RDTAI(I))*1000.
      ENDDO
      DR(NBINS)=-999.9
c      WRITE(6,*)DR
c      PAUSE
      DO J=1,NUM_RAYS
       THETA(J)=PAZM(J)*3.14159/180.
c       write(6,*)j,az_el(1,j),az_el(2,j),(vrrad(i,j),i=1,nbins)
      ENDDO
      DO J=1,NUM_RAYS-1
       DTHETA(J)=THETA(J+1)-THETA(J)
      ENDDO
      DTHETA(NUM_RAYS)=-999.9
c      WRITE(6,*)PAZM
c      PAUSE
c      WRITE(6,*)DTHETA
c      PAUSE
      DO J=1,NUM_RAYS
       DO I=1,NBINS-1
        IF(VRRAD(I,J).GT.-200..AND.VRRAD(I+1,J).GT.-200..AND.
     1     SWEEP(I,J).GT.-200..AND.SWEEP(I+1,J).GT.-200.)THEN
         DVRADR(I,J)=(SWEEP(I+1,J)-SWEEP(I,J))/DR(I)
         IPOSITION=I+(J-1)*MAX_GATES
         INDEX2(IPOSITION)=1
         INDEX4(I,J)=1
c         IF(ABS(DVRADR(I,J)).GT..001)THEN
c          WRITE(6,*)
c     1       'I,J,PAZM(J),SWEEP(I,J),SWEEP(I+1,J),DVRADR(I,J) = ',
c     1              I,J,PAZM(J),SWEEP(I,J),SWEEP(I+1,J),DVRADR(I,J)
c          WRITE(6,*)'I,J,VRRAD(I,J),VRRAD(I+1,J) = ',
c     1              I,J,VRRAD(I,J),VRRAD(I+1,J)
c         ENDIF
        ELSE
         DVRADR(I,J)=-999.9
        ENDIF
       ENDDO
      ENDDO
      DO J=1,NUM_RAYS-1
       DO I=1,NBINS
        ATEST=ABS(DTHETA(J)*RDTAI(I))
c        WRITE(6,*)'I,J,ATEST = ',I,J,ATEST
c         WRITE(6,*)'I,J,SWEEP(I,J),SWEEP(I,J+1) = ',
c     1              I,J,SWEEP(I,J),SWEEP(I,J+1)
c         WRITE(6,*)'I,J,VRRAD(I,J),VRRAD(I,J+1) = ',
c     1              I,J,VRRAD(I,J),VRRAD(I,J+1)
        IF(VRRAD(I,J+1).GT.-200..AND.VRRAD(I,J).GT.-200..AND.
     1     DTHETA(J).LT..04.AND.ATEST.LT.2..AND.
     1     SWEEP(I,J+1).GT.-200..AND.SWEEP(I,J).GT.-200.)THEN
         DVRADAZM(I,J)=(SWEEP(I,J+1)-SWEEP(I,J))/DTHETA(J)
c         DVRADAZM(I,J)=(VRRAD(I,J+1)-VRRAD(I,J))/DTHETA(J)
         IPOSITION=I+(J-1)*MAX_GATES
         INDEX2(IPOSITION)=1
         INDEX4(I,J)=1
c         WRITE(6,*)'I,J,SWEEP(I,J),SWEEP(I,J+1),DVRADAZM(I,J) = ',
c     1              I,J,SWEEP(I,J),SWEEP(I,J+1),DVRADAZM(I,J)
c         WRITE(6,*)'I,J,VRRAD(I,J),VRRAD(I,J+1) = ',
c     1              I,J,VRRAD(I,J),VRRAD(I,J+1)
        ELSE
         DVRADAZM(I,J)=-999.9
        ENDIF
       ENDDO
      ENDDO
      DO J=1,NUM_RAYS
c       WRITE(6,*)J,(VRRAD(I,J),I=1,NBINS)
       MAXBINS=0
       MINBINS=0
       DO I=1,NBINS
        IF(SWEEP(I,J).GT.-200.)THEN
         IF(MINBINS.EQ.0)MINBINS=I
         MAXBINS=I
        ENDIF
       ENDDO
       IF(MINBINS.GT.0)THEN
        MINBINS=MINBINS-5
        IF(MINBINS.LT.1)MINBINS=1
       ENDIF
       MAXBINS=MAXBINS+5
       IF(MAXBINS.GT.NBINS)MAXBINS=NBINS
       IF(MINBINS.GT.0)THEN
c        WRITE(6,*)'J,MINBINS,MAXBINS = ',J,MINBINS,MAXBINS
        DO I=MINBINS,MAXBINS
         IF(VRRAD(I,J).GT.-200.)THEN
          IPOSITION=I+(J-1)*MAX_GATES
          INDEX2(IPOSITION)=1
          INDEX4(I,J)=1
          IF(SWEEP(I,J).GT.-200.)INDEX5(I,J)=1
         ENDIF
        ENDDO
       ENDIF
      ENDDO
      IPOS=0
      DO I=1,NN
c       write(6,*)'i,index2(i) = ',i,index2(i)
       IF(INDEX2(I).NE.0)THEN
        IPOS=IPOS+1 
c        write(6,*)'ipos = ',ipos
        IF(IPOS.GT.NNNN)THEN
c         WRITE(6,*)'I= ',I,'  IPOS = ',IPOS
         STOP
        ENDIF
        INDEX1(IPOS)=I
        INDEX2(I)=IPOS
       ENDIF
      ENDDO 
      CALL SBINI(IPOS,NZ,IA,JA,M,IWORK)
      WRITE(6,*)'IPOS = ',IPOS
c      DO II=1,IPOS
c       WRITE(6,*)'II,INDEX1(II) = ',II,INDEX1(II)
c       J=1+(INDEX1(II)/MAX_GATES)
c       I=INDEX1(II)-(J-1)*MAX_GATES
c       WRITE(6,*)'I,J,VRRAD,SWEEP = ',I,J,VRRAD(I,J),SWEEP(I,J)
c      ENDDO
c      PAUSE
c      WRITE(6,*)'ONE'
      DO J=1,NUM_RAYS
       DO I=1,NBINS-1
        IF(INDEX4(I,J).EQ.1.AND.INDEX4(I+1,J).EQ.1.AND.
     1     ABS(DVRADR(I,J)).LT..05)THEN
         IPOSITION=I+(J-1)*MAX_GATES
         IPOSITION2=IPOSITION+1
         INPOSITION=INDEX2(IPOSITION)
         INPOSITION2=INDEX2(IPOSITION2)
         INDEXNN(1)=IPOSITION
         INDEXNN(2)=IPOSITION2
         VALUES(1)=-1./DR(I)
         VALUES(2)=1./DR(I)
         NINDEX=2
         NN=409600
         NNNN=409600
         FACTORDR=DR(I)*DR(I)
c         FACTORDR=0.
         RHS(INPOSITION)=RHS(INPOSITION)
     1                    +VALUES(1)*DVRADR(I,J)*FACTORDR
         RHS(INPOSITION2)=RHS(INPOSITION2)
     1                     +VALUES(2)*DVRADR(I,J)*FACTORDR     
c         WRITE(6,*)I,J,INDEXNN(1),INDEXNN(2),NINDEX
c         WRITE(6,*)'RADIUS,DR = ',RDTAI(I),RDTAI(I+1),DR(I)
c         WRITE(6,*)'VALUES= ',(VALUES(LK),LK=1,NINDEX)
c         WRITE(6,*)'FACTORDR = ',FACTORDR
c         WRITE(6,*)'IPOS,NZ,NW = ',IPOS,NZ,NW
         CALL MATRIXSUM(INDEXNN,INDEX2,VALUES,NINDEX,NN,IDIF,
     1       NNNN,FACTORDR,IPOS,NZ,IA,JA,M,IWORK,NW)       
        ENDIF
       ENDDO
      ENDDO
c      WRITE(6,*)'RADIAL GRADIENT SUMMATION FINISHED'
c      PAUSE
      DO J=1,NUM_RAYS
       DO I=2,NBINS-1
        IF(INDEX4(I,J).EQ.1.AND.INDEX4(I+1,J).EQ.1.AND.
     1     INDEX4(I-1,J).EQ.1.AND.DR(I-1).EQ.DR(I))THEN
         IPOSITION=I-1+(J-1)*MAX_GATES
         IPOSITION2=IPOSITION+1
         IPOSITION3=IPOSITION+2
         INPOSITION=INDEX2(IPOSITION)
         INPOSITION2=INDEX2(IPOSITION2)
         INPOSITION3=INDEX2(IPOSITION3)
         INDEXNN(1)=IPOSITION
         INDEXNN(2)=IPOSITION2
         INDEXNN(3)=IPOSITION3
         DRR=DR(I)*DR(I-1)
         ABSD=ABS(DR(I)-DR(I-1))
         IF(ABSD.GT.1.)THEN
          DENOMINATOR=.5*(DR(I)*DR(I)*DR(I-1)+DR(I)*DR(I-1)*DR(I-1))         
          VALUES(1)=-DR(I)/DENOMINATOR
          VALUES(2)=(DR(I)+DR(I-1))/DENOMINATOR
          VALUES(3)=-DR(I-1)/DENOMINATOR
         ELSE
          VALUES(1)=-1./DRR
          VALUES(2)=2./DRR
          VALUES(3)=-1./DRR
         ENDIF
         NINDEX=3
         NN=409600
         NNNN=409600
         FACTORDRR=DRR*DRR*.01
c         FACTORDRR=0.
c         WRITE(6,*)I,J,INDEXNN(1),INDEXNN(2),NINDEX
c         WRITE(6,*)'RADIUS,DR = ',RDTAI(I),RDTAI(I+1),DR(I)
c         WRITE(6,*)'VALUES= ',(VALUES(LK),LK=1,NINDEX)
c         WRITE(6,*)'FACTORDR = ',FACTORDR
c         WRITE(6,*)'IPOS,NZ,NW = ',IPOS,NZ,NW
         CALL MATRIXSUM(INDEXNN,INDEX2,VALUES,NINDEX,NN,IDIF,
     1       NNNN,FACTORDRR,IPOS,NZ,IA,JA,M,IWORK,NW)       
        ENDIF
       ENDDO
      ENDDO
c      WRITE(6,*)'RADIAL GRADIENT SUMMATION FINISHED'
c      PAUSE
      DO J=1,NUM_RAYS-1
       DO I=1,NBINS
        IF(INDEX4(I,J).EQ.1.AND.INDEX4(I,J+1).EQ.1.AND.
     1     ABS(DVRADAZM(I,J)).LT.600.)THEN
         IPOSITION=I+(J-1)*MAX_GATES
         IPOSITION2=IPOSITION+MAX_GATES
         INPOSITION=INDEX2(IPOSITION)
         INPOSITION2=INDEX2(IPOSITION2)
         INDEXNN(1)=IPOSITION
         INDEXNN(2)=IPOSITION2
         VALUES(1)=-1./DTHETA(J)
         VALUES(2)=1./DTHETA(J)
         NINDEX=2
         RANGE=RDTAI(I)*1000.
         FACTORDTHETA=1.
c         FACTORDTHETA=0.
         RHS(INPOSITION)=RHS(INPOSITION)
     1                    +VALUES(1)*DVRADAZM(I,J)*FACTORDTHETA
         RHS(INPOSITION2)=RHS(INPOSITION2)
     1                     +VALUES(2)*DVRADAZM(I,J)*FACTORDTHETA
c         WRITE(6,*)I,J,INDEXNN(1),INDEXNN(2),NINDEX
         CALL MATRIXSUM(INDEXNN,INDEX2,VALUES,NINDEX,NN,IDIF,
     1       NNNN,FACTORDTHETA,IPOS,NZ,IA,JA,M,IWORK,NW)
        ENDIF
       ENDDO
      ENDDO
      DO J=2,NUM_RAYS-1
       DO I=1,NBINS
        IF(INDEX4(I,J).EQ.1.AND.INDEX4(I,J+1).EQ.1.AND.
     1     INDEX4(I,J-1).EQ.1)THEN
         IPOSITION=I+(J-2)*MAX_GATES
         IPOSITION2=IPOSITION+MAX_GATES
         IPOSITION3=IPOSITION+2*MAX_GATES
         INPOSITION=INDEX2(IPOSITION)
         INPOSITION2=INDEX2(IPOSITION2)
         INPOSITION3=INDEX2(IPOSITION3)
         INDEXNN(1)=IPOSITION
         INDEXNN(2)=IPOSITION2
         INDEXNN(3)=IPOSITION3
         DENOMINATOR=.5*(DTHETA(J)*DTHETA(J)*DTHETA(J-1)
     1                +DTHETA(J)*DTHETA(J-1)*DTHETA(J-1))         
         VALUES(1)=-DTHETA(J)/DENOMINATOR
         VALUES(2)=(DTHETA(J)+DTHETA(J-1))/DENOMINATOR
         VALUES(3)=-DTHETA(J-1)/DENOMINATOR
         NINDEX=3
         RANGE=RDTAI(I)*1000.
         FACTORDTHETA=.01
     1         *DTHETA(J)*DTHETA(J)*DTHETA(J-1)*DTHETA(J-1)       
c         FACTORDTHETA=0.
c         WRITE(6,*)I,J,INDEXNN(1),INDEXNN(2),NINDEX
         CALL MATRIXSUM(INDEXNN,INDEX2,VALUES,NINDEX,NN,IDIF,
     1       NNNN,FACTORDTHETA,IPOS,NZ,IA,JA,M,IWORK,NW)
        ENDIF
       ENDDO
      ENDDO
c      WRITE(6,*)'AZIMUTHAL GRADIENT SUMMATION FINISHED'
c      PAUSE
      DO J=1,NUM_RAYS
       DO I=1,NBINS
        IF(INDEX4(I,J).EQ.1)THEN
c        IF(VRRAD(I,J).GT.-200.)THEN
         IPOSITION=I+(J-1)*MAX_GATES
         INPOSITION=INDEX2(IPOSITION)
c         write(6,*)'i,j,iposition,iposition2,max_gates = ',
c     +     i,j,iposition,iposition2,max_gates
c         INPOSITION2=INDEX2(IPOSITION2)
         INDEXNN(1)=IPOSITION
         VALUES(1)=1.
         NINDEX=1
         FACTORVR=.01
         RHS(INPOSITION)=RHS(INPOSITION)+VRRAD(I,J)*FACTORVR
c         WRITE(6,*)I,J,INDEXNN(1),NINDEX
         CALL MATRIXSUM(INDEXNN,INDEX2,VALUES,NINDEX,NN,IDIF,
     1       NNNN,FACTORVR,IPOS,NZ,IA,JA,M,IWORK,NW)
        ENDIF
       ENDDO
c       WRITE(6,*)'J,INDEX4 = ',J,(INDEX4(I,J),I=1,NBINS)
      ENDDO
c      WRITE(6,*)'BACKGROUND SUMMATION FINISHED'
c      PAUSE
      CALL SBEND(IPOS,NZ,IA,JA,M,IWORK)
      WRITE(6,*)'SBEND FINISHED'
c      PAUSE
      RETURN
      END
      SUBROUTINE MATRIXSUM(INDX,INDEX2,VALUES,N,NN,IDIF,NNNN,
     1                     FACTOR,IPOS,NZ,IA,JA,A,IWORK,NW)
      INTEGER IA(NNNN),JA(NZ),IWORK(NZ)
      DOUBLE PRECISION A(NZ),SM,VALUES(N)
      INTEGER INDEX2(NN),INDX(N),IDIF(115)
      CALL SORTER(INDX,VALUES,N)
c        WRITE(6,*)'INDX = ',INDX
c        WRITE(6,*)'VALUES = ',VALUES
      NOUT=6
      LEVEL=0
      MODE=1
      IF(FACTOR.EQ.0)RETURN
      DO I=1,N
       DO L=1,N
        IF(INDX(I).GE.INDX(L))THEN
         IF(INDX(I).GT.0.AND.INDX(L).GT.0)THEN
          NDIFF=INDX(I)-INDX(L)
          NPOS=100*L+I
          IN=INDEX2(INDX(I))
          INN=INDEX2(INDX(L))
          IF(IN.GT.0.AND.INN.GT.0)THEN
           SM=VALUES(I)*VALUES(L)*
     1                     FACTOR
         INI=INDEX2(INDX(I))
         INL=INDEX2(INDX(L))
         CALL SBSIJ(IPOS,NZ,IA,JA,A,IWORK,INL,INI,SM,
     1    MODE,LEVEL,NOUT,IER)
          ENDIF
         ENDIF
        ENDIF
       ENDDO
      ENDDO
      RETURN
      END
      SUBROUTINE SORTER(INDX,VALUES,N)
      INTEGER INDX(N)
      DOUBLE PRECISION VALUES(N)
      DO I=1,N
       INTEST=I
       DO L=I,N
        IF(INDX(L).GT.INDX(INTEST))INTEST=L
       ENDDO
       IA=INDX(INTEST)
       INDX(INTEST)=INDX(I)
       INDX(I)=IA
       A=VALUES(INTEST)
       VALUES(INTEST)=VALUES(I)
       VALUES(I)=A
      ENDDO
      RETURN
      END
