      SUBROUTINE READHEADERS(LU,FILNAM,KEYWORD,FLTNAME,
     + STMNAME,RADAR,EXPERIMENT,
     + CREATIME,EXTRA1,IMX,JMX,KMX,KOUNT,NMOSM,
     + IUNFLD,IATTEN,FLAG,EXTRA2,EXTRA3,STIME,ETIME,OLAT,OLON,
     + SX,SY,SZ,XZ,YZ,ZZ,ROT,RA,CO1,CO2,AZMCOR,ELCOR,THRESH,
     + POWERT,BIEL,AZBIEL,ETIME1,STIME2,EXTRA6,EXTRA7)
      CHARACTER KEYWORD*4,FLTNAME*8,STMNAME*12,RADAR*4,EXPERIMENT*32
      CHARACTER CREATIME*32,EXTRA1*28,FILNAM*56
      INTEGER IMX,JMX,KMX,KOUNT,NMOSM,
     + IUNFLD,IATTEN,FLAG,EXTRA2,EXTRA3
      REAL STIME,ETIME,OLAT,OLON,SX,SY,SZ,XZ,YZ,ZZ,ROT,RA,CO1,
     + CO2,AZMCOR,ELCOR,THRESH,POWERT,BIEL,AZBIEL,ETIME1,STIME2,
     + EXTRA6,EXTRA7
      OPEN(LU,FILE=FILNAM,STATUS='OLD',FORM='UNFORMATTED')
      READ(LU)KEYWORD,FLTNAME,STMNAME,
     + RADAR,EXPERIMENT,CREATIME,
     + EXTRA1,IMX,JMX,KMX,KOUNT,NMOSM,
     + IUNFLD,IATTEN,FLAG,EXTRA2,
     + EXTRA3,STIME,ETIME,OLAT,OLON,SX,SY,SZ,XZ,YZ,ZZ,ROT,RA,CO1,
     + CO2,AZMCOR,ELCOR,THRESH,POWERT,BIEL,AZBIEL,ETIME1,STIME2,
     + EXTRA6,EXTRA7
      RETURN
      END
      FUNCTION VTERM_NEW(Z,H,hb,dpb,IRSW,ZLOW,ZHIGH) 
C Terminal velocity from dBZ and height 
C This function computes mean terminal velocity from the reflectivity 
C according to Paul Willis' 2-parameter gamma distribution and
C a snow relationship developed by Atlas et al. (1973)
C Reflectivity, in terms of dBZ, must be passed to this routine.
C HEIGHT MUST BE IN KM
c irsw - 0 Joss and Waldvogel; >0 Willis Gamma
C hb is the height of the bright band, and dpb is the depth of the bright 
C   band both in km 
C 
      ZZ=10.0**(Z*0.1)
      hlow= hb - dpb * .5 
      hhi= hlow + dpb 
C density correction term (rhoo/rho)*0.45 [rho(Z)=rhoo exp-(z/H), where 
C  H is the scale height = 9.58125 from Gray's inner 2 deg composite] 
C 0.45 density correction from Beard (1985, JOAT pp 468-471)
      DCOR=EXP(0.45*H*.10437052)
C The snow relationship (Atlas et al., 1973) --- VT=0.817*Z**0.063  (m/s) 
      VTS=-DCOR * (0.817*ZZ**0.063) 
      if(irsw.gt.0) then
C The rain relationship --- from Willis analytical-gamma distribution 
         TERM1=7.331/ZZ**0.010022 
         TERM2=0.14034*ZZ**0.095238 
         VTR=-DCOR * (5.5011E+09/(TERM1+TERM2)**10.5) 
      else
C The rain relationship (Joss and Waldvogel,1971) --- VT=2.6*Z**.107 (m/s)
         VTR=-DCOR * (2.6*ZZ**.107) 
      endif 
C test if height is in the transition region between SNOW and RAIN
C  defined as hlow in km < H < hhi in km
C  if in the transition region do a linear weight of VTR and VTS
      IF(Z.GT.ZLOW.AND.Z.LE.ZHIGH)THEN
       WEIGHTR=(Z-ZLOW)/(ZHIGH-ZLOW)
       WEIGHTS=1.-WEIGHTR
       VTS=(VTR*WEIGHTR+VTS*WEIGHTS)/(WEIGHTR+WEIGHTS)
      ELSEIF(Z.GT.ZHIGH)THEN
       VTS=VTR
      ENDIF
      VTERM_NEW=VTR*(hhi-H)/dpb + VTS*(H-hlow)/dpb  
      IF(H.LT.hlow) VTERM_NEW=VTR 
      IF(H.GT.hhi) VTERM_NEW=VTS
      RETURN
      END 
      SUBROUTINE LDPLNNOW(LU,U,V,W,IMAX,JMAX,KMAX,IUV,ZZ,SZ)
      REAL U(IMAX,JMAX,KMAX),V(IMAX,JMAX,KMAX),W(IMAX,JMAX,KMAX)
      INTEGER*2 IU(200),IV(200),IW(200),IDB(200),IDV(200)
      REAL RU(200),RV(200),RW(200),RDV(200)
      FLAG=-1.0E+10
      WRITE(6,*)'INSIDE LDPLNW'
      WRITE(6,*)'IMAX,JMAX,KMAX,IUV = ',IMAX,JMAX,KMAX,IUV
      IRSW=0
      DO K=1,KMAX
       H=ZZ+(K-1)*SZ
       RHO=EXP(-H*.10437052)
c       RHO=EXP(-H*.11)
       DO J=1,JMAX
        IF(IUV.EQ.0)THEN
         READ(LU)(IU(I),IV(I),IW(I),IDB(I),IDV(I),I=1,IMAX)
c         write(6,*)'j,k,iu = ',(j,k,iu(i),i=1,imax)
c         write(6,*)'j,k,iv = ',(j,k,iv(i),i=1,imax)
c         write(6,*)'j,k,iw = ',j,k,(iw(i),i=1,imax)
c         write(6,*)'j,k,idb = ',j,k,(idb(i),i=1,imax)
c         write(6,*)'j,k,idv = ',(j,k,idv(i),i=1,imax)
        ELSE
         READ(LU)(RU(I),RV(I),RW(I),IDB(I),RDV(I),I=1,IMAX)
        ENDIF
        DO I=1,IMAX
         IF(IDB(I).GT.-1000)THEN
          DBZ=IDB(I)*.1
         ELSE
          DBZ=FLAG
         ENDIF
         IF(IUV.EQ.0)THEN
          IF(IU(I).LT.-9990)THEN
           U(I,J,K)=FLAG
           V(I,J,K)=FLAG
          ELSE
           WDR=IU(I)*.1
           WSP=IV(I)*.1
c           CALL COMP(XU,XV,WDR,WSP)
           XU=-SIN(WDR*3.14159/180.)*WSP
           XV=-COS(WDR*3.14159/180.)*WSP
           U(I,J,K)=XU
           V(I,J,K)=XV
          ENDIF
          IF(IW(I).GT.-9990.AND.DBZ.GT.FLAG)THEN
c           VT=VTERM_NEW(DBZ,H,HB,DPB,IRSW,ZLOW,ZHIGH)
           VT=0.
           W(I,J,K)=VT+IW(I)*.01
          ELSE
           U(I,J,K)=FLAG
           V(I,J,K)=FLAG
           W(I,J,K)=FLAG
          ENDIF
          IF(U(I,J,K).GT.FLAG.AND.W(I,J,K).LE.FLAG)THEN
           WRITE(6,*)'I,J,K,U,V,W,IU,IV,IW = ',
     1    I,J,K,U(I,J,K),V(I,J,K),W(I,J,K),IU(I),IV(I),IW(I)
          ENDIF
         ELSE
C      FUNCTION VTERM_NEW(Z,H,hb,dpb,IRSW,ZLOW,ZHIGH) 
          IF(RU(I).GT.FLAG.AND.RV(I).GT.FLAG.AND.RW(I).GT.FLAG)THEN
           U(I,J,K)=RU(I)
           V(I,J,K)=RV(I)
           DBZ=IDB(I)*.1
C           VT=VTERM_NEW(DBZ,H,HB,DPB,IRSW,ZLOW,ZHIGH)
           VT=0.
           W(I,J,K)=VT+RW(I)
          ELSE
           U(I,J,K)=FLAG
           V(I,J,K)=FLAG
           W(I,J,K)=FLAG
          ENDIF
         ENDIF
        ENDDO
c        WRITE(6,*)'J,K,U = ',J,K,(U(I,J,K),I=1,IMAX)
       ENDDO
      ENDDO
      RETURN
      END
      SUBROUTINE LDPLN(LU,U,V,W,IMAX,JMAX,KMAX,IUV,ZZ,SZ,
     1 ZLOW,ZHIGH,HB,DPB)
      REAL U(IMAX,JMAX,KMAX),V(IMAX,JMAX,KMAX),W(IMAX,JMAX,KMAX)
      INTEGER*2 IU(200),IV(200),IW(200),IDB(200),IDV(200)
      REAL RU(200),RV(200),RW(200),RDV(200)
      FLAG=-1.0E+10
      WRITE(6,*)'INSIDE LDPLNW'
      WRITE(6,*)'IMAX,JMAX,KMAX,IUV = ',IMAX,JMAX,KMAX,IUV
      IRSW=0
      DO K=1,KMAX
       H=ZZ+(K-1)*SZ
       RHO=EXP(-H*.10437052)
c       RHO=EXP(-H*.11)
       DO J=1,JMAX
        IF(IUV.EQ.0)THEN
         READ(LU)(IU(I),IV(I),IW(I),IDB(I),IDV(I),I=1,IMAX)
c         write(6,*)'j,k,iu = ',(j,k,iu(i),i=1,imax)
c         write(6,*)'j,k,iv = ',(j,k,iv(i),i=1,imax)
c         write(6,*)'j,k,iw = ',j,k,(iw(i),i=1,imax)
c         write(6,*)'j,k,idb = ',j,k,(idb(i),i=1,imax)
c         write(6,*)'j,k,idv = ',(j,k,idv(i),i=1,imax)
        ELSE
         READ(LU)(RU(I),RV(I),RW(I),IDB(I),RDV(I),I=1,IMAX)
        ENDIF
        DO I=1,IMAX
         IF(IDB(I).GT.-1000)THEN
          DBZ=IDB(I)*.1
         ELSE
          DBZ=FLAG
         ENDIF
         IF(IUV.EQ.0)THEN
          IF(IU(I).LT.-9990)THEN
           U(I,J,K)=FLAG
           V(I,J,K)=FLAG
          ELSE
           WDR=IU(I)*.1
           WSP=IV(I)*.1
c           CALL COMP(XU,XV,WDR,WSP)
           XU=-SIN(WDR*3.14159/180.)*WSP
           XV=-COS(WDR*3.14159/180.)*WSP
           U(I,J,K)=XU
           V(I,J,K)=XV
          ENDIF
          IF(IW(I).GT.-9990.AND.DBZ.GT.FLAG)THEN
           VT=VTERM_NEW(DBZ,H,HB,DPB,IRSW,ZLOW,ZHIGH)
           W(I,J,K)=VT+IW(I)*.01
          ELSE
           U(I,J,K)=FLAG
           V(I,J,K)=FLAG
           W(I,J,K)=FLAG
          ENDIF
          IF(U(I,J,K).GT.FLAG.AND.W(I,J,K).LE.FLAG)THEN
           WRITE(6,*)'I,J,K,U,V,W,IU,IV,IW = ',
     1    I,J,K,U(I,J,K),V(I,J,K),W(I,J,K),IU(I),IV(I),IW(I)
          ENDIF
         ELSE
C      FUNCTION VTERM_NEW(Z,H,hb,dpb,IRSW,ZLOW,ZHIGH) 
          IF(RU(I).GT.FLAG.AND.RV(I).GT.FLAG.AND.RW(I).GT.FLAG)THEN
           U(I,J,K)=RU(I)
           V(I,J,K)=RV(I)
           DBZ=IDB(I)*.1
           VT=VTERM_NEW(DBZ,H,HB,DPB,IRSW,ZLOW,ZHIGH)
           W(I,J,K)=VT+RW(I)
          ELSE
           U(I,J,K)=FLAG
           V(I,J,K)=FLAG
           W(I,J,K)=FLAG
          ENDIF
         ENDIF
        ENDDO
c        WRITE(6,*)'J,K,U = ',J,K,(U(I,J,K),I=1,IMAX)
       ENDDO
      ENDDO
      RETURN
      END
      SUBROUTINE LDPLNCOR(LU,U,V,W,DBZ,IMAX,JMAX,KMAX,IUV,ZZ,SZ,
     1 ZLOW,ZHIGH,HB,DPB)
      REAL U(IMAX,JMAX,KMAX),V(IMAX,JMAX,KMAX),W(IMAX,JMAX,KMAX)
      INTEGER*2 IU(200),IV(200),IW(200),IDB(200),IDV(200)
      REAL RU(200),RV(200),RW(200),RDV(200)
      FLAG=-1.0E+10
      WRITE(6,*)'INSIDE LDPLNW'
      WRITE(6,*)'IMAX,JMAX,KMAX,IUV = ',IMAX,JMAX,KMAX,IUV
      IRSW=0
      DO K=1,KMAX
       H=ZZ+(K-1)*SZ
       RHO=EXP(-H*.10437052)
c       RHO=EXP(-H*.11)
       DO J=1,JMAX
        IF(IUV.EQ.0)THEN
         READ(LU)(IU(I),IV(I),IW(I),IDB(I),IDV(I),I=1,IMAX)
c         write(6,*)'j,k,iu = ',(j,k,iu(i),i=1,imax)
c         write(6,*)'j,k,iv = ',(j,k,iv(i),i=1,imax)
c         write(6,*)'j,k,iw = ',j,k,(iw(i),i=1,imax)
c         write(6,*)'j,k,idb = ',j,k,(idb(i),i=1,imax)
c         write(6,*)'j,k,idv = ',(j,k,idv(i),i=1,imax)
        ELSE
         READ(LU)(RU(I),RV(I),RW(I),IDB(I),RDV(I),I=1,IMAX)
        ENDIF
        DO I=1,IMAX
         IF(IDB(I).GT.-1000)THEN
          DBZ=IDB(I)*.1
         ELSE
          DBZ=FLAG
         ENDIF
         IF(IUV.EQ.0)THEN
          IF(IU(I).LT.-9990)THEN
           U(I,J,K)=FLAG
           V(I,J,K)=FLAG
          ELSE
           WDR=IU(I)*.1
           WSP=IV(I)*.1
c           CALL COMP(XU,XV,WDR,WSP)
           XU=-SIN(WDR*3.14159/180.)*WSP
           XV=-COS(WDR*3.14159/180.)*WSP
           U(I,J,K)=XU
           V(I,J,K)=XV
          ENDIF
          IF(IW(I).GT.-9990.AND.DBZ.GT.FLAG)THEN
           VT=VTERM_NEW(DBZ,H,HB,DPB,IRSW,ZLOW,ZHIGH)
           W(I,J,K)=VT+IW(I)*.01
          ELSE
           U(I,J,K)=FLAG
           V(I,J,K)=FLAG
           W(I,J,K)=FLAG
          ENDIF
          IF(U(I,J,K).GT.FLAG.AND.W(I,J,K).LE.FLAG)THEN
           WRITE(6,*)'I,J,K,U,V,W,IU,IV,IW = ',
     1    I,J,K,U(I,J,K),V(I,J,K),W(I,J,K),IU(I),IV(I),IW(I)
          ENDIF
         ELSE
C      FUNCTION VTERM_NEW(Z,H,hb,dpb,IRSW,ZLOW,ZHIGH) 
          IF(RU(I).GT.FLAG.AND.RV(I).GT.FLAG.AND.RW(I).GT.FLAG)THEN
           U(I,J,K)=RU(I)
           V(I,J,K)=RV(I)
           DBZ=IDB(I)*.1
C           VT=VTERM_NEW(DBZ,H,HB,DPB,IRSW,ZLOW,ZHIGH)
           VT=0.
           W(I,J,K)=VT+RW(I)
          ELSE
           U(I,J,K)=FLAG
           V(I,J,K)=FLAG
           W(I,J,K)=FLAG
          ENDIF
         ENDIF
        ENDDO
c        WRITE(6,*)'J,K,U = ',J,K,(U(I,J,K),I=1,IMAX)
       ENDDO
      ENDDO
      RETURN
      END

