      SUBROUTINE RAYCOR1(bin, zbin)
C 
C     SUBROUTINE CALLED BY SWEEPIN (NEWSWEEPREAD_AUTO_FIRST_DISC_DEFRECKLE.F)
C       
C ... FUNCTION:   
C       
C     THIS SUBROUTINE CORRECTS THE FLIGHT DATA ONE RAY AT A TIME THEN PASSES
C     IT BACK FOR AVERAGING, INTERPOLATION, OR FURTHER ANALYSIS.
C     THIS ROUTINE WORKS IN THE AIRCRAFT COORDINATE SYSTEM OF ANGLES:
C 
C     AZM    0 - 360 DEGREES  SWEEP ROTATION ANGLE(CLOCKWISE) WITH 0 UP
C     ELEV  (+OR-)25 DEGREES  ANTENNA ANGLE(TILT) FROM PERPENDICULAR TO TRACK
C  	                      >0 IS FORWARD, <0 IS AFT, 0 IS PERPENDICULAR
C     TRACK  0 - 360 DEGREES  ANGLE AIRCRAFT TRACK MAKES FROM NORTH(0 DEGREES)
C                             METEOROLOGICAL ANGLES
C
C ... RAYCOR1 SUBPROGRAM REFERENCES: INTERVENATTEN1 (NOT PRESENTLY USED)
C                                    UNFLD1 (NOT PRESENTLY USED)
C     
C     VERSION:  <TBD>
C       
C     CODE WRITTEN BY:  JOHN GAMACHE   
C                       HRD/AOML/NOAA          
C                       MIAMI, FL 33149      
C       
C     FOR ADDITIONAL DETAILS ON THE ALGORITHM SEE <TBD>
C       
C     BASED ON THEORY BY:  <TBD>
C       
C     REFERENCE THE BOOK:  <TBD>
C       
C     **************************************************  
C     *               IMPORTANT NOTE                   *  
C     *                                                *  
C     *                    <TBD>                       *  
C     *                                                *  
C     **************************************************         
C
C     SPECIFICATIONS FOR ARGUMENTS
C    
C     BIN(512) = ARRAY CONTAINING THE DOPPLER DATA TO BE RETURNED
C     ZBIN(512) = ARRAY CONTAINING THE REFLECTIVITY(DBZ) DATA TO BE RETURNED
C 
      DIMENSION      bin(512), zbin(512)
      DIMENSION      bin2(512)
      COMMON /TAPEHEADER/ nbytesheader, ntape, nversion, ihheader,
     +               imheader, isheader, ine, ndrive, naircraft,
     +               flightid, projectid, nsamplelf, nsampleta,
     +               refslopelf, refslopeta, refnoisethreslf,
     +               refnoisethresta, sqilf, sqita, widththreslf,
     +               widththresta, caliblf, calibta, modedatalf,
     +               modedatata, noisetmlf, noisetmta, rpmlf, rpmta,
     +               gtlnlf, ivrangelf, ivrangeta, gtlnta(3), rdellf,
     +               rdelta, rdelcorlf, rdelcorta, nbinlf, nbinta,
     +               nbins, rmaxlf, rmaxta, radiita(512), radiilf(512),
     +               prf_flaglf,prf_flagta,prf_highlf,prf_highta,
     +               xniqlf,xniqta,
     +               iheader(1024)
      COMMON /RAYHEADER/ nbytesdata, nlfsweep, ntasweep, numrecord,
     +               irecflag, idradar, nbytesray, icode, idsp, mdata,
     +               iyear, month, iday, iraycode, time,
     +               ihour, imin, isec, isec100, rlat, rlon, radaralt,
     +               gse, gsn, gs, vgs, ucom, vcom, wd, ws, vws, ircu,
     +               elev, azm, pitch, roll, drift, heading,
     +               dbzbuffer(512), velbuffer(512), widthbuffer(512)
      COMMON /PARAMS/trackazm, trackelev, driftnew,
     +               rot, track, htbb, dbb, dbzthresh, swthresh, dbzrs,
     +               ibst(2), inob(2), ileg, xniq, irsw, maxnbins, v0,
     +               pcor, dcor, rcor, azmcor, elcor, dbzcor, dbzslope,
     +               iunfoldflag, iattenflag,
     +               badstabflag, surfelimflag, echoflag, atmflag
      LOGICAL        badstabflag, surfelimflag, echoflag, atmflag,
     +               swflag
      INTEGER*2      iheader
      REAL           amos(512)
      CHARACTER      flightid*8, projectid*16
      PARAMETER      (cos_bw = 0.999999958, sin_bw = 0.0002893864959)
      DATA           pidiv180/0.01745329/, amos/512*0.0/,
     +               swflag/.FALSE./
C
C     CALCULATE FUNCTIONS USED REPEATEDLY
C 
      caz = COS(trackazm * pidiv180) 
      saz = SIN(trackazm * pidiv180) 
      cev = COS(trackelev * pidiv180)
      sev = SIN(trackelev * pidiv180)
      cazcev = caz * cev
      sazcev = saz * cev
C
C     PROCESS DOPPLER:
C 
      nb = nbins
      nbd = nbins
C
C     IGNORE DATA BELOW THE GROUND: CALCULATE THE BIN VALUE AT THE GROUND
C     ASSUME HALF BEAMWIDTH OF 0.95 DEG(USES COS AND SIN OF 0.95)
C 
      IF (caz.LT.0.0) THEN
C 
        cs = (caz * cos_bw + SIGN(1.0, saz) * saz * sin_bw) * cev
        a = -radaralt / cs
        b = rdelta * 1000.0
        c = gtlnta(1) * 1000.0
        nbd = NINT((a - b) / c)
        IF ((ivrangeta.EQ.0).OR.(nbd.LE.256)) THEN
          CONTINUE
        ELSE IF (nbd.LE.512) THEN
          nbd = (nbd - 255) / 2 + 256
        ELSE 
          nbd = (nbd - 509) / 4 + 384
        ENDIF
C
C       SUBTRACT 1 FROM THE NUMBER OF BINS TO UNFOLD IN CASE INOB=0,
C       YOU DON'T WANT TO USE THE INTERSECTION BIN 
C 
        nb = nbd - ibst(ileg) - 1
C 
      ENDIF
C
C     USE THE MINIMUM NUMBER OF BINS REQUESTED OR CALCULATED
C 
      nb = MIN0(maxnbins, nb)
C
C     CALCULATE BIN# AT RADARALT TO REMOVE THE SIDELOBES.  THE ECHO MUST BE
C     > ZBRA(RANGE CORRECTION IN THE DBZ COMPUTATION) FOR THE GATES TO BE KEPT
C 
      nbra = NINT((radaralt * 0.001 - rdelta) / gtlnta(1)) + 1
      zbra = 20.0 * ALOG10(radaralt * 0.001) + 1.0
C
C     CORRECTION OF DOPPLER VELOCITIES FOR IMPROPER ANTENNA BEHAVIOR(STABILITY).
C     GIVEN SPEED ALONG TRACK(GS), VERTICAL MOTION OF AIRCRAFT(VGS), CORRECTION
C     OF VELOCITY IS A PROJECTION OF THE AIRCRAFT MOTION VECTOR ON THE RADAR RAY
C 
      IF (badstabflag) THEN
        corvl = gs * sev + vgs * cazcev
      ELSE
        corvl = 0.0
      ENDIF
C
C     LOAD DBZ VALUES INTO ARRAY ZBIN ADDING APPLICABLE CORRECTIONS
C     AT PRESENT, IT APPEARS THAT DBZCOR=0, DBZSLOPE=1, AND AMOS=0
C 
      DO i = 1, nbins
        IF (dbzbuffer(i).GE.-31.5) THEN
          zbin(i) = dbzcor + dbzslope * dbzbuffer(i) + amos(i)
        ELSE
          zbin(i) = dbzbuffer(i)
        ENDIF
      ENDDO
C
C     ADD INTERVENING ATTENUATION IF DESIRED (NOT AT PRESENT)
C 
      IF (iattenflag.EQ.1) CALL INTERVENATTEN1(zbin, nbins, radiita)
C
C     DECIDE IF SPECTRAL WIDTH THRESHHOLDING IS BEING DONE
C 
      IF ((swthresh.LE.12.75).AND.(swthresh.GT.0.0).AND.
     +  (ibits(icode, 13, 1).EQ.1)) swflag = .TRUE.
C
C     CALCULATE RANGE DEPENDENT DBZ THRESHOLD
C     AT PRESENT, DBZTHRESH=-99
CCC 
      DO i = 1, nbins
CCC 
        bin(i) = velbuffer(i)
        dbzt = dbzthresh
C
C       AT PRESENT, DBZRS=-99
C 
        IF (dbzrs.GT.0) THEN
          rdb = radiita(i)
          IF (rdb.GE.dbzrs)dbzt = dbzthresh + 20.0 * ALOG10(rdb / dbzrs)
        ENDIF
        zbra = AMAX1(zbra, dbzt)
C
C       IGNORE ALL UNKNOWN VELOCITIES 
CC 
        IF (bin(i).LE.-888.0) THEN
CC 
          CONTINUE  ! GO TO ENDDO
C
C       IGNORE VALUES WHERE RANGE DELAY CORRECTION HAS MADE A NEGATIVE RADII
CC 
        ELSE IF (radiita(i).LT.0.0) THEN  ! PAL 5 FEB 93
CC 
          bin(i) = -888.88
          zbin(i) = -32.0
C
C       IGNORE ALL VELOCITIES BELOW THE SEA SURFACE (FALSE BY DEFAULT)
C       THIS IS ACCOMPLISHED ELSEWHERE IN SWEEPIN
CC 
        ELSE IF ((i.GT.(MIN0(maxnbins, nbd))).AND.(surfelimflag)) THEN
CC 
          bin(i) = -888.88
          zbin(i) = -32.0
C
C       THRESHOLD VALUES BASED ON SPECTRAL WIDTH IF DESIRED - PAL 5 OCT 94C
CC 
        ELSE IF ((swflag).AND.(widthbuffer(i).GT.swthresh)) THEN  ! Edited 18 Feb 97 per FM
CC 
          bin(i) = -888.88
          zbin(i) = -32.0
C
C       IGNORE ALL VELOCITIES AT ECHO(RANGE) RING AROUND AIRPLANE
CC 
        ELSE IF (((.NOT.(swflag)).AND.
     +    ((i - nbra).LT.7).AND.((i - nbra).GT.-7)).AND.
     +    ((zbin(i).LT.zbra).AND.(echoflag)))  THEN 
CC 
          bin(i) = -888.88 
          zbin(i) = -32.0
C
C       OR USE VARIABLE RANGE DBZ THRESHOLDING (NOT USED SINCE DBZT=-99)
CC 
        ELSE IF (zbin(i).LT.dbzt) THEN   ! Edited 18 Feb 97 per FM
CC 
          bin(i) = -888.88 
          zbin(i) = -32.0  ! Edited 18 Feb 97 per FM
C 
C       OTHERWISE UNPACK VELOCITY AND CORRECT FOR ANTENNA ATTITUDE AND FALLSPEED
C       THIS IS DONE ELSEWHERE IN THE CODE?
CC
        ELSE
CC 
          IF (htbb.LT.0.0) THEN
            corvt = 0.0
          ELSE 
C
C          CORRECTION OF DOPPLER VELOCITY ESTIMATES FOR PARTICLE FALL SPEED(VT)
C          USING DBZ-VT RELATIONSHIP TO ESTIMATE VT.  IF IRSW = 0 THEN FUNCTION
C          USES THE JOSS + WALDVOGEL METHOD.  GIVEN A PARTICLE FALL SPEED(VT),
C          DERIVED FROM REFLECTIVITY OR CLOUD MICROPHYSICS, THE CORRECTION TO
C          THE RADIAL VELOCITY IS THE PROJECTION OF THE VERTICAL VELOCITY ON
C          THE RADAR RAY.
C 
           CORVT=0.
C 
          ENDIF
C 
          bin(i) = bin(i) + corvl + corvt 
C 
          DO WHILE(ABS(BIN(I)).GT.XNIQ)
           IF (bin(i).LT.-xniq) bin(i) = bin(i) + 2.0 * xniq
           IF (bin(i).GT.xniq) bin(i) = bin(i) - 2.0 * xniq 
          ENDDO
CC 
        ENDIF
CCC 
      ENDDO
CCC
C     TRACK ANGLE IS THE HEADING PLUS THE CORRECTED DRIFT
C     THE SEED VELOCITY FOR DOPPLER UNFOLDING IS DERIVED FROM WIND SPEED AT 
C     FLIGHT LEVEL.  GIVEN TRACK, HORIZONTAL WIND SPEED(WS), WIND DIRECTION(WD),
C     WHERE WD IS THE DIRECTION WIND IS BLOWING FROM, AND THE VERTICAL WIND
C     SPEED(VWS), WE CAN DEFINE A VELOCITY VECTOR RELATIVE TO TRACK.
C 
      wd_prime = (wd-track)*pidiv180  ! WIND DIRECTION RELATIVE TO TRACK
      v0 = -ws*(sazcev*SIN(wd_prime)+sev*COS(wd_prime)) + vws*cazcev
C
C     NO UNFOLDING IS DONE HERE BY DEFAULT. IT IS DONE ELSEWHERE WITHIN SWEEPIN.
CC 
      IF (iunfoldflag.EQ.1) THEN
CC 
        IF (nb.LT.1) RETURN
C 
        wd_prime = (wd-track)*pidiv180  ! WIND DIRECTION RELATIVE TO TRACK
        v0 = -ws*(sazcev*SIN(wd_prime)+sev*COS(wd_prime)) + vws*cazcev
C 
        DO I=1,512
         BIN2(I)=-888.88
        ENDDO
C 
        CALL UNFLD1(v0,xniq,inob(ileg),ibst(ileg),nb,bin(1),
     +                bin2(1),nbins)
C 
        DO I=1,512
         BIN(I)=BIN2(I)
        ENDDO
CC
      ENDIF 
CC
      RETURN
      END
