$ tables on
C These routines use plot10 calls to plot arrows pointing with wind
C or meteorological wind barbs.
	subroutine plot_arrow(x, y, shaft, u, v)
C shaft is length, in inches, of arrow shaft.
	spd = sqrt(u*u + v*v)
	dx = shaft * u / spd
	dy = shaft * v / spd
	call plot(x,y,3)
	call plot(x+dx, y+dy, 2)
C the arrow head:
C arrow edge scaled by length of shaft
	edge = sqrt (dx**2 + dy**2) * 0.2
	theta = atan2(-dy,-dx)
C draw edges 30 degrees from point
	th = theta + .5235 ! +30 deg
	call plot(x+dx, y+dy, 3)
	call plot(x+dx+edge*cos(th), y+dy +edge*sin(th),2)
	th = theta - .5235 ! -30 deg
	call plot(x+dx, y+dy, 3)
	call plot(x+dx+edge*cos(th), y+dy +edge*sin(th),2)
	return
	end
C -------------------
      subroutine plot_barb_wd(xc,yc,dir,spd,shaft)
C Draw a wind barb from xc, yc that is shaft inches long
C given speeds in m/s, and dir is met angle in degrees
      real xc, yc, shaft, dir, spd, ang 
      parameter(deg2rad = 0.0174533)
	real vel, xe, ye, xt, yt, qos, syn, qosp, synp
C 
	slant = 70.0 ! slant for barbs
      ang = amod(450.0-dir,360.0)*deg2rad 
      vel = spd * 2.0 ! m/s to knots
      if(vel.lt.0)then
              return
      else if(vel.eq.0.0)then !calm 
              return
      end if
      qos = cos(ang)
      syn = sin(ang)
	c_slant = cosd(slant)
	s_slant = sind(slant)
      dr = shaft * 0.1 ! spacing along shaft
      dx = dr * qos 
      dy = dr * syn 
      barb_len = shaft * 0.25
      qosp = barb_len * (qos * c_slant + syn * s_slant) !  =  cos (ang-70)*barb  
      synp = barb_len * (syn * c_slant - qos * s_slant) !  =  sin (ang-70) 
      xe = xc + shaft * qos
      ye = yc + shaft * syn
	call plot(xc, yc, 3)
	call plot(xe, ye, 2)
10    if(vel.ge.48.0)then  ! draw flag 
              xe = xe-dx
              ye = ye-dy
              xt = xe+qosp
              yt = ye+synp
		call plot( xt, yt, 2)
		call plot(xe, ye, 2)
              vel = vel-50.0
              go to 10
      end if
20    if(vel.ge.8.0)then ! draw barb
              xt = xe+qosp
              yt = ye+synp
		call plot(xe, ye, 3)
		call plot(xt, yt, 2)
              xe = xe-dx
              ye = ye-dy
		vel = vel - 10.0
              go to 20
      end if
      if(vel.ge.3.0)then
C             draw half bar 
              xt = xe+0.5*qosp
              yt = ye+0.5*synp
		call plot(xe, ye, 3)
		call plot(xt, yt, 2)
      end if
      return
      end 
C -------------------
      subroutine plot_barb_uv(xc,yc,u,v,shaft)
C Draw a wind barb from xc, yc that is shaft inches long
C given u, v in m/s, and dir is met angle in degrees
      real xc, yc, shaft, u, v, ang 
	real vel, xe, ye, xt, yt, qos, syn, qosp, synp
C 
	slant = 70.0 ! degrees
      vel = sqrt(u*u + v*v) * 2.0 ! m/s to knots
      if(vel.le.0)then
              return
      end if
	ang = atan2(-v, -u) ! angle of flag blowing with the wind
      qos = cos(ang)
      syn = sin(ang)
	c_slant = cosd(slant)
	s_slant = sind(slant)
      dr = shaft * 0.1 ! spacing along shaft
      dx = dr * qos 
      dy = dr * syn 
      barb_len = shaft * 0.25
      qosp = barb_len * (qos * c_slant + syn * s_slant) !  =  cos (ang-70)*barb  
      synp = barb_len * (syn * c_slant - qos * s_slant) !  =  sin (ang-90) 
      xe = xc + shaft * qos
      ye = yc + shaft * syn
	call plot(xc, yc, 3)
	call plot(xe, ye, 2)
	iflag = 0
10    if(vel.ge.48.0)then  ! draw flag 
		iflag = 1
              xe = xe-dx
              ye = ye-dy
              xt = xe + qosp
              yt = ye + synp
		call plot( xt, yt, 2)
		call plot(xe, ye, 2)
              vel = vel-50.0
              go to 10
      end if
20    if(vel.ge.8.0)then ! draw barb
		iflag = 1
              xt = xe + qosp
              yt = ye + synp
		call plot(xe, ye, 3)
		call plot(xt, yt, 2)
              xe = xe - dx
              ye = ye - dy
		vel = vel - 10.0
              go to 20
      end if
      if(vel.ge.3.0)then ! draw half bar 
	if(iflag .eq. 0)then ! move down from end of shaft
              xe = xe - dx
              ye = ye - dy
	end if
	xt = xe + 0.5 * qosp
	yt = ye + 0.5 * synp
	call plot(xe, ye, 3)
	call plot(xt, yt, 2)
      end if
      return
      end 

