C all the subroutines for lambert conformal maps in a library 
C 	HP-UX version
      subroutine lamcon_map_sub(xl, yb, rlat, rlon, radkm, 
     +	radinch, lamcon, fil, cone, hemis, xscale, yscale, 
     +  xcen, ycen, w, label, csiz)
C Produce a lambert conformal map on a plotter using tek type calls.
C initialize plotter in main
C lifted out of NCAR Supmap documentation 
C uses calcomp plot calls...link with dmlib for dot matrix,etc. 
C 23-Feb 1987 added clipping to gulf stream plotter 
C note... this sub does NOT initialize plotter and does not close 
C plot when done...so do that stuff outside 
C w(1:4) is plot window which calling program must supply
      parameter(for5=0.7853982,pi180=.0174533)
      integer hemis ! +1 for Northern Hemisphere, -1 for Southern 
      real kmdeglat,kmdeglon,w(4) ! w is clipping window
      logical lamcon
      character*32 fil,half(-1:1)*5,string*40,label*40
      integer*2 istring(20) 
C 
      data half/'South','Equtr','North'/, lunit/24/ 
      if(rlat.gt.0.0)then 
              hemis=+1
      else
              hemis=-1
      endif 
C      diam=2.0*radkm
	xkm = ( w(3) - w(1) ) * 0.5 * radkm / radinch
	ykm = ( w(4) - w(2) ) * 0.5 * radkm / radinch
	xext = 2.0 * xkm
	yext = 2.0 * ykm
      call setmap(rlat,rlon,xkm,ykm,xext,yext,XLATMN,XLATMX,
     +        XLONMN,XLONMX,kmdeglat,kmdeglon)
      if(lamcon)then
C bounding parallels: 
        th1=(rlat+radkm/kmdeglat)*pi180 
        th2=(rlat-radkm/kmdeglat)*pi180 
        write(6,*)'parallels:',th1/pi180,th2/pi180
C cone factor:
        cone=log10(cos(th1))-hemis*log10(cos(th2))
        cone=cone/(log10(tan(for5-hemis*th1*0.5))-
     +        log10(tan(for5-hemis*th2*0.5))) 
C scaling and translation factors:
        call lam_proj(rlat,rlon,ucen,vcen,cone,rlon,hemis)
        call lam_proj(xlatmx,rlon,uup,vup,cone,rlon,hemis)
        xscale=radinch/(vup-vcen) 
        yscale=xscale 
C mod 9 march 92 so clat, clon map to center of plot window

        xcen = -ucen * xscale + (w(3) - w(1) ) * 0.5 ! radinch 
        ycen = -vcen * yscale + (w(4) - w(2) ) * 0.5 ! radinch 
cD       write(6,120)rlat,rlon,th1/pi180,th2/pi180,cone,radkm/radinch, 
cD    +       half(hemis) 
cd120     format(' Lambert conformal conical projection. Center: ', 
cd    +        f5.2,1x,f7.2,' Bounding parallels:',2(1x,f5.2)/,
cd    +        ' Cone factor: ',f1.6,' Km per inch: ',f9.2/, 
cd    +        ' Hemisphere: ',a5) 
C mod added 5 June 1996 for correct corners:
C get lat lon of box corners:
	clon = rlon
	u1 = (w(1) - xl - xcen) / xscale
	v1 = (w(2) - yb - ycen) / yscale
	u2 = (w(3) - xl - xcen) / xscale
	v2 = (w(4) - yb - ycen) / yscale
	call inv_lam_proj(u1, v1, ylat_ll, xlon_ll, cone, clon, hemis)
	write(6,*)' Lat, lon lower left corner: ',ylat_ll, xlon_ll
	call inv_lam_proj(u2, v1, ylat_lr, xlon_lr, cone, clon, hemis)
	write(6,*)' Lat, lon lower right corner: ',ylat_lr, xlon_lr
	call inv_lam_proj(u2, v2, ylat_ur, xlon_ur, cone, clon, hemis)
	write(6,*)' Lat, lon upper right corner: ',ylat_ur, xlon_ur
	call inv_lam_proj(u1, v2, ylat_ul, xlon_ul, cone, clon, hemis)
	write(6,*)' Lat, lon upper left corner: ',ylat_ul, xlon_ul
	xlatmn = min(ylat_ll, ylat_lr, ylat_ur, ylat_ul)
	xlatmx = max(ylat_ll, ylat_lr, ylat_ur, ylat_ul)
	xlonmn = min(xlon_ll, xlon_lr, xlon_ur, xlon_ul)
	xlonmx = max(xlon_ll, xlon_lr, xlon_ur, xlon_ul)
      else ! for flat earthers: 
        xscale=(radinch/radkm)*kmdeglon 
        yscale=(radinch/radkm)*kmdeglat 
        xcen=0. ! because dotmap for Luddites uses lower left corner
        ycen=0. ! as origin for translation 
cD       write(6,121)rlat,rlon,radkm/radinch 
121     format(' Flat Earth projection centered at: ',f5.2,f7.2,
     +        ' Km per inch: ',f9.2)
      endif 
cD     WRite(6,*)',xc,yc,xscl,yscl,cone',XCEN,YCEN,XSCALE,yscale,CONe
C do it:
c      call dotmap(fil,lamcon,XLATMN,XLATMX,XLONMN,XLONMX, 
c     +        xcen,ycen,xscale,yscale,cone,rlon,hemis,w)
C and lines at north and east:
C      call plot(xl+radinch,yb+2.0*radinch-0.5,3)
C      call plot(xl+radinch,yb+2.0*radinch,2)
C     call plot(xl+2.0*radinch-0.5,yb+radinch,3)
C     call plot(xl+2.0*radinch,yb+radinch,2)
C 
C Finally a legend at the bottom: 
	if( label .ne. 'none')then
C first a distance scale above label
	  x = w(3) + 0.2
	  y = yb + 1.0 + 3.0 * csiz
	  call dis_scale(w, radinch, radkm, x, y, 10, csiz)
      string='Lambert Conformal Conical Projection' 
      read(string,'(20(a2))')istring
      nchar=36
      y = yb + 1.0 
      call symbl(x,y,csiz,istring,0.0,nchar) 
      string='Centered at +nn.nn, -mmm.mm. Bounding'
      nchar=37
      y = yb +0.8 
      write(string(13:27),'(f6.2,1x,f7.2)')rlat,rlon
      read(string,'(20(a2))')istring
      call symbl(x,y,csiz,istring,0.0,nchar) 
      string='Parallels +nn.nn, +nn.nn. Km/in: nnn.m' 
      write(string(11:24),'(f6.2,1x,f6.2)')th1/pi180,th2/pi180
      write(string(34:38),'(f5.1)')radkm/radinch
      nchar=38
      y = yb + 0.6 
      read(string,'(20(a2))')istring
      call symbl(x,y,csiz,istring,0.0,nchar) 
      y = yb + 0.4 
      read(label,'(20(a2))')istring 
      call symbl(x,y,csiz,istring,0.0,40)
	end if
      end 
C **********************************
      subroutine setmap(olat,olon,xkm,ykm,xext,yext,XLATMN,XLATMX,
     +        XLONMN,XLONMX,kmdeglat,kmdeglon)
      real kmdeglat,kmdeglon
C  THIS subroutine CALCULATES THE MIN AND MAX LATITUDE AND
C  LONGITUDE FOR THE CURRENT window.
C     This stolen from PAL by Peter D. and made a subroutine
C     Modified on july 2 85 as per Mike Black's corrections 
C     now uses correct km/deg for midpoint of picture 
C  SET SCALE FACTOR TO KILOMETERS PER DEGREE AVERAGE
      radlat=olat*0.0174533 ! degrees to radians
C trig series from Bowditch:
      kmdeglat=111.13209-0.56605*cos(2.*radlat)+
     +        0.00012*cos(4.0*radlat)-0.000002*cos(6.*radlat) 
      kmdeglon=111.41513*cos(radlat)-0.09455*cos(3.*radlat)+
     +        0.00012*cos(5.*radlat)
C  CALCULATE MAP LAT AND LON LIMITS. LONGITUDE VALUES INCREASE
C  TO THE LEFT (WEST OF 0 DEGREES). 
      XLATMN = OLAT - YKM / kmdeglat
      XLATMX = OLAT + (YEXT-YKM) / kmdeglat 
      XLONMn = OLON - XKM / kmdeglon
      XLONMx = OLON + (XEXT - XKM) / kmdeglon 
      write(6,*)'XL = ',XLATMN,XLATMX,XLONMn,XLONMx
      return
      END 
C ******************************* 
      SUBROUTINE dotmap(fil,lamcon,XLATMN,XLATMX,XLONMN,XLONMX, 
     +        xcen,ycen,xscale,yscale,cone,cenlon,hemis, w)
C  THIS  TAKES AS INPUT THE MAP LIMITS FOR THE CURRENT
C  COMPOSITE AND PLOTS THE GEOGRAPHY WITHIN THOSE LIMITS. 
C Stolen by Peter d. from PAL and modified to ask no questions. 
C fil determines which geography data file to use, lamcon determines
C whether to use lambert conformal conic or flat earth proj.
C West Hemisphere lons are <0.
      integer hemis ! +1=N. Hemisphere, -1=S. Hemisphere
      DIMENSION RBUF(2,100) 
      CHARACTER*32 fil, head*28
      logical lamcon, visible
	real w(4) ! clipping window, in inches.
      DATA LP /14/
	xl = w(1)
	yb = w(2)
C  OPEN DATA FILE which on HP-UX is unformatted file
700   OPEN(LP,FILE=fil,status='old',form = 'unformatted',
     +		IOSTAT=IERR,ERR=100)
C  READ DATA FILE MAPPING LIMITS
	read(lp)head ! this because header is ASCII !
      READ(head,65,IOSTAT=IERR,ERR=150) YMIN,YMAX,XMIN,XMAX 
65    FORMAT(4F7.2) 
C  WRITE DATA FILE MAPPING LIMITS TO CNS
	WRite(6,'("MAP FILE LATITUDE LIMITS ",2(F7.2,1X))') YMIN,YMAX 
	WRite(6,'("MAP FILE LONGITUDE LIMITS ",2(F7.2,1X))') XMIN,XMAX
C  READ LOOP
	xp = 0.0
	yp = 0.0
201   CONTINUE
COUT      if(ifbrk().lt.0) go to 600 ! close file, then return
      READ(LP,IOSTAT=IERR,ERR=900,END=600)((RBUF(I,J),I=1,2),J=1,100) 
      DO 300 ICNT=1,100 
C  CHECK FOR PEN-UP MARKER
      IF(RBUF(1,ICNT).EQ.-200.)then ! pen up instruction
C debug write(6,*)' pen up. icnt = ',icnt
		GO TO 11 
	end if
C  READ LATS AND LONS 
      RLAT=RBUF(2,ICNT) 
      RLON=RBUF(1,ICNT) 
C primitive clipping:
C  CHECK COORDINATES TO SEE IF WITHIN MAP LIMITS
	IF( (RLAT .GT. XLATMX) .OR. (RLAT .LT. XLATMN) .or.
     +	  (RLON .GT. XLONMX) .OR. (RLON .LT. XLONMN) ) then
		go to 11
	end if
C  CALCULATE inch LOCATIONS 
      if(.not.lamcon)then 
        u=(rlon-xlonmn) 
        v=(rlat-xlatmn) 
      else ! use lambert conformal conical proj 
        call lam_proj(rlat,rlon,u,v,cone,cenlon,hemis)
      endif 
      x = xl + u * xscale + xcen 
      y = yb + v * yscale + ycen 
C  WRITE OUT COORDINATES AND PEN VALUES 
cD      WRite(6,871)X,Y,RLAT,RLON,IP 
cD 871  FORMAT(' X,Y ',2F10.2,' LAT,LON ',2F10.2,I5) 
C  MOVE TO NEXT POINT WITH PEN UP OR DOWN 
c     IF (IP.EQ.2) CALL TVLABS (IX,IY,icolor) ! PEN DOWN
c     IF (IP.EQ.3) CALL TVSETC(IX,IY) ! PEN UP
	if( ip .eq. 3)then ! pen up move
		xp = x
		yp = y
		call plot( x, y, 3)
	else if(ip .eq. 2) then ! pen down, so clip:
		call wclip(xp,yp,x,y,w,visible, ic_code) 
		if(visible)then 
		  if(ic_code .eq. 0)then ! line was not modified
			call plot(x, y, 2)
		  else ! line clipped, so have to do pen up move too
			call plot(xp, yp, 3)
			call plot(x, y, 2)
		  end if
		end if
		xp = x
		yp = y
	end if
      IP=2
      GO TO 300 
11    IP=3
300   CONTINUE
      GO TO 201 
100   WRite(6,'("OPEN ERROR ",I5," ON FILE ",a32)') IERR,fil
      GO TO 600 
150   WRite(6,'("READ ERROR ",I5," ON FILE ",a32)') IERR,fil 
600   CONTINUE
      CLOSE(LP) ! CLOSE DATA FILE 
      RETURN ! RETURN TO CALLING SEGMENT
900   WRite(6,'("ERROR ",I5," ON FILE ",I3)')IERR,LP
      GO TO 201 
      END 
C ******************************* 
      subroutine lam_proj(rlat,rlon,u,v,cone,cenlon,hemis)
C lifted out of NCAR Supmap documentation 
      parameter(for5=0.7853982,pi180=.0174533)
      integer hemis ! +1= N. Hemisphere, -1= S. Hemisphere
      rfac=(tan(for5-hemis*rlat*0.5*pi180))**cone 
      u=rfac*sin(cone*(rlon-cenlon)*pi180)
      v=-hemis*rfac*cos(cone*(rlon-cenlon)*pi180) 
cd     write(6,*)'rfac,u,v',rfac,u,v 
      return
      end 
C
	subroutine inv_lam_proj(u,v,rlat,rlon,cone,cenlon,hemis)
C Inverse of lambert conformal
      parameter(for5=0.7853982)
      integer hemis ! +1= N. Hemisphere, -1= S. Hemisphere
	rad2deg = 180.0 / acos(-1.0)
	rfac = sqrt(u*u + v*v)
	stuff = atan(rfac**(1.0/cone))
	rlat = (for5-stuff)*2.0*hemis * rad2deg
	stuff = atan2(u, -v)
	rlon = (stuff / cone) * rad2deg + cenlon
	return
	end	
C *********************8
      subroutine get_map_par(ioutlu,rlat,rlon,radkm,radinch, 
     + fil) 
C get parameters for lamcon_map_sub 
C ioutlu = 1 if plotting to dot matrix (6)...else can use 6
      character*32 fil
20       format(a32)
      Write(ioutlu,*)' Enter center point of map(lat,lon):_' 
      read(5,*)rlat,rlon
      write(ioutlu,*)' Enter radius of area (km):_'
      read(5,*)radkm
      write(ioutlu,*)' Enter radius for plot (in):_' 
      read(5,*)radinch
C pick data file: 
      write(ioutlu,*)' Enter name of geography file:_'
      read(5,20)fil 
      return
      end     
C ************************* 
C ******************************
      subroutine set_proj(clat,clon,radkm,cone,xsc,ysc,xc,yc,hemis) 
C set factors to use lambert confromal proj and 
C return scaling so that u,v can be translated into 
C km relative to clat and clon. use this when don't 
C want to plot anything 
C input: clat, clon, radkm
      real kmdeglat, kmdeglon 
      integer hemis 
      parameter(for5=0.7853982,pi180=.0174533)
      kmdeglat=111.13209-0.56605*cosd(2.*clat)+
     +        0.00012*cosd(4.0*clat)-0.000002*cosd(6.*clat) 
      kmdeglon=111.41513*cosd(clat)-0.09455*cosd(3.*clat)+
     +        0.00012*cosd(5.*clat)
        th1=(clat+radkm/kmdeglat)*pi180 
        th2=(clat-radkm/kmdeglat)*pi180 
cd     write(6,*)'parallels:',th1/pi180,th2/pi180
C cone factor:
        cone=log10(cos(th1))-hemis*log10(cos(th2))
        cone=cone/(log10(tan(for5-hemis*th1*0.5))-
     +        log10(tan(for5-hemis*th2*0.5))) 
C scaling and translation factors:
        call lam_proj(clat,clon,ucen,vcen,cone,clon,hemis)
        xlat100 = clat + 100. / kmdeglat ! 100 km away from clat
        call lam_proj(xlat100,clon,uup,vup,cone,clon,hemis) 
        xsc = 100.0 /(vup-vcen) 
        ysc = xsc 
        xc = -ucen*xsc
        yc = -vcen*ysc
      return
      end 
C ------------------------------------
      subroutine bnding_box(grid_inc,ylatmn,ylatmx,xlonmn,xlonmx,
     +        xcen,ycen,xscale,yscale,cone, 
     +        cenlon,hemis,w) 
      real w(4) ! clipping window 
      logical cool,visible
      integer hemis 
C  THIS subroutine plots box and lat and lon tick marks
C  use lambert conformal conical proj.
      if(grid_inc.le.0.0)then 
              return
      end if
C Bounding lines. Lat lines curve, so do as 100 segments
	del=(xlonmx-xlonmn)*0.01
	call lam_proj(ylatmx,xlonmn,u,v,cone,cenlon,hemis) 
	xb=u*xscale+xcen
	yb=v*yscale+ycen
	call plot(xb,yb,3)
	do i = 1, 100
	  call lam_proj(ylatmx,xlonmn+i*del,u,v,cone,cenlon,hemis)
          xe=u*xscale+xcen
          ye=v*yscale+ycen
          call plot(xe,ye,2)
	end do 
C
	call lam_proj(ylatmn,xlonmn,u,v,cone,cenlon,hemis) 
	xb=u*xscale+xcen
	yb=v*yscale+ycen
	call plot(xb,yb,3)
	do i = 1, 100
	  call lam_proj(ylatmn,xlonmn+i*del,u,v,cone,cenlon,hemis)
          xe=u*xscale+xcen
          ye=v*yscale+ycen
          call plot(xe,ye,2)
	end do 
C Lon lines are straight:
	call lam_proj(ylatmn,xlonmn,u,v,cone,cenlon,hemis) 
              xb=u*xscale+xcen
              yb=v*yscale+ycen
        call lam_proj(ylatmx,xlonmn,u,v,cone,cenlon,hemis)
              xe=u*xscale+xcen
              ye=v*yscale+ycen
              call plot(xb,yb,3)
              call plot(xe,ye,2)
	call lam_proj(ylatmn,xlonmx,u,v,cone,cenlon,hemis) 
              xb=u*xscale+xcen
              yb=v*yscale+ycen
        call lam_proj(ylatmx,xlonmx,u,v,cone,cenlon,hemis)
              xe=u*xscale+xcen
              ye=v*yscale+ycen
              call plot(xb,yb,3)
              call plot(xe,ye,2)
C Now do tick marks
      slatmn=anint(ylatmn-grid_inc) 
      slatmx=anint(ylatmx+grid_inc) 
      slonmn=anint(xlonmn-grid_inc) 
      slonmx=anint(xlonmx+grid_inc) 
C horizontal lines
      del = 0.1
	del_s = 0.05
      nln=anint(slatmx-slatmn)+1
      nlg=1.0/grid_inc-1 ! number of dashed lines to do 
      start=slatmx+1.0
      do i=1,nln
       start=start-1.0
C the solid, degree line: 
	call lam_proj(start,xlonmn,u,v,cone,cenlon,hemis) 
              xb=u*xscale+xcen
              yb=v*yscale+ycen
        call lam_proj(start,xlonmn+del,u,v,cone,cenlon,hemis)
              xe=u*xscale+xcen
              ye=v*yscale+ycen
C              call wclip(xb,yb,xe,ye,w,visible,ic_code) 
C              if(visible)then 
                call plot(xb,yb,3)
                call plot(xe,ye,2)
C              endif 
	call lam_proj(start,xlonmx,u,v,cone,cenlon,hemis) 
              xb=u*xscale+xcen
              yb=v*yscale+ycen
        call lam_proj(start,xlonmx-del,u,v,cone,cenlon,hemis)
              xe=u*xscale+xcen
              ye=v*yscale+ycen
C              call wclip(xb,yb,xe,ye,w,visible, ic_code)
C             if(visible)then 
                call plot(xb,yb,3)
                call plot(xe,ye,2)
C             endif 
       do ii=1,nlg
         stg=start+ii*grid_inc
              call lam_proj(stg,xlonmn,u,v,cone,cenlon,hemis) 
              xb=u*xscale+xcen
              yb=v*yscale+ycen
              call lam_proj(stg,xlonmn+del_s,u,v,cone,cenlon,hemis) 
              xe=u*xscale+xcen
              ye=v*yscale+ycen
                call plot(xb,yb,3)
                call plot(xe,ye,2)
C
              call lam_proj(stg,xlonmx,u,v,cone,cenlon,hemis) 
              xb=u*xscale+xcen
              yb=v*yscale+ycen
              call lam_proj(stg,xlonmx-del_s,u,v,cone,cenlon,hemis) 
              xe=u*xscale+xcen
              ye=v*yscale+ycen
                call plot(xb,yb,3)
                call plot(xe,ye,2)
       end do 
      end do
C vertical lines
      nln=anint(slonmx-slonmn)+1
      nlg=1.0/grid_inc-1 ! number of dashed lines to do 
      start=slonmx+1.0
      do i=1,nln
       start=start-1.0
C the solid, degree line: 
	call lam_proj(ylatmn,start,u,v,cone,cenlon,hemis) 
              xb=u*xscale+xcen
              yb=v*yscale+ycen
	call lam_proj(ylatmn+del,start,u,v,cone,cenlon,hemis)
              xe=u*xscale+xcen
              ye=v*yscale+ycen
C              call wclip(xb,yb,xe,ye,w,visible, ic_code)
C              if(visible)then 
                call plot(xb,yb,3)
                call plot(xe,ye,2)
C              endif 
C
	call lam_proj(ylatmx,start,u,v,cone,cenlon,hemis) 
              xb=u*xscale+xcen
              yb=v*yscale+ycen
	call lam_proj(ylatmx-del,start,u,v,cone,cenlon,hemis)
              xe=u*xscale+xcen
              ye=v*yscale+ycen
C              call wclip(xb,yb,xe,ye,w,visible, ic_code)
C              if(visible)then 
                call plot(xb,yb,3)
                call plot(xe,ye,2)
C              endif 
C inbetween, dotted lines 
       do ii=1,nlg
         stg=start+ii*grid_inc
	call lam_proj(ylatmn,stg,u,v,cone,cenlon,hemis) 
              xb=u*xscale+xcen
              yb=v*yscale+ycen
	call lam_proj(ylatmn+del_s,stg,u,v,cone,cenlon,hemis) 
              xe=u*xscale+xcen
              ye=v*yscale+ycen
                 call plot(xb,yb,3)
                call plot(xe,ye,2) 
 	call lam_proj(ylatmx,stg,u,v,cone,cenlon,hemis) 
              xb=u*xscale+xcen
              yb=v*yscale+ycen
	call lam_proj(ylatmx-del_s,stg,u,v,cone,cenlon,hemis) 
              xe=u*xscale+xcen
              ye=v*yscale+ycen
                 call plot(xb,yb,3)
                call plot(xe,ye,2) 
        end do 
      end do
100   RETURN
      END 
C -----------------------------
	subroutine dis_scale(w, sc_in, sc_km, xd, yd, n10, csiz)
	real w(4) ! clipping window, not used yet
	character*4 string
	integer*2 istring(2)
c  draw km scale and label every 50 km
	delta = 10.0 * sc_in / sc_km ! 10 km  
	tick_siz = 0.5 * csiz
	call plot(xd, yd, 3)
	call plot(xd + n10 * delta, yd, 2)
	call plot(xd, yd, 3)
	call plot(xd, yd + csiz, 2)
	if(n10 .lt. 20)then ! 50 km labels
		ilab_div = 50
	else
		ilab_div = 100
	end if
C now do ticks
	string = ' 0'
	read(string(1:2),'(a2)')istring(1)
	nc = 2
	call symbl(xd - nc * 0.5 * csiz, yd - 1.5 * csiz, csiz, 
     +			istring, 0.0, nc)
	do i = 1, n10
	  x = xd + i * delta 
	  idis = i * 10
	  if( mod(idis, ilab_div) .eq. 0)then
	  	call plot(x, yd, 3) 
		call plot(x, yd + csiz, 2) 
		write(string,'(i4)')idis
		read(string,'(2a2)')istring
Cout		nc = log10(float(idis)) + 1
		nc = 4
		call symbl(x - nc * 0.5 * csiz, yd - 1.5 * csiz, csiz, 
     +			istring, 0.0, nc)
	  else
	  	call plot(x, yd, 3) 
		call plot(x, yd + tick_siz, 2) 
	  end if
	end do
	string(1:2) = 'km'
	read(string,'(a2)')istring(1)
	nc = 2
	call symbl(x+2.0*csiz, yd - 1.5 * csiz, csiz, istring, 0.0, 2)
C Added 2 km ticks for 0-10, to help in reading distances
	do i = 2, 8, 2
	  x = xd + i * delta * 0.1 
	  call plot(x, yd, 3) 
	  call plot(x, yd - tick_siz, 2) 
	end do
	return
	end
      subroutine short_grid_lines(xleft, ybottom, grid_inc,
     +		xlatmn,xlatmx,xlonmn,xlonmx,
     +        xcen,ycen,xscale,yscale,cone, 
     +        cenlon,hemis,w, ipen1, ipen2, csiz) 
      real w(4) ! clipping window 
      logical cool,visible
      integer hemis 
	integer*2 istring(3)
	character string*6
C  THIS subroutine plots lat and lon grid 
C  use lambert conformal conical proj.
C version that joins lines at whole degree intersections, instead of
C lotsa a little segments..
C 13 August 1996: added labels to lat and lons
      if(grid_inc.le.0.0)then 
              return
      end if
      slatmn=anint(xlatmn-grid_inc) 
      slatmx=anint(xlatmx+grid_inc) 
      slonmn=anint(xlonmn-grid_inc) 
      slonmx=anint(xlonmx+grid_inc) 
	if( grid_inc .gt. 2.0 )then ! adjust starts so on 5 deg inc
		n = int( slatmx ) / 5
		slatmx = (n+1) * 5.0
		n = int( slonmx ) / 5
		slonmx = (n+1) * 5.0
	else if( grid_inc .gt. 1.0 )then ! adjust to start on even deg
		n = int( slatmx ) / 2
		slatmx = (n+1) * 2.0
		n = int( slonmx ) / 2
		slonmx = (n+1) * 2.0
	end if
C crosses at whole degrees
C	call newpn(ipen1)
	if (grid_inc .lt. 1.0) then
		nln_lon =anint(slonmx-slonmn)+1
		nln_lat = anint(slatmx-slatmn)+1
		deg_inc = 1.0
	else
		nln_lon = (slonmx-slonmn) / grid_inc + 1
		nln_lat = (slatmx-slatmn)/ grid_inc + 1
		deg_inc = grid_inc
	end if
C Latitude lines at grid_inc:
      start_lat = slatmx + deg_inc
      istart_lat = start_lat
      do i = 1, nln_lat
       start_lat = start_lat - deg_inc
        istart_lat=start_lat
	write(string(1:2),'(i2)')istart_lat
	read(string,'(a2)')istring(1)
	start_lon = slonmx + deg_inc
	call lam_proj(start_lat,start_lon,
     +		u,v,cone,cenlon,hemis) 
        xb = xleft + u*xscale+xcen
        yb = ybottom + v*yscale+ycen
	icut = 0
	do j = 1, nln_lon
       	   start_lon = start_lon - deg_inc
           call lam_proj(start_lat,start_lon,
     +		u,v,cone,cenlon,hemis) 
           xe = xleft + u*xscale+xcen
           ye = ybottom + v*yscale+ycen
           call wclip(xb,yb,xe,ye,w,visible,ic_code) 
           if(visible)then 
                call plot(xb,yb,3)
                call plot(xe,ye,2)
		if( ic_code .eq. 1 ) then ! cut edge of window, so label
		  icut = icut + 1
		  if( icut .eq. 2 ) then ! xe, ye right
		    call symbl(w(3)+csiz, ye, csiz, istring, 0.0, 2)
		  else if( icut .eq. 1) then ! xb, yb left
		    call symbl(w(1)-2.5*csiz, ye, csiz, istring, 0.0, 2)
		  end if
		end if
           endif 
	   xb = xe
	   yb = ye
	   if( grid_inc .gt. 1.0) then ! add tick marks
		do ig = 1, grid_inc-1
		  call lam_proj(start_lat+0.2,start_lon + ig,
     +			u,v,cone,cenlon,hemis) 
		  x1 = xleft + u*xscale+xcen
           	  y1 = ybottom + v*yscale+ycen
		  call lam_proj(start_lat-0.2,start_lon+ig,
     +			u,v,cone,cenlon,hemis) 
		  x2 = xleft + u*xscale+xcen
           	  y2 = ybottom + v*yscale+ycen
		  call wclip(x1,y1,x2,y2,w,visible,ic_code) 
           	  if(visible)then 
                	call plot(x1,y1,3)
                	call plot(x2,y2,2)
           	  endif 
		end do
	   end if
	end do
      end do
C
C Longitude lines at grid_inc:
	start_lon = slonmx + deg_inc
      do i = 1, nln_lon
       	start_lon = start_lon - deg_inc
	if( abs(start_lon) .lt. 10) then
		nch = 2
                istart_lon = abs(start_lon)
                write(6,*)'start_lon,istart_lon = ',start_lon,istart_lon
		write(string(1:2),'(i2)')istart_lon
		read(string,'(a2)')istring(1)
	else
		nch = 3
                istart_lon=start_lon
		write(string(1:3),'(i3)')istart_lon
		read(string,'(2a2)')istring(1), istring(2)
	end if
        start_lat = slatmx + deg_inc
	call lam_proj(start_lat,start_lon,
     +		u,v,cone,cenlon,hemis) 
        xb = xleft + u*xscale+xcen
        yb = ybottom + v*yscale+ycen
	icut = 0
	do j = 1, nln_lat
           start_lat = start_lat - deg_inc
           call lam_proj(start_lat,start_lon,
     +		u,v,cone,cenlon,hemis) 
           xe = xleft + u*xscale+xcen
           ye = ybottom + v*yscale+ycen
           call wclip(xb,yb,xe,ye,w,visible,ic_code) 
           if(visible)then 
                call plot(xb,yb,3)
                call plot(xe,ye,2)
		if( ic_code .eq. 1 ) then ! cut edge of window, so label
		  icut = icut + 1
		  if( icut .eq. 2 ) then ! xe, ye bottom
		    call symbl(xb - 0.5*nch*csiz, w(2)-1.5*csiz, csiz, 
     +			istring, 0.0, nch)
		  else if( icut .eq. 1 ) then ! xb, yb top
		    call symbl(xb - 0.5*nch*csiz, w(4)+0.5*csiz, csiz, 
     +			istring, 0.0, nch)
		  end if
		end if
           endif 
	   xb = xe
	   yb = ye
	   if( grid_inc .gt. 1.0) then ! add tick marks
		do ig = 1, grid_inc-1
		  call lam_proj(start_lat+ig,start_lon + 0.2,
     +			u,v,cone,cenlon,hemis) 
		  x1 = xleft + u*xscale+xcen
           	  y1 = ybottom + v*yscale+ycen
		  call lam_proj(start_lat+ig,start_lon - 0.2,
     +			u,v,cone,cenlon,hemis) 
		  x2 = xleft + u*xscale+xcen
           	  y2 = ybottom + v*yscale+ycen
		  call wclip(x1,y1,x2,y2,w,visible,ic_code) 
           	  if(visible)then 
                	call plot(x1,y1,3)
                	call plot(x2,y2,2)
           	  endif 
		end do
	   end if
	end do
      end do
C crosses at incrments less than 1 degree:
	if (grid_inc .lt. 1.0) then ! <<<<<<<<<<<<<<<<<<<<<<<
		call newpn(ipen2)
		tick = 0.025 ! degrees
		nln_lon = (slonmx-slonmn) / grid_inc + 1
		nln_lat = (slatmx-slatmn)/ grid_inc + 1
      start_lat = slatmx+grid_inc
      do i=1,nln_lat
       start_lat = start_lat -grid_inc
	start_lon = slonmx + grid_inc
	do j =1,nln_lon
       	   start_lon = start_lon -grid_inc
C           call lam_proj(start_lat,start_lon,
C    +		u,v,cone,cenlon,hemis) 
C          xb = xleft + u*xscale+xcen
C          yb = ybottom + v*yscale+ycen
C		xe = xb
C		ye = yb
C          call wclip(xb,yb,xe,ye,w,visible,ic_code) 
C          if(visible)then 
C               call plot(xb,yb,3)
C               call plot(xb,yb,2)
C          endif 
           call lam_proj(start_lat,start_lon - tick,
     +		u,v,cone,cenlon,hemis) 
           xb = xleft + u*xscale+xcen
           yb = ybottom + v*yscale+ycen
           call lam_proj(start_lat,start_lon + tick,
     +		u,v,cone,cenlon,hemis)
           xe = xleft + u*xscale+xcen
           ye = ybottom + v*yscale+ycen
           call wclip(xb,yb,xe,ye,w,visible,ic_code) 
           if(visible)then 
                call plot(xb,yb,3)
                call plot(xe,ye,2)
           endif 
           call lam_proj(start_lat - tick,start_lon,
     +		u,v,cone,cenlon,hemis) 
           xb = xleft + u*xscale+xcen
           yb = ybottom + v*yscale+ycen
           call lam_proj(start_lat + tick,start_lon,
     +		u,v,cone,cenlon,hemis)
           xe = xleft + u*xscale+xcen
           ye = ybottom + v*yscale+ycen
           call wclip(xb,yb,xe,ye,w,visible,ic_code) 
           if(visible)then 
                call plot(xb,yb,3)
                call plot(xe,ye,2)
           endif 
	end do
      end do
	end if ! <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
C

	return
	end

