C jobfile_subroutines.f 
C These subroutines were derived from John Gamache;s jobfilemaker.
C Jobfilemaker generates the job files needed to run his automatic
C Doppler radar programs. I broke it into these subroutines and then
C wrote jobfile_display - an X display of the main parameters that can 
C be edited n a pseudo GUI way. The idea is to make this software easy to run
C on the airborne workstations.
C The "get" routines looks for oarameter files
C and if they do not exist, prompts to creat them.
C Parameter files:
C   radar_analysis_params.dat - contains analysis parameters taht should
C 	not change - grid sizea s dimwnaiona, weighting factors...
C   radar_flt_params.dat - flight specific details, such as aircraft
C	number, date, antenna type, storm name and the attitude
C	angle correction factors
C   radar_legs.dat - data for a specific analysis - storm position, motion,
C	center time, start time of inbound leg, and time of outbound
C	leg and azimuths of the two legs. This file is created by another
C	program called center_from_radar_tape.
C   angtest.txt - contain akternate set of attitude angle correction
C	factors create by previous runsa of John's software
C
C The routines are:
C  get_flight_params: If it exists, read radar_flt_params.dat. If not there
C	then ask user for all the values (a tedious process) and create file.
C  get_analysis_params: If file exist, read radar_analysis_params.dat.
C	Otherwise get user to enter them.
C  get_leg_params: If it exists, read radar_legs.dat. Otherwise, set 
C 	all missing (-999.9). User can supply info in jobfile_display.
C  write_flight_params: write radar_flt_params.dat file.
C  write_leg_params:  write radar)legs.dat file.
C  write_analysis_params: write radar_analysis_params.dat file.
C  get_alternate_corrs: Read angtest, if it exists, and ask user if want
C	to use these alternate valuse.
C  set_auto_corrs: ask user if they want the radar software to calculate
C	attitude angel correction factors. If so, set all the factors to zero.
C	might do this on first pass in each flight.
C  write_jobfiles:  read radar_legs.dat, radar_flt_params.dat, and
C	radar_abalysis_params.dat, ad use those parameters to compose
C	and write out 8 jobfiles that can be used by the radar software.
C 
C =====================================================================
	subroutine get_flight_params(IY, IM, ID, IAIR, FLT, EXP,
     +		IFRANCE, ISTORMNO, ibst, aft_AZMCOR, 
     +          aft_ELCOR,aft_RDELCOR,
     +		aft_PCOR, aft_DCOR, aft_RCOR, fore_AZMCOR, fore_ELCOR,
     +		fore_RDELCOR,fore_PCOR, fore_DCOR, fore_RCOR, 
     +          airborne_wkstn)

	integer IY,IM,ID,IAIR,IFRANCE,ISTORMNO
	character flt*8, exp*12, cplane*2, yesno*1
	logical exist, changed,airborne_wkstn, jg_corrs
C
	lu = 89 
	changed = .false.
C
 	inquire(file = 'radar_flt_params.dat', exist = exist)
	if( .not.exist) then
		write(6,*)'radar_flt_params.dat does not exist.'
		write(6,*)"We'll make it now."
C
1108  WRITE(6,*)'ENTER YEAR AS 2 DIGITS'
      READ(5,*,err=1108)IY
1109  WRITE(6,*)'ENTER MONTH AS 2 DIGITS'
      READ(5,*,err=1109)IM
1110  WRITE(6,*)'ENTER DAY AS 2 DIGITS'
      READ(5,*,err=1110)ID
22    		WRITE(6,*)'ENTER AIRCRAFT (EITHER 42 OR 43)'
      		READ(5,*,err=22)IAIR
      		IF(IAIR.EQ.42)THEN
       			CPLANE='H1'
      		ELSEIF(IAIR.EQ.43)THEN
       			CPLANE='I1'
      		ELSE
       			WRITE(6,*)'NUMBER MUST BE 42 OR 43'
       			GO TO 22
      		ENDIF
      write(flt,'(3i2.2,a2)')IY, IM, ID, CPLANE
      WRITE(6,*)'ENTER EXPERIMENT (EXAMPLE Isabel 03)'
      READ(5,'(A12)')EXP
1112  WRITE(6,*)'Enter ATCF Storm Number'
      READ(5,*,err=1112)ISTORMNO
1113   		WRITE(6,*)'Enter 0 for NOAA and 1 for French antenna'
      		READ(5,*,err=1113)IFRANCE

C On airborne wkstation force to 0 if file was not there
C so angle corrs will be calculated during analysis
	if(airborne_wkstn) then ! >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	 call set_auto_corrs(ibst, aft_AZMCOR, 
     +          aft_ELCOR,aft_RDELCOR,
     +		aft_PCOR, aft_DCOR, aft_RCOR, fore_AZMCOR, fore_ELCOR,
     +		fore_RDELCOR,fore_PCOR, fore_DCOR, fore_RCOR, 
     +          airborne_wkstn)
C otherwise prompt for values
	else ! >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
1115  WRITE(6,*)'Enter IBST'
      READ(5,*,err=1115)IBST
1116  WRITE(6,*)'Enter azimuth and elevation corrections for aft'
      READ(5,*,err=1116)aft_AZMCOR, aft_ELCOR
1117  WRITE(6,*)'Enter aft range delay in km'
      READ(5,*,err=1117)aft_RDELCOR
1118  WRITE(6,*)'Enter pitch, drift, and roll corrections for aft'
      READ(5,*,err=1118)aft_PCOR, aft_DCOR, aft_RCOR
1119  WRITE(6,*)'Enter azimuth and elevation corrections for fore'
      READ(5,*,err=1119)fore_AZMCOR, fore_ELCOR
1120  WRITE(6,*)'Enter fore range delay in km'
      READ(5,*,err=1120)fore_RDELCOR
1121  WRITE(6,*)'Enter pitch, drift, and roll corrections for fore'
      READ(5,*,err=1121)fore_PCOR, fore_DCOR, fore_RCOR
	end if ! <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	open(lu,file = 'radar_flt_params.dat', 
     +			form = 'formatted')
		write(lu,*)iair, ' Aircraft'
		write(lu,'(3i2.2," Date")')IY, IM, ID
		write(lu,'(A12)')EXP
		write(lu,*)ISTORMNO, ' ATCF Storm number'
		write(lu,*)IFRANCE, ' Antenna type, 1 = French'
		write(lu,*)aft_AZMCOR, aft_ELCOR, ' aft AZMCOR,_ELCOR'
		write(lu,*)aft_RDELCOR, ' aft RDELCOR'
		write(lu,*)aft_PCOR, aft_DCOR, aft_RCOR,
     +             ' Aft pcor, dcor, elcor'
		write(lu,*)fore_AZMCOR, fore_ELCOR, 
     +             ' Fore AZMCOR,_ELCOR'    
		write(lu,*)fore_RDELCOR, ' fore RDELCOR'
		write(lu,*)fore_PCOR, fore_DCOR, fore_RCOR, 
     +             ' FB ore pcor, dcor, elcor'
                write(lu,*)ibst, ' IBST'
		close(lu)
C
C 
C Following is to modify existing file
	else
		write(6,*)'Here are values from radar_flt_params.dat.'
		open(lu,file = 'radar_flt_params.dat', 
     +			form = 'formatted', status ='old')
		read(lu,*)iair
		read(lu,'(3i2.2)')IY, IM, ID
		IF(IAIR.EQ.42)THEN
		  write(flt,'(3i2.2,a2)')IY, IM, ID,'H1'
		else IF(IAIR.EQ.43) then
		  write(flt,'(3i2.2,a2)')IY, IM, ID,'I1'
		else
		  write(6,*)iair,' is bad plane id'
		  flt = 'garbage'
		end if
		read(lu,'(A12)')EXP
		read(lu,*)ISTORMNO
		read(lu,*)IFRANCE
		read(lu,*)aft_AZMCOR, aft_ELCOR
		read(lu,*)aft_RDELCOR
		read(lu,*)aft_PCOR, aft_DCOR, aft_RCOR
		read(lu,*)fore_AZMCOR, fore_ELCOR
		read(lu,*)fore_RDELCOR
		read(lu,*)fore_PCOR, fore_DCOR, fore_RCOR
                read(lu,*)ibst
		close(lu)
C
C Non Nav info:
		write(6,*)' Flight specific info:'
		write(6,*)'Aircraft: ',iair
		write(6,'("Date: ",3i2.2)')IY, IM, ID
		write(6,'("Experiment: ", A12)')EXP
		write(6,*)"ATCF Storm Number: ",ISTORMNO
		write(6,*)"Antenna type (1=French): ",IFRANCE
C
C
130		write(6,*)" Present angle and radial Correction Factors:"
                write(6,*)" IBST: ",ibst
		write(6,*)" aft AZMCOR, ELCOR: ",aft_AZMCOR, aft_ELCOR
		write(6,*)" aft RDELCOR: ",aft_RDELCOR
		write(6,*)" aft p, d, r COR: ",aft_PCOR, aft_DCOR, 
     +                      aft_RCOR
		write(6,*)" fore AZMCOR, ELCOR: ",fore_AZMCOR, 
     +                        fore_ELCOR
		write(6,*)" fore RDELCOR: ",fore_RDELCOR
		write(6,*)"fore p, d, r COR: ",fore_PCOR, 
     +                     fore_DCOR, fore_RCOR
C
C

	end if
	return
	end 
C =================================================================
	subroutine get_analysis_params(RADIUS, HREZ, ZRES, TREZ,
     +          HREZPROFILE, ZRESPROFILE, HEIGHTBOT, ROT,
     +          INOB, THRESH,DBZRS,DBZCOR,DBZSLOPE,SWTHRESH,
     +          FACTZ, HB2, DPB2, ZLOW, ZHIGH, airborne_wkstn)
	logical airborne_wkstn, exist
	character*1 yesno
C
	lu = 89 
C Temporarily, hardwire FACTZ:
	if (airborne_wkstn) then
		FACTZ = 1000.0
	end if
C
	inquire(file = 'radar_analysis_params.dat', exist = exist)
	if( .not.exist) then
		write(6,*)'radar_analysis_params.dat does not exist.'
C
2222  WRITE(6,*)'Enter max radius from storm center in km'
      READ(5,*,err=2222)RADIUS
      HREZSUGGEST=RADIUS/49.
2223  if(airborne_wkstn)THEN
	max_grid = 49
	grid_inc = 0.5
	call set_grid_params(radius, max_grid, grid_inc,
     +		dx, dy, xc, yc, ierror)
	hrez = dx
Cout       WRITE(6,*)'Horizontal resolution must be'
Cout       WRITE(6,*)'greater than or equal to ',HREZSUGGEST
	write(6,*)' horiz res set to ',hrez,' km'
	write(6,*)' radius set to ', radius
      else
	WRITE(6,*)'Enter horizontal resolution in km'
        READ(5,*,err=2223)HREZ
      end if
      ZRES=.5
      IMAXIMPLIED=NINT(RADIUS*2./HREZ)
      IF(IMAXIMPLIED.GT.98.AND.airborne_wkstn)THEN
       WRITE(6,*)'Re-enter max radius and horizontal resolution'
       WRITE(6,*)'Because max radius divided by horizontal resolution'
       WRITE(6,*)'May not be more than 22'
       GO TO 2222
      ENDIF
      TREZ=15.
	if(airborne_wkstn) then ! Hardwired values
		HREZPROFILE = 1.5
		ZRESPROFILE = 0.15
		HEIGHTBOT=0.
		ROT=0.
		INOB = 5
		THRESH = -99
		DBZRS = -99
		DBZCOR = 0
		DBZSLOPE = 1
C changed 5 nov 2008 for al93
 		swthresh = 6.25
c		swthresh = 4.5

		FACTZ = 1000.
		HB2 = 5.5
		DPB2 = 2.0
		ZLOW = 99.
		ZHIGH = 100.
	else
1211  WRITE(6,*)'Enter vertical resolution for vertical profiles'
      WRITE(6,*)'A value of .15 km is suggested'
      HREZPROFILE=1.5
      READ(5,*,err=1211)ZRESPROFILE
      HEIGHTBOT=0.
      ROT=0.
1212  WRITE(6,*)'Enter first good gate, number of gates to avg ',
     +'for doppler unfolding (2,5 if not sure)'
      READ(5,*,err=1212)IBST,INOB
1213  WRITE(6,*)'Enter THRESH, DBZRS, DBZCOR, DBZSLOPE'
      WRITE(6,*)'If you dont know enter "-99, -99, 0, 1"'
      READ(5,*,err=1213)THRESH,DBZRS,DBZCOR,DBZSLOPE
1214  WRITE(6,*)'Enter spectral width threshold in m per s'
	WRITE(6,*)'If you dont know use 6.25'
      READ(5,*,err=1214)SWTHRESH
1215  WRITE(6,*)'Enter continuity factor ',
     + ' (if you dont know enter 1000.)'      
      READ(5,*,err=1215)FACTZ
1216  WRITE(6,*)'Enter height and depth of melting layer in km'
      WRITE(6,*)'If you dont know, enter 5.5,2.0'
      READ(5,*,err=1216)HB2,DPB2
1217  WRITE(6,*)'Enter dBZ value below which fallspeed all from snow'
      WRITE(6,*)'If you dont know enter 99.'
      READ(5,*,err=1217)ZLOW
1218  WRITE(6,*)'Enter dBZ value above which fallspeed all from water'
      WRITE(6,*)'IF you dont know enter 100.'
      READ(5,*,err=1218)ZHIGH
	end if
C
C
	else
		open(lu,file = 'radar_analysis_params.dat', 
     +			form = 'formatted', status ='old')
      read(lu,*)RADIUS
      read(lu,*)HREZ,ZRES
      read(lu,*)TREZ
      read(lu,*)HREZPROFILE
      read(lu,*)ZRESPROFILE
      read(lu,*)HEIGHTBOT, ROT
      read(lu,*)INOB
      read(lu,*)THRESH,DBZRS,DBZCOR,DBZSLOPE
      read(lu,*)SWTHRESH
      read(lu,*)HB2,DPB2
      read(lu,*)ZLOW
      read(lu,*)ZHIGH
 	read(lu,*)factz
		close(lu)
	WRITE(6,*)' values from radar_analysis_params.dat;'
	write(6,*)RADIUS,' distance out to go from center in km'
      write(6,*)HREZ,ZRES,' horizontal, vertical resolution in km'
      write(6,*)TREZ, ' Trez'
      write(6,*)HREZPROFILE,
     +	' horizontal resolution for vertical profiles'
      write(6,*)ZRESPROFILE,' vertical resolution for vertical profiles'      
      write(6,*)HEIGHTBOT, ROT, ' height of bottom, coordinate rotation'
      write(6,*)INOB,
     +	' # gates to avg for doppler unfolding'
      write(6,*)THRESH,DBZRS,DBZCOR,DBZSLOPE, 
     +	' THRESH, DBZRS, DBZCOR, DBZSLOPE'
      write(6,*)SWTHRESH,' spectral width threshold in m per s'
      write(6,*)HB2,DPB2,' height and depth of melting layer in km'
      write(6,*)ZLOW, ' dBZ value below which fallspeed all from snow'
      write(6,*)ZHIGH, ' dBZ value above which fallspeed all from water'
      write(6,*)factz,' Continuity factor'
C
	end if ! new or old file block
C

	return
	end
C ==============================================================
C Moved leg specific stuff to this subroutine.
	subroutine get_leg_params(IHB,IMB,ISB,IHE,IME,ISE,
     +		IHC,IMC,ISC, olat, olon, u, v,
     +		aziin,aziout, wc_lat, wc_lon,
     +          airborne_wkstn)
	integer IHB,IMB,ISB,IHE,IME,ISE,IHC,IMC,isc
	real olat, olon, u, v,aziin,aziout
	logical airborne_wkstn, exist
	character*1 yesno
	real kts_to_ms
C 
	 kts_to_ms = 1.0 / 1.9438
C 
	inquire(file = 'radar_legs.dat', exist = exist)
	if( exist) then
	  open(89,file = 'radar_legs.dat', form ='formatted')
          read(89,"(3i2.2)")ihb, imb,isb  
          read(89,"(3i2.2)")ihe, ime, ise
          read(89,"(3i2.2)")ihc,imc,isc
          read(89,*)olat, olon
	  read(89,*)track_inbound, azimuth_inbound
	  read(89,*)track_outbound, azimuth_outbound
	  read(89,*)u,v
C added Willoughby Chelmow center
	  read(89, *)wc_lat, wc_lon
	  close(89)
	  aziin = azimuth_inbound
	  aziout = azimuth_outbound
	else
C Changed as per JG;s request to force user to input values.
C He figures this is faster than via the GUI.
	  wc_lat = -999.9
	  wc_lon = -999.9
	  write(6,*)'radar_legs.dat not found. Please enter'
	  write(6,*)' following time and storm position info'
100	  write(6,*)'Inbound start time as hhmmss, like 174533'
	  read(5,*,err = 100)itime
	  ihb = itime /10000
	  ims = (itime - ihb * 10000) / 100
	  isb = itime - ihb * 10000 - imb * 100
110	  write(6,*)'Outbound end time as hhmmss, like 181015'
	  read(5,*,err= 110)itime
	  ihe = itime /10000
	  ime = (itime - ihe * 10000) / 100
	  ise = itime - ihe * 10000 - ime * 100
120	  write(6,*)'Storm center time as hhmmss, like 175732'
	  read(5,*,err=120)itime
	  ihc = itime /10000
	  imc = (itime - ihc * 10000) / 100
	  isc = itime - ihc * 10000 - imc * 100
	  if(airborne_wkstn) then
130	    write(6,*)'Enter center lat as deg, min, sec'
	    read(5,*,err=130)slatd,slatm,slats
C following line hardwired fr 2007 Hurricane xeason, rest works anywhere
	    if(slatd.lt.0.0)slatd = -slatd
C note I use abs for all in case there was confusion when entering 
C sign of min snd sec
	    olat = abs(slatd) + abs(slatm)/60.0 + 
     +		abs(slats) / 3600.0
	    if(slatd .lt. 0.0) olat = -olat
140	    write(6,*)'Enter center lon as deg, min, sec'
	    read(5,*,err=140)slond,slonm,slons
C following line hardwired fr 2007 Hurricane xeason, rest works anywhere
	    if(slond.gt.0.0)slond = -slond
	    olon = abs(slond) + abs(slonm)/60.0 + 
     +		abs(slons) / 3600.0
	    if(slond .lt. 0.0) olon = -olon
150	    write(6,*)'Enter storm motion direction (deg nav)'
	    read(5,*,err=150)storm_dir
160	    write(6, *)'Enter storm speed'
	    read(5,*,err=160)storm_speed
	    write(6,*)'Was speed in knots? (y or n)'
	    read(5,'(a1)')yesno
	    if((yesno.eq.'y') .or. (yesno.eq.'Y') )then
		storm_speed = storm_speed * kts_to_ms
	    end if
	    ang = (90.0 - storm_dir)*acos(-1.0)/180.0
	    u = storm_speed * cos(ang)
	    v = storm_speed * sin(ang)
	  else
180	    write(6,*)' Enter center lat (decimal, + for North'
	    read(5,*,err=180)olat
190	    write(6,*)' Enter center lon (decimal, - for West'
	    read(5,*,err=190)olon
200	    write(6,*)'Enter storm motion as u, v in m/s:'
	    read(5,*, err=200)u, v
	  end if
C in bound azimuth iz 180 from inbound track angle
C out bound az is the out bound track
210	  write(6,*)'Enter in bound track (deg nav):'		
	  read(5,*,err=210)track_in
	  aziin = amod(track_in+180.0, 360.0)
220	  write(6,*)'Enter outbound track'
	  read(5,*,err=220)aziout
	end if
C
	return
	end
C ===============================================================
C OUTPUT subs
C ==============================================================
	subroutine write_flight_params(IY, IM, ID, IAIR, FLT, EXP,
     +		IFRANCE, ISTORMNO, ibst, aft_AZMCOR, 
     +          aft_ELCOR,aft_RDELCOR,
     +		aft_PCOR, aft_DCOR, aft_RCOR, fore_AZMCOR, fore_ELCOR,
     +		fore_RDELCOR,fore_PCOR, fore_DCOR, fore_RCOR)

	integer IY,IM,ID,IAIR,IFRANCE,ISTORMNO
	character flt*8, exp*12, cplane*2, yesno*1
C
	lu = 89 .
C
	open(lu,file = 'radar_flt_params.dat', 
     +			form = 'formatted')
	write(lu,*)iair, ' Aircraft'
	write(lu,'(3i2.2," Date")')IY, IM, ID
	write(lu,'(A12)')EXP
	write(lu,*)ISTORMNO, ' ATCF Storm number'
	write(lu,*)IFRANCE, ' Antenna type, 1 = French'
	write(lu,*)aft_AZMCOR, aft_ELCOR, ' aft AZMCOR,_ELCOR'
	write(lu,*)aft_RDELCOR, ' aft RDELCOR'
	write(lu,*)aft_PCOR, aft_DCOR, aft_RCOR,
     +             ' Aft pcor, dcor, elcor'
	write(lu,*)fore_AZMCOR, fore_ELCOR, 
     +             ' Fore AZMCOR,_ELCOR'    
	write(lu,*)fore_RDELCOR, ' fore RDELCOR'
	write(lu,*)fore_PCOR, fore_DCOR, fore_RCOR, 
     +             ' FB ore pcor, dcor, elcor'
        write(lu,*)ibst, ' IBST'
	close(lu)
	return
	end 
C ==========================================================
	subroutine write_leg_params(IHB,IMB,ISB,IHE,IME,ISE,
     +		IHC,IMC,isc, olat, olon, u_storm, v_storm,
     +		aziin,aziout, wc_lat, wc_lon,
     +          airborne_wkstn)
	integer IHB,IMB,ISB,IHE,IME,ISE,IHC,IMC,isc
	real olat, olon, u, v,aziin,aziout
	logical airborne_wkstn
C 
	azimuth_inbound = aziin
	azimuth_outbound = aziout
	track_inbound = amod(180.0 + aziin, 360.0)
	track_outbound = aziout
	open(89,file = 'radar_legs.dat', form ='formatted')
        write(89,"(3i2.2)")ihb, imb,isb  
        write(89,"(3i2.2)")ihe, ime, ise
        write(89,"(3i2.2)")ihc,imc,isc
        write(89,*)olat, olon
	write(89,*)track_inbound, azimuth_inbound
	write(89,*)track_outbound, azimuth_outbound
	write(89,*)u_storm, v_storm
C added Willoughby Chelmpw center (or -999)
	write(89,*)wc_lat, wc_lon
	close(89)
	return
	end
C ===============================================================
	subroutine write_analysis_params(RADIUS, HREZ, ZRES, TREZ,
     +          HREZPROFILE, ZRESPROFILE, HEIGHTBOT, ROT,
     +          INOB, THRESH,DBZRS,DBZCOR,DBZSLOPE,SWTHRESH,
     +          FACTZ, HB2, DPB2, ZLOW, ZHIGH, airborne_wkstn)
	logical airborne_wkstn
	character*1 yesno
C
	lu = 89 
	open(lu,file = 'radar_analysis_params.dat', 
     +			form = 'formatted')
	write(lu,*)RADIUS,' distance out to go from center in km'
	write(lu,*)HREZ,ZRES,' horizontal, vertical resolution in km'
	write(lu,*)TREZ, ' Trez'
	write(lu,*)HREZPROFILE,
     +	' horizontal resolution for vertical profiles'
	write(lu,*)ZRESPROFILE,
     +	' vertical resolution for vertical profiles'
	write(lu,*)HEIGHTBOT, ROT, 
     +	' height of bottom, coordinate rotation'
	write(lu,*)INOB,
     +	' 1st good gate, # gates to avg for doppler unfolding'
	write(lu,*)THRESH,DBZRS,DBZCOR,DBZSLOPE, 
     +	' THRESH, DBZRS, DBZCOR, DBZSLOPE'
	write(lu,*)SWTHRESH,' spectral width threshold in m per s'
	write(lu,*)HB2,DPB2,' height and depth of melting layer in km'
	write(lu,*)ZLOW, ' dBZ value below which fallspeed all from snow'
	write(lu,*)ZHIGH, 
     +	' dBZ value above which fallspeed all from water'
	write(lu,*)FACTZ, ' Continuity factor'
	close(lu)
	return
	end
C =============================================
	subroutine get_alternate_corrs(ibst, aft_AZMCOR, 
     +          aft_ELCOR,aft_RDELCOR,
     +		aft_PCOR, aft_DCOR, aft_RCOR, fore_AZMCOR, fore_ELCOR,
     +		fore_RDELCOR,fore_PCOR, fore_DCOR, fore_RCOR, 
     +          airborne_wkstn)

	integer ibst
	character yesno*1
	logical exist, changed,airborne_wkstn, jg_corrs
C
	lu = 89 
	changed = .false.
C
	inquire(file = 'angtest.txt', exist = exist)
	if(exist) then
		jg_corrs = .true.
		open(lu,file='angtest.txt',form='formatted')
		read(lu,*)ibst_jg
		read(lu,*)idum,tilt_cor_aft_jg
		aft_elcor_jg = -tilt_cor_aft_jg
		read(lu,*)idum,aft_azmcor_jg
		read(lu,*)idum,aft_rdelcor_jg
		read(lu,*)idum,tilt_cor_fore_jg
		fore_elcor_jg = -tilt_cor_fore_jg
		read(lu,*)idum,fore_azmcor_jg
		read(lu,*)idum,fore_rdelcor_jg
		close(lu)
	else
		jg_corrs = .false.
		return
	end if
C
c	write(6,*)' Here are corrections previously '
c	write(6,*)' calculated automatically by anglecheck:'
C 
c	write(6,*)'Left = current, right = previously calculated'
c	write(6,*) 'ibst', ibst, ibst_jg
c	write(6,*) ',aft_AZMCOR',aft_AZMCOR, aft_AZMCOR_jg
c	write(6,*) 'aft_ELCOR',aft_ELCOR, aft_ELCOR_jg
c	write(6,*) 'aft_RDELCOR',aft_RDELCOR, aft_RDELCOR_jg
c	write(6,*) 'fore_AZMCOR',fore_AZMCOR,fore_AZMCOR_jg
c	write(6,*) 'fore_ELCOR',fore_ELCOR, fore_ELCOR_jg
c	write(6,*) 'fore_RDELCOR',fore_RDELCOR,fore_RDELCOR_jg
C
c	write(6,*)'Use instead of the present stored values ?'
c	write(6,*)'yes(y)/no(n)'
c	read(5,'(a1)')yesno
        yesno='y'
	if(yesno.eq.'y' .or. yesno.eq.'Y')then
		ibst = ibst_jg
		aft_AZMCOR = aft_AZMCOR_jg
		aft_ELCOR = aft_ELCOR_jg
		aft_RDELCOR = aft_RDELCOR_jg
		fore_AZMCOR = fore_AZMCOR_jg
		fore_ELCOR = fore_ELCOR_jg
		fore_RDELCOR = fore_RDELCOR_jg
		changed = .true.
	end if

	return
	end
C =====================
	subroutine set_auto_corrs(ibst, aft_AZMCOR, 
     +          aft_ELCOR,aft_RDELCOR,
     +		aft_PCOR, aft_DCOR, aft_RCOR, fore_AZMCOR, fore_ELCOR,
     +		fore_RDELCOR,fore_PCOR, fore_DCOR, fore_RCOR, 
     +          airborne_wkstn)
C
	integer ibst
	logical airborne_wkstn
	character*1 yesno
C
C	write(6,*)'Want anglecheck software to find corrections?'
C       write(6,*)'yes (y) or no (n)?'
C	read(5,'(a1)')yesno
C	if(yesno.eq.'y' .or. yesno.eq.'Y')then ! >>>>>>>>>>>>>>>>>>>>>>>>>>
C Set all to zero so John's software finds them.
                ibst = 0
		aft_AZMCOR = 0.0
		aft_ELCOR = 0.0
		aft_RDELCOR = 0.0
		aft_PCOR = 0.0
		aft_DCOR = 0.0
		aft_RCOR = 0.0
		fore_AZMCOR = 0.0
		fore_ELCOR = 0.0
		fore_RDELCOR = 0.0
		fore_PCOR  = 0.0
		fore_DCOR = 0.0
		fore_RCOR  = 0.0
C	end if
	return
	end
C  write_jobfiles.f
C Part of Jobfile maker made a subroutine. It assumes existence of
C files...and if those files are not there it will not make
C job files. Peter Dodge 14 May 2007
	subroutine write_jobfiles( airborne_wkstn, error_status)
	integer error_status
C
      CHARACTER FLT*8,EXP*12,CPLANE*2,OFILNAM*80
	character*80 radar_FILNAM
	logical airborne_wkstn, exist
	character*1 platform ! W = wkstn, G = ground
	character*1 yesno
        character*9 dummyradarfilename 
C So far so good:
	error_status = 1
C 
C Where is the radar data coming from?
	if(.not.airborne_wkstn)then
1101  WRITE(6,*)'Enter LU number for tape drive'
      WRITE(6,*)'Enter a negative number if using a disk file'
      READ(5,*,err=1101)lu_tape
      IF(lu_tape.LT.6)THEN
       WRITE(6,*)'Enter radar file name'
       READ(5,'(A80)')radar_FILNAM
      ENDIF
	else
C LU number meaningless (but >6 for logic below!)
c        write(6,*)'Since you are running this on thor with a '
c        write(6,*)'Enter the tape drive lu number'
c        read(5,*)lu_tape
		lu_tape = -1
                radar_FILNAM='radarfb.dat'
	end if
C Flight specific
 	inquire(file = 'radar_flt_params.dat', exist = exist)
	if( .not.exist) then
		write(6,*)'radar_flt_params.dat does not exist.'
		error_status = -1
		return
	end if
	call get_flight_params(IY, IM, ID, IAIR, FLT, EXP, IFRANCE,
     +		ISTORMNO, ibst, aft_AZMCOR, aft_ELCOR,aft_RDELCOR,
     +		aft_PCOR, aft_DCOR, aft_RCOR, fore_AZMCOR, fore_ELCOR,
     +		fore_RDELCOR,fore_PCOR, fore_DCOR, fore_RCOR,
     +		airborne_wkstn)
C
C Flight leg specific:
	inquire(file = 'radar_legs.dat', exist = exist)
	if( .not.exist) then
		write(6,*)'radar_legs.dat does not exist.'
		error_status = -3
		return
	end if
	call get_leg_params(IHB,IMB,ISB,IHE,IME,ISE,
     +		IHC,IMC,ISC, olat, olon, u, v,
     +		aziin,aziout, wc_lat, wc_lon,
     +          airborne_wkstn)
C Get Analysis specific paramters
	inquire(file = 'radar_analysis_params.dat', exist = exist)
	if( .not.exist) then
		write(6,*)'radar_analysis_params.dat does not exist.'
		error_status = -3
		return
	end if
	call get_analysis_params(RADIUS, HREZ, ZRES, TREZ, 
     +		HREZPROFILE, ZRESPROFILE, HEIGHTBOT, ROT,
     +		INOB, THRESH, DBZRS, DBZCOR, DBZSLOPE,
     +		SWTHRESH, FACTZ, HB2, DPB2, ZLOW, ZHIGH,
     +		airborne_wkstn)
C some hardwired values
      TREZ=15.
      HREZPROFILE=1.5
      HEIGHTBOT=0.
      ROT=0.
C
      IMAX=NINT(RADIUS*2./HREZ)
      JMAX=IMAX
      KMAX=1+NINT(18./ZRES)
C JG changed so will do deep profile
Cout      KMAXPROFILE=1+NINT(3./ZRESPROFILE)
      KMAXPROFILE=1+NINT(18./ZRESPROFILE)
      IMAX = NINT(RADIUS/HREZ)
      IMAXPROFILE=NINT(RADIUS/HREZPROFILE)
      IF(IMAXPROFILE.GT.130)IMAXPROFILE=130
      JMAX=24
C      WRITE(6,*)'Enter an output wind file name'
C      READ(5,'(A80)')OFILNAM
Cout      WRITE(6,*)'Enter name of final cartesian wind file'
Cout      READ(5,'(A80)')OFILNAM
C Label output files by center time
C open output files:
      OPEN(80,FILE='jobfile_radar')
      OPEN(81,FILE='jobfile_radar_rt')
      OPEN(82,FILE='jobfile_radar_profile')
      OPEN(83,FILE='jobfile_radar_fourier')
C added for 2007:
      OPEN(84,FILE='jobfile_radar_in')
      OPEN(85,FILE='jobfile_radar_out')
      OPEN(86,FILE='jobfile_radar_profile_in')
      OPEN(87,FILE='jobfile_radar_profile_out')
C
	do lu = 80, 87
		write(lu,'(a8)')flt
		write(lu,'(A12)')EXP
	end do
	do lu = 80,83
		write(lu,'(3i2.2,1x,3i2.2)')IHB,IMB,ISB,IHE,IME,ISE
	end do
	write(84,'(3i2.2,1x,3i2.2)')IHB,IMB,ISB,ihc,imc,isc
	write(86,'(3i2.2,1x,3i2.2)')IHB,IMB,ISB,ihc,imc,isc
	write(85,'(3i2.2,1x,3i2.2)')ihc,imc,isc,IHE,IME,ISE
	write(87,'(3i2.2,1x,3i2.2)')ihc,imc,isc,IHE,IME,ISE
	do lu = 80,87
		write(lu,202)u,v
	end do
202   FORMAT(2F8.2)
	do lu = 80,87
		write(lu,'(3i2.2)')IHC,IMC,ISC
	end do
	do lu = 80,87
		write(lu, 204)OLAT,OLON
	end do
204   FORMAT(2F10.3)
      WRITE(80,205)HREZ,HREZ,ZRES
      WRITE(81,205)HREZ,TREZ,ZRES
      WRITE(83,205)HREZ,TREZ,ZRES
      WRITE(84,205)HREZ,HREZ,ZRES
      WRITE(85,205)HREZ,HREZ,ZRES

      WRITE(82,205)HREZPROFILE,TREZ,ZRESPROFILE
      WRITE(86,205)HREZPROFILE,TREZ,ZRESPROFILE
      WRITE(87,205)HREZPROFILE,TREZ,ZRESPROFILE
205   FORMAT(4F8.2)

      WRITE(80,205)RADIUS,RADIUS,HEIGHTBOT,ROT
	WRITE(84,205)RADIUS,RADIUS,HEIGHTBOT,ROT
	WRITE(85,205)RADIUS,RADIUS,HEIGHTBOT,ROT

      WRITE(81,205)HREZ,ROT,HEIGHTBOT,ROT
      WRITE(82,205)HREZPROFILE,ROT,HEIGHTBOT,ROT
	WRITE(86,205)HREZPROFILE,ROT,HEIGHTBOT,ROT
	WRITE(87,205)HREZPROFILE,ROT,HEIGHTBOT,ROT
      WRITE(83,205)HREZ,ROT,HEIGHTBOT,ROT
C
      IMAX=NINT(RADIUS*2./HREZ)
      JMAX=IMAX
      KMAX=1+NINT(18./ZRES)
      KMAXPROFILE=1+NINT(18./ZRESPROFILE)
      WRITE(80,206)IMAX,JMAX,KMAX
	WRITE(84,206)IMAX,JMAX,KMAX
	WRITE(85,206)IMAX,JMAX,KMAX
      IMAX = NINT(RADIUS/HREZ)
      IMAXPROFILE=NINT(RADIUS/HREZPROFILE)
      IF(IMAXPROFILE.GT.130)IMAXPROFILE=130
      JMAX=24
      WRITE(81,206)IMAX,JMAX,KMAX
      WRITE(82,206)IMAXPROFILE,JMAX,KMAXPROFILE
	WRITE(86,206)IMAXPROFILE,JMAX,KMAXPROFILE
	WRITE(87,206)IMAXPROFILE,JMAX,KMAXPROFILE
      WRITE(83,206)IMAX,JMAX,KMAX
206   FORMAT(3I4)
	do lu = 80, 87
		WRITE(lu,206)lu_tape
		WRITE(lu,206)IBST,INOB
C Attitude and antenna angle corrections:
		WRITE(lu,205)aft_AZMCOR, aft_ELCOR, aft_RDELCOR
		WRITE(lu,205)aft_PCOR, aft_DCOR, aft_RCOR
		WRITE(lu,205)fore_AZMCOR, fore_ELCOR, fore_RDELCOR
		WRITE(lu,205)fore_PCOR, fore_DCOR, fore_RCOR
C Analysis params: 
		WRITE(lu,205)THRESH,DBZRS,DBZCOR,DBZSLOPE
		WRITE(lu,205)SWTHRESH
C Dont know why times are repeated here but they are, so need to
C make sure about times for inbound and out bound match with times 
C listed earlier.
		if(lu .lt. 84) then
		 write(lu,'(3i2.2,1x,3i2.2)')IHB,IMB,ISB,IHE,IME,ISE
		else if((lu.eq.84) .or. (lu.eq.86))then
		 write(lu,'(3i2.2,1x,3i2.2)')IHB,IMB,ISB,IHc,IMc,ISc
		else if((lu.eq.85) .or. (lu.eq.87))then
		 write(lu,'(3i2.2,1x,3i2.2)')IHc,IMc,ISc,IHE,IME,ISE
		end if
C
Cout		WRITE(lu,201)STARTTIME,ENDTIME
		WRITE(lu,'(F10.1)')FACTZ
		WRITE(lu,'(2F10.2)')HB2,DPB2
		WRITE(lu,'(2F10.2)')ZLOW,ZHIGH
	end do
	OFILNAM = ''
	write(OFILNAM(1:18),"(a8,'_',2i2.2,'_xy.w')")flt,ihc,imc
      WRITE(80,'(A80)')OFILNAM
      WRITE(80,'(2F10.2)')AZIIN,AZIOUT
	WRITE(84,'(A80)')OFILNAM
	WRITE(84,'(2F10.2)')AZIIN,AZIOUT
	WRITE(85,'(A80)')OFILNAM
	WRITE(85,'(2F10.2)')AZIIN,AZIOUT
      IF(lu_tape .LT. 6)THEN
       WRITE(80,'(A80)')radar_FILNAM
	WRITE(84,'(A80)')radar_FILNAM
	WRITE(85,'(A80)')radar_FILNAM
C Change for 2006...so all jobfiles have same # of lines:
      else
        dummyradarfilename='radar.dat'
	write(80,'(A5)')dummyradarfilename
	write(84,'(A5)')dummyradarfilename
	write(85,'(A5)')dummyradarfilename
      ENDIF
      OFILNAM='first_guess_rt.w'
      WRITE(81,'(A80)')OFILNAM
Cout      WRITE(6,*)'Enter name of vertical profile output file'
Cout      READ(5,'(A80)')OFILNAM
	OFILNAM = ''
	write(OFILNAM(1:20),"(a8,'_',2i2.2,'_vert.w')")flt,ihc,imc
C WARNING I changed names of vert.w files for in and out profiles
      WRITE(82,'(A80)')OFILNAM
	write(OFILNAM(1:28),"(a8,'_',2i2.2,'_vert_inbound.w')")flt,
     +		ihc,imc
	write(86,'(A80)')OFILNAM
	write(OFILNAM(1:29),"(a8,'_',2i2.2,'_vert_outbound.w')")flt,
     +		ihc,imc
	write(87,'(A80)')OFILNAM
      WRITE(80,'(I1)')IFRANCE
	write(84,'(I1)')IFRANCE
	write(85,'(I1)')IFRANCE
c      WRITE(6,*)'Enter name of fourier output file'
c      READ(5,'(A80)')OFILNAM
      OFILNAM='first_guess_fourier.w'
      WRITE(83,'(A80)')OFILNAM
      WRITE(82,'(I2)')ISTORMNO
	write(86, '(I2)')ISTORMNO
	write(87,'(I2)')ISTORMNO
      WRITE(82,'(2F10.2)')AZIIN,AZIOUT
	write(86,'(2F10.2)')AZIIN,AZIOUT
	write(87, '(2F10.2)')AZIIN,AZIOUT
      WRITE(80,'(I2)')ISTORMNO
	write(84,'(I2)')ISTORMNO
	write(85,'(I2)')ISTORMNO
C close the job files 
	do lu = 80,87
		CLOSE(lu)
	end do
	write(6,*)' Job files have been created.'
	return
	end
C ----------------------------------------------------
	subroutine set_grid_params(radius, max_grid, grid_inc,
     +		dx, dy, xc, yc, ierror)
C Input radius, max_grid, grid_inc
C output dx, dy, xc, yc, ierror
C
	write(6,*)'input: ',radius, max_grid, grid_inc
	ierror = 1 
	if(radius .le. 0) then
		ierror = -1
		return
	else if( max_grid .le. 0) then
                ierror = -2
                return
	else if( grid_inc .le. 0) then
                ierror = -3
                return
	end if
C
	dx = radius / max_grid
C adjust grid to next grid_inc interval
C ie if grid_inc = 0.5 6.2 -> 6.5, 6.6 -> 7.0
	nt = dx / grid_inc
	if(dx .gt. nt * grid_inc) then ! bump up
	  dx = (nt + 1) * grid_inc
	end if
C And adjust radius
	radius = dx * max_grid
	dy = dx
	xc = radius
	yc = radius
	return
	end
