	program jobfile_display
C Display jobfile parameters in boxes that can then be clicked and modified. 
C Sort of a proof of concept.
	parameter(max_grid = 49, grid_int_inc = 0.5) ! for workstation
        CHARACTER FLT*8,EXP*12,aircraft*1,OFILNAM*80,returnchar*1
	character*80 radar_FILNAM
	logical airborne_wkstn, exist
	character*1 platform ! W = wkstn, G = ground
	character*1 run_it
	character*10 script_dir
	character*1 yesno
        character*1 charair
        character*5 dummyradarfilename
	logical calc_ang_corrs
C
	parameter(max_boxes = 50)
	real param(max_boxes)
	character*20 param_label(max_boxes)
	integer xl(max_boxes), yb(max_boxes)
	integer xl_done, yb_done
	integer xl_ang, yb_ang, xl_tstm,yb_tstm
	integer xl_flt, yb_flt, xl_exp, yb_exp
	integer xl_ant, yb_ant
	logical changed(max_boxes)
	integer param_type(max_boxes)
Cout	integer box_wid(max_boxes), box_ht(max_boxes)
	integer width, height
	character*20 string
	integer text_color, box_color
	character*32 window_label
	integer*4 window(47)
	character*72 cmd_string
C
	real ms_kts
C	
	ms_kts = 1.9438
C
C defaults
	istorm_type = 2 ! 1 - tropical storm, 2 - hurricane
	calc_ang_corrs = .false.
	ifrench_ant = 1
	NOAA_ant= 0
C
	do i = 1, max_boxes
		changed(i) = .false.
		param_label(i) = 'Label'
		param(i) = -999.9
		param_type(i) = 1 ! 1 float, 2 integer
	end do
C Read in job file parameters
	call getarg(1,platform)
	if( platform .eq.'W' .or. platform .eq. 'w') then
		airborne_wkstn = .true.
		write(6,*)' Airborne workstation'
		script_dir = '/home/hrd/'
	else if( platform .eq.'G'  .or. platform .eq. 'g') then
		airborne_wkstn = .false.
		write(6,*)'Not running on Airborne workstation'
		script_dir = '/hrd/run/'
	else
		write(6,*)' You did not specify platform.'
		write(6,*)' Assume running on airborne workstation'
		airborne_wkstn = .true.
		script_dir = '/home/hrd/'
	end if
C Added parameter to control whether radar programs are launched once 
C this program finishes. Either R or Y will do the trick.
	call getarg(2,run_it)
	if(run_it .eq. 'r') then
		run_it = 'R'
	else if(run_it .eq. 'y') then
		run_it = 'Y'
	else
		run_it = 'N'
	end if
C Flight leg specific:
	call get_leg_params(IHB,IMB,ISB,IHE,IME,ISE,
     +		IHC,IMC,ISC, olat, olon, u, v,
     +		aziin,aziout, wc_lat, wc_lon,
     +          airborne_wkstn)
C Added code to use Willoughby Chelmow center as default storm center
C Fut then commented it out ahain, because wc center crappy
c when plane doing a lot of maneuvering
cout	if(wc_lat .gt. -90.0) then
cout		olat = wc_lat
cout		olon = wc_lon
cout	end if
C Now load the paramaeter arrays for displaying boxes
	i = 0
	num_boxes = 0
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = 'Start'
	param(i) = ihb*10000 + imb*100 + isb
	param_type(i) = 2
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = 'End'
	param(i) = ihe*10000 + ime*100 + ise
	param_type(i) = 2
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = 'Center  Time'
	param(i) = ihc*10000 + imc*100 + isc
	param_type(i) = 2
	if( airborne_wkstn ) then
	      if(olat .gt. -999.0)then
		lat_deg = olat
		lat_min = (olat-lat_deg)*60.0
		lat_sec = (olat-lat_deg - lat_min/60.)*3600
		i = i + 1
		num_boxes = num_boxes + 1
		param_label(i) = 'Lat Deg'
		param(i) = lat_deg
	param_type(i) = 2
		i = i + 1
		num_boxes = num_boxes + 1
		param_label(i) = 'Lat Min'
		param(i) = lat_min
	param_type(i) = 2
		i = i + 1
		num_boxes = num_boxes + 1
		param_label(i) = 'Lat sec'
		param(i) = lat_sec
	param_type(i) = 2
	     else ! set all to missing
		i = i + 1
		num_boxes = num_boxes + 1
		param_label(i) = 'Lat Deg'
		param(i) = -999.9
		i = i + 1
	param_type(i) = 2
		num_boxes = num_boxes + 1
		param_label(i) = 'Lat Min'
		param(i) = -999.9
	param_type(i) = 2
		i = i + 1
		num_boxes = num_boxes + 1
		param_label(i) = 'Lat sec'
		param(i) = -999.9
	param_type(i) = 2
	     end if
C A little more code here, to get around negative signs everywhere
	     if(olon .gt. -999.0) then
		isign_olon = 1
		if(olon .lt. 0.0) isign_olon = -1
		lon_deg = abs(olon)
		lon_min = (abs(olon)-lon_deg)*60.0
		lon_sec = (abs(olon)-lon_deg - lon_min/60.)*3600
		i = i + 1
		num_boxes = num_boxes + 1
		param_label(i) = 'Lon Deg'
C to avoid confusion on plane, write lon as positive for west
Cout		param(i) = lon_deg * isign_olon
		param(i) = lon_deg
	param_type(i) = 2
		i = i + 1
		num_boxes = num_boxes + 1
		param_label(i) = 'Lon Min'
		param(i) = lon_min
	param_type(i) = 2
		i = i + 1
		num_boxes = num_boxes + 1
		param_label(i) = 'Lon sec'
		param(i) = lon_sec
	param_type(i) = 2
	     else
		isign_olon = -1 ! Hardwired ti western hemis !!
		i = i + 1
		num_boxes = num_boxes + 1
		param_label(i) = 'Lon Deg'
		param(i) = -999.9
	param_type(i) = 2
		i = i + 1
		num_boxes = num_boxes + 1
		param_label(i) = 'Lon Min'
		param(i) = -999.9
	param_type(i) = 2
		i = i + 1
		num_boxes = num_boxes + 1
		param_label(i) = 'Lon sec'
		param(i) = -999.9
	param_type(i) = 2
	     end if
	else
C We are on the ground and can grok decimal fractions
		i = i + 1
		num_boxes = num_boxes + 1
		param_label(i) = 'Storm Lat'
		param(i) = olat
		i = i + 1
		num_boxes = num_boxes + 1
		param_label(i) = 'Storm Lon'
		param(i) = olon
	end if
C
	if(airborne_wkstn) then
	  if(u .gt. -999.0) then
		stm_spd = sqrt(u*u + v*v) * ms_kts
		dir = 90.0 - atan2(v,u)*180.0/acos(-1.0)
		stm_dir = amod(360 + dir, 360.0)
	  else
		stm_spd = -999.0
		stm_dir = -999.0
	  end if
	  i = i + 1
	  num_boxes = num_boxes + 1
	  param_label(i) = 'Stm dir'
	  param(i) = stm_dir
	  i_stm_dir_ptr = i
	  i = i + 1
	  num_boxes = num_boxes + 1
	  param_label(i) = 'Stm kts'
	  param(i) = stm_spd
	  i_stm_spd_ptr = i
	else
	  i = i + 1
	  num_boxes = num_boxes + 1
	  param_label(i) = 'Storm U'
	  param(i) = u
	  i = i + 1
	  num_boxes = num_boxes + 1
	  param_label(i) = 'Storm V'
	  param(i) = v
	end if
C
C Changed to display inbound and outbound tracks imstead of azimuths
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = 'Trk In'
	trk_in = amod(180.0 + aziin, 360.0)
	param(i) = trk_in
C Outbound trk and az are the same
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = 'Trk Out'
	param(i) = aziout
	num_leg_boxes = num_boxes
C
C Flight specific
	call get_flight_params(IY, IM, ID, IAIR, FLT, EXP, IFRANCE,
     +		ISTORMNO, ibst, aft_AZMCOR, aft_ELCOR,aft_RDELCOR,
     +		aft_PCOR, aft_DCOR, aft_RCOR, fore_AZMCOR, fore_ELCOR,
     +		fore_RDELCOR,fore_PCOR, fore_DCOR, fore_RCOR,
     +		airborne_wkstn)
C Check to see if automatically created correctiosn are there
	call get_alternate_corrs(ibst, aft_AZMCOR, 
     +          aft_ELCOR,aft_RDELCOR,
     +		aft_PCOR, aft_DCOR, aft_RCOR, fore_AZMCOR, fore_ELCOR,
     +		fore_RDELCOR,fore_PCOR, fore_DCOR, fore_RCOR, 
     +          airborne_wkstn)
C May set so program runs anglecheck
	if(.not.calc_ang_corrs) then
c	  write(6,*)'Want anglecheck software to find corrections?'
c	  write(6,*)'yes (y) or no (n)?'
c	  read(5,'(a1)')yesno
          yesno='n'
	  if(yesno.eq.'y' .or. yesno.eq.'Y')then 
	     calc_ang_corrs = .true.
	     call set_auto_corrs(ibst, aft_AZMCOR, 
     +          aft_ELCOR,aft_RDELCOR,
     +		aft_PCOR, aft_DCOR, aft_RCOR, fore_AZMCOR, fore_ELCOR,
     +		fore_RDELCOR,fore_PCOR, fore_DCOR, fore_RCOR, 
     +          airborne_wkstn)
	  end if
	end if
C
	i = i + 1
	num_boxes = num_boxes + 1
        write(6,*)'i for date is ',i
	param_label(i) = 'Date'
	param(i) = iy*10000 + im*100 + id
	idate_ptr = i ! so can update fkt id display also
	param_type(i) = 2
	i = i + 1
	num_boxes = num_boxes + 1
        write(6,*)'i for Aircraft is ',i
	param_label(i) = 'Aircraft'
	param(i) = iair
	param_type(i) = 2
        iair_ptr=i
        write(6,*)'iair_ptr = ',iair_ptr
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = 'Antenna'
	param(i) = ifrance
	param_type(i) = 2
C added footwork to make antenna selection a toggle boc
C down further in the code
	iparm_antenna = i
	param_type(i) = -2 ! no op code
C
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = 'ATCF #'
	param(i) = istormno
	param_type(i) = 2
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = 'IBST'
	param(i) = ibst
	param_type(i) = 2
C added GRID params sx, sy, sz, sr_vert, sr_radial
C and xz, yz (with warning notto change?)
	call get_analysis_params(RADIUS, HREZ, ZRES, TREZ,
     +          HREZPROFILE, ZRESPROFILE, HEIGHTBOT, ROT,
     +          INOB, THRESH,DBZRS,DBZCOR,DBZSLOPE,SWTHRESH,
     +          FACTZ, HB2, DPB2, ZLOW, ZHIGH, airborne_wkstn)
	sx = hrez
	sy = hrez
	sz = zres
	sr_vert = ZRESPROFILE
	sr_rt = HREZPROFILE
	xz = RADIUS
	yz = RADIUS
C
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = 'Radius'
	param(i) = radius
	i_rad_ptr  = i
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = 'dX'
	param(i) = sx
	if(airborne_wkstn) then
	  param_type(i) = -1 ! means not user changeable
	  i_sx_ptr = i
	end if
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = 'dY'
	param(i) = sy
	if(airborne_wkstn) then
	  param_type(i) = -1 ! means not user changeable
	  i_sy_ptr = i
	end if
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = 'dZ'
	param(i) = sz
	if(airborne_wkstn) then
	  param_type(i) = -1 ! means not user changeable
	end if
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = 'Prof dZ'
	param(i) = sr_vert
	if(airborne_wkstn) then
	  param_type(i) = -1 ! means not user changeable
	end if
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = 'Prof dR'
	param(i) = sr_rt
	if(airborne_wkstn) then
	  param_type(i) = -1 ! means not user changeable
	end if
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = 'Ctr X'
	param(i) = xz
	if(airborne_wkstn) then
	  param_type(i) = -1 ! means not user changeable
	  i_xz_ptr = i
	end if
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = 'Ctr Y'
	param(i) = yz
	if(airborne_wkstn) then
	  param_type(i) = -1 ! means not user changeable
	  i_yz_ptr = i
	end if
	num_flt_boxes = num_boxes - num_leg_boxes
C
	i = i + 1
	num_boxes = num_boxes + 1
	i_aft_ptr = i
	param_label(i) = '  az cor'
	param(i) = aft_azmcor
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = '    el cor'
	param(i) = aft_elcor
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = '  rdel cor'
	param(i) = aft_rdelcor
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = '   p cor'
	param(i) = aft_pcor
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = '   d cor'
	param(i) = aft_dcor
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = '   r cor'
	param(i) = aft_rcor

	i = i + 1
	num_boxes = num_boxes + 1
	i_fore_ptr = i
	param_label(i) = '  az cor'
	param(i) = fore_azmcor
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = '    el cor'
	param(i) = fore_elcor
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = '  rdel cor'
	param(i) = fore_rdelcor
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = '   p cor'
	param(i) = fore_pcor
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = '   d cor'
	param(i) = fore_dcor
	i = i + 1
	num_boxes = num_boxes + 1
	param_label(i) = '   r cor'
	param(i) = fore_rcor

	num_cor_boxes = num_boxes - num_leg_boxes - num_flt_boxes
C Stuff to display X wondow tith burrons
C Set up display
	window_label = 'Doppler Analysis Parameters'
	call rasx_open_window( window, ierror,window_label)
	if(ierror .ne. 1) then
		write(6,*)' rasx_open_window error # ',ierror
		stop
	end if
C Draw boxes
	height = 20
	width = 90
	box_color = 0
	text_color = 16
	iy_top = 420
C Label if in airborne workstation mode
	if(airborne_wkstn) then
	  string = 'nn Workstation'
	  write(string(1:2),'(i2.2)')iair
	  call x_tvtype(10, iy_top + height + 10, 
     +		string, 14, 0,
     +		text_color, window)
	end if
C Leg boxes
        write(6,*)'I got here 1'
	j = 0
	  icol = j *230 + 10
	  do irow = 1, num_leg_boxes
	   i = irow
           ixixl = icol +1
	   xl(i) = icol + 135
	   yb(i) = iy_top - irow * (height + 10)
           write(6,*)i,ixixl,yb(i),param_label(i)
	   call x_tvtype(ixixl, yb(i) + 1, param_label(i), 20, 0,
     +		text_color, window)
           write(6,*)'i got here 2'
           pause
	   if(param_type(i) .eq. 1 )then
	     if(abs(param(i)) .lt. 1.0) then
		write(string(1:7),'(f7.2)')param(i)
	     else
                write(6,*)'Is it really happening here?'
                write(6,*)'i = ',i
                write(6,*)'param(i) = '
                write(6,*)param(i)
		write(string(1:7),'(f7.2)')param(i)
	     end if
	   else if(param_type(i) .eq. 2) then
             iparm = nint(param(i))
             write(6,*)'i,idate_ptr = ',i,idate_ptr
             if(i.gt.3.and.i.ne.idate_ptr)then
	      write(string(1:7), '(i7)')iparm
             else
              if(iparm.ge.100000)then
               write(string(1:7), '(1X,i6.6)')iparm
              elseif(iparm.ge.10000)then
               write(string(1:7),'(1x,"0",i5.5)')iparm
              else
               write(string(1:7),'(1x,"00",i4.4)')iparm
              endif
             endif
	   end if
	   num_char = 7
           if(i.eq.1)then
c            write(6,*)'enter a return'
c            read(5,'(a1)')returnchar
           do jij=1,10000000
            iji=jij
           enddo
           endif
c           if(i.eq.1)pause
           write(6,*)'i got here 2b'
           pause
           write(6,*)'xl,yb,width,height,string,num_char = ',
     +      xl(i),yb(i),width,height,string,num_char
	   call draw_fill_box(xl(i), yb(i), width, height,
     +		box_color,text_color, string, num_char, window)
           write(6,*)'i got here 3'
           pause
	  end do
C Flight boxes - parameters that should not change during flight
	j = 1

	  icol = j *230 + 10
C Temporary stick characrer strings here
C and save corners so can change these also
	call x_tvtype(icol + 1, iy_top + 1, flt, 8, 0,
     +		text_color, window)
        pause
	xl_flt = icol + 1
	yb_flt = iy_top + 1
	call x_tvtype(icol + 1, iy_top + height + 10, exp, 12, 0,
     +		text_color, window)
        pause
	xl_exp = icol + 1
	yb_exp = iy_top + height + 10
C
	  do irow = 1, num_flt_boxes
	   i = irow + num_leg_boxes
           ixixl = icol +1
	   xl(i) = icol + 135
	   yb(i) = iy_top - irow * (height + 10)
           write(6,*)i,ixixl,yb(i),param_label(i)
	   call x_tvtype(ixixl, yb(i) + 1, param_label(i), 20, 0,
     +		text_color, window)
           write(6,*)'i got here 4'
           pause
	   if(abs(param_type(i)) .eq. 1 ) then
	     if(abs(param(i)) .lt. 1.0) then
		write(string(1:7),'(f7.2)')param(i)
	     else
		write(string(1:7),'(f7.2)')param(i)
	     end if
	   else if(abs(param_type(i)) .eq. 2) then
	     iparm = nint(param(i))
             if(i.ne.idate_ptr)then
 	      write(string(1:7), '(i7)')iparm
             else
              if(iparm.ge.100000)then
  	       write(string(1:7), '(1X,i6.6)')iparm
              elseif(iparm.ge.10000)then
               write(string(1:7),'(1X,"0",i5.5)')iparm
              else
               write(string(1:7),'(1X,"00",i4.4)')iparm
              endif
             endif
	   end if
	   num_char = 7
c          pause
           write(6,*)'xl,yb,width,height,string,num_char = ',
     +      xl(i),yb(i),width,height,string,num_char
	   call draw_fill_box(xl(i), yb(i), width, height,
     +		box_color,text_color, string, num_char, window)
          pause
	  end do
C Correction boxes - should not change during flight
	j = 2
	  icol = j *230 - 10
C AFT corrections
	  iy_rel = iy_top - (height + 10)
	  string = 'AFT Corrections'
	  call x_tvtype(icol + 1, iy_rel + 1,string, 15, 0,
     +		text_color, window)
	  do irow = 1, 6
	   i = irow + num_leg_boxes + num_flt_boxes
	   xl(i) = icol + 100
	   yb(i) = iy_rel - (height + 10)
	   iy_rel = yb(i)
	   call x_tvtype(icol + 1, yb(i) + 1, param_label(i), 20, 0,
     +		text_color, window)
	   if(abs(param_type(i)) .eq. 1 ) then
	     if(abs(param(i)) .lt. 1.0) then
		write(string(1:7),'(f7.2)')param(i)
	     else
		write(string(1:7), '(f7.2)')param(i)
	     end if
	   else if((param_type(i)) .eq. 2) then
	     iparm = nint(param(i))
	     write(string(1:7), '(i7)')iparm
	   end if
	   num_char = 7
c           pause
	   call draw_fill_box(xl(i), yb(i), width, height,
     +		box_color,text_color, string, num_char, window)
	  end do
C FORE corrections
	  iy_rel = iy_rel - (height + 10)
	  string = 'FORE Corrections'
	  call x_tvtype(icol + 1, iy_rel + 1,string, 16, 0,
     +		text_color, window)
	  do irow = 7, num_cor_boxes
	   i = irow + num_leg_boxes + num_flt_boxes
	   xl(i) = icol + 100
	   yb(i) = iy_rel - (height + 10)
	   iy_rel = yb(i)
	   call x_tvtype(icol + 1, yb(i) + 1, param_label(i), 20, 0,
     +		text_color, window)
	   if(abs(param_type(i)) .eq. 1 ) then
	     if(abs(param(i)) .lt. 1.0) then
		write(string(1:7),'(f7.2)')param(i)
	     else
		write(string(1:7), '(f7.2)')param(i)
	     end if
	   else if(abs(param_type(i)) .eq. 2) then
	     iparm = nint(param(i))
	     write(string(1:7), '(i7)')iparm
	   end if
	   num_char = 7
           write(6,*)'calling draw_fill_box'
c           pause
	   call draw_fill_box(xl(i), yb(i), width, height,
     +		box_color,text_color, string, num_char, window)
           write(6,*)'called draw_fill_box'
c           pause
	  end do
C Make done buttom
	string = 'DONE'
	num_char = 4
	xl_done = icol + 100
	yb_done = iy_rel - (height + 10)
c       pause
	call draw_fill_box(xl_done, yb_done,width, height,
     +          box_color,text_color, string, num_char, window) 	
C Added two Toggle Boxes:
	if(istorm_type .eq. 1 ) then
	  string = 'Tropical Storm'
	else
	  string = 'Hurricane'
	endif
	num_char = 14
	xl_tstm = 10
	yb_tstm = iy_rel - (height + 10)
c       pause
	call draw_fill_box(xl_tstm, yb_tstm,width, height,
     +          box_color,text_color, string, num_char, window)
C
	if(calc_ang_corrs)then
	  string = 'Calc Angle corrs'
	else
	  string = 'Use Angle Corrs'
	end if
	num_char = 16
	xl_ang = xl_tstm + 100 + width
	yb_ang = iy_rel - (height + 10)
c       pause
	call draw_fill_box(xl_ang, yb_ang,width, height,
     +          box_color,text_color, string, num_char, window) 	
C Added one more toggle box, foe antenna choice
	if(ifrance .eq. ifrench_ant) then
		string = 'French'
	else 
		string = 'NOAA'
	end if
	num_char = 6
	j = 1
	irow = 3
	icol = j *230 + 10
	xl_ant = icol + 100
	yb_ant = iy_top - irow * (height + 10)
c       pause
	call draw_fill_box(xl_ant, yb_ant, width, height,
     +          box_color,text_color, string, num_char, window) 	
 
c       pause
C Does Mac need an extra flush here?
	call x_raise_window(window)
C Do not lnoe if this fixes Mac/Linuc stuff or not
	call x_map_raised_window(window)
C Loop through mouse clicks
100	call x_cross(window, ix_m, iy_m, ibutton)
	do while(ibutton .ne. 4)
C If not right click then find box
	   do i = 1, num_boxes
	     if(in_box(ix_m,iy_m,xl(i), yb(i), width, height) 
     +			.eq.0)then
C Special Case for airborne workstation. If radius is chenged,
C then also cheneg dx dy and xc and yc so thta array dimesnions do not
C grpw and dx dy are in .5 km increments.
		if ( airborne_wkstn .and.(i.eq.i_rad_ptr)) then
		  call clear_box(xl(i), yb(i), width, height, 
     +			box_color, window)
		  call x_lower_window(window)
		write(6,*)' Enter New Radius'
1220		read(5,*,err = 1230)param(i)
		go to 1240
1230		write(6,*)'Error. Enter integer or real number:'
		go to 1220
1240	        radius = param(i)
		call set_grid_params(radius, max_grid, grid_int_inc,
     +          	dx, dy, xc, yc, ierror)
		param(i_rad_ptr) = radius
		param(i_sx_ptr) = dx
		param(i_sy_ptr) = dy
		param(i_xz_ptr) = xc
		param(i_yz_ptr) = yc
		num_char = 7
		  write(string(1:7), '(f7.2)')param(i_rad_ptr)
		call update_box_text(xl(i_rad_ptr), yb(i_rad_ptr),
     +			text_color, string, num_char, window)
		  write(string(1:7), '(f7.2)')param(i_sx_ptr)
		  call clear_box(xl(i_sx_ptr), yb(i_sx_ptr), 
     +			width, height, 
     +			box_color, window)
		call update_box_text(xl(i_sx_ptr), yb(i_sx_ptr),
     +			text_color, string, num_char, window)
		  write(string(1:7), '(f7.2)')param(i_sy_ptr)
		  call clear_box(xl(i_sy_ptr), yb(i_sy_ptr), 
     +			width, height, 
     +			box_color, window)
		call update_box_text(xl(i_sy_ptr), yb(i_sy_ptr),
     +			text_color, string, num_char, window)
		  write(string(1:7), '(f7.2)')param(i_xz_ptr)
		  call clear_box(xl(i_xz_ptr), yb(i_xz_ptr), 
     +			width, height, 
     +			box_color, window)
		call update_box_text(xl(i_xz_ptr), yb(i_xz_ptr),
     +			text_color, string, num_char, window)
		  write(string(1:7), '(f7.2)')param(i_yz_ptr)
		  call clear_box(xl(i_yz_ptr), yb(i_yz_ptr), 
     +			width, height, 
     +			box_color, window)
		call update_box_text(xl(i_yz_ptr), yb(i_yz_ptr),
     +			text_color, string, num_char, window)
		call x_raise_window(window)
		changed(i) = .true.
		else if( param_type(i) .gt. 0) then
C If click in box, clear and update
		call clear_box(xl(i), yb(i), width, height, 
     +			box_color, window)
		call x_lower_window(window)
Cout		write(6,*)'you clicked ',param_label(i)
		write(6,*)' Enter New ',param_label(i)
122             if(i.gt.3)then
   	         read(5,*,err = 123)param(i)
                else
                 write(6,*)'Enter in 6 digit form hhmmss'
                 write(6,*)'where hh is hours, mm is min,'
                 write(6,*)'and ss is seconds'
                 write(6,*)'and include any leading zeros'
                 read(5,'(3I2)')ihtemp,imtemp,istemp
                 param(i)=ihtemp*10000+imtemp*100+istemp
                endif
		go to 124
123		write(6,*)'Error. Enter integer or real number:'
		go to 122
124	   if(param_type(i) .eq. 1 ) then
	     if(abs(param(i)) .lt. 1.0) then
		write(string(1:7),'(f7.2)')param(i)
	     else
		write(string(1:7),'(f7.2)')param(i)
	     end if
	   else if(param_type(i) .eq. 2) then
	     iparm = nint(param(i))
             if(i.gt.3.and.i.ne.idate_ptr)then
 	      write(string(1:7), '(i7)')iparm
             else
 	      write(string(1:7), '(1X,i6.6)')iparm
             endif
	   end if
		num_char = 7
		call x_raise_window(window)
		call update_box_text(xl(i), yb(i),text_color,
     +          	string, num_char, window)
		changed(i) = .true.
		if(i .eq. idate_ptr) then ! update flt
		   call clear_box(xl_flt, yb_flt, width+20, height, 
     +			box_color, window)
		   write(flt(1:6),'(i6.6)')nint(param(i))
		   call x_tvtype(xl_flt, yb_flt,  flt, 8, 0,
     +			text_color, window)
		end if
		if(i .eq. iair_ptr) then ! update flt
                   iair=param(i)
		   call clear_box(xl_flt, yb_flt, width+20, height, 
     +			box_color, window)
                   if(iair.eq.42)then
                    charair='H'
                   elseif(iair.eq.43)then
                    charair='I'
                   elseif(iair.eq.49)then
                    charair='N'
                   else
                    charair='X'
                   endif                
                   write(6,*)'charair = ',charair
		   write(flt(7:7),'(A1)')charair
                   write(6,*)'flt = ',flt
		   call x_tvtype(xl_flt, yb_flt,  flt, 8, 0,
     +			text_color, window)
		end if
	else
c have to add addituional test so dont freak out the user
c wheb he/she changes antenna
	  if(param_type(i) .ne. -2) then
	   write(6,*)'Cannot change ',param_label(i)
	  end if
	end if
	     end if
	   end do
C Check if char strigs were clicked
C If flt id changes, update date and aircraft type
	   if(in_box(ix_m,iy_m,xl_flt, yb_flt,width, height)
     +		.eq. 0) then
		call clear_box(xl_flt, yb_flt, width+20, height, 
     +			box_color, window)
		call x_lower_window(window)
		write(6,*)' Enter flight ID; like 070824H1 (8 char): '
		read(5, '(a8)')flt
		read(flt(1:6),'(i6.6)')idate
		param(idate_ptr) = idate
		read(flt(7:8), '(a1,i1)')aircraft,ifltno
		if((aircraft .eq.'H') .or. (aircraft .eq.'h'))then
			iair = 42
		else if((aircraft .eq.'I') .or. (aircraft .eq.'i'))then
			iair = 43
		end if
		call x_tvtype(xl_flt, yb_flt,  flt, 8, 0,
     +		text_color, window)
		call x_raise_window(window)
                param(iair_ptr)=iair
                iparm=param(iair_ptr)
                write(string(1:7),'(i7)')iparm
                num_char=7
                call draw_fill_box(xl(iair_ptr),yb(iair_ptr),
     +            width,height,
     +            box_color,text_color,string,num_char,window)
                write(6,*)'idate = ',idate
                if(idate.lt.10000)then
                 write(6,*)'i4.4'
                 write(string(1:7),'(1x,"00",i4.4)')idate
                elseif(idate.lt.100000)then
                 write(6,*)'i5.5'
                 write(string(1:7),'(1x,"0",i5.5)')idate
                else
                 write(6,*)'i4.4'
                 write(string(1:7),'(1x,i6.6)')idate
                endif
                call draw_fill_box(xl(idate_ptr),yb(idate_ptr),
     +            width,height,
     +            box_color,text_color,string,num_char,window)
	   end if
	   if(in_box(ix_m,iy_m,xl_exp, yb_exp,width, height)
     +		.eq. 0) then
		call clear_box(xl_exp, yb_exp, width + 20, height, 
     +			box_color, window)
		call x_lower_window(window)
		write(6,*)' Enter New Experimenr (12 char): '
		read(5, '(a12)')exp
		call x_tvtype(xl_exp, yb_exp, exp, 12, 0,
     +		text_color, window)
		call x_raise_window(window)
	   end if
C Chack if toggle box clicked
	   if(in_box(ix_m,iy_m, xl_tstm, yb_tstm, width, height)
     +		.eq. 0) then
	      if(istorm_type .eq. 1) then
		istorm_type = 2
	      else
		istorm_type = 1
	      end if
	      call clear_box(xl_tstm, yb_tstm, width + 100, height, 
     +			box_color, window)
	      if(istorm_type .eq. 1 ) then
	  	string = 'Tropical Storm'
	      else
	  	string = 'Hurricane     '
	      endif
	      num_char = 14
c             pause
	      call draw_fill_box(xl_tstm, yb_tstm,width, height,
     +          box_color,text_color, string, num_char, window)
	else if(in_box(ix_m,iy_m, xl_ang, yb_ang, width, height)
     +		.eq. 0) then
	      if(calc_ang_corrs) then
		calc_ang_corrs = .false.
	      else
		calc_ang_corrs = .true.
	      end if
	      call clear_box(xl_ang, yb_ang, width + 100, height, 
     +			box_color, window)
	      if(calc_ang_corrs)then
	  	string = 'Calc Angle corrs'
		call set_auto_corrs(ibst, aft_AZMCOR, 
     +           aft_ELCOR,aft_RDELCOR,
     +		 aft_PCOR, aft_DCOR, aft_RCOR, fore_AZMCOR, fore_ELCOR,
     +		 fore_RDELCOR,fore_PCOR, fore_DCOR, fore_RCOR, 
     +           airborne_wkstn)

	      else
	  	string = 'Use Angle Corrs'
	      end if
	      call clear_box(xl_ang, yb_ang, width + 100, height, 
     +			box_color, window)
	     num_char = 16
c            pause
	     call draw_fill_box(xl_ang, yb_ang,width, height,
     +          box_color,text_color, string, num_char, window) 	
C added toggle box for radar antenna
	else if(in_box(ix_m,iy_m, xl_ant, yb_ant, width, height)
     +		.eq. 0) then
	      if(ifrance .eq. ifrench_ant ) then
		ifrance = NOAA_ant
		string = 'NOAA'
	      else if(ifrance .eq. NOAA_ant) then
		ifrance = ifrench_ant
		string = 'French'
	      end if
		changed(iparm_antenna) = .true.
		param(iparm_antenna) = ifrance
	      call clear_box(xl_ant, yb_ant, width, height, 
     +			box_color, window)
	     num_char = 6
c            pause
	     call draw_fill_box(xl_ant, yb_ant,width, height,
     +          box_color,text_color, string, num_char, window) 	
	   end if
C check if done box was clicked
	   if(in_box(ix_m,iy_m, xl_done, yb_done, width, height)
     +		.eq. 0) then
		ibutton = 4
	   else ! get another click
		call x_cross(window, ix_m, iy_m, ibutton)
	   end if
Cout	  write(6,*)'button, x, y ',ibutton, ix_m, iy_m
	end do
C 
C Done mousing, so updats
C Added chack to insure there no bad flags still in params:
	do i = 1, num_boxes
	  if(param(i) .le. -999.0) then
	    write(6,*)trim(param_label(i) ),' needs value!'
	    write(6,*)'Please click on ',trim(param_label(i) ),
     +		' and change'
	    call x_raise_window(window)
	    call x_map_raised_window(window)
	    go to 100 ! back to mousing
	  end if
	end do
C First, load param array back into variables:
	i = 0
	num_boxes = 0
	i = i + 1
C	param(i) = ihb*10000 + imb*100 + isb
	ihb = param(i) * 0.0001
	imb = (param(i) - ihb*10000) * 0.01
	isb = param(i) - ihb*10000 - imb*100
	i = i + 1
C	param(i) = ihe*10000 + ime*100 + ise
	ihe = param(i) * 0.0001
	ime = (param(i) - ihe*10000) * 0.01
	ise = param(i) - ihe*10000 - ime*100
	i = i + 1
C	param(i) = ihc*10000 + imc*100 + isc
	ihc = param(i) * 0.0001
	imc = (param(i) - ihc*10000) * 0.01
	isc = param(i) - ihc*10000 - imc*100
	if( airborne_wkstn ) then
		i = i + 1
		num_boxes = num_boxes + 1
C		param_label(i) = 'Lat Deg'
		lat_deg = param(i)
		i = i + 1
		lat_min = param(i)
		i = i + 1
		lat_sec = param(i)
		olat = lat_deg + lat_min/60.0 + lat_sec/3600.0
		i = i + 1
C		param_label(i) = 'Lon Deg'
		lon_deg = param(i)
C Note that on airborne workstation, no matter the sign of lat_deg,
C I am forcing Western Hemisphere
C Warning ... i do not permit change of hemisphere!!!
		i = i + 1
		lon_min = param(i)
		i = i + 1
		lon_sec = param(i)
		olon = abs(lon_deg) + lon_min/60.0 + lon_sec/3600.0
		olon = olon * isign_olon
	else
		i = i + 1
		olat = param(i)
		i = i + 1
		olon = param(i)
	end if
	if(airborne_wkstn) then
	  i = i + 1
	  stm_dir = param(i)
	  i = i + 1
	  stm_spd = param(i) / ms_kts
	  dir = (90.0 - stm_dir) * acos(-1.0) / 180.0
	  u = stm_spd * cos(dir)
	  v = stm_spd * sin(dir)
	else
	  i = i + 1
C	param_label(i) = 'Storm U'
	  u = param(i)
	  i = i + 1
C	param_label(i) = 'Storm V'
	  v = param(i)
	end if
	i = i + 1
C	param_label(i) = 'Trk In'
	trk_in = param(i)
	aziin = amod(trk_in + 180.0, 360.0)
	i = i + 1
C	param_label(i) = 'Trk Out'
	aziout = param(i)
C Flight specific
	i = i + 1
C	param_label(i) = 'Date'
C	param(i) = iy*10000 + im*100 + id
	iy = param(i) *0.0001
	im = (param(i) - iy*10000) * 0.01
	id = param(i) - iy*10000 - im*100
	i = i + 1
C	param_label(i) = 'Aircraft'
	iair = param(i)
	i = i + 1
C	param_label(i) = 'Antenna'
c following commented out because ifrancs was set in a
c toggle box..not in the chain of parameter voxes.
c	ifrance = param(i)
	i = i + 1
C	param_label(i) = 'ATCF #'
	istormno = param(i)
	i = i + 1
C	param_label(i) = 'IBST'
	ibst = param(i)
C
	i = i + 1
	radius = param(i)
	i = i + 1
	sx = param(i)
	i = i + 1
	sy = param(i)
	i = i + 1
	sz = param(i)
	i = i + 1
	sr_vert = param(i)
	i = i + 1
	sr_rt = param(i)
	i = i + 1
	xz = param(i)
	i = i + 1
	yz = param(i)
C
	hrez = sx
	zres = sz
	ZRESPROFILE = sr_vert
	HREZPROFILE = sr_rt
Comment out because in menu now
Cout	RADIUS = xz
C
	i = i + 1
C	param_label(i) = '  az cor'
	aft_azmcor = param(i)
	i = i + 1
	aft_elcor = param(i)
	i = i + 1
	aft_rdelcor = param(i)
	i = i + 1
	aft_pcor = param(i)
	i = i + 1
	aft_dcor = param(i) 
	i = i + 1
	aft_rcor = param(i)

	i = i + 1
	fore_azmcor = param(i)
	i = i + 1
	fore_elcor = param(i)
	i = i + 1
	fore_rdelcor = param(i)
	i = i + 1
	fore_pcor = param(i)
	i = i + 1
	fore_dcor = param(i)
	i = i + 1
	fore_rcor = param(i)
C Then write out the parameter files
	call write_leg_params(IHB,IMB,ISB,IHE,IME,ISE,
     +		IHC,IMC,ISC, olat, olon, u, v,
     +		aziin,aziout, wc_lat, wc_lon,
     +          airborne_wkstn)
C If calc_ang_corrs set all corrs to zero. We dod not do this ealuer so as not
C to trash corrs until we write job files
      if(calc_ang_corrs)then
	call set_auto_corrs(ibst, aft_AZMCOR, 
     +           aft_ELCOR,aft_RDELCOR,
     +		 aft_PCOR, aft_DCOR, aft_RCOR, fore_AZMCOR, fore_ELCOR,
     +		 fore_RDELCOR,fore_PCOR, fore_DCOR, fore_RCOR, 
     +           airborne_wkstn)

	end if
	call write_flight_params(IY, IM, ID, IAIR, FLT, EXP,
     +		IFRANCE, ISTORMNO, ibst, aft_AZMCOR, 
     +          aft_ELCOR,aft_RDELCOR,
     +		aft_PCOR, aft_DCOR, aft_RCOR, fore_AZMCOR, fore_ELCOR,
     +		fore_RDELCOR,fore_PCOR, fore_DCOR, fore_RCOR)
	call write_analysis_params(RADIUS, HREZ, ZRES, TREZ,
     +          HREZPROFILE, ZRESPROFILE, HEIGHTBOT, ROT,
     +          INOB, THRESH,DBZRS,DBZCOR,DBZSLOPE,SWTHRESH,
     +          FACTZ, HB2, DPB2, ZLOW, ZHIGH, airborne_wkstn)
C Finally write out the job files:
	call write_jobfiles( airborne_wkstn, ierr)
	if(ierr .lt. 1) then
	  write(6,*)' No Jobfiles created!'
	  write(6,*)'write_jobfiles error code ',ierr
	else
	  write(6,*)'8 jobfiles created. Good luck.'
	end if
C and post finally pass to script to run
	if(calc_ang_corrs)then
         if(istorm_type.eq.1)then
          write(6,*)'run command "ja_anglecheck_ts" to process data'
         else
          write(6,*)'run command "ja_anglecheck" to process data'
         endif
c	 write(cmd_string,"('make_radar_script',2(1x,i1),1x,a1,1x,a10)")       
c     +		istorm_type, 1, run_it, script_dir
	else
         if(istorm_type.eq.1)then
          write(6,*)'run command "ja_ts" to process data'
         else
          write(6,*)'run command "ja" to process data'
         endif
c	 write(cmd_string,"('make_radar_script',2(1x,i1),1x,a1,1x,a10)") 
c     +		istorm_type, 0, run_it script_dir
	end if
c	call system(cmd_string)
	end
C =========================================================================
	subroutine draw_fill_box(xl,yb,width,height,box_color,text_color,
     +		text, num_char, window)
	integer xl,yb,width,height,box_color,text_color
	integer*4 window(47)
	character*(*) text
C
	call x_tvfrec(xl, yb, xl+width, yb+height, box_color,window)
	call x_tvtype(xl + 1, yb +1, text, num_char, 0, text_color,
     +		window)
	return
	end
C ==========================================================================
	subroutine update_box_text(xl,yb,text_color,
     +          text, num_char, window)
	integer xl,yb,width,height,box_color,text_color
	integer*4 window(47)
	character*(*) text
	call x_tvtype(xl + 1, yb +1, text, num_char, 0, text_color,
     +		window)
	return
	end
C =========================================================================
	subroutine clear_box(xl,yb,width,height,box_color, window)
	integer xl,yb,width,height,box_color,text_color
        integer*4 window(47)
	call x_tvfrec(xl, yb, xl+width, yb+height, box_color,window)
	return 
	end
C ============================================================
      function in_box(pointx,pointy,xl, yb, width, height)
C Returns a location code for point, relative to window.
C Lower left corner of window is (w(1),w(2)), upper right 
C is (w(3),w(4)). 
C     1001/9  1000/8  1010/10    above the window 
C     0001/1  0000/0  0010/2     left,window,right
C     0101/5  0100/4  0110/6     below the window 
      integer pointx,pointy,xl, yb, width, height
      in_box = 0
      if(pointx.lt.xl)then
              in_box = in_box + 1 
      else if(pointx.gt.xl+width)then 
              in_box = in_box + 2 
      endif 
      if(pointy.lt.yb)then
              in_box = in_box + 4 
      else if(pointy.gt.yb+height)then 
              in_box = in_box + 8 
      endif 
      return
      end 
