      SUBROUTINE DEFRECKLE(IMAXBINS,JMAXRAYS,
     +  NUM_RAYS,ANGLE,VR,VROUT,VNYQ)
C 
C     SUBROUTINE CALLED BY SWEEPIN (NEWSWEEPREAD_AUTO_FIRST_DISC_DEFRECKLE.F)
C       
C ... FUNCTION:   
C       
C     THIS SUBROUTINE...
C
C ... DEFRECKLE SUBPROGRAM REFERENCES: NONE
C     
C     VERSION:  <TBD>
C       
C     CODE WRITTEN BY:  JOHN GAMACHE   
C                       HRD/AOML/NOAA          
C                       MIAMI, FL 33149      
C       
C     FOR ADDITIONAL DETAILS ON THE ALGORITHM SEE <TBD>
C       
C     BASED ON THEORY BY:  <TBD>
C       
C     REFERENCE THE BOOK:  <TBD>
C       
C     **************************************************  
C     *               IMPORTANT NOTE                   *  
C     *                                                *  
C     *                    <TBD>                       *  
C     *                                                *  
C     **************************************************         
C
C     SPECIFICATIONS FOR ARGUMENTS
C    
      REAL VR(IMAXBINS,JMAXRAYS)
      REAL VROUT(IMAXBINS,JMAXRAYS)
      REAL VTEST(3)
      REAL ANGLE(JMAXRAYS)
C 
      VTEST(1)=40.
      VTEST(2)=20.
      VTEST(3)=10.
C 
      DO JJ=1,NUM_RAYS
       DO II=1,IMAXBINS
        VROUT(II,JJ)=VR(II,JJ)
       ENDDO
      ENDDO
CCCC 
      DO N=1,3  ! 3 ITERATIONS
CCCC
       NX=1
C
C      NOTE: ITESTSUM AND VRMEAN ARE NOT USED
C 
       ITESTSUM=0
CCC
       DO WHILE(NX.GE.1)
CCC 
        ITESTSUM=ITESTSUM+1
        NX=0
CC
        DO JJ=1,NUM_RAYS
         DO II=1,IMAXBINS
CC 
          IF(VR(II,JJ).GT.-799.9)THEN  ! IF NOT FLAGGED
C 
C          CONSIDER 3 GATES BEFORE AND AFTER, 3 RAYS BEFORE AND AFTER
C 
           IMIN=II-3
           IMAX=II+3
           JMIN=JJ-3
           JMAX=JJ+3
           SUMVR=0.
           SUMDIFF=0.
           NSUM=0
C 
           IF(IMIN.LT.1)IMIN=1
           IF(IMAX.GT.IMAXBINS)IMAX=IMAXBINS
           IF(JMIN.LT.1)JMIN=1
           IF(JMAX.GT.JMAXRAYS)JMAX=JMAXRAYS
C 
C          LOOP OVER SECTOR
C 
           DO J=JMIN,JMAX
            ANGLEDIFF=ABS(ANGLE(J)-ANGLE(JJ))
            DO I=IMIN,IMAX
C
C            AS LONG AS LOOP POINT DOES NOT COINCIDE WITH (II,JJ),
C            VELOCITY OF LOOP POINT IS NOT FLAGGED, AND MAGNITUDE OF 
C            ANGULAR DIFFERENCE DOES NOT REACH 4 DEG: COMPUTE VELOCITY
C            DIFFERENCE BETWEEN LOOP POINT AND (II,JJ) POINT.
C
C            IF DIFFERENCE IS < -NYQUIST VELOCITY, ADD TWICE NYQUIST VELOCITY
C            IF DIFFERENCE IS > +NYQUIST VELOCITY, SUB TWICE NYQUIST VELOCITY
C            RECOMPUTE VELOCITY DIFFERENCE AND ADD IT TO SUM
C 
             IF((II.NE.I.OR.JJ.NE.J).AND.
     1          VR(I,J).GT.-799.9.AND.ANGLEDIFF.LT.4.)THEN
              VRI=VR(I,J)
              DIFF=VRI-VR(II,JJ)
              IF(DIFF.LT.-VNYQ)VRI=VRI+2.*VNYQ
              IF(DIFF.GT.VNYQ)VRI=VRI-2.*VNYQ
              DIFF=VRI-VR(II,JJ)
              SUMDIFF=SUMDIFF+DIFF
              SUMVR=SUMVR+VRI
              NSUM=NSUM+1
             ENDIF
            ENDDO
           ENDDO
C 
C          AS LONG AS AT LEAST ONE POINT CHECKED OUT IN SECTOR, COMPUTE
C          AVERAGE DIFFERENCE (VRTEST) WITHIN SECTOR. IF AVERAGE DIFFERENCE 
C          EXCEEDS 40 M/S (FOR FIRST ITERATION), FLAG (II,JJ) VELOCITY.
C 
           IF(NSUM.GE.1)THEN
            VRTEST=ABS(SUMDIFF/NSUM)
            VRMEAN=SUMVR/NSUM
            IF(VRTEST.GT.VTEST(N))THEN
             NX=NX+1
             VROUT(II,JJ)=-888.88
            ENDIF
           ELSE
            VROUT(II,JJ)=-888.88
           ENDIF
C 
          ENDIF
CC 
         ENDDO
        ENDDO
CC
        DO JJ=1,JMAXRAYS
         DO II=1,IMAXBINS
          VR(II,JJ)=VROUT(II,JJ)
         ENDDO
        ENDDO
CCC
       ENDDO
CCCC
      ENDDO
CCCC
      RETURN
      END

