      SUBROUTINE CONVERTANGLES(track, azm, elev, theta, phi)
C     A SUBROUTINE TO CONVERT FROM TAIL RADAR-RELATIVE ANGLES(TRACK, AZIMUTH,
C     AND ELEVATION) TO EARTH-RELATIVE CLASSICAL SPHERICAL COORDINATES
C     (THETA - AZIMUTH AND PHI - ELEVATION). 
C     GEOMETRY COURTESY DODGE, P., USDC/NOAA/AOML/HRD, 2 JUN 92.
C     INPUT:
C       TRACK:  AIRCRAFT TRACK ANGLE FROM N (0 DEG); 0-360 DEG
C       AZM:  ROTATION ANGLE OF TAIL RADAR ANTENNA; 0-360 DEG CLOCKWISE FROM UP
C       ELEV:  ELEVATION ANGLE OF TAIL RADAR ANTENNA FROM PERPENDICULAR TO TRACK
C         +-25 DEG; ELEV > 0 = FORWARD, ELEV < 0 = AFT, ELEV = 0 PERPENDICULAR
C     OUTPUT:
C       THETA:  EARTH RELATIVE AZIMUTH ANGLE (MATHEMATICS CONVENTIONS) FROM EAST
C       PHI:  EARTH RELATIVE ELEVATION ANGLE (0 = HORIZONTAL)
      DATA    pidiv180/0.017453293/

c      write(6,*)'convertangles,track,azm,elev = ',track,azm,elev
C     CALCULATE THE ELEVATION(PHI) FROM HORIZONTAL
      phi = ASIN(COS(azm * pidiv180) * COS(elev * pidiv180)) / pidiv180

C     CALCULATE THE AZIMUTH(THETA) FROM EAST.  CALCULATE AN INTERMEDIATE ANGLE,
C     E-PRIME, THAT IS A PROJECTION OF THE TAIL ELEVATION ANGLE(TILT) ON THE
C     HORIZONTAL PLANE.  THEN ADD THIS ANGLE TO -TRACK(FOR COORDINATE ROTATION).
      e_prime = ATAN2(SIN(elev * pidiv180),
     +  COS(elev * pidiv180) * SIN(azm * pidiv180))
      theta = ((-track * pidiv180) + e_prime) / pidiv180

C     THETA TO BE OUTPUT BETWEEN -180.0 AND 180.0
      IF (theta.GT.180.0) theta = theta - 360.0
      IF (theta.LT.-180.0) theta = theta + 360.0
c      write(6,*)'convertangles,track,elev,azm,horazm,horelev = ',
c     + track,elev,azm,theta,phi
      RETURN
      END       
