      program center_from_radar_file
C read in radar dysc file  file and estomate center, to test 
C stuff to then be applied to radar tapes or disc files
C I have included logic to deal with cases where legs azimuths are less than
C 90 deg as ,ight happen in NESDIS flights, so we can still define
C legs for partial Doppler analyses.
C Of course I could switch task order, find center first, then legs
C but I like the idea of limiting search within RMW.
C center finder could be improved if pressure or D values were available,
C ala Rahn/Willoughby
C Call it thusly
C center_from_radar_file radar_file start stop output
C If outout not specified then output is written to
C radar_legs_estimate.txt
      parameter(bad_flag=-900.0, missing = -9999, bad_w = -9000.0)
      character cmd*1
	character*80 ps_file
	character create_time*32
	character yesno*1, cstr*60
C
	logical exist
C
	character time_string*4
C Radar tape/file stuff
	character*80 radar_fn, out_fn
      COMMON /TAPEHEADER/ nbytesheader,ntape,nversion,ihheader,imheader,
     +                    isheader,ine,ndrive,naircraft,flightid,stmname
     +                    ,nsamplelf,nsampleta,refslopelf,refslopeta,
     +                    refnoisethreslf,refnoisethresta,sqilf,sqita,
     +                    widththreslf,widththresta,caliblf,calibta,
     +                    modedatalf,modedatata,noisetmlf,noisetmta,
     +                    rpmlf,rpmta,gtlnlf,ivrangelf,ivrangeta,
     +                    gtlnta(3),rdellf,rdelta,rdelcorlf,rdelcorta,
     +                    nbinlf,nbinta,nbins,rmaxlf,rmaxta,
     +                    radiita(512),radiilf(512),
C following 6 variables are new:
     +			  prf_flaglf, prf_flagta, prf_highlf,
     +			  prf_highta, xniqlf, xniqta, 
     +			iheader(1024)
C
      COMMON /RAYHEADER / nbytesdata,nlfsweep,ntasweep,numrecord,
     +                    irecflag,idradar,nbytesray,icode,idsp,mdata,
     +                    iyear,month,iday,iraycode,time,ih,im,
     +                    is,is100,rlat,rlon,ra,gse,gsn,gs,vgs,
     +                    ucom,vcom,wd,ws,vws,ircu,
     +                    elev,azm,pitch,roll,drift,heading,
     +                    dbzbuffer(512),velbuffer(512),widthbuffer(512)
	integer*2 iheader
	integer prf_flaglf, prf_flagta
      INTEGER LUT,BIN1,BIN2,NWEDGE,KINDRADAR, time_ta, time_lf
	integer bins_lf, bine_lf, bins_ta, binm_ta, bine_ta
      CHARACTER FLIGHTID*8,STMNAME*16,ANS,OUTFILE*50
      REAL SECONDS,time_start,time_end,TIME1,TIME2,
     +     AZMCOR,ELCOR,PCOR,RCOR,DCOR
	logical found_tail, want_port
 	integer maxpts, badz
	integer taplu, irdwr, tape, outlu, ierr, method
	character*32 time_stamp ! for writing out current time
C Arrays
	parameter ( max_smpl = 36000) ! 10 h worth of 1 sec data
	real ws_s(max_smpl), wd_s(max_smpl), time_s(max_smpl)
	real rlat_s(max_smpl), rlon_s(max_smpl), track_s(max_smpl)
C
	open(1,file='/dev/tty')
	pi = acos(-1.0)
	pi180 = pi / 180. 
C Will find two spots in eyewall where wind dir 
C differs by at least this amount:
	wd_chng_min = 90.0
	wd_av_chng = 5.0 ! max wind dir change in 5 sec
C Then will find radial legs at most this long:
	radial_leg_length = 210.0
C
C get tape, and  output file
C  From Nancy Griffin's documentation
C	openradarfile(nameradarfile,lut,lup,ierr)
C     nameradarfile(character) - name of disc file to be opened.
C    lut(integer) - logical unit number of disc file, for the open statement.
C     lup(integer) - lu for messages, either 1 or 6.
C     ierr(integer) - lu for error messages.
C
C	radardiscread(LUT,KINDRADAR,IHEADERFLAG,IDATAFLAG, IERR)
C	radardiscrewind(lut)
C 2) You may search for times and sweeps with:
C     discsearch(lut,kindradar,iop,rkey,ierr)
C      This subroutine reads the SIGMET format data and searches for a
C     specified sweep number or a specified time.  It positions the disc at
C     the beginning he specified sweep number or the specified time.
C     lut - disc logical unit number, from open    (integer)
	kindradar = 2
	call getarg(1, radar_fn)
	if(radar_fn .eq. ' ')then
	  write(6,*)' Radar disc file: '
	  read(5,'(a)')radar_fn
c          radar_fn='radarfb.dat'
	end if
	tape = 80
	iout_lu = 21
	call openradarfile(radar_fn, tape,1,ierr)
C	call tapeopen(taplu, irdwr, tape)
C	CALL RADARTAPEREWIND(tape)
C	call tapecontrol(tape, 2,1) ! backspace one file

	IHEADERFLAG=0 !DON'T WANT BIG HEADER INFO
	IDATAFLAG = 6   ! DBZ ARRAY (BIT 2= ON), vel array bit1 = on.
C
C

	call getarg(2,time_string)
	if(time_string .eq. ' ') then
	  write(6,*)' Enter start time (hhmm) '
	  read(5,'(2i2)')ihs,ims
	else
	  read(time_string(1:4), '(2i2)')ihs,ims
	end if
	call getarg(3, time_string)
	if(time_string .eq. ' ') then
	  write(6,*)' Enter end time (hhmm) '
	  read(5,'(2i2)')ihe,ime
	else
	  read(time_string(1:4), '(2i2)')ihe, ime
	end if
	iss = 0
	ise = 0
	call getarg(4, out_fn)
	if(out_fn .eq. ' ') then
		out_fn = 'radar_legs_estimate.txt'
	end if
	open(iout_lu, file=out_fn,form='formatted')
	write(iout_lu,*)'Radial leg lengths: ',radial_leg_length
	write(iout_lu,"('Searched ',3i2.2,1x,3i2.2)")ihs,ims,iss,
     1      ihe,ime,ise
	time_start = 3600.0 * ihs + 60.0 * ims + iss
	time_end = 3600.0 * ihe + 60.0 * ime + ise
	if (time_end .lt. time_start) time_end = time_end + 24.0 *3600.0
C
C space to start time:
	iswp1 = -1
	time = -1.0
	iop = 2 ! 1-> search by sweep number, 2-> search by time
	call discsearch(tape, kindradar,iop,time_start,ierr)
C Now load temp array between time_start and time_end so we dont have to keep reading
C Radar tape or discfile
	is_iprev = -1
	n_smpl = 0
	do while( time .lt. time_end)
	  CALL RADARdiscREAD1(tape,KINDRADAR,IHEADERFLAG,
     +			IDATAFLAG,IERR)
	  if(ierr .lt. 0) then
	   if( ierr .gt. -2 ) then
		write(6,*) ' taperead error ',ierr,' will try next.'
	   else
		write(6,*)ierr, ' eot.'
		go to 900
	   end if
	  end if
	  if(is .ne. is_prev) then ! save sample
		n_smpl = n_smpl + 1
		if(n_smpl .gt. max_smpl) then
			n_smpl = max_smpl
			go to 900 ! break out
		end if
		is_prev = is
		ws_s(n_smpl) = ws
		wd_s(n_smpl) = wd
		time_s(n_smpl) = time
		rlat_s(n_smpl) = rlat
		rlon_s(n_smpl) = rlon
		track_s(n_smpl) = heading + drift
C debug
Cout		write(33,*)ih,im,is,ws,wd,rlat,rlon
C
	  end if
	end do
900	write(iout_lu,*)' Sampling ',n_smpl,' points'
Cout	call radardiscrewind(tape)
	close(tape)
        WRITE(6,*)'FINISHED READING FILE'
c        PAUSE
C 
C
	dt = 1.0
	ws_max = -999.
	wd_max = -999.
	time_max = -999.
	do i = 1, n_smpl
		if( ws_s(i) .gt. ws_max) then
C Make sure this is not an outlier/fucked-up value by comparing wind dirs
			wd_av = 0.0
			n_av = 0
			do ii = max(1, i - 5), i-1
			  wd_av = wd_av + wd_s(ii)
			  n_av = n_av + 1
			end do
			if(n_av .gt.0) then
			  wd_av = wd_av / n_av
			  az_dif = abs(wd_s(i)-wd_av)
			else
			  az_dif = 999.9
			end if
		        if(az_dif .lt. wd_av_chng) then
			  ws_max = ws_s(i)
			  wd_max = wd_s(i)
			  time_max = time_s(i)
			  iptr_max = i
			end if
		end if
	end do
C Now find second max in another part of the storm:
	ws_max_2 = -999.
	wd_max_2 = -999.
	time_max_2 = -999.
	do i = 1, n_smpl
		if( ws_s(i) .gt. ws_max_2) then
C Make sure this is not an outlier/fucked-up value by comparing azimuths
			wd_av = 0.0
			n_av = 0
			do ii = max(1, i - 5), i-1
			  wd_av = wd_av + wd_s(ii)
			  n_av = n_av + 1
			end do
			if(n_av .gt.0) then
			  wd_av = wd_av / n_av
			  az_dif = abs(wd_s(i)-wd_av)
			else
			  az_dif = 999.9
			end if
		        if(az_dif .lt. wd_av_chng) then
			   az_dif_2 = abs(wd_s(i)-wd_max)
			   if(az_dif_2 .gt. wd_chng_min) then
				ws_max_2 = ws_s(i)
				wd_max_2 = wd_s(i)
				time_max_2 = time_s(i)
				iptr_max_2 = i
		   	   end if
			end if
		end if
	end do
Cout	write(iout_lu,*)time_max, ws_max,wd_max
Cout	write(iout_lu,*)time_max_2,ws_max_2, wd_max_2
C Swap so first is first in time
	if(time_max_2 .lt. 0.0) then
	  write(iout_lu,*)' Only one leg will be found'
	else
	  if(time_max .gt. time_max_2) then
		temp = time_max
		time_max  = time_max_2
		time_max_2 = temp
		temp = ws_max
		ws_max = ws_max_2
		ws_max_2 = temp
		temp = wd_max
		wd_max = wd_max_2
		wd_max_2 = temp
		itemp = iptr_max
		iptr_max = iptr_max_2
		iptr_max_2 = itemp
		
	  end if
	end if
C
	write(iout_lu,*)'Wind maxima:'
	rlat_1 = rlat_s(iptr_max)
	rlon_1 = rlon_s(iptr_max)
	call ctme1(time_max,ih1,im1,is1)
	write(iout_lu,234)ih1,im1,is1, ws_max, wd_max, rlat_1, rlon_1
	if(time_max_2 .gt. 0.0) then
	  rlat_2 = rlat_s(iptr_max_2)
	  rlon_2 = rlon_s(iptr_max_2)
	  call ctme1(time_max_2,ih2,im2,is2)
	  write(iout_lu,234)ih2,im2,is2, ws_max_2, wd_max_2, 
     1                      rlat_2, rlon_2
	end if
234	Format(3i2.2, 1x, f6.2,1x,f5.1, f6.2, 1x, f7.2)
C Find point between with min wind
	ws_min = 999.9
	wd_min = 999.9
	time_min = -999.9
	if(time_max_2 .gt. 0.0) then
	  i_search_st = iptr_max
	  i_search_end = iptr_max_2
	else
C Because we only have one wind max, we dont know if that is on
C inbound or outbound so search the whole period
	  i_search_st = 1
	  i_search_end = n_smpl
	end if
	do i = i_search_st, i_search_end
C Added this test in case ws missing
	   if( ws_s(i) .gt. 0.0) then
		if( ws_s(i) .lt. ws_min) then
			ws_min = ws_s(i)
			wd_min = wd_s(i)
			time_min = time_s(i)
			rlat_min = rlat_s(i)
			rlon_min = rlon_s(i)
			iptr_min = i
		end if
	   end if
	end do
	call ctme1(time_min,ihm,imm,ism)
	write(iout_lu,*)'Min flight level wind:'
	write(iout_lu,234)ihm,imm,ism, ws_min, wd_min, 
     1                    rlat_min, rlon_min
C Now find inbound leg start by gnoing backwards from center until
C we are beyonf radial_leg_length
C km per deg of lat and lon at storm lat
  	faclat = 111.132 - .566 * cosd(2.0*rlat_min)
	faclon = 111.415 * cosd(rlat_min) - .09455 * cos(3.0*rlat_min)
	time_in = -999.9
	do i = iptr_min, 1, -1
		dx = ( rlon_s(i) - rlon_min ) * faclon
		dy = ( rlat_s(i) - rlat_min ) * faclat
		radius = sqrt( dx**2 + dy**2)
		if(radius .le. radial_leg_length) then
			time_in = time_s(i)
			rad_dist_1 = radius
			iptr_ib = i
		else
			go to 50 ! Break out
		end if
	end do
50	call ctme1(time_in,ihib, imib, isib)
	rlat_in = rlat_s(iptr_ib)
	rlon_in = rlon_s(iptr_ib)
	write(iout_lu,*)'Inbound leg start:'
	write(iout_lu,234)ihib,imib,isib, ws_s(iptr_ib), wd_s(iptr_ib),        
     +		rlat_s(iptr_ib), rlon_s(iptr_ib)
	write(iout_lu,*)' Inbound radial leg length: ',rad_dist_1
C 
C Note that even if we did not find two wind maxima with wind dirs different,
C we can still get inbound and out legs by using the time of minimum flight
C leve wind.
C Find outbound leg end
	time_out = -999.9
	do i = iptr_min, n_smpl
		dx = ( rlon_s(i) - rlon_min ) * faclon
		dy = ( rlat_s(i) - rlat_min ) * faclat
		radius = sqrt( dx**2 + dy**2)
		if(radius .le. radial_leg_length) then
			time_out = time_s(i)
			rad_dist_2 = radius
			iptr_ob = i
		else
			go to 55 ! Break out
		end if
	end do
55	call ctme1(time_out,ihob, imob, isob)
C
	write(iout_lu,*)'Outbound leg finish:'
	rlat_out = rlat_s(iptr_ob)
	rlon_out = rlon_s(iptr_ob)
	write(iout_lu,234)ihob,imob,isob, ws_s(iptr_ob), wd_s(iptr_ob), 
     +		rlat_out, rlon_out
	write(iout_lu,*)' Outbound radial leg length: ',rad_dist_2
C Now we need to find the average inbound and outbound tracks.
C In this version where I use *.ram files I dont have aircraft track angles
C sp I use aircraft positions at wind max and center to define leg 
C orientations. In the radar disc/tape version I will average the track
C around the wind max values, to avoid problems when Ac maneuvers in the eye.
C Inbound leg:
	dx = (rlon_1 - rlon_min) * faclon
	dy = (rlat_1 - rlat_min) * faclat
	ang = atan2(dy,dx) / pi180
	az_ib = amod(450.0 - ang, 360.0)
	if(time_max .lt. time_min) then
	  write(iout_lu,*)'Inbound azimuth: ', az_ib
	else
	  write(iout_lu,*)'Outbound azimuth for one leg: ', az_ib
	end if
C Outbound leg:
	if(time_max_2 .gt. 0.0) then
	  dx = (rlon_2 - rlon_min) * faclon
	  dy = (rlat_2 - rlat_min) * faclat
	  ang = atan2(dy,dx) / pi180
	  az_ob = amod(450.0 - ang, 360.0)
	  write(iout_lu,*)'Outbound azimuth from wind max: ', az_ob
	else
C use radial leg end to get azimuth
	  dx = (rlon_out - rlon_min) * faclon
	  dy = (rlat_out - rlat_min) * faclat
	  ang = atan2(dy,dx) / pi180
	  az_ob = amod(450.0 - ang, 360.0)
	  write(iout_lu,*)'Outbound azimuth from leg end: ', az_ob
	end if
C Calculate average flight tracks to compare with azimuths:
C of course, as John Gamache pointed out to me, I need to
C average the direction cosines, not the track angles!
 	trk_avg_ib = 0.0
	sin_avg = 0.0
	cos_avg = 0.0
	np = 0
	do i = iptr_ib, iptr_min
		sin_avg = sin_avg + sin(pi180 * track_s(i) )
		cos_avg = cos_avg + cos(pi180 * track_s(i) )
		np = np + 1
	end do
	sin_avg = sin_avg / np
	cos_avg = cos_avg / np
	trk_avg_ib = atan2(sin_avg, cos_avg) / pi180
	trk_avg_ib = mod(trk_avg_ib + 360.0, 360.0)
	radial_ib = mod(trk_avg_ib + 180.0, 360.0)
	write(iout_lu,*)' Average inbound track: ',trk_avg_ib,
     +		'(radial: ',radial_ib,')'
C
	trk_avg_ob = 0.0
	np = 0
	sin_avg = 0.0
	cos_avg = 0.0
	do i = iptr_min, iptr_ob
		sin_avg = sin_avg + sin(pi180 * track_s(i) )
		cos_avg = cos_avg + cos(pi180 * track_s(i) )
		np = np + 1
	end do
	sin_avg = sin_avg / np
	cos_avg = cos_avg / np
	trk_avg_ob = atan2(sin_avg, cos_avg) / pi180
	trk_avg_ob = mod(trk_avg_ob + 360.0, 360.0)
	radial_ob = trk_avg_ob
	write(iout_lu,*)' Average outbound track: ',trk_avg_ob
C
	close(iout_lu)
C Make radial profile file for jobfilemaker
	open(iout_lu, file = 'radar_legs.dat', form = 'formatted')
	write(iout_lu,"(3i2.2,' Inbound start')")ihib,imib,isib
	write(iout_lu,"(3i2.2,' Outbound end')")ihob, imob, isob
	write(iout_lu,"(3i2.2,' Center time')")ihm,imm,ism
	write(iout_lu,*)rlat_min, rlon_min, ' Center lat and lon'
	write(iout_lu,*)trk_avg_ib, radial_ib,' Inbound trk and az'
	write(iout_lu, *)trk_avg_ob, radial_ob,' Outbound trk and az'
C If there are previous centers then read in and compute a storm motion also
	inquire(file = 'stm_centers.dat', exist = exist)
	if(exist)then
	  open(22,file='stm_centers.dat',form='formatted')
	  ih_prev = 0
	  do while (ih_prev .ge. 0)
	    read(22,'(3i2.2,1x,f5.2,1x,f7.2)', end = 777, err = 777) 
     1        ih_prev,im_prev, is_prev, prev_lat, prev_lon
	  end do
777	  close(22)
C Compute storm motion
	  t_prev = ih_prev * 3600.0 + im_prev * 60.0 + is_prev
	  t = ihm * 3600.0 + imm * 60.0 + ism
	  dt = t - t_prev
	  write(6,*)'Prev storm center at ',ih_prev,im_prev,is_prev
	  write(6,*)'Prev lat and lon: ',prev_lat,prev_lon
	  if(dt .gt. 0) then
		dy = (rlat_min - prev_lat) * faclat
		dx = (rlon_min - prev_lon) * faclon
		u_storm = 1000.0 * dx/dt
		v_storm = 1000.0 * dy/dt
                write(6,*)'rlat_min,rlon_min,prev_lat,prev_lon = ',
     1                     rlat_min,rlon_min,prev_lat,prev_lon
                write(6,*)'dx,dy,dt,faclat,faclon = ',
     1                     dx,dy,dt,faclat,faclon
                write(6,*)'u_storm,v_storm = ',u_storm,v_storm
c                pause
	  else
                write(6,*)'no previous file'
c                pause
		u_storm = -999.9
		v_storm = -999.9
	  end if
C Update the centers file
	  open(22,file='stm_centers.dat',form='formatted' )
	  write(22,'(3i2.2,1x,f5.2,1x,f7.2)')ihm,imm,ism,rlat_min,
     1                                       rlon_min
	  write(6,'(3i2.2,1x,f5.2,1x,f7.2)')ihm,imm,ism,rlat_min,
     1                                      rlon_min
          write(6,*)'I am pausing here'
c          pause
	  close(22)
	else
C Make a file with the center we just found
	  open(22,file='stm_centers.dat',form='formatted')
	  write(22,'(3i2.2,1x,f5.2,1x,f7.2)')ihm,imm,ism,rlat_min,
     1                                       rlon_min
	  write(6,'(3i2.2,1x,f5.2,1x,f7.2)')ihm,imm,ism,rlat_min,
     1                                      rlon_min
          close(22)
	  u_storm = -999.9
	  v_storm = -999.9
c          pause
	end if
	write(iout_lu, *)u_storm, v_storm, ' Storm motion m/s'
C Added Willoughby Chelmow  center finder
        wspd_thresh = 5.0
c That value may be too low if the aircraft is circling in the ete,
c especially if hunting for a center!
        cpa_lat = rlat_s(iptr_min)
        cpa_lon = rlon_s(iptr_min)
        cpa_track = track_s(iptr_min)
        npts = n_smpl
	write(6,*)'WC with cpa and track ',cpa_lat,cpa_lon,cpa_track
	write(6,*)'WC with npts, thredh: ',npts, wspd_thresh
        call wc_center_finder(cpa_lat, cpa_lon,cpa_track,
     +          rlat_s, rlon_s, ws_s,wd_s, npts, wspd_thresh,
     +          wc_ctr_lat, wc_ctr_lon, det, ierr_code)
        if(ierr_code .eq. 1) then
          write(6,*)'WC center: ',wc_ctr_lat, wc_ctr_lon
          write(iout_lu,*)wc_ctr_lat, wc_ctr_lon,' WC center.'
        else
	  write(6,*)'WC center failed. err code: ',ierr_code
	end if
        write(6,*)'before close'
	close(iout_lu)
        write(6,*)'after close'
C
C added plot
	width = 450.0
	height = 450.0
	ps_file = 'legs_diagram.ps'
        write(6,*)'rlat_min, rlon_min = ',rlat_min,rlon_min
        write(6,*)"before calling fltlvl_map_sub"
	call fltlvl_map_sub(rlat_min, rlon_min, width, height, n_smpl,
     +    time_s, wd_s, ws_s, rlat_s, rlon_s, iptr_min, iptr_max, 
     +    iptr_max_2, iptr_ib, iptr_ob,wc_ctr_lat,wc_ctr_lon,
     +    ps_file)
        write(6,*)"after returning from fltlvl_map_sub"
1000      END 
