      SUBROUTINE ABCD
     1   (RRMAX,RTMAX,RZMAX,ERMAX,ETMAX,EZMAX,XACC,YACC,ZACC,NF,
     2   SUM1,SUM2,SUM3,SUM4,SUM5,SUM6,SUM7,SUM8,SUM9,
     2   SUM10,SUM11,SUM12,SUM13,
     3   KMIN2,KMAX2,
     4   SINTOL,SRB,STHETAB,SZB,RZB,THETAZB,ZZB,ROTB,
     5   IMAXB,JMAXB,KMAXB,SUMDBZ,
     6   SUMWTSAVE,XWSAVE,YWSAVE,ZWSAVE,IGUESS,
     7   IREADABCD,OLAT,OLON,
     9   SLOPE1,CENTIME,TSTART,TEND,
     1   SMOTIONU,SMOTIONV,FLIGHTID,DBZTEST,RRRR,
     1   UGUESS,VGUESS,WGUESS,IREVERSE,IRAMSFILES,
     1   DISTXYZ,PIMAX,IJTEST,IVSPEED,VSPEED0,VFACTOR,TATF)
C
C THIS ROUTINE CALLS THE DATA-READING AND QUALITY-CONTROL ROUTINE SWEEPIN
C AND THEN INTERPOLATES THE REQUIRED PRODUCTS OF RADIAL VELOCITY WITH 
C DIRECTION COSINE AS WELL AS THE PRODUCTS OF SEPARATE DIRECTION COSINES
C AND FINALLY SUMS OF RADAR REFLECTIVITY.  ALL BUT THE RADAR REFLECTIVITY
C SUMS ARE USED IN THE SYNTHESIS METHOD THAT USES A VARIATION LEAST-SQUARES
C SOLUTION OF THE WIND FIELD
C
C Begin variables that are for the graphics-producing version of this
C routine
C
      PARAMETER(MAX_X=750,MAX_Y=250)
      CHARACTER DISPLAY_LABEL*32,WINDOW_LABEL*28
      CHARACTER DISPLAY_LABELZ*32,WINDOW_LABELZ*18
      INTEGER RAW_WINDOW(47),RAWZ_WINDOW(47)
C
C End graphics variables
C
C OLAT AND OLON ARE PASSED FROM MAIN AND ARE FOR THE OUTPUT SUMFILE
C OLATG AND OLONG ARE FROM THE GUESS FILE THAT IS USED BY THE SWEEP READER
C
      CHARACTER FLIGHTID*8
      REAL GTLENGTH(512)
      REAL UG(400000),VG(400000),WG(400000)
      REAL SUMVR(90,2,3),SUMNVR(90,2,3),VRTOT(2,3),VRTOTN(2,3)
      REAL VRTOTSUM(2,3),VRTOTSUMN(2,3),VRINTERIM(2,3)
      REAL SUMVRSHOW(90,2,3)
      REAL SUMWTSAVE(IMAXB,JMAXB,KMAXB,2)
      REAL XWSAVE(IMAXB,JMAXB,KMAXB,2)
      REAL YWSAVE(IMAXB,JMAXB,KMAXB,2),ZWSAVE(IMAXB,JMAXB,KMAXB,2)
      REAL UMEAN(100,360),VMEAN(100,360),WMEAN(100,360)
      REAL SUMDBZ(IMAXB,JMAXB,KMAXB,2)
      REAL VR(1024),RANGE(1024),DBZ(1024),XR(1024),YR(1024),ZR(1024)
      REAL RDWD(800),RDWS(800),RDVWS(800)
      REAL RAD(1024),THETA(1024)
C
C The following sum variables represent the summations of products that
C are accumlated during the interpolation process
C
      REAL SUM1(IMAXB,JMAXB,KMAXB,2),SUM2(IMAXB,JMAXB,KMAXB,2)
      REAL SUM3(IMAXB,JMAXB,KMAXB,2),SUM4(IMAXB,JMAXB,KMAXB,2)
      REAL SUM5(IMAXB,JMAXB,KMAXB,2),SUM6(IMAXB,JMAXB,KMAXB,2)
      REAL SUM7(IMAXB,JMAXB,KMAXB,2),SUM8(IMAXB,JMAXB,KMAXB,2)
      REAL SUM9(IMAXB,JMAXB,KMAXB,2),SUM10(IMAXB,JMAXB,KMAXB,2)
      REAL SUM11(IMAXB,JMAXB,KMAXB,2),SUM12(IMAXB,JMAXB,KMAXB,2)
      REAL SUM13(IMAXB,JMAXB,KMAXB,2)
      REAL UGUESS(IMAXB,JMAXB,KMAXB),VGUESS(IMAXB,JMAXB,KMAXB)
      REAL WGUESS(IMAXB,JMAXB,KMAXB),RHOK(100)
      REAL DISTXYZ(IMAXB,JMAXB,KMAXB,2,2,2,2)
      REAL VRSWP(512,800),REFSWP(512,800),VRRAD(512,800)
      REAL RDTAI(512),AZ_EL(2,800),EAZM(800),EEV(800)
      REAL VNYQ(512,800),PELEV(800)
      INTEGER JINDEX(512,800),JIINDEX(512,800),DATA_TYPE
      REAL TMP1(512,800),TMP2(512,800),UNFVEL(512,800)
      REAL SWEEPSAVE(512,800)
      REAL TMSWEEP(800),RRLAT(800),RRLON(800),RRA(800)
      INTEGER*2 DBZ_INT(MAX_X,MAX_Y)
      CHARACTER*2 TATF(80),TAF
c      INTEGER*2 CHECKVR(100,400,50),CHECKDBZ(100,400,50)
      REAL SUMMER(100,400,50,2)
      INTEGER WINDOWERROR
      FLAG=-1.0E+10
c      OPEN(68,FILE='sweeps.txt')
c      OPEN(67,FILE='swidth.txt')
      WINDOW_LABEL='cleaned up radial velocities'
      WINDOW_LABELZ='reflectivity (dBZ)'
      ILOG_LU=6
      lablen=28
c      CALL RASX_OPEN_WINDOW(RAW_WINDOW,WINDOWERROR,
c     + WINDOW_LABEL)
      LABLEN=18
c      CALL RASX_OPEN_WINDOW(RAWZ_WINDOW,WINDOWERROR,
c     + WINDOW_LABELZ)
C
C IUSEWIND WILL USUALLY BE 0 FOR THIS ROUTINE, SINCE IT IS USED TO DO THE
C INITIAL INTERPOLATION BEFORE THERE IS A GUESS WIND FIELD
C
      WRITE(6,*)'IGUESS = ',IGUESS
c      PAUSE
      IUSEWIND=IGUESS
      IF(IUSEWIND.EQ.1)THEN
       IJKMAX=400000
       CALL READWIND(UG,VG,WG,IMXG,JMXG,KMXG,SXG,SYG,SZG,
     + OLATG,OLONG,XZG,YZG,ZZG,IJKMAX)
      ENDIF
      ISCANMAX=128
C
C MAX_GATES is Maximum number of gates stored for each radial
C
      MAX_GATES=512
C
C MAX_RAYS is Maximum number of radials expected in a full sweep
C
      MAX_RAYS=800
C
C MDIM is total number of grid points in output fields
C
      MDIM=IMAXB*JMAXB*KMAXB
      WRITE(6,*)'MDIM = IMAXB*JMAXB*KMAXB = ',MDIM
C
C Determine pi to full real-variable resolution
C
      PI=2.*ASIN(1.)
      PI2=2.*PI
      NELAZOLD=0
      ELMIN=-180.
      ELMAX=180.
      DTR=PI/180.
      ISCANDIM=256
      IBINS=7
      SXB2=.5*SXB*SXB
      SYB2=.5*SYB*SYB
      SZB2=.5*SZB*SZB
      JBINS=3*IBINS+1
      RHIGH=200.
      RLOW=.1
      DO L=1,2
       DO LL=1,3
        VRTOTSUM(L,LL)=0.
        VRTOTSUMN(L,LL)=0.
       ENDDO
       DO K=1,KMAXB
        HEIGHT=ZZB+(K-1)*SZB
        RHO=EXP(-HEIGHT*.10437052)
        RHOK(K)=RHO
        DO J=1,JMAXB
         DO I=1,IMAXB
          DO KK=1,2
           DO JJ=1,2
            DO II=1,2
C
C DISTXYZ IS USED FOR DOING A BI-LINEAR INTERPOLATION.  IT GIVES THE DISTANCE
C OF THE THE CLOSEST OBSERVATION THAT WAS INTERPOLATED TO THAT GRID POINT
C IF DISTXYZ FOR II JJ AND KK EQUAL 1 OR 2 IS 1000 FOR ANY OF THEM, THEN IT
C MEANS THE GRID POINT WAS NOT SURROUNDED BY INTERPOLATED DATA.  IT IS 
C USUALLY GOOD TO FLAG SUCH A DATA POINT
C THE FOLLOWING LINE RESETS ALL THE POINTS TO NO DATA FLAG OR 1000
C
             DISTXYZ(I,J,K,L,II,JJ,KK)=1000.
            ENDDO
           ENDDO
          ENDDO
         ENDDO
        ENDDO
       ENDDO
      ENDDO
      DO I=1,256
       A=I
       RANGE(I)=A
       VR(I)=-A
       DBZ(I)=A*2.
      ENDDO
      write(6,*)'entered abcd'
      MDIM2=IMAXB*JMAXB
      WRITE(6,*)'IMAXB,JMAXB,KMAXB,SXB,SYB,SZB,ROTB'
      WRITE(6,*)IMAXB,JMAXB,KMAXB,SXB,SYB,SZB,ROTB
      WRITE(6,*)'Entered ABCD'
      RRWEIGHT=ERMAX*ERMAX
      RTWEIGHT=ETMAX*ETMAX
      RZWEIGHT=EZMAX*EZMAX
      WRITE(6,*)'EHMAX,EZMAX,RXMAX,RYMAX,RZMAX'
      WRITE(6,*)EHMAX,EZMAX,RXMAX,RYMAX,RZMAX    
      WRITE(6,*)'XACC = ',XACC
      WRITE(6,*)'YACC = ',YACC
      WRITE(6,*)'ZACC = ',ZACC
      TIMER=0.
C
C Determine R-Z mean values of tangential (v), radial (u) 
C and vertical (w) wind in the guess file used for advecting observations
C to common composite time
C
      DO K=1,KMAXB
       DO I=1,IMAXB
        SUMV=0.
        SUMU=0.
        SUMW=0.
        DO J=1,JMAXB
         SUMV=SUMV+VGUESS(I,J,K)
         SUMU=SUMU+UGUESS(I,J,K)
         SUMW=SUMW+WGUESS(I,J,K)
        ENDDO
        VMEAN(I,K)=SUMV/JMAXB
        UMEAN(I,K)=SUMU/JMAXB
        WMEAN(I,K)=SUMW/JMAXB
       ENDDO
      ENDDO
      DO L=1,2
       IF(IREADABCD.NE.1)THEN
        DO KK=KMIN2,KMAX2
         DO JJ=1,JMAXB
          DO II=1,IMAXB
C
C First call to ABCD:  zero all angle-projection summations
C
           SUMDBZ(II,JJ,KK,L)=0
           SUMWTSAVE(II,JJ,KK,L)=0
           SUM1(II,JJ,KK,L)=0
           SUM2(II,JJ,KK,L)=0
           SUM3(II,JJ,KK,L)=0
           SUM4(II,JJ,KK,L)=0
           SUM5(II,JJ,KK,L)=0
           SUM6(II,JJ,KK,L)=0
           SUM7(II,JJ,KK,L)=0
           SUM8(II,JJ,KK,L)=0
           SUM9(II,JJ,KK,L)=0
           SUM10(II,JJ,KK,L)=0
           SUM11(II,JJ,KK,L)=0
           SUM12(II,JJ,KK,L)=0
           SUM13(II,JJ,KK,L)=0
           XWSAVE(II,JJ,KK,L)=0
           YWSAVE(II,JJ,KK,L)=0
           ZWSAVE(II,JJ,KK,L)=0
           SUMMER(II,JJ,KK,L)=0
c           CHECKVR(II,JJ,KK,L)=0
c           CHECKDBZ(II,JJ,KK,L)=0
C
C If w found during first iteration, set to zero to begin second iteration
C
          ENDDO
         ENDDO
        ENDDO
       ENDIF
      ENDDO
      IBEGIN=0
      TIMES=0.
      NRECORD=1
      RLATBEFORE=0.
      ICLSWP=0
      IF(IREADABCD.EQ.1)GO TO 72735
92923 TAF=TATF(1)
      DO I=1,1024
       VR(I)=FLAG
       DBZ(I)=FLAG
      ENDDO
c      write(6,*)'calling sweepin iusewind = ',iusewind
C
C SWEEPIN READS DATA FROM A TO_FB FILE, CLEANS IT UP, REMOVES THE SURFACE,
C REMOVES SPECKLES, AND AUTOMATICALLY DE-ALIASES THE DATA IN BOTH A SINGLE-
C RADIAL AND AN AZIMUTHAL MODE
C
      CALL SWEEPIN(VRSWP,REFSWP,MAX_RAYS,MAX_GATES,NUM_RAYS,RDTAI,
     + AZ_EL,ICLSWP,NRECORD,VRRAD,UNFVEL,TMP1,TMP2,JINDEX,
     + JIINDEX,VNYQ,ILATERSWEEP,SWEEPSAVE,UG,VG,WG,
     + IMXG,JMXG,KMXG,SXG,SYG,SZG,OLATG,OLONG,XZG,YZG,ZZG,
     + IUSEWIND,EAZM,EEV,TMSWEEP,RRLAT,RRLON,RRA,
     + SMOTIONU,SMOTIONV,CENTIME,PELEV,NTASWEEP,
     + RDWS,RDWD,RDVWS,NBINS,OLAT,OLON)
c      CLOSE(67)
c      PAUSE
c      write(6,*)'returned from sweeping iusewind = ',iusewind
      ICLSWP=1
      NR=1
      DO I=1,128
       RANGE(I)=RDTAI(I)
       GTLENGTH(I)=RDTAI(I)
      ENDDO
      DO I=1,512
       IF(RANGE(I).GT.RHIGH)RANGE(I)=RHIGH+.01
      ENDDO
C
C BEGIN VARIABLES FOR SCAN GRAPHICS
C
      RMX=1.2*ISCANMAX
      XDIS=75.
      YDIS=10.
      SWEEPSX=.20
      SWEEPSY=.20
      IMAXSWEEP=MAX_X
      JMAXSWEEP=MAX_Y
      RDEL=0.
      RDEL_Z=0.
      NMOSM=0
      BAD_VAL=-888.8
      DOPMIN=-80.
      DOPMAX=80.
      TOO_NOISY=-200.
      AMBIGUOUS=-100.
      BAD_VALZ=-31.5
      DBZMIN=-20.
      DBZMAX=55.
      DATA_TYPE=2
      IXL=20
      IYB=20
C
C END VARIABLES FOR SCAN GRAPHICS
C
c      CALL SOLO_CONVT(DATA_TYPE,ELMIN,ELMAX,
c     + DBZ_INT,MAX_X,MAX_Y,ILOG_LU,
c     + AZ_EL,VRSWP,MAX_GATES,ISCANMAX,NUM_RAYS,IERSM,
c     + IMAXSWEEP,JMAXSWEEP,SWEEPSX,SWEEPSY,XDIS,YDIS,RLATDUM,
c     + RLONDUM,SLATDUM,SLONDUM,RMX,RDEL_Z,TIMES,NMOSM,ITFLG,
c     + GTLENGTH,BAD_VAL)
c      CALL SHOW_IZ(IXL,IYB,DBZ_INT,MAX_X,MAX_Y,IMAXSWEEP,JMAXSWEEP,
c     + DOPMIN,DOPMAX,DATA_TYPE,TOO_NOISY,AMBIGUOUS,
c     + RAW_WINDOW,DISPLAY_LABEL)
      DATA_TYPE=1
c      CALL SOLO_CONVT(DATA_TYPE,ELMIN,ELMAX,
c     + DBZ_INT,MAX_X,MAX_Y,ILOG_LU,
c     + AZ_EL,REFSWP,MAX_GATES,ISCANMAX,NUM_RAYS,IERSM,
c     + IMAXSWEEP,JMAXSWEEP,SWEEPSX,SWEEPSY,XDIS,YDIS,RLATDUM,
c     + RLONDUM,SLATDUM,SLONDUM,RMX,RDEL_Z,TIMES,NMOSM,ITFLG,
c     + GTLENGTH,BAD_VALZ)
c      CALL SHOW_IZ(IXL,IYB,DBZ_INT,MAX_X,MAX_Y,IMAXSWEEP,JMAXSWEEP,
c     + DBZMIN,DBZMAX,DATA_TYPE,TOO_NOISY,AMBIGUOUS,
c     + RAWZ_WINDOW,DISPLAY_LABELZ)
C
C NELAZ KEEPS TRACK OF WHETHER A PARTICULAR RADIAL IS IN A FORE OR AFT SCAN
C THIS HELPS TO DEAL WITH THE ERRORS IN SEPARATING SWEEPS WHEN THE FRENCH
C ANTENNA IS USED
C
      IF(PELEV(2).GE.0.)THEN
       NELAZ=2
      ELSE
       NELAZ=1
      ENDIF
c      write(6,*)'pelev,nelaz = ',pelev(2),nelaz
c      WRITE(6,*)'CHECKING RESET'      
      IF(NELAZ.NE.NELAZOLD)THEN
c       WRITE(6,*)'RESETTING NELAZ,NELAZOLD = ',NELAZ,NELAZOLD
       DO LMN=1,90
        DO MNO=1,2
         DO KNO=1,3
          SUMVR(LMN,MNO,KNO)=0.
          SUMNVR(LMN,MNO,KNO)=0.
         ENDDO
        ENDDO
       ENDDO
       NELAZOLD=NELAZ
      ENDIF
92924 DO WHILE(NR.LE.NUM_RAYS)
       ELEVTEST=PELEV(NR)
       AZEL=AZ_EL(1,NR)+2.
       ELAZ=PELEV(NR)
       NELAZ=1
       IF(ELAZ.GE.0.)NELAZ=2
       IF(AZEL.LT.0.)AZEL=AZEL+360.
       IF(AZEL.GT.360.)AZEL=AZEL-360.
       NVRADD=1+INT(AZEL/4.)
       VV=-RDWS(NR)*COS(RDWD(NR)*3.14159/180.)
       UU=-RDWS(NR)*SIN(RDWD(NR)*3.14159/180.)
       WW=RDVWS(NR)
       REEV=3.14159/180.*EEV(NR)
       REAZM=3.14159/180.*EAZM(NR)
       CREAZM=COS(REAZM)
       SREAZM=SIN(REAZM)
       CREEV=COS(REEV)
       SREEV=SIN(REEV)
c       WRITE(6,*)'NR,EAZM,REAZM,EEV,REEV = ',NR,EAZM(NR),REAZM,
c     +  EEV(NR),REEV
c       WRITE(6,*)'CREAZM,SREAZM,CREEV,SREEV = ',
c     +            CREAZM,SREAZM,CREEV,SREEV
       DO KNO=1,3
        IF(VRSWP(KNO,NR).GT.-800.)THEN
        VRTEST=UU*CREAZM*CREEV
     +  +VV*SREAZM*CREEV+WW*SREEV
        VRCHECK=VRSWP(KNO,NR)-VRTEST
        SUMVR(NVRADD,NELAZ,KNO)=SUMVR(NVRADD,NELAZ,KNO)+VRCHECK
c        WRITE(6,*)'NR,KNO,UU,VV,WW,EAZM,EEV,VRTEST,VRSWP,VRCHECK = ',
c     +   NR,KNO,UU,VV,WW,EAZM(NR),EEV(NR),VRTEST,VRSWP(KNO,NR),VRCHECK
C        WRITE(6,*)'PELEV,NR,NELAZ,VRSWP,NVRADD,AZEL,NTASWEEP = ',
C     +   PELEV(NR),NR,NELAZ,VRSWP(5,NR),NVRADD,AZEL,NTASWEEP
        SUMNVR(NVRADD,NELAZ,KNO)=SUMNVR(NVRADD,NELAZ,KNO)+1
        ENDIF
       ENDDO
c       WRITE(6,*)'TMSWEEP,NR,ELEVTEST = ',TMSWEEP(NR),NR,ELEVTEST
       TAF=TATF(1)
c       WRITE(6,'(A2)')TAF
       IF(ELEVTEST.LE.0.OR.'TAF'.EQ.'TN')THEN
c        IF(ELEVTEST.LE.0.)WRITE(6,*)'GOING TO 27272'
C        IF(ELEVTEST.LE.0.)GO TO 27272
        L2=1
        NF=1
       ELSE
c        IF(ELEVTEST.GT.0.)WRITE(6,*)'GOING TO 27272'
C        IF(ELEVTEST.GT.0.)GO TO 27272
        L2=2
        NF=2
       ENDIF
       RLATBEFORE=RLAT
       TIMES=TMSWEEP(NR)
       AZIM=EAZM(NR)
C
C Sweepin uses math angles but VRLOCATE was based upon using the
C UF file reader which reports back in navigational coordinates
C Thus do a reflection and check
C
       AZIM=90-AZIM
       IF(AZIM.LT.0.)AZIM=AZIM+360.  
       IF(AZIM.GT.360.)AZIM=AZIM-360.
       RALT=RRA(NR)   
       ELEV=EEV(NR)
       RLAT=RRLAT(NR)
       RLON=RRLON(NR)
       RLATR=RLAT
       RLONR=RLON
       IHOURS=TIMES/3600.
       SECLEFT=TIMES-IHOURS*3600.
       IMINS=SECLEFT/60.
       ISECS=TIMES-IHOURS*3600.-IMINS*60.
       ITHHMMSS=IHOURS*10000+IMINS*100+ISECS
c        WRITE(6,*)ITHHMMSS,RLAT,RLON,ELEV,AZIM,JJJSTART,RANGE(JJJSTART)
       DO I=1,128
        VR(I)=VRSWP(I,NR)
        DBZ(I)=REFSWP(I,NR)
c        write(6,'(I5,3F10.3)')NR,VR(I),DBZ(I),RANGE(I)
       ENDDO
       IF(IRAMSFILES.EQ.1)THEN
        CALL READRAMFILE(TIMES,TIME_RAM,RLAT,RLON,DM1,DM2,DM3,
     *                      DM4,DM5,DM6,DM7,IOS)
        IF(IERR.EQ.0.AND.IOS.EQ.0)THEN
         RLATDIFF=RLAT-RLATR
         RLONDIFF=RLON-RLONR
        WRITE(6,*)'RLAT,RLATR,RLATDIFF,RLON,RLONR,RLONDIFF = ',
     +              RLAT,RLATR,RLATDIFF,RLON,RLONR,RLONDIFF
        ELSEIF(IOS.NE.0)THEN
         RLAT=RLATR+RLATDIFF
         RLON=RLONR+RLONDIFF
        WRITE(6,*)'IOS,RLAT,RLATR,RLATDIFF,RLON,RLONR,RLONDIFF = ',
     +              IOS,RLAT,RLATR,RLATDIFF,RLON,RLONR,RLONDIFF
        ELSE
         IHOURS=TIMES/3600.
         SECLEFT=TIMES-IHOURS*3600.
         IMINS=SECLEFT/60.
         ISECS=TIMES-IHOURS*3600.-IMINS*60.
         IHHMMSS=IHOURS*10000+IMINS*100+ISECS
         WRITE(6,*)'TIME,IOS,IERR = ',IHHMMSS,IOS,IERR
         IF(IERR.EQ.-2.OR.IERR.EQ.-3)THEN
          WRITE(6,*)'Are you giving rams coordinates to the '
          WRITE(6,*)'NEXRAD radar i.e. moving the radar?'
         ENDIF
         IF(IERR.LE.-4)GO TO 92923
        ENDIF
       ENDIF
       IF(IBEGIN.EQ.1.AND.TIMES.LT.TSTART)TIMES=TIMES+86400.
c       write(6,*)'times,tend = ',times,tend
       IF(TIMES.GT.TEND.OR.IERR.EQ.-1)GO TO 92929
       IF(TIMES.GT.TIMEOLD)THEN
c        WRITE(6,*)TIMES,RALT,RLAT,RLATR,RLON,RLONR
        ITIMES=NINT(TIMES)
        ITIMEHH=ITIMES/3600
        IREMAIN=ITIMES-3600*ITIMEHH
        ITIMEMM=IREMAIN/60
        ITIMESS=IREMAIN-ITIMEMM*60
c        WRITE(6,10103)ITIMEHH,ITIMEMM,ITIMESS
10103    FORMAT('TIME = ',3I2)
       ENDIF
        TIMEOLD=TIMES
       IF(IREADABCD.NE.1.AND.TIMES.GE.TSTART.AND.TIMES.LE.TEND)THEN
        IF(RDEL.GT.0.)THEN
         JJJSTART=1
        ELSE
         JJJSTART=2-(RDEL/.15)
         ENDIF
c       write(6,9656)(vr(i),i=11,20)
c9656   format('vr(11)-vr(20) = ',10f8.3)
c       write(6,9657)(dbz(i),i=11,20)
c9657   format('dbz(11)-dbz(20) = ',10f8.3)
        IF(RDEL.LT.0)THEN
         DO JJJ=JJJSTART,ISCANDIM
          RANGE(JJJ)=RANGE(JJJ)+RDEL
          IF(IREVERSE.EQ.1)THEN
           VR(JJJ)=-VR(JJJ)
          ENDIF
         ENDDO
        ENDIF
        IHOURS=TIMES/3600.
        SECLEFT=TIMES-IHOURS*3600.
        IMINS=SECLEFT/60.
        ISECS=TIMES-IHOURS*3600.-IMINS*60.
        ITHHMMSS=IHOURS*10000+IMINS*100+ISECS
c       WRITE(6,*)ITHHMMSS,RLAT,RLON,ELEV,AZIM,JJJSTART,RANGE(JJJSTART)
c        RLOW=(RALT/1000.)+2.5
c      WRITE(6,*)TIMES,RLAT,RLON,ELEV,AZIM,JJJSTART,RANGE(JJJSTART),
c     +RLOW,RHIGH
C
C Angle projection summing follows.  
C
        IBEGIN=1
        XWEIGHT=0
        YWEIGHT=0
        ZWEIGHT=0
        SUMWEIGHT=0
        XSHFT=0.
        YSHFT=0.
c       WRITE(6,*)'OLAT,OLON,TIMES = ',OLAT,OLON,TIMES
c       WRITE(6,*)'RLAT,RLON,RALT,ELEV = ',RLAT,RLON,RALT,ELEV
c       WRITE(6,*)'RANGE(10),SMOTIONU,SMOTIONV,CENTIME = ',
c     +        RANGE(10),SMOTIONU,SMOTIONV,CENTIME
c        WRITE(6,*)'XSHFT,YSHFT = ',XSHFT,YSHFT
C
C CALL THE ROUTINE TO DETERMINE GATE LOCATION WITHIN INTERPOLATION GRID
C
        CALL VRLOCATE(OLAT,OLON,TIMES,
     + RLAT,RLON,RALT,ELEV,AZIM,RANGE,XR,YR,ZR,
     + SMOTIONU,SMOTIONV,ISCANDIM,CENTIME,XSHFT,YSHFT,RAD,THETA,
     + ISCANMAX)
c       WRITE(6,*)'TIMES,ELEV,XR(1),YR(1),ZR(1) = ',
c     +  TIMES,ELEV,XR(1),YR(1),ZR(1)
        AZIMM=AZIM-ROTB
        GAMMA=SIN(ELEV*DTR)
        ALPHA=SIN(AZIMM*DTR)*COS(ELEV*DTR)
        BETA=COS(AZIMM*DTR)*COS(ELEV*DTR)
        DO I=JJJSTART,NBINS
c         WRITE(6,*)'I,VR,DBZ,RANGE = ',I,VR(I),DBZ(I),RANGE(I)
         DBZCHK=DBZTEST+20.*ALOG10(RANGE(I)/RRRR)
         RHO=EXP(-ZR(I)*.10437052)
         ZRCHECK=RANGE(I)/57.*.95*COS(ELEV*DTR)
         VRVR=VR(I)
         IF((VR(I).GT.-800..OR.DBZ(I).GT.-30.).AND.
c     +     ZR(I).GT.ZRCHECK.AND.ZR(I).GT..075.
c     +     AND.RANGE(I).GT.RLOW.AND.RANGE(I).LT.RHIGH)THEN
     +     RANGE(I).GT.RLOW.AND.RANGE(I).LT.RHIGH)THEN
          IF(GAMMA.LE.SINTOL)THEN
C
C Determine actual distance from location of datum in data file
C to the point being evaluated in output file 
C
C
C Determine actual distance from location of datum in data file
C to the point being evaluated in output file 
C
           IMIDDLE=NINT((RAD(I)-RZB)/SRB+1.)
           JMIDDLE=NINT((THETA(I)-THETAZB)/STHETAB+1.)
           KMIDDLE=NINT((ZR(I)-ZZB)/SZB+1.)
c           WRITE(6,*)'I,VR(I),IMIDDLE,JMIDDLE,KMIDDLE = ',
c     +      I,VR(I),IMIDDLE,JMIDDLE,KMIDDLE
           TIMEDIFF=TIMES-CENTIME
           IF(IMIDDLE.GT.IMAXB)THEN
            IMID=IMAXB
           ELSEIF(IMIDDLE.LE.0)THEN
            IMID=1
           ELSE
            IMID=IMIDDLE
           ENDIF
           IF(KMIDDLE.GT.KMAX2)THEN
            KMID=KMAX2
           ELSEIF(KMIDDLE.LE.0)THEN
            KMID=1
           ELSE
            KMID=KMIDDLE
           ENDIF
           IF(JMIDDLE.GT.JMAXB)THEN
            JMID=JMAXB
           ELSEIF(JMIDDLE.LE.0)THEN
            JMID=1
           ELSE
            JMID=JMIDDLE
           ENDIF
           HKMID=ZZB+(KMID-1)*SZB
           RHO=EXP(-HKMID*.10437052)
           IF(VGUESS(IMID,JMID,KMID).GT.FLAG)THEN
            VSPEED=VGUESS(IMID,JMID,KMID)/RHO
           ELSE
            VSPEED=FLAG
            DO IL=IMID-1,1,-1
             IF(VGUESS(IL,JMID,KMID).GT.FLAG)THEN
              VSPEED=VGUESS(IL,JMID,KMID)/RHO
              GO TO 9984
             ENDIF
            ENDDO
9984         IF(VSPEED.EQ.FLAG)THEN
             VSPEED=60.
            ENDIF
           ENDIF
           RSPEED=0.
           WSPEED=0.
           UM=0.
           VM=0.
           WM=0.
           VSPEED=0.
c           IF(IGUESS.NE.1)VSPEED=0.
c           IF(IVSPEED.EQ.1)VSPEED=VSPEED0
           DELTHETA=-TIMEDIFF*VSPEED/RAD(I)/1000.*180./3.14159*VFACTOR
c          write(6,*)'vspeed,vfactor,deltheta = ',
c     1               vspeed,vfactor,deltheta
c          write(6,*)'iguess,ivspeed = ',iguess,ivspeed
           DELRAD=-TIMEDIFF*RSPEED/1000.
           DELH=-TIMEDIFF*WSPEED/1000.
           THETA(I)=THETA(I)+DELTHETA
           RAD(I)=RAD(I)+DELRAD
           ZR(I)=ZR(I)+DELH
           IF(THETA(I).GT.360.)THETA(I)=THETA(I)-360.
           IF(THETA(I).LT.0.)THETA(I)=THETA(I)+360.
           thetaneww=theta(i)
           JMIDDLE=NINT((THETA(I)-THETAZB)/STHETAB+1.)
           IMIDDLE=NINT((RAD(I)-RZB)/SRB+1.)
           KMIDDLE=NINT((ZR(I)-ZZB)/SZB+1.)
           IDELTA=INT(RRMAX/SRB)+1
c           write(6,*)'rad(i),sthetab = ',rad(i),sthetab
           JDELTA=INT(RTMAX/STHETAB)+1
C           JDELTA=INT(RTMAX/(RAD(I)*3.14159/180.)/STHETAB)+1
c           write(6,*)'jdelta = ',jdelta
c           write(6,*)'szb = ',szb
c           write(6,*)'rzmax = ',rzmax
           KDELTA=INT(RZMAX/SZB)+1
c           write(6,*)'kdelta = ',kdelta
           IXMIN=IMIDDLE-IDELTA
           IXMAX=IMIDDLE+IDELTA
           IYMIN=JMIDDLE-JDELTA
           IYMAX=JMIDDLE+JDELTA
           IZMIN=KMIDDLE-KDELTA
           IZMAX=KMIDDLE+KDELTA
           IF(IXMIN.LT.1)THEN
            IXMIN=1
           ELSEIF(IXMIN.GT.IMAXB)THEN
            IXMIN=999
           ENDIF
           IF(IXMAX.GT.IMAXB)THEN
            IXMAX=IMAXB
           ELSEIF(IXMAX.LT.1)THEN
            IXMAX=999
           ENDIF
           IF(IZMIN.LT.KMIN2)THEN
            IZMIN=KMIN2
           ELSEIF(IZMIN.GT.KMAX2)THEN
            IZMIN=999
           ENDIF
           IF(IZMAX.LT.KMIN2)THEN
            IZMAX=999
           ELSEIF(IZMAX.GT.KMAX2)THEN
            IZMAX=KMAX2
           ENDIF
           if(rad(i).lt.-100.)then
            write(6,*)'i,rzb,srb,imiddle,idelta,ixmin,ixmax = ',
     +               i,rzb,srb,imiddle,idelta,ixmin,ixmax
          write(6,*)'i,thetazb,sthetab,jmiddle,jdelta,iymin,iymax = ',      
     +               i,thetazb,sthetab,jmiddle,jdelta,iymin,iymax
            write(6,*)'i,zzb,szb,kmiddle,kdelta,izmin,izmax = ',
     +               i,zzb,szb,kmiddle,kdelta,izmin,izmax
           endif
           IF(IXMIN.LT.999.AND.IXMAX.LT.999.AND.IYMIN.LT.999.AND.
     +       IYMAX.LT.999.AND.IZMIN.LT.999.AND.IZMAX.LT.999)THEN
            ALPHAI=(ALPHA*XR(I)+BETA*YR(I))/RAD(I)
            BETAI=(-ALPHA*YR(I)+BETA*XR(I))/RAD(I)
c            write(6,*)'alphai,betai = ',alphai,betai
C           VRVR=VR(I)+45.*BETAI
c          if(vspeed.gt.60.1.or.vspeed.lt.59.9)then
c          if(vguess(imid,jmid,kmid).gt.flag)then
c          write(6,*)'i,timediff,vspeed,deltheta,delrad,delh,theta = ',  
c     1       i,timediff,vspeed,deltheta,delrad,delh,theta(i)
c          write(6,*)'i,vguess,rho = ',i,vguess(il,jmid,kmid),rho
c          write(6,*)'newtheta = ',thetaneww
c          write(6,*)'il,imid,jmid,kmid = ',il,imid,jmid,kmid
c          write(6,*)'theta,rad = ',theta(i),rad(i)
c          endif
            DO KK=IZMIN,IZMAX
             RHOVRVR=VRVR*RHOK(KK)
             HKK=ZZB+(KK-1)*SZB
             RHO=EXP(-HKK*.10437052)
             ZAN=(KK-1)*SZB+ZZB
             RZ=ZR(I)-ZAN
C
C Enclosed was just moved
c
             DO II=IXMIN,IXMAX
              RAN=(II-1)*SRB+RZB
              RX=RAD(I)-RAN
c             RTFACT=(3.14159/180.*RAD(I))**2.
              RTFACT=1.
              DO JJTEST=IYMIN,IYMAX  
              TAN=(JJTEST-1)*STHETAB+THETAZB
               TDIFF=THETA(I)-TAN
               IF(TDIFF.GT.180.)TDIFF=TDIFF-360.
               IF(TDIFF.LT.-180.)TDIFF=TDIFF+360.
               RYDIST=TDIFF*3.14159/180.*RAD(I)
               RY=TDIFF
c              RTTEST=TDIFF*3.14159/180.*RAD(I)
               IF(JJTEST.LT.1)THEN
                IF(IJTEST.EQ.1)THEN
                 JJ=JJTEST+JMAXB
                ELSEIF(ABS(RY).LT.RTMAX)THEN
                 JJ=JJTEST+NINT(360./STHETAB)
                ELSE
                 JJ=-1
                ENDIF
               ELSEIF(JJTEST.GT.JMAXB)THEN
                IF(IJTEST.EQ.1)THEN
                 JJ=JJTEST-JMAXB
                ELSEIF(ABS(RY).LT.RTMAX)THEN
                 JJ=JJTEST-NINT(360./STHETAB)
                ELSE
                 JJ=-1
                ENDIF
               ELSE
                JJ=JJTEST
               ENDIF
               IF(JJ.LT.1.OR.JJ.GT.JMAXB)GO TO 6298
               IF(ABS(RX).GT.RRMAX.OR.ABS(RY).GT.RTMAX.OR.
     +           ABS(RZ).GT.RZMAX)GO TO 6298
               IF(RX.LE.0)IA=1
               IF(RX.GT.0)IA=2
               IF(RY.LE.0)JA=1
               IF(RY.GT.0)JA=2
               IF(RZ.LE.0)KA=1
               IF(RZ.GT.0)KA=2
               RR=SQRT(RX*RX+RTFACT*RYDIST*RYDIST+RZ*RZ)
               IF(RR.LT.DISTXYZ(II,JJ,KK,L2,IA,JA,KA))THEN
                IF(VR(I).GT.-800.)THEN
                 DISTXYZ(II,JJ,KK,L2,IA,JA,KA)=RR
                ENDIF
               ENDIF
               ABC=RX*RX/RRWEIGHT+RY*RY/RTWEIGHT+RZ*RZ/RZWEIGHT
               WEIGHT=EXP(-ABC)
               P=WEIGHT
C
C Accumulate weighted sums of x, y, and z distances of input data
C
               SUMWEIGHT=P
               IF(DBZ(I).GT.-100)THEN
                DBZZ=DBZ(I)*SLOPE1
                ELSE
                DBZZ=-200.
               ENDIF
C
C Perform DBZ weighted sum
C
               IF(DBZ(I).GT.-100.)THEN
                ZE=10.**(DBZZ/10.)
C       if(dbz(i).gt.40.)then
c      write(6,*)'i,dbz(i),dbzz,slope1,ze = ',i,dbz(i),dbzz,slope1,ze
c      write(6,*)'ii,jj,kk = ',ii,jj,kk
c      write(6,*)'rad,weight,abc,rx,ry,rz = ',rad(i),weight,abc,rx,ry,rz
c      write(6,*)'before p,sumdbz,summer = ',
c     +           p,sumdbz(ii,jj,kk),summer(ii,jj,kk)
c      endif
                SUMDBZ(II,JJ,KK,L2)=
     +          SUMDBZ(II,JJ,KK,L2)+P*ZE
                SUMMER(II,JJ,KK,L2)=SUMMER(II,JJ,KK,L2)+P
c      if(dbz(i).gt.40.)then
c      write(6,*)'after sumdbz,summer = ',
c     +           sumdbz(ii,jj,KK,L2),summer(ii,jj,KK,L2)
c      endif
               ENDIF
C
C Perform weighted sums of 9 direction cosine/Vr terms
C
               IF(VR(I).GT.-800.)THEN
                SUM1(II,JJ,KK,L2)=
     +          SUM1(II,JJ,KK,L2)+P*ALPHAI*BETAI
                SUM2(II,JJ,KK,L2)=
     +          SUM2(II,JJ,KK,L2)+P*BETAI*RHOVRVR
                SUM3(II,JJ,KK,L2)=
     +          SUM3(II,JJ,KK,L2)+P*BETAI*BETAI
                SUM4(II,JJ,KK,L2)=
     +          SUM4(II,JJ,KK,L2)+P*ALPHAI*RHOVRVR
                SUM5(II,JJ,KK,L2)=
     +          SUM5(II,JJ,KK,L2)+P*ALPHAI*ALPHAI
                SUM6(II,JJ,KK,L2)=
     +          SUM6(II,JJ,KK,L2)+P*ALPHAI*GAMMA
                SUM7(II,JJ,KK,L2)=
     +          SUM7(II,JJ,KK,L2)+P*BETAI*GAMMA
                SUM8(II,JJ,KK,L2)=
     +          SUM8(II,JJ,KK,L2)+P*GAMMA*GAMMA
                SUM9(II,JJ,KK,L2)=
     +          SUM9(II,JJ,KK,L2)+P*GAMMA*RHOVRVR
                SUM10(II,JJ,KK,L2)=
     +          SUM10(II,JJ,KK,L2)+P*ALPHAI
                SUM11(II,JJ,KK,L2)=
     +          SUM11(II,JJ,KK,L2)+P*BETAI
                SUM12(II,JJ,KK,L2)=
     +          SUM12(II,JJ,KK,L2)+P*GAMMA
                SUM13(II,JJ,KK,L2)=
     +          SUM13(II,JJ,KK,L2)+P*RHOVRVR
                SUMWTSAVE(II,JJ,KK,L2)=SUMWTSAVE(II,JJ,KK,L2)+P
                XWSAVE(II,JJ,KK,L2)=XWSAVE(II,JJ,KK,L2)+P*RX
                YWSAVE(II,JJ,KK,L2)=YWSAVE(II,JJ,KK,L2)+P*RY
                ZWSAVE(II,JJ,KK,L2)=ZWSAVE(II,JJ,KK,L2)+P*RZ
               ENDIF
6298          ENDDO
             ENDDO
            ENDDO
           ENDIF
          ENDIF
         ENDIF
        ENDDO
       ENDIF
27272  NR=NR+1
      ENDDO
C
C BEGIN SUMMATIONS THAT ARE DESIGNED TO DIAGNOSE ERRORS IN ANTENNA TILT
C
      DO J=1,2
       DO KNO=1,3
        VRTOT(J,KNO)=0.
        VRTOTN(J,KNO)=0.
       ENDDO
       DO I=1,45
        DO KNO=1,3
         IF(SUMNVR(I,J,KNO).GT.0..AND.SUMNVR(I+45,J,KNO).GT.0.)THEN
         SUMVRSHOW(I,J,KNO)=SUMVR(I,J,KNO)/SUMNVR(I,J,KNO)
         SUMVRSHOW(I+45,J,KNO)=SUMVR(I+45,J,KNO)/SUMNVR(I+45,J,KNO)
         VRTOT(J,KNO)=
     +    VRTOT(J,KNO)+SUMVRSHOW(I,J,KNO)+SUMVRSHOW(I+45,J,KNO)
          VRTOTN(J,KNO)=VRTOTN(J,KNO)+2.
         ELSE
          SUMVRSHOW(I,J,KNO)=0.
          SUMVRSHOW(I+45,J,KNO)=0.
         ENDIF
        ENDDO
       ENDDO
      ENDDO
C      DO J=1,2
C       DO I=1,45
C        DO KNO=1,3
C         IF(SUMNVR(I,J,KNO).GT.0.)THEN
C          WRITE(6,*)'I,J,SUMVR,SUMNVR = ',I,J,
C     +    SUMVRSHOW(I,J,KNO),SUMVRSHOW(I+45,J,KNO),
C     +    SUMNVR(I,J,KNO),SUMNVR(I+45,J,KNO)
C         ENDIF
C        ENDDO
C       ENDDO
C      ENDDO
      DO J=1,2
       DO KNO=1,3
        VRINTERIM(J,KNO)=0.
        IF(VRTOTN(J,KNO).GT.0.)THEN
         VRTOT(J,KNO)=VRTOT(J,KNO)/VRTOTN(J,KNO)
         VRTOTSUM(J,KNO)=VRTOT(J,KNO)+VRTOTSUM(J,KNO)
         VRTOTSUMN(J,KNO)=VRTOTSUMN(J,KNO)+1.
        ELSE
         VRTOT(J,KNO)=0.
        ENDIF
        IF(VRTOTSUMN(J,KNO).GT.0.)THEN
         VRINTERIM(J,KNO)=VRTOTSUM(J,KNO)/VRTOTSUMN(J,KNO)
        ENDIF
       ENDDO
      ENDDO
c      WRITE(6,*)'VRTOT = ',VRTOT
c      WRITE(6,*)'VRTOTSUM = ',VRTOTSUM
c      WRITE(6,*)'VRTOTSUMN = ',VRTOTSUMN
c      WRITE(6,*)'VRINTERIM = ',VRINTERIM
C
C END DIAGNOSIS OF BIAS IN TILT ANGLE WHERE IT IS ASSUMED
C
      GO TO 92923
92929 WRITE(6,*)'JUST FINISHED VR SUMMATION'
c5554  OPEN(103,FILE='/hrd/dat/gustav/tracking/insideabcd')
c      WRITE(103,*)'AT STATEMENT 5554--NF=',NF
c      WRITE(103,*)'JUST FINISHED VR SUMMATION'
c      CLOSE(103)
C
C DETERMINE IF GRID POINT IS SURROUNDED BY DATA
C
      DO L=1,2
       DO KK=1,KMAXB
        DO JJ=1,JMAXB
         DO II=1,IMAXB
          ITEST=0
          IF(KK.LE.4)THEN
           KABOT=2
          ELSE
           KABOT=1
          ENDIF
          DO KA=KABOT,2
           DO JA=1,2
            DO IA=1,2
             DIST=DISTXYZ(II,JJ,KK,L,IA,JA,KA)
C
C SETTING THIS TEST SO HIGH MEANS THE TEST OF A GRID POINT BEING SURROUNDED
C IS TURNED OFF
C
             IF(DIST.GE.99999999.)THEN
              SUM1(II,JJ,KK,L)=0
              SUM2(II,JJ,KK,L)=0
              SUM3(II,JJ,KK,L)=0
              SUM4(II,JJ,KK,L)=0
              SUM5(II,JJ,KK,L)=0
              SUM6(II,JJ,KK,L)=0
              SUM7(II,JJ,KK,L)=0
              SUM8(II,JJ,KK,L)=0
              SUM9(II,JJ,KK,L)=0
              SUM10(II,JJ,KK,L)=0
              SUM11(II,JJ,KK,L)=0
              SUM12(II,JJ,KK,L)=0
              SUM13(II,JJ,KK,L)=0
              XWSAVE(II,JJ,KK,L)=1000.*SUMWTSAVE(II,JJ,KK,L)
              YWSAVE(II,JJ,KK,L)=1000.*SUMWTSAVE(II,JJ,KK,L)
              ZWSAVE(II,JJ,KK,L)=1000.*SUMWTSAVE(II,JJ,KK,L)
              SUMWTSAVE(II,JJ,KK,L)=0.
              GO TO 10097
             ENDIF
            ENDDO
           ENDDO
          ENDDO
10097    ENDDO
        ENDDO
       ENDDO
      ENDDO
      IOKAY=1
72735 IF(IOKAY.EQ.1)THEN
C
C At end of each complete iteration
C
c       WRITE(6,*)'IN ABCD'
c       WRITE(6,*)'SUM1,SUM2,SUM3 = ',
c     + SUM1(1,1,1,1),SUM2(1,1,1,1),SUM3(1,1,1,1),
c     + SUMDBZ(1,1,1,1),SUMWTSAVE(1,1,1,1)
C
C L =1 AND 2 REPRESENT FORE AND AFT SUMMATIONS
C
       DO L=1,2
        DO KK=KMIN2,KMAX2
c        OPEN(102,FILE='/hrd/dat/gustav/tracking/abcd')
c        WRITE(102,*)'IN ABCD--K,NF = ',KK,NF
c        CLOSE(102)
         DO JJ=1,JMAXB
          DO II=1,IMAXB
           IF(SUMWTSAVE(II,JJ,KK,L).GT.0.AND.
     +       SUMMER(II,JJ,KK,L).GT.0.)THEN
            SUM1(II,JJ,KK,L)=SUM1(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM2(II,JJ,KK,L)=SUM2(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM3(II,JJ,KK,L)=SUM3(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM4(II,JJ,KK,L)=SUM4(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM5(II,JJ,KK,L)=SUM5(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM6(II,JJ,KK,L)=SUM6(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM7(II,JJ,KK,L)=SUM7(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM8(II,JJ,KK,L)=SUM8(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM9(II,JJ,KK,L)=SUM9(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM10(II,JJ,KK,L)=SUM10(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM11(II,JJ,KK,L)=SUM11(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM12(II,JJ,KK,L)=SUM12(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            SUM13(II,JJ,KK,L)=SUM13(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            XWSAVE(II,JJ,KK,L)=XWSAVE(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            YWSAVE(II,JJ,KK,L)=YWSAVE(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            ZWSAVE(II,JJ,KK,L)=ZWSAVE(II,JJ,KK,L)/SUMWTSAVE(II,JJ,KK,L)
            ZE=SUMDBZ(II,JJ,KK,L)/SUMMER(II,JJ,KK,L)
            SUMDBZ(II,JJ,KK,L)=10.*ALOG10(ZE)
           ELSEIF(SUMMER(II,JJ,KK,L).GT.0.)THEN
            ZE=SUMDBZ(II,JJ,KK,L)/SUMMER(II,JJ,KK,L)
            SUMDBZ(II,JJ,KK,L)=10.*ALOG10(ZE)
            SUM1(II,JJ,KK,L)=0
            SUM2(II,JJ,KK,L)=0
            SUM3(II,JJ,KK,L)=0
            SUM4(II,JJ,KK,L)=0
            SUM5(II,JJ,KK,L)=0
            SUM6(II,JJ,KK,L)=0
            SUM7(II,JJ,KK,L)=0
            SUM8(II,JJ,KK,L)=0
            SUM9(II,JJ,KK,L)=0
            SUM10(II,JJ,KK,L)=0
            SUM11(II,JJ,KK,L)=0
            SUM12(II,JJ,KK,L)=0
            SUM13(II,JJ,KK,L)=0
           ELSE
            SUM1(II,JJ,KK,L)=0
            SUM2(II,JJ,KK,L)=0
            SUM3(II,JJ,KK,L)=0
            SUM4(II,JJ,KK,L)=0
            SUM5(II,JJ,KK,L)=0
            SUM6(II,JJ,KK,L)=0
            SUM7(II,JJ,KK,L)=0
            SUM8(II,JJ,KK,L)=0
            SUM9(II,JJ,KK,L)=0
            SUM10(II,JJ,KK,L)=0
            SUM11(II,JJ,KK,L)=0
            SUM12(II,JJ,KK,L)=0
            SUM13(II,JJ,KK,L)=0
            SUMDBZ(II,JJ,KK,L)=FLAG
           ENDIF
          ENDDO
         ENDDO
        ENDDO      
       WRITE(6,*)'SUM1,SUM2,SUM3,SUMDBZ,SUMWTSAVE = ',
     + SUM1(1,1,1,L),SUM2(1,1,1,L),SUM3(1,1,1,L),
     + SUMDBZ(1,1,1,L),SUMWTSAVE(1,1,1,L)
       ENDDO
      ENDIF
C      CLOSE(67)
c      CLOSE(68)
      RETURN
      END
      SUBROUTINE VRLOCATE(OLAT,OLON,TIMES,
     + RLAT,RLON,ALT,ELEV,AZIM,RANGE,XR,YR,ZR,
     + SMOTIONU,SMOTIONV,ISCANDIM,CENTIME,XSHFT,YSHFT,RAD,THETA,
     + ISCANMAX)
C
C THIS ROUTINE IS USED TO LOCATE AN OBSERVATION PROPERLY WITHIN THE 
C THE INTERPOLATION COORDINATE GRID
C
      REAL RANGE(ISCANDIM),XR(ISCANDIM),YR(ISCANDIM),ZR(ISCANDIM)
      REAL RAD(ISCANDIM),THETA(ISCANDIM)
      RALT=ALT/1000.
      PI=ASIN(1.0)*2.
      DTR=PI/180.
      REARTH=6366.
      TDIFF=TIMES-CENTIME
      XSHIFT=TDIFF*SMOTIONU/1000.
      YSHIFT=TDIFF*SMOTIONV/1000.     
      RAZIM=AZIM*DTR
      RELEV=ELEV*DTR
      DO I=1,ISCANMAX
c xradar=horizontal distance from aircraft
c yradar=vertical distance from center of earth
       XRADAR=RANGE(I)*COS(RELEV)
       YRADAR=REARTH+RALT+RANGE(I)*SIN(RELEV)
c radnew=distance of datum from center of earth
       RADNEW=SQRT(XRADAR*XRADAR+YRADAR*YRADAR)
c delangle=angle between vertical at aircraft and vertical at datum
       DELANGLE=ATAN(XRADAR/YRADAR)
c distance along great circle from radar to datum
       DISTANCE=.5*(RADNEW+REARTH+RALT)*DELANGLE
c height=altitude of datum
       HEIGHT=RADNEW-REARTH
c distance2=xradar
       DISTANCE2=RANGE(I)*COS(RELEV)
c height2=altitude of datum not accounting for earth's curvature
       HEIGHT2=RALT+RANGE(I)*SIN(RELEV)
c delx=distance (aircraft/datum) along great circle due to east west
       DELX=DISTANCE*SIN(RAZIM)
c dely=distance(aircraft/datum)along great circle due to north-south
       DELY=DISTANCE*COS(RAZIM)
c dx=east west distance from origin to aircraft
       XLAT=.5*(RLAT+OLAT)*DTR
       DX=(RLON-OLON)*DTR*REARTH*COS(XLAT)
c dy=north south distance from origin to aircraft
       DY=(RLAT-OLAT)*DTR*REARTH
c xshift=east-west distance from lower left corner to origin
c yshift=north-south distance from lower left corner to origin
c XR=distance of datum from lower left corner
c YR=distance of datum from lower left corner
       XR(I)=DELX+DX-XSHIFT+XSHFT
c yshift=distance from lower left corner to origin
       YR(I)=DELY+DY-YSHIFT+YSHFT
       ZR(I)=HEIGHT
       RAD(I)=SQRT(XR(I)*XR(I)+YR(I)*YR(I))
       THETA(I)=ATAN2(YR(I),XR(I))*180./3.14159
       IF(THETA(I).GT.360.)THETA(I)=THETA(I)-360.
       IF(THETA(I).LT.0.)THETA(I)=THETA(I)+360.
c       WRITE(1,*)'I,RANGE,DISTANCE,HEIGHT,DELX,DELY,DX,DY,XSHIFT,'
c     +  'YSHIFT = ',
c     +  I,RANGE(I),DISTANCE,HEIGHT,DELX,DELY,DX,DY,XSHIFT,YSHIFT
      ENDDO
      CONTINUE
      END
