	Subroutine WritePSSub(id,nid)
C modified 22 May bt p dodge, HRD, so lines are split properly...
	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer nid,id(nid)

        Write (95,*)'%********************'
	Write (95,*)'% DEFINE SUBROUTINES'
        Write (95,*)'%********************'
C Write out routine to draw white space around contour labels
*	Call Label_space 
C Write gray/color table
	IF (plot_type.NE.1.AND.color_flag.EQ.'Y') THEN
	 Call WriteSubColor
	ELSEIF (plot_type.NE.1.AND.color_flag.EQ.'N') THEN
	 Call WriteSubGray
	ENDIF
C Write clipping routine
	Call WriteSubClipIt
C Write routine that draws the gray/color scale
	IF (plot_type.NE.1) THEN
	 Call WriteSubDrawScale 
	ENDIF
C Write font routine 
	Call WriteSubFont
C Write routine that draws the box
	Call WriteSubBox
C Write routine that draws tick marks
	Call WriteSubGrid
C Write routine that draws vectors
	IF (plot_type.NE.2.OR.plot_type.NE.4) THEN
	 Call WriteSubArrow
	ENDIF
C Write routine that handles text
	Call WriteSubText 
C Call FlightTrack if airborne radar
	IF ((fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') .AND.
     +		scan_mode.EQ.'AIR') THEN
           IF (catalog_name(1:4).NE.'none') THEN
	     Call FlightTrack
	     Call ReadScan(id,nid)
	   ENDIF
	ENDIF

	Return
	End
**************************************************
C Subroutines to write PostScript subroutines
**************************************************
	Subroutine Label_space

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	
	Write (95,*)'%WHITE SPACE FOR CONTOUR LABELS'
	Write (95,*)'/fill_label {'
 	Write (95,*)'/theta exch def /y exch def /x exch def' 
 	Write (95,*)'stringwidth pop /side exch def'
 	Write (95,*)'gsave x y translate theta rotate side '
	Write (95,*)' 2 div neg side 4 div neg moveto'
 	Write (95,*)'1 setgray  side 0 rlineto 0 side 2 div rlineto'
 	Write (95,*)'side neg 0 rlineto closepath fill grestore'
 	Write (95,*)'} def'


	Return
	End
**************************************************
	Subroutine WriteSubGray 

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer fillnum

	fillnum=nint(fill_num)

	Write (95,*)'%GRAY OR COLOR SCALE' 
        Write (95,*) '/ct 256 array def'
        Write (95,*) '/o {ct exch get aload pop setrgbcolor} def'
        Write (95,*) '%the gray scale for hp laser prninter'
        IF (fillnum.EQ.4.) THEN
         Write (95,*) 'ct 1 [ 1.00  1.00  1.00 ] put'
         Write (95,*) 'ct 2 [ 0.90  0.90  0.90 ] put'
         Write (95,*) 'ct 3 [ 0.75  0.75  0.75 ] put'
         Write (95,*) 'ct 4 [ 0.55  0.55  0.55 ] put'
         Write (95,*) 'ct 5 [ .300  .300  .300 ] put'
         Write (95,*) 'ct 15 [ .00  .00  .00 ] put'
        ELSEIF (fillnum.EQ.5.) THEN
         Write (95,*) 'ct 1 [ 1.00  1.00  1.00 ] put'
         Write (95,*) 'ct 2 [ 0.99  0.99  0.99 ] put'
         Write (95,*) 'ct 3 [ 0.90  0.90  0.90 ] put'
         Write (95,*) 'ct 4 [ 0.75  0.75  0.75 ] put'
         Write (95,*) 'ct 5 [ 0.55  0.55  0.55 ] put'
         Write (95,*) 'ct 6 [ .300  .300  .300 ] put'
         Write (95,*) 'ct 15 [ .00  .00  .00 ] put'
        ELSEIF (fillnum.EQ.6.) THEN
         Write (95,*) 'ct 1 [ 1.00  1.00  1.00 ] put'
         Write (95,*) 'ct 2 [ 0.99  0.99  0.99 ] put'
         Write (95,*) 'ct 3 [ 0.94  0.94  0.94 ] put'
         Write (95,*) 'ct 4 [ 0.80  0.80  0.80 ] put'
         Write (95,*) 'ct 5 [ 0.62  0.60  0.62 ] put'
         Write (95,*) 'ct 6 [ 0.40  0.40  0.40 ] put'
         Write (95,*) 'ct 7 [ .200  .200  .200 ] put'
         Write (95,*) 'ct 15 [ .00  .00  .00 ] put'
        ELSEIF (fillnum.EQ.7.) THEN
         Write (95,*) 'ct 1 [ 1.00  1.00  1.00 ] put'
         Write (95,*) 'ct 2 [ 0.99  0.99  0.99 ] put'
         Write (95,*) 'ct 3 [ 0.90  0.90  0.90 ] put'
         Write (95,*) 'ct 4 [ 0.80  0.80  0.80 ] put'
         Write (95,*) 'ct 5 [ 0.70  0.70  0.70 ] put'
         Write (95,*) 'ct 6 [ 0.50  0.50  0.50 ] put'
         Write (95,*) 'ct 7 [ 0.35  0.35  0.35 ] put'
         Write (95,*) 'ct 8 [ .200  .200  .200 ] put'
         Write (95,*) 'ct 15 [ .00  .00  .00 ] put'
        ELSEIF (fillnum.EQ.8.) THEN
         Write (95,*) 'ct 1 [ 1.00  1.00  1.00 ] put'
         Write (95,*) 'ct 2 [ 0.99  0.99  0.99 ] put'
         Write (95,*) 'ct 3 [ 0.90  0.90  0.90 ] put'
         Write (95,*) 'ct 4 [ 0.80  0.80  0.80 ] put'
         Write (95,*) 'ct 5 [ 0.65  0.65  0.65 ] put'
         Write (95,*) 'ct 6 [ 0.50  0.50  0.50 ] put'
         Write (95,*) 'ct 7 [ 0.45  0.45  0.45 ] put'
         Write (95,*) 'ct 8 [ 0.35  0.35  0.35 ] put'
         Write (95,*) 'ct 9 [ .200  .200  .200 ] put'
         Write (95,*) 'ct 15 [ .00  .00  .00 ] put'
       ELSEIF (fillnum.EQ.9.) THEN
         Write (95,*) 'ct 1 [ 1.00  1.00  1.00 ] put'
         Write (95,*) 'ct 2 [ 0.99  0.99  0.99 ] put'
         Write (95,*) 'ct 3 [ 0.94  0.94  0.94 ] put'
         Write (95,*) 'ct 4 [ 0.90  0.90  0.90 ] put'
         Write (95,*) 'ct 5 [ 0.85  0.85  0.85 ] put'
         Write (95,*) 'ct 6 [ 0.80  0.80  0.80 ] put'
         Write (95,*) 'ct 7 [ 0.75  0.75  0.75 ] put'
         Write (95,*) 'ct 8 [ 0.65  0.65  0.65 ] put'
         Write (95,*) 'ct 9 [ 0.45  0.45  0.45 ] put'
         Write (95,*) 'ct 10 [ .200  .200  .200 ] put'
         Write (95,*) 'ct 15 [ .00  .00  .00 ] put'
       ELSEIF (fillnum.EQ.10.) THEN
         Write (95,*) 'ct 1 [ 1.00  1.00  1.00 ] put'
         Write (95,*) 'ct 2 [ 0.995  0.995  0.995 ] put'
         Write (95,*) 'ct 3 [ 0.97  0.97  0.97 ] put'
         Write (95,*) 'ct 4 [ 0.90  0.90  0.90 ] put'
         Write (95,*) 'ct 5 [ 0.85  0.85  0.85 ] put'
         Write (95,*) 'ct 6 [ 0.80  0.80  0.80 ] put'
         Write (95,*) 'ct 7 [ 0.75  0.75  0.75 ] put'
         Write (95,*) 'ct 8 [ 0.65  0.65  0.65 ] put'
         Write (95,*) 'ct 9 [ 0.50  0.50  0.50 ] put'
         Write (95,*) 'ct 10 [ 0.35  0.35  0.35 ] put'
         Write (95,*) 'ct 11 [ .200  .200  .200 ] put'
         Write (95,*) 'ct 15 [ .00  .00  .00 ] put'
        ELSE
         Write(200,*) 'ERROR: NUMBER OF GRAY SCALE INCREMENTS MUST BE '
	 Write(200,*) 'BETWEEN 4 AND 10'
        ENDIF


	Return
	End
**************************************************
	Subroutine WriteSubColor

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer i,k,count,index
        integer nlook
	Real val1
	Integer colorbeg,colorend
	Real colorinc
	Character*14 rgbval(45)

C ASSIGN THE RGB VALUES FOR THE COLOR TABLE..BASED ON CARBONE 42
        rgbval(1)='1.00 1.00 1.00'
        rgbval(2)='.469 .020 .640'
        rgbval(3)='.403 .227 .559'
        rgbval(4)='.164 .055 .582'
        rgbval(5)='.227 .055 .672'
        rgbval(6)='.289 .055 .766'
        rgbval(7)='.352 .141 .898'
        rgbval(8)='.414 .375 .996'
        rgbval(9)='.445 .559 .996'
        rgbval(10)='.281 .590 .602'
        rgbval(11)='.188 .523 .371'
        rgbval(12)='.004 .445 .000'
        rgbval(13)='.000 .492 .000'
        rgbval(14)='.000 .539 .000'
        rgbval(15)='.059 .586 .059'
        rgbval(16)='.176 .633 .176'
        rgbval(17)='.289 .680 .289'
        rgbval(18)='.402 .723 .402'
        rgbval(19)='.520 .770 .520'
        rgbval(20)='.633 .816 .633'
        rgbval(21)='.750 .863 .750'
	rgbval(22)='.863 .910 .863'
        rgbval(23)='.938 .906 .703'
        rgbval(24)='.938 .859 .352'
        rgbval(25)='.938 .812 .000'
        rgbval(26)='.938 .766 .023'
        rgbval(27)='.938 .719 .055'
        rgbval(28)='.926 .672 .086'
        rgbval(29)='.871 .625 .117'
        rgbval(30)='.816 .578 .148'
        rgbval(31)='.758 .531 .180'
        rgbval(32)='.703 .484 .211'
        rgbval(33)='.648 .438 .242'
        rgbval(34)='.590 .391 .250'
        rgbval(35)='.535 .344 .250'
        rgbval(36)='.485 .328 .297'
        rgbval(37)='.629 .312 .375'
        rgbval(38)='.625 .003 .000'
        rgbval(39)='.718 .086 .188'
        rgbval(40)='.813 .148 .273'
        rgbval(41)='.879 .211 .355'
        rgbval(42)='.949 .273 .355'
        rgbval(43)='1.00 .012 .000'
        rgbval(44)='0.00 0.00 0.00'

C CALCULATE THE MID VALUE SO THAT THE GREY COLOR CORRESPONDS
C WITH 0 VALUE
	colorinc=num_colors/fill_num
        write(6,*)'colorinc,num_colors,fill_num = ',
     1   colorinc,num_colors,fill_num
c        pause
	IF (cont_type.EQ.0) THEN
          k=0
          val1=fill_beg
10        IF (val1.LT.0) THEN
            val1=val1+fill_inc
            k=k+1
            goto 10
          ENDIF
          midval=k
	ELSE
	  midval=int(fill_num/2)+1
	ENDIF
        write(6,*)'position 2 colorinc = ',colorinc
c        pause
	IF (cont_type.EQ.0.OR.cont_type.EQ.1) THEN
           write(6,*)'midval,colorinc = ',midval,colorinc
           nlook=2+((midval-1)*colorinc)
           write(6,*)'nlook = ',nlook
           if(nlook.ge.1)then
            rgbval(2+((midval-1)*colorinc))='.863 .863 .863'
           endif
	ENDIF
        write(6,*)'position 3 colorinc = ',colorinc
c        pause
C CALCULATE THE BEGIN & END COLORS
        colorbeg=2
	colorend=43
	Write(95,*)'%GRAY OR COLOR SCALE' 
        Write(95,*) '/ct 256 array def'
        Write(95,*) '/o {ct exch get aload pop setrgbcolor} def'
        Write(95,*) '%the gray scale for hp laser printer'
	count=1
	Write(95,20)count,rgbval(1)
        write(6,*)'position 4 colorinc = ',colorinc
c        pause
	DO i=1,fill_num
*	DO i=colorbeg,colorend,colorinc
	   count=count+1
	   index=2+int((i-1)*colorinc)
	   Write(95,20)count,rgbval(index)
           write(6,*)'i,colorinc = ',i,colorinc
           write(6,*)'count = ',count
           write(6,*)'index = ',index
           write(6,*)'rgbval(index) = ',rgbval(index)
c           pause
	ENDDO
	count=44
	Write(95,20)count,rgbval(44)
20	Format('ct ',I2,' [ ',A,' ] put')

	Return
	End
**************************************************
	Subroutine WriteSubClipIt

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Write (95,*)'% DEFINE CLIPPING PATH'
	Write (95,*)'/ClipIt {'
	Write (95,*)'newpath'
	Write (95,*)'0 0 moveto'
	Write (95,*)'box_w 0 rlineto'
	Write (95,*)'0 box_h rlineto'
	Write (95,*)'box_w neg 0 rlineto'
	Write (95,*)'closepath clip newpath } def'

	Return
	End
**************************************************
	Subroutine WriteSubDrawScale 

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'


	
	Write (95,*)'% DRAW THE GRAY/COLOR SCALE'
	Write (95,*) '/DrawScale{'
        Write (95,10)int(fill_num)
10      Format ('1 1 ',I2,' {')
        Write (95,*) '/y exch def'
        Write (95,*) '0 y 1 sub scale_box_h mul moveto'
        Write (95,*) 'scale_w 0 rlineto'
        Write (95,*) '0 scale_box_h rlineto'
        Write (95,*) 'scale_w neg 0 rlineto'
*        Write (95,*) 'closepath numo o fill'
        Write (95,*) 'closepath y 1 add o fill'
        Write (95,*) '0 setgray'
        Write (95,*) '0 y 1 sub scale_box_h mul moveto'
        Write (95,*) 'scale_w 0 rlineto'
        Write (95,*) '0 scale_box_h rlineto'
        Write (95,*) 'scale_w neg 0 rlineto'
        Write (95,*) 'closepath stroke } for } def'

	Return
	End
**************************************************
	Subroutine WriteSubFont

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'
	
        Write (95,*) '% SELECT FONT'
        Write (95,*) '/font {findfont exch scalefont setfont} def'

	Return
	End
**************************************************
	Subroutine WriteSubBox

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

        Write (95,*) '% DRAW BOX'
        Write (95,*) '/box {'
        Write (95,*) ' 0 0 moveto'
        Write (95,*) ' box_w 0 lineto'
        Write (95,*) ' 0 box_h rlineto'
        Write (95,*) ' box_w neg 0 rlineto'
        Write (95,*) ' closepath stroke } def'

	Return
	End
**************************************************
	Subroutine WriteSubGrid

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'


	IF (fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') THEN
	 hkm='xkm'
	 vkm='ykm'
	ELSEIF (fix_axis.EQ.'Y'.OR.fix_axis.EQ.'y') THEN
	 hkm='xkm'
	 vkm='zkm'
	ELSEIF (fix_axis.EQ.'X'.OR.fix_axis.EQ.'x') THEN
	 hkm='ykm'
	 vkm='zkm'
	ENDIF
	
        Write (95,*) '% GENERATE HORIZONTAL PRIMARY GRID MARKS'
        Write (95,*) '/phgrid {'
        Write (95,10)tick_hbeg1,hkm 
10	Format (F6.2,1X,A,' pri_grid1 box_w {')
        Write (95,*) '8 moveto 0 8 neg rlineto'
        Write (95,*) 'stroke } for'
        Write (95,11)tick_hbeg1,hkm 
11	Format (F6.2,1X,A,' pri_grid1 box_w {')
        Write (95,*) 'box_h moveto 0 8 neg rlineto'
        Write (95,*) 'stroke } for'
	Write (95,*) '} def'
        Write (95,*) '% GENERATE VERTICAL PRIMARY GRID MARKS'
        Write (95,*) '/pvgrid {'
        Write (95,20) tick_vbeg1,vkm
20	Format (F6.2,1X,A,' pri_grid2 box_h {')
        Write (95,*) '8 exch moveto 8 neg 0 rlineto'
        Write (95,*) 'stroke } for'
        Write (95,21) tick_vbeg1,vkm
21	Format (F6.2,1X,A,' pri_grid2 box_h {')
        Write (95,*) 'box_w exch moveto 8 neg 0 rlineto'
        Write (95,*) 'stroke } for' 
	Write (95,*) '} def'
        Write (95,*) '% GENERATE HORIZONTAL SECONDARY GRID MARKS'
        Write (95,*) '/shgrid {'
        Write (95,30) tick_hbeg2,hkm
30	Format (F6.2,1X,A,' sec_grid1 box_w {')
        Write (95,*) '4 moveto 0 4 neg rlineto'
        Write (95,*) 'stroke } for'
        Write (95,31) tick_hbeg2,hkm
31	Format (F6.2,1X,A,' sec_grid1 box_w {')
        Write (95,*) 'box_h moveto 0 4 neg rlineto'
        Write (95,*) 'stroke } for'
	Write (95,*) '} def'
        Write (95,*) '% GENERATE VERTICAL SECONDARY GRID MARKS'
        Write (95,*) '/svgrid {'
        Write (95,40) tick_vbeg2,vkm
40	Format (F6.2,1X,A,' sec_grid2 box_h {')
        Write (95,*) '4 exch moveto 4 neg 0 rlineto'
        Write (95,*) 'stroke } for'
        Write (95,41) tick_vbeg2,vkm
41	Format (F6.2,1X,A,' sec_grid2 box_h {')
        Write (95,*) 'box_w exch moveto 4 neg 0 rlineto'
        Write (95,*) 'stroke } for' 
	Write (95,*) '} def'

	Return
	End
**************************************************
	Subroutine WriteSubArrow

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Write (95,*)'% DRAW VECTORS'

        Write (95,*) '/veclen 60 def'
        Write (95,*) '/arrlen 9 def'
        Write (95,*) '/vecthick 2 def'
        Write (95,*) '/arrthick 7 def'
        Write (95,*) '/arrowdict 14 dict def'
        Write (95,*) '/radius 180 def'
        Write (95,*) 'arrowdict begin'
        Write (95,*) '/mtrx matrix def'
        Write (95,*) 'end'
        Write (95,*)
        Write (95,*) '%arrow routine obtained from Dave Johnson'
        Write (95,*) '/arrow'
        Write (95,*) '{ arrowdict begin'
	Write (95,*)
     +		'/headlength exch def /halfheadthickness exch 2 div def'
        Write (95,*) '/halfthickness exch 2 div def'
        Write (95,*) '/tipx exch def /tipy exch def'
        Write (95,*) '/tailx exch def /taily exch def'
	Write (95,*)
     +		'/arrowlength tipx tipx mul tipy tipy mul add sqrt def'
        Write (95,*) '/angle tipy tipx atan def'
        Write (95,*) '/base arrowlength headlength sub def'
        Write (95,*)
        Write (95,*) '/savematrix mtrx currentmatrix def'
        Write (95,*)
        Write (95,*) 'tailx taily translate angle rotate'
        Write (95,*)
	Write (95,*)
     +		'0 halfthickness neg moveto base halfthickness neg lineto'
	Write (95,*)
     +		'base halfheadthickness neg lineto arrowlength 0 lineto'
	Write (95,*)
     +		'base halfheadthickness lineto base halfthickness lineto'
        Write (95,*)'0 halfthickness lineto closepath'
        Write (95,*)
	Write (95,*) 'savematrix setmatrix end } def'

	Return
	End
**************************************************
	Subroutine WriteSubText

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Write (95,*) '% TEXT-HANDLING PROCEDURE'
	Write (95,*) '%text-handling procedure'
	Write (95,*)
     +		'% syntex:  xloc yloc angle (text) xcenter ycenter text_pos'
	Write (95,*) '   /textdict 25 dict def'
	Write (95,*) '    textdict begin'	
	Write (95,*)
     +	    	'       /delta 2 def /graytext 0 def /grayback  1 def'
	Write (95,*) '       /lino  false def lino { 4 setflat } if'	
	Write (95,*)
     +		'       /tcfp {true charpath flattenpath pathbbox} def'	
	Write (95,*)
     +		'       /lcpbbox  {           { strX  0  3  -1  roll put'	
	Write (95,*) '           newpath  0  0  moveto'	
	Write (95,*) '           strX tcfp'	
	Write (95,*)
     +		'             dup y2 gt { /y2 exch def } { pop } ifelse'	
	Write (95,*)
     +		'    xoff add dup x2 gt { /x2 exch def } { pop } ifelse'
	Write (95,*)
     +		'             dup y1 lt { /y1 exch def } { pop } ifelse'	
	Write (95,*)
     +		'    xoff add dup x1 lt { /x1 exch def } { pop } ifelse'
	Write (95,*)
     +		'           strX stringwidth pop xoff add /xoff exch def'
	Write (95,*) '             }  forall  } def end' 	
	Write (95,*)	
  	Write (95,*) '/text_pos { textdict begin'
        Write (95,*) '       /back  false  def'
    	Write (95,*) '/strX (x) def  /xoff  0  def'
    	Write (95,*) '/x1    0  def  /x2    0  def'
    	Write (95,*) '/y1    0  def  /y2    0  def'
    	Write (95,*) '/cy  exch def  /cx  exch def'
    	Write (95,*) '/str exch def  /ang exch def'
    	Write (95,*) '/yy  exch def  /xx  exch def'
    	Write (95,*) 'cx 0 lt { /back true def  /cx cx neg def } if'
    	Write (95,*) 'newpath  0 0 moveto'
    	Write (95,*) 'str lcpbbox'
    	Write (95,*) 'clear newpath'
    	Write (95,*) 'cx 0 eq { /xxx 0  def } if'
    	Write (95,*) 'cx 1 eq { /xxx x1   neg def } if'
*    	Write (95,*) 'cx 2 eq { /xxx x1 x2 add neg 2 div def } if'
    	Write (95,*) 'cx 2 eq { /xxx x1 xoff add neg 2 div def } if'
    	Write (95,*) 'cx 3 eq { /xxx x2   neg def } if'
    	Write (95,*) 'cx 4 eq { /xxx xoff neg def } if'
	Write (95,*) 'cy 0 eq { /yyy y1   neg def } if'
    	Write (95,*) 'cy 1 eq { /yyy 0  def } if'
    	Write (95,*) 'cy 2 eq { /yyy y2 2 div neg def } if'
    	Write (95,*) 'cy 3 eq { /yyy y2   neg def } if'
    	Write (95,*) 'xx yy translate ang rotate } def'

C This is for normal text
	Write (95,*)'%NORMAL TEXT'
	Write (95,*)'/text1 {'
    	Write (95,*)
     +		'xxx yyy moveto str show  back { xxx yyy moveto } if'
    	Write (95,*)
     +		'ang neg rotate  xx neg yy neg translate  end }  def'
C This is for labeling contour lines...puts a white space around text 
	Write (95,*)'%CONTOUR TEXT'
	Write (95,*)'%syntax: spacex spacey text2'
	Write (95,*)'/text2 {'
	Write (95,*)'/spacey exch def /spacex exch def'
	Write (95,*)'/hor_side {spacex 2 mul xoff add} def'
	Write (95,*)'/ver_side {spacey 2 mul y2 add} def'
*	Write (95,*)'xxx yyy moveto str show  back'
	Write (95,*)'back'
	Write (95,*)'{xxx spacex sub yyy spacey sub moveto'
	Write (95,*)'hor_side 0 rlineto 0 ver_side rlineto '
C following two lines were origianlly one line ... p dodge
	Write (95,*)'hor_side neg 0 rlineto closepath '
	Write (95,*)' 1 setgray fill 0 setgray} if'
	Write (95,*)'xxx yyy moveto str show'
	Write (95,*)
     +		'ang neg rotate  xx neg yy neg translate  end }  def'

	Return
	End
**************************************************
	Subroutine FlightTrack

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

        Write (95,*) '% DRAW FLIGHT TRACK'
        Write (95,*) '/plotplane {'
        Write (95,*) '/i {10 mul} def'
        Write (95,*) '/r {rlineto} def'
        Write (95,*) '/angle exch def'
        Write (95,*) '/y exch def'
        Write (95,*) '/x exch def'
        Write (95,*) 'gsave newpath'
        Write (95,*) 'x xkm y ykm translate'
        Write (95,*) 'angle 180 add rotate'
        Write (95,*) '.125 i .125 i moveto'
        Write (95,*) '.125 i .0625 i .0625 i 180 90 arcn'
        Write (95,*) '.125 i .125 i moveto'
        Write (95,*) '.1875 i .0625 i r'
        Write (95,*) '.50 i 0 r'
        Write (95,*) '.1875 i .5 i r'
        Write (95,*) '.125 i 0 r'
        Write (95,*) '.125 i neg .50 i neg r'
        Write (95,*) '.375 i 0 r'
        Write (95,*) '.0625 i .125 i r'
        Write (95,*) '.0625 i 0 r'
        Write (95,*) '.0625 i neg .25 i neg r'
        Write (95,*) '.0625 i .25 i neg r'
        Write (95,*) '.0625 i neg 0 r'
        Write (95,*) '.0625 i neg .125 i r'    
        Write (95,*) '.375 i neg 0 r'
        Write (95,*) '.125 i .50 i neg r'
        Write (95,*) '.125 i neg 0 r'   
        Write (95,*) '.1875 i neg .5 i r'
        Write (95,*) '.50 i neg 0 r'
        Write (95,*) '.1875 i neg .0625 i r'
        Write (95,*) '.125 i .0625 i .0625 i 270 180 arcn' 
        Write (95,*) 'closepath' 
        Write (95,*) 'fill grestore } def' 

	Return
	End
**************************************************
	Subroutine ReadScan(id,nid)

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer i,j,end,scan(150)
	Integer nid,id(nid)
        Real x1, y1,dtheta,dtor
        Real lat,long,lat1,long1,head,alt,origx,origy,x,y,angle
        Character*4  temp
        Character*15 temp1
        Character*16 temp2
        Character*20 temp3,temp4

 	Open (unit=50,file=catalog_name,status='old')
 	Open (unit=51,file="debug.out",status='unknown')

*	origx=real(lat_deg+(lat_min/60.)+(lat_sec/3600))
*	origy=real(long_deg+(long_min/60.)+(long_sec/3600))
C This is weird. why take float of a float?
*        dtor=float(3.1415926/180.)

	i = 0
	Write (95,*)'/drawplane {'
10	Read (50,*,END=20) temp 
 	If (temp.EQ.'SCAN') then
	 i = i+1
	 scan(i) = i
	 end = i
	 Do 11 j = 1,4
	  Read (50,*)
11	 Continue
	 Read (50,12) temp1,lat
	 Read (50,12) temp2,long
	 Read (50,12) temp3,alt
	 Read (50,*)
	 Read (50,12) temp4,head
12	 Format (A,F8.4)
*        Print*, 'SCAN(',i,'): ', scan(i)
*	 Print*
	 If (temp1.EQ.'Start_latitude:') then
*	  Print*, 'LAT: ', lat
	 else
         goto 20
	 endif
	 If (temp2.EQ.'Start_longitude:') then
*	  Print*, 'LONG: ', long 
	 else
          goto 20
	 endif
	 If (temp3.EQ.'Start_altitude_(km):') then
*	  Print*, 'ALT: ', alt  
	 else
          goto 20
	 endif
	 If (temp4.EQ.'Start_heading_(deg):') then
*	  Print*, 'ALT: ', head 
	 else
          goto 20
	 endif
*	 Print*
 	 origx=real(lat_deg+(lat_min/60.)+(lat_sec/3600.))
	 origy=real(long_deg+(long_min/60.)+(long_sec/3600.))
C This is illegal in f90:         dtor=float(3.1415926/180.)
         dtor = 3.1415926/180.
         if(mod(scan(i),plane_inc).EQ.0) then
                lat1 = lat - origx 
		long1 = long - origy 
C This code should be more general, km oer degree is function of lat
C should add that here. 
C Conversion factor for TOGA COARE
*		y = lat1 * 111.137
*		x = long1 * 110.8  
C Conversion factor for VORTEX 
		y = lat1 * 110.952
		x = long1 * 90.168  
*		x = (x - horiz_beg) 
*		y = (y - vert_beg)
*		x = (x - (id(160)*.01)) 
*		y = (y - (id(165)*.01))
        	dtheta = 90. - float(clockwise_deg)/64.
        	x1 = x*cos(dtheta*dtor) + y*sin(dtheta*dtor)
        	y1 = -x*sin(dtheta*dtor) + y*cos(dtheta*dtor)
		Write(51,*)'*****************************'
		Write(51,*)'origx: ',origx
		Write(51,*)'origy: ',origy
		Write(51,*)'lat: ',lat
		Write(51,*)'long: ',long
		Write(51,*)'lat1: ',lat1
		Write(51,*)'long1: ',long1
		Write(51,*)'dtor: ',dtor
		Write(51,*)'dtheta: ',dtheta
		Write(51,*)'x: ',x
		Write(51,*)'y: ',y
		Write(51,*)'x1: ',x1
		Write(51,*)'y1: ',y1
		angle = mod((450-head),360.0)-dtheta
		Write (95,30) x1,y1,angle
30		Format (F10.4,1X,F10.4,1X,F10.4,1X,'plotplane')
          endif
        endif
 	goto 10
	
20	Write (95,*) '} def'

	Close(50)
	
	Return
	End
