	Subroutine TextReadHRD(id,nid,panel)
C This is version of NCAR/ATD subroutine TextRead that was modified to
C read HRD wind file ( *.w, usually) and vertical cross-section formats.
C 17 May 2005 - fixed MAJOR bug (my fault) in calculating levels.
C p dodge HRD 
Cout	Implicit none

	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

        Integer nid,id(nid),imax,jmax,kmax,data_format,panel
	integer ierr_code
	character*4 keywd ! hrd data type,  from header
	write(6,*)' opening ',data_file
C HRD Files are UNformatted:
	Open (unit=96, file=data_file, status= 'old', err = 900,
     +		form = 'unformatted',
     +		iostat = ierr_code)
	go to 901
900	write(6,*)'kaboom. could not open input file. err = ',
     +		ierr_code
	stop
901	write(6,*)' opened input'

C Read the initial parameters
C ie, read the HRD wind file header:
	Call ReadHRDhdr(id,nid,imax,jmax,kmax,keywd,panel,
     +		sx, sy, sz, xz, yz, z0)
C now load the array for plotced:
	Call StoreDataHRD(id,nid,imax,jmax,kmax,keywd,
     +		sx, sy, sz, xz, yz, z0)
C
	Close(unit=96)

	Return
	End
**************************************************
	Subroutine ReadHRDhdr(id,nid,imax,jmax,kmax,keywd,panel,
     +		sx, sy, sz, xz, yz, z0)

Cout	Implicit none

	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

        Integer nid,id(nid),imax,jmax,kmax,Nmosm
	Integer yr,mon,day,hr,mn,sec,panel
	Real sx,sy,sz,Olat,Olong,z0,Su,Sv,Baddata
	character keywd*4,flight*8,storm*12,radarid*4,
     +		experiment*32,create_time*32,extra1*28,
     +		string*8

* Read array header & store in id
        Read (96)keywd,flight,storm,radarid,
     +		experiment,create_time,extra1,
     +		imax,jmax,kmax,
     +		nsweeps,nmosm,unfold,interven_attn,flag_dop,iextra2,
     +		iextra3, stime, etime, olat, olong,
     +          sx, sy, sz, xz, yz, z0,
     +		rot, ra, co1, co2, azmcor, elcor, thresh,
     +        powerT,pcor,dcor,rcor,extra5,extra6,extra7
C    Su,Sv,
C     $                Baddata,yr,mon,day,hr,mn,sec

	if( keywd .eq. 'XSEC') then ! data are stored by time...
		sx = 0.7 ! 6 sec = ~ 700 m?
		xz = 0.0
	end if
        id(162) = imax
	if( keywd .eq. 'TX2S' ) then ! two xsecs
		id(162) = 2 * imax + 1
		xz = 0.0
	else if( keywd .eq. 'TXAV' ) then ! r-z average of tail xsecs
		id(162) = imax + 1
		xz = 0.0
	end if
        id(167) = jmax
        id(172) = kmax
        id(163) = int(sx*1000)
        id(168) = int(sy*1000)
        id(173) = int(sz*1000)
        id(33) = int(Olat)
        id(34) = nint((Olat-id(33))*60)
        id(35) = 0
        id(36) = int(Olong)
        id(37) = nint((Olong-id(36))*60)
        id(38) = 0
        id(170) = z0*1000
C extract date and start time of field:
	read(flight(1:6),'(3i2)', err = 222)yr, mon, day
        id(116) = yr
        id(117) = mon
        id(118) = day
	go to 223
222		id(116) = 0
        	id(117) = 0
        	id(118) = 0
223	continue
	call ctme(stime, hr, mn, sec) ! hrd sub for seconds to hr, mn, sec
        id(119) = hr
        id(120) = mn
        id(121) = sec
        id(122) = yr
        id(123) = mon
        id(124) = day
	call ctme(etime, hr, mn, sec) ! hrd sub for seconds to hr, mn, sec
        id(125) = hr
        id(126) = mn
        id(127) = sec
C
C Mod to have lower left corner plot properly
C xz,yz give pos of storm from lower left, and we want storm to be at 0,0.
cout        id(160) = 0*100
        id(160) = -xz * 100
        id(161) = id(160) + (id(163)*.1*(id(162)-1))
Cout        id(165) = 0*100
        id(165) = -yz * 100
        id(166) = id(165) + (id(168)*.1*(id(167)-1))
        id(171) = id(170) + (id(173)*(id(172)-1))
C CALCULATE THE LEVEL
C added for Radius - Height mean:
        IF (fix_axis.EQ.'R'.OR.fix_axis.EQ.'r') THEN
		fix_beg = 0.0
		fix_inc = 0.0 ! so level = 1
	else IF (fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') THEN
	   fix_beg=id(170)*.001
           fix_inc=id(173)*.001
        ELSEIF (fix_axis.EQ.'Y'.OR.fix_axis.EQ.'y') THEN
           fix_beg=id(165)*.01
           fix_inc=id(168)*.001
        ELSEIF (fix_axis.EQ.'X'.OR.fix_axis.EQ.'x') THEN
           fix_beg=id(160)*.01
           fix_inc=id(163)*.001
        ENDIF
C This code used to be outside, in the main, but I need to know here, 
C so i can just read in one layer of wind file.
	IF (level_flag.EQ.'D'.OR.level_flag.EQ.'d') THEN
		level=nint(((plots(panel)-fix_beg)/fix_inc)+1)
		if( level .lt. 1) level = 1
		IF (fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') THEN
			if( level .gt. kmax) level = kmax
        	ELSEIF (fix_axis.EQ.'Y'.OR.fix_axis.EQ.'y') THEN
			if( level .gt. jmax) level = jmax
        	ELSEIF (fix_axis.EQ.'X'.OR.fix_axis.EQ.'x') THEN
			if( level .gt. imax) level = imax
        	ENDIF
	ENDIF
C Debug
Cout	write(6,*)' Debug in ReadHRDhdr'
Cout 	write(6,*)'Fix_axis: ', fix_axis
Cout	write(6,*)'Fix_beg, fix_inc: ', fix_beg, fix_inc
Cout	write(6,*)'panel, plots(panel): ',panel, plots(panel)
Cout	write(6,*)'Level: ',level
Cout	pause
C End debug
	Return
	End
**************************************************
**************************************************
**************************************************
	Subroutine Calc_Stats(imax,jmax,kmax)


	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer imax,jmax,kmax,i,j,k
	Integer begx1,endx1,begy1,endy1 
	Integer begx2,endx2,begy2,endy2 
	Integer u_num,v_num,w_num,div_num
	Real u_av,v_av,w_av,div_av
	Real u_std,v_std,w_std,div_std
	Real u_sum,v_sum,w_sum,div_sum

C Initialize values
	u_num=0
	v_num=0
	w_num=0
	div_num=0
	u_sum=0.0
	v_sum=0.0
	w_sum=0.0
	div_sum=0.0
    	u_av=0.0
    	v_av=0.0
    	w_av=0.0
    	div_av=0.0
    	u_std=0.0
    	v_std=0.0
    	w_std=0.0
    	div_std=0.0

	begx1=41
	endx1=61
	begy1=28
	endy1=41
	begx2=21
	endx2=48
	begy2=34
	endy2=48


	DO k=1,4
	  DO j=1,jmax
	    DO i=1,imax
	      IF (fld_data(i,j,k).GT.-100) THEN
  	       u_sum=u_sum+fld_data(i,j,k)       
	       u_num=u_num+1
	      ELSEIF (fld_data(i,j,k).GT.-100) THEN
  	       v_sum=v_sum+fld_data(i,j,k)       
	       v_num=v_num+1
	      ELSEIF (fld_data(i,j,k).GT.-100) THEN
  	       w_sum=w_sum+fld_data(i,j,k)       
	       w_num=w_num+1
	      ELSEIF (fld_data(i,j,k).GT.-100) THEN
  	       div_sum=div_sum+fld_data(i,j,k)       
	       div_num=div_num+1
	      ENDIF
	    ENDDO
	  ENDDO
	ENDDO

	Return
	End
**************************************************
C following reads HRD wind format files and loads into plotced's array
	Subroutine StoreDataHRD(id,nid,imax,jmax,kmax,keywd,
     +		sx, sy, sz, xz, yz, z0)

Cout	Implicit none

	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer nid, id(nid),imax,jmax,kmax,i,j,k,m,field
	integer inun
	character*4 keywd, reply*1
	Integer data_pos(4),data_format
Cout	Real temp_array(5,100,100,40)
C need big z index for Gamachian profiles 
	Real temp_array(5,200,200,160)
	parameter( mxdopts=200, bad_val = -900.0,
     +		maxvar = 5, missing = -9999, ibad_w = -9000)
	integer*2 indat(maxvar,mxdopts) ! for reading in dop3d or wind3d files
	integer*2 kpk(mxdopts) ! for reading in ta3d files
	logical convert_wdws, convert_vtvr, fill_void, shift_center
	logical storm_relative
C Arrays for cross-section files:
	real dbzbuf(168, 256), velbuf(168, 256), fallbuf(168, 256)
	real rabuf(168), gsbuf(168), vwsbuf(168), dbzground(168), 
     +		velground(168)
C Array for r-z means
	parameter(irmax = 200, izmax = 60, nvar = 5)
C store {u, v, w, dBZ} or {vtan, vrad, w, dBZ}
	real rz_av(2,nvar,0:irmax,0:izmax) 
C Array for movie files ( man i sure do have a lot of arrays
C running around here!)
	integer*2 iz(480,480)
C
	inun = 96
C
	convert_wdws = .false.
	convert_vtvr = .false.
C 
	storm_relative = .false.
	u_storm = 0.0
	v_storm = 0.0
	write(6,*)' Do you want storm-relative winds?'
	read(5,'(a1)') reply
	if( (reply.eq.'y') .or. (reply.eq.'Y') ) then
		write(6,*)' Enter storm u, v: (m/s)'
		read(5,*)u_storm, v_storm
		storm_relative = .true.
	end if
C 
	shift_center = .false.
	xc_shift = 0.0
	yc_shift = 0.0
	write(6,*)' Do you want to shift center?'
	read(5,'(a1)') reply
	if( (reply.eq.'y') .or. (reply.eq.'Y') ) then
		write(6,*)' Enter x and y shifts (km):'
		read(5,*)xc_shift, yc_shift
		shift_center = .true.
	end if
C
	if( (keywd .eq.'WIND') .or. (keywd.eq.'wind') ) then ! --------->>>>>>
C  ORDER OF HRD wind file  DATA
C  1 = wind direction x 10 (deg meteorological)
C  2 = wind speed x 10 m/s
C  3 = W vertical velocity cm/s
C  4 = dBZe (Reflectivity)
C  5 = Divergence

C Figure out the position in the data file and where to store it in
C the array. first two positions define the vector variables for
C plot x and y axes, last two define variables to contour...
     	  DO i=1,4	
	   if ( fld_name(1,i) .eq. "S" ) then
		data_pos(i) = 5 ! temp fix so can plot isotachs and barbs
	   ELSE IF (fld_name(1,i).EQ."U") THEN
    	     data_pos(i) = 1
	  	convert_wdws = .true.
    	   ELSEIF (fld_name(1,i).EQ."V") THEN
    	     data_pos(i) = 2
	  	convert_wdws = .true.
    	   ELSEIF (fld_name(1,i).EQ."T") THEN
    	     data_pos(i) = 1
	  	convert_wdws = .true.
		convert_vtvr = .true.
    	   ELSEIF (fld_name(1,i).EQ."R") THEN
    	     data_pos(i) = 2
	  	convert_wdws = .true.
		convert_vtvr = .true.
    	   ELSEIF (fld_name(1,i).EQ."W") THEN
    	     data_pos(i)=3
    	   ELSEIF (fld_name(1,i).EQ."Z") THEN
    	     data_pos(i)=4
    	   ELSEIF (fld_name(1,i).EQ."D") THEN
    	     data_pos(i)=5
	   else
		data_pos(i) = -1
    	   ENDIF
    	  ENDDO
C Read the array
	  DO k=1,kmax  ! >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	    do j=1, jmax
		read(inun)((indat(nv,ii),
     +			nv = 1,5), ii =1,imax)
		if( convert_vtvr ) then ! need relative position
			y = j * sy - yz
			if( shift_center ) y = y + yc_shift
		end if
		do i=1,imax
		  wd = indat(1,i) * 0.1
		  ws = indat(2,i) * 0.1
		  if( convert_wdws) then ! need u, v
			call wdir2uv(wd,ws,u,v,bad_val,ier)
			if( u .gt. bad_val )then ! ->->->->->->->->->->->
			if ( storm_relative ) then
				u = u - u_storm
				v = v - v_storm
			end if
			if( convert_vtvr ) then
			    x = i * sx - xz
			    if( shift_center ) x = x + xc_shift
			    if((x.eq.y) .and. (x*y.eq.0.0))then
				vtan = 0
				vrad = 0
			    else
				ang = atan2(y,x)
				vtan = -u*sin(ang) + v*cos(ang)
				vrad = u*cos(ang) + v*sin(ang)
			    end if
			  temp_array(1,i,j,k) = vtan
			  temp_array(2,i,j,k) = vrad
			else
			  temp_array(1,i,j,k) = u
			  temp_array(2,i,j,k) = v
			end if
			else ! <-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-
			  temp_array(1,i,j,k) = bad_val
			  temp_array(2,i,j,k) = bad_val
			end if ! <-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-
		  else
			  temp_array(1,i,j,k) = wd
			  temp_array(2,i,j,k) = ws
		  end if
		  if( indat(3,i) .gt. ibad_w)then
			  w = indat(3,i) * 0.01 !cm/s to m/s
		  else
			w = bad_val
		  end if
		  dBZ = indat(4,i) * 0.1
		  div = indat(5,i) 
		  temp_array(3,i,j,k) = w
		  temp_array(4,i,j,k) = dBZ
		  temp_array(5,i,j,k) = ws ! should be div
		end do
	     end do
	  end do ! <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
C Store the array in fld_data
	  IF (fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') THEN
		k = level
C horizontal slices
	        DO field=1,4
	          IF (data_pos(field) .gt. 0 ) THEN
	            DO j=1,jmax
	              DO i=1,imax
	                fld_data(i,j,field) = 
     +				temp_array(data_pos(field),i,j,k)
	              ENDDO
	            ENDDO
	          ENDIF
	        ENDDO
	  ELSEIF (fix_axis.EQ.'Y'.OR.fix_axis.EQ.'y') THEN
C xz cross sections
               DO field=1,4
                 IF (data_pos(field) .gt. 0) THEN
		  do k = 1, kmax
		   DO i=1,imax
		      fld_data(i,k,field) =
     +			temp_array(data_pos(field),i, level, k)
		   ENDDO
		  end do
	         ENDIF
               ENDDO
	  ELSEIF (fix_axis.EQ.'X'.OR.fix_axis.EQ.'x') THEN
C yz cross sections
               DO field=1,4
                 IF (data_pos(field) .gt. 0) THEN
		   do k = 1, kmax
		    DO j = 1, jmax
		       fld_data(j,k,field) = 
     +			temp_array(data_pos(field), level,j,k)
		    ENDDO
		   end do
	         ENDIF
               ENDDO
	  else if( fix_axis.EQ.'R'.OR.fix_axis.EQ.'r' ) then
C rz cross sections...more work!
	  	iDBZ = 4
C get rad_max, rad_min from data file constants
		call get_rmin(imax, jmax, xz, yz, sx, sy, 
     +			rad_max, rad_min)
		dr = sqrt( sx*sx + sy*sy)
		write(6,*)'min, max radial distances: ',rad_min, rad_max
		write(6,*)' diagonal del r: ',dr,' km'
		write(6,*)' Do you want to change these?'
		read(5,'(a1)') reply
		if( (reply.eq.'y') .or. (reply.eq.'Y') ) then
			write(6,*)' Enter dr, rad min and max'
			read(5,*)dr, rad_min, rad_max
		end if
		arc_min_frac = 0.5
		write(6,*)' arc min fraction: ',arc_min_frac
		write(6,*)' Do you want to change it?'
		read(5,'(a1)') reply
		if( (reply.eq.'y') .or. (reply.eq.'Y') ) then
			write(6,*)' enter fraction (0 to 1)'
			read(5,*)arc_min_frac
		end if
		call rz_average(temp_array, nvar, 100, 100,
     +	  		imax, jmax, kmax, sx, sy, xz, yz, 
     +	  		shift_center, xc_shift, yc_shift,
     +	  		rad_max, rad_min, dr,
     +	  		iDBZ, rz_av, irmax, bad_val, arc_min_frac)
		nrbins = (rad_max - rad_min) / dr
	write(6,*)' nrbins: ', nrbins
                DO field=1,4
                 IF (data_pos(field) .gt. 0) THEN
		   do k = 1, kmax
		    DO i = 1, nrbins
		       fld_data(i,k,field) = 
     +			rz_av(1, data_pos(field), i, k)
		    ENDDO
		   end do
	         ENDIF
		ENDDO
C We need to reset stuff so plot will work!
		fix_axis = 'Y' ! so like x-z plot
		id(163) = dr * 1000 ! km to m
		id(162) = nrbins
		id(161) = rad_max * 100
		id(160) = rad_min * 100
	  end if
C
C
C
C
	else if( (keywd .eq.'XSEC') .or. (keywd.eq.'xsec') ) then ! --------->>>>>>
	   fill_void = .true.
	   sy = id(168) * 0.001 ! y inc in km
	   write(6,*)' reading vertical incidence data'
	   iground = 0
c	   call rxsec( dbzbuf, velbuf, fallbuf, rabuf, gsbuf, vwsbuf,
c     +		dbzground, velground, iground, imax, jmax, inun, ierr)
	   write(6,*)' finished reading vertical incidence data'
	   write(6,*)' rxsec ierr: ',ierr
	av_gs = 0.0
	n_av = 0
	do ii = 1,imax
		if(gsbuf(ii) .gt. 0.0) then
			n_av = n_av +1
			av_gs = av_gs + gsbuf(ii)
		end if
	end do
	if(n_av .gt. 0) then
		av_gs = av_gs/n_av
		id(163) = av_gs * 6.0 ! assuming 10 rpm for tail
		write(6,*)' set sx = id(163) = ',id(163)
	else
		write(6,*)'gsbuf all bad. using default sx'
	end if
	   if( fill_void ) then ! interp dopp vels near a/c
		write(6,*)' filling data near a/c'
		call fill_plane(velbuf, fallbuf, vwsbuf,
     +			rabuf, sy, imax, jmax)
		bad_flag = -999.0
		call fill_dbz(dbzbuf, rabuf, sy, imax, jmax, bad_flag)
	   else ! we need to convert velbuf to w, which is done 
C in fill_plane!
	     do j =1 , jmax
		do i = 1, imax
		if( (velbuf(i,j) .gt. -9000) .and.
     +				(fallbuf(i,j) .gt. -9990) )then
		  velbuf(i,j) = velbuf(i,j) - fallbuf(i,j)
		else
		  velbuf(i,j) = -9990.0
		end if
	       end do
	     end do
	   end if
    	   IF (fld_name(1,3).EQ."W") THEN
C debug
		WRITE(6,*)' field 3 is w'
    	     data_pos(3) = 3
	     data_pos(4) = 4
    	   ELSEIF (fld_name(1,3).EQ."Z") THEN
C debug
		WRITE(6,*)' field 3 is Z'
    	     data_pos(3) = 4
	     data_pos(4) = 3
	   end if
C Load fld_data: ( no data for first two vector fields....)
	  do j =1 , jmax
		do i = 1, imax
			fld_data(i,j,1) = dbzbuf(i,j)
			fld_data(i,j,2) = velbuf(i,j)
			fld_data(i,j,data_pos(3)) = velbuf(i,j)
			fld_data(i,j,data_pos(4)) = dbzbuf(i,j)
		end do
	  end do
C
	else if( (keywd .eq.'TX2S') .or. (keywd.eq.'tx2s') ) then ! --------->>>>>>
	   write(6,*)' reading 2 slice file'
    	   IF (fld_name(1,3).EQ."W") THEN
C debug
		WRITE(6,*)' field 3 is w'
    	     data_pos(3) = 3
	     data_pos(4) = 4
    	   ELSEIF (fld_name(1,3).EQ."Z") THEN
C debug
		WRITE(6,*)' field 3 is Z'
    	     data_pos(3) = 4
	     data_pos(4) = 3
	   end if
C Load fld_data: ( no data for first two vector fields....)
	   do j = 1, jmax
		do ir = -imax, imax, 1
		   read(inun) w, dBZ
		   i = imax + ir + 1
		   fld_data(i,j,1) = dBZ
		   fld_data(i,j,2) = w
		   fld_data(i,j,data_pos(3)) = w
		   fld_data(i,j,data_pos(4)) = dBZ
		end do
	   end do
C
	else if( (keywd .eq.'TXAV') .or. (keywd.eq.'txav') ) then ! --------->>>>>>
	   write(6,*)' reading xsec average file'
    	   IF (fld_name(1,3).EQ."W") THEN
C debug
		WRITE(6,*)' field 3 is w'
    	     data_pos(3) = 3
	     data_pos(4) = 4
    	   ELSEIF (fld_name(1,3).EQ."Z") THEN
C debug
		WRITE(6,*)' field 3 is Z'
    	     data_pos(3) = 4
	     data_pos(4) = 3
	   end if
C Load fld_data: ( no data for first two vector fields....)
	   do j = 1, jmax
		do ir = 0, imax, 1
		   read(inun) w, dBZ
		   i = ir + 1
		   fld_data(i,j,1) = dBZ
		   fld_data(i,j,2) = w
		   fld_data(i,j,data_pos(3)) = w
		   fld_data(i,j,data_pos(4)) = dBZ
		end do
	   end do
C
	else if( (keywd .eq.'MOVI') .or. (keywd.eq.'movi') ) then ! --------->>>>>>
	   write(6,*)' reading movie frame file'
c	   call unpack_movie_file(inun, iz, 480, imax, jmax,
c     +			 nt_rec, ier)
	zmin = 1000.0
	zmax = -zmin
C movie files may be bigger than 256 x 256, if so, center 256 x 256 window
C and modify id array...
	   if( jmax .gt. 256 ) then
		jb = (jmax - 256) / 2
		jt = jb + 255
		id(167) = 256
		id(166) = id(165) + (id(168)*.1*(id(167)-1))
	   else
		jb = 1
		jt = jmax
	   end if
	   if( imax .gt. 256 ) then
		il = (imax - 256) / 2
		ir = il + 255
		id(162) = 256
	        id(161) = id(160) + (id(163)*.1*(id(162)-1))
	   else
		il = 1
		ir = imax
	   end if
C Note i am assuming dBZ data, stored *4
	write(6,*)' jb, jt, il, ir ',jb, jt, il, ir
	   do j = jb, jt
		jptr = j -jb + 1
		do i = il, ir
		   iptr = i - il + 1
		   if( iz(i,j) .ne. -1 ) then
			dBZ = iz(i,j) * 0.25
			if( dBZ .gt. zmax)zmax = dBZ
			if( dBZ .lt. zmin)zmin = dBZ
			do k = 1, 4
			  fld_data(iptr,jptr,k) = dBZ
			end do
		   else
			do k = 1, 4
			  fld_data(iptr,jptr,k) = bad_val
			end do
		   end if
		end do
	   end do
	write(6,*)' movie file dbz min, max: ',zmin, zmax
C ---- TA3D files:
	else if( (keywd .eq.'TA3D') .or. (keywd.eq.'ta3d') ) then ! --------->>>>>>
	   write(6,*)' reading TA3D file'
	   ipk = imax* 0.5
	   zmax = bad_val
	   zmin = -zmax
	   do k =1, kmax
		do j=1,jmax
			read(inun)(kpk(ii), ii = 1, ipk)
			do i = 1,imax
c			 call unpakdbz2d(i,1,kpk,imax,1,dbz)
			if( dBZ .gt. zmax)zmax = dBZ
			if( dBZ .lt. zmin)zmin = dBZ
			 do k4 = 1, 5
			   temp_array(k4,i,j,k) = dbz
			 end do
			end do
		end do
	   end do
	  IF (fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') THEN
	write(6,*)' Z at level: ',level
		do j = 1, jmax
		  do i = 1, imax
			do k4 = 1, 4
			  fld_data(i,j,k4) = temp_array(1,i,j,level)
			end do
		   end do
		end do
	  ELSE IF (fix_axis.EQ.'Y'.OR.fix_axis.EQ.'y') THEN
		do k = 1, kmax
		  do i = 1, imax
			do k4 = 1, 4
			  fld_data(i,k,k4) = temp_array(1,i,level,k)
			end do
		   end do
		end do
	  ELSE IF (fix_axis.EQ.'X'.OR.fix_axis.EQ.'x') THEN
		do k = 1, kmax
		  do j = 1, jmax
			do k4 = 1, 4
			  fld_data(j,k,k4) = temp_array(1,level,j,k)
			end do
		   end do
		end do
	  else if( fix_axis.EQ.'R'.OR.fix_axis.EQ.'r' ) then
C rz cross sections...more work!
	  	iDBZ = 4
C get rad_max, rad_min from data file constants
		call get_rmin(imax, jmax, xz, yz, sx, sy, 
     +			rad_max, rad_min)
		dr = sqrt( sx*sx + sy*sy)
		write(6,*)'min, max radial distances: ',rad_min, rad_max
		write(6,*)' diagonal del r: ',dr,' km'
		write(6,*)' Do you want to change these?'
		read(5,'(a1)') reply
		if( (reply.eq.'y') .or. (reply.eq.'Y') ) then
			write(6,*)' Enter dr, rad min and max'
			read(5,*)dr, rad_min, rad_max
		end if
		arc_min_frac = 0.5
		write(6,*)' arc min fraction: ',arc_min_frac
		write(6,*)' Do you want to change it?'
		read(5,'(a1)') reply
		if( (reply.eq.'y') .or. (reply.eq.'Y') ) then
			write(6,*)' enter fraction (0 to 1)'
			read(5,*)arc_min_frac
		end if
		call rz_average(temp_array, nvar, 100, 100,
     +	  		imax, jmax, kmax, sx, sy, xz, yz, 
     +	  		shift_center, xc_shift, yc_shift,
     +	  		rad_max, rad_min, dr,
     +	  		iDBZ, rz_av, irmax, bad_val, arc_min_frac)
		nrbins = (rad_max - rad_min) / dr
	        write(6,*)' nrbins: ', nrbins
		do k = 1, kmax
		   do i = 1, nrbins
                      do k4 = 1, 4
			fld_data(i,k,k4) = rz_av(1, iDBZ, i, k)
		      end do
		   end do
		end do
C We need to reset stuff so plot will work!
		fix_axis = 'Y' ! so like x-z plot
		id(163) = dr * 1000 ! km to m
		id(162) = nrbins
		id(161) = rad_max * 100
		id(160) = rad_min * 100
	  END IF
	  write(6,*)'dbz min, max: ',zmin, zmax
C CMP files
	else if( (keywd .eq.'CMP ') .or. (keywd.eq.'cmp ') ) then ! --------->>>>>>
	   write(6,*)' reading TA3D file'
	   ipk = imax* 0.5
	   zmax = bad_val
	   zmin = -zmax
C note that cmp files have 1,1 in upper left corner. To switch to right handed
C coords, i read as if first line was j = jmax, etc.
	   do j = jmax, 1, -1
		read(inun)(kpk(ii), ii = 1, ipk)
		do i = 1,imax
c			 call unpakdbz2d(i,1,kpk,imax,1,dbz)
			if( dBZ .gt. zmax)zmax = dBZ
			if( dBZ .lt. zmin)zmin = dBZ
			 do k4 = 1, 4
			  fld_data(i,j,k4) = dbz
			 end do
		end do
	   end do
	end if ! <<<<<<<<<<<<<<<< -------------------------------------------

	Return
	End
C -------------------- HRD routine:
      subroutine wdir2uv(wd,ws,u,v,bad,ier)
C given speed and direction in degrees meteorological ( direction 
C from which wind is blowing ), return u, v  in same units as speed.
	real wd, ws, u, v, bad
	integer ier
      parameter(deg2rad=0.0174533)
	ier = 0
      if( (wd.lt.0.0) .or. (wd .gt. 360.0) )then 
	ier = -1
        u=bad 
        v=bad 
      else
        ang = -(90.0+wd)*deg2rad ! conversion to math angle 
        u = ws * cos(ang) 
        v = ws * sin(ang) 
      end if
      return  
      end 
C 
      subroutine uv2wd(u,v,wdir,wspeed,bad) 
C given u,v return speed in same units direction in degrees, met sense. 
C (90 deg means wind blowing FROM 90 deg, etc...) 
	real u, v, wdir, wspeed, bad
      parameter(rad2deg=57.2957795) 
      if(u.gt.bad)then
              ang=atan2(v,u)
              wdir=amod(360.0-(90.0+ang*rad2deg),360.)
              wspeed=sqrt(u*u+v*v)
      else
              wdir=bad
              wspeed=bad
      end if
      return
      end 
C ------
	subroutine fill_plane(velbuf, fallbuf, vwsbuf, 
     +		rabuf, syt, idim, jdim)
C mod from code supplied by N. Griffin, 5 oct 1993.
	real velbuf(168, 256), rabuf(168)
	real fallbuf(168, 256)
	real vwsbuf(168)
C
	do i = 1, idim
	   if( rabuf(i) .le. -999.0) then
Cout		print*,'Yipes! i, rabuf(i)',i,rabuf(i)
		go to 100
	   end if
	   ipk = nint(rabuf(i) / (syt*1000.) ) ! bin for a/c
	   vws = vwsbuf(i)
	   do j = 1, jdim
		if( (velbuf(i,j) .gt. -9000) .and.
     +				(fallbuf(i,j) .gt. -9990) )then
		  velbuf(i,j) = velbuf(i,j) - fallbuf(i,j)
		  fallbuf(i,j) = 0.0
		else
		  fallbuf(i,j) = 0.0
		end if
	   end do
C Find # pts missing above plane:
d	print *,'filling from bin # ',ipk,'rabuf(ipk):',rabuf(ipk)
	   in_top = ipk
	   topdop = -9000.
	   do while( (ifix(topdop) .eq. -9000) .and. (in_top .ne. jdim))
		in_top =in_top + 1
		topdop = velbuf(i, in_top)
	   end do
C Fill:
	   if( topdop .gt. -9000. )then
		npts = in_top - ipk
		if( npts .gt. 1) then
			ratevws = (vws-topdop) / (float(npts))
			do ii = 1, npts -1
				vwsint = ii*ratevws + topdop
				velbuf(i,in_top -ii) = vwsint
			end do
		end if
	  end if
C
	   in_down = ipk
	   downdop = -9000.
C Find # pts missing below plane:
	   do while( (ifix(downdop) .eq. -9000) .and. (in_down .ne.1) )
		in_down =in_down - 1
		downdop = velbuf(i, in_down)
	   end do
C Fill:
	   if( downdop .gt. -9000. )then
		npts = ipk - in_down 
		if( npts .gt. 1) then
			ratevws = (downdop-vws) / (float(npts))
			do ii = 1, npts -1
				vwsint = ii*ratevws + vws
				velbuf(i,ipk -ii) = vwsint
			end do
		end if
	  end if
C If whole ray was caca, don't put anything at a/c bin
	  if( topdop .le. -9000.0 .and. downdop .le. -9000.0)then
		velbuf( i, ipk) = -9990.0
	  else
C Put aircraft measured vert wind speed in aircraft bin
		   velbuf(i,ipk) = vws
	  end if
100	end do
C The following ensures that any missing values or no data values
C are set to the same no data flag.
	do j = 1, jdim
		do i = 1, idim
			if(velbuf(i,j) .le. -9000.0) then
				velbuf(i,j) = -9990.0
			end if
		end do
	end do
	return
	end
	subroutine fill_dbz(dbzbuf, rabuf, syt, idim, jdim, bad_flag)
C mod from code supplied by N. Griffin, 5 oct 1993
C fill dBZ gap around plane
	real dbzbuf(168, 256), rabuf(168)
C
	do i = 1, idim
	   if( rabuf(i) .le. -999.0) go to 100
	   ipk = nint(rabuf(i) / (syt*1000.) ) ! bin for a/c
C Find top of gap above plane:
	   in_top = ipk
	   topdbz = bad_flag
	   do while( (topdbz .le. bad_flag) .and. (in_top .ne. jdim))
		in_top =in_top + 1
		topdbz = dbzbuf(i, in_top)
	   end do
C Find bottom of gap below plane:
	   in_down = ipk
	   downdbz = bad_flag
	   do while( (downdbz .le. bad_flag) .and. (in_down .ne.1) )
		in_down =in_down - 1
		downdbz = dbzbuf(i, in_down)
	   end do
C Fill:
	if( (topdbz .gt. bad_flag) .and. ( downdbz .gt. bad_flag))then
		npts = in_top - in_down
		if( npts .gt. 1) then
			ztop = 10.0**(topdbz*0.1)
			zbot = 10.0**(downdbz*0.1)
			rate = (ztop - zbot) / npts
			do ii = 1, npts-1
				z_int =  zbot + ii*rate
				dbzbuf(i,in_down + ii) = 
     +					10.0 * (log10(z_int))
			end do
		end if
	end if
100	end do
C The following ensures that any missing values or no data values
C are set to the same no data flag.
	do j = 1, jdim
		do i = 1, idim
			if(dbzbuf(i,j) .le. -800.0) then
				dbzbuf(i,j) = bad_flag
			end if
		end do
	end do
	return
	end
        subroutine ctme(stime,ih,im,is)
        isecs=stime
        ih=isecs/3600
        isecs=isecs-ih*3600
        im=isecs/60
        is=isecs-im*60
        return
        end

