@echo off

REM
REM Copyright 2003 Sun Microsystems, Inc. All rights reserved.
REM SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
REM

REM
REM @(#)build.bat	1.1 03/10/17
REM

rem Should have the following variables set:
rem
rem  set JAVA_HOME=<path to J2SDK installation root>
rem  set TOMCAT_HOME=<path to jwsdp-1.2 installation root> 

set PATH=%TOMCAT_HOME%/bin;%TOMCAT_HOME%/jaxrpc/bin;%JAVA_HOME%/bin;%PATH%

rem check variables correctness
if ""%TOMCAT_HOME%""=="""" goto no_tomcat
if not exist %TOMCAT_HOME%\jaxrpc\bin\wscompile.bat goto no_tomcat2
if ""%JAVA_HOME%""=="""" goto no_java
if not exist %JAVA_HOME%/bin/javac.exe goto no_java2

mkdir WEB-INF
mkdir WEB-INF\classes
echo running javac.exe
javac.exe -d WEB-INF\classes -classpath %TOMCAT_HOME%\jaxrpc\lib\jaxrpc-api.jar;%TOMCAT_HOME%\common\lib\servlet-api.jar src\serverscript\Implementation.java src\serverscript\Interface.java 
if NOT %ERRORLEVEL%==0 goto error

mkdir tmp_src 
echo running wscompile.bat
call wscompile.bat -gen:server -d WEB-INF\classes -keep -model WEB-INF\model.gz  -s tmp_src -f:wsi -f:documentliteral -classpath WEB-INF\classes src\config.xml
if NOT %ERRORLEVEL%==0 goto error

copy src\web.xml WEB-INF
copy src\jaxrpc-ri.xml WEB-INF
echo running jar.exe
jar.exe -cf serverscript.jar WEB-INF
echo running wsdeploy.bat
call wsdeploy.bat serverscript.jar -o serverscript.war

goto exit

:no_tomcat
 echo TOMCAT_HOME variable is not set
:no_tomcat2
 echo TOMCAT_HOME should point to JWSDP-1.2 installation
 echo You can download it from:
 echo http://java.sun.com/webservices/downloads/webservicespack.html
 goto error

:no_java
 echo JAVA_HOME variable is not set
:no_java2
 echo JAVA_HOME should point to J2SDK installation
:error
:exit
 pause
