/*
 * Decompiled with CFR 0.152.
 */
package example.wormgame;

import example.wormgame.Worm;
import example.wormgame.WormException;
import example.wormgame.WormFood;
import example.wormgame.WormScore;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.ToneControl;

public class WormPit
extends Canvas
implements Runnable {
    private WormFood myFood;
    private Worm myWorm;
    private boolean gameOver = false;
    private boolean gamePaused = false;
    private boolean gameRestart = false;
    private boolean forceRedraw = true;
    private boolean gameDestroyed = false;
    private int score = 0;
    private int level = 5;
    private int foodEaten = 0;
    private int width = this.round(this.getWidth());
    private int height = this.round(this.getHeight() - SCORE_HEIGHT);
    private Player audioPlayer;
    private Player tonePlayer;
    static int CellWidth;
    static int CellHeight;
    private static final int START_POS = 3;
    private static final int SCORE_CHAR_HEIGHT;
    private static final int SCORE_CHAR_WIDTH;
    private static final int SCORE_HEIGHT;
    private static final int DEFAULT_WAIT = 400;
    static final byte MAX_LEVELS = 10;
    static final int FOOD_COLOUR = 65280;
    static final int TEXT_COLOUR = 0xFF0000;
    static final int ERASE_COLOUR = 0xFFFFFF;
    static final int DRAW_COLOUR = 0;
    public static final int CELL_SIZE = 5;

    public WormPit() {
        CellWidth = (this.width - 6) / 5;
        CellHeight = (this.height - 6) / 5;
        this.myWorm = new Worm(this);
        this.myFood = new WormFood(this);
        int n = this.myFood.getX();
        int n2 = this.myFood.getY();
        while (this.myWorm.contains(n, n2)) {
            this.myFood.regenerate();
            n = this.myFood.getX();
            n2 = this.myFood.getY();
        }
    }

    private int round(int n) {
        int n2 = (n - 6) % 5;
        return n - n2;
    }

    public void setLevel(int n) {
        if (this.level != n) {
            this.level = n;
            this.gameOver = true;
            this.gamePaused = false;
            this.foodEaten = 0;
            this.score = 0;
        }
    }

    public int getLevel() {
        return this.level;
    }

    public int getScore() {
        return this.score;
    }

    static boolean isInBounds(int n, int n2) {
        if (n < 0 || n >= CellWidth) {
            return false;
        }
        return n2 >= 0 && n2 < CellHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restart() {
        if (this.gamePaused) {
            this.gamePaused = false;
        } else {
            this.myWorm.regenerate();
            this.myFood.regenerate();
            int n = this.myFood.getX();
            int n2 = this.myFood.getY();
            while (this.myWorm.contains(n, n2)) {
                this.myFood.regenerate();
                n = this.myFood.getX();
                n2 = this.myFood.getY();
            }
            this.foodEaten = 0;
            this.score = 0;
            this.gameOver = false;
            if (this.audioPlayer != null && this.audioPlayer.getState() == 300) {
                try {
                    this.audioPlayer.setMediaTime(0L);
                    this.audioPlayer.start();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
            }
        }
        this.forceRedraw = true;
        Worm worm = this.myWorm;
        synchronized (worm) {
            this.myWorm.notifyAll();
        }
    }

    public void keyPressed(int n) {
        block0 : switch (this.getGameAction(n)) {
            case 1: {
                this.myWorm.setDirection((byte)8);
                break;
            }
            case 6: {
                this.myWorm.setDirection((byte)2);
                break;
            }
            case 2: {
                this.myWorm.setDirection((byte)4);
                break;
            }
            case 5: {
                this.myWorm.setDirection((byte)6);
                break;
            }
            case 0: {
                switch (n) {
                    case 50: {
                        this.myWorm.setDirection((byte)8);
                        break block0;
                    }
                    case 56: {
                        this.myWorm.setDirection((byte)2);
                        break block0;
                    }
                    case 52: {
                        this.myWorm.setDirection((byte)4);
                        break block0;
                    }
                    case 54: {
                        this.myWorm.setDirection((byte)6);
                    }
                }
            }
        }
    }

    private void paintPitContents(Graphics graphics) {
        try {
            this.myWorm.update(graphics);
            if (this.myFood.isAt(this.myWorm.getX(), this.myWorm.getY())) {
                this.myWorm.eat();
                this.score += this.level;
                ++this.foodEaten;
                if (this.foodEaten > this.level << 1) {
                    this.forceRedraw = true;
                    this.foodEaten = 0;
                    ++this.level;
                    if (this.level == 10) {
                        --this.level;
                        this.gameOver = true;
                    }
                    if (this.tonePlayer != null) {
                        try {
                            this.tonePlayer.setMediaTime(0L);
                            this.tonePlayer.start();
                        }
                        catch (MediaException mediaException) {}
                    }
                } else if (this.audioPlayer != null) {
                    try {
                        Manager.playTone((int)69, (int)50, (int)100);
                    }
                    catch (MediaException mediaException) {
                        // empty catch block
                    }
                }
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(this.width - SCORE_CHAR_WIDTH * 3 - 3, this.height - 3, SCORE_CHAR_WIDTH * 3, SCORE_CHAR_HEIGHT);
                graphics.setColor(0);
                graphics.drawString("" + this.score, this.width - SCORE_CHAR_WIDTH * 3 - 3, this.height - 3, 0x10 | 4);
                this.myFood.regenerate();
                int n = this.myFood.getX();
                int n2 = this.myFood.getY();
                while (this.myWorm.contains(n, n2)) {
                    this.myFood.regenerate();
                    n = this.myFood.getX();
                    n2 = this.myFood.getY();
                }
            }
            this.myFood.paint(graphics);
        }
        catch (WormException wormException) {
            this.gameOver = true;
        }
    }

    public void paint(Graphics graphics) {
        if (this.forceRedraw) {
            this.forceRedraw = false;
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(0);
            graphics.drawRect(1, 1, this.width - 3, this.height - 3);
            graphics.drawString("L: " + this.level, 3, this.height, 0x10 | 4);
            graphics.drawString("" + this.score, this.width - SCORE_CHAR_WIDTH * 3, this.height, 0x10 | 4);
            graphics.drawString("S: ", this.width - SCORE_CHAR_WIDTH * 4, this.height, 0x10 | 8);
            graphics.drawString("" + this.score, this.width - SCORE_CHAR_WIDTH * 3, this.height, 0x10 | 4);
            graphics.drawString("H: ", this.width - SCORE_CHAR_WIDTH * 4, this.height + SCORE_CHAR_HEIGHT, 0x10 | 8);
            graphics.drawString("" + WormScore.getHighScore(this.level), this.width - SCORE_CHAR_WIDTH * 3, this.height + SCORE_CHAR_HEIGHT, 0x10 | 4);
            graphics.translate(3, 3);
            graphics.setClip(0, 0, CellWidth * 5, CellHeight * 5);
            this.myWorm.paint(graphics);
            this.myFood.paint(graphics);
        } else {
            graphics.translate(3, 3);
        }
        if (this.gamePaused) {
            Font font = graphics.getFont();
            int n = font.getHeight();
            int n2 = font.stringWidth("Paused");
            graphics.setColor(0xFFFFFF);
            graphics.fillRect((this.width - n2) / 2 - 1, (this.height - n) / 2, n2 + 2, n);
            graphics.setColor(0xFF0000);
            graphics.setFont(font);
            graphics.drawString("Paused", (this.width - n2) / 2, (this.height - n) / 2, 0x10 | 4);
        } else if (this.gameOver) {
            Font font = graphics.getFont();
            int n = font.getHeight();
            int n3 = font.stringWidth("Game Over");
            graphics.setColor(0xFFFFFF);
            graphics.fillRect((this.width - n3) / 2 - 1, (this.height - n) / 2, n3 + 2, n);
            graphics.setColor(0xFF0000);
            graphics.setFont(font);
            graphics.drawString("Game Over", (this.width - n3) / 2, (this.height - n) / 2, 0x10 | 4);
        } else {
            this.paintPitContents(graphics);
        }
        graphics.translate(-3, -3);
    }

    protected void hideNotify() {
        super.hideNotify();
        this.forceRedraw = true;
        if (!this.gameOver) {
            this.gamePaused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.gameDestroyed) {
            try {
                Worm worm = this.myWorm;
                synchronized (worm) {
                    if (this.gameOver) {
                        if (WormScore.getHighScore(this.level) < this.score) {
                            WormScore.setHighScore(this.level, this.score, "me");
                        }
                        if (this.audioPlayer != null && this.audioPlayer.getState() == 400) {
                            try {
                                this.audioPlayer.stop();
                                Manager.playTone((int)60, (int)400, (int)100);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        this.repaint();
                        this.myWorm.wait();
                    } else if (this.gamePaused) {
                        this.repaint();
                        this.myWorm.wait();
                    } else {
                        this.myWorm.moveOnUpdate();
                        this.repaint();
                        this.myWorm.wait(400 - this.level * 40);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyGame() {
        Worm worm = this.myWorm;
        synchronized (worm) {
            this.gameDestroyed = true;
            this.myWorm.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyAudioPlayer() {
        Worm worm = this.myWorm;
        synchronized (worm) {
            if (this.audioPlayer != null) {
                this.audioPlayer.close();
                this.audioPlayer = null;
            }
            if (this.tonePlayer != null) {
                this.tonePlayer.close();
                this.tonePlayer = null;
            }
            this.myWorm.notifyAll();
        }
    }

    public void createAudioPlayer() {
        byte[] byArray = new byte[]{-2, 1, -8, 40, 76, 8, 81, 24, 76, 8, 88, 24, 81, 8, 85, 16, 83, 8, 85, 8, 81, 16, 76, 16, 81, 16, 90, 16, 88, 16, 85, 8, 86, 8, 88, 48, -1, 8, 76, 8, 81, 16, 90, 16, 88, 16, 85, 8, 86, 8, 88, 16, 83, 8, 85, 8, 81, 16, 76, 16, 81, 16, 85, 8, 86, 8, 83, 24, 81, 8, 81, 32};
        byte[] byArray2 = new byte[]{-2, 1, 64, 4, 65, 4, 66, 4};
        if (this.audioPlayer != null) {
            this.audioPlayer.close();
            this.audioPlayer = null;
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.tonePlayer = Manager.createPlayer((String)"device://tone");
            this.tonePlayer.realize();
            ToneControl toneControl = (ToneControl)this.tonePlayer.getControl("ToneControl");
            toneControl.setSequence(byArray2);
            this.audioPlayer = Manager.createPlayer((String)"device://tone");
            this.audioPlayer.setLoopCount(-1);
            this.audioPlayer.realize();
            toneControl = (ToneControl)this.audioPlayer.getControl("ToneControl");
            toneControl.setSequence(byArray);
            this.audioPlayer.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        Font font = Font.getDefaultFont();
        SCORE_CHAR_WIDTH = font.charWidth('S');
        SCORE_CHAR_HEIGHT = font.getHeight();
        SCORE_HEIGHT = SCORE_CHAR_HEIGHT * 2;
    }
}

