/*
 * Decompiled with CFR 0.152.
 */
package example.pushpuzzle;

import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

class Score {
    private int levelId = 0;
    private byte[] levelRec = new byte[9];
    private static final int LEVEL_LEN = 9;
    private static final byte LEVEL_TAG = 1;
    private int scoreId;
    private byte[] scoreRec;
    private static final int SCORE_LEN = 13;
    private static final byte SCORE_TAG = 2;
    private RecordStore store = null;

    Score() {
        this.levelRec[0] = 1;
        this.putInt(this.levelRec, 1, 0);
        this.putInt(this.levelRec, 5, 0);
        this.scoreId = 0;
        this.scoreRec = new byte[13];
        this.scoreRec[0] = 2;
        this.putInt(this.scoreRec, 1, 0);
    }

    boolean open() {
        try {
            this.store = RecordStore.openRecordStore((String)"PushPuzzleScores", (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        if (this.store == null) {
            return false;
        }
        try {
            this.levelId = 0;
            RecordEnumeration recordEnumeration = this.store.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                int n;
                int n2 = recordEnumeration.nextRecordId();
                if (this.store.getRecordSize(n2) != 9 || (n = this.store.getRecord(n2, this.levelRec, 0)) != 9 || this.levelRec[0] != 1) continue;
                this.levelId = n2;
                break;
            }
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
            return false;
        }
        return true;
    }

    int getTheme() {
        return this.getInt(this.levelRec, 5);
    }

    int getLevel() {
        return this.getInt(this.levelRec, 1);
    }

    boolean setLevel(int n, int n2) {
        this.putInt(this.levelRec, 1, n);
        this.putInt(this.levelRec, 5, n2);
        this.putInt(this.scoreRec, 1, n);
        if (this.store == null) {
            return false;
        }
        try {
            if (this.levelId == 0) {
                this.levelId = this.store.addRecord(this.levelRec, 0, this.levelRec.length);
            } else {
                this.store.setRecord(this.levelId, this.levelRec, 0, this.levelRec.length);
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println("RecordStoreException");
            recordStoreException.printStackTrace();
            return false;
        }
        this.readScore(n);
        return true;
    }

    int getPushes() {
        return this.getInt(this.scoreRec, 5);
    }

    int getMoves() {
        return this.getInt(this.scoreRec, 9);
    }

    boolean readScore(int n) {
        try {
            this.scoreId = 0;
            RecordEnumeration recordEnumeration = this.store.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                int n2;
                int n3 = recordEnumeration.nextRecordId();
                if (this.store.getRecordSize(n3) != 13 || (n2 = this.store.getRecord(n3, this.scoreRec, 0)) != 13 || this.scoreRec[0] != 2 || this.getInt(this.scoreRec, 1) != n) continue;
                this.scoreId = n3;
                return true;
            }
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
            return false;
        }
        this.scoreRec[0] = 2;
        this.putInt(this.scoreRec, 1, n);
        this.putInt(this.scoreRec, 5, 0);
        this.putInt(this.scoreRec, 9, 0);
        return true;
    }

    boolean setLevelScore(int n, int n2) {
        this.putInt(this.scoreRec, 5, n);
        this.putInt(this.scoreRec, 9, n2);
        try {
            if (this.scoreId == 0) {
                this.scoreId = this.store.addRecord(this.scoreRec, 0, this.scoreRec.length);
            } else {
                this.store.setRecord(this.scoreId, this.scoreRec, 0, this.scoreRec.length);
            }
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
            return false;
        }
        return true;
    }

    private int getInt(byte[] byArray, int n) {
        return (byArray[n + 0] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private void putInt(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 >> 24 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 3] = (byte)(n2 >> 0 & 0xFF);
    }

    void close() {
        try {
            if (this.store != null) {
                this.store.closeRecordStore();
            }
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }
}

