/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev.metadd;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.schema2beansdev.metadd.CommonBean;
import org.netbeans.modules.schema2beansdev.metadd.MetaDD;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetaProperty
implements CommonBean {
    private String _BeanName;
    private List _DefaultValue = new ArrayList();
    private List _KnownValue = new ArrayList();
    private boolean _Key;
    private boolean _Vetoable;

    public MetaProperty() {
        this._BeanName = "";
    }

    public MetaProperty(String beanName) {
        this._BeanName = beanName;
    }

    public MetaProperty(MetaProperty source) {
        String element;
        this._BeanName = source._BeanName;
        Iterator it = source._DefaultValue.iterator();
        while (it.hasNext()) {
            element = (String)it.next();
            this._DefaultValue.add(element);
        }
        it = source._KnownValue.iterator();
        while (it.hasNext()) {
            element = (String)it.next();
            this._KnownValue.add(element);
        }
        this._Key = source._Key;
        this._Vetoable = source._Vetoable;
    }

    public void setBeanName(String value) {
        this._BeanName = value;
    }

    public String getBeanName() {
        return this._BeanName;
    }

    public void setDefaultValue(String[] value) {
        if (value == null) {
            value = new String[]{};
        }
        this._DefaultValue.clear();
        for (int i = 0; i < value.length; ++i) {
            this._DefaultValue.add(value[i]);
        }
    }

    public void setDefaultValue(int index, String value) {
        this._DefaultValue.set(index, value);
    }

    public String[] getDefaultValue() {
        String[] arr = new String[this._DefaultValue.size()];
        return this._DefaultValue.toArray(arr);
    }

    public List fetchDefaultValueList() {
        return this._DefaultValue;
    }

    public String getDefaultValue(int index) {
        return (String)this._DefaultValue.get(index);
    }

    public int sizeDefaultValue() {
        return this._DefaultValue.size();
    }

    public int addDefaultValue(String value) {
        this._DefaultValue.add(value);
        int positionOfNewItem = this._DefaultValue.size() - 1;
        return positionOfNewItem;
    }

    public int removeDefaultValue(String value) {
        int pos = this._DefaultValue.indexOf(value);
        if (pos >= 0) {
            this._DefaultValue.remove(pos);
        }
        return pos;
    }

    public void setKnownValue(String[] value) {
        if (value == null) {
            value = new String[]{};
        }
        this._KnownValue.clear();
        for (int i = 0; i < value.length; ++i) {
            this._KnownValue.add(value[i]);
        }
    }

    public void setKnownValue(int index, String value) {
        this._KnownValue.set(index, value);
    }

    public String[] getKnownValue() {
        String[] arr = new String[this._KnownValue.size()];
        return this._KnownValue.toArray(arr);
    }

    public List fetchKnownValueList() {
        return this._KnownValue;
    }

    public String getKnownValue(int index) {
        return (String)this._KnownValue.get(index);
    }

    public int sizeKnownValue() {
        return this._KnownValue.size();
    }

    public int addKnownValue(String value) {
        this._KnownValue.add(value);
        int positionOfNewItem = this._KnownValue.size() - 1;
        return positionOfNewItem;
    }

    public int removeKnownValue(String value) {
        int pos = this._KnownValue.indexOf(value);
        if (pos >= 0) {
            this._KnownValue.remove(pos);
        }
        return pos;
    }

    public void setKey(boolean value) {
        this._Key = value;
    }

    public boolean isKey() {
        return this._Key;
    }

    public void setVetoable(boolean value) {
        this._Vetoable = value;
    }

    public boolean isVetoable() {
        return this._Vetoable;
    }

    public void writeNode(Writer out, String nodeName, String indent) throws IOException {
        String element;
        out.write(indent);
        out.write("<");
        out.write(nodeName);
        out.write(">\n");
        String nextIndent = indent + "\t";
        if (this._BeanName != null) {
            out.write(nextIndent);
            out.write("<bean-name");
            out.write(">");
            MetaDD.writeXML(out, this._BeanName, false);
            out.write("</bean-name>\n");
        }
        Iterator it = this._DefaultValue.iterator();
        while (it.hasNext()) {
            element = (String)it.next();
            if (element == null) continue;
            out.write(nextIndent);
            out.write("<default-value");
            out.write(">");
            MetaDD.writeXML(out, element, false);
            out.write("</default-value>\n");
        }
        it = this._KnownValue.iterator();
        while (it.hasNext()) {
            element = (String)it.next();
            if (element == null) continue;
            out.write(nextIndent);
            out.write("<known-value");
            out.write(">");
            MetaDD.writeXML(out, element, false);
            out.write("</known-value>\n");
        }
        if (this._Key) {
            out.write(nextIndent);
            out.write("<key");
            out.write("/>\n");
        }
        if (this._Vetoable) {
            out.write(nextIndent);
            out.write("<vetoable");
            out.write("/>\n");
        }
        out.write(indent);
        out.write("</" + nodeName + ">\n");
    }

    public void readNode(Node node) {
        NodeList children = node.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Node childNode = children.item(i);
            String childNodeName = childNode.getLocalName() == null ? childNode.getNodeName().intern() : childNode.getLocalName().intern();
            String childNodeValue = "";
            if (childNode.getFirstChild() != null) {
                childNodeValue = childNode.getFirstChild().getNodeValue();
            }
            if (childNodeName == "bean-name") {
                this._BeanName = childNodeValue;
                continue;
            }
            if (childNodeName == "default-value") {
                String aDefaultValue = childNodeValue;
                this._DefaultValue.add(aDefaultValue);
                continue;
            }
            if (childNodeName == "known-value") {
                String aKnownValue = childNodeValue;
                this._KnownValue.add(aKnownValue);
                continue;
            }
            if (childNodeName == "key") {
                if (childNode.getFirstChild() == null) {
                    this._Key = true;
                    continue;
                }
                this._Key = Boolean.valueOf(childNodeValue);
                continue;
            }
            if (childNodeName != "vetoable") continue;
            this._Vetoable = childNode.getFirstChild() == null ? true : Boolean.valueOf(childNodeValue);
        }
    }

    public void validate() throws MetaDD.ValidateException {
        boolean restrictionFailure = false;
        if (this.getBeanName() == null) {
            throw new MetaDD.ValidateException("getBeanName() == null", MetaDD.ValidateException.FailureType.NULL_VALUE, "beanName", this);
        }
    }

    public void changePropertyByName(String name, Object value) {
        if (name == null) {
            return;
        }
        if ((name = name.intern()) == "beanName") {
            this.setBeanName((String)value);
        } else if (name == "defaultValue") {
            this.addDefaultValue((String)value);
        } else if (name == "defaultValue[]") {
            this.setDefaultValue((String[])value);
        } else if (name == "knownValue") {
            this.addKnownValue((String)value);
        } else if (name == "knownValue[]") {
            this.setKnownValue((String[])value);
        } else if (name == "key") {
            this.setKey((Boolean)value);
        } else if (name == "vetoable") {
            this.setVetoable((Boolean)value);
        } else {
            throw new IllegalArgumentException(name + " is not a valid property name for MetaProperty");
        }
    }

    public Object fetchPropertyByName(String name) {
        if (name == "beanName") {
            return this.getBeanName();
        }
        if (name == "defaultValue[]") {
            return this.getDefaultValue();
        }
        if (name == "knownValue[]") {
            return this.getKnownValue();
        }
        if (name == "key") {
            return this.isKey() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name == "vetoable") {
            return this.isVetoable() ? Boolean.TRUE : Boolean.FALSE;
        }
        throw new IllegalArgumentException(name + " is not a valid property name for MetaProperty");
    }

    public String nameSelf() {
        return "meta-property";
    }

    public String nameChild(Object childObj) {
        Object child;
        if (childObj instanceof String) {
            String element;
            child = (String)childObj;
            if (child == this._BeanName) {
                return "beanName";
            }
            int index = 0;
            Iterator it = this._DefaultValue.iterator();
            while (it.hasNext()) {
                element = (String)it.next();
                if (child == element) {
                    return "defaultValue." + index;
                }
                ++index;
            }
            index = 0;
            it = this._KnownValue.iterator();
            while (it.hasNext()) {
                element = (String)it.next();
                if (child == element) {
                    return "knownValue." + index;
                }
                ++index;
            }
        }
        if (childObj instanceof Boolean) {
            child = (Boolean)childObj;
            if ((Boolean)child == this._Key) {
                return "key";
            }
            if ((Boolean)child == this._Vetoable) {
                return "vetoable";
            }
        }
        return null;
    }

    public CommonBean[] childBeans(boolean recursive) {
        LinkedList children = new LinkedList();
        this.childBeans(recursive, children);
        CommonBean[] result = new CommonBean[children.size()];
        return children.toArray(result);
    }

    public void childBeans(boolean recursive, List beans) {
    }

    public boolean equals(Object o) {
        String element2;
        String element;
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaProperty)) {
            return false;
        }
        MetaProperty inst = (MetaProperty)o;
        if (!(this._BeanName != null ? this._BeanName.equals(inst._BeanName) : inst._BeanName == null)) {
            return false;
        }
        if (this.sizeDefaultValue() != inst.sizeDefaultValue()) {
            return false;
        }
        Iterator it = this._DefaultValue.iterator();
        Iterator it2 = inst._DefaultValue.iterator();
        while (it.hasNext() && it2.hasNext()) {
            element = (String)it.next();
            element2 = (String)it2.next();
            if (element != null ? element.equals(element2) : element2 == null) continue;
            return false;
        }
        if (this.sizeKnownValue() != inst.sizeKnownValue()) {
            return false;
        }
        it = this._KnownValue.iterator();
        it2 = inst._KnownValue.iterator();
        while (it.hasNext() && it2.hasNext()) {
            element = (String)it.next();
            element2 = (String)it2.next();
            if (element != null ? element.equals(element2) : element2 == null) continue;
            return false;
        }
        if (this._Key != inst._Key) {
            return false;
        }
        return this._Vetoable == inst._Vetoable;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this._BeanName == null ? 0 : this._BeanName.hashCode());
        result = 37 * result + (this._DefaultValue == null ? 0 : ((Object)this._DefaultValue).hashCode());
        result = 37 * result + (this._KnownValue == null ? 0 : ((Object)this._KnownValue).hashCode());
        result = 37 * result + (this._Key ? 0 : 1);
        result = 37 * result + (this._Vetoable ? 0 : 1);
        return result;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.writeNode(sw, "MetaProperty", "");
        }
        catch (IOException e) {
            return e.getMessage();
        }
        return sw.toString();
    }
}

