/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev.metadd;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.schema2beansdev.metadd.CommonBean;
import org.netbeans.modules.schema2beansdev.metadd.MetaElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MetaDD
implements CommonBean {
    private List _MetaElement = new ArrayList();
    private String _Implements;
    private String _Extends;
    private List _Import = new ArrayList();
    private boolean _Vetoable;
    private boolean _ThrowExceptions;
    private String schemaLocation;

    public MetaDD() {
    }

    public MetaDD(MetaDD source) {
        Object element;
        Iterator it = source._MetaElement.iterator();
        while (it.hasNext()) {
            element = (MetaElement)it.next();
            this._MetaElement.add(element == null ? null : new MetaElement((MetaElement)element));
        }
        this._Implements = source._Implements;
        this._Extends = source._Extends;
        it = source._Import.iterator();
        while (it.hasNext()) {
            element = (String)it.next();
            this._Import.add(element);
        }
        this._Vetoable = source._Vetoable;
        this._ThrowExceptions = source._ThrowExceptions;
        this.schemaLocation = source.schemaLocation;
    }

    public void setMetaElement(MetaElement[] value) {
        if (value == null) {
            value = new MetaElement[]{};
        }
        this._MetaElement.clear();
        for (int i = 0; i < value.length; ++i) {
            this._MetaElement.add(value[i]);
        }
    }

    public void setMetaElement(int index, MetaElement value) {
        this._MetaElement.set(index, value);
    }

    public MetaElement[] getMetaElement() {
        MetaElement[] arr = new MetaElement[this._MetaElement.size()];
        return this._MetaElement.toArray(arr);
    }

    public List fetchMetaElementList() {
        return this._MetaElement;
    }

    public MetaElement getMetaElement(int index) {
        return (MetaElement)this._MetaElement.get(index);
    }

    public int sizeMetaElement() {
        return this._MetaElement.size();
    }

    public int addMetaElement(MetaElement value) {
        this._MetaElement.add(value);
        int positionOfNewItem = this._MetaElement.size() - 1;
        return positionOfNewItem;
    }

    public int removeMetaElement(MetaElement value) {
        int pos = this._MetaElement.indexOf(value);
        if (pos >= 0) {
            this._MetaElement.remove(pos);
        }
        return pos;
    }

    public void setImplements(String value) {
        this._Implements = value;
    }

    public String getImplements() {
        return this._Implements;
    }

    public void setExtends(String value) {
        this._Extends = value;
    }

    public String getExtends() {
        return this._Extends;
    }

    public void setImport(String[] value) {
        if (value == null) {
            value = new String[]{};
        }
        this._Import.clear();
        for (int i = 0; i < value.length; ++i) {
            this._Import.add(value[i]);
        }
    }

    public void setImport(int index, String value) {
        this._Import.set(index, value);
    }

    public String[] getImport() {
        String[] arr = new String[this._Import.size()];
        return this._Import.toArray(arr);
    }

    public List fetchImportList() {
        return this._Import;
    }

    public String getImport(int index) {
        return (String)this._Import.get(index);
    }

    public int sizeImport() {
        return this._Import.size();
    }

    public int addImport(String value) {
        this._Import.add(value);
        int positionOfNewItem = this._Import.size() - 1;
        return positionOfNewItem;
    }

    public int removeImport(String value) {
        int pos = this._Import.indexOf(value);
        if (pos >= 0) {
            this._Import.remove(pos);
        }
        return pos;
    }

    public void setVetoable(boolean value) {
        this._Vetoable = value;
    }

    public boolean isVetoable() {
        return this._Vetoable;
    }

    public void setThrowExceptions(boolean value) {
        this._ThrowExceptions = value;
    }

    public boolean isThrowExceptions() {
        return this._ThrowExceptions;
    }

    public void _setSchemaLocation(String location) {
        this.schemaLocation = location;
    }

    public String _getSchemaLocation() {
        return this.schemaLocation;
    }

    public void write(OutputStream out) throws IOException {
        this.write(out, null);
    }

    public void write(OutputStream out, String encoding) throws IOException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out, encoding));
        this.write(w, encoding);
        ((Writer)w).flush();
    }

    public void write(Writer out, String encoding) throws IOException {
        out.write("<?xml version='1.0'");
        if (encoding != null) {
            out.write(" encoding='" + encoding + "'");
        }
        out.write(" ?>\n");
        this.writeNode(out, "metaDD", "");
    }

    public void writeNode(Writer out, String nodeName, String indent) throws IOException {
        Object element;
        out.write(indent);
        out.write("<");
        out.write(nodeName);
        if (this.schemaLocation != null) {
            out.write(" xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='");
            out.write(this.schemaLocation);
            out.write("'");
        }
        out.write(">\n");
        String nextIndent = indent + "\t";
        Iterator it = this._MetaElement.iterator();
        while (it.hasNext()) {
            element = (MetaElement)it.next();
            if (element == null) continue;
            ((MetaElement)element).writeNode(out, "meta-element", nextIndent);
        }
        if (this._Implements != null) {
            out.write(nextIndent);
            out.write("<implements");
            out.write(">");
            MetaDD.writeXML(out, this._Implements, false);
            out.write("</implements>\n");
        }
        if (this._Extends != null) {
            out.write(nextIndent);
            out.write("<extends");
            out.write(">");
            MetaDD.writeXML(out, this._Extends, false);
            out.write("</extends>\n");
        }
        it = this._Import.iterator();
        while (it.hasNext()) {
            element = (String)it.next();
            if (element == null) continue;
            out.write(nextIndent);
            out.write("<import");
            out.write(">");
            MetaDD.writeXML(out, (String)element, false);
            out.write("</import>\n");
        }
        if (this._Vetoable) {
            out.write(nextIndent);
            out.write("<vetoable");
            out.write("/>\n");
        }
        if (this._ThrowExceptions) {
            out.write(nextIndent);
            out.write("<throw-exceptions");
            out.write("/>\n");
        }
        out.write(indent);
        out.write("</" + nodeName + ">\n");
    }

    public static MetaDD read(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        return MetaDD.read(new InputSource(in), false, null, null);
    }

    public static MetaDD readNoEntityResolver(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        return MetaDD.read(new InputSource(in), false, new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                ByteArrayInputStream bin = new ByteArrayInputStream(new byte[0]);
                return new InputSource(bin);
            }
        }, null);
    }

    public static MetaDD read(InputSource in, boolean validate, EntityResolver er, ErrorHandler eh) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(validate);
        DocumentBuilder db = dbf.newDocumentBuilder();
        if (er != null) {
            db.setEntityResolver(er);
        }
        if (eh != null) {
            db.setErrorHandler(eh);
        }
        Document doc = db.parse(in);
        return MetaDD.read(doc);
    }

    public static MetaDD read(Document document) {
        MetaDD aMetaDD = new MetaDD();
        aMetaDD.readNode(document.getDocumentElement());
        return aMetaDD;
    }

    public void readNode(Node node) {
        if (node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            Attr attr = (Attr)attrs.getNamedItem("xsi:schemaLocation");
            String attrValue = attr != null ? attr.getValue() : null;
            this.schemaLocation = attrValue;
        }
        NodeList children = node.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Node childNode = children.item(i);
            String childNodeName = childNode.getLocalName() == null ? childNode.getNodeName().intern() : childNode.getLocalName().intern();
            String childNodeValue = "";
            if (childNode.getFirstChild() != null) {
                childNodeValue = childNode.getFirstChild().getNodeValue();
            }
            if (childNodeName == "meta-element") {
                MetaElement aMetaElement = new MetaElement();
                aMetaElement.readNode(childNode);
                this._MetaElement.add(aMetaElement);
                continue;
            }
            if (childNodeName == "implements") {
                this._Implements = childNodeValue;
                continue;
            }
            if (childNodeName == "extends") {
                this._Extends = childNodeValue;
                continue;
            }
            if (childNodeName == "import") {
                String aImport = childNodeValue;
                this._Import.add(aImport);
                continue;
            }
            if (childNodeName == "vetoable") {
                if (childNode.getFirstChild() == null) {
                    this._Vetoable = true;
                    continue;
                }
                this._Vetoable = Boolean.valueOf(childNodeValue);
                continue;
            }
            if (childNodeName != "throw-exceptions") continue;
            this._ThrowExceptions = childNode.getFirstChild() == null ? true : Boolean.valueOf(childNodeValue);
        }
    }

    public static void writeXML(Writer out, String msg) throws IOException {
        MetaDD.writeXML(out, msg, true);
    }

    public static void writeXML(Writer out, String msg, boolean attribute) throws IOException {
        if (msg == null) {
            return;
        }
        int msgLength = msg.length();
        for (int i = 0; i < msgLength; ++i) {
            char c = msg.charAt(i);
            MetaDD.writeXML(out, c, attribute);
        }
    }

    public static void writeXML(Writer out, char msg, boolean attribute) throws IOException {
        if (msg == '&') {
            out.write("&amp;");
        } else if (msg == '<') {
            out.write("&lt;");
        } else if (msg == '>') {
            out.write("&gt;");
        } else if (attribute && msg == '\"') {
            out.write("&quot;");
        } else if (attribute && msg == '\'') {
            out.write("&apos;");
        } else if (attribute && msg == '\n') {
            out.write("&#xA;");
        } else if (attribute && msg == '\t') {
            out.write("&#x9;");
        } else {
            out.write(msg);
        }
    }

    public void validate() throws ValidateException {
        boolean restrictionFailure = false;
        for (int _index = 0; _index < this.sizeMetaElement(); ++_index) {
            MetaElement element = this.getMetaElement(_index);
            if (element == null) continue;
            element.validate();
        }
    }

    public void changePropertyByName(String name, Object value) {
        if (name == null) {
            return;
        }
        if ((name = name.intern()) == "metaElement") {
            this.addMetaElement((MetaElement)value);
        } else if (name == "metaElement[]") {
            this.setMetaElement((MetaElement[])value);
        } else if (name == "implements") {
            this.setImplements((String)value);
        } else if (name == "extends") {
            this.setExtends((String)value);
        } else if (name == "import") {
            this.addImport((String)value);
        } else if (name == "import[]") {
            this.setImport((String[])value);
        } else if (name == "vetoable") {
            this.setVetoable((Boolean)value);
        } else if (name == "throwExceptions") {
            this.setThrowExceptions((Boolean)value);
        } else {
            throw new IllegalArgumentException(name + " is not a valid property name for MetaDD");
        }
    }

    public Object fetchPropertyByName(String name) {
        if (name == "metaElement[]") {
            return this.getMetaElement();
        }
        if (name == "implements") {
            return this.getImplements();
        }
        if (name == "extends") {
            return this.getExtends();
        }
        if (name == "import[]") {
            return this.getImport();
        }
        if (name == "vetoable") {
            return this.isVetoable() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name == "throwExceptions") {
            return this.isThrowExceptions() ? Boolean.TRUE : Boolean.FALSE;
        }
        throw new IllegalArgumentException(name + " is not a valid property name for MetaDD");
    }

    public String nameSelf() {
        return "/metaDD";
    }

    public String nameChild(Object childObj) {
        Object element;
        Iterator it;
        int index;
        Object child;
        if (childObj instanceof String) {
            child = (String)childObj;
            if (child == this._Implements) {
                return "implements";
            }
            if (child == this._Extends) {
                return "extends";
            }
            index = 0;
            it = this._Import.iterator();
            while (it.hasNext()) {
                element = (String)it.next();
                if (child == element) {
                    return "import." + index;
                }
                ++index;
            }
        }
        if (childObj instanceof MetaElement) {
            child = (MetaElement)childObj;
            index = 0;
            it = this._MetaElement.iterator();
            while (it.hasNext()) {
                element = (MetaElement)it.next();
                if (child == element) {
                    return "metaElement." + index;
                }
                ++index;
            }
        }
        if (childObj instanceof Boolean) {
            child = (Boolean)childObj;
            if ((Boolean)child == this._Vetoable) {
                return "vetoable";
            }
            if ((Boolean)child == this._ThrowExceptions) {
                return "throwExceptions";
            }
        }
        return null;
    }

    public CommonBean[] childBeans(boolean recursive) {
        LinkedList children = new LinkedList();
        this.childBeans(recursive, children);
        CommonBean[] result = new CommonBean[children.size()];
        return children.toArray(result);
    }

    public void childBeans(boolean recursive, List beans) {
        Iterator it = this._MetaElement.iterator();
        while (it.hasNext()) {
            MetaElement element = (MetaElement)it.next();
            if (element == null) continue;
            if (recursive) {
                element.childBeans(true, beans);
            }
            beans.add(element);
        }
    }

    public boolean equals(Object o) {
        Object element2;
        Object element;
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaDD)) {
            return false;
        }
        MetaDD inst = (MetaDD)o;
        if (this.sizeMetaElement() != inst.sizeMetaElement()) {
            return false;
        }
        Iterator it = this._MetaElement.iterator();
        Iterator it2 = inst._MetaElement.iterator();
        while (it.hasNext() && it2.hasNext()) {
            element = (MetaElement)it.next();
            element2 = (MetaElement)it2.next();
            if (element != null ? ((MetaElement)element).equals(element2) : element2 == null) continue;
            return false;
        }
        if (!(this._Implements != null ? this._Implements.equals(inst._Implements) : inst._Implements == null)) {
            return false;
        }
        if (!(this._Extends != null ? this._Extends.equals(inst._Extends) : inst._Extends == null)) {
            return false;
        }
        if (this.sizeImport() != inst.sizeImport()) {
            return false;
        }
        it = this._Import.iterator();
        it2 = inst._Import.iterator();
        while (it.hasNext() && it2.hasNext()) {
            element = (String)it.next();
            element2 = (String)it2.next();
            if (element != null ? ((String)element).equals(element2) : element2 == null) continue;
            return false;
        }
        if (this._Vetoable != inst._Vetoable) {
            return false;
        }
        return this._ThrowExceptions == inst._ThrowExceptions;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this._MetaElement == null ? 0 : ((Object)this._MetaElement).hashCode());
        result = 37 * result + (this._Implements == null ? 0 : this._Implements.hashCode());
        result = 37 * result + (this._Extends == null ? 0 : this._Extends.hashCode());
        result = 37 * result + (this._Import == null ? 0 : ((Object)this._Import).hashCode());
        result = 37 * result + (this._Vetoable ? 0 : 1);
        result = 37 * result + (this._ThrowExceptions ? 0 : 1);
        return result;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.writeNode(sw, "MetaDD", "");
        }
        catch (IOException e) {
            return e.getMessage();
        }
        return sw.toString();
    }

    public static class ValidateException
    extends Exception {
        private CommonBean failedBean;
        private String failedPropertyName;
        private FailureType failureType;

        public ValidateException(String msg, String failedPropertyName, CommonBean failedBean) {
            super(msg);
            this.failedBean = failedBean;
            this.failedPropertyName = failedPropertyName;
        }

        public ValidateException(String msg, FailureType ft, String failedPropertyName, CommonBean failedBean) {
            super(msg);
            this.failureType = ft;
            this.failedBean = failedBean;
            this.failedPropertyName = failedPropertyName;
        }

        public String getFailedPropertyName() {
            return this.failedPropertyName;
        }

        public FailureType getFailureType() {
            return this.failureType;
        }

        public CommonBean getFailedBean() {
            return this.failedBean;
        }

        public static class FailureType {
            private final String name;
            public static final FailureType NULL_VALUE = new FailureType("NULL_VALUE");
            public static final FailureType DATA_RESTRICTION = new FailureType("DATA_RESTRICTION");
            public static final FailureType ENUM_RESTRICTION = new FailureType("ENUM_RESTRICTION");
            public static final FailureType MUTUALLY_EXCLUSIVE = new FailureType("MUTUALLY_EXCLUSIVE");

            private FailureType(String name) {
                this.name = name;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

