/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.netbeans.modules.schema2beans.AttrProp;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DDLogFlags;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansNestedException;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.schema2beans.TraceLogger;
import org.netbeans.modules.schema2beansdev.DocDefHandler;
import org.netbeans.modules.schema2beansdev.DocDefParser;
import org.netbeans.modules.schema2beansdev.GenBeans;
import org.netbeans.modules.schema2beansdev.GraphLink;
import org.netbeans.modules.schema2beansdev.GraphNode;
import org.netbeans.modules.schema2beansdev.TreeParser;

public class TreeBuilder
implements DocDefHandler,
TreeParser {
    GraphNode rootNode;
    String docRoot;
    GenBeans.Config config;
    private Stack curParentGroupStack = new Stack();
    private GraphLink curParentGroup;
    private Stack curElementTypeStack = new Stack();
    private int curElementType;
    private Stack curAttrStack = new Stack();
    private AttrProp curAttr = null;
    Map nameHash = new HashMap();
    private String defaultNamespace = null;
    private static final int CREATE = 1;
    private static final int GET = 2;
    private static final int REFERENCE = 3;
    private static final String INDENT = "  ";

    void pushLevel() {
        this.curParentGroupStack.push(this.curParentGroup);
        this.curElementTypeStack.push(new Integer(this.curElementType));
        this.curAttrStack.push(this.curAttr);
    }

    void popLevel() {
        this.curParentGroup = (GraphLink)this.curParentGroupStack.pop();
        this.curElementType = (Integer)this.curElementTypeStack.pop();
        this.curAttr = (AttrProp)this.curAttrStack.pop();
    }

    TreeBuilder(GenBeans.Config config) {
        this.config = config;
    }

    public void startDocument(String root) {
        if (DDLogFlags.debug) {
            TraceLogger.put((int)TraceLogger.DEBUG, (int)TraceLogger.SVC_DD, (int)12, (int)1, (int)1, (Object)root);
            this.config.messageOut.println("Building the schema object graph.");
        }
        this.docRoot = root;
    }

    public void endDocument() {
        if (DDLogFlags.debug) {
            TraceLogger.put((int)TraceLogger.DEBUG, (int)TraceLogger.SVC_DD, (int)12, (int)1, (int)2);
            this.config.messageOut.println("schema Object graph built.");
        }
        Iterator it = this.nameHash.values().iterator();
        while (it.hasNext()) {
            GraphLink firstChild;
            GraphNode node = (GraphNode)it.next();
            GraphLink l = node.getGraphLink();
            if (l == null || l.name != null || l.getSibling() != null || l.isSequenceOr() || l.getGroupInstance() != 32 || (firstChild = l.getFirstChild()) != null && firstChild.getSibling() != null) continue;
            if (DDLogFlags.debug) {
                this.config.messageOut.println("Removing starter group: " + l);
            }
            node.setGraphLink(firstChild);
        }
        try {
            this.findRootNode();
        }
        catch (Schema2BeansException e) {
            throw new Schema2BeansRuntimeException((Throwable)e);
        }
        if (DDLogFlags.debug) {
            this.config.messageOut.println(this.dump());
        }
    }

    private GraphNode getGraphNode(String name, int mode) throws Schema2BeansException {
        String uniqueName = name;
        GraphNode node = (GraphNode)this.nameHash.get(uniqueName);
        if (node != null) {
            if (node.isCreated() && mode == 1) {
                throw new Schema2BeansException(Common.getMessage((String)"DuplicateElement_msg", (Object)uniqueName));
            }
        } else {
            node = new GraphNode(name, uniqueName);
            node.setGraphLink(new GraphLink(null));
            this.nameHash.put(uniqueName, node);
        }
        if (mode == 1) {
            node.setCreated(true);
        } else if (mode == 3) {
            node.incrRefCount();
        }
        return node;
    }

    public void startElement(String uniqueName, String typeName, int type) {
        if (DDLogFlags.debug) {
            TraceLogger.put((int)TraceLogger.DEBUG, (int)TraceLogger.SVC_DD, (int)12, (int)1, (int)3, (Object)(uniqueName + " - " + typeName + " - " + TreeBuilder.typeToString(type)));
        }
        this.pushLevel();
        this.curElementType = type;
        try {
            if (type == 2) {
                GraphNode node = this.getGraphNode(typeName, 1);
                this.curParentGroup = node.getGraphLink();
            } else if (type == 3) {
                GraphNode node = this.getGraphNode(typeName, 2);
                this.curAttr = new AttrProp(typeName);
                node.addAttribute(this.curAttr);
            }
        }
        catch (Schema2BeansException e) {
            throw new Schema2BeansRuntimeException((Throwable)e);
        }
    }

    public void startElement(String name, int type) {
        this.startElement(name, name, type);
    }

    public void endElement() {
        if (DDLogFlags.debug) {
            TraceLogger.put((int)TraceLogger.DEBUG, (int)TraceLogger.SVC_DD, (int)12, (int)1, (int)4);
        }
        if (this.curElementType == 3) {
            this.curAttr.validate();
        } else if (this.curElementType == 2) {
            // empty if block
        }
        this.curElementType = 0;
        this.popLevel();
    }

    public void character(char c) {
        if (this.curElementType == 2) {
            if (c == '|') {
                this.curParentGroup.setSequence(2);
            }
        } else if (this.curElementType == 3 && c == '|') {
            this.curAttr.checkEnum();
        }
    }

    public void element(String uniqueName, String typeName, String attrName, int instance, boolean externalType, String defaultValue) {
        if (DDLogFlags.debug) {
            TraceLogger.put((int)TraceLogger.DEBUG, (int)TraceLogger.SVC_DD, (int)12, (int)1, (int)5, (Object)(attrName + " : " + typeName + TreeBuilder.instanceToString(instance, false)));
        }
        try {
            if (this.curElementType == 0 && !externalType) {
                if (DDLogFlags.debug) {
                    System.out.println("Top element def for " + attrName);
                }
                GraphNode attrNode = this.getGraphNode(attrName, 1);
                GraphNode node = this.getGraphNode(typeName, 3);
                attrNode.setAlias(node);
            } else if (this.curElementType == 2) {
                GraphNode node = this.getGraphNode(typeName, 3);
                GraphLink link = new GraphLink(attrName);
                link.setDefaultValue(defaultValue);
                this.curParentGroup.addChild(link);
                link.element = node;
                link.setElementInstance(instance);
                if (externalType) {
                    node.setJavaType(typeName);
                }
            } else if (this.curElementType == 3) {
                if (this.curAttr.isComplete()) {
                    throw new DocDefParser.MissingEndOfEltException(this.curAttr.getPropertyName());
                }
                if (defaultValue != null) {
                    this.curAttr.setDefaultValue(defaultValue);
                }
                this.curAttr.addValue(attrName);
                if (externalType) {
                    this.curAttr.setJavaType(typeName);
                }
            }
        }
        catch (Schema2BeansException e) {
            throw new Schema2BeansRuntimeException((Throwable)e);
        }
    }

    public void element(String typeName, int instance) {
        this.element(typeName, typeName, typeName, instance, false, null);
    }

    public void addExtraDataNode(String typeName, Object data) throws Schema2BeansException {
        GraphNode node = this.getGraphNode(typeName, 2);
        node.addExtraData(data);
    }

    public void addExtraDataCurLink(Object data) {
        if (this.curElementType == 3) {
            if (this.curAttr != null) {
                this.curAttr.addExtraData(data);
            }
        } else if (this.curParentGroup != null && this.curParentGroup.getLastChild() != null) {
            this.curParentGroup.getLastChild().extraData.add(data);
        }
    }

    public void nillable(boolean value) {
        if (this.curParentGroup != null && this.curParentGroup.getLastChild() != null) {
            this.curParentGroup.getLastChild().setNillable(value);
        }
    }

    public void setExtendedProperty(String typeName, String propertyName, Object value) throws Schema2BeansException {
        GraphNode node = this.getGraphNode(typeName, 2);
        node.setExtendedProperty(propertyName, value);
    }

    public void javaType(String uniqueName, String name, String javaType) {
        if (this.curElementType == 3) {
            this.curAttr.setJavaType(javaType);
        } else {
            GraphNode node;
            try {
                node = this.getGraphNode(name, 2);
            }
            catch (Schema2BeansException e) {
                throw new Schema2BeansRuntimeException((Throwable)e);
            }
            node.setJavaType(javaType);
            node.setCreated(false);
        }
    }

    public void startGroupElements() {
        if (DDLogFlags.debug) {
            TraceLogger.put((int)TraceLogger.DEBUG, (int)TraceLogger.SVC_DD, (int)12, (int)5, (int)6);
        }
        if (this.curElementType == 2) {
            GraphLink link = new GraphLink(null);
            this.curParentGroup.addChild(link);
            this.curParentGroup = link;
        } else if (this.curElementType == 3) {
            this.curAttr.setEnum(true);
        }
    }

    public void endGroupElements(int instance) {
        if (DDLogFlags.debug) {
            TraceLogger.put((int)TraceLogger.DEBUG, (int)TraceLogger.SVC_DD, (int)12, (int)5, (int)7, (Object)TreeBuilder.instanceToString(instance, false));
        }
        if (this.curElementType == 2) {
            this.curParentGroup.setGroupInstance(instance);
            this.curParentGroup = this.curParentGroup.getParent();
        } else if (this.curElementType == 3) {
            this.curAttr.setEnum(false);
        }
    }

    public void setDefaultNamespace(String ns) {
        this.defaultNamespace = ns;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    private void findRootNode() throws Schema2BeansException {
        GraphNode node;
        Iterator it = this.nameHash.values().iterator();
        int count = 0;
        ArrayList<GraphNode> list = new ArrayList<GraphNode>();
        while (it.hasNext()) {
            node = (GraphNode)it.next();
            if (DDLogFlags.debug) {
                System.out.println("refCount=" + node.getRefCount() + " created=" + node.isCreated() + " javaType=" + node.getJavaType() + " node=" + node);
            }
            if (!node.isCreated() || node.getRefCount() != 0) continue;
            ++count;
            list.add(node);
        }
        if (count > 1) {
            int highestPoints = 0;
            GraphNode highestNode = null;
            int tieCount = 0;
            Iterator highit = list.iterator();
            while (highit.hasNext()) {
                GraphLink link;
                int points = 0;
                node = (GraphNode)highit.next();
                if (node.getAlias() != null) {
                    ++points;
                }
                if (this.defaultNamespace == null ? node.getNamespace() == null : this.defaultNamespace.equals(node.getNamespace())) {
                    ++points;
                }
                if ((link = node.getGraphLink()) != null && !"#PCDATA".equals(link.name)) {
                    GraphLink sibling;
                    ++points;
                    GraphLink firstChild = link.getFirstChild();
                    if (firstChild != null) {
                        ++points;
                        if (firstChild.getSibling() != null) {
                            ++points;
                        }
                        if (firstChild.getFirstChild() != null) {
                            ++points;
                        }
                    }
                    if ((sibling = link.getSibling()) != null) {
                        ++points;
                        if (sibling.getSibling() != null) {
                            ++points;
                        }
                        if (sibling.getFirstChild() != null) {
                            ++points;
                        }
                    }
                }
                if (points > highestPoints) {
                    highestPoints = points;
                    highestNode = node;
                    tieCount = 0;
                    continue;
                }
                if (points != highestPoints) continue;
                ++tieCount;
            }
            if (tieCount == 0 && highestNode != null) {
                count = 1;
                list.clear();
                list.add(highestNode);
            }
        }
        if (count == 1) {
            this.rootNode = (GraphNode)list.get(0);
            if (this.docRoot != null && !this.docRoot.equals(this.rootNode.getName())) {
                String str = "Mismatch between doc root name specified (" + this.docRoot + ") and the root name found in the DTD graph (" + this.rootNode.getName() + ")";
                throw new IllegalStateException(str);
            }
        } else if (count == 0) {
            this.rootNode = null;
            if (this.docRoot != null) {
                it = this.nameHash.values().iterator();
                while (it.hasNext()) {
                    node = (GraphNode)it.next();
                    if (!this.docRoot.equals(node.getName())) continue;
                    this.rootNode = node;
                    break;
                }
            }
            if (this.rootNode == null) {
                throw new IllegalStateException(Common.getMessage((String)"NoRootElementCandidate"));
            }
        } else {
            this.config.messageOut.println("The following elements could be the root of the document:");
            for (int i = 0; i < list.size(); ++i) {
                GraphNode n = (GraphNode)list.get(i);
                this.config.messageOut.print(i + 1 + ". " + n);
                if (this.docRoot != null && this.docRoot.equals(n.getName())) {
                    this.rootNode = n;
                    this.config.messageOut.println(" <= parameter value");
                    continue;
                }
                this.config.messageOut.println("");
            }
            if (this.rootNode == null) {
                String errStr = "Could not find the root of the document. Use the -d option to specify the doc root";
                if (this.config.isAuto()) {
                    throw new IllegalStateException(errStr);
                }
                try {
                    BufferedReader rd = new BufferedReader(new InputStreamReader(System.in));
                    this.config.messageOut.print("Enter the element that should be used as the root: ");
                    String str = rd.readLine();
                    int i = Integer.parseInt(str) - 1;
                    if (i < 0 || i >= list.size()) {
                        throw new IllegalStateException(errStr);
                    }
                    this.rootNode = (GraphNode)list.get(i);
                }
                catch (Exception e) {
                    TraceLogger.error((Throwable)e);
                    throw new Schema2BeansNestedException(errStr, (Throwable)e);
                }
            }
        }
        if (DDLogFlags.debug) {
            this.config.messageOut.println("Using " + this.rootNode.getName() + " as the root of the document.");
        }
    }

    static String instanceToString(int instance, boolean bean) {
        switch (instance) {
            case 16: {
                if (bean) {
                    return "[0,1]";
                }
                return "?";
            }
            case 48: {
                if (bean) {
                    return "[0,n]";
                }
                return "*";
            }
            case 64: {
                if (bean) {
                    return "[1,n]";
                }
                return "+";
            }
        }
        return "";
    }

    static String typeToString(int type) {
        switch (type) {
            case 1: {
                return "comment";
            }
            case 2: {
                return "element";
            }
            case 3: {
                return "attlist";
            }
        }
        return "unknown value: " + type;
    }

    public GraphNode[] getNodes() {
        int maxSize = this.nameHash.values().size();
        GraphNode[] ret = new GraphNode[maxSize];
        HashMap insertedNodes = new HashMap();
        int pos = 0;
        pos = this.getNodesInsertNode(this.rootNode, ret, pos, insertedNodes);
        pos = this.getNodes(this.rootNode.getGraphLink(), ret, pos, insertedNodes);
        if (this.config.isRemoveUnreferencedNodes()) {
            if (pos < maxSize) {
                GraphNode[] newRet = new GraphNode[pos];
                System.arraycopy(ret, 0, newRet, 0, pos);
                ret = newRet;
                maxSize = pos;
            }
        } else {
            Iterator it = this.nameHash.values().iterator();
            while (pos < maxSize && it.hasNext()) {
                GraphNode node = (GraphNode)it.next();
                if (insertedNodes.containsKey(node)) continue;
                this.config.messageOut.println(Common.getMessage((String)"MSG_FoundUnreferencedNode", (Object)node.toString()));
                ret[pos++] = node;
            }
        }
        return ret;
    }

    private int getNodes(GraphLink l, GraphNode[] ret, int pos, Map insertedNodes) {
        Stack<GraphLink> linkStack = new Stack<GraphLink>();
        linkStack.push(l);
        while (!linkStack.isEmpty()) {
            for (l = (GraphLink)linkStack.pop(); l != null; l = l.getSibling()) {
                if (l.element != null && !insertedNodes.containsKey(l.element)) {
                    pos = this.getNodesInsertNode(l.element, ret, pos, insertedNodes);
                    linkStack.push(l.element.getGraphLink());
                }
                linkStack.push(l.getFirstChild());
            }
        }
        return pos;
    }

    private int getNodesInsertNode(GraphNode node, GraphNode[] ret, int pos, Map insertedNodes) {
        if (insertedNodes.containsKey(node)) {
            return pos;
        }
        ret[pos++] = node;
        insertedNodes.put(node, null);
        if (node.getAlias() != null && !insertedNodes.containsKey(node.getAlias())) {
            ret[pos++] = node.getAlias();
            insertedNodes.put(node.getAlias(), null);
        }
        return pos;
    }

    public GraphNode getNode(String uniqueName) {
        return (GraphNode)this.nameHash.get(uniqueName);
    }

    public GraphNode getRoot() {
        return this.rootNode;
    }

    static void dumpAttributes(GraphNode elt, StringBuffer str, String indent) {
        AttrProp[] attrList = elt.getAttributes();
        for (int i = 0; i < attrList.length; ++i) {
            str.append(indent + INDENT + "[attr: " + attrList[i] + "]\n");
        }
    }

    static void dumpTree(List children, StringBuffer str, String indent, boolean tree) {
        Iterator it = children.iterator();
        while (it.hasNext()) {
            GraphLink l = (GraphLink)it.next();
            TreeBuilder.dumpTree(l, str, indent, tree);
        }
    }

    static void dumpTree(GraphLink l, StringBuffer str, String indent, boolean tree) {
        if (l == null) {
            return;
        }
        if (l.element != null) {
            str.append(indent);
            str.append(l.name + " : " + l.element.toString());
            str.append(TreeBuilder.instanceToString(l.getElementInstance(), false) + "\n");
            TreeBuilder.dumpAttributes(l.element, str, indent);
            if (tree && !l.element.getMarked()) {
                l.element.setMarked(true);
                TreeBuilder.dumpTree(l.element.getGraphLink(), str, indent + INDENT + TreeBuilder.instanceToString(l.getGroupInstance(), false) + (l.isSequenceOr() ? "| " : " "), tree);
                l.element.setMarked(false);
            }
        }
        if (l.isSequenceOr() || l.getGroupInstance() != 32) {
            str.append(indent + TreeBuilder.instanceToString(l.getGroupInstance(), false) + (l.isSequenceOr() ? "|\n" : "\n"));
        }
        TreeBuilder.dumpTree(l.getChildren(), str, indent + INDENT, tree);
    }

    public String dump() {
        StringBuffer str = new StringBuffer();
        str.append("Tree:\n");
        str.append(this.rootNode.toString());
        str.append("\n");
        TreeBuilder.dumpAttributes(this.rootNode, str, INDENT);
        TreeBuilder.dumpTree(this.rootNode.getGraphLink(), str, INDENT, true);
        return str.toString();
    }
}

