/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.schema2beans.AttrProp;
import org.netbeans.modules.schema2beansdev.GraphLink;

public class GraphNode {
    private String name;
    private String namespace = null;
    private String uniqueName;
    private GraphLink link;
    private boolean created;
    private int refCount;
    private Object object;
    private List attributes;
    private boolean marked;
    private String javaType;
    private Map extendedProperties = new HashMap();
    private List extraData = new ArrayList();
    private GraphNode alias;

    GraphNode(String name, String uniqueName) {
        this.setName(name);
        this.uniqueName = uniqueName;
        this.created = false;
        this.attributes = null;
        this.marked = false;
    }

    void addAttribute(AttrProp attr) {
        if (this.alias != null) {
            this.alias.addAttribute(attr);
            return;
        }
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        this.attributes.add(attr);
    }

    AttrProp[] getAttributes() {
        if (this.alias != null) {
            return this.alias.getAttributes();
        }
        int size = 0;
        if (this.attributes != null) {
            size = this.attributes.size();
        }
        AttrProp[] ret = new AttrProp[size];
        if (size > 0) {
            return this.attributes.toArray(ret);
        }
        return ret;
    }

    void setObject(Object obj) {
        this.object = obj;
    }

    Object getObject() {
        return this.object;
    }

    String getNameWithNamespace() {
        if (this.namespace == null) {
            return this.name;
        }
        return "{" + this.namespace + "}" + this.name;
    }

    String getName() {
        return this.name;
    }

    String getNamespace() {
        if (this.alias != null) {
            return this.alias.getNamespace();
        }
        return this.namespace;
    }

    void setName(String name) {
        if (name.charAt(0) == '{') {
            int closingBracket = name.indexOf(125);
            this.name = name.substring(closingBracket + 1, name.length());
            this.namespace = name.substring(1, closingBracket);
        } else {
            this.name = name;
            this.namespace = null;
        }
    }

    GraphLink getGraphLink() {
        if (this.alias != null) {
            return this.alias.getGraphLink();
        }
        return this.link;
    }

    void setGraphLink(GraphLink l) {
        if (this.alias != null) {
            this.alias.setGraphLink(l);
            return;
        }
        this.link = l;
    }

    void setMarked(boolean value) {
        if (this.alias != null) {
            this.alias.setMarked(value);
            return;
        }
        this.marked = value;
    }

    boolean getMarked() {
        if (this.alias != null) {
            return this.alias.getMarked();
        }
        return this.marked;
    }

    void setCreated(boolean value) {
        if (this.alias != null) {
            this.alias.setCreated(value);
            return;
        }
        this.created = value;
    }

    boolean isCreated() {
        if (this.alias != null) {
            return this.alias.isCreated();
        }
        return this.created;
    }

    public void setExtendedProperty(String name, Object value) {
        if (this.alias != null) {
            this.alias.setExtendedProperty(name, value);
            return;
        }
        this.extendedProperties.put(name, value);
    }

    public Object getExtendedProperty(String name) {
        if (this.alias != null) {
            return this.alias.getExtendedProperty(name);
        }
        return this.extendedProperties.get(name);
    }

    void incrRefCount() {
        ++this.refCount;
    }

    int getRefCount() {
        return this.refCount;
    }

    void setAlias(GraphNode n) {
        this.alias = n;
    }

    GraphNode getAlias() {
        return this.alias;
    }

    GraphNode[] getNodes() {
        if (this.alias != null) {
            return this.alias.getNodes();
        }
        HashMap list = new HashMap();
        this.gatherElements(this.link, list);
        GraphNode[] ret = new GraphNode[list.size()];
        return list.values().toArray(ret);
    }

    private void gatherElements(GraphLink l, Map list) {
        while (l != null) {
            if (l.element != null) {
                list.put(l.element.getName(), l.element);
            }
            this.gatherElements(l.getFirstChild(), list);
            l = l.getSibling();
        }
    }

    public void setJavaType(String jt) {
        if (this.alias != null) {
            this.alias.setJavaType(jt);
            return;
        }
        this.javaType = jt;
    }

    public String getJavaType() {
        if (this.alias != null) {
            return this.alias.getJavaType();
        }
        return this.javaType;
    }

    public void addExtraData(Object data) {
        this.extraData.add(data);
    }

    public Object searchExtraData(Class type) {
        Iterator it = this.extraData.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!type.isAssignableFrom(o.getClass())) continue;
            return o;
        }
        return null;
    }

    public Iterator extraDataIterator() {
        return this.extraData.iterator();
    }

    public List getExtraData() {
        return this.extraData;
    }

    public String toString() {
        if (this.alias != null) {
            return this.name + " (is a " + this.alias.toString() + ")";
        }
        return this.getNameWithNamespace();
    }
}

