/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.netbeans.modules.schema2beansdev.GraphNode;

public class GraphLink {
    GraphNode element;
    private GraphLink parent;
    private GraphLink sibling;
    private GraphLink child;
    private transient GraphLink lastChild;
    int propElement = 33;
    int propChildren = 33;
    String name;
    private String defaultValue;
    private boolean nillable;
    private Object object;
    List extraData = new ArrayList();

    GraphLink(String name) {
        this.name = name;
    }

    public List getChildren() {
        ArrayList<GraphLink> result = new ArrayList<GraphLink>();
        GraphLink l = this.child;
        while (l != null) {
            result.add(l);
            l = l.sibling;
        }
        return result;
    }

    public List getSiblings() {
        ArrayList<GraphLink> result = new ArrayList<GraphLink>();
        if (this.parent == null) {
            GraphLink l = this;
            while (l != null) {
                result.add(l);
                l = l.sibling;
            }
            return result;
        }
        GraphLink l = this.parent.child;
        while (l != null) {
            if (l != this) {
                result.add(l);
            }
            l = l.sibling;
        }
        return result;
    }

    public List getSiblingsAndMe() {
        if (this.parent == null) {
            ArrayList<GraphLink> result = new ArrayList<GraphLink>();
            GraphLink l = this;
            while (l != null) {
                result.add(l);
                l = l.sibling;
            }
            return result;
        }
        return this.parent.getChildren();
    }

    public GraphLink getSibling() {
        return this.sibling;
    }

    public GraphLink getLastSibling() {
        if (this.parent != null && this.parent.lastChild != null) {
            return this.parent.getLastChild();
        }
        if (this.sibling == null) {
            return this;
        }
        return this.sibling.getLastSibling();
    }

    public GraphLink getFirstChild() {
        return this.child;
    }

    public GraphLink getLastChild() {
        if (this.lastChild == null && this.child != null) {
            this.lastChild = this.child.getLastSibling();
        }
        return this.lastChild;
    }

    public void setChild(GraphLink l) {
        this.child = l;
        this.child.parent = this;
        this.lastChild = null;
    }

    private void addSibling(GraphLink l) {
        if (this.sibling != null) {
            throw new RuntimeException("I am not the last sibling!");
        }
        this.sibling = l;
        l.parent = this.parent;
        if (this.parent != null) {
            this.parent.lastChild = l;
        }
    }

    public void addChild(GraphLink l) {
        if (this.child == null) {
            this.setChild(l);
        } else {
            this.child.getLastSibling().addSibling(l);
        }
    }

    public GraphLink getParent() {
        return this.parent;
    }

    private void setParent(GraphLink l) {
        this.parent = l;
    }

    boolean isSequenceAnd() {
        return (this.propChildren & 1) == 1;
    }

    boolean isSequenceOr() {
        return (this.propChildren & 2) == 2;
    }

    void setSequence(int prop) {
        this.propChildren = this.propChildren & 0xFF00 | prop;
    }

    void setElementInstance(int instance) {
        this.propElement = this.propElement & 0xF | instance;
    }

    int getElementInstance() {
        return this.propElement & 0xF0;
    }

    void setGroupInstance(int instance) {
        this.propChildren = this.propChildren & 0xF | instance;
    }

    int getGroupInstance() {
        return this.propChildren & 0xF0;
    }

    public void getMutuallyExclusiveLinks(List links) {
        if (this.parent == null) {
            return;
        }
        if (this.parent.isSequenceOr() && (this.parent.getGroupInstance() == 32 || this.parent.getGroupInstance() == 16)) {
            Iterator it = this.getSiblings().iterator();
            while (it.hasNext()) {
                GraphLink l = (GraphLink)it.next();
                l.findAllBelowBranch(links);
            }
        }
        this.parent.getMutuallyExclusiveLinks(links);
    }

    public void findAllBelowBranch(List links) {
        links.add(this);
        if (this.child != null) {
            this.child.findAllBelowBranchAndSiblings(links);
        }
    }

    public void findAllBelowBranchAndSiblings(List links) {
        GraphLink l = this;
        while (l != null) {
            links.add(l);
            if (l.child != null) {
                l.child.findAllBelowBranchAndSiblings(links);
            }
            l = l.sibling;
        }
    }

    String getDefaultValue() {
        return this.defaultValue;
    }

    void setDefaultValue(String d) {
        this.defaultValue = d;
    }

    void setObject(Object obj) {
        this.object = obj;
    }

    Object getObject() {
        return this.object;
    }

    boolean isNillable() {
        return this.nillable;
    }

    void setNillable(boolean value) {
        this.nillable = value;
    }

    public XPathIterator xPathIterator(String xpath) {
        return new XPathIterator(this, xpath);
    }

    public static class XPathIterator
    implements Iterator {
        private String xpath;
        private String step;
        private GraphLink curLink;
        private int position;

        public XPathIterator(GraphLink startingLink, String xpath) {
            this.xpath = xpath;
            this.curLink = startingLink;
            this.findNextStep();
        }

        private void findNextStep() {
            if (this.position >= this.xpath.length()) {
                this.step = null;
                return;
            }
            int startingPos = this.position;
            while (this.position < this.xpath.length()) {
                if (this.xpath.charAt(this.position) == '/') {
                    this.step = this.xpath.substring(startingPos, this.position);
                    ++this.position;
                    if (".".equals(this.step)) {
                        startingPos = this.position;
                    } else {
                        return;
                    }
                }
                ++this.position;
            }
            this.step = this.xpath.substring(startingPos, this.position);
            if (startingPos > 0 && ".".equals(this.step)) {
                this.step = null;
            }
        }

        public boolean hasNext() {
            return this.step != null;
        }

        public Object next() {
            if (this.step == null) {
                throw new NoSuchElementException();
            }
            GraphLink result = this.curLink;
            while (".".equals(this.step)) {
                this.findNextStep();
                if (this.step != null) continue;
                return result;
            }
            int colonPos = this.step.indexOf(58);
            if (colonPos >= 0) {
                this.step = this.step.substring(colonPos + 1, this.step.length());
            }
            while (result != null && !this.step.equals(result.name)) {
                if (result.sibling != null) {
                    result = result.sibling;
                    continue;
                }
                if (result.child != null) {
                    result = result.child;
                    continue;
                }
                this.step = null;
                this.position = this.xpath.length();
                return null;
            }
            this.curLink = result.element == null ? null : result.element.getGraphLink();
            this.findNextStep();
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

