/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DDLogFlags;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansNestedException;
import org.netbeans.modules.schema2beans.Version;
import org.netbeans.modules.schema2beansdev.BaseBeansFactory;
import org.netbeans.modules.schema2beansdev.BeanBuilder;
import org.netbeans.modules.schema2beansdev.CodeGeneratorFactory;
import org.netbeans.modules.schema2beansdev.DocDefParser;
import org.netbeans.modules.schema2beansdev.GeneralParser;
import org.netbeans.modules.schema2beansdev.JavaBeansFactory;
import org.netbeans.modules.schema2beansdev.S2bConfig;
import org.netbeans.modules.schema2beansdev.SchemaParseException;
import org.netbeans.modules.schema2beansdev.TreeBuilder;
import org.netbeans.modules.schema2beansdev.XMLSchemaParser;
import org.netbeans.modules.schema2beansdev.beangraph.BeanGraph;
import org.netbeans.modules.schema2beansdev.metadd.MetaDD;
import org.xml.sax.SAXException;

public class GenBeans {
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$io$PrintWriter;
    static /* synthetic */ Class class$org$netbeans$modules$schema2beans$BaseBean;
    static /* synthetic */ Class class$org$netbeans$modules$schema2beansdev$BeanClass;
    static /* synthetic */ Class class$org$netbeans$modules$schema2beansdev$GenBeans;
    static /* synthetic */ Class class$org$netbeans$modules$schema2beansdev$BeanBuilder;
    static /* synthetic */ Class class$org$netbeans$modules$schema2beansdev$TreeBuilder;
    static /* synthetic */ Class class$org$netbeans$modules$schema2beansdev$GraphLink;
    static /* synthetic */ Class class$org$netbeans$modules$schema2beansdev$GraphNode;
    static /* synthetic */ Class class$org$netbeans$modules$schema2beansdev$JavaBeanClass;

    public static void main(String[] args) {
        Config config = new Config();
        if (config.parseArguments(args)) {
            config.showHelp(System.out);
            return;
        }
        if (config.getFilename() == null) {
            config.showHelp(System.out);
            return;
        }
        DDLogFlags.debug = config.isTrace();
        try {
            GenBeans.doIt(config);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void doIt(Config config) throws IOException, Schema2BeansException {
        boolean tryAgain;
        if (config.getIndentAmount() > 0) {
            config.setIndent("");
            for (int i = 0; i < config.getIndentAmount(); ++i) {
                config.setIndent(config.getIndent() + " ");
            }
        }
        if (config.isGenerateTransactions()) {
            config.setGeneratePropertyEvents(true);
            config.setGenerateStoreEvents(true);
        } else if (!config.isGeneratePropertyEvents() && config.isGenerateStoreEvents()) {
            config.setGenerateStoreEvents(false);
        }
        if (config.isGenerateHasChanged()) {
            config.setGenerateParentRefs(true);
        }
        GenBeans.calculateNewestSourceTime(config);
        boolean needToWriteMetaDD = GenBeans.processMetaDD(config);
        TreeBuilder tree = new TreeBuilder(config);
        GeneralParser parser = null;
        int schemaType = config.getSchemaTypeNum();
        SchemaParseException lastException = null;
        do {
            tryAgain = false;
            if (schemaType == 0) {
                XMLSchemaParser xmlSchemaParser = new XMLSchemaParser(config, tree);
                if (config.getInputURI() != null) {
                    xmlSchemaParser.setInputURI(config.getInputURI());
                }
                GenBeans.readBeanGraphs(config, xmlSchemaParser);
                parser = xmlSchemaParser;
            } else {
                parser = new DocDefParser(config, tree);
            }
            try {
                parser.process();
            }
            catch (SchemaParseException e) {
                if (schemaType != 1) {
                    if (lastException == null) {
                        throw e;
                    }
                    throw lastException;
                }
                tryAgain = true;
                schemaType = 0;
                lastException = e;
            }
        } while (tryAgain);
        config.setSchemaTypeNum(schemaType);
        BeanBuilder builder = new BeanBuilder(tree, config, config.getCodeGeneratorFactory());
        builder.process();
        if (needToWriteMetaDD) {
            try {
                config.messageOut.println("Writing metaDD XML file");
                FileOutputStream mddOut = new FileOutputStream(config.getMddFile());
                config.getMetaDD().write(mddOut);
                mddOut.close();
            }
            catch (IOException e) {
                config.messageOut.println("Failed to write the mdd file: " + e.getMessage());
                throw e;
            }
        }
        if (config.isDoCompile() && config.getOutputStreamProvider() instanceof DefaultOutputStreamProvider) {
            DefaultOutputStreamProvider out = (DefaultOutputStreamProvider)config.getOutputStreamProvider();
            String[] javacArgs = new String[out.getGeneratedFiles().size()];
            int javaFileCount = 0;
            Iterator it = out.getGeneratedFiles().iterator();
            while (it.hasNext()) {
                javacArgs[javaFileCount] = (String)it.next();
                ++javaFileCount;
            }
            if (javaFileCount == 0) {
                config.messageOut.println(Common.getMessage((String)"MSG_NothingToCompile"));
            } else {
                config.messageOut.println(Common.getMessage((String)"MSG_Compiling"));
                try {
                    Class<?> javacClass = Class.forName("com.sun.tools.javac.Main");
                    Method compileMethod = javacClass.getDeclaredMethod("compile", array$Ljava$lang$String == null ? (array$Ljava$lang$String = GenBeans.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = GenBeans.class$("java.io.PrintWriter")) : class$java$io$PrintWriter);
                    PrintWriter pw = new PrintWriter(config.messageOut, true);
                    Object result = compileMethod.invoke(null, javacArgs, pw);
                    pw.flush();
                    int compileExitCode = 0;
                    if (result instanceof Integer) {
                        compileExitCode = (Integer)result;
                    }
                    if (compileExitCode != 0) {
                        throw new RuntimeException("Compile errors: javac had an exit code of " + compileExitCode);
                    }
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof Schema2BeansException) {
                        throw (Schema2BeansException)e;
                    }
                    throw new Schema2BeansNestedException(Common.getMessage((String)"MSG_UnableToCompile"), (Throwable)e);
                }
            }
        }
    }

    private static void readBeanGraphs(Config config, XMLSchemaParser xmlSchemaParser) throws IOException {
        try {
            Iterator it = config.readBeanGraphFiles();
            while (it.hasNext()) {
                File filename = (File)it.next();
                FileInputStream in = new FileInputStream(filename);
                BeanGraph bg = BeanGraph.read(in);
                ((InputStream)in).close();
                config.addReadBeanGraphs(bg);
            }
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static boolean processMetaDD(Config config) throws IOException {
        needToWriteMetaDD = false;
        if (config.getMddFile() != null || config.getMddIn() != null) {
            file = config.getMddFile();
            if (config.getMddIn() == null && !file.exists()) {
                config.setDoGeneration(false);
                if (!config.isAuto() && !GenBeans.askYesOrNo(config.messageOut, "The mdd file " + config.getMddFile() + " doesn't exist. Should we create it (y/n)? ")) {
                    config.messageOut.println("Generation aborted.");
                    return false;
                }
                needToWriteMetaDD = true;
                mdd = new MetaDD();
            } else {
                try {
                    is = config.getMddIn();
                    if (config.getMddIn() == null) {
                        is = new FileInputStream(config.getMddFile());
                        config.messageOut.println(Common.getMessage((String)"MSG_UsingMdd", (Object)config.getMddFile()));
                    }
                    mdd = MetaDD.read(is);
                    if (config.getMddIn() != null) ** GOTO lbl34
                    is.close();
                }
                catch (IOException e) {
                    if (config.isTraceParse()) {
                        e.printStackTrace();
                    }
                    throw new IOException(Common.getMessage((String)"CantCreateMetaDDFile_msg", (Object)e.getMessage()));
                }
                catch (ParserConfigurationException e) {
                    if (config.isTraceParse()) {
                        e.printStackTrace();
                    }
                    throw new IOException(Common.getMessage((String)"CantCreateMetaDDFile_msg", (Object)e.getMessage()));
                }
                catch (SAXException e) {
                    if (config.isTraceParse()) {
                        e.printStackTrace();
                    }
                    throw new IOException(Common.getMessage((String)"CantCreateMetaDDFile_msg", (Object)e.getMessage()));
                }
            }
        } else {
            var2_3 = new MetaDD();
        }
lbl34:
        // 4 sources

        config.setMetaDD(var2_3);
        return needToWriteMetaDD;
    }

    private static boolean askYesOrNo(PrintStream out, String prompt) throws IOException {
        out.print(prompt);
        BufferedReader rd = new BufferedReader(new InputStreamReader(System.in));
        String str = rd.readLine();
        return str.equalsIgnoreCase("y");
    }

    private static void calculateNewestSourceTime(Config config) {
        if (config.getFilename() != null) {
            config.setIfNewerSourceTime(config.getFilename().lastModified());
        }
        if (config.getMddFile() != null) {
            config.setIfNewerSourceTime(config.getMddFile().lastModified());
        }
        Iterator it = config.readBeanGraphFiles();
        while (it.hasNext()) {
            File f = (File)it.next();
            config.setIfNewerSourceTime(f.lastModified());
        }
        config.setIfNewerSourceTime(GenBeans.getLastModified(class$org$netbeans$modules$schema2beans$BaseBean == null ? (class$org$netbeans$modules$schema2beans$BaseBean = GenBeans.class$("org.netbeans.modules.schema2beans.BaseBean")) : class$org$netbeans$modules$schema2beans$BaseBean));
        config.setIfNewerSourceTime(GenBeans.getLastModified(class$org$netbeans$modules$schema2beansdev$BeanClass == null ? (class$org$netbeans$modules$schema2beansdev$BeanClass = GenBeans.class$("org.netbeans.modules.schema2beansdev.BeanClass")) : class$org$netbeans$modules$schema2beansdev$BeanClass));
        config.setIfNewerSourceTime(GenBeans.getLastModified(class$org$netbeans$modules$schema2beansdev$GenBeans == null ? (class$org$netbeans$modules$schema2beansdev$GenBeans = GenBeans.class$("org.netbeans.modules.schema2beansdev.GenBeans")) : class$org$netbeans$modules$schema2beansdev$GenBeans));
        config.setIfNewerSourceTime(GenBeans.getLastModified(class$org$netbeans$modules$schema2beansdev$BeanBuilder == null ? (class$org$netbeans$modules$schema2beansdev$BeanBuilder = GenBeans.class$("org.netbeans.modules.schema2beansdev.BeanBuilder")) : class$org$netbeans$modules$schema2beansdev$BeanBuilder));
        config.setIfNewerSourceTime(GenBeans.getLastModified(class$org$netbeans$modules$schema2beansdev$TreeBuilder == null ? (class$org$netbeans$modules$schema2beansdev$TreeBuilder = GenBeans.class$("org.netbeans.modules.schema2beansdev.TreeBuilder")) : class$org$netbeans$modules$schema2beansdev$TreeBuilder));
        config.setIfNewerSourceTime(GenBeans.getLastModified(class$org$netbeans$modules$schema2beansdev$GraphLink == null ? (class$org$netbeans$modules$schema2beansdev$GraphLink = GenBeans.class$("org.netbeans.modules.schema2beansdev.GraphLink")) : class$org$netbeans$modules$schema2beansdev$GraphLink));
        config.setIfNewerSourceTime(GenBeans.getLastModified(class$org$netbeans$modules$schema2beansdev$GraphNode == null ? (class$org$netbeans$modules$schema2beansdev$GraphNode = GenBeans.class$("org.netbeans.modules.schema2beansdev.GraphNode")) : class$org$netbeans$modules$schema2beansdev$GraphNode));
        config.setIfNewerSourceTime(GenBeans.getLastModified(class$org$netbeans$modules$schema2beansdev$JavaBeanClass == null ? (class$org$netbeans$modules$schema2beansdev$JavaBeanClass = GenBeans.class$("org.netbeans.modules.schema2beansdev.JavaBeanClass")) : class$org$netbeans$modules$schema2beansdev$JavaBeanClass));
    }

    private static long getLastModified(Class cls) {
        try {
            String shortName = cls.getName().substring(1 + cls.getName().lastIndexOf(46));
            URL url = cls.getResource(shortName + ".class");
            String file = url.getFile();
            if ("file".equals(url.getProtocol())) {
                String result = file.substring(0, file.length() - cls.getName().length() - 6);
                return new File(file).lastModified();
            }
            if ("jar".equals(url.getProtocol())) {
                String jarFile = file.substring(file.indexOf(58) + 1);
                jarFile = jarFile.substring(0, jarFile.indexOf(33));
                return new File(jarFile).lastModified();
            }
            return url.openConnection().getDate();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Config
    extends S2bConfig {
        public static final int XML_SCHEMA = 0;
        public static final int DTD = 1;
        public static final int OUTPUT_TRADITIONAL_BASEBEAN = 0;
        public static final int OUTPUT_JAVABEANS = 1;
        PrintStream messageOut;

        public Config() {
            this.setOutputStreamProvider(new DefaultOutputStreamProvider(this));
            this.setSchemaTypeNum(1);
            this.setMessageOut(System.out);
        }

        public Config(OutputStreamProvider out) {
            this.setOutputStreamProvider(out);
            this.setSchemaTypeNum(1);
            this.setMessageOut(System.out);
        }

        protected int unknownArgument(String[] args, String arg, int argNum) {
            if (arg == "-t") {
                if ((arg = args[++argNum]).equalsIgnoreCase("parse")) {
                    this.setTraceParse(true);
                } else if (arg.equalsIgnoreCase("gen")) {
                    this.setTraceGen(true);
                } else if (arg.equalsIgnoreCase("dot")) {
                    this.setTraceDot(true);
                } else {
                    if (!arg.equalsIgnoreCase("all")) {
                        --argNum;
                    }
                    this.setTraceParse(true);
                    this.setTraceGen(true);
                    this.setTraceMisc(true);
                    this.setTraceDot(true);
                }
            } else if (arg == "-version") {
                this.messageOut.println("schema2beans - " + Version.getVersion());
                System.exit(0);
            } else if (arg == "-xmlschema") {
                this.setSchemaTypeNum(0);
            } else if (arg == "-dtd") {
                this.setSchemaTypeNum(1);
            } else if (arg == "-premium") {
                this.buyPremium();
            } else if (arg == "-basebean") {
                this.setOutputType(0);
            } else if (arg == "-javabeans") {
                this.setOutputType(1);
            } else if (arg == "-commoninterface") {
                this.setGenerateCommonInterface("CommonBean");
            } else if (arg == "-nocommoninterface") {
                this.setGenerateCommonInterface(null);
            } else {
                this.messageOut.println("Unknown argument: " + arg);
                this.messageOut.println("Use -help.");
                System.exit(1);
            }
            return argNum;
        }

        public void showHelp(PrintStream out) {
            super.showHelp(out);
            out.println(" -version\tPrint version info");
            out.println(" -xmlschema\tXML Schema input mode");
            out.println(" -dtd\tDTD input mode (default)");
            out.println(" -javaBeans\tGenerate pure JavaBeans that do not need any runtime library support (no BaseBean).");
            out.println(" -baseBean\tForce use of BaseBean.  Runtime required.");
            out.println(" -commonInterface\tGenerate a common interface between all beans.");
            out.println(" -premium The \"Premium\" Package.  Turn on what ought to be the default switches (but can't be the default due to backwards compatibility).");
            out.println("\nThe bean classes are generated in the directory rootDir/packagePath, where packagePath is built using the package name specified. If the package name is not specified, the doc root element value is used as the default package name.  Use the empty string to get no (default) package.");
            out.println("\nexamples: java GenBeans -f ejb.dtd");
            out.println("          java GenBeans -f webapp.dtd -d webapp -p myproject.webapp -r /myPath/src");
            out.println("          java GenBeans -f webapp.xsd -xmlschema -r /myPath/src -premium");
            out.println("\nMost of the parameters are optional. Only the file name is mandatory.");
            out.println("With only the file name specified, the generator uses the current directory, and uses the schema docroot value as the package name.");
        }

        public void setMessageOut(PrintStream messageOut) {
            this.messageOut = messageOut;
            super.setMessageOut(messageOut);
        }

        public void setOutputType(int type) {
            if (type == 1) {
                this.setCodeGeneratorFactory(JavaBeansFactory.newInstance());
                this.setAttributesAsProperties(true);
            } else if (type == 0) {
                this.setCodeGeneratorFactory(null);
                this.setProcessComments(false);
            } else {
                throw new IllegalArgumentException("type != OUTPUT_JAVABEANS && type != OUTPUT_TRADITIONAL_BASEBEAN");
            }
        }

        public CodeGeneratorFactory getCodeGeneratorFactory() {
            if (super.getCodeGeneratorFactory() == null) {
                this.setCodeGeneratorFactory(BaseBeansFactory.newInstance());
            }
            return super.getCodeGeneratorFactory();
        }

        public void setPackagePath(String pkg) {
            pkg = pkg.equals(".") ? "" : pkg.replace('.', '/');
            super.setPackagePath(pkg);
        }

        public boolean isTrace() {
            return this.isTraceParse() || this.isTraceGen() || this.isTraceMisc();
        }

        public void setTraceGen(boolean value) {
            super.setTraceGen(value);
            DDLogFlags.debug = value;
        }

        void setIfNewerSourceTime(long t) {
            if (t > this.getNewestSourceTime()) {
                this.setNewestSourceTime(t);
            }
        }

        public Iterator readBeanGraphs() {
            return this.fetchReadBeanGraphsList().iterator();
        }

        public Iterator readBeanGraphFiles() {
            return this.fetchReadBeanGraphFilesList().iterator();
        }

        public int getSchemaTypeNum() {
            if ("xmlschema".equalsIgnoreCase(this.getSchemaType())) {
                return 0;
            }
            if ("dtd".equalsIgnoreCase(this.getSchemaType())) {
                return 1;
            }
            throw new IllegalStateException(Common.getMessage((String)"MSG_IllegalSchemaName", (Object)this.getSchemaType()));
        }

        public void setSchemaType(int type) {
            this.setSchemaTypeNum(type);
        }

        public void setSchemaTypeNum(int type) {
            if (type == 0) {
                this.setSchemaType("xmlschema");
            } else if (type == 1) {
                this.setSchemaType("dtd");
            } else {
                throw new IllegalStateException("illegal schema type: " + type);
            }
        }

        public void setMDDIn(InputStream value) {
            this.setMddIn(value);
        }

        public void setDTDIn(InputStream value) {
            this.setFileIn(value);
        }

        public void setRootDir(String dir) {
            this.setRootDir(new File(dir));
        }

        public void setForME(boolean value) {
            super.setForME(value);
            if (value) {
                this.setOutputType(1);
                this.setGeneratePropertyEvents(false);
                this.setIndexedPropertyType(null);
            }
        }

        public void buyPremium() {
            this.setStandalone(true);
            this.setDumpToString(true);
            this.setThrowErrors(true);
            this.setGenerateXMLIO(true);
            this.setGenerateValidate(true);
            this.setAttributesAsProperties(true);
            this.setGenerateInterfaces(true);
            this.setGenerateCommonInterface("CommonBean");
            this.setOutputType(1);
        }

        public void setMinFeatures(boolean value) {
            super.setMinFeatures(value);
            if (value) {
                this.setOutputType(1);
                this.setGenerateXMLIO(false);
                this.setGenerateValidate(false);
                this.setGenerateInterfaces(false);
                this.setGenerateCommonInterface(null);
                this.setGeneratePropertyEvents(false);
                this.setGenerateStoreEvents(false);
                this.setGenerateTransactions(false);
                this.setDefaultsAccessable(false);
                this.setKeepElementPositions(false);
                this.setRemoveUnreferencedNodes(true);
                this.setProcessComments(false);
                this.setProcessDocType(false);
                this.setGenerateParentRefs(false);
                this.setGenerateHasChanged(false);
            }
        }
    }

    public static class DefaultOutputStreamProvider
    implements OutputStreamProvider {
        private Config config;
        private List generatedFiles;

        public DefaultOutputStreamProvider(Config config) {
            this.config = config;
            this.generatedFiles = new LinkedList();
        }

        private String getFilename(String dir, String name, String extension) {
            return dir + "/" + name + "." + extension;
        }

        public OutputStream getStream(String dir, String name, String extension) throws IOException {
            String filename = this.getFilename(dir, name, extension);
            this.config.messageOut.println(Common.getMessage((String)"MSG_GeneratingClass", (Object)filename));
            this.generatedFiles.add(filename);
            return new FileOutputStream(filename);
        }

        public boolean isOlderThan(String dir, String name, String extension, long time) throws IOException {
            String filename = this.getFilename(dir, name, extension);
            File f = new File(filename);
            return f.lastModified() < time;
        }

        public List getGeneratedFiles() {
            return this.generatedFiles;
        }
    }

    public static interface OutputStreamProvider {
        public OutputStream getStream(String var1, String var2, String var3) throws IOException;

        public boolean isOlderThan(String var1, String var2, String var3, long var4) throws IOException;
    }
}

