/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.lime;

import com.sun.kvem.lime.Profiler;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class DeadlockProfiler
implements Profiler {
    private ThreadLocal trackingThreads = new ThreadLocal();
    private long threshold = 1000L;

    public DeadlockProfiler() {
        String string = System.getProperty("lime.profiler.threshold");
        if (string == null) {
            System.err.println("lime.profiler.threshold not defined, using default of " + this.threshold);
        } else {
            try {
                this.threshold = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("lime.profiler.threshold: " + string);
                System.err.println("Malformed threshold value,  using default of " + this.threshold);
            }
        }
    }

    public void profileMethodCallStart(Method method, Object[] objectArray) {
        TrackingThread trackingThread = (TrackingThread)this.trackingThreads.get();
        if (trackingThread == null) {
            trackingThread = new TrackingThread(this.threshold);
            this.trackingThreads.set(trackingThread);
            trackingThread.start();
        }
        trackingThread.enter(method);
    }

    public void profileMethodCallEnd(Method method, Object[] objectArray) {
        TrackingThread trackingThread = (TrackingThread)this.trackingThreads.get();
        trackingThread.exit();
    }

    public void writeReport(PrintWriter printWriter) {
    }

    private static class TrackingThread
    extends Thread {
        Method currentMethod;
        long threshold;

        TrackingThread(long l) {
            super("LIME Deadlock Profiler");
            this.threshold = l;
        }

        synchronized void enter(Method method) {
            this.currentMethod = method;
            this.notify();
        }

        synchronized void exit() {
            this.currentMethod = null;
            this.notify();
        }

        public synchronized void run() {
            while (true) {
                if (this.currentMethod == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                long l = System.currentTimeMillis();
                long l2 = l + this.threshold;
                long l3 = l;
                while (l3 < l2 && this.currentMethod != null) {
                    try {
                        this.wait(l2 - l3);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    l3 = System.currentTimeMillis();
                }
                if (this.currentMethod == null) continue;
                System.out.println("!!! Call to " + this.currentMethod + " has not completed after " + (l3 - l) + "ms");
                Method method = this.currentMethod;
                while (this.currentMethod != null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                l3 = System.currentTimeMillis();
                System.out.println("OK: Call to " + method + " has finally completed after " + (l3 - l) + "ms");
            }
        }
    }
}

