/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.lime;

import com.sun.kvem.lime.DataHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class CharBufferType
implements DataHandler {
    private ThreadLocal buffers = new ThreadLocal();

    public int getTypeNumber() {
        return 21;
    }

    public void writeData(DataOutputStream dataOutputStream, Object object) throws IOException {
        CharBuffer charBuffer = (CharBuffer)object;
        dataOutputStream.writeInt(charBuffer.remaining());
        while (charBuffer.hasRemaining()) {
            dataOutputStream.writeChar(charBuffer.get());
        }
    }

    public Object readData(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt() * 2;
        ByteBuffer byteBuffer = (ByteBuffer)this.buffers.get();
        if (byteBuffer == null || byteBuffer.capacity() < n) {
            byteBuffer = ByteBuffer.allocate(n);
            this.buffers.set(byteBuffer);
        }
        byteBuffer.rewind();
        byteBuffer.limit(n);
        ReadableByteChannel readableByteChannel = Channels.newChannel(dataInputStream);
        while (n > 0) {
            int n2 = readableByteChannel.read(byteBuffer);
            if (n2 == -1) {
                throw new IOException("Stream ended unexpectedly");
            }
            n -= n2;
        }
        byteBuffer.flip();
        return byteBuffer.asCharBuffer();
    }
}

