/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.lime;

import com.sun.kvem.lime.DataHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;

public class ArrayHandler
implements DataHandler {
    private DataHandler baseHandler;

    public ArrayHandler(DataHandler dataHandler) {
        this.baseHandler = dataHandler;
    }

    public int getTypeNumber() {
        return this.baseHandler.getTypeNumber() | 0x10;
    }

    public void writeData(DataOutputStream dataOutputStream, Object object) throws IOException {
        if (object == null) {
            dataOutputStream.writeInt(-1);
        } else {
            int n = Array.getLength(object);
            dataOutputStream.writeInt(n);
            int n2 = this.baseHandler.getTypeNumber();
            if (n2 == 1) {
                byte[] byArray = (byte[])object;
                dataOutputStream.write(byArray);
            } else {
                block6: for (int i = 0; i < n; ++i) {
                    switch (n2) {
                        case 3: {
                            int[] nArray = (int[])object;
                            dataOutputStream.writeInt(nArray[i]);
                            continue block6;
                        }
                        case 2: {
                            short[] sArray = (short[])object;
                            dataOutputStream.writeShort(sArray[i]);
                            continue block6;
                        }
                        case 5: {
                            char[] cArray = (char[])object;
                            dataOutputStream.writeChar(cArray[i]);
                            continue block6;
                        }
                        case 6: {
                            boolean[] blArray = (boolean[])object;
                            dataOutputStream.writeInt(blArray[i] ? 1 : 0);
                            continue block6;
                        }
                    }
                }
            }
        }
    }

    public Object readData(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == -1) {
            return null;
        }
        switch (this.baseHandler.getTypeNumber()) {
            case 6: {
                return this.readBoolArray(dataInputStream, n);
            }
            case 1: {
                return this.readByteArray(dataInputStream, n);
            }
            case 2: {
                return this.readShortArray(dataInputStream, n);
            }
            case 5: {
                return this.readCharArray(dataInputStream, n);
            }
            case 3: {
                return this.readIntArray(dataInputStream, n);
            }
            case 4: {
                return this.readLongArray(dataInputStream, n);
            }
        }
        throw new RuntimeException("Unknown Lime array element type " + this.baseHandler.getTypeNumber());
    }

    private boolean[] readBoolArray(DataInputStream dataInputStream, int n) throws IOException {
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readInt();
            blArray[i] = n2 != 0;
        }
        return blArray;
    }

    private byte[] readByteArray(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        for (int i = n; i > 0; i -= n2) {
            n2 = dataInputStream.read(byArray, n - i, i);
            if (n2 != -1) continue;
            throw new IOException("Unexpected end of stream");
        }
        return byArray;
    }

    private short[] readShortArray(DataInputStream dataInputStream, int n) throws IOException {
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = dataInputStream.readShort();
        }
        return sArray;
    }

    private char[] readCharArray(DataInputStream dataInputStream, int n) throws IOException {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = dataInputStream.readChar();
        }
        return cArray;
    }

    private int[] readIntArray(DataInputStream dataInputStream, int n) throws IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        return nArray;
    }

    private long[] readLongArray(DataInputStream dataInputStream, int n) throws IOException {
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = dataInputStream.readLong();
        }
        return lArray;
    }
}

