/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.lime.DataHandler;
import com.sun.kvem.lime.DataManager;
import com.sun.kvem.lime.NullProfiler;
import com.sun.kvem.lime.Profiler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public class Lime {
    private ServerSocket commandServer;
    private ServerSocket eventServer;
    private Socket eventSocket;
    private DataOutputStream eventOutput;
    private Vector commands = new Vector();
    private static boolean debug = Boolean.getBoolean("lime.debug");
    private Object lock = new Object();
    private Profiler profiler = this.createProfiler();
    private boolean connected = false;

    private Profiler createProfiler() {
        String string = System.getProperty("lime.profiler", "com.sun.kvem.lime.NullProfiler");
        try {
            return (Profiler)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.err.println("Cannot instantiate LIME profiler " + string + "'");
            return new NullProfiler();
        }
    }

    public Process runClient(String string, String[] stringArray) throws IOException {
        return this.runClient(string, stringArray, null);
    }

    public Process runClient(String string, String[] stringArray, String[] stringArray2) throws IOException {
        return this.runClient(string, stringArray, stringArray2, new File(System.getProperty("user.dir")));
    }

    public Process runClient(String string, String[] stringArray, String[] stringArray2, File file) throws IOException {
        this.commandServer = new ServerSocket(0);
        this.eventServer = new ServerSocket(0);
        int n = this.commandServer.getLocalPort();
        int n2 = this.eventServer.getLocalPort();
        String[] stringArray3 = new String[]{"LIME_TRACE=" + (debug ? 1 : 0), "COMMAND_PORT=" + n, "EVENT_PORT=" + n2, "--"};
        int n3 = stringArray2 == null ? 0 : stringArray2.length;
        String[] stringArray4 = new String[1 + n3 + stringArray3.length + stringArray.length];
        stringArray4[0] = string;
        if (stringArray2 != null) {
            System.arraycopy(stringArray2, 0, stringArray4, 1, n3);
        }
        System.arraycopy(stringArray3, 0, stringArray4, 1 + n3, stringArray3.length);
        System.arraycopy(stringArray, 0, stringArray4, 1 + n3 + stringArray3.length, stringArray.length);
        if (debug) {
            for (int i = 0; i < stringArray4.length; ++i) {
                System.out.println("argv[" + i + "] = " + stringArray4[i]);
            }
            System.out.flush();
        }
        Server server = new Server();
        this.connected = true;
        new Thread((Runnable)server, "LIME Connection").start();
        String string2 = System.getProperty("kvm.use_library", "false");
        if (string2.compareToIgnoreCase("true") == 0) {
            return new FakeProcess(stringArray4);
        }
        return Runtime.getRuntime().exec(stringArray4, null, file);
    }

    public synchronized void disconnect() {
        if (this.connected) {
            block13: {
                block12: {
                    block11: {
                        if (debug) {
                            System.out.println("LIME: disconnect");
                        }
                        if (this.eventServer != null) {
                            try {
                                this.eventServer.close();
                            }
                            catch (IOException iOException) {
                                if (!debug) break block11;
                                iOException.printStackTrace();
                            }
                        }
                    }
                    if (this.eventSocket != null) {
                        try {
                            this.eventSocket.close();
                        }
                        catch (IOException iOException) {
                            if (!debug) break block12;
                            iOException.printStackTrace();
                        }
                    }
                }
                if (this.eventOutput != null) {
                    try {
                        this.eventOutput.close();
                    }
                    catch (IOException iOException) {
                        if (!debug) break block13;
                        iOException.printStackTrace();
                    }
                }
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            PrintWriter printWriter = new PrintWriter(outputStreamWriter);
            this.profiler.writeReport(printWriter);
            printWriter.flush();
            this.connected = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementEventCount() {
        block12: {
            if (debug) {
                System.out.println("LIME: generated event at " + System.currentTimeMillis() + "ms");
            }
            if (!this.connected) {
                return;
            }
            try {
                Object object = this.lock;
                synchronized (object) {
                    while (this.eventOutput == null) {
                        this.lock.wait();
                    }
                    this.eventOutput.write(0);
                    this.eventOutput.flush();
                }
            }
            catch (IOException iOException) {
                if (debug) {
                    iOException.printStackTrace();
                }
            }
            catch (NullPointerException nullPointerException) {
                if (debug) {
                    nullPointerException.printStackTrace();
                }
            }
            catch (InterruptedException interruptedException) {
                if (!debug) break block12;
                interruptedException.printStackTrace();
            }
        }
    }

    public Object getLock() {
        return this.lock;
    }

    private class Connection
    implements Runnable {
        private DataInputStream commandInput;
        private DataOutputStream commandOutput;
        private static final int MAX_ARGS = 32;
        private Object[][] buffers;

        Connection(InputStream inputStream, OutputStream outputStream) {
            this.commandInput = new DataInputStream(new BufferedInputStream(inputStream));
            this.commandOutput = new DataOutputStream(new BufferedOutputStream(outputStream));
            this.buffers = new Object[32][];
            for (int i = 0; i < this.buffers.length; ++i) {
                this.buffers[i] = new Object[i];
            }
        }

        public void run() {
            try {
                while (true) {
                    this.processCommand();
                }
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            try {
                this.commandInput.close();
                this.commandOutput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private String readCommandLine() throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            char c;
            while ((c = (char)this.commandInput.read()) != '\n' && c != '\r') {
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }

        private int readCommandInt() throws IOException {
            return this.commandInput.readInt();
        }

        private void writeCommandInt(int n) throws IOException {
            this.commandOutput.writeInt(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processCommand() throws IOException {
            int n = this.readCommandInt();
            switch (n) {
                case 1: {
                    Object object = Lime.this.lock;
                    synchronized (object) {
                        String string = this.readCommandLine().trim();
                        String string2 = this.readCommandLine().trim();
                        String string3 = this.readCommandLine().trim();
                        int n2 = this.lookup(string, string2, string3);
                        this.writeCommandInt(n2);
                        this.writeMethodData(n2);
                        this.commandOutput.flush();
                        break;
                    }
                }
                case 2: {
                    Object object = Lime.this.lock;
                    synchronized (object) {
                        int n3 = this.readCommandInt();
                        Method method = (Method)Lime.this.commands.elementAt(n3);
                        Object[] objectArray = this.getArguments(method);
                        this.callMethod(method, objectArray);
                        this.commandOutput.flush();
                        break;
                    }
                }
                default: {
                    System.err.println("Unrecognised LIME command: " + n);
                }
            }
        }

        private int lookup(String string, String string2, String string3) throws IOException {
            String string4 = string.length() == 0 ? string2 : string + "." + string2;
            try {
                int n;
                Class<?> clazz = Class.forName(string4);
                Method[] methodArray = clazz.getMethods();
                Method method = null;
                for (n = 0; n < methodArray.length; ++n) {
                    if (!methodArray[n].getName().equals(string3) || !Modifier.isStatic(methodArray[n].getModifiers())) continue;
                    method = methodArray[n];
                    break;
                }
                if (method == null) {
                    System.err.println("LIME method '" + string3 + "' not found" + " in class '" + string4 + "'");
                    return -1;
                }
                n = Lime.this.commands.indexOf(method);
                if (n == -1) {
                    n = Lime.this.commands.size();
                    Lime.this.commands.addElement(method);
                }
                return n;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("LIME class '" + string4 + "' not found.");
                return -1;
            }
        }

        private void writeMethodData(int n) throws IOException {
            Method method = (Method)Lime.this.commands.elementAt(n);
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> clazz = method.getReturnType();
            this.writeCommandInt(classArray.length);
            for (int i = 0; i < classArray.length; ++i) {
                DataHandler dataHandler = DataManager.getManager().getHandler(classArray[i]);
                this.writeCommandInt(dataHandler.getTypeNumber());
            }
            DataHandler dataHandler = DataManager.getManager().getHandler(clazz);
            this.writeCommandInt(dataHandler.getTypeNumber());
        }

        private Object[] getArguments(Method method) throws IOException {
            Class<?>[] classArray = method.getParameterTypes();
            Object[] objectArray = this.buffers[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                DataHandler dataHandler = DataManager.getManager().getHandler(classArray[i]);
                objectArray[i] = dataHandler.readData(this.commandInput);
            }
            return objectArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void callMethod(Method method, Object[] objectArray) throws IOException {
            block12: {
                try {
                    Lime.this.profiler.profileMethodCallStart(method, objectArray);
                    Object object = method.invoke(null, objectArray);
                    Class<?> clazz = method.getReturnType();
                    if (clazz == Void.TYPE) break block12;
                    Object object2 = Lime.this.lock;
                    synchronized (object2) {
                        if (object == null) {
                            this.writeCommandInt(-1);
                        } else {
                            DataHandler dataHandler = DataManager.getManager().getHandler(clazz);
                            dataHandler.writeData(this.commandOutput, object);
                        }
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.getTargetException().printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.err.println("Cannot access method " + method);
                }
                finally {
                    Lime.this.profiler.profileMethodCallEnd(method, objectArray);
                }
            }
        }
    }

    private class Server
    implements Runnable {
        private Server() {
        }

        public void run() {
            try {
                Lime.this.eventSocket = Lime.this.eventServer.accept();
                Lime.this.eventSocket.setTcpNoDelay(true);
                Lime.this.eventOutput = new DataOutputStream(new BufferedOutputStream(Lime.this.eventSocket.getOutputStream()));
                Lime.this.commandServer.setSoTimeout(3000);
                while (Lime.this.connected) {
                    try {
                        this.acceptConnection();
                    }
                    catch (InterruptedIOException interruptedIOException) {}
                }
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            Lime.this.disconnect();
        }

        private void acceptConnection() throws IOException {
            Socket socket = Lime.this.commandServer.accept();
            socket.setTcpNoDelay(true);
            socket.setSoTimeout(0);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            Connection connection = new Connection(inputStream, outputStream);
            if (debug) {
                System.out.println("New Lime connection");
            }
            new Thread(connection).start();
        }
    }

    private class FakeProcess
    extends Process
    implements Runnable {
        Integer result;
        String[] argv;

        FakeProcess(String[] stringArray) {
            this.argv = stringArray;
            System.loadLibrary("zayit");
            new Thread(this).start();
        }

        public native void run();

        public void destroy() {
        }

        public int exitValue() {
            return this.result;
        }

        public InputStream getErrorStream() {
            return new ByteArrayInputStream(new byte[0]);
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(new byte[0]);
        }

        public OutputStream getOutputStream() {
            return null;
        }

        public int waitFor() {
            System.out.println("waiting for the process");
            while (this.result == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return this.result;
        }
    }
}

