/*
 * Decompiled with CFR 0.152.
 */
package javax.media.protocol;

import java.io.IOException;
import java.io.InputStream;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;

public class InputSourceStream
implements PullSourceStream {
    protected InputStream stream;
    protected boolean eosReached;
    ContentDescriptor contentType;

    public InputSourceStream(InputStream inputStream, ContentDescriptor contentDescriptor) {
        this.stream = inputStream;
        this.eosReached = false;
        this.contentType = contentDescriptor;
    }

    public ContentDescriptor getContentDescriptor() {
        return this.contentType;
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean willReadBlock() {
        if (this.eosReached) {
            return true;
        }
        try {
            return this.stream.available() == 0;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.stream.read(byArray, n, n2);
        if (n3 == -1) {
            this.eosReached = true;
        }
        return n3;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public boolean endOfStream() {
        return this.eosReached;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String string) {
        return null;
    }
}

