/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;

public class RGBFormat
extends VideoFormat {
    protected int redMask = -1;
    protected int greenMask = -1;
    protected int blueMask = -1;
    protected int bitsPerPixel = -1;
    protected int pixelStride = -1;
    protected int lineStride = -1;
    protected int flipped = -1;
    protected int endian = -1;
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;
    private static String ENCODING = "rgb";

    public RGBFormat() {
        super(ENCODING);
        this.dataType = null;
    }

    public RGBFormat(Dimension dimension, int n, Class clazz, float f, int n2, int n3, int n4, int n5) {
        super(ENCODING, dimension, n, clazz, f);
        this.bitsPerPixel = n2;
        this.redMask = n3;
        this.greenMask = n4;
        this.blueMask = n5;
        if (n2 != -1 && clazz != null) {
            this.pixelStride = n2 / 8;
            if (clazz != byteArray) {
                this.pixelStride = 1;
            }
        } else {
            this.pixelStride = -1;
        }
        this.lineStride = dimension != null && this.pixelStride != -1 ? this.pixelStride * dimension.width : -1;
        this.flipped = 0;
        this.endian = n2 == 16 && clazz == byteArray ? 1 : -1;
    }

    public RGBFormat(Dimension dimension, int n, Class clazz, float f, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        super(ENCODING, dimension, n, clazz, f);
        this.bitsPerPixel = n2;
        this.redMask = n3;
        this.greenMask = n4;
        this.blueMask = n5;
        this.pixelStride = n6;
        this.lineStride = n7;
        this.flipped = n8;
        this.endian = n9;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public int getRedMask() {
        return this.redMask;
    }

    public int getGreenMask() {
        return this.greenMask;
    }

    public int getBlueMask() {
        return this.blueMask;
    }

    public int getPixelStride() {
        return this.pixelStride;
    }

    public int getLineStride() {
        return this.lineStride;
    }

    public int getFlipped() {
        return this.flipped;
    }

    public int getEndian() {
        return this.endian;
    }

    public Object clone() {
        RGBFormat rGBFormat = new RGBFormat(this.size, this.maxDataLength, this.dataType, this.frameRate, this.bitsPerPixel, this.redMask, this.greenMask, this.blueMask, this.pixelStride, this.lineStride, this.flipped, this.endian);
        rGBFormat.copy(this);
        return rGBFormat;
    }

    protected void copy(Format format) {
        super.copy(format);
        if (format instanceof RGBFormat) {
            RGBFormat rGBFormat = (RGBFormat)format;
            this.bitsPerPixel = rGBFormat.bitsPerPixel;
            this.redMask = rGBFormat.redMask;
            this.greenMask = rGBFormat.greenMask;
            this.blueMask = rGBFormat.blueMask;
            this.pixelStride = rGBFormat.pixelStride;
            this.lineStride = rGBFormat.lineStride;
            this.flipped = rGBFormat.flipped;
            this.endian = rGBFormat.endian;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof RGBFormat) {
            RGBFormat rGBFormat = (RGBFormat)object;
            return super.equals(object) && this.bitsPerPixel == rGBFormat.bitsPerPixel && this.redMask == rGBFormat.redMask && this.greenMask == rGBFormat.greenMask && this.blueMask == rGBFormat.blueMask && this.pixelStride == rGBFormat.pixelStride && this.lineStride == rGBFormat.lineStride && this.endian == rGBFormat.endian && this.flipped == rGBFormat.flipped;
        }
        return false;
    }

    public boolean matches(Format format) {
        if (!super.matches(format)) {
            return false;
        }
        if (!(format instanceof RGBFormat)) {
            return true;
        }
        RGBFormat rGBFormat = (RGBFormat)format;
        boolean bl = !(this.bitsPerPixel != -1 && rGBFormat.bitsPerPixel != -1 && this.bitsPerPixel != rGBFormat.bitsPerPixel || this.redMask != -1 && rGBFormat.redMask != -1 && this.redMask != rGBFormat.redMask || this.greenMask != -1 && rGBFormat.greenMask != -1 && this.greenMask != rGBFormat.greenMask || this.blueMask != -1 && rGBFormat.blueMask != -1 && this.blueMask != rGBFormat.blueMask || this.pixelStride != -1 && rGBFormat.pixelStride != -1 && this.pixelStride != rGBFormat.pixelStride || this.endian != -1 && rGBFormat.endian != -1 && this.endian != rGBFormat.endian || this.flipped != -1 && rGBFormat.flipped != -1 && this.flipped != rGBFormat.flipped);
        return bl;
    }

    public Format intersects(Format format) {
        Format format2 = super.intersects(format);
        if (format2 == null) {
            return null;
        }
        if (!(format instanceof RGBFormat)) {
            return format2;
        }
        RGBFormat rGBFormat = (RGBFormat)format;
        RGBFormat rGBFormat2 = (RGBFormat)format2;
        rGBFormat2.bitsPerPixel = this.bitsPerPixel != -1 ? this.bitsPerPixel : rGBFormat.bitsPerPixel;
        rGBFormat2.pixelStride = this.pixelStride != -1 ? this.pixelStride : rGBFormat.pixelStride;
        rGBFormat2.lineStride = this.lineStride != -1 ? this.lineStride : rGBFormat.lineStride;
        rGBFormat2.redMask = this.redMask != -1 ? this.redMask : rGBFormat.redMask;
        rGBFormat2.greenMask = this.greenMask != -1 ? this.greenMask : rGBFormat.greenMask;
        rGBFormat2.blueMask = this.blueMask != -1 ? this.blueMask : rGBFormat.blueMask;
        rGBFormat2.flipped = this.flipped != -1 ? this.flipped : rGBFormat.flipped;
        rGBFormat2.endian = this.endian != -1 ? this.endian : rGBFormat.endian;
        return rGBFormat2;
    }

    public Format relax() {
        RGBFormat rGBFormat = (RGBFormat)super.relax();
        if (rGBFormat == null) {
            return null;
        }
        rGBFormat.lineStride = -1;
        rGBFormat.pixelStride = -1;
        return rGBFormat;
    }

    public String toString() {
        String string = this.getEncoding().toUpperCase();
        if (this.size != null) {
            string = string + ", " + this.size.width + "x" + this.size.height;
        }
        if (this.frameRate != -1.0f) {
            string = string + ", FrameRate=" + (float)((int)(this.frameRate * 10.0f)) / 10.0f;
        }
        if (this.maxDataLength != -1) {
            string = string + ", Length=" + this.maxDataLength;
        }
        string = string + ", " + this.bitsPerPixel + "-bit";
        string = string + ", Masks=" + this.redMask + ":" + this.greenMask + ":" + this.blueMask;
        if (this.pixelStride != 1) {
            string = string + ", PixelStride=" + this.pixelStride;
        }
        string = string + ", LineStride=" + this.lineStride;
        if (this.flipped != -1) {
            string = string + (this.flipped == 1 ? ", Flipped" : "");
        }
        if (this.dataType == byteArray && this.bitsPerPixel == 16 && this.endian != -1) {
            string = string + (this.endian == 0 ? ", BigEndian" : ", LittleEndian");
        }
        if (this.dataType != null && this.dataType != Format.byteArray) {
            string = string + ", " + this.dataType;
        }
        return string;
    }
}

