/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import java.io.Serializable;

public class Format
implements Cloneable,
Serializable {
    public static final int NOT_SPECIFIED = -1;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    protected String encoding;
    public static final Class intArray = new int[0].getClass();
    public static final Class shortArray = new short[0].getClass();
    public static final Class byteArray = new byte[0].getClass();
    public static final Class formatArray = new Format[0].getClass();
    protected Class dataType = byteArray;
    protected Class clz = this.getClass();
    private long encodingCode = 0L;

    public Format(String string) {
        this.encoding = string;
    }

    public Format(String string, Class clazz) {
        this(string);
        this.dataType = clazz;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Class getDataType() {
        return this.dataType;
    }

    public boolean equals(Object object) {
        if (object == null || this.clz != ((Format)object).clz) {
            return false;
        }
        String string = ((Format)object).encoding;
        Class clazz = ((Format)object).dataType;
        return this.dataType == clazz && (this.encoding == string || this.encoding != null && string != null && this.isSameEncoding((Format)object));
    }

    public boolean matches(Format format) {
        if (format == null) {
            return false;
        }
        return !(format.encoding != null && this.encoding != null && !this.isSameEncoding(format) || format.dataType != null && this.dataType != null && format.dataType != this.dataType || !this.clz.isAssignableFrom(format.clz) && !format.clz.isAssignableFrom(this.clz));
    }

    public Format intersects(Format format) {
        Format format2;
        if (this.clz.isAssignableFrom(format.clz)) {
            format2 = (Format)format.clone();
        } else if (format.clz.isAssignableFrom(this.clz)) {
            format2 = (Format)this.clone();
        } else {
            return null;
        }
        if (format2.encoding == null) {
            String string = format2.encoding = this.encoding != null ? this.encoding : format.encoding;
        }
        if (format2.dataType == null) {
            format2.dataType = this.dataType != null ? this.dataType : format.dataType;
        }
        return format2;
    }

    public boolean isSameEncoding(Format format) {
        if (this.encoding == null || format == null || format.encoding == null) {
            return false;
        }
        if (this.encoding == format.encoding) {
            return true;
        }
        if (this.encodingCode > 0L && format.encodingCode > 0L) {
            return this.encodingCode == format.encodingCode;
        }
        if (this.encoding.length() > 10) {
            return this.encoding.equalsIgnoreCase(format.encoding);
        }
        if (this.encodingCode == 0L) {
            this.encodingCode = this.getEncodingCode(this.encoding);
        }
        if (this.encodingCode <= 0L) {
            return this.encoding.equalsIgnoreCase(format.encoding);
        }
        if (format.encodingCode == 0L) {
            return format.isSameEncoding(this);
        }
        return this.encodingCode == format.encodingCode;
    }

    public boolean isSameEncoding(String string) {
        if (this.encoding == null || string == null) {
            return false;
        }
        if (this.encoding == string) {
            return true;
        }
        if (this.encoding.length() > 10) {
            return this.encoding.equalsIgnoreCase(string);
        }
        if (this.encodingCode == 0L) {
            this.encodingCode = this.getEncodingCode(this.encoding);
        }
        if (this.encodingCode < 0L) {
            return this.encoding.equalsIgnoreCase(string);
        }
        long l = this.getEncodingCode(string);
        return this.encodingCode == l;
    }

    private long getEncodingCode(String string) {
        byte[] byArray = string.getBytes();
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            byte by = byArray[i];
            if (by > 96 && by < 123) {
                by = (byte)(by - 32);
            }
            if ((by = (byte)(by - 32)) > 63) {
                return -1L;
            }
            l = l << 6 | (long)by;
        }
        return l;
    }

    public Format relax() {
        return (Format)this.clone();
    }

    public Object clone() {
        Format format = new Format(this.encoding);
        format.copy(this);
        return format;
    }

    protected void copy(Format format) {
        this.dataType = format.dataType;
    }

    public String toString() {
        return this.getEncoding();
    }
}

