/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.vfw;

import com.sun.media.format.AviVideoFormat;
import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class BitMapInfo {
    public int biWidth = 0;
    public int biHeight = 0;
    public int biPlanes = 1;
    public int biBitCount = 24;
    public String fourcc = "";
    public int biSizeImage = 0;
    public int biXPelsPerMeter = 0;
    public int biYPelsPerMeter = 0;
    public int biClrUsed = 0;
    public int biClrImportant = 0;
    public int extraSize = 0;
    public byte[] extraBytes = null;
    static /* synthetic */ Class array$B;

    public BitMapInfo() {
    }

    public BitMapInfo(String string, int n, int n2) {
        this.biWidth = n;
        this.biHeight = n2;
        this.fourcc = string;
        if (string.equals("RGB")) {
            this.biSizeImage = n * n2 * 3;
        }
        if (string.equals("MSVC")) {
            this.fourcc = "CRAM";
        }
    }

    public BitMapInfo(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this(string, n, n2);
        this.biPlanes = n3;
        this.biBitCount = n4;
        this.biSizeImage = n5;
        this.biClrUsed = n6;
        this.biClrImportant = n7;
    }

    public BitMapInfo(VideoFormat videoFormat) {
        Class clazz;
        Dimension dimension = videoFormat.getSize();
        if (dimension == null) {
            dimension = new Dimension(320, 240);
        }
        int n = (clazz = videoFormat.getDataType()) == Format.byteArray ? 1 : (clazz == Format.intArray ? 4 : 2);
        this.biWidth = dimension.width;
        this.biHeight = dimension.height;
        this.biPlanes = 1;
        this.biSizeImage = videoFormat.getMaxDataLength() * n;
        this.fourcc = videoFormat.getEncoding();
        if (this.fourcc.equalsIgnoreCase("msvc")) {
            this.fourcc = "CRAM";
        }
        if (videoFormat instanceof AviVideoFormat) {
            AviVideoFormat aviVideoFormat = (AviVideoFormat)videoFormat;
            this.biPlanes = aviVideoFormat.getPlanes();
            this.biBitCount = aviVideoFormat.getBitsPerPixel();
            this.biXPelsPerMeter = aviVideoFormat.getXPelsPerMeter();
            this.biYPelsPerMeter = aviVideoFormat.getYPelsPerMeter();
            this.biClrUsed = aviVideoFormat.getClrUsed();
            this.biClrImportant = aviVideoFormat.getClrImportant();
            this.extraBytes = aviVideoFormat.getCodecSpecificHeader();
            if (this.extraBytes != null) {
                this.extraSize = this.extraBytes.length;
            }
        } else if (videoFormat instanceof RGBFormat) {
            RGBFormat rGBFormat = (RGBFormat)videoFormat;
            this.fourcc = "RGB";
            this.biBitCount = rGBFormat.getBitsPerPixel();
            if (rGBFormat.getFlipped() == 0) {
                this.biHeight = -this.biHeight;
            }
        } else if (videoFormat instanceof YUVFormat) {
            YUVFormat yUVFormat = (YUVFormat)videoFormat;
            switch (yUVFormat.getYuvType()) {
                case 2: {
                    this.fourcc = yUVFormat.getOffsetU() < yUVFormat.getOffsetV() ? "I420" : "YV12";
                }
                case 32: {
                    if (yUVFormat.getOffsetY() == 0 && yUVFormat.getOffsetU() == 1) {
                        this.fourcc = "YUY2";
                        break;
                    }
                    if (yUVFormat.getOffsetY() == 0 && yUVFormat.getOffsetU() == 3) {
                        this.fourcc = "YVYU";
                        break;
                    }
                    if (yUVFormat.getOffsetU() != 0) break;
                    this.fourcc = "UYVY";
                }
            }
            if (this.fourcc.equalsIgnoreCase("yv12") || this.fourcc.equalsIgnoreCase("i420") || this.fourcc.equalsIgnoreCase("y411")) {
                this.biBitCount = 12;
            } else if (this.fourcc.equalsIgnoreCase("yuy2")) {
                this.biBitCount = 16;
            }
        }
    }

    public VideoFormat createVideoFormat(Class clazz) {
        return this.createVideoFormat(clazz, -1.0f);
    }

    public VideoFormat createVideoFormat(Class clazz, float f) {
        VideoFormat videoFormat;
        if (this.fourcc.equalsIgnoreCase("rgb")) {
            int n = clazz == Format.byteArray ? 1 : (clazz == Format.intArray ? 4 : 2);
            int n2 = this.biSizeImage / n;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            if (this.biBitCount == 16) {
                n3 = 31744;
                n4 = 992;
                n5 = 31;
            } else if (this.biBitCount == 32) {
                if (n == 4) {
                    n3 = 0xFF0000;
                    n4 = 65280;
                    n5 = 255;
                } else {
                    n3 = 3;
                    n4 = 2;
                    n5 = 1;
                }
            } else if (this.biBitCount == 24) {
                n3 = 3;
                n4 = 2;
                n5 = 1;
            }
            int n6 = this.biWidth * this.biBitCount / 8;
            int n7 = n6 / n;
            int n8 = n7 / this.biWidth;
            int n9 = this.biHeight;
            int n10 = 1;
            if (this.biHeight < 0) {
                n9 = -n9;
                n10 = 0;
            }
            videoFormat = new RGBFormat(new Dimension(this.biWidth, n9), n2, clazz, f, this.biBitCount, n3, n4, n5, n8, n7, n10, 1);
        } else if (this.fourcc.equalsIgnoreCase("yuy2")) {
            int n = this.biWidth * this.biHeight;
            videoFormat = new YUVFormat(new Dimension(this.biWidth, this.biHeight), this.biSizeImage, array$B == null ? (array$B = BitMapInfo.class$("[B")) : array$B, f, 32, this.biWidth * 2, this.biWidth * 2, 0, 1, 3);
        } else if (this.fourcc.equalsIgnoreCase("i420")) {
            int n = this.biWidth * this.biHeight;
            videoFormat = new YUVFormat(new Dimension(this.biWidth, this.biHeight), this.biSizeImage, array$B == null ? (array$B = BitMapInfo.class$("[B")) : array$B, f, 2, this.biWidth, this.biWidth / 2, 0, n, n + n / 4);
        } else if (this.fourcc.equalsIgnoreCase("yv12")) {
            int n = this.biWidth * this.biHeight;
            videoFormat = new YUVFormat(new Dimension(this.biWidth, this.biHeight), this.biSizeImage, array$B == null ? (array$B = BitMapInfo.class$("[B")) : array$B, f, 2, this.biWidth, this.biWidth / 2, 0, n + n / 4, n);
        } else {
            videoFormat = new AviVideoFormat(this.fourcc, new Dimension(this.biWidth, this.biHeight), this.biSizeImage, clazz, f, this.biPlanes, this.biBitCount, this.biSizeImage, this.biXPelsPerMeter, this.biYPelsPerMeter, this.biClrUsed, this.biClrImportant, this.extraBytes);
        }
        return videoFormat;
    }

    public String toString() {
        String string = "Size = " + this.biWidth + " x " + this.biHeight + "\t" + "Planes = " + this.biPlanes + "\t" + "BitCount = " + this.biBitCount + "\t" + "FourCC = " + this.fourcc + "\t" + "SizeImage = " + this.biSizeImage + "\n" + "ClrUsed = " + this.biClrUsed + "\n" + "ClrImportant = " + this.biClrImportant + "\n" + "ExtraSize = " + this.extraSize + "\n";
        if (this.extraSize > 0) {
            for (int i = 0; i < this.extraSize; ++i) {
                string = string + "\t" + i + " = " + this.extraBytes[i] + "\n";
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

