/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.util.FormatTable;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12PropertyAction;
import com.sun.media.util.jdk12ReadFileAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;

public class Resource {
    private static Hashtable hash;
    private static String filename;
    private static final int versionNumber = 200;
    private static boolean securityPrivelege;
    private static JMFSecurity jmfSecurity;
    private static Method[] m;
    private static Class[] cl;
    private static Object[][] args;
    private static final String USERHOME = "user.home";
    private static String userhome;
    static FormatTable audioFmtTbl;
    static FormatTable videoFmtTbl;
    static FormatTable miscFmtTbl;
    static Object fmtTblSync;
    static int AUDIO_TBL_SIZE;
    static int VIDEO_TBL_SIZE;
    static int MISC_TBL_SIZE;
    static String AUDIO_SIZE_KEY;
    static String AUDIO_INPUT_KEY;
    static String AUDIO_FORMAT_KEY;
    static String AUDIO_HIT_KEY;
    static String VIDEO_SIZE_KEY;
    static String VIDEO_INPUT_KEY;
    static String VIDEO_FORMAT_KEY;
    static String VIDEO_HIT_KEY;
    static String MISC_SIZE_KEY;
    static String MISC_INPUT_KEY;
    static String MISC_FORMAT_KEY;
    static String MISC_HIT_KEY;
    static boolean needSaving;

    public static final synchronized void reset() {
        hash = new Hashtable();
    }

    public static final synchronized boolean set(String string, Object object) {
        if (string != null && object != null) {
            if (jmfSecurity != null && string.indexOf("secure.") == 0) {
                return false;
            }
            hash.put(string, object);
            return true;
        }
        return false;
    }

    public static final synchronized Object get(String string) {
        if (string != null) {
            return hash.get(string);
        }
        return null;
    }

    public static final synchronized boolean remove(String string) {
        if (string != null && hash.containsKey(string)) {
            hash.remove(string);
            return true;
        }
        return false;
    }

    public static final synchronized void removeGroup(String string) {
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            Enumeration enumeration = hash.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith(string)) continue;
                vector.addElement(string2);
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            hash.remove(vector.elementAt(i));
        }
    }

    public static final synchronized boolean commit() throws IOException {
        if (filename == null) {
            throw new IOException("Can't find resource file");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(filename);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        int n = hash.size();
        objectOutputStream.writeInt(n);
        objectOutputStream.writeInt(200);
        Enumeration enumeration = hash.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = hash.get(string);
            objectOutputStream.writeUTF(string);
            objectOutputStream.writeObject(v);
            objectOutputStream.flush();
        }
        objectOutputStream.close();
        return true;
    }

    public static final synchronized void destroy() {
        if (filename == null) {
            return;
        }
        try {
            File file = new File(filename);
            file.delete();
        }
        catch (Throwable throwable) {
            filename = null;
        }
    }

    private static final synchronized InputStream findResourceFile() {
        String string = ".jmf-resource";
        File file = null;
        FileInputStream fileInputStream = null;
        if (userhome == null) {
            return null;
        }
        try {
            filename = userhome + File.separator + string;
            file = new File(filename);
            fileInputStream = Resource.getResourceStream(file);
        }
        catch (Throwable throwable) {
            filename = null;
            return null;
        }
        return fileInputStream;
    }

    private static final FileInputStream getResourceStream(File file) throws IOException {
        try {
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor constructor = jdk12ReadFileAction.cons;
                return (FileInputStream)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(file.getPath()));
            }
            if (!file.exists()) {
                return null;
            }
            return new FileInputStream(file.getPath());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static final synchronized boolean readResource(InputStream inputStream) {
        if (inputStream == null) {
            return false;
        }
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            int n = objectInputStream.readInt();
            int n2 = objectInputStream.readInt();
            if (n2 > 200) {
                System.err.println("Version number mismatch.\nThere could be errors in reading the resource");
            }
            hash = new Hashtable();
            for (int i = 0; i < n; ++i) {
                String string = objectInputStream.readUTF();
                boolean bl = false;
                try {
                    Object object = objectInputStream.readObject();
                    hash.put(string, object);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl = true;
                    continue;
                }
                catch (OptionalDataException optionalDataException) {
                    bl = true;
                }
            }
            objectInputStream.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("IOException in readResource: " + iOException);
        }
        finally {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void initDB() {
        Object object = fmtTblSync;
        synchronized (object) {
            audioFmtTbl = new FormatTable(AUDIO_TBL_SIZE);
            videoFmtTbl = new FormatTable(VIDEO_TBL_SIZE);
            miscFmtTbl = new FormatTable(MISC_TBL_SIZE);
            Resource.loadDB();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void purgeDB() {
        Object object = fmtTblSync;
        synchronized (object) {
            if (audioFmtTbl == null) {
                return;
            }
            audioFmtTbl = new FormatTable(AUDIO_TBL_SIZE);
            videoFmtTbl = new FormatTable(VIDEO_TBL_SIZE);
            miscFmtTbl = new FormatTable(MISC_TBL_SIZE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Format[] getDB(Format format) {
        Object object = fmtTblSync;
        synchronized (object) {
            if (audioFmtTbl == null) {
                Resource.initDB();
            }
            if (format instanceof AudioFormat) {
                return audioFmtTbl.get(format);
            }
            if (format instanceof VideoFormat) {
                return videoFmtTbl.get(format);
            }
            return miscFmtTbl.get(format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Format[] putDB(Format format, Format[] formatArray) {
        Object object = fmtTblSync;
        synchronized (object) {
            Format format2 = format.relax();
            Format[] formatArray2 = new Format[formatArray.length];
            for (int i = 0; i < formatArray.length; ++i) {
                formatArray2[i] = formatArray[i].relax();
            }
            if (format2 instanceof AudioFormat) {
                audioFmtTbl.save(format2, formatArray2);
            } else if (format2 instanceof VideoFormat) {
                videoFmtTbl.save(format2, formatArray2);
            } else {
                miscFmtTbl.save(format2, formatArray2);
            }
            needSaving = true;
            return formatArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void loadDB() {
        Object object = fmtTblSync;
        synchronized (object) {
            Object object2;
            Object object3;
            int n;
            Object object4 = Resource.get(AUDIO_SIZE_KEY);
            int n2 = object4 instanceof Integer ? (Integer)object4 : 0;
            if (n2 > AUDIO_TBL_SIZE) {
                System.err.println("Resource file is corrupted");
                n2 = AUDIO_TBL_SIZE;
            }
            Resource.audioFmtTbl.last = n2;
            for (n = 0; n < n2; ++n) {
                object4 = Resource.get(AUDIO_INPUT_KEY + n);
                object3 = Resource.get(AUDIO_FORMAT_KEY + n);
                object2 = Resource.get(AUDIO_HIT_KEY + n);
                if (!(object4 instanceof Format && object3 instanceof Format[] && object2 instanceof Integer)) {
                    System.err.println("Resource file is corrupted");
                    Resource.audioFmtTbl.last = 0;
                    break;
                }
                Resource.audioFmtTbl.keys[n] = (Format)object4;
                Resource.audioFmtTbl.table[n] = (Format[])object3;
                Resource.audioFmtTbl.hits[n] = (Integer)object2;
            }
            if ((n2 = (object4 = Resource.get(VIDEO_SIZE_KEY)) instanceof Integer ? (Integer)object4 : 0) > VIDEO_TBL_SIZE) {
                System.err.println("Resource file is corrupted");
                n2 = VIDEO_TBL_SIZE;
            }
            Resource.videoFmtTbl.last = n2;
            for (n = 0; n < n2; ++n) {
                object4 = Resource.get(VIDEO_INPUT_KEY + n);
                object3 = Resource.get(VIDEO_FORMAT_KEY + n);
                object2 = Resource.get(VIDEO_HIT_KEY + n);
                if (!(object4 instanceof Format && object3 instanceof Format[] && object2 instanceof Integer)) {
                    System.err.println("Resource file is corrupted");
                    Resource.videoFmtTbl.last = 0;
                    break;
                }
                Resource.videoFmtTbl.keys[n] = (Format)object4;
                Resource.videoFmtTbl.table[n] = (Format[])object3;
                Resource.videoFmtTbl.hits[n] = (Integer)object2;
            }
            if ((n2 = (object4 = Resource.get(MISC_SIZE_KEY)) instanceof Integer ? (Integer)object4 : 0) > MISC_TBL_SIZE) {
                System.err.println("Resource file is corrupted");
                n2 = MISC_TBL_SIZE;
            }
            Resource.miscFmtTbl.last = n2;
            for (n = 0; n < n2; ++n) {
                object4 = Resource.get(MISC_INPUT_KEY + n);
                object3 = Resource.get(MISC_FORMAT_KEY + n);
                object2 = Resource.get(MISC_HIT_KEY + n);
                if (!(object4 instanceof Format && object3 instanceof Format[] && object2 instanceof Integer)) {
                    System.err.println("Resource file is corrupted");
                    Resource.miscFmtTbl.last = 0;
                    break;
                }
                Resource.miscFmtTbl.keys[n] = (Format)object4;
                Resource.miscFmtTbl.table[n] = (Format[])object3;
                Resource.miscFmtTbl.hits[n] = (Integer)object2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveDB() {
        Object object = fmtTblSync;
        synchronized (object) {
            int n;
            if (!needSaving) {
                return;
            }
            Resource.reset();
            Resource.set(AUDIO_SIZE_KEY, new Integer(Resource.audioFmtTbl.last));
            for (n = 0; n < Resource.audioFmtTbl.last; ++n) {
                Resource.set(AUDIO_INPUT_KEY + n, Resource.audioFmtTbl.keys[n]);
                Resource.set(AUDIO_FORMAT_KEY + n, Resource.audioFmtTbl.table[n]);
                Resource.set(AUDIO_HIT_KEY + n, new Integer(Resource.audioFmtTbl.hits[n]));
            }
            Resource.set(VIDEO_SIZE_KEY, new Integer(Resource.videoFmtTbl.last));
            for (n = 0; n < Resource.videoFmtTbl.last; ++n) {
                Resource.set(VIDEO_INPUT_KEY + n, Resource.videoFmtTbl.keys[n]);
                Resource.set(VIDEO_FORMAT_KEY + n, Resource.videoFmtTbl.table[n]);
                Resource.set(VIDEO_HIT_KEY + n, new Integer(Resource.videoFmtTbl.hits[n]));
            }
            Resource.set(MISC_SIZE_KEY, new Integer(Resource.miscFmtTbl.last));
            for (n = 0; n < Resource.miscFmtTbl.last; ++n) {
                Resource.set(MISC_INPUT_KEY + n, Resource.miscFmtTbl.keys[n]);
                Resource.set(MISC_FORMAT_KEY + n, Resource.miscFmtTbl.table[n]);
                Resource.set(MISC_HIT_KEY + n, new Integer(Resource.miscFmtTbl.hits[n]));
            }
            try {
                Resource.commit();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            needSaving = false;
        }
    }

    static {
        Object object;
        hash = null;
        filename = null;
        securityPrivelege = false;
        jmfSecurity = null;
        m = new Method[1];
        cl = new Class[1];
        args = new Object[1][0];
        userhome = null;
        hash = new Hashtable();
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (jmfSecurity != null) {
            object = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    object = "read property";
                    jmfSecurity.requestPermission(m, cl, args, 1);
                    m[0].invoke((Object)cl[0], args[0]);
                    object = "read file";
                    jmfSecurity.requestPermission(m, cl, args, 2);
                    m[0].invoke((Object)cl[0], args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.checkPermission((PermissionID)PermissionID.FILEIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
                }
            }
            catch (Throwable throwable) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                object = jdk12PropertyAction.cons;
                userhome = (String)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(USERHOME));
            }
            catch (Throwable throwable) {
                securityPrivelege = false;
            }
        } else {
            try {
                if (securityPrivelege) {
                    userhome = System.getProperty(USERHOME);
                }
            }
            catch (Exception exception) {
                userhome = null;
                securityPrivelege = false;
            }
        }
        if (userhome == null) {
            securityPrivelege = false;
        }
        object = null;
        if (securityPrivelege && (object = Resource.findResourceFile()) == null) {
            securityPrivelege = false;
        }
        if (!Resource.readResource((InputStream)object)) {
            hash = new Hashtable();
        }
        fmtTblSync = new Object();
        AUDIO_TBL_SIZE = 40;
        VIDEO_TBL_SIZE = 20;
        MISC_TBL_SIZE = 10;
        AUDIO_SIZE_KEY = "ATS";
        AUDIO_INPUT_KEY = "AI.";
        AUDIO_FORMAT_KEY = "AF.";
        AUDIO_HIT_KEY = "AH.";
        VIDEO_SIZE_KEY = "VTS";
        VIDEO_INPUT_KEY = "VI.";
        VIDEO_FORMAT_KEY = "VF.";
        VIDEO_HIT_KEY = "VH.";
        MISC_SIZE_KEY = "MTS";
        MISC_INPUT_KEY = "MI.";
        MISC_FORMAT_KEY = "MF.";
        MISC_HIT_KEY = "MH.";
        needSaving = false;
    }
}

