/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

import com.sun.media.util.MediaThread;

public abstract class LoopThread
extends MediaThread {
    protected boolean paused = false;
    protected boolean started = false;
    protected boolean killed = false;
    private boolean waitingAtPaused = false;

    public LoopThread() {
        this.setName("Loop thread");
    }

    public synchronized void pause() {
        this.paused = true;
    }

    public synchronized void blockingPause() {
        if (this.waitingAtPaused || this.killed) {
            return;
        }
        this.paused = true;
        this.waitForCompleteStop();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public synchronized void waitForCompleteStop() {
        try {
            while (!this.killed && !this.waitingAtPaused && this.paused) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void waitForCompleteStop(int n) {
        try {
            if (!this.killed && !this.waitingAtPaused && this.paused) {
                this.wait(n);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void start() {
        if (!this.started) {
            super.start();
            this.started = true;
        }
        this.paused = false;
        this.notifyAll();
    }

    public synchronized void kill() {
        this.killed = true;
        this.notifyAll();
    }

    public synchronized boolean waitHereIfPaused() {
        if (this.killed) {
            return false;
        }
        this.waitingAtPaused = true;
        if (this.paused) {
            this.notifyAll();
        }
        try {
            while (!this.killed && this.paused) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Timer: timeLoop() wait interrupted " + interruptedException);
        }
        this.waitingAtPaused = false;
        return !this.killed;
    }

    protected abstract boolean process();

    public void run() {
        while (this.waitHereIfPaused() && this.process()) {
        }
    }
}

