/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

public class ByteBuffer {
    public byte[] buffer;
    public int offset;
    public int length;
    public int size;

    public ByteBuffer(int n) {
        this.size = n;
        this.buffer = new byte[n];
    }

    public final void clear() {
        this.offset = 0;
        this.length = 0;
    }

    public final void writeBytes(String string) {
        byte[] byArray = string.getBytes();
        this.writeBytes(byArray);
    }

    public final void writeBytes(byte[] byArray) {
        System.arraycopy(byArray, 0, this.buffer, this.offset, byArray.length);
        this.offset += byArray.length;
        this.length += byArray.length;
    }

    public final void writeInt(int n) {
        this.buffer[this.offset + 0] = (byte)(n >> 24 & 0xFF);
        this.buffer[this.offset + 1] = (byte)(n >> 16 & 0xFF);
        this.buffer[this.offset + 2] = (byte)(n >> 8 & 0xFF);
        this.buffer[this.offset + 3] = (byte)(n >> 0 & 0xFF);
        this.offset += 4;
        this.length += 4;
    }

    public final void writeIntLittleEndian(int n) {
        this.buffer[this.offset + 3] = (byte)(n >>> 24 & 0xFF);
        this.buffer[this.offset + 2] = (byte)(n >>> 16 & 0xFF);
        this.buffer[this.offset + 1] = (byte)(n >>> 8 & 0xFF);
        this.buffer[this.offset + 0] = (byte)(n >>> 0 & 0xFF);
        this.offset += 4;
        this.length += 4;
    }

    public final void writeShort(short s) {
        this.buffer[this.offset + 0] = (byte)(s >> 8 & 0xFF);
        this.buffer[this.offset + 1] = (byte)(s >> 0 & 0xFF);
        this.offset += 2;
        this.length += 2;
    }

    public final void writeShortLittleEndian(short s) {
        this.buffer[this.offset + 1] = (byte)(s >> 8 & 0xFF);
        this.buffer[this.offset + 0] = (byte)(s >> 0 & 0xFF);
        this.offset += 2;
        this.length += 2;
    }

    public final void writeByte(byte by) {
        this.buffer[this.offset] = by;
        ++this.offset;
        ++this.length;
    }
}

