/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;

public class ToolTip
extends Window {
    private static final int MARGIN_HORZ = 4;
    private static final int MARGIN_VERT = 2;
    private String[] arrStrings = null;

    public ToolTip(String string) {
        super(new Frame());
        this.arrStrings = new String[1];
        this.arrStrings[0] = new String(string);
        Font font = new Font("Helvetica", 0, 10);
        this.setFont(font);
        this.resizePopup();
    }

    public ToolTip(String[] stringArray) {
        super(new Frame());
        stringArray = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = new String(stringArray[i]);
        }
        Font font = new Font("Helvetica", 0, 10);
        this.setFont(font);
        this.resizePopup();
    }

    public void setText(String string) {
        this.arrStrings = new String[1];
        this.arrStrings[0] = new String(string);
        this.resizePopup();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        graphics.setColor(new Color(255, 255, 192));
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        int n = 4;
        int n2 = 2 + fontMetrics.getAscent();
        int n3 = fontMetrics.getHeight();
        for (int i = 0; i < this.arrStrings.length; ++i) {
            graphics.drawString(this.arrStrings[i], n, n2);
            n2 += n3;
        }
    }

    private void resizePopup() {
        int n = 0;
        int n2 = 0;
        Rectangle rectangle = this.getBounds();
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        for (int i = 0; i < this.arrStrings.length; ++i) {
            int n3 = fontMetrics.stringWidth(this.arrStrings[i]);
            n = Math.max(n, n3);
        }
        n2 = fontMetrics.getHeight() * this.arrStrings.length;
        rectangle.width = n + 8;
        rectangle.height = n2 + 4;
        Dimension dimension = this.getSize();
        if (dimension.height != rectangle.height || rectangle.width > dimension.width || rectangle.width < dimension.width / 2) {
            this.setBounds(rectangle);
        }
    }
}

