/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.TabField;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class TabControl
extends Panel
implements MouseListener,
FocusListener,
KeyListener,
ComponentListener {
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_LEFT = 1;
    private Panel panelPageContainer;
    private CardLayout layoutCard = new CardLayout();
    private int nCurrentPage = -1;
    private Button buttonFocus;
    private boolean boolFocus = false;
    private int nAlignment = 0;
    private int MARGIN_PAGE_VERT = 6;
    private int MARGIN_PAGE_HORZ = 6;
    private String strPageToShowAfterPaint = null;
    private Cursor cursorNormal = new Cursor(0);
    private Cursor cursorWait = new Cursor(3);
    private Vector vectorTabs = new Vector();
    private int nTabHeightMax = 1;
    private int nTabWidthMax = 1;
    private int nRowCount = 1;

    public TabControl() {
        this(0);
    }

    public TabControl(int n) {
        this.nAlignment = n;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout());
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.buttonFocus = new Button("Focus");
        this.add(this.buttonFocus);
        this.buttonFocus.addKeyListener(this);
        this.buttonFocus.addFocusListener(this);
        this.panelPageContainer = new Panel(this.layoutCard);
        this.add((Component)this.panelPageContainer, "Center");
        Font font = this.panelPageContainer.getFont();
        if (font == null) {
            font = new Font("Dialog", 0, 12);
        }
        Font font2 = new Font("Dialog", 0, 12);
        this.setFont(font2);
        this.panelPageContainer.setFont(font);
        this.setBackground(TabField.COLOR_BG);
        this.panelPageContainer.setBackground(TabField.COLOR_BG);
    }

    public int addPage(Panel panel, String string) {
        int n = this.addPage(panel, string, null);
        return n;
    }

    public int addPage(Panel panel, String string, Image image) {
        int n = this.vectorTabs.size();
        TabField tabField = new TabField(this, panel, string, image);
        this.vectorTabs.addElement(tabField);
        this.panelPageContainer.add((Component)panel, string);
        if (n == 0) {
            this.nCurrentPage = 0;
            this.layoutCard.show(this.panelPageContainer, string);
        }
        tabField.calculateTabDimension(this.getFontMetrics(this.getFont()));
        this.nTabHeightMax = Math.max(tabField.dim.height, this.nTabHeightMax);
        this.nTabWidthMax = Math.max(tabField.dim.width, this.nTabWidthMax);
        this.recalculateTabs();
        this.repaint();
        return n;
    }

    public int setPageImage(Panel panel, Image image) {
        int n = this.findPage(panel);
        if (n < 0 || n >= this.vectorTabs.size()) {
            return n;
        }
        TabField tabField = (TabField)this.vectorTabs.elementAt(n);
        if (tabField.image == image) {
            return n;
        }
        tabField.image = image;
        this.nTabHeightMax = 1;
        this.nTabWidthMax = 1;
        int n2 = this.vectorTabs.size();
        for (int i = 0; i < n2; ++i) {
            tabField = (TabField)this.vectorTabs.elementAt(i);
            tabField.calculateTabDimension(this.getFontMetrics(this.getFont()));
            this.nTabHeightMax = Math.max(tabField.dim.height, this.nTabHeightMax);
            this.nTabWidthMax = Math.max(tabField.dim.width, this.nTabWidthMax);
        }
        this.recalculateTabs();
        this.repaint();
        return n;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.nAlignment == 1) {
            dimension.height = Math.max(dimension.height, this.nTabHeightMax * this.vectorTabs.size() + 1);
        } else {
            int n = 0;
            for (int i = 0; i < this.vectorTabs.size(); ++i) {
                TabField tabField = (TabField)this.vectorTabs.elementAt(i);
                n += tabField.dim.width;
            }
            dimension.width = Math.max(dimension.width, n + 1);
        }
        return dimension;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        insets = this.nAlignment == 1 ? new Insets(insets.top + this.MARGIN_PAGE_VERT, insets.left + this.nRowCount * this.nTabWidthMax - 2 + this.MARGIN_PAGE_HORZ, insets.bottom + this.MARGIN_PAGE_VERT, insets.right + this.MARGIN_PAGE_HORZ) : new Insets(insets.top + this.nRowCount * this.nTabHeightMax - 2 + this.MARGIN_PAGE_VERT, insets.left + this.MARGIN_PAGE_HORZ, insets.bottom + this.MARGIN_PAGE_VERT, insets.right + this.MARGIN_PAGE_HORZ);
        return insets;
    }

    public void update(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        if (rectangle.width < 1 || rectangle.height < 1) {
            return;
        }
        Image image = this.createImage(rectangle.width, rectangle.height);
        Graphics graphics2 = image != null ? image.getGraphics() : graphics;
        this.paint(graphics2);
        if (image != null) {
            graphics.drawImage(image, 0, 0, this);
        }
    }

    public void paint(Graphics graphics) {
        Font font;
        super.paint(graphics);
        Rectangle rectangle = this.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (this.nAlignment == 1) {
            rectangle2.x += this.nTabWidthMax * this.nRowCount - 2;
            rectangle2.width -= this.nTabWidthMax * this.nRowCount - 2;
        } else {
            rectangle2.y += this.nTabHeightMax * this.nRowCount - 2;
            rectangle2.height -= this.nTabHeightMax * this.nRowCount - 2;
        }
        --rectangle2.width;
        --rectangle2.height;
        graphics.setColor(TabField.COLOR_SHADOW_BOTTOM);
        graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        graphics.setColor(TabField.COLOR_SHADOW_TOP);
        graphics.drawLine(rectangle2.x + 1, rectangle2.y + 1, rectangle2.x + 1, rectangle2.y + rectangle2.height - 2);
        graphics.drawLine(rectangle2.x + 1, rectangle2.y + 1, rectangle2.x + rectangle2.width - 2, rectangle2.y + 1);
        Font font2 = font = this.getFont();
        int n = this.vectorTabs.size();
        for (int i = n - 1; i >= 0; --i) {
            int n2;
            int n3;
            int n4;
            FontMetrics fontMetrics;
            int n5;
            TabField tabField = (TabField)this.vectorTabs.elementAt(i);
            if (i == this.nCurrentPage) {
                if (this.nAlignment == 1) {
                    tabField.drawCurrentTabLeft(graphics);
                } else {
                    tabField.drawCurrentTabTop(graphics);
                }
            } else if (this.nAlignment == 1) {
                tabField.drawTabLeft(graphics);
            } else {
                tabField.drawTabTop(graphics);
            }
            graphics.setColor(this.getForeground());
            Rectangle rectangle3 = new Rectangle(tabField.rect);
            if (this.nAlignment == 1) {
                rectangle3.width = this.nTabWidthMax;
            } else {
                rectangle3.height = this.nTabHeightMax;
            }
            if (tabField.image != null) {
                n5 = tabField.image.getWidth(this);
                rectangle3.x += n5 + tabField.MARGIN_TAB_HORZ;
                rectangle3.width -= n5 + tabField.MARGIN_TAB_HORZ;
            }
            ++rectangle3.y;
            if (i == this.nCurrentPage) {
                graphics.setFont(font2);
                fontMetrics = graphics.getFontMetrics(font2);
                if (this.boolFocus) {
                    n5 = fontMetrics.stringWidth(tabField.strTitle) + 6;
                    n4 = fontMetrics.getHeight() + 1;
                    n3 = rectangle3.x + (rectangle3.width - n5) / 2;
                    n2 = rectangle3.y + (this.nTabHeightMax - 2 - n4) / 2 + 1;
                    this.drawDottedRectangle(graphics, n3, n2, n5, n4);
                }
            } else {
                graphics.setFont(font);
                fontMetrics = graphics.getFontMetrics(font);
            }
            n3 = rectangle3.x + (rectangle3.width - fontMetrics.stringWidth(tabField.strTitle)) / 2;
            n2 = rectangle3.y + rectangle3.height - (rectangle3.height - fontMetrics.getHeight()) / 2 - fontMetrics.getMaxDescent();
            --n2;
            if (i != this.nCurrentPage) {
                ++n3;
                ++n2;
            }
            graphics.drawString(tabField.strTitle, n3, n2);
            if (tabField.image == null) continue;
            n4 = tabField.image.getHeight(this);
            n3 = tabField.rect.x + tabField.MARGIN_TAB_HORZ;
            n2 = tabField.rect.y + (this.nTabHeightMax - n4) / 2;
            if (i != this.nCurrentPage) {
                ++n3;
                ++n2;
            }
            graphics.drawImage(tabField.image, n3, n2, this);
        }
        if (this.strPageToShowAfterPaint != null) {
            this.layoutCard.show(this.panelPageContainer, this.strPageToShowAfterPaint);
            this.strPageToShowAfterPaint = null;
            this.setCursor(this.cursorNormal);
        }
    }

    private void drawDottedRectangle(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawDottedLine(graphics, n, n2, n + n3 - 1, n2);
        this.drawDottedLine(graphics, n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        this.drawDottedLine(graphics, n + n3 - 1, n2 + n4 - 1, n, n2 + n4 - 1);
        this.drawDottedLine(graphics, n, n2 + n4 - 1, n, n2);
    }

    private void drawDottedLine(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n == n3 && n2 == n4) {
            this.drawDot(graphics, n, n2);
            return;
        }
        if (n > n3) {
            n6 = n;
            n = n3;
            n3 = n6;
        }
        if (n2 > n4) {
            n5 = n2;
            n2 = n4;
            n4 = n5;
        }
        if (n3 - n > n4 - n2) {
            double d = (double)(n4 - n2) / (double)(n3 - n);
            for (n6 = n; n6 <= n3; ++n6) {
                n5 = (int)Math.rint((double)n2 + (double)(n6 - n) * d);
                this.drawDot(graphics, n6, n5);
            }
        } else {
            double d = (n3 - n) / (n4 - n2);
            for (n5 = n2; n5 <= n4; ++n5) {
                n6 = (int)Math.rint((double)n + (double)(n5 - n2) * d);
                this.drawDot(graphics, n6, n5);
            }
        }
    }

    private void drawDot(Graphics graphics, int n, int n2) {
        if ((n + n2) % 2 == 0) {
            graphics.drawLine(n, n2, n, n2);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.vectorTabs.size();
        for (int i = 0; i < n3; ++i) {
            TabField tabField = (TabField)this.vectorTabs.elementAt(i);
            if (!tabField.rect.contains(n, n2)) continue;
            this.buttonFocus.requestFocus();
            this.nCurrentPage = i;
            this.strPageToShowAfterPaint = tabField.strTitle;
            this.setCursor(this.cursorWait);
            this.repaint();
            break;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = this.nCurrentPage;
        int n2 = keyEvent.getKeyCode();
        if (n2 == 40 || n2 == 39) {
            ++n;
        } else if (n2 == 38 || n2 == 37) {
            --n;
        }
        if (n >= this.vectorTabs.size()) {
            n = this.vectorTabs.size() - 1;
        }
        if (n < 0) {
            n = 0;
        }
        if (this.nCurrentPage != n) {
            this.nCurrentPage = n;
            TabField tabField = (TabField)this.vectorTabs.elementAt(n);
            this.strPageToShowAfterPaint = tabField.strTitle;
            this.setCursor(this.cursorWait);
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.boolFocus) {
            return;
        }
        this.boolFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.boolFocus) {
            return;
        }
        this.boolFocus = false;
        this.repaint();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.recalculateTabs();
        this.doLayout();
        this.panelPageContainer.validate();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    private void recalculateTabs() {
        int n = 1;
        Rectangle rectangle = this.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        if (rectangle.width < 1 || rectangle.height < 1) {
            return;
        }
        int n2 = this.vectorTabs.size();
        if (this.nAlignment == 1) {
            n = rectangle.height / this.nTabHeightMax;
            this.nRowCount = (n2 + n - 1) / n;
            int n3 = this.nRowCount * this.nTabWidthMax;
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                if (i % n == 0) {
                    n3 -= this.nTabWidthMax;
                    n4 = 0;
                }
                TabField tabField = (TabField)this.vectorTabs.elementAt(i);
                tabField.rect.x = n3;
                tabField.rect.y = n4;
                tabField.rect.width = this.nTabWidthMax * (i / n + 1);
                tabField.rect.height = this.nTabHeightMax;
                tabField.nRowIndex = i / n;
                if (tabField.nRowIndex > 0) {
                    tabField.rect.width -= 2;
                }
                n4 += this.nTabHeightMax;
            }
        } else {
            TabField tabField;
            int n5;
            this.nRowCount = 1;
            int n6 = 0;
            for (n5 = 0; n5 < n2; ++n5) {
                tabField = (TabField)this.vectorTabs.elementAt(n5);
                if (n6 + tabField.dim.width > rectangle.width) {
                    n6 = 0;
                    ++this.nRowCount;
                }
                n6 += tabField.dim.width;
            }
            int n7 = 0;
            int n8 = this.nRowCount * this.nTabHeightMax;
            int n9 = 0;
            int n10 = 0;
            for (n5 = 0; n5 < n2; ++n5) {
                if (n5 == n10) {
                    n7 = 0;
                    n8 -= this.nTabHeightMax;
                    n6 = 0;
                    for (n10 = n5; n10 < n2; ++n10) {
                        tabField = (TabField)this.vectorTabs.elementAt(n10);
                        if (n10 > n5 && n6 + tabField.dim.width > rectangle.width) break;
                        n6 += tabField.dim.width;
                        tabField.nRowIndex = n9;
                    }
                    n = n10 - n5;
                    ++n9;
                }
                tabField = (TabField)this.vectorTabs.elementAt(n5);
                tabField.rect.x = n7;
                tabField.rect.y = n8;
                tabField.rect.width = tabField.dim.width;
                if (this.nRowCount > 1 && n9 < this.nRowCount) {
                    tabField.rect.width += (rectangle.width - n6 - 1) / n;
                    tabField.rect.width = tabField.rect.width + (n10 - n5 > (rectangle.width - n6 - 1) % n ? 0 : 1);
                }
                tabField.rect.height = this.nTabHeightMax * n9;
                if (tabField.nRowIndex > 0) {
                    tabField.rect.height -= 2;
                }
                n7 += tabField.rect.width;
            }
        }
        this.repaint();
    }

    private int findPage(Panel panel) {
        int n;
        for (n = this.vectorTabs.size() - 1; n >= 0; --n) {
            TabField tabField = (TabField)this.vectorTabs.elementAt(n);
            if (tabField.panelPage == panel) break;
        }
        return n;
    }
}

