/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.BasicComp;
import com.sun.media.ui.Scroll;
import java.awt.BorderLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SliderComp
extends BasicComp
implements ActionListener {
    float value;
    float minValue;
    float maxValue;
    float initialValue;
    Scroll scroll;
    TextField tfIndicator;
    private static final int MIN = 0;
    private static final int MAX = 1000;
    private static final int PAGESIZE = 100;

    public SliderComp(String string, float f, float f2, float f3) {
        super(string);
        this.minValue = f;
        this.maxValue = f2;
        this.initialValue = f3;
        this.value = f3;
        this.setLayout(new BorderLayout());
        Label label = new Label(string, 0);
        this.add("West", label);
        this.scroll = new Scroll();
        this.add("Center", this.scroll);
        this.scroll.setActionListener(this);
        this.scroll.setValue(this.toRatio(this.value));
    }

    public void setValue(int n) {
        this.value = n;
        this.scroll.setValue(this.toRatio(n));
    }

    public void setValue(float f) {
        this.value = f;
        this.scroll.setValue(this.toRatio(f));
    }

    public int getIntValue() {
        return (int)this.value;
    }

    public float getFloatValue() {
        return this.value;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        float f = this.scroll.getValue();
        this.value = this.fromRatio(f);
        this.informListener();
    }

    private float toRatio(float f) {
        float f2 = this.maxValue - this.minValue;
        return (f - this.minValue) / f2;
    }

    private float fromRatio(float f) {
        return f * (this.maxValue - this.minValue) + this.minValue;
    }
}

